/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.javascript.jscomp.NewTypeInference;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.jscomp.newtypes.Declaration;
import com.google.javascript.jscomp.newtypes.DeclaredFunctionType;
import com.google.javascript.jscomp.newtypes.DeclaredTypeRegistry;
import com.google.javascript.jscomp.newtypes.EnumType;
import com.google.javascript.jscomp.newtypes.JSType;
import com.google.javascript.jscomp.newtypes.JSTypeCreatorFromJSDoc;
import com.google.javascript.jscomp.newtypes.JSTypes;
import com.google.javascript.jscomp.newtypes.Namespace;
import com.google.javascript.jscomp.newtypes.NamespaceLit;
import com.google.javascript.jscomp.newtypes.QualifiedName;
import com.google.javascript.jscomp.newtypes.RawNominalType;
import com.google.javascript.jscomp.newtypes.Typedef;
import com.google.javascript.rhino.JSDocInfo;
import com.google.javascript.rhino.Node;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

final class NTIScope
implements DeclaredTypeRegistry {
    private final NTIScope parent;
    private final Node root;
    private final String name;
    private final JSTypes commonTypes;
    private boolean isFinalized = false;
    private final Map<String, JSType> locals = new LinkedHashMap<String, JSType>();
    private final Map<String, JSType> externs;
    private final Set<String> constVars = new LinkedHashSet<String>();
    private final List<String> formals;
    private final Set<String> outerVars = new LinkedHashSet<String>();
    private final Map<String, NTIScope> localFunDefs = new LinkedHashMap<String, NTIScope>();
    private Set<String> unknownTypeNames = new LinkedHashSet<String>();
    private Map<String, RawNominalType> localClassDefs = new LinkedHashMap<String, RawNominalType>();
    private Map<String, Typedef> localTypedefs = new LinkedHashMap<String, Typedef>();
    private Map<String, EnumType> localEnums = new LinkedHashMap<String, EnumType>();
    private Map<String, NamespaceLit> localNamespaces = new LinkedHashMap<String, NamespaceLit>();
    private Set<EnumType> qualifiedEnums = new LinkedHashSet<EnumType>();
    private DeclaredFunctionType declaredType;

    NTIScope(Node root, NTIScope parent, List<String> formals, JSTypes commonTypes) {
        if (parent == null) {
            this.name = null;
            this.externs = new LinkedHashMap<String, JSType>();
        } else {
            String nameOnAst = root.getFirstChild().getString();
            this.name = nameOnAst.isEmpty() ? null : nameOnAst;
            this.externs = ImmutableMap.of();
        }
        this.root = root;
        this.parent = parent;
        this.formals = formals;
        this.commonTypes = commonTypes;
    }

    Node getRoot() {
        return this.root;
    }

    NTIScope getParent() {
        return this.parent;
    }

    Node getBody() {
        Preconditions.checkArgument((boolean)this.root.isFunction());
        return NodeUtil.getFunctionBody(this.root);
    }

    String getReadableName() {
        return this.isTopLevel() ? null : NodeUtil.getFunctionName(this.root);
    }

    String getName() {
        return this.name;
    }

    void setDeclaredType(DeclaredFunctionType declaredType) {
        this.declaredType = declaredType;
        if (this.root.isFromExterns()) {
            this.root.setTypeI(this.getCommonTypes().fromFunctionType(declaredType.toFunctionType()));
        }
    }

    @Override
    public DeclaredFunctionType getDeclaredFunctionType() {
        return this.declaredType;
    }

    boolean isFunction() {
        return this.root.isFunction();
    }

    boolean isTopLevel() {
        return this.parent == null;
    }

    boolean isConstructor() {
        if (!this.root.isFunction()) {
            return false;
        }
        JSDocInfo fnDoc = NodeUtil.getBestJSDocInfo(this.root);
        return fnDoc != null && fnDoc.isConstructor();
    }

    boolean isPrototypeMethod() {
        Preconditions.checkArgument((this.root != null ? 1 : 0) != 0);
        return NodeUtil.isPrototypeMethod(this.root);
    }

    void addUnknownTypeNames(List<String> names) {
        Preconditions.checkState((boolean)this.isTopLevel());
        this.unknownTypeNames.addAll(names);
    }

    Set<String> getUnknownTypeNames() {
        Preconditions.checkState((boolean)this.isTopLevel());
        return this.unknownTypeNames;
    }

    void addLocalFunDef(String name, NTIScope scope) {
        Preconditions.checkArgument((!name.isEmpty() ? 1 : 0) != 0);
        Preconditions.checkArgument((!name.contains(".") ? 1 : 0) != 0);
        Preconditions.checkArgument((!this.isDefinedLocally(name, false) ? 1 : 0) != 0);
        this.localFunDefs.put(name, scope);
    }

    boolean isFormalParam(String name) {
        return this.formals.contains(name);
    }

    boolean isLocalFunDef(String name) {
        return this.localFunDefs.containsKey(name);
    }

    boolean isFunctionNamespace(String name) {
        Preconditions.checkArgument((!name.contains(".") ? 1 : 0) != 0);
        Preconditions.checkState((boolean)this.isFinalized);
        Declaration d = this.getDeclaration(name, false);
        if (d == null || d.getFunctionScope() == null || d.getTypeOfSimpleDecl() == null) {
            return false;
        }
        return d.getTypeOfSimpleDecl().getObjTypeIfSingletonObj() != null;
    }

    boolean isDefinedLocally(String name, boolean includeTypes) {
        Preconditions.checkNotNull((Object)name);
        Preconditions.checkState((!name.contains(".") ? 1 : 0) != 0);
        if (this.locals.containsKey(name) || this.formals.contains(name) || this.localFunDefs.containsKey(name) || "this".equals(name) || this.externs.containsKey(name) || this.localNamespaces.containsKey(name) || this.localTypedefs.containsKey(name) || this.localEnums.containsKey(name)) {
            return true;
        }
        if (includeTypes) {
            return this.unknownTypeNames.contains(name) || this.declaredType != null && this.declaredType.isTypeVariableDefinedLocally(name);
        }
        return false;
    }

    boolean isDefined(Node qnameNode) {
        Preconditions.checkArgument((boolean)qnameNode.isQualifiedName());
        if (qnameNode.isName()) {
            return this.isDefinedLocally(qnameNode.getString(), false);
        }
        if (qnameNode.isThis()) {
            return true;
        }
        QualifiedName qname = QualifiedName.fromNode(qnameNode);
        String leftmost = qname.getLeftmostName();
        if (this.isNamespace(leftmost)) {
            return this.getNamespace(leftmost).isDefined(qname.getAllButLeftmost());
        }
        return this.parent == null ? false : this.parent.isDefined(qnameNode);
    }

    boolean isNamespace(Node expr) {
        if (expr.isName()) {
            return this.isNamespace(expr.getString());
        }
        if (!expr.isGetProp()) {
            return false;
        }
        return this.isNamespace(QualifiedName.fromNode(expr));
    }

    boolean isNamespace(QualifiedName qname) {
        if (qname == null) {
            return false;
        }
        String leftmost = qname.getLeftmostName();
        return this.isNamespace(leftmost) && (qname.isIdentifier() || this.getNamespace(leftmost).hasSubnamespace(qname.getAllButLeftmost()));
    }

    boolean isNamespace(String name) {
        Preconditions.checkArgument((!name.contains(".") ? 1 : 0) != 0);
        Declaration decl = this.getDeclaration(name, false);
        return decl != null && decl.getNamespace() != null;
    }

    boolean isVisibleInScope(String name) {
        Preconditions.checkArgument((!name.contains(".") ? 1 : 0) != 0);
        return this.isDefinedLocally(name, false) || name.equals(this.name) || this.parent != null && this.parent.isVisibleInScope(name);
    }

    boolean isConstVar(String name) {
        Preconditions.checkArgument((!name.contains(".") ? 1 : 0) != 0);
        Declaration decl = this.getDeclaration(name, false);
        return decl != null && decl.isConstant();
    }

    boolean isOuterVarEarly(String name) {
        Preconditions.checkArgument((!name.contains(".") ? 1 : 0) != 0);
        return !this.isDefinedLocally(name, false) && this.parent != null && this.parent.isVisibleInScope(name);
    }

    boolean isUndeclaredFormal(String name) {
        Preconditions.checkArgument((!name.contains(".") ? 1 : 0) != 0);
        return this.formals.contains(name) && this.getDeclaredTypeOf(name) == null;
    }

    List<String> getFormals() {
        return new ArrayList<String>(this.formals);
    }

    Set<String> getOuterVars() {
        return new LinkedHashSet<String>(this.outerVars);
    }

    Set<String> getLocalFunDefs() {
        return ImmutableSet.copyOf(this.localFunDefs.keySet());
    }

    boolean isOuterVar(String name) {
        return this.outerVars.contains(name);
    }

    boolean hasThis() {
        return this.isFunction() && this.getDeclaredFunctionType().getThisType() != null;
    }

    RawNominalType getNominalType(QualifiedName qname) {
        Declaration decl = this.getDeclaration(qname, false);
        return decl == null ? null : decl.getNominal();
    }

    @Override
    public JSTypes getCommonTypes() {
        if (this.isTopLevel()) {
            return this.commonTypes;
        }
        return this.parent.getCommonTypes();
    }

    @Override
    public JSType getDeclaredTypeOf(String name) {
        Preconditions.checkArgument((!name.contains(".") ? 1 : 0) != 0);
        if ("this".equals(name)) {
            if (!this.hasThis()) {
                return null;
            }
            return this.getDeclaredFunctionType().getThisType().getInstanceAsJSType();
        }
        Declaration decl = this.getLocalDeclaration(name, false);
        if (decl != null) {
            if (decl.getTypeOfSimpleDecl() != null) {
                Preconditions.checkState((!decl.getTypeOfSimpleDecl().isBottom() ? 1 : 0) != 0, (String)"%s was bottom", (Object[])new Object[]{name});
                return decl.getTypeOfSimpleDecl();
            }
            NTIScope funScope = (NTIScope)decl.getFunctionScope();
            if (funScope != null) {
                return this.getCommonTypes().fromFunctionType(funScope.getDeclaredFunctionType().toFunctionType());
            }
            Preconditions.checkState((decl.getNamespace() == null ? 1 : 0) != 0);
            return null;
        }
        if (name.equals(this.name) && !this.parent.isFunctionNamespace(name)) {
            return this.getCommonTypes().fromFunctionType(this.getDeclaredFunctionType().toFunctionType());
        }
        if (this.parent != null) {
            return this.parent.getDeclaredTypeOf(name);
        }
        return null;
    }

    boolean hasUndeclaredFormalsOrOuters() {
        for (String formal : this.formals) {
            if (this.getDeclaredTypeOf(formal) != null) continue;
            return true;
        }
        for (String outer : this.outerVars) {
            JSType declType = this.getDeclaredTypeOf(outer);
            if (declType != null && (declType.getFunType() == null || !declType.getFunType().getReturnType().isUnknown())) continue;
            return true;
        }
        return false;
    }

    private NTIScope getScopeHelper(QualifiedName qname) {
        Declaration decl = this.getDeclaration(qname, false);
        return decl == null ? null : (NTIScope)decl.getFunctionScope();
    }

    boolean isKnownFunction(String fnName) {
        Preconditions.checkArgument((!fnName.contains(".") ? 1 : 0) != 0);
        return this.getScopeHelper(new QualifiedName(fnName)) != null;
    }

    boolean isKnownFunction(QualifiedName qname) {
        return this.getScopeHelper(qname) != null;
    }

    boolean isExternalFunction(String fnName) {
        NTIScope s = this.getScopeHelper(new QualifiedName(fnName));
        return s.root.isFromExterns();
    }

    NTIScope getScope(String fnName) {
        NTIScope s = this.getScopeHelper(new QualifiedName(fnName));
        Preconditions.checkState((s != null ? 1 : 0) != 0);
        return s;
    }

    Set<String> getLocals() {
        return ImmutableSet.copyOf(this.locals.keySet());
    }

    Set<String> getExterns() {
        return ImmutableSet.copyOf(this.externs.keySet());
    }

    void addSimpleType(Node qnameNode, JSType declType) {
        Preconditions.checkState((boolean)qnameNode.isName());
        String name = qnameNode.getString();
        if (qnameNode.isFromExterns()) {
            this.externs.put(name, declType);
        } else {
            this.locals.put(name, declType);
        }
    }

    void addLocal(String name, JSType declType, boolean isConstant, boolean isFromExterns) {
        Preconditions.checkArgument((!name.contains(".") ? 1 : 0) != 0);
        Preconditions.checkArgument((!this.isDefinedLocally(name, false) ? 1 : 0) != 0);
        if (isConstant) {
            this.constVars.add(name);
        }
        if (isFromExterns) {
            this.externs.put(name, declType);
        } else {
            this.locals.put(name, declType);
        }
    }

    void addNamespace(Node qnameNode, boolean isFromExterns) {
        Preconditions.checkArgument((!this.isNamespace(qnameNode) ? 1 : 0) != 0);
        if (qnameNode.isName()) {
            String varName = qnameNode.getString();
            this.localNamespaces.put(varName, new NamespaceLit(varName));
            if (isFromExterns) {
                this.externs.put(qnameNode.getString(), null);
            }
        } else {
            QualifiedName qname = QualifiedName.fromNode(qnameNode);
            Namespace ns = this.getNamespace(qname.getLeftmostName());
            ns.addSubnamespace(qname.getAllButLeftmost());
        }
    }

    void updateType(String name, JSType newDeclType) {
        if (this.isDefinedLocally(name, false)) {
            this.locals.put(name, newDeclType);
        } else if (this.parent != null) {
            this.parent.updateType(name, newDeclType);
        } else {
            throw new RuntimeException("Cannot update type of unknown variable: " + name);
        }
    }

    void addOuterVar(String name) {
        this.outerVars.add(name);
    }

    void addNominalType(Node qnameNode, RawNominalType rawNominalType) {
        if (qnameNode.isName()) {
            Preconditions.checkState((!this.localClassDefs.containsKey(qnameNode.getString()) ? 1 : 0) != 0);
            this.localClassDefs.put(qnameNode.getString(), rawNominalType);
        } else {
            Preconditions.checkArgument((!this.isDefined(qnameNode) ? 1 : 0) != 0);
            QualifiedName qname = QualifiedName.fromNode(qnameNode);
            Namespace ns = this.getNamespace(qname.getLeftmostName());
            ns.addNominalType(qname.getAllButLeftmost(), rawNominalType);
        }
    }

    void addTypedef(Node qnameNode, Typedef td) {
        if (qnameNode.isName()) {
            Preconditions.checkState((!this.localTypedefs.containsKey(qnameNode.getString()) ? 1 : 0) != 0);
            this.localTypedefs.put(qnameNode.getString(), td);
        } else {
            Preconditions.checkState((!this.isDefined(qnameNode) ? 1 : 0) != 0);
            QualifiedName qname = QualifiedName.fromNode(qnameNode);
            Namespace ns = this.getNamespace(qname.getLeftmostName());
            ns.addTypedef(qname.getAllButLeftmost(), td);
        }
    }

    Typedef getTypedef(String name) {
        Preconditions.checkState((!name.contains(".") ? 1 : 0) != 0);
        Declaration decl = this.getDeclaration(name, false);
        return decl == null ? null : decl.getTypedef();
    }

    void addEnum(Node qnameNode, EnumType e) {
        if (qnameNode.isName()) {
            Preconditions.checkState((!this.localEnums.containsKey(qnameNode.getString()) ? 1 : 0) != 0);
            this.localEnums.put(qnameNode.getString(), e);
        } else {
            Preconditions.checkState((!this.isDefined(qnameNode) ? 1 : 0) != 0);
            QualifiedName qname = QualifiedName.fromNode(qnameNode);
            Namespace ns = this.getNamespace(qname.getLeftmostName());
            ns.addEnum(qname.getAllButLeftmost(), e);
            this.qualifiedEnums.add(e);
        }
    }

    EnumType getEnum(QualifiedName qname) {
        Declaration decl = this.getDeclaration(qname, false);
        return decl == null ? null : decl.getEnum();
    }

    Namespace getNamespace(QualifiedName qname) {
        Namespace ns = this.getNamespace(qname.getLeftmostName());
        return qname.isIdentifier() ? ns : ns.getSubnamespace(qname.getAllButLeftmost());
    }

    private Declaration getLocalDeclaration(String name, boolean includeTypes) {
        Preconditions.checkArgument((!name.contains(".") ? 1 : 0) != 0);
        if (!this.isDefinedLocally(name, includeTypes)) {
            return null;
        }
        JSType type = null;
        boolean isForwardDeclaration = false;
        boolean isTypeVar = false;
        if (this.locals.containsKey(name)) {
            type = this.locals.get(name);
        } else if (this.formals.contains(name)) {
            JSType formalType;
            int formalIndex = this.formals.indexOf(name);
            if (this.declaredType != null && formalIndex != -1 && (formalType = this.declaredType.getFormalType(formalIndex)) != null && !formalType.isBottom()) {
                type = formalType;
            }
        } else if (this.localFunDefs.containsKey(name)) {
            if (this.isFinalized && this.externs.containsKey(name)) {
                type = this.externs.get(name);
            }
        } else if (!(this.localTypedefs.containsKey(name) || this.localNamespaces.containsKey(name) || this.localEnums.containsKey(name) || this.localClassDefs.containsKey(name))) {
            if (this.declaredType != null && this.declaredType.isTypeVariableDefinedLocally(name)) {
                isTypeVar = true;
                type = JSType.fromTypeVar(name);
            } else if (this.externs.containsKey(name)) {
                type = this.externs.get(name);
            } else if (this.unknownTypeNames.contains(name)) {
                isForwardDeclaration = true;
            }
        }
        return new Declaration(type, this.localTypedefs.get(name), this.localNamespaces.get(name), this.localEnums.get(name), this.localFunDefs.get(name), this.localClassDefs.get(name), isTypeVar, this.constVars.contains(name), isForwardDeclaration);
    }

    @Override
    public Declaration getDeclaration(QualifiedName qname, boolean includeTypes) {
        if (qname.isIdentifier()) {
            return this.getDeclaration(qname.getLeftmostName(), includeTypes);
        }
        Preconditions.checkState((!this.isFinalized ? 1 : 0) != 0, (Object)"Namespaces are removed from scopes after finalization");
        Namespace ns = this.getNamespace(qname.getLeftmostName());
        if (ns == null) {
            return null;
        }
        Declaration decl = ns.getDeclaration(qname.getAllButLeftmost());
        if (decl == null && this.unknownTypeNames.contains(qname.toString())) {
            return new Declaration(JSType.UNKNOWN, null, null, null, null, null, false, false, true);
        }
        return decl;
    }

    public Declaration getDeclaration(String name, boolean includeTypes) {
        Preconditions.checkArgument((!name.contains(".") ? 1 : 0) != 0);
        Declaration decl = this.getLocalDeclaration(name, includeTypes);
        if (decl != null) {
            return decl;
        }
        return this.parent == null ? null : this.parent.getDeclaration(name, includeTypes);
    }

    Namespace getNamespace(String name) {
        Preconditions.checkArgument((!name.contains(".") ? 1 : 0) != 0);
        Declaration decl = this.getDeclaration(name, false);
        return decl == null ? null : decl.getNamespace();
    }

    void resolveTypedefs(JSTypeCreatorFromJSDoc typeParser) {
        for (Typedef td : this.localTypedefs.values()) {
            if (td.isResolved()) continue;
            typeParser.resolveTypedef(td, this);
        }
    }

    void resolveEnums(JSTypeCreatorFromJSDoc typeParser) {
        for (EnumType e : this.localEnums.values()) {
            if (e.isResolved()) continue;
            typeParser.resolveEnum(e, this);
        }
        for (EnumType e : this.qualifiedEnums) {
            if (e.isResolved()) continue;
            typeParser.resolveEnum(e, this);
        }
        this.qualifiedEnums = null;
    }

    Node mayDeclareUnknownType(QualifiedName qname, NewTypeInference.WarningReporter warnings) {
        Namespace ns;
        if (qname.isIdentifier() || null == this.getNamespace(qname.getLeftmostName())) {
            String name = qname.getLeftmostName();
            if (!this.locals.containsKey(name)) {
                this.externs.put(name, JSType.UNKNOWN);
            }
            return null;
        }
        Namespace leftmost = this.getNamespace(qname.getLeftmostName());
        QualifiedName props = qname.getAllButLeftmost();
        while (!props.isIdentifier() && !leftmost.hasSubnamespace(props.getAllButRightmost())) {
            props = props.getAllButRightmost();
        }
        Namespace namespace = ns = props.isIdentifier() ? leftmost : leftmost.getSubnamespace(props.getAllButRightmost());
        if (ns.isNamespaceFinalized()) {
            Preconditions.checkNotNull((Object)ns.getConstDeclNode(), (String)"Namespace %s was finalized incorrectly", (Object[])new Object[]{ns.getName()});
            return ns.getConstDeclNode();
        }
        String pname = props.getRightmostName();
        ns.addUndeclaredProperty(pname, null, JSType.UNKNOWN, false);
        return null;
    }

    void removeTmpData() {
        this.unknownTypeNames = ImmutableSet.of();
        JSTypes commonTypes = this.getCommonTypes();
        for (Map.Entry<String, NamespaceLit> entry : this.localNamespaces.entrySet()) {
            String name = entry.getKey();
            NamespaceLit nslit = entry.getValue();
            nslit.finalizeNamespace(null);
            JSType t = nslit.toJSType(commonTypes);
            if (this.localFunDefs.containsKey(name)) {
                t = t.withFunction(this.localFunDefs.get(name).getDeclaredFunctionType().toFunctionType(), commonTypes.getFunctionType());
            }
            if (this.externs.containsKey(name)) {
                this.externs.put(name, t);
                continue;
            }
            this.locals.put(name, t);
        }
        for (Map.Entry<String, Namespace> entry : this.localEnums.entrySet()) {
            EnumType et = (EnumType)entry.getValue();
            et.finalizeNamespace(null);
            this.locals.put(entry.getKey(), et.toJSType(commonTypes));
        }
        for (String string : this.localTypedefs.keySet()) {
            this.locals.put(string, JSType.UNDEFINED);
        }
        this.localNamespaces = ImmutableMap.of();
        this.localClassDefs = ImmutableMap.of();
        this.localTypedefs = ImmutableMap.of();
        this.localEnums = ImmutableMap.of();
        this.isFinalized = true;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.isTopLevel()) {
            sb.append("<TOP SCOPE>");
        } else {
            sb.append(this.getReadableName());
            sb.append('(');
            Joiner.on((char)',').appendTo(sb, this.formals);
            sb.append(')');
        }
        sb.append(" with root: ");
        sb.append(this.root);
        return sb.toString();
    }
}

