/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.base.Preconditions;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.CheckLevel;
import com.google.javascript.jscomp.CompilerInput;
import com.google.javascript.jscomp.ControlFlowAnalysis;
import com.google.javascript.jscomp.ControlFlowGraph;
import com.google.javascript.jscomp.DiagnosticType;
import com.google.javascript.jscomp.Es6SyntacticScopeCreator;
import com.google.javascript.jscomp.JSError;
import com.google.javascript.jscomp.JSModule;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.jscomp.Scope;
import com.google.javascript.jscomp.ScopeCreator;
import com.google.javascript.jscomp.SyntacticScopeCreator;
import com.google.javascript.jscomp.TypedScope;
import com.google.javascript.rhino.InputId;
import com.google.javascript.rhino.Node;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Set;

public class NodeTraversal {
    private final AbstractCompiler compiler;
    private final Callback callback;
    private Node curNode;
    public static final DiagnosticType NODE_TRAVERSAL_ERROR = DiagnosticType.error("JSC_NODE_TRAVERSAL_ERROR", "{0}");
    private final Deque<Scope> scopes = new ArrayDeque<Scope>();
    private final Deque<Node> scopeRoots = new ArrayDeque<Node>();
    private final Deque<Node> cfgRoots = new ArrayDeque<Node>();
    Deque<ControlFlowGraph<Node>> cfgs = new LinkedList<ControlFlowGraph<Node>>();
    private String sourceName;
    private InputId inputId;
    private final ScopeCreator scopeCreator;
    private final boolean useBlockScope;
    private ScopedCallback scopeCallback;
    private static final String MISSING_SOURCE = "[source unknown]";

    public NodeTraversal(AbstractCompiler compiler, Callback cb) {
        this(compiler, cb, compiler.getLanguageMode().isEs6OrHigher() ? new Es6SyntacticScopeCreator(compiler) : SyntacticScopeCreator.makeUntyped(compiler));
    }

    public NodeTraversal(AbstractCompiler compiler, Callback cb, ScopeCreator scopeCreator) {
        this.callback = cb;
        if (cb instanceof ScopedCallback) {
            this.scopeCallback = (ScopedCallback)cb;
        }
        this.compiler = compiler;
        this.inputId = null;
        this.sourceName = "";
        this.scopeCreator = scopeCreator;
        this.useBlockScope = scopeCreator.hasBlockScope();
    }

    private void throwUnexpectedException(Exception unexpectedException) {
        String message = unexpectedException.getMessage();
        if (this.inputId != null) {
            message = unexpectedException.getMessage() + "\n" + this.formatNodeContext("Node", this.curNode) + (this.curNode == null ? "" : this.formatNodeContext("Parent", this.curNode.getParent()));
        }
        this.compiler.throwInternalError(message, unexpectedException);
    }

    private String formatNodeContext(String label, Node n) {
        if (n == null) {
            return "  " + label + ": NULL";
        }
        return "  " + label + "(" + n.toString(false, false, false) + "): " + this.formatNodePosition(n);
    }

    public void traverse(Node root) {
        try {
            this.inputId = NodeUtil.getInputId(root);
            this.sourceName = "";
            this.curNode = root;
            this.pushScope(root);
            this.traverseBranch(root, null);
            this.popScope();
        }
        catch (Exception unexpectedException) {
            this.throwUnexpectedException(unexpectedException);
        }
    }

    void traverseRoots(Node externs, Node root) {
        try {
            Node scopeRoot = externs.getParent();
            Preconditions.checkState((scopeRoot != null ? 1 : 0) != 0);
            this.inputId = NodeUtil.getInputId(scopeRoot);
            this.sourceName = "";
            this.curNode = scopeRoot;
            this.pushScope(scopeRoot);
            this.traverseBranch(externs, scopeRoot);
            Preconditions.checkState((root.getParent() == scopeRoot ? 1 : 0) != 0);
            this.traverseBranch(root, scopeRoot);
            this.popScope();
        }
        catch (Exception unexpectedException) {
            this.throwUnexpectedException(unexpectedException);
        }
    }

    private String formatNodePosition(Node n) {
        String sourceFileName = this.getBestSourceFileName(n);
        if (sourceFileName == null) {
            return "[source unknown]\n";
        }
        int lineNumber = n.getLineno();
        int columnNumber = n.getCharno();
        String src = this.compiler.getSourceLine(sourceFileName, lineNumber);
        if (src == null) {
            src = MISSING_SOURCE;
        }
        return sourceFileName + ":" + lineNumber + ":" + columnNumber + "\n" + src + "\n";
    }

    void traverseWithScope(Node root, Scope s) {
        Preconditions.checkState((boolean)s.isGlobal());
        try {
            this.inputId = null;
            this.sourceName = "";
            this.curNode = root;
            this.pushScope(s);
            this.traverseBranch(root, null);
            this.popScope();
        }
        catch (Exception unexpectedException) {
            this.throwUnexpectedException(unexpectedException);
        }
    }

    void traverseAtScope(Scope s) {
        Node n = s.getRootNode();
        if (n.isFunction()) {
            if (this.inputId == null) {
                this.inputId = NodeUtil.getInputId(n);
            }
            this.sourceName = NodeTraversal.getSourceName(n);
            this.curNode = n;
            this.pushScope(s);
            Node args = n.getFirstChild().getNext();
            Node body = args.getNext();
            this.traverseBranch(args, n);
            this.traverseBranch(body, n);
            this.popScope();
        } else if (n.isBlock()) {
            if (this.inputId == null) {
                this.inputId = NodeUtil.getInputId(n);
            }
            this.sourceName = NodeTraversal.getSourceName(n);
            this.curNode = n;
            this.pushScope(s);
            this.traverseBranch(n, n.getParent());
            this.popScope();
        } else {
            Preconditions.checkState((boolean)s.isGlobal(), (String)"Expected global scope. Got:", (Object[])new Object[]{s});
            this.traverseWithScope(n, s);
        }
    }

    public void traverseFunctionOutOfBand(Node node, Scope scope) {
        Preconditions.checkNotNull((Object)scope);
        Preconditions.checkState((boolean)node.isFunction());
        Preconditions.checkState((scope.getRootNode() != null ? 1 : 0) != 0);
        if (this.inputId == null) {
            this.inputId = NodeUtil.getInputId(node);
        }
        this.curNode = node.getParent();
        this.pushScope(scope, true);
        this.traverseBranch(node, this.curNode);
        this.popScope(true);
    }

    void traverseInnerNode(Node node, Node parent, Scope refinedScope) {
        Preconditions.checkNotNull((Object)parent);
        if (this.inputId == null) {
            this.inputId = NodeUtil.getInputId(node);
        }
        if (refinedScope != null && this.getScope() != refinedScope) {
            this.curNode = node;
            this.pushScope(refinedScope);
            this.traverseBranch(node, parent);
            this.popScope();
        } else {
            this.traverseBranch(node, parent);
        }
    }

    public AbstractCompiler getCompiler() {
        return this.compiler;
    }

    public int getLineNumber() {
        for (Node cur = this.curNode; cur != null; cur = cur.getParent()) {
            int line = cur.getLineno();
            if (line < 0) continue;
            return line;
        }
        return 0;
    }

    public int getCharno() {
        for (Node cur = this.curNode; cur != null; cur = cur.getParent()) {
            int line = cur.getCharno();
            if (line < 0) continue;
            return line;
        }
        return 0;
    }

    public String getSourceName() {
        return this.sourceName;
    }

    public CompilerInput getInput() {
        return this.compiler.getInput(this.inputId);
    }

    public JSModule getModule() {
        CompilerInput input = this.getInput();
        return input == null ? null : input.getModule();
    }

    public Node getCurrentNode() {
        return this.curNode;
    }

    public static void traverseChangedFunctions(AbstractCompiler compiler, FunctionCallback callback) {
        final AbstractCompiler comp = compiler;
        final FunctionCallback cb = callback;
        final Node jsRoot = comp.getJsRoot();
        NodeTraversal t = new NodeTraversal(comp, new AbstractPreOrderCallback(){

            @Override
            public final boolean shouldTraverse(NodeTraversal t, Node n, Node p) {
                if ((n == jsRoot || n.isFunction()) && comp.hasScopeChanged(n)) {
                    cb.visit(comp, n);
                }
                return true;
            }
        });
        t.traverse(jsRoot);
    }

    public static void traverse(AbstractCompiler compiler, Node root, Callback cb) {
        NodeTraversal t = new NodeTraversal(compiler, cb);
        t.traverse(root);
    }

    public static void traverseTyped(AbstractCompiler compiler, Node root, Callback cb) {
        NodeTraversal t = new NodeTraversal(compiler, cb, SyntacticScopeCreator.makeTyped(compiler));
        t.traverse(root);
    }

    public static void traverseRoots(AbstractCompiler compiler, Callback cb, Node externs, Node root) {
        NodeTraversal t = new NodeTraversal(compiler, cb);
        t.traverseRoots(externs, root);
    }

    static void traverseRootsTyped(AbstractCompiler compiler, Callback cb, Node externs, Node root) {
        NodeTraversal t = new NodeTraversal(compiler, cb, SyntacticScopeCreator.makeTyped(compiler));
        t.traverseRoots(externs, root);
    }

    private void traverseBranch(Node n, Node parent) {
        int type = n.getType();
        if (type == 132) {
            this.inputId = n.getInputId();
            this.sourceName = NodeTraversal.getSourceName(n);
        }
        this.curNode = n;
        if (!this.callback.shouldTraverse(this, n, parent)) {
            return;
        }
        if (type == 105) {
            this.traverseFunction(n, parent);
        } else if (this.useBlockScope && NodeUtil.createsBlockScope(n)) {
            this.traverseBlockScope(n);
        } else {
            Node child = n.getFirstChild();
            while (child != null) {
                Node next = child.getNext();
                this.traverseBranch(child, n);
                child = next;
            }
        }
        this.curNode = n;
        this.callback.visit(this, n, parent);
    }

    private void traverseFunction(Node n, Node parent) {
        boolean isFunctionExpression;
        Preconditions.checkState((n.getChildCount() == 3 ? 1 : 0) != 0);
        Preconditions.checkState((boolean)n.isFunction());
        Node fnName = n.getFirstChild();
        boolean bl = isFunctionExpression = parent != null && NodeUtil.isFunctionExpression(n);
        if (!isFunctionExpression) {
            this.traverseBranch(fnName, n);
        }
        this.curNode = n;
        this.pushScope(n);
        if (isFunctionExpression) {
            this.traverseBranch(fnName, n);
        }
        Node args = fnName.getNext();
        Node body = args.getNext();
        this.traverseBranch(args, n);
        this.traverseBranch(body, n);
        this.popScope();
    }

    private void traverseBlockScope(Node n) {
        this.pushScope(n);
        for (Node child : n.children()) {
            this.traverseBranch(child, n);
        }
        this.popScope();
    }

    public Node getEnclosingFunction() {
        Node root = this.getCfgRoot();
        return root.isFunction() ? root : null;
    }

    private void pushScope(Node node) {
        Preconditions.checkState((this.curNode != null ? 1 : 0) != 0);
        this.compiler.setScope(node);
        this.scopeRoots.push(node);
        if (NodeUtil.isValidCfgRoot(node)) {
            this.cfgRoots.push(node);
            this.cfgs.push(null);
        }
        if (this.scopeCallback != null) {
            this.scopeCallback.enterScope(this);
        }
    }

    private void pushScope(Scope s) {
        this.pushScope(s, false);
    }

    private void pushScope(Scope s, boolean quietly) {
        Preconditions.checkState((this.curNode != null ? 1 : 0) != 0);
        this.compiler.setScope(s.getRootNode());
        this.scopes.push(s);
        if (NodeUtil.isValidCfgRoot(s.getRootNode())) {
            this.cfgs.push(null);
        }
        if (!quietly && this.scopeCallback != null) {
            this.scopeCallback.enterScope(this);
        }
    }

    private void popScope() {
        this.popScope(false);
    }

    private void popScope(boolean quietly) {
        Node scopeRoot;
        if (!quietly && this.scopeCallback != null) {
            this.scopeCallback.exitScope(this);
        }
        if (NodeUtil.isValidCfgRoot(scopeRoot = this.scopeRoots.isEmpty() ? this.scopes.pop().getRootNode() : this.scopeRoots.pop())) {
            this.cfgs.pop();
            if (!this.cfgRoots.isEmpty()) {
                Preconditions.checkState((this.cfgRoots.pop() == scopeRoot ? 1 : 0) != 0);
            }
        }
        if (this.hasScope()) {
            this.compiler.setScope(this.getScopeRoot());
        }
    }

    public Scope getScope() {
        Scope scope;
        Scope scope2 = scope = this.scopes.isEmpty() ? null : this.scopes.peek();
        if (this.scopeRoots.isEmpty()) {
            return scope;
        }
        Iterator<Node> it = this.scopeRoots.descendingIterator();
        while (it.hasNext()) {
            scope = this.scopeCreator.createScope(it.next(), scope);
            this.scopes.push(scope);
        }
        this.scopeRoots.clear();
        this.cfgRoots.clear();
        return scope;
    }

    public TypedScope getTypedScope() {
        Scope s = this.getScope();
        Preconditions.checkState((boolean)(s instanceof TypedScope), (Object)"getTypedScope called for untyped traversal");
        return (TypedScope)s;
    }

    public ControlFlowGraph<Node> getControlFlowGraph() {
        if (this.cfgs.peek() == null) {
            ControlFlowAnalysis cfa = new ControlFlowAnalysis(this.compiler, false, true);
            cfa.process(null, this.getCfgRoot());
            this.cfgs.pop();
            this.cfgs.push(cfa.getCfg());
        }
        return this.cfgs.peek();
    }

    public Node getScopeRoot() {
        if (this.scopeRoots.isEmpty()) {
            return this.scopes.peek().getRootNode();
        }
        return this.scopeRoots.peek();
    }

    private Node getCfgRoot() {
        if (this.cfgRoots.isEmpty()) {
            Scope currScope = this.scopes.peek();
            while (currScope.isBlockScope()) {
                currScope = currScope.getParent();
            }
            return currScope.getRootNode();
        }
        return this.cfgRoots.peek();
    }

    boolean inGlobalScope() {
        return this.getScopeDepth() <= 1;
    }

    boolean inFunction() {
        return this.getCfgRoot().isFunction();
    }

    int getScopeDepth() {
        return this.scopes.size() + this.scopeRoots.size();
    }

    public boolean hasScope() {
        return !this.scopes.isEmpty() || !this.scopeRoots.isEmpty();
    }

    public void report(Node n, DiagnosticType diagnosticType, String ... arguments) {
        JSError error = JSError.make(n, diagnosticType, arguments);
        this.compiler.report(error);
    }

    private static String getSourceName(Node n) {
        String name = n.getSourceFileName();
        return name == null ? "" : name;
    }

    InputId getInputId() {
        return this.inputId;
    }

    public JSError makeError(Node n, CheckLevel level, DiagnosticType type, String ... arguments) {
        return JSError.make(n, level, type, arguments);
    }

    public JSError makeError(Node n, DiagnosticType type, String ... arguments) {
        return JSError.make(n, type, arguments);
    }

    private String getBestSourceFileName(Node n) {
        return n == null ? this.sourceName : n.getSourceFileName();
    }

    public static abstract class AbstractNodeTypePruningCallback
    implements Callback {
        private final Set<Integer> nodeTypes;
        private final boolean include;

        public AbstractNodeTypePruningCallback(Set<Integer> nodeTypes) {
            this(nodeTypes, true);
        }

        public AbstractNodeTypePruningCallback(Set<Integer> nodeTypes, boolean include) {
            this.nodeTypes = nodeTypes;
            this.include = include;
        }

        @Override
        public boolean shouldTraverse(NodeTraversal nodeTraversal, Node n, Node parent) {
            return this.include == this.nodeTypes.contains(n.getType());
        }
    }

    public static abstract class AbstractShallowStatementCallback
    implements Callback {
        @Override
        public final boolean shouldTraverse(NodeTraversal nodeTraversal, Node n, Node parent) {
            return parent == null || NodeUtil.isControlStructure(parent) || NodeUtil.isStatementBlock(parent);
        }
    }

    public static abstract class AbstractShallowCallback
    implements Callback {
        @Override
        public final boolean shouldTraverse(NodeTraversal nodeTraversal, Node n, Node parent) {
            return parent == null || !parent.isFunction() || n == parent.getFirstChild();
        }
    }

    public static abstract class AbstractScopedCallback
    implements ScopedCallback {
        @Override
        public final boolean shouldTraverse(NodeTraversal nodeTraversal, Node n, Node parent) {
            return true;
        }

        @Override
        public void enterScope(NodeTraversal t) {
        }

        @Override
        public void exitScope(NodeTraversal t) {
        }
    }

    public static abstract class AbstractPreOrderCallback
    implements Callback {
        @Override
        public void visit(NodeTraversal t, Node n, Node parent) {
        }
    }

    public static abstract class AbstractPostOrderCallback
    implements Callback {
        @Override
        public final boolean shouldTraverse(NodeTraversal nodeTraversal, Node n, Node parent) {
            return true;
        }
    }

    public static interface ScopedCallback
    extends Callback {
        public void enterScope(NodeTraversal var1);

        public void exitScope(NodeTraversal var1);
    }

    public static interface Callback {
        public boolean shouldTraverse(NodeTraversal var1, Node var2, Node var3);

        public void visit(NodeTraversal var1, Node var2, Node var3);
    }

    public static interface FunctionCallback {
        public void visit(AbstractCompiler var1, Node var2);
    }
}

