/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableList;
import com.google.common.io.Files;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.CompilerPass;
import com.google.javascript.jscomp.DefinitionProvider;
import com.google.javascript.jscomp.DefinitionsRemover;
import com.google.javascript.jscomp.DiagnosticType;
import com.google.javascript.jscomp.FunctionNames;
import com.google.javascript.jscomp.NameReferenceGraphConstruction;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.jscomp.Scope;
import com.google.javascript.jscomp.SimpleDefinitionFinder;
import com.google.javascript.jscomp.Var;
import com.google.javascript.jscomp.graph.FixedPointGraphTraversal;
import com.google.javascript.jscomp.graph.Graph;
import com.google.javascript.jscomp.graph.LinkedDirectedGraph;
import com.google.javascript.rhino.JSDocInfo;
import com.google.javascript.rhino.Node;
import com.google.javascript.rhino.Token;
import com.google.javascript.rhino.jstype.FunctionType;
import com.google.javascript.rhino.jstype.JSType;
import com.google.javascript.rhino.jstype.JSTypeNative;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

class PureFunctionIdentifier
implements CompilerPass {
    static final DiagnosticType INVALID_NO_SIDE_EFFECT_ANNOTATION = DiagnosticType.error("JSC_INVALID_NO_SIDE_EFFECT_ANNOTATION", "@nosideeffects may only appear in externs files.");
    static final DiagnosticType INVALID_MODIFIES_ANNOTATION = DiagnosticType.error("JSC_INVALID_MODIFIES_ANNOTATION", "@modifies may only appear in externs files.");
    private final AbstractCompiler compiler;
    private final DefinitionProvider definitionProvider;
    private final Map<Node, FunctionInformation> functionSideEffectMap;
    private final List<Node> allFunctionCalls;
    private Node externs;
    private Node root;

    public PureFunctionIdentifier(AbstractCompiler compiler, DefinitionProvider definitionProvider) {
        this.compiler = compiler;
        this.definitionProvider = definitionProvider;
        this.functionSideEffectMap = new HashMap<Node, FunctionInformation>();
        this.allFunctionCalls = new ArrayList<Node>();
        this.externs = null;
        this.root = null;
    }

    @Override
    public void process(Node externsAst, Node srcAst) {
        if (this.externs != null || this.root != null) {
            throw new IllegalStateException("It is illegal to call PureFunctionIdentifier.process twice the same instance.  Please use a new PureFunctionIdentifier instance each time.");
        }
        this.externs = externsAst;
        this.root = srcAst;
        NodeTraversal.traverse(this.compiler, this.externs, new FunctionAnalyzer(true));
        NodeTraversal.traverse(this.compiler, this.root, new FunctionAnalyzer(false));
        this.propagateSideEffects();
        this.markPureFunctionCalls();
    }

    String getDebugReport() {
        FunctionInformation functionInfo;
        Node function;
        Preconditions.checkNotNull((Object)this.externs);
        Preconditions.checkNotNull((Object)this.root);
        StringBuilder sb = new StringBuilder();
        FunctionNames functionNames = new FunctionNames(this.compiler);
        functionNames.process(null, this.externs);
        functionNames.process(null, this.root);
        sb.append("Pure functions:\n");
        for (Map.Entry<Node, FunctionInformation> entry : this.functionSideEffectMap.entrySet()) {
            function = entry.getKey();
            functionInfo = entry.getValue();
            boolean isPure = functionInfo.mayBePure() && !functionInfo.mayHaveSideEffects();
            if (!isPure) continue;
            sb.append("  " + functionNames.getFunctionName(function) + "\n");
        }
        sb.append("\n");
        for (Map.Entry<Node, FunctionInformation> entry : this.functionSideEffectMap.entrySet()) {
            function = entry.getKey();
            functionInfo = entry.getValue();
            HashSet<String> depFunctionNames = new HashSet<String>();
            for (Node callSite : functionInfo.getCallsInFunctionBody()) {
                Collection<DefinitionsRemover.Definition> defs = PureFunctionIdentifier.getCallableDefinitions(this.definitionProvider, callSite.getFirstChild());
                if (defs == null) {
                    depFunctionNames.add("<null def list>");
                    continue;
                }
                for (DefinitionsRemover.Definition def : defs) {
                    depFunctionNames.add(functionNames.getFunctionName(def.getRValue()));
                }
            }
            sb.append(functionNames.getFunctionName(function) + " " + functionInfo + " Calls: " + depFunctionNames + "\n");
        }
        return sb.toString();
    }

    private static Collection<DefinitionsRemover.Definition> getCallableDefinitions(DefinitionProvider definitionProvider, Node name) {
        if (name.isGetProp() || name.isName()) {
            ArrayList<DefinitionsRemover.Definition> result = new ArrayList<DefinitionsRemover.Definition>();
            Collection<DefinitionsRemover.Definition> decls = definitionProvider.getDefinitionsReferencedAt(name);
            if (decls == null) {
                return null;
            }
            for (DefinitionsRemover.Definition current : decls) {
                Node rValue = current.getRValue();
                if (rValue != null && rValue.isFunction()) {
                    result.add(current);
                    continue;
                }
                return null;
            }
            return result;
        }
        if (name.isOr() || name.isHook()) {
            Node firstVal = name.isHook() ? name.getFirstChild().getNext() : name.getFirstChild();
            Collection<DefinitionsRemover.Definition> defs1 = PureFunctionIdentifier.getCallableDefinitions(definitionProvider, firstVal);
            Collection<DefinitionsRemover.Definition> defs2 = PureFunctionIdentifier.getCallableDefinitions(definitionProvider, firstVal.getNext());
            if (defs1 != null && defs2 != null) {
                defs1.addAll(defs2);
                return defs1;
            }
            return null;
        }
        if (NodeUtil.isFunctionExpression(name)) {
            return ImmutableList.of((Object)new DefinitionsRemover.FunctionExpressionDefinition(name, false));
        }
        return null;
    }

    private void propagateSideEffects() {
        LinkedDirectedGraph<FunctionInformation, Node> sideEffectGraph = LinkedDirectedGraph.createWithoutAnnotations();
        for (FunctionInformation functionInfo : this.functionSideEffectMap.values()) {
            ((Graph)sideEffectGraph).createNode(functionInfo);
        }
        block1: for (FunctionInformation functionInfo : this.functionSideEffectMap.values()) {
            if (!functionInfo.mayHaveSideEffects()) continue;
            for (Node callSite : functionInfo.getCallsInFunctionBody()) {
                Node callee = callSite.getFirstChild();
                Collection<DefinitionsRemover.Definition> defs = PureFunctionIdentifier.getCallableDefinitions(this.definitionProvider, callee);
                if (defs == null) {
                    functionInfo.setTaintsUnknown();
                    continue block1;
                }
                for (DefinitionsRemover.Definition def : defs) {
                    Node defValue = def.getRValue();
                    FunctionInformation dep = this.functionSideEffectMap.get(defValue);
                    Preconditions.checkNotNull((Object)dep);
                    ((Graph)sideEffectGraph).connect(dep, callSite, functionInfo);
                }
            }
        }
        FixedPointGraphTraversal.newTraversal(new SideEffectPropagationCallback()).computeFixedPoint(sideEffectGraph);
        for (FunctionInformation functionInfo : this.functionSideEffectMap.values()) {
            if (!functionInfo.mayBePure()) continue;
            functionInfo.setIsPure();
        }
    }

    private void markPureFunctionCalls() {
        for (Node callNode : this.allFunctionCalls) {
            Node name = callNode.getFirstChild();
            Collection<DefinitionsRemover.Definition> defs = PureFunctionIdentifier.getCallableDefinitions(this.definitionProvider, name);
            Node.SideEffectFlags flags = new Node.SideEffectFlags();
            if (defs == null) {
                flags.setMutatesGlobalState();
                flags.setThrows();
                flags.setReturnsTainted();
            } else {
                flags.clearAllFlags();
                for (DefinitionsRemover.Definition def : defs) {
                    FunctionInformation functionInfo = this.functionSideEffectMap.get(def.getRValue());
                    Preconditions.checkNotNull((Object)functionInfo);
                    if (functionInfo.mutatesGlobalState()) {
                        flags.setMutatesGlobalState();
                    }
                    if (functionInfo.mutatesArguments()) {
                        flags.setMutatesArguments();
                    }
                    if (functionInfo.functionThrows()) {
                        flags.setThrows();
                    }
                    if (!callNode.isNew() && functionInfo.taintsThis()) {
                        if (PureFunctionIdentifier.isCallOrApply(callNode)) {
                            flags.setMutatesArguments();
                        } else {
                            flags.setMutatesThis();
                        }
                    }
                    if (functionInfo.taintsReturn()) {
                        flags.setReturnsTainted();
                    }
                    if (!flags.areAllFlagsSet()) continue;
                    break;
                }
            }
            if (callNode.isCall()) {
                Preconditions.checkState((this.compiler != null ? 1 : 0) != 0);
                if (!NodeUtil.functionCallHasSideEffects(callNode, this.compiler)) {
                    flags.clearSideEffectFlags();
                }
            } else if (callNode.isNew() && !NodeUtil.constructorCallHasSideEffects(callNode)) {
                flags.clearSideEffectFlags();
            }
            callNode.setSideEffectFlags(flags.valueOf());
        }
    }

    private static boolean isIncDec(Node n) {
        int type = n.getType();
        return type == 102 || type == 103;
    }

    private static boolean isKnownLocalValue(Node value) {
        Predicate<Node> taintingPredicate = new Predicate<Node>(){

            public boolean apply(Node value) {
                switch (value.getType()) {
                    case 86: {
                        return false;
                    }
                    case 42: {
                        return false;
                    }
                    case 38: {
                        return false;
                    }
                    case 33: 
                    case 35: {
                        return false;
                    }
                    case 37: {
                        return false;
                    }
                }
                return false;
            }
        };
        return NodeUtil.evaluatesToLocalValue(value, taintingPredicate);
    }

    private static boolean isCallOrApply(Node callSite) {
        return NodeUtil.isFunctionObjectCall(callSite) || NodeUtil.isFunctionObjectApply(callSite);
    }

    static class Driver
    implements CompilerPass {
        private final AbstractCompiler compiler;
        private final String reportPath;
        private final boolean useNameReferenceGraph;

        Driver(AbstractCompiler compiler, String reportPath, boolean useNameReferenceGraph) {
            this.compiler = compiler;
            this.reportPath = reportPath;
            this.useNameReferenceGraph = useNameReferenceGraph;
        }

        @Override
        public void process(Node externs, Node root) {
            DefinitionProvider definitionProvider = null;
            if (this.useNameReferenceGraph) {
                NameReferenceGraphConstruction graphBuilder = new NameReferenceGraphConstruction(this.compiler);
                graphBuilder.process(externs, root);
                definitionProvider = graphBuilder.getNameReferenceGraph();
            } else {
                SimpleDefinitionFinder defFinder = new SimpleDefinitionFinder(this.compiler);
                defFinder.process(externs, root);
                definitionProvider = defFinder;
            }
            PureFunctionIdentifier pureFunctionIdentifier = new PureFunctionIdentifier(this.compiler, definitionProvider);
            pureFunctionIdentifier.process(externs, root);
            if (this.reportPath != null) {
                try {
                    Files.write((CharSequence)pureFunctionIdentifier.getDebugReport(), (File)new File(this.reportPath), (Charset)StandardCharsets.UTF_8);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        }
    }

    private static class FunctionInformation {
        private List<Node> callsInFunctionBody = null;
        private Set<Var> blacklisted = null;
        private Set<Var> taintedLocals = null;
        private int bitmask = 0;
        private static final int EXTERN_MASK = 1;
        private static final int PURE_FUNCTION_MASK = 2;
        private static final int FUNCTION_THROWS_MASK = 4;
        private static final int TAINTS_GLOBAL_STATE_MASK = 8;
        private static final int TAINTS_THIS_MASK = 16;
        private static final int TAINTS_ARGUMENTS_MASK = 32;
        private static final int TAINTS_UNKNOWN_MASK = 64;
        private static final int TAINTS_RETURN_MASK = 128;

        private void setMask(int mask, boolean value) {
            this.bitmask = value ? (this.bitmask |= mask) : (this.bitmask &= ~mask);
        }

        private boolean getMask(int mask) {
            return (this.bitmask & mask) != 0;
        }

        private boolean extern() {
            return this.getMask(1);
        }

        private boolean pureFunction() {
            return this.getMask(2);
        }

        private boolean taintsGlobalState() {
            return this.getMask(8);
        }

        private boolean taintsThis() {
            return this.getMask(16);
        }

        private boolean taintsUnknown() {
            return this.getMask(64);
        }

        private boolean taintsReturn() {
            return this.getMask(128);
        }

        boolean functionThrows() {
            return this.getMask(4);
        }

        FunctionInformation(boolean extern) {
            this.setMask(1, extern);
            this.checkInvariant();
        }

        public Set<Var> taintedLocals() {
            if (this.taintedLocals == null) {
                return Collections.emptySet();
            }
            return this.taintedLocals;
        }

        void addTaintedLocalObject(Var var) {
            if (this.taintedLocals == null) {
                this.taintedLocals = new HashSet<Var>();
            }
            this.taintedLocals.add(var);
        }

        void resetLocalVars() {
            this.blacklisted = Collections.emptySet();
            this.taintedLocals = Collections.emptySet();
        }

        public Set<Var> blacklisted() {
            if (this.blacklisted == null) {
                return Collections.emptySet();
            }
            return this.blacklisted;
        }

        public void blacklistLocal(Var var) {
            if (this.blacklisted == null) {
                this.blacklisted = new HashSet<Var>();
            }
            this.blacklisted.add(var);
        }

        boolean mayBePure() {
            return !this.getMask(124);
        }

        boolean mayHaveSideEffects() {
            return !this.pureFunction();
        }

        void setIsPure() {
            this.setMask(2, true);
            this.checkInvariant();
        }

        void setTaintsGlobalState() {
            this.setMask(8, true);
            this.checkInvariant();
        }

        void setTaintsThis() {
            this.setMask(16, true);
            this.checkInvariant();
        }

        void setTaintsArguments() {
            this.setMask(32, true);
            this.checkInvariant();
        }

        void setFunctionThrows() {
            this.setMask(4, true);
            this.checkInvariant();
        }

        void setTaintsUnknown() {
            this.setMask(64, true);
            this.checkInvariant();
        }

        void setTaintsReturn() {
            this.setMask(128, true);
            this.checkInvariant();
        }

        boolean mutatesGlobalState() {
            return this.getMask(72);
        }

        boolean mutatesArguments() {
            return this.getMask(104);
        }

        boolean mutatesThis() {
            return this.taintsThis();
        }

        private void checkInvariant() {
            boolean invariant;
            boolean bl = invariant = this.mayBePure() || this.mayHaveSideEffects();
            if (!invariant) {
                throw new IllegalStateException("Invariant failed.  " + this);
            }
        }

        void appendCall(Node callNode) {
            if (this.callsInFunctionBody == null) {
                this.callsInFunctionBody = new ArrayList<Node>();
            }
            this.callsInFunctionBody.add(callNode);
        }

        List<Node> getCallsInFunctionBody() {
            if (this.callsInFunctionBody == null) {
                return Collections.emptyList();
            }
            return this.callsInFunctionBody;
        }

        public String toString() {
            ArrayList<String> status = new ArrayList<String>();
            if (this.extern()) {
                status.add("extern");
            }
            if (this.pureFunction()) {
                status.add("pure");
            }
            if (this.taintsThis()) {
                status.add("this");
            }
            if (this.taintsGlobalState()) {
                status.add("global");
            }
            if (this.functionThrows()) {
                status.add("throw");
            }
            if (this.taintsUnknown()) {
                status.add("complex");
            }
            return "Side effects: " + status;
        }
    }

    private static class SideEffectPropagationCallback
    implements FixedPointGraphTraversal.EdgeCallback<FunctionInformation, Node> {
        private SideEffectPropagationCallback() {
        }

        @Override
        public boolean traverseEdge(FunctionInformation callee, Node callSite, FunctionInformation caller) {
            Preconditions.checkArgument((callSite.isCall() || callSite.isNew() ? 1 : 0) != 0);
            boolean changed = false;
            if (!caller.mutatesGlobalState() && callee.mutatesGlobalState()) {
                caller.setTaintsGlobalState();
                changed = true;
            }
            if (!caller.functionThrows() && callee.functionThrows()) {
                caller.setFunctionThrows();
                changed = true;
            }
            if (!caller.mutatesGlobalState() && callee.mutatesArguments() && !NodeUtil.allArgsUnescapedLocal(callSite)) {
                caller.setTaintsGlobalState();
                changed = true;
            }
            if (callee.mutatesThis() && !callSite.isNew()) {
                Node objectNode;
                boolean isCallOrApply = PureFunctionIdentifier.isCallOrApply(callSite);
                Node node = objectNode = isCallOrApply ? callSite.getFirstChild().getNext() : callSite.getFirstChild().getFirstChild();
                if (objectNode != null && objectNode.isName() && !isCallOrApply) {
                    if (!caller.mutatesGlobalState()) {
                        caller.setTaintsGlobalState();
                        changed = true;
                    }
                } else if (objectNode != null && objectNode.isThis()) {
                    if (!caller.mutatesThis()) {
                        caller.setTaintsThis();
                        changed = true;
                    }
                } else if (!(objectNode != null && NodeUtil.evaluatesToLocalValue(objectNode) && !isCallOrApply || caller.mutatesGlobalState())) {
                    caller.setTaintsGlobalState();
                    changed = true;
                }
            }
            return changed;
        }
    }

    private class FunctionAnalyzer
    implements NodeTraversal.ScopedCallback {
        private final boolean inExterns;

        FunctionAnalyzer(boolean inExterns) {
            this.inExterns = inExterns;
        }

        @Override
        public boolean shouldTraverse(NodeTraversal traversal, Node node, Node parent) {
            if (node.isFunction()) {
                Node gramp = parent.getParent();
                this.visitFunction(traversal, node, parent, gramp);
            }
            return true;
        }

        @Override
        public void visit(NodeTraversal traversal, Node node, Node parent) {
            Node enclosingFunction;
            if (this.inExterns) {
                return;
            }
            if (!NodeUtil.nodeTypeMayHaveSideEffects(node) && !node.isReturn()) {
                return;
            }
            if (node.isCall() || node.isNew()) {
                PureFunctionIdentifier.this.allFunctionCalls.add(node);
            }
            if ((enclosingFunction = traversal.getEnclosingFunction()) != null) {
                FunctionInformation sideEffectInfo = (FunctionInformation)PureFunctionIdentifier.this.functionSideEffectMap.get(enclosingFunction);
                Preconditions.checkNotNull((Object)sideEffectInfo);
                if (NodeUtil.isAssignmentOp(node)) {
                    this.visitAssignmentOrUnaryOperator(sideEffectInfo, traversal.getScope(), node, node.getFirstChild(), node.getLastChild());
                } else {
                    switch (node.getType()) {
                        case 30: 
                        case 37: {
                            this.visitCall(sideEffectInfo, node);
                            break;
                        }
                        case 31: 
                        case 102: 
                        case 103: {
                            this.visitAssignmentOrUnaryOperator(sideEffectInfo, traversal.getScope(), node, node.getFirstChild(), null);
                            break;
                        }
                        case 38: {
                            Preconditions.checkArgument((boolean)NodeUtil.isVarDeclaration(node));
                            Node value = node.getFirstChild();
                            if (value == null || NodeUtil.evaluatesToLocalValue(value)) break;
                            Scope scope = traversal.getScope();
                            Var var = scope.getVar(node.getString());
                            sideEffectInfo.blacklistLocal(var);
                            break;
                        }
                        case 49: {
                            this.visitThrow(sideEffectInfo);
                            break;
                        }
                        case 4: {
                            if (!node.hasChildren() || NodeUtil.evaluatesToLocalValue(node.getFirstChild())) break;
                            sideEffectInfo.setTaintsReturn();
                            break;
                        }
                        default: {
                            throw new IllegalArgumentException("Unhandled side effect node type " + Token.name(node.getType()));
                        }
                    }
                }
            }
        }

        @Override
        public void enterScope(NodeTraversal t) {
        }

        @Override
        public void exitScope(NodeTraversal t) {
            if (t.inGlobalScope()) {
                return;
            }
            Node function = NodeUtil.getEnclosingFunction(t.getScopeRoot());
            if (function == null) {
                return;
            }
            FunctionInformation sideEffectInfo = (FunctionInformation)PureFunctionIdentifier.this.functionSideEffectMap.get(function);
            if (sideEffectInfo == null) {
                return;
            }
            if (sideEffectInfo.mutatesGlobalState()) {
                sideEffectInfo.resetLocalVars();
                return;
            }
            Iterator i = t.getScope().getVars();
            while (i.hasNext()) {
                Var v = (Var)i.next();
                boolean param = v.getParentNode().isParamList();
                if (param && !sideEffectInfo.blacklisted().contains(v) && sideEffectInfo.taintedLocals().contains(v)) {
                    sideEffectInfo.setTaintsArguments();
                    continue;
                }
                boolean localVar = false;
                if (v.getParentNode().isVar()) {
                    localVar = true;
                }
                if (localVar && !sideEffectInfo.blacklisted().contains(v) || !sideEffectInfo.taintedLocals().contains(v)) continue;
                sideEffectInfo.setTaintsUnknown();
                sideEffectInfo.resetLocalVars();
                break;
            }
            if (t.getScopeRoot().isFunction()) {
                sideEffectInfo.resetLocalVars();
            }
        }

        private boolean varDeclaredInDifferentFunction(Var v, Scope scope) {
            if (v == null) {
                return true;
            }
            if (v.scope != scope) {
                Node scopeRoot;
                Node declarationRoot = NodeUtil.getEnclosingFunction(v.scope.rootNode);
                return declarationRoot != (scopeRoot = NodeUtil.getEnclosingFunction(scope.rootNode));
            }
            return false;
        }

        private void visitAssignmentOrUnaryOperator(FunctionInformation sideEffectInfo, Scope scope, Node op, Node lhs, Node rhs) {
            if (lhs.isName()) {
                Var var = scope.getVar(lhs.getString());
                if (this.varDeclaredInDifferentFunction(var, scope)) {
                    sideEffectInfo.setTaintsGlobalState();
                } else {
                    Preconditions.checkState((NodeUtil.isAssignmentOp(op) || PureFunctionIdentifier.isIncDec(op) || op.isDelProp() ? 1 : 0) != 0);
                    if (rhs != null && op.isAssign() && !NodeUtil.evaluatesToLocalValue(rhs)) {
                        sideEffectInfo.blacklistLocal(var);
                    }
                }
            } else if (NodeUtil.isGet(lhs)) {
                if (lhs.getFirstChild().isThis()) {
                    sideEffectInfo.setTaintsThis();
                } else {
                    Var var = null;
                    Node objectNode = lhs.getFirstChild();
                    if (objectNode.isName()) {
                        var = scope.getVar(objectNode.getString());
                    }
                    if (this.varDeclaredInDifferentFunction(var, scope)) {
                        sideEffectInfo.setTaintsUnknown();
                    } else {
                        sideEffectInfo.addTaintedLocalObject(var);
                    }
                }
            } else {
                sideEffectInfo.setTaintsUnknown();
            }
        }

        private void visitCall(FunctionInformation sideEffectInfo, Node node) {
            if (node.isCall() && !NodeUtil.functionCallHasSideEffects(node, PureFunctionIdentifier.this.compiler)) {
                return;
            }
            if (node.isNew() && !NodeUtil.constructorCallHasSideEffects(node)) {
                return;
            }
            sideEffectInfo.appendCall(node);
        }

        private void visitFunction(NodeTraversal traversal, Node node, Node parent, Node gramp) {
            JSDocInfo info;
            Preconditions.checkArgument((!PureFunctionIdentifier.this.functionSideEffectMap.containsKey(node) ? 1 : 0) != 0);
            FunctionInformation sideEffectInfo = new FunctionInformation(this.inExterns);
            PureFunctionIdentifier.this.functionSideEffectMap.put(node, sideEffectInfo);
            if (this.inExterns) {
                JSType jstypeReturn;
                JSType jstype = node.getJSType();
                boolean knownLocalResult = false;
                FunctionType functionType = JSType.toMaybeFunctionType(jstype);
                if (functionType != null && this.isLocalValueType(jstypeReturn = functionType.getReturnType())) {
                    knownLocalResult = true;
                }
                if (!knownLocalResult) {
                    sideEffectInfo.setTaintsReturn();
                }
            }
            if ((info = this.getJSDocInfoForFunction(node, parent, gramp)) != null) {
                boolean hasSpecificSideEffects = false;
                if (this.hasSideEffectsThisAnnotation(info)) {
                    if (this.inExterns) {
                        hasSpecificSideEffects = true;
                        sideEffectInfo.setTaintsThis();
                    } else {
                        traversal.report(node, INVALID_MODIFIES_ANNOTATION, new String[0]);
                    }
                }
                if (this.hasSideEffectsArgumentsAnnotation(info)) {
                    if (this.inExterns) {
                        hasSpecificSideEffects = true;
                        sideEffectInfo.setTaintsArguments();
                    } else {
                        traversal.report(node, INVALID_MODIFIES_ANNOTATION, new String[0]);
                    }
                }
                if (this.inExterns && !info.getThrownTypes().isEmpty()) {
                    hasSpecificSideEffects = true;
                    sideEffectInfo.setFunctionThrows();
                }
                if (!hasSpecificSideEffects) {
                    if (this.hasNoSideEffectsAnnotation(info)) {
                        if (this.inExterns) {
                            sideEffectInfo.setIsPure();
                        } else {
                            traversal.report(node, INVALID_NO_SIDE_EFFECT_ANNOTATION, new String[0]);
                        }
                    } else if (this.inExterns) {
                        sideEffectInfo.setTaintsGlobalState();
                    }
                }
            } else if (this.inExterns) {
                sideEffectInfo.setTaintsGlobalState();
            }
        }

        private boolean isLocalValueType(JSType jstype) {
            Preconditions.checkNotNull((Object)jstype);
            JSType subtype = jstype.getGreatestSubtype((JSType)PureFunctionIdentifier.this.compiler.getTypeIRegistry().getNativeType(JSTypeNative.OBJECT_TYPE));
            return subtype.isNoType();
        }

        private void visitThrow(FunctionInformation sideEffectInfo) {
            sideEffectInfo.setFunctionThrows();
        }

        private JSDocInfo getJSDocInfoForFunction(Node node, Node parent, Node gramp) {
            JSDocInfo info = node.getJSDocInfo();
            if (info != null) {
                return info;
            }
            if (parent.isName()) {
                return gramp.hasOneChild() ? gramp.getJSDocInfo() : null;
            }
            if (parent.isAssign()) {
                return parent.getJSDocInfo();
            }
            return null;
        }

        private boolean hasNoSideEffectsAnnotation(JSDocInfo docInfo) {
            Preconditions.checkNotNull((Object)docInfo);
            return docInfo.isNoSideEffects();
        }

        private boolean hasSideEffectsThisAnnotation(JSDocInfo docInfo) {
            Preconditions.checkNotNull((Object)docInfo);
            return docInfo.getModifies().contains("this");
        }

        private boolean hasSideEffectsArgumentsAnnotation(JSDocInfo docInfo) {
            Preconditions.checkNotNull((Object)docInfo);
            Set<String> modifies = docInfo.getModifies();
            return modifies.size() > 1 || modifies.size() == 1 && !modifies.contains("this");
        }
    }
}

