/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableBiMap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSortedMap;
import com.google.common.collect.ImmutableSortedSet;
import com.google.common.io.Files;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.text.ParseException;
import java.util.Collection;
import java.util.Comparator;
import java.util.Map;

public final class VariableMap {
    private static final char SEPARATOR = ':';
    private static final Comparator<Map.Entry<String, String>> ENTRY_COMPARATOR = new Comparator<Map.Entry<String, String>>(){

        @Override
        public int compare(Map.Entry<String, String> e1, Map.Entry<String, String> e2) {
            return e1.getKey().compareTo(e2.getKey());
        }
    };
    private final ImmutableBiMap<String, String> map;
    private static final Splitter LINE_SPLITTER = Splitter.onPattern((String)"\\r?\\n").omitEmptyStrings();

    VariableMap(Map<String, String> map) {
        this.map = ImmutableBiMap.copyOf(map);
    }

    public String lookupNewName(String sourceName) {
        return (String)this.map.get((Object)sourceName);
    }

    public String lookupSourceName(String newName) {
        return (String)this.map.inverse().get((Object)newName);
    }

    public Map<String, String> getOriginalNameToNewNameMap() {
        return ImmutableSortedMap.copyOf(this.map);
    }

    public Map<String, String> getNewNameToOriginalNameMap() {
        return this.map.inverse();
    }

    public void save(String filename) throws IOException {
        Files.write((byte[])this.toBytes(), (File)new File(filename));
    }

    public static VariableMap load(String filename) throws IOException {
        try {
            return VariableMap.fromBytes(Files.toByteArray((File)new File(filename)));
        }
        catch (ParseException e) {
            throw new IOException(e);
        }
    }

    public byte[] toBytes() {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        OutputStreamWriter writer = new OutputStreamWriter((OutputStream)baos, StandardCharsets.UTF_8);
        try {
            for (Map.Entry entry : ImmutableSortedSet.copyOf(ENTRY_COMPARATOR, (Collection)this.map.entrySet())) {
                writer.write(VariableMap.escape((String)entry.getKey()));
                ((Writer)writer).write(58);
                writer.write(VariableMap.escape((String)entry.getValue()));
                ((Writer)writer).write(10);
            }
            ((Writer)writer).close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return baos.toByteArray();
    }

    public static VariableMap fromBytes(byte[] bytes) throws ParseException {
        Iterable lines = LINE_SPLITTER.split((CharSequence)new String(bytes, StandardCharsets.UTF_8));
        ImmutableMap.Builder map = ImmutableMap.builder();
        for (String line : lines) {
            int pos = VariableMap.findIndexOfChar(line, ':');
            if (pos <= 0 || pos == line.length() - 1) {
                throw new ParseException("Bad line: " + line, 0);
            }
            map.put((Object)VariableMap.unescape(line.substring(0, pos)), (Object)VariableMap.unescape(line.substring(pos + 1)));
        }
        return new VariableMap((Map<String, String>)map.build());
    }

    private static String escape(String value) {
        return value.replace("\\", "\\\\").replace(":", "\\:").replace("\n", "\\n");
    }

    private static int findIndexOfChar(String value, char stopChar) {
        int len = value.length();
        for (int i = 0; i < len; ++i) {
            char c = value.charAt(i);
            if (c == '\\' && ++i < len) {
                c = value.charAt(i);
                continue;
            }
            if (c != stopChar) continue;
            return i;
        }
        return -1;
    }

    private static String unescape(CharSequence value) {
        StringBuilder sb = new StringBuilder();
        int len = value.length();
        for (int i = 0; i < len; ++i) {
            char c = value.charAt(i);
            if (c == '\\' && ++i < len) {
                c = value.charAt(i);
            }
            sb.append(c);
        }
        return sb.toString();
    }

    public static VariableMap fromMap(Map<String, String> map) {
        return new VariableMap(map);
    }

    @VisibleForTesting
    Map<String, String> toMap() {
        return this.map;
    }
}

