/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp.newtypes;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Multimap;
import com.google.javascript.jscomp.newtypes.FunctionType;
import com.google.javascript.jscomp.newtypes.JSType;
import com.google.javascript.jscomp.newtypes.ObjectKind;
import com.google.javascript.jscomp.newtypes.ObjectType;
import com.google.javascript.jscomp.newtypes.Property;
import com.google.javascript.jscomp.newtypes.RawNominalType;
import com.google.javascript.rhino.Node;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Pattern;

public final class NominalType {
    private final ImmutableMap<String, JSType> typeMap;
    private final RawNominalType rawType;
    private static final Pattern NUMERIC_PATTERN = Pattern.compile("\\d+");

    NominalType(ImmutableMap<String, JSType> typeMap, RawNominalType rawType) {
        Preconditions.checkState((typeMap.isEmpty() || typeMap.keySet().containsAll(rawType.getTypeParameters()) && rawType.getTypeParameters().containsAll((Collection)typeMap.keySet()) ? 1 : 0) != 0);
        this.typeMap = typeMap;
        this.rawType = rawType;
    }

    public RawNominalType getRawNominalType() {
        Preconditions.checkState((!this.rawType.isRawTypeFinalized() ? 1 : 0) != 0);
        return this.rawType;
    }

    public JSType getInstanceAsJSType() {
        return this.rawType.isGeneric() && !this.typeMap.isEmpty() ? JSType.fromObjectType(ObjectType.fromNominalType(this)) : this.rawType.getInstanceAsJSType();
    }

    ObjectKind getObjectKind() {
        return this.rawType.getObjectKind();
    }

    Node getConstDeclNode() {
        return this.rawType.getConstDeclNode();
    }

    Map<String, JSType> getTypeMap() {
        return this.typeMap;
    }

    boolean isClassy() {
        return !this.isFunction() && !this.isObject();
    }

    boolean isFunction() {
        return "Function".equals(this.rawType.name);
    }

    private boolean isObject() {
        return "Object".equals(this.rawType.name);
    }

    public boolean isStruct() {
        return this.rawType.isStruct();
    }

    public boolean isDict() {
        return this.rawType.isDict();
    }

    public boolean isGeneric() {
        return this.rawType.isGeneric();
    }

    public boolean isUninstantiatedGenericType() {
        return this.rawType.isGeneric() && this.typeMap.isEmpty();
    }

    boolean finalizeNamespace(Node constDeclNode) {
        return this.rawType.finalizeNamespace(constDeclNode);
    }

    NominalType instantiateGenerics(List<JSType> types) {
        ImmutableList<String> typeParams = this.rawType.getTypeParameters();
        Preconditions.checkState((types.size() == typeParams.size() ? 1 : 0) != 0);
        LinkedHashMap<String, JSType> typeMap = new LinkedHashMap<String, JSType>();
        for (int i = 0; i < typeParams.size(); ++i) {
            typeMap.put((String)typeParams.get(i), types.get(i));
        }
        return this.instantiateGenerics(typeMap);
    }

    NominalType instantiateGenerics(Map<String, JSType> newTypeMap) {
        ImmutableMap resultMap;
        if (newTypeMap.isEmpty()) {
            return this;
        }
        if (!this.rawType.isGeneric()) {
            return this.rawType.getAsNominalType();
        }
        ImmutableMap.Builder builder = ImmutableMap.builder();
        if (!this.typeMap.isEmpty()) {
            for (String oldKey : this.typeMap.keySet()) {
                builder.put((Object)oldKey, (Object)((JSType)this.typeMap.get((Object)oldKey)).substituteGenerics(newTypeMap));
            }
            resultMap = builder.build();
        } else {
            ImmutableList<String> typeParams = this.rawType.getTypeParameters();
            for (String newKey : typeParams) {
                if (!newTypeMap.containsKey(newKey)) continue;
                builder.put((Object)newKey, (Object)newTypeMap.get(newKey));
            }
            resultMap = builder.build();
            if (resultMap.isEmpty()) {
                return this;
            }
            if (resultMap.size() < typeParams.size()) {
                return this;
            }
        }
        return new NominalType((ImmutableMap<String, JSType>)resultMap, this.rawType);
    }

    public String getName() {
        return this.rawType.name;
    }

    public RawNominalType getId() {
        return this.rawType;
    }

    public boolean isClass() {
        return this.rawType.isClass();
    }

    public boolean isInterface() {
        return this.rawType.isInterface();
    }

    public boolean isRawTypeFinalized() {
        return this.rawType.isRawTypeFinalized();
    }

    boolean hasAncestorClass(RawNominalType ancestor) {
        return this.rawType.hasAncestorClass(ancestor);
    }

    boolean hasAncestorInterface(RawNominalType ancestor) {
        return this.rawType.hasAncestorInterface(ancestor);
    }

    public ImmutableSet<String> getAllPropsOfInterface() {
        return this.rawType.getAllPropsOfInterface();
    }

    public ImmutableSet<String> getAllPropsOfClass() {
        return this.rawType.getAllPropsOfClass();
    }

    public NominalType getInstantiatedSuperclass() {
        Preconditions.checkState((boolean)this.rawType.isRawTypeFinalized());
        if (this.rawType.getSuperClass() == null) {
            return null;
        }
        return this.rawType.getSuperClass().instantiateGenerics((Map<String, JSType>)this.typeMap);
    }

    public JSType getPrototype() {
        Preconditions.checkState((boolean)this.rawType.isRawTypeFinalized());
        return this.rawType.getCtorPropDeclaredType("prototype").substituteGenerics((Map<String, JSType>)this.typeMap);
    }

    public ImmutableSet<NominalType> getInstantiatedInterfaces() {
        Preconditions.checkState((boolean)this.rawType.isRawTypeFinalized());
        ImmutableSet.Builder result = ImmutableSet.builder();
        for (NominalType interf : this.rawType.getInterfaces()) {
            result.add((Object)interf.instantiateGenerics((Map<String, JSType>)this.typeMap));
        }
        return result.build();
    }

    Property getProp(String pname) {
        if (this.rawType.name.equals("Array") && NUMERIC_PATTERN.matcher(pname).matches()) {
            if (this.typeMap.isEmpty()) {
                return Property.make(JSType.UNKNOWN, null);
            }
            Preconditions.checkState((this.typeMap.size() == 1 ? 1 : 0) != 0);
            JSType elmType = (JSType)Iterables.getOnlyElement((Iterable)this.typeMap.values());
            return Property.make(elmType, null);
        }
        Property p = this.rawType.getProp(pname);
        return p == null ? null : p.substituteGenerics((Map<String, JSType>)this.typeMap);
    }

    public JSType getPropDeclaredType(String pname) {
        JSType type = this.rawType.getInstancePropDeclaredType(pname);
        if (type == null) {
            return null;
        }
        return type.substituteGenerics((Map<String, JSType>)this.typeMap);
    }

    public boolean hasConstantProp(String pname) {
        Property p = this.rawType.getProp(pname);
        return p != null && p.isConstant();
    }

    static JSType getConstructorObject(FunctionType ctorFn) {
        return ctorFn.nominalType.rawType.getConstructorObject(ctorFn);
    }

    boolean isSubtypeOf(NominalType other) {
        RawNominalType thisRaw = this.rawType;
        if (thisRaw == other.rawType) {
            return this.areTypeMapsCompatible(other);
        }
        if (other.isInterface()) {
            for (NominalType i : thisRaw.getInterfaces()) {
                if (!i.instantiateGenerics((Map<String, JSType>)this.typeMap).isSubtypeOf(other)) continue;
                return true;
            }
        }
        return this.isClass() && thisRaw.getSuperClass() != null && thisRaw.getSuperClass().instantiateGenerics((Map<String, JSType>)this.typeMap).isSubtypeOf(other);
    }

    private boolean areTypeMapsCompatible(NominalType other) {
        Preconditions.checkState((boolean)this.rawType.equals(other.rawType));
        if (this.typeMap.isEmpty()) {
            return other.instantiationIsUnknownOrIdentity();
        }
        if (other.typeMap.isEmpty()) {
            return this.instantiationIsUnknownOrIdentity();
        }
        for (String typeVar : this.rawType.getTypeParameters()) {
            Preconditions.checkState((boolean)this.typeMap.containsKey((Object)typeVar), (String)"Type variable %s not in the domain: %s", (Object[])new Object[]{typeVar, this.typeMap.keySet()});
            Preconditions.checkState((boolean)other.typeMap.containsKey((Object)typeVar), (String)"Other (%s) doesn't contain mapping (%s->%s) from this (%s)", (Object[])new Object[]{other, typeVar, this.typeMap.get((Object)typeVar), this});
            JSType thisType = (JSType)this.typeMap.get((Object)typeVar);
            JSType otherType = (JSType)other.typeMap.get((Object)typeVar);
            if (!(NominalType.allowCovariantGenerics(this) ? !thisType.isSubtypeOf(otherType) : !thisType.equals(otherType) && JSType.unifyUnknowns(thisType, otherType) == null)) continue;
            return false;
        }
        return true;
    }

    private static boolean allowCovariantGenerics(NominalType nt) {
        return nt.rawType.name.equals("Array");
    }

    private boolean instantiationIsUnknownOrIdentity() {
        if (this.typeMap.isEmpty()) {
            return true;
        }
        for (String typeVar : this.rawType.getTypeParameters()) {
            Preconditions.checkState((boolean)this.typeMap.containsKey((Object)typeVar), (String)"Type variable %s not in the domain: %s", (Object[])new Object[]{typeVar, this.typeMap.keySet()});
            JSType t = (JSType)this.typeMap.get((Object)typeVar);
            if (t.isUnknown() || t.equals(JSType.fromTypeVar(typeVar))) continue;
            return false;
        }
        return true;
    }

    static NominalType pickSuperclass(NominalType c1, NominalType c2) {
        if (c1 == null || c2 == null) {
            return null;
        }
        if (c1.isSubtypeOf(c2)) {
            return c2;
        }
        return c2.isSubtypeOf(c1) ? c1 : null;
    }

    static NominalType pickSubclass(NominalType c1, NominalType c2) {
        if (c1 == null) {
            return c2;
        }
        if (c2 == null) {
            return c1;
        }
        if (c1.isSubtypeOf(c2)) {
            return c1;
        }
        return c2.isSubtypeOf(c1) ? c2 : null;
    }

    boolean unifyWithSubtype(NominalType other, List<String> typeParameters, Multimap<String, JSType> typeMultimap) {
        if ((other = other.findMatchingAncestorWith(this)) == null) {
            return false;
        }
        if (!this.isGeneric()) {
            return true;
        }
        Preconditions.checkState((!this.typeMap.isEmpty() ? 1 : 0) != 0);
        if (other.typeMap.isEmpty()) {
            return true;
        }
        boolean hasUnified = true;
        for (String typeParam : this.rawType.getTypeParameters()) {
            JSType fromOtherMap = (JSType)other.typeMap.get((Object)typeParam);
            Preconditions.checkNotNull((Object)fromOtherMap, (String)"Type variable %s not found in map %s", (Object[])new Object[]{typeParam, other.typeMap});
            hasUnified = hasUnified && ((JSType)this.typeMap.get((Object)typeParam)).unifyWithSubtype(fromOtherMap, typeParameters, typeMultimap);
        }
        return hasUnified && (NominalType.allowCovariantGenerics(this) || this.isInvariantWith(typeMultimap, other));
    }

    private NominalType findMatchingAncestorWith(NominalType other) {
        RawNominalType thisRaw = this.rawType;
        if (thisRaw == other.rawType) {
            return this;
        }
        if (other.isInterface()) {
            for (NominalType i : thisRaw.getInterfaces()) {
                NominalType nt = i.instantiateGenerics((Map<String, JSType>)this.typeMap).findMatchingAncestorWith(other);
                if (nt == null) continue;
                return nt;
            }
        }
        if (this.isClass() && thisRaw.getSuperClass() != null) {
            return thisRaw.getSuperClass().instantiateGenerics((Map<String, JSType>)this.typeMap).findMatchingAncestorWith(other);
        }
        return null;
    }

    private boolean isInvariantWith(Multimap<String, JSType> typeMultimap, NominalType other) {
        Preconditions.checkState((boolean)this.isGeneric());
        Preconditions.checkState((this.rawType == other.rawType ? 1 : 0) != 0);
        LinkedHashMap<String, JSType> newTypeMap = new LinkedHashMap<String, JSType>();
        for (String typeVar : typeMultimap.keySet()) {
            Collection c = typeMultimap.get((Object)typeVar);
            if (c.size() != 1) {
                return false;
            }
            newTypeMap.put(typeVar, (JSType)Preconditions.checkNotNull((Object)Iterables.getOnlyElement((Iterable)c)));
        }
        NominalType instantiated = this.instantiateGenerics(newTypeMap);
        return Objects.equals(instantiated.typeMap, other.typeMap);
    }

    public String toString() {
        return this.appendTo(new StringBuilder()).toString();
    }

    StringBuilder appendTo(StringBuilder builder) {
        if (this.typeMap.isEmpty()) {
            return this.rawType.appendTo(builder);
        }
        builder.append(this.rawType.name);
        ImmutableList<String> typeParams = this.rawType.getTypeParameters();
        Preconditions.checkState((boolean)this.typeMap.keySet().containsAll(typeParams));
        boolean firstIteration = true;
        builder.append('<');
        for (String typeParam : typeParams) {
            if (firstIteration) {
                firstIteration = false;
            } else {
                builder.append(',');
            }
            JSType concrete = (JSType)this.typeMap.get((Object)typeParam);
            ((JSType)Preconditions.checkNotNull((Object)concrete)).appendTo(builder);
        }
        builder.append('>');
        return builder;
    }

    public int hashCode() {
        return Objects.hash(this.typeMap, this.rawType);
    }

    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        Preconditions.checkState((boolean)(other instanceof NominalType));
        NominalType o = (NominalType)other;
        return Objects.equals(this.typeMap, o.typeMap) && this.rawType.equals(o.rawType);
    }
}

