/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp.newtypes;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.javascript.jscomp.newtypes.FunctionType;
import com.google.javascript.jscomp.newtypes.JSType;
import com.google.javascript.jscomp.newtypes.JSTypes;
import com.google.javascript.jscomp.newtypes.Namespace;
import com.google.javascript.jscomp.newtypes.NominalType;
import com.google.javascript.jscomp.newtypes.ObjectKind;
import com.google.javascript.jscomp.newtypes.ObjectType;
import com.google.javascript.jscomp.newtypes.PersistentMap;
import com.google.javascript.jscomp.newtypes.Property;
import com.google.javascript.jscomp.newtypes.QualifiedName;
import com.google.javascript.rhino.Node;
import java.util.LinkedHashSet;
import java.util.Set;

public final class RawNominalType
extends Namespace {
    private final Node defSite;
    private boolean isRawTypeFinalized;
    private PersistentMap<String, Property> classProps = PersistentMap.create();
    private PersistentMap<String, Property> protoProps = PersistentMap.create();
    private PersistentMap<String, Property> randomProps = PersistentMap.create();
    private NominalType superClass = null;
    private ImmutableSet<NominalType> interfaces = null;
    private final boolean isInterface;
    private ImmutableSet<String> allProps = null;
    private final NominalType wrappedAsNominal;
    private final JSType wrappedAsJSType;
    private final JSType wrappedAsNullableJSType;
    private final ImmutableList<String> typeParameters;
    private final ObjectKind objectKind;
    private FunctionType ctorFn;
    private JSTypes commonTypes;

    private RawNominalType(Node defSite, String name, ImmutableList<String> typeParameters, boolean isInterface, ObjectKind objectKind) {
        ObjectType objInstance;
        Preconditions.checkNotNull((Object)objectKind);
        Preconditions.checkState((defSite == null || defSite.isFunction() ? 1 : 0) != 0);
        if (typeParameters == null) {
            typeParameters = ImmutableList.of();
        }
        this.name = name;
        this.defSite = defSite;
        this.typeParameters = typeParameters;
        this.isInterface = isInterface;
        this.objectKind = objectKind;
        this.wrappedAsNominal = new NominalType((ImmutableMap<String, JSType>)ImmutableMap.of(), this);
        switch (name) {
            case "Function": {
                objInstance = ObjectType.fromFunction(FunctionType.TOP_FUNCTION, this.wrappedAsNominal);
                break;
            }
            case "Object": {
                objInstance = ObjectType.TOP_OBJECT;
                break;
            }
            default: {
                objInstance = ObjectType.fromNominalType(this.wrappedAsNominal);
            }
        }
        this.wrappedAsJSType = JSType.fromObjectType(objInstance);
        this.wrappedAsNullableJSType = JSType.join(JSType.NULL, this.wrappedAsJSType);
    }

    public static RawNominalType makeUnrestrictedClass(Node defSite, QualifiedName name, ImmutableList<String> typeParameters) {
        return new RawNominalType(defSite, name.toString(), typeParameters, false, ObjectKind.UNRESTRICTED);
    }

    public static RawNominalType makeStructClass(Node defSite, QualifiedName name, ImmutableList<String> typeParameters) {
        return new RawNominalType(defSite, name.toString(), typeParameters, false, ObjectKind.STRUCT);
    }

    public static RawNominalType makeDictClass(Node defSite, QualifiedName name, ImmutableList<String> typeParameters) {
        return new RawNominalType(defSite, name.toString(), typeParameters, false, ObjectKind.DICT);
    }

    public static RawNominalType makeInterface(Node defSite, QualifiedName name, ImmutableList<String> typeParameters) {
        return new RawNominalType(defSite, name.toString(), typeParameters, true, ObjectKind.STRUCT);
    }

    public Node getDefSite() {
        return this.defSite;
    }

    @Override
    public Node getConstDeclNode() {
        if (this.constDeclNode != null) {
            return this.constDeclNode;
        }
        Node n = null;
        if (this.superClass != null) {
            n = this.superClass.getConstDeclNode();
        }
        if (n != null) {
            return n;
        }
        if (this.interfaces != null) {
            for (NominalType interf : this.interfaces) {
                n = interf.getConstDeclNode();
                if (n == null) continue;
                return n;
            }
        }
        return null;
    }

    public boolean isClass() {
        return !this.isInterface;
    }

    public boolean isInterface() {
        return this.isInterface;
    }

    boolean isGeneric() {
        return !this.typeParameters.isEmpty();
    }

    public boolean isStruct() {
        return this.objectKind.isStruct();
    }

    public boolean isDict() {
        return this.objectKind.isDict();
    }

    public boolean isRawTypeFinalized() {
        return this.isRawTypeFinalized;
    }

    ImmutableList<String> getTypeParameters() {
        return this.typeParameters;
    }

    ObjectKind getObjectKind() {
        return this.objectKind;
    }

    public void setCtorFunction(FunctionType ctorFn, JSTypes commonTypes) {
        Preconditions.checkState((!this.isNamespaceFinalized ? 1 : 0) != 0);
        this.ctorFn = ctorFn;
        this.commonTypes = commonTypes;
    }

    boolean hasAncestorClass(RawNominalType ancestor) {
        Preconditions.checkState((boolean)ancestor.isClass());
        if (this == ancestor) {
            return true;
        }
        if (this.superClass == null) {
            return false;
        }
        return this.superClass.hasAncestorClass(ancestor);
    }

    public boolean addSuperClass(NominalType superClass) {
        Preconditions.checkState((!this.isNamespaceFinalized ? 1 : 0) != 0);
        Preconditions.checkState((this.superClass == null ? 1 : 0) != 0);
        if (superClass.hasAncestorClass(this)) {
            return false;
        }
        this.superClass = superClass;
        return true;
    }

    boolean hasAncestorInterface(RawNominalType ancestor) {
        Preconditions.checkState((boolean)ancestor.isInterface);
        if (this == ancestor) {
            return true;
        }
        if (this.interfaces == null) {
            return false;
        }
        for (NominalType superInter : this.interfaces) {
            if (!superInter.hasAncestorInterface(ancestor)) continue;
            return true;
        }
        return false;
    }

    public boolean addInterfaces(ImmutableSet<NominalType> interfaces) {
        Preconditions.checkState((!this.isNamespaceFinalized ? 1 : 0) != 0);
        Preconditions.checkState((this.interfaces == null ? 1 : 0) != 0);
        Preconditions.checkNotNull(interfaces);
        if (this.isInterface) {
            for (NominalType interf : interfaces) {
                if (!interf.hasAncestorInterface(this)) continue;
                this.interfaces = ImmutableSet.of();
                return false;
            }
        }
        this.interfaces = interfaces;
        return true;
    }

    public NominalType getSuperClass() {
        return this.superClass;
    }

    public ImmutableSet<NominalType> getInterfaces() {
        return this.interfaces == null ? ImmutableSet.of() : this.interfaces;
    }

    private Property getOwnProp(String pname) {
        Property p = (Property)this.classProps.get(pname);
        if (p != null) {
            return p;
        }
        p = (Property)this.randomProps.get(pname);
        if (p != null) {
            return p;
        }
        return (Property)this.protoProps.get(pname);
    }

    private Property getPropFromClass(String pname) {
        Preconditions.checkState((!this.isInterface ? 1 : 0) != 0);
        Property p = this.getOwnProp(pname);
        if (p != null) {
            return p;
        }
        if (this.superClass != null && (p = this.superClass.getProp(pname)) != null) {
            return p;
        }
        return null;
    }

    private Property getPropFromInterface(String pname) {
        Preconditions.checkState((boolean)this.isInterface);
        Property p = this.getOwnProp(pname);
        if (p != null) {
            return p;
        }
        if (this.interfaces != null) {
            for (NominalType interf : this.interfaces) {
                p = interf.getProp(pname);
                if (p == null) continue;
                return p;
            }
        }
        return null;
    }

    Property getProp(String pname) {
        if (this.isInterface) {
            return this.getPropFromInterface(pname);
        }
        return this.getPropFromClass(pname);
    }

    public boolean mayHaveOwnProp(String pname) {
        return this.getOwnProp(pname) != null;
    }

    public boolean mayHaveProp(String pname) {
        return this.getProp(pname) != null;
    }

    public JSType getInstancePropDeclaredType(String pname) {
        Property p = this.getProp(pname);
        if (p == null) {
            return null;
        }
        if (p.getDeclaredType() == null && this.superClass != null) {
            return this.superClass.getPropDeclaredType(pname);
        }
        return p.getDeclaredType();
    }

    public Set<String> getAllOwnProps() {
        LinkedHashSet<String> ownProps = new LinkedHashSet<String>();
        ownProps.addAll(this.classProps.keySet());
        ownProps.addAll(this.protoProps.keySet());
        return ownProps;
    }

    ImmutableSet<String> getAllPropsOfInterface() {
        Preconditions.checkState((boolean)this.isInterface);
        Preconditions.checkState((boolean)this.isRawTypeFinalized);
        if (this.allProps == null) {
            ImmutableSet.Builder builder = ImmutableSet.builder();
            if (this.interfaces != null) {
                for (NominalType interf : this.interfaces) {
                    builder.addAll(interf.getAllPropsOfInterface());
                }
            }
            this.allProps = builder.addAll(this.protoProps.keySet()).build();
        }
        return this.allProps;
    }

    ImmutableSet<String> getAllPropsOfClass() {
        Preconditions.checkState((!this.isInterface ? 1 : 0) != 0);
        Preconditions.checkState((boolean)this.isRawTypeFinalized);
        if (this.allProps == null) {
            ImmutableSet.Builder builder = ImmutableSet.builder();
            if (this.superClass != null) {
                builder.addAll(this.superClass.getAllPropsOfClass());
            }
            this.allProps = builder.addAll(this.classProps.keySet()).addAll(this.protoProps.keySet()).build();
        }
        return this.allProps;
    }

    public void addPropertyWhichMayNotBeOnAllInstances(String pname, JSType type) {
        Preconditions.checkState((!this.isRawTypeFinalized ? 1 : 0) != 0);
        if (this.classProps.containsKey(pname) || this.protoProps.containsKey(pname)) {
            return;
        }
        if (this.objectKind == ObjectKind.UNRESTRICTED) {
            this.randomProps = this.randomProps.with(pname, Property.make(type == null ? JSType.UNKNOWN : type, type));
        }
    }

    public void addClassProperty(String pname, Node defSite, JSType type, boolean isConstant) {
        Preconditions.checkState((!this.isRawTypeFinalized ? 1 : 0) != 0);
        if (type == null && isConstant) {
            type = JSType.UNKNOWN;
        }
        this.classProps = this.classProps.with(pname, isConstant ? Property.makeConstant(defSite, type, type) : Property.makeWithDefsite(defSite, type, type));
        if (this.protoProps.containsKey(pname)) {
            this.addProtoProperty(pname, defSite, type, isConstant);
        }
        if (this.randomProps.containsKey(pname)) {
            this.randomProps = this.randomProps.without(pname);
        }
    }

    public void addUndeclaredClassProperty(String pname, Node defSite) {
        Preconditions.checkState((!this.isRawTypeFinalized ? 1 : 0) != 0);
        if (this.mayHaveProp(pname)) {
            return;
        }
        this.classProps = this.classProps.with(pname, Property.makeWithDefsite(defSite, JSType.UNKNOWN, null));
    }

    public void addProtoProperty(String pname, Node defSite, JSType type, boolean isConstant) {
        Preconditions.checkState((!this.isRawTypeFinalized ? 1 : 0) != 0);
        if (type == null && isConstant) {
            type = JSType.UNKNOWN;
        }
        if (this.classProps.containsKey(pname) && ((Property)this.classProps.get(pname)).getDeclaredType() == null) {
            this.classProps = this.classProps.without(pname);
        }
        if (this.randomProps.containsKey(pname)) {
            this.randomProps = this.randomProps.without(pname);
        }
        this.protoProps = this.protoProps.with(pname, isConstant ? Property.makeConstant(defSite, type, type) : Property.makeWithDefsite(defSite, type, type));
    }

    public void addUndeclaredProtoProperty(String pname, Node defSite) {
        Preconditions.checkState((!this.isNamespaceFinalized ? 1 : 0) != 0);
        if (!this.protoProps.containsKey(pname) || ((Property)this.protoProps.get(pname)).getDeclaredType() == null) {
            this.protoProps = this.protoProps.with(pname, Property.makeWithDefsite(defSite, JSType.UNKNOWN, null));
            if (this.randomProps.containsKey(pname)) {
                this.randomProps = this.randomProps.without(pname);
            }
        }
    }

    private JSType createProtoObject() {
        return JSType.fromObjectType(ObjectType.makeObjectType(this.superClass, this.protoProps, null, false, ObjectKind.UNRESTRICTED));
    }

    public boolean hasCtorProp(String pname) {
        return super.hasProp(pname);
    }

    public void addCtorProperty(String pname, Node defSite, JSType type, boolean isConstant) {
        Preconditions.checkState((!this.isNamespaceFinalized ? 1 : 0) != 0);
        super.addProperty(pname, defSite, type, isConstant);
    }

    public void addUndeclaredCtorProperty(String pname, Node defSite) {
        Preconditions.checkState((!this.isNamespaceFinalized ? 1 : 0) != 0);
        super.addUndeclaredProperty(pname, defSite, JSType.UNKNOWN, false);
    }

    public JSType getCtorPropDeclaredType(String pname) {
        return super.getPropDeclaredType(pname);
    }

    JSType getConstructorObject(FunctionType ctorFn) {
        Preconditions.checkState((boolean)this.isNamespaceFinalized);
        if (this.ctorFn != ctorFn || this.namespaceType == null) {
            ObjectType ctorFnAsObj = ObjectType.makeObjectType(this.commonTypes.getFunctionType(), this.otherProps, ctorFn, ctorFn.isLoose(), ObjectKind.UNRESTRICTED);
            return this.withNamedTypes(this.commonTypes, ctorFnAsObj);
        }
        return this.namespaceType;
    }

    @Override
    public boolean finalizeNamespace(Node constDeclNode) {
        if (this.isNamespaceFinalized) {
            return true;
        }
        if (this.ctorFn == null) {
            return false;
        }
        this.addCtorProperty("prototype", null, this.createProtoObject(), false);
        this.constDeclNode = constDeclNode;
        this.isNamespaceFinalized = true;
        boolean success = this.finalizeSubnamespaces(constDeclNode);
        if (this.superClass != null) {
            boolean bl = success = success && this.superClass.finalizeNamespace(constDeclNode);
        }
        if (this.interfaces != null) {
            for (NominalType interf : this.interfaces) {
                success = success && interf.finalizeNamespace(constDeclNode);
            }
        }
        return success;
    }

    public void finalizeRawType() {
        Preconditions.checkState((!this.isRawTypeFinalized ? 1 : 0) != 0);
        if (!this.isNamespaceFinalized) {
            this.finalizeNamespace(null);
        }
        if (this.interfaces == null) {
            this.interfaces = ImmutableSet.of();
        }
        this.isRawTypeFinalized = true;
    }

    StringBuilder appendTo(StringBuilder builder) {
        builder.append(this.name);
        if (!this.typeParameters.isEmpty()) {
            builder.append("<" + Joiner.on((String)",").join(this.typeParameters) + ">");
        }
        return builder;
    }

    public String toString() {
        return this.appendTo(new StringBuilder()).toString();
    }

    @Override
    protected JSType computeJSType(JSTypes commonTypes) {
        return this.getConstructorObject(this.ctorFn);
    }

    public NominalType getAsNominalType() {
        return this.wrappedAsNominal;
    }

    public JSType getInstanceAsJSType() {
        return this.wrappedAsJSType;
    }

    public JSType getInstanceWithNullability(boolean includeNull) {
        return includeNull ? this.wrappedAsNullableJSType : this.wrappedAsJSType;
    }
}

