/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp.parsing.parser;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableList;
import com.google.javascript.jscomp.parsing.parser.IdentifierToken;
import com.google.javascript.jscomp.parsing.parser.Keywords;
import com.google.javascript.jscomp.parsing.parser.LiteralToken;
import com.google.javascript.jscomp.parsing.parser.Scanner;
import com.google.javascript.jscomp.parsing.parser.SourceFile;
import com.google.javascript.jscomp.parsing.parser.Token;
import com.google.javascript.jscomp.parsing.parser.TokenType;
import com.google.javascript.jscomp.parsing.parser.trees.AmbientDeclarationTree;
import com.google.javascript.jscomp.parsing.parser.trees.ArgumentListTree;
import com.google.javascript.jscomp.parsing.parser.trees.ArrayLiteralExpressionTree;
import com.google.javascript.jscomp.parsing.parser.trees.ArrayPatternTree;
import com.google.javascript.jscomp.parsing.parser.trees.ArrayTypeTree;
import com.google.javascript.jscomp.parsing.parser.trees.AssignmentRestElementTree;
import com.google.javascript.jscomp.parsing.parser.trees.BinaryOperatorTree;
import com.google.javascript.jscomp.parsing.parser.trees.BlockTree;
import com.google.javascript.jscomp.parsing.parser.trees.BreakStatementTree;
import com.google.javascript.jscomp.parsing.parser.trees.CallExpressionTree;
import com.google.javascript.jscomp.parsing.parser.trees.CallSignatureTree;
import com.google.javascript.jscomp.parsing.parser.trees.CaseClauseTree;
import com.google.javascript.jscomp.parsing.parser.trees.CatchTree;
import com.google.javascript.jscomp.parsing.parser.trees.ClassDeclarationTree;
import com.google.javascript.jscomp.parsing.parser.trees.CommaExpressionTree;
import com.google.javascript.jscomp.parsing.parser.trees.Comment;
import com.google.javascript.jscomp.parsing.parser.trees.ComprehensionForTree;
import com.google.javascript.jscomp.parsing.parser.trees.ComprehensionIfTree;
import com.google.javascript.jscomp.parsing.parser.trees.ComprehensionTree;
import com.google.javascript.jscomp.parsing.parser.trees.ComputedPropertyDefinitionTree;
import com.google.javascript.jscomp.parsing.parser.trees.ComputedPropertyGetterTree;
import com.google.javascript.jscomp.parsing.parser.trees.ComputedPropertyMemberVariableTree;
import com.google.javascript.jscomp.parsing.parser.trees.ComputedPropertyMethodTree;
import com.google.javascript.jscomp.parsing.parser.trees.ComputedPropertySetterTree;
import com.google.javascript.jscomp.parsing.parser.trees.ConditionalExpressionTree;
import com.google.javascript.jscomp.parsing.parser.trees.ContinueStatementTree;
import com.google.javascript.jscomp.parsing.parser.trees.DebuggerStatementTree;
import com.google.javascript.jscomp.parsing.parser.trees.DefaultClauseTree;
import com.google.javascript.jscomp.parsing.parser.trees.DefaultParameterTree;
import com.google.javascript.jscomp.parsing.parser.trees.DoWhileStatementTree;
import com.google.javascript.jscomp.parsing.parser.trees.EmptyStatementTree;
import com.google.javascript.jscomp.parsing.parser.trees.EnumDeclarationTree;
import com.google.javascript.jscomp.parsing.parser.trees.ExportDeclarationTree;
import com.google.javascript.jscomp.parsing.parser.trees.ExportSpecifierTree;
import com.google.javascript.jscomp.parsing.parser.trees.ExpressionStatementTree;
import com.google.javascript.jscomp.parsing.parser.trees.FinallyTree;
import com.google.javascript.jscomp.parsing.parser.trees.ForInStatementTree;
import com.google.javascript.jscomp.parsing.parser.trees.ForOfStatementTree;
import com.google.javascript.jscomp.parsing.parser.trees.ForStatementTree;
import com.google.javascript.jscomp.parsing.parser.trees.FormalParameterListTree;
import com.google.javascript.jscomp.parsing.parser.trees.FunctionDeclarationTree;
import com.google.javascript.jscomp.parsing.parser.trees.FunctionTypeTree;
import com.google.javascript.jscomp.parsing.parser.trees.GenericTypeListTree;
import com.google.javascript.jscomp.parsing.parser.trees.GetAccessorTree;
import com.google.javascript.jscomp.parsing.parser.trees.IdentifierExpressionTree;
import com.google.javascript.jscomp.parsing.parser.trees.IfStatementTree;
import com.google.javascript.jscomp.parsing.parser.trees.ImportDeclarationTree;
import com.google.javascript.jscomp.parsing.parser.trees.ImportSpecifierTree;
import com.google.javascript.jscomp.parsing.parser.trees.IndexSignatureTree;
import com.google.javascript.jscomp.parsing.parser.trees.InterfaceDeclarationTree;
import com.google.javascript.jscomp.parsing.parser.trees.LabelledStatementTree;
import com.google.javascript.jscomp.parsing.parser.trees.LiteralExpressionTree;
import com.google.javascript.jscomp.parsing.parser.trees.MemberExpressionTree;
import com.google.javascript.jscomp.parsing.parser.trees.MemberLookupExpressionTree;
import com.google.javascript.jscomp.parsing.parser.trees.MemberVariableTree;
import com.google.javascript.jscomp.parsing.parser.trees.MissingPrimaryExpressionTree;
import com.google.javascript.jscomp.parsing.parser.trees.NewExpressionTree;
import com.google.javascript.jscomp.parsing.parser.trees.NullTree;
import com.google.javascript.jscomp.parsing.parser.trees.ObjectLiteralExpressionTree;
import com.google.javascript.jscomp.parsing.parser.trees.ObjectPatternTree;
import com.google.javascript.jscomp.parsing.parser.trees.OptionalParameterTree;
import com.google.javascript.jscomp.parsing.parser.trees.ParameterizedTypeTree;
import com.google.javascript.jscomp.parsing.parser.trees.ParenExpressionTree;
import com.google.javascript.jscomp.parsing.parser.trees.ParseTree;
import com.google.javascript.jscomp.parsing.parser.trees.ParseTreeType;
import com.google.javascript.jscomp.parsing.parser.trees.PostfixExpressionTree;
import com.google.javascript.jscomp.parsing.parser.trees.ProgramTree;
import com.google.javascript.jscomp.parsing.parser.trees.PropertyNameAssignmentTree;
import com.google.javascript.jscomp.parsing.parser.trees.RecordTypeTree;
import com.google.javascript.jscomp.parsing.parser.trees.RestParameterTree;
import com.google.javascript.jscomp.parsing.parser.trees.ReturnStatementTree;
import com.google.javascript.jscomp.parsing.parser.trees.SetAccessorTree;
import com.google.javascript.jscomp.parsing.parser.trees.SpreadExpressionTree;
import com.google.javascript.jscomp.parsing.parser.trees.SuperExpressionTree;
import com.google.javascript.jscomp.parsing.parser.trees.SwitchStatementTree;
import com.google.javascript.jscomp.parsing.parser.trees.TemplateLiteralExpressionTree;
import com.google.javascript.jscomp.parsing.parser.trees.TemplateLiteralPortionTree;
import com.google.javascript.jscomp.parsing.parser.trees.TemplateSubstitutionTree;
import com.google.javascript.jscomp.parsing.parser.trees.ThisExpressionTree;
import com.google.javascript.jscomp.parsing.parser.trees.ThrowStatementTree;
import com.google.javascript.jscomp.parsing.parser.trees.TryStatementTree;
import com.google.javascript.jscomp.parsing.parser.trees.TypeAliasTree;
import com.google.javascript.jscomp.parsing.parser.trees.TypeNameTree;
import com.google.javascript.jscomp.parsing.parser.trees.TypeQueryTree;
import com.google.javascript.jscomp.parsing.parser.trees.TypedParameterTree;
import com.google.javascript.jscomp.parsing.parser.trees.UnaryExpressionTree;
import com.google.javascript.jscomp.parsing.parser.trees.UnionTypeTree;
import com.google.javascript.jscomp.parsing.parser.trees.VariableDeclarationListTree;
import com.google.javascript.jscomp.parsing.parser.trees.VariableDeclarationTree;
import com.google.javascript.jscomp.parsing.parser.trees.VariableStatementTree;
import com.google.javascript.jscomp.parsing.parser.trees.WhileStatementTree;
import com.google.javascript.jscomp.parsing.parser.trees.WithStatementTree;
import com.google.javascript.jscomp.parsing.parser.trees.YieldExpressionTree;
import com.google.javascript.jscomp.parsing.parser.util.ErrorReporter;
import com.google.javascript.jscomp.parsing.parser.util.LookaheadErrorReporter;
import com.google.javascript.jscomp.parsing.parser.util.SourcePosition;
import com.google.javascript.jscomp.parsing.parser.util.SourceRange;
import com.google.javascript.jscomp.parsing.parser.util.Timer;
import java.util.ArrayDeque;
import java.util.EnumSet;
import java.util.LinkedHashMap;
import java.util.List;

public class Parser {
    private final Scanner scanner;
    private final ErrorReporter errorReporter;
    private Token lastToken;
    private final Config config;
    private final CommentRecorder commentRecorder = new CommentRecorder();
    private final ArrayDeque<Boolean> inGeneratorContext = new ArrayDeque();
    private static final EnumSet<TokenType> assignmentFollowSet = EnumSet.of(TokenType.EQUAL);

    public Parser(Config config, ErrorReporter errorReporter, SourceFile source, int offset, boolean initialGeneratorContext) {
        this.config = config;
        this.errorReporter = errorReporter;
        this.scanner = new Scanner(errorReporter, this.commentRecorder, source, offset);
        this.inGeneratorContext.add(initialGeneratorContext);
    }

    public Parser(Config config, ErrorReporter errorReporter, SourceFile source, int offset) {
        this(config, errorReporter, source, offset, false);
    }

    public Parser(Config config, ErrorReporter errorReporter, SourceFile source) {
        this(config, errorReporter, source, 0);
    }

    public List<Comment> getComments() {
        return this.commentRecorder.getComments();
    }

    public ProgramTree parseProgram() {
        Timer t = new Timer("Parse Program");
        try {
            SourcePosition start = this.getTreeStartLocation();
            ImmutableList<ParseTree> sourceElements = this.parseGlobalSourceElements();
            this.eat(TokenType.END_OF_FILE);
            t.end();
            return new ProgramTree(this.getTreeLocation(start), sourceElements, (ImmutableList<Comment>)this.commentRecorder.getComments());
        }
        catch (StackOverflowError e) {
            this.reportError("Too deep recursion while parsing", new Object[0]);
            return null;
        }
    }

    private ImmutableList<ParseTree> parseGlobalSourceElements() {
        ImmutableList.Builder result = ImmutableList.builder();
        while (!this.peek(TokenType.END_OF_FILE)) {
            result.add((Object)this.parseScriptElement());
        }
        return result.build();
    }

    private ParseTree parseScriptElement() {
        if (this.peekImportDeclaration()) {
            return this.parseImportDeclaration();
        }
        if (this.peekExportDeclaration()) {
            return this.parseExportDeclaration();
        }
        if (this.peekInterfaceDeclaration()) {
            return this.parseInterfaceDeclaration();
        }
        if (this.peekEnumDeclaration()) {
            return this.parseEnumDeclaration();
        }
        if (this.peekTypeAlias()) {
            return this.parseTypeAlias();
        }
        if (this.peekAmbientDeclaration()) {
            return this.parseAmbientDeclaration();
        }
        return this.parseSourceElement();
    }

    private boolean peekImportDeclaration() {
        return this.peek(TokenType.IMPORT);
    }

    private ParseTree parseImportDeclaration() {
        SourcePosition start = this.getTreeStartLocation();
        this.eat(TokenType.IMPORT);
        if (this.peek(TokenType.STRING)) {
            LiteralToken moduleSpecifier = this.eat(TokenType.STRING).asLiteral();
            this.eatPossibleImplicitSemiColon();
            return new ImportDeclarationTree(this.getTreeLocation(start), null, null, null, moduleSpecifier);
        }
        IdentifierToken defaultBindingIdentifier = null;
        IdentifierToken nameSpaceImportIdentifier = null;
        ImmutableList<ParseTree> identifierSet = null;
        boolean parseExplicitNames = true;
        if (this.peekId()) {
            defaultBindingIdentifier = this.eatId();
            if (this.peek(TokenType.COMMA)) {
                this.eat(TokenType.COMMA);
            } else {
                parseExplicitNames = false;
            }
        }
        if (parseExplicitNames) {
            if (this.peek(TokenType.STAR)) {
                this.eat(TokenType.STAR);
                this.eatPredefinedString("as");
                nameSpaceImportIdentifier = this.eatId();
            } else {
                identifierSet = this.parseImportSpecifierSet();
            }
        }
        this.eatPredefinedString("from");
        Token moduleStr = this.eat(TokenType.STRING);
        LiteralToken moduleSpecifier = moduleStr == null ? null : moduleStr.asLiteral();
        this.eatPossibleImplicitSemiColon();
        return new ImportDeclarationTree(this.getTreeLocation(start), defaultBindingIdentifier, identifierSet, nameSpaceImportIdentifier, moduleSpecifier);
    }

    private ImmutableList<ParseTree> parseImportSpecifierSet() {
        ImmutableList.Builder elements = ImmutableList.builder();
        this.eat(TokenType.OPEN_CURLY);
        while (this.peekId()) {
            elements.add((Object)this.parseImportSpecifier());
            if (this.peek(TokenType.CLOSE_CURLY)) continue;
            this.eat(TokenType.COMMA);
        }
        this.eat(TokenType.CLOSE_CURLY);
        return elements.build();
    }

    private ParseTree parseImportSpecifier() {
        SourcePosition start = this.getTreeStartLocation();
        IdentifierToken importedName = this.eatId();
        IdentifierToken destinationName = null;
        if (this.peekPredefinedString("as")) {
            this.eatPredefinedString("as");
            destinationName = this.eatId();
        }
        return new ImportSpecifierTree(this.getTreeLocation(start), importedName, destinationName);
    }

    private boolean peekExportDeclaration() {
        return this.peek(TokenType.EXPORT);
    }

    private ParseTree parseExportDeclaration() {
        SourcePosition start = this.getTreeStartLocation();
        boolean isDefault = false;
        boolean isExportAll = false;
        boolean isExportSpecifier = false;
        this.eat(TokenType.EXPORT);
        ParseTree export = null;
        ImmutableList<ParseTree> exportSpecifierList = null;
        switch (this.peekType()) {
            case STAR: {
                isExportAll = true;
                this.nextToken();
                break;
            }
            case FUNCTION: {
                export = this.parseFunctionDeclaration();
                break;
            }
            case CLASS: {
                export = this.parseClassDeclaration(false);
                break;
            }
            case DEFAULT: {
                isDefault = true;
                this.nextToken();
                export = this.parseExpression();
                break;
            }
            case OPEN_CURLY: {
                isExportSpecifier = true;
                exportSpecifierList = this.parseExportSpecifierSet();
                break;
            }
            default: {
                export = this.parseVariableDeclarationList();
            }
        }
        LiteralToken moduleSpecifier = null;
        if (isExportAll || isExportSpecifier && this.peekPredefinedString("from")) {
            this.eatPredefinedString("from");
            moduleSpecifier = this.eat(TokenType.STRING).asLiteral();
        }
        this.eatPossibleImplicitSemiColon();
        return new ExportDeclarationTree(this.getTreeLocation(start), isDefault, isExportAll, export, exportSpecifierList, moduleSpecifier);
    }

    private ImmutableList<ParseTree> parseExportSpecifierSet() {
        ImmutableList.Builder elements = ImmutableList.builder();
        this.eat(TokenType.OPEN_CURLY);
        while (this.peekId()) {
            elements.add((Object)this.parseExportSpecifier());
            if (this.peek(TokenType.CLOSE_CURLY)) continue;
            this.eat(TokenType.COMMA);
        }
        this.eat(TokenType.CLOSE_CURLY);
        return elements.build();
    }

    private ParseTree parseExportSpecifier() {
        SourcePosition start = this.getTreeStartLocation();
        IdentifierToken importedName = this.eatId();
        IdentifierToken destinationName = null;
        if (this.peekPredefinedString("as")) {
            this.eatPredefinedString("as");
            destinationName = this.eatId();
        }
        return new ExportSpecifierTree(this.getTreeLocation(start), importedName, destinationName);
    }

    private boolean peekClassDeclaration() {
        return this.peek(TokenType.CLASS);
    }

    private boolean peekInterfaceDeclaration() {
        return this.peek(TokenType.INTERFACE);
    }

    private boolean peekEnumDeclaration() {
        return this.peek(TokenType.ENUM);
    }

    private ParseTree parseClassDeclaration(boolean isAmbient) {
        return this.parseClass(false, isAmbient);
    }

    private ParseTree parseClassExpression() {
        return this.parseClass(true, false);
    }

    private ParseTree parseInterfaceDeclaration() {
        SourcePosition start = this.getTreeStartLocation();
        this.eat(TokenType.INTERFACE);
        IdentifierToken name = this.eatId();
        GenericTypeListTree generics = this.maybeParseGenericTypes();
        ImmutableList.Builder superTypes = ImmutableList.builder();
        if (this.peek(TokenType.EXTENDS)) {
            this.eat(TokenType.EXTENDS);
            ParseTree type = this.parseType();
            superTypes.add((Object)type);
            while (this.peek(TokenType.COMMA)) {
                this.eat(TokenType.COMMA);
                type = this.parseType();
                if (type == null) continue;
                superTypes.add((Object)type);
            }
        }
        this.eat(TokenType.OPEN_CURLY);
        ImmutableList<ParseTree> elements = this.parseInterfaceElements();
        this.eat(TokenType.CLOSE_CURLY);
        return new InterfaceDeclarationTree(this.getTreeLocation(start), name, generics, (ImmutableList<ParseTree>)superTypes.build(), elements);
    }

    private ImmutableList<ParseTree> parseInterfaceElements() {
        ImmutableList.Builder result = ImmutableList.builder();
        while (this.peekInterfaceElement()) {
            result.add((Object)this.parseInterfaceElement());
            if (this.peek(TokenType.CLOSE_CURLY)) continue;
            if (this.peekImplicitSemiColon()) {
                this.eatPossibleImplicitSemiColon();
                continue;
            }
            this.eat(TokenType.COMMA);
        }
        return result.build();
    }

    private boolean peekInterfaceElement() {
        Token token = this.peekToken();
        switch (token.type) {
            case STAR: 
            case NEW: 
            case IDENTIFIER: 
            case OPEN_SQUARE: 
            case OPEN_ANGLE: 
            case OPEN_PAREN: {
                return true;
            }
        }
        return Keywords.isKeyword(token.type);
    }

    private ParseTree parseInterfaceElement() {
        SourcePosition start = this.getTreeStartLocation();
        boolean isGenerator = this.eatOpt(TokenType.STAR) != null;
        IdentifierToken name = null;
        TokenType type = this.peekType();
        if (type == TokenType.NEW) {
            return this.parseCallSignature(true);
        }
        if (type == TokenType.IDENTIFIER || Keywords.isKeyword(type)) {
            name = this.eatIdOrKeywordAsId();
        } else {
            if (type == TokenType.OPEN_SQUARE) {
                return this.parseIndexSignature();
            }
            if (type == TokenType.OPEN_ANGLE || type == TokenType.OPEN_PAREN) {
                return this.parseCallSignature(false);
            }
        }
        boolean isOptional = false;
        if (this.peek(TokenType.QUESTION)) {
            this.eat(TokenType.QUESTION);
            isOptional = true;
        }
        if (this.peek(TokenType.OPEN_PAREN) || this.peek(TokenType.OPEN_ANGLE)) {
            FunctionDeclarationTree function = this.parseMethodSignature(start, name, false, isGenerator, isOptional, null);
            return function;
        }
        ParseTree declaredType = this.maybeParseColonType();
        return new MemberVariableTree(this.getTreeLocation(start), name, false, isOptional, null, declaredType);
    }

    private ParseTree parseEnumDeclaration() {
        SourcePosition start = this.getTreeStartLocation();
        this.eat(TokenType.ENUM);
        IdentifierToken name = this.eatId();
        this.eat(TokenType.OPEN_CURLY);
        ImmutableList<ParseTree> members = this.parseEnumMembers();
        this.eat(TokenType.CLOSE_CURLY);
        return new EnumDeclarationTree(this.getTreeLocation(start), name, members);
    }

    private ImmutableList<ParseTree> parseEnumMembers() {
        SourceRange range = this.getTreeLocation(this.getTreeStartLocation());
        PropertyNameAssignmentTree member = null;
        ImmutableList.Builder result = ImmutableList.builder();
        while (this.peekId()) {
            IdentifierToken propertyName = this.parseIdentifierExpression().identifierToken;
            member = new PropertyNameAssignmentTree(range, propertyName, null);
            result.add((Object)member);
            if (this.peek(TokenType.CLOSE_CURLY)) continue;
            this.eat(TokenType.COMMA);
        }
        return result.build();
    }

    private ParseTree parseClass(boolean isExpression, boolean isAmbient) {
        SourcePosition start = this.getTreeStartLocation();
        this.eat(TokenType.CLASS);
        IdentifierToken name = null;
        if (!isExpression || this.peekId()) {
            name = this.eatId();
        }
        GenericTypeListTree generics = this.maybeParseGenericTypes();
        ParseTree superClass = null;
        if (this.peek(TokenType.EXTENDS)) {
            this.eat(TokenType.EXTENDS);
            superClass = this.parseExpression();
        }
        ImmutableList.Builder interfaces = ImmutableList.builder();
        if (this.peek(TokenType.IMPLEMENTS)) {
            this.eat(TokenType.IMPLEMENTS);
            ParseTree type = this.parseType();
            interfaces.add((Object)type);
            while (this.peek(TokenType.COMMA)) {
                this.eat(TokenType.COMMA);
                type = this.parseType();
                if (type == null) continue;
                interfaces.add((Object)type);
            }
        }
        this.eat(TokenType.OPEN_CURLY);
        ImmutableList<ParseTree> elements = this.parseClassElements(isAmbient);
        this.eat(TokenType.CLOSE_CURLY);
        return new ClassDeclarationTree(this.getTreeLocation(start), name, generics, superClass, (ImmutableList<ParseTree>)interfaces.build(), elements);
    }

    private ImmutableList<ParseTree> parseClassElements(boolean isAmbient) {
        ImmutableList.Builder result = ImmutableList.builder();
        while (this.peekClassElement()) {
            result.add((Object)this.parseClassElement(isAmbient));
        }
        return result.build();
    }

    private boolean peekClassElement() {
        Token token = this.peekToken();
        switch (token.type) {
            case STAR: 
            case IDENTIFIER: 
            case OPEN_SQUARE: 
            case STATIC: 
            case SEMI_COLON: {
                return true;
            }
        }
        return Keywords.isKeyword(token.type);
    }

    private ParseTree parseClassElement(boolean isAmbient) {
        TokenType access = this.maybeParseAccessibilityModifier();
        if (this.peek(TokenType.SEMI_COLON)) {
            return this.parseEmptyStatement();
        }
        if (this.peekGetAccessor(true)) {
            return this.parseGetAccessor(access);
        }
        if (this.peekSetAccessor(true)) {
            return this.parseSetAccessor(access);
        }
        return this.parseClassMemberDeclaration(true, isAmbient, access);
    }

    private ParseTree parseClassMemberDeclaration(boolean allowStatic, boolean isAmbient, TokenType access) {
        IdentifierToken name;
        ParseTree nameExpr;
        SourcePosition start = this.getTreeStartLocation();
        boolean isStatic = false;
        if (allowStatic && this.peek(TokenType.STATIC) && this.peekType(1) != TokenType.OPEN_PAREN) {
            this.eat(TokenType.STATIC);
            isStatic = true;
        }
        boolean isGenerator = this.eatOpt(TokenType.STAR) != null;
        TokenType type = this.peekType();
        if (type == TokenType.IDENTIFIER || Keywords.isKeyword(type)) {
            nameExpr = null;
            name = this.eatIdOrKeywordAsId();
        } else {
            if (this.peekIndexSignature()) {
                IndexSignatureTree indexSignature = this.parseIndexSignature();
                this.eatPossibleImplicitSemiColon();
                return indexSignature;
            }
            nameExpr = this.parseComputedPropertyName();
            name = null;
        }
        if (this.peek(TokenType.OPEN_PAREN) || this.peek(TokenType.OPEN_ANGLE)) {
            FunctionDeclarationTree function;
            TokenType accessOnFunction;
            FunctionDeclarationTree.Kind kind;
            if (nameExpr == null) {
                kind = FunctionDeclarationTree.Kind.MEMBER;
                accessOnFunction = access;
            } else {
                kind = FunctionDeclarationTree.Kind.EXPRESSION;
                accessOnFunction = null;
            }
            if (isAmbient) {
                function = this.parseMethodSignature(start, name, isStatic, isGenerator, false, accessOnFunction);
                this.eatPossibleImplicitSemiColon();
            } else {
                function = this.parseFunctionTail(start, name, isStatic, isGenerator, accessOnFunction, kind);
            }
            if (kind == FunctionDeclarationTree.Kind.MEMBER) {
                return function;
            }
            return new ComputedPropertyMethodTree(this.getTreeLocation(start), access, nameExpr, function);
        }
        if (isGenerator) {
            this.reportError("Member variable cannot be prefixed by '*' (generator function)", new Object[0]);
        }
        ParseTree declaredType = this.maybeParseColonType();
        if (this.peek(TokenType.EQUAL)) {
            this.reportError("Member variable initializers ('=') are not supported", new Object[0]);
        }
        this.eatPossibleImplicitSemiColon();
        if (nameExpr == null) {
            return new MemberVariableTree(this.getTreeLocation(start), name, isStatic, false, access, declaredType);
        }
        return new ComputedPropertyMemberVariableTree(this.getTreeLocation(start), nameExpr, isStatic, access, declaredType);
    }

    private FunctionDeclarationTree parseMethodSignature(SourcePosition start, IdentifierToken name, boolean isStatic, boolean isGenerator, boolean isOptional, TokenType access) {
        GenericTypeListTree generics = this.maybeParseGenericTypes();
        FormalParameterListTree formalParameterList = this.parseFormalParameterList(ParamContext.SIGNATURE);
        ParseTree returnType = this.maybeParseColonType();
        EmptyStatementTree functionBody = new EmptyStatementTree(this.getTreeLocation(start));
        FunctionDeclarationTree declaration = new FunctionDeclarationTree(this.getTreeLocation(start), name, generics, isStatic, isGenerator, isOptional, access, FunctionDeclarationTree.Kind.MEMBER, formalParameterList, returnType, functionBody);
        return declaration;
    }

    private FunctionDeclarationTree parseAmbientFunctionDeclaration(SourcePosition start, IdentifierToken name, boolean isGenerator) {
        GenericTypeListTree generics = this.maybeParseGenericTypes();
        FormalParameterListTree formalParameterList = this.parseFormalParameterList(ParamContext.SIGNATURE);
        ParseTree returnType = this.maybeParseColonType();
        EmptyStatementTree functionBody = new EmptyStatementTree(this.getTreeLocation(start));
        FunctionDeclarationTree declaration = new FunctionDeclarationTree(this.getTreeLocation(start), name, generics, false, isGenerator, false, null, FunctionDeclarationTree.Kind.DECLARATION, formalParameterList, returnType, functionBody);
        return declaration;
    }

    private FunctionDeclarationTree parseFunctionTail(SourcePosition start, IdentifierToken name, boolean isStatic, boolean isGenerator, TokenType access, FunctionDeclarationTree.Kind kind) {
        this.inGeneratorContext.addLast(isGenerator);
        GenericTypeListTree generics = this.maybeParseGenericTypes();
        FormalParameterListTree formalParameterList = this.parseFormalParameterList(ParamContext.IMPLEMENTATION);
        ParseTree returnType = this.maybeParseColonType();
        BlockTree functionBody = this.parseFunctionBody();
        FunctionDeclarationTree declaration = new FunctionDeclarationTree(this.getTreeLocation(start), name, generics, isStatic, isGenerator, false, access, kind, formalParameterList, returnType, functionBody);
        this.inGeneratorContext.removeLast();
        return declaration;
    }

    private ParseTree parseSourceElement() {
        if (this.peekFunction()) {
            return this.parseFunctionDeclaration();
        }
        if (this.peekClassDeclaration()) {
            return this.parseClassDeclaration(false);
        }
        if (this.peek(TokenType.LET)) {
            return this.parseVariableStatement();
        }
        return this.parseStatementStandard();
    }

    private boolean peekSourceElement() {
        return this.peekFunction() || this.peekStatementStandard() || this.peekDeclaration();
    }

    private boolean peekFunction() {
        return this.peekFunction(0);
    }

    private boolean peekDeclaration() {
        return this.peek(TokenType.LET) || this.peekClassDeclaration();
    }

    private boolean peekTypeAlias() {
        return this.peek(TokenType.TYPE) && !this.peekImplicitSemiColon(1) && this.peek(1, TokenType.IDENTIFIER) && this.peek(2, TokenType.EQUAL);
    }

    private boolean peekIndexSignature() {
        return this.peek(TokenType.OPEN_SQUARE) && this.peek(1, TokenType.IDENTIFIER) && this.peek(2, TokenType.COLON);
    }

    private IndexSignatureTree parseIndexSignature() {
        SourcePosition start = this.getTreeStartLocation();
        this.eat(TokenType.OPEN_SQUARE);
        IdentifierToken name = this.eatIdOrKeywordAsId();
        this.eat(TokenType.COLON);
        TypeNameTree indexType = this.parseTypeName();
        this.eat(TokenType.CLOSE_SQUARE);
        this.eat(TokenType.COLON);
        ParseTree declaredType = this.parseType();
        MemberVariableTree nameTree = new MemberVariableTree(this.getTreeLocation(start), name, false, false, null, indexType);
        return new IndexSignatureTree(this.getTreeLocation(start), nameTree, declaredType);
    }

    private CallSignatureTree parseCallSignature(boolean isNew) {
        SourcePosition start = this.getTreeStartLocation();
        if (isNew) {
            this.eat(TokenType.NEW);
        }
        GenericTypeListTree generics = this.maybeParseGenericTypes();
        FormalParameterListTree params = this.parseFormalParameterList(ParamContext.SIGNATURE);
        ParseTree returnType = this.maybeParseColonType();
        return new CallSignatureTree(this.getTreeLocation(start), isNew, generics, params, returnType);
    }

    private boolean peekAmbientDeclaration() {
        return this.peek(TokenType.DECLARE) && !this.peekImplicitSemiColon(1) && (this.peek(1, TokenType.VAR) || this.peek(1, TokenType.LET) || this.peek(1, TokenType.CONST) || this.peek(1, TokenType.FUNCTION) || this.peek(1, TokenType.CLASS) || this.peek(1, TokenType.ENUM));
    }

    private boolean peekFunction(int index) {
        return this.peek(index, TokenType.FUNCTION);
    }

    private ParseTree parseArrowFunction(Expression expressionIn) {
        FormalParameterListTree formalParameterList;
        SourcePosition start = this.getTreeStartLocation();
        this.inGeneratorContext.addLast(false);
        GenericTypeListTree generics = this.maybeParseGenericTypes();
        if (this.peekId()) {
            IdentifierExpressionTree param = this.parseIdentifierExpression();
            formalParameterList = new FormalParameterListTree(this.getTreeLocation(start), (ImmutableList<ParseTree>)ImmutableList.of((Object)param));
        } else {
            formalParameterList = this.parseFormalParameterList(ParamContext.IMPLEMENTATION);
        }
        ParseTree returnType = null;
        if (this.peek(TokenType.COLON)) {
            returnType = this.parseTypeAnnotation();
        }
        if (this.peekImplicitSemiColon()) {
            this.reportError("No newline allowed before '=>'", new Object[0]);
        }
        this.eat(TokenType.ARROW);
        ParseTree functionBody = this.peek(TokenType.OPEN_CURLY) ? this.parseFunctionBody() : this.parseAssignment(expressionIn);
        FunctionDeclarationTree declaration = new FunctionDeclarationTree(this.getTreeLocation(start), null, generics, false, false, false, null, FunctionDeclarationTree.Kind.ARROW, formalParameterList, returnType, functionBody);
        this.inGeneratorContext.removeLast();
        return declaration;
    }

    private boolean peekArrowFunction() {
        if (this.peekId() && this.peekType(1) == TokenType.ARROW) {
            return true;
        }
        return this.peekArrowFunctionWithParenthesizedParameterList(ParamContext.IMPLEMENTATION);
    }

    private boolean peekArrowFunctionWithParenthesizedParameterList(ParamContext context) {
        if (this.peek(TokenType.OPEN_PAREN) || this.peek(TokenType.OPEN_ANGLE)) {
            Parser p = this.createLookaheadParser();
            try {
                p.maybeParseGenericTypes();
                p.parseFormalParameterList(context);
                if (p.peek(TokenType.COLON)) {
                    p.parseTypeAnnotation();
                }
                return p.peek(TokenType.ARROW);
            }
            catch (LookaheadErrorReporter.ParseException e) {
                return false;
            }
        }
        return false;
    }

    private ParseTree parseFunctionDeclaration() {
        SourcePosition start = this.getTreeStartLocation();
        this.eat(Keywords.FUNCTION.type);
        boolean isGenerator = this.eatOpt(TokenType.STAR) != null;
        IdentifierToken name = this.eatId();
        return this.parseFunctionTail(start, name, false, isGenerator, null, FunctionDeclarationTree.Kind.DECLARATION);
    }

    private ParseTree parseFunctionExpression() {
        SourcePosition start = this.getTreeStartLocation();
        this.eat(Keywords.FUNCTION.type);
        boolean isGenerator = this.eatOpt(TokenType.STAR) != null;
        IdentifierToken name = this.eatIdOpt();
        return this.parseFunctionTail(start, name, false, isGenerator, null, FunctionDeclarationTree.Kind.EXPRESSION);
    }

    private ParseTree parseAmbientFunctionDeclaration() {
        SourcePosition start = this.getTreeStartLocation();
        this.eat(Keywords.FUNCTION.type);
        boolean isGenerator = this.eatOpt(TokenType.STAR) != null;
        IdentifierToken name = this.eatId();
        return this.parseAmbientFunctionDeclaration(start, name, isGenerator);
    }

    private boolean peekParameter(ParamContext context) {
        if (this.peekId() || this.peek(TokenType.SPREAD)) {
            return true;
        }
        if (context != ParamContext.TYPE_EXPRESSION) {
            return this.peek(TokenType.OPEN_SQUARE) || this.peek(TokenType.OPEN_CURLY);
        }
        return false;
    }

    private ParseTree parseParameter(ParamContext context) {
        SourcePosition start = this.getTreeStartLocation();
        ParseTree parameter = null;
        boolean isRestParam = false;
        if (this.peek(TokenType.SPREAD)) {
            isRestParam = true;
            this.eat(TokenType.SPREAD);
            parameter = new RestParameterTree(this.getTreeLocation(start), this.eatId());
        } else if (this.peekId()) {
            parameter = this.parseIdentifierExpression();
            if (this.peek(TokenType.QUESTION)) {
                this.eat(TokenType.QUESTION);
                parameter = new OptionalParameterTree(this.getTreeLocation(start), parameter);
            }
        } else if (context != ParamContext.TYPE_EXPRESSION) {
            if (this.peek(TokenType.OPEN_SQUARE)) {
                parameter = this.parseArrayPattern(PatternKind.INITIALIZER);
            } else if (this.peek(TokenType.OPEN_CURLY)) {
                parameter = this.parseObjectPattern(PatternKind.INITIALIZER);
            }
        }
        ParseTree typeAnnotation = null;
        SourceRange typeLocation = null;
        if (this.peek(TokenType.COLON)) {
            if (this.peek(1, TokenType.STRING)) {
                this.eat(TokenType.COLON);
                typeAnnotation = this.parseLiteralExpression();
            } else {
                typeAnnotation = this.parseTypeAnnotation();
            }
            typeLocation = this.getTreeLocation(this.getTreeStartLocation());
        }
        if (context == ParamContext.IMPLEMENTATION && !isRestParam && this.peek(TokenType.EQUAL)) {
            this.eat(TokenType.EQUAL);
            ParseTree defaultValue = this.parseAssignmentExpression();
            parameter = new DefaultParameterTree(this.getTreeLocation(start), parameter, defaultValue);
        }
        if (typeAnnotation != null) {
            parameter = new TypedParameterTree(typeLocation, parameter, typeAnnotation);
        }
        return parameter;
    }

    private FormalParameterListTree parseFormalParameterList(ParamContext context) {
        SourcePosition listStart = this.getTreeStartLocation();
        this.eat(TokenType.OPEN_PAREN);
        ImmutableList.Builder result = ImmutableList.builder();
        while (this.peekParameter(context)) {
            result.add((Object)this.parseParameter(context));
            if (this.peek(TokenType.CLOSE_PAREN)) continue;
            Token comma = this.eat(TokenType.COMMA);
            if (!this.peek(TokenType.CLOSE_PAREN)) continue;
            this.reportError(comma, "Invalid trailing comma in formal parameter list", new Object[0]);
        }
        this.eat(TokenType.CLOSE_PAREN);
        return new FormalParameterListTree(this.getTreeLocation(listStart), (ImmutableList<ParseTree>)result.build());
    }

    private ParseTree parseTypeAnnotation() {
        this.eat(TokenType.COLON);
        return this.parseType();
    }

    private ParseTree parseType() {
        SourcePosition start = this.getTreeStartLocation();
        if (!this.peekId() && !EnumSet.of(TokenType.VOID, TokenType.OPEN_PAREN, TokenType.OPEN_CURLY, TokenType.TYPEOF).contains((Object)this.peekType())) {
            this.reportError("Unexpected token '%s' in type expression", new Object[]{this.peekType()});
            return new TypeNameTree(this.getTreeLocation(start), (ImmutableList<String>)ImmutableList.of((Object)"error"));
        }
        ParseTree typeExpression = this.parseFunctionTypeExpression();
        if (!this.peek(TokenType.BAR)) {
            return typeExpression;
        }
        ImmutableList.Builder unionType = ImmutableList.builder();
        unionType.add((Object)typeExpression);
        do {
            this.eat(TokenType.BAR);
            unionType.add((Object)this.parseArrayTypeExpression());
        } while (this.peek(TokenType.BAR));
        return new UnionTypeTree(this.getTreeLocation(start), (ImmutableList<ParseTree>)unionType.build());
    }

    private ParseTree parseFunctionTypeExpression() {
        SourcePosition start = this.getTreeStartLocation();
        ParseTree typeExpression = null;
        if (this.peekArrowFunctionWithParenthesizedParameterList(ParamContext.TYPE_EXPRESSION)) {
            FormalParameterListTree formalParameterList = this.parseFormalParameterList(ParamContext.IMPLEMENTATION);
            this.eat(TokenType.ARROW);
            ParseTree returnType = this.parseType();
            typeExpression = new FunctionTypeTree(this.getTreeLocation(start), formalParameterList, returnType);
        } else {
            typeExpression = this.parseArrayTypeExpression();
        }
        return typeExpression;
    }

    private ParseTree parseArrayTypeExpression() {
        SourcePosition start = this.getTreeStartLocation();
        ParseTree typeExpression = this.parseParenTypeExpression();
        while (!this.peekImplicitSemiColon() && this.peek(TokenType.OPEN_SQUARE)) {
            this.eat(TokenType.OPEN_SQUARE);
            this.eat(TokenType.CLOSE_SQUARE);
            typeExpression = new ArrayTypeTree(this.getTreeLocation(start), typeExpression);
        }
        return typeExpression;
    }

    private ParseTree parseParenTypeExpression() {
        ParseTree typeExpression;
        if (this.peek(TokenType.OPEN_PAREN)) {
            this.eat(TokenType.OPEN_PAREN);
            typeExpression = this.parseType();
            this.eat(TokenType.CLOSE_PAREN);
        } else {
            typeExpression = this.parseRecordTypeExpression();
        }
        return typeExpression;
    }

    private ParseTree parseRecordTypeExpression() {
        ParseTree typeExpression;
        SourcePosition start = this.getTreeStartLocation();
        if (this.peek(TokenType.OPEN_CURLY)) {
            this.eat(TokenType.OPEN_CURLY);
            typeExpression = new RecordTypeTree(this.getTreeLocation(start), this.parseInterfaceElements());
            this.eat(TokenType.CLOSE_CURLY);
        } else {
            typeExpression = this.parseTypeQuery();
        }
        return typeExpression;
    }

    private ParseTree parseTypeQuery() {
        SourcePosition start = this.getTreeStartLocation();
        if (this.peek(TokenType.TYPEOF)) {
            this.eat(TokenType.TYPEOF);
            IdentifierToken token = this.eatId();
            ImmutableList.Builder identifiers = ImmutableList.builder();
            if (token != null) {
                identifiers.add((Object)token.value);
            }
            while (this.peek(TokenType.PERIOD)) {
                this.eat(TokenType.PERIOD);
                token = this.eatId();
                if (token == null) break;
                identifiers.add((Object)token.value);
            }
            return new TypeQueryTree(this.getTreeLocation(start), (ImmutableList<String>)identifiers.build());
        }
        return this.parseTypeReference();
    }

    private ParseTree parseTypeReference() {
        SourcePosition start = this.getTreeStartLocation();
        TypeNameTree typeName = this.parseTypeName();
        if (!this.peek(TokenType.OPEN_ANGLE)) {
            return typeName;
        }
        return this.parseTypeArgumentList(start, typeName);
    }

    private ParseTree parseTypeArgumentList(SourcePosition start, TypeNameTree typeName) {
        this.eat(TokenType.OPEN_ANGLE);
        this.scanner.incTypeParameterLevel();
        ImmutableList.Builder typeArguments = ImmutableList.builder();
        ParseTree type = this.parseType();
        typeArguments.add((Object)type);
        while (this.peek(TokenType.COMMA)) {
            this.eat(TokenType.COMMA);
            type = this.parseType();
            if (type == null) continue;
            typeArguments.add((Object)type);
        }
        this.eat(TokenType.CLOSE_ANGLE);
        this.scanner.decTypeParameterLevel();
        return new ParameterizedTypeTree(this.getTreeLocation(start), typeName, (ImmutableList<ParseTree>)typeArguments.build());
    }

    private TypeNameTree parseTypeName() {
        SourcePosition start = this.getTreeStartLocation();
        IdentifierToken token = this.eatIdOrKeywordAsId();
        ImmutableList.Builder identifiers = ImmutableList.builder();
        identifiers.add((Object)(token != null ? token.value : ""));
        while (this.peek(TokenType.PERIOD)) {
            this.eat(TokenType.PERIOD);
            token = this.eatId();
            if (token == null) break;
            identifiers.add((Object)token.value);
        }
        return new TypeNameTree(this.getTreeLocation(start), (ImmutableList<String>)identifiers.build());
    }

    private BlockTree parseFunctionBody() {
        SourcePosition start = this.getTreeStartLocation();
        this.eat(TokenType.OPEN_CURLY);
        ImmutableList<ParseTree> result = this.parseSourceElementList();
        this.eat(TokenType.CLOSE_CURLY);
        return new BlockTree(this.getTreeLocation(start), result);
    }

    private ImmutableList<ParseTree> parseSourceElementList() {
        ImmutableList.Builder result = ImmutableList.builder();
        while (this.peekSourceElement()) {
            result.add((Object)this.parseSourceElement());
        }
        return result.build();
    }

    private SpreadExpressionTree parseSpreadExpression() {
        SourcePosition start = this.getTreeStartLocation();
        this.eat(TokenType.SPREAD);
        ParseTree operand = this.parseAssignmentExpression();
        return new SpreadExpressionTree(this.getTreeLocation(start), operand);
    }

    private ParseTree parseStatement() {
        return this.parseSourceElement();
    }

    private ParseTree parseStatementStandard() {
        switch (this.peekType()) {
            case OPEN_CURLY: {
                return this.parseBlock();
            }
            case VAR: 
            case CONST: {
                return this.parseVariableStatement();
            }
            case SEMI_COLON: {
                return this.parseEmptyStatement();
            }
            case IF: {
                return this.parseIfStatement();
            }
            case DO: {
                return this.parseDoWhileStatement();
            }
            case WHILE: {
                return this.parseWhileStatement();
            }
            case FOR: {
                return this.parseForStatement();
            }
            case CONTINUE: {
                return this.parseContinueStatement();
            }
            case BREAK: {
                return this.parseBreakStatement();
            }
            case RETURN: {
                return this.parseReturnStatement();
            }
            case WITH: {
                return this.parseWithStatement();
            }
            case SWITCH: {
                return this.parseSwitchStatement();
            }
            case THROW: {
                return this.parseThrowStatement();
            }
            case TRY: {
                return this.parseTryStatement();
            }
            case DEBUGGER: {
                return this.parseDebuggerStatement();
            }
        }
        if (this.peekLabelledStatement()) {
            return this.parseLabelledStatement();
        }
        return this.parseExpressionStatement();
    }

    private boolean peekStatement() {
        return this.peekSourceElement();
    }

    private boolean peekStatementStandard() {
        switch (this.peekType()) {
            case CLASS: 
            case OPEN_CURLY: 
            case VAR: 
            case CONST: 
            case NEW: 
            case IDENTIFIER: 
            case OPEN_SQUARE: 
            case OPEN_PAREN: 
            case SEMI_COLON: 
            case IF: 
            case DO: 
            case WHILE: 
            case FOR: 
            case CONTINUE: 
            case BREAK: 
            case RETURN: 
            case WITH: 
            case SWITCH: 
            case THROW: 
            case TRY: 
            case DEBUGGER: 
            case YIELD: 
            case TYPE: 
            case DECLARE: 
            case THIS: 
            case SUPER: 
            case NUMBER: 
            case STRING: 
            case NO_SUBSTITUTION_TEMPLATE: 
            case TEMPLATE_HEAD: 
            case NULL: 
            case TRUE: 
            case SLASH: 
            case SLASH_EQUAL: 
            case FALSE: 
            case DELETE: 
            case VOID: 
            case TYPEOF: 
            case PLUS_PLUS: 
            case MINUS_MINUS: 
            case PLUS: 
            case MINUS: 
            case TILDE: 
            case BANG: {
                return true;
            }
        }
        return false;
    }

    private BlockTree parseBlock() {
        SourcePosition start = this.getTreeStartLocation();
        this.eat(TokenType.OPEN_CURLY);
        ImmutableList<ParseTree> result = this.parseSourceElementList();
        this.eat(TokenType.CLOSE_CURLY);
        return new BlockTree(this.getTreeLocation(start), result);
    }

    private ImmutableList<ParseTree> parseStatementList() {
        ImmutableList.Builder result = ImmutableList.builder();
        while (this.peekStatement()) {
            result.add((Object)this.parseStatement());
        }
        return result.build();
    }

    private VariableStatementTree parseVariableStatement() {
        SourcePosition start = this.getTreeStartLocation();
        VariableDeclarationListTree declarations = this.parseVariableDeclarationList();
        this.eatPossibleImplicitSemiColon();
        return new VariableStatementTree(this.getTreeLocation(start), declarations);
    }

    private VariableDeclarationListTree parseVariableDeclarationList() {
        return this.parseVariableDeclarationList(Expression.NORMAL);
    }

    private VariableDeclarationListTree parseVariableDeclarationListNoIn() {
        return this.parseVariableDeclarationList(Expression.NO_IN);
    }

    private VariableDeclarationListTree parseVariableDeclarationList(Expression expressionIn) {
        TokenType token = this.peekType();
        switch (token) {
            case VAR: 
            case LET: 
            case CONST: {
                this.eat(token);
                break;
            }
            default: {
                this.reportError(this.peekToken(), "expected declaration", new Object[0]);
                return null;
            }
        }
        SourcePosition start = this.getTreeStartLocation();
        ImmutableList.Builder declarations = ImmutableList.builder();
        declarations.add((Object)this.parseVariableDeclaration(token, expressionIn));
        while (this.peek(TokenType.COMMA)) {
            this.eat(TokenType.COMMA);
            declarations.add((Object)this.parseVariableDeclaration(token, expressionIn));
        }
        return new VariableDeclarationListTree(this.getTreeLocation(start), token, (ImmutableList<VariableDeclarationTree>)declarations.build());
    }

    private VariableDeclarationTree parseVariableDeclaration(TokenType binding, Expression expressionIn) {
        ParseTree lvalue;
        SourcePosition start = this.getTreeStartLocation();
        ParseTree typeAnnotation = null;
        if (this.peekPatternStart()) {
            lvalue = this.parsePattern(PatternKind.INITIALIZER);
        } else {
            lvalue = this.parseIdentifierExpression();
            if (this.peek(TokenType.COLON)) {
                typeAnnotation = this.parseTypeAnnotation();
            }
        }
        ParseTree initializer = null;
        if (this.peek(TokenType.EQUAL)) {
            initializer = this.parseInitializer(expressionIn);
        } else if (expressionIn != Expression.NO_IN) {
            this.maybeReportNoInitializer(binding, lvalue);
        }
        return new VariableDeclarationTree(this.getTreeLocation(start), lvalue, typeAnnotation, initializer);
    }

    private ParseTree parseInitializer(Expression expressionIn) {
        this.eat(TokenType.EQUAL);
        return this.parseAssignment(expressionIn);
    }

    private EmptyStatementTree parseEmptyStatement() {
        SourcePosition start = this.getTreeStartLocation();
        this.eat(TokenType.SEMI_COLON);
        return new EmptyStatementTree(this.getTreeLocation(start));
    }

    private ExpressionStatementTree parseExpressionStatement() {
        SourcePosition start = this.getTreeStartLocation();
        ParseTree expression = this.parseExpression();
        this.eatPossibleImplicitSemiColon();
        return new ExpressionStatementTree(this.getTreeLocation(start), expression);
    }

    private IfStatementTree parseIfStatement() {
        SourcePosition start = this.getTreeStartLocation();
        this.eat(TokenType.IF);
        this.eat(TokenType.OPEN_PAREN);
        ParseTree condition = this.parseExpression();
        this.eat(TokenType.CLOSE_PAREN);
        ParseTree ifClause = this.parseStatement();
        ParseTree elseClause = null;
        if (this.peek(TokenType.ELSE)) {
            this.eat(TokenType.ELSE);
            elseClause = this.parseStatement();
        }
        return new IfStatementTree(this.getTreeLocation(start), condition, ifClause, elseClause);
    }

    private ParseTree parseDoWhileStatement() {
        SourcePosition start = this.getTreeStartLocation();
        this.eat(TokenType.DO);
        ParseTree body = this.parseStatement();
        this.eat(TokenType.WHILE);
        this.eat(TokenType.OPEN_PAREN);
        ParseTree condition = this.parseExpression();
        this.eat(TokenType.CLOSE_PAREN);
        if (this.peek(TokenType.SEMI_COLON)) {
            this.eat(TokenType.SEMI_COLON);
        }
        return new DoWhileStatementTree(this.getTreeLocation(start), body, condition);
    }

    private ParseTree parseWhileStatement() {
        SourcePosition start = this.getTreeStartLocation();
        this.eat(TokenType.WHILE);
        this.eat(TokenType.OPEN_PAREN);
        ParseTree condition = this.parseExpression();
        this.eat(TokenType.CLOSE_PAREN);
        ParseTree body = this.parseStatement();
        return new WhileStatementTree(this.getTreeLocation(start), condition, body);
    }

    private ParseTree parseForStatement() {
        ParseTree initializer;
        SourcePosition start = this.getTreeStartLocation();
        this.eat(TokenType.FOR);
        this.eat(TokenType.OPEN_PAREN);
        if (this.peekVariableDeclarationList()) {
            VariableDeclarationListTree variables = this.parseVariableDeclarationListNoIn();
            if (this.peek(TokenType.IN)) {
                if (variables.declarations.size() > 1) {
                    this.reportError("for-in statement may not have more than one variable declaration", new Object[0]);
                }
                VariableDeclarationTree declaration = (VariableDeclarationTree)variables.declarations.get(0);
                if (declaration.initializer != null) {
                    if (this.config.atLeast6) {
                        this.reportError("for-in statement may not have initializer", new Object[0]);
                    } else {
                        this.errorReporter.reportWarning(declaration.location.start, "for-in statement should not have initializer", new Object[0]);
                    }
                }
                return this.parseForInStatement(start, variables);
            }
            if (this.peekPredefinedString("of")) {
                if (variables.declarations.size() > 1) {
                    this.reportError("for-of statement may not have more than one variable declaration", new Object[0]);
                }
                VariableDeclarationTree declaration = (VariableDeclarationTree)variables.declarations.get(0);
                if (declaration.initializer != null) {
                    this.reportError("for-of statement may not have initializer", new Object[0]);
                }
                return this.parseForOfStatement(start, variables);
            }
            this.checkVanillaForInitializers(variables);
            return this.parseForStatement(start, variables);
        }
        if (this.peek(TokenType.SEMI_COLON)) {
            return this.parseForStatement(start, null);
        }
        Predicate<Token> followPred = new Predicate<Token>(){

            public boolean apply(Token t) {
                return EnumSet.of(TokenType.IN, TokenType.EQUAL).contains((Object)t.type) || t.type == TokenType.IDENTIFIER && t.asIdentifier().value.equals("of");
            }
        };
        ParseTree parseTree = initializer = this.peekPattern(PatternKind.ANY, followPred) ? this.parsePattern(PatternKind.ANY) : this.parseExpressionNoIn();
        if ((this.peek(TokenType.IN) || this.peekPredefinedString("of")) && initializer.type != ParseTreeType.BINARY_OPERATOR && initializer.type != ParseTreeType.COMMA_EXPRESSION) {
            if (this.peek(TokenType.IN)) {
                return this.parseForInStatement(start, initializer);
            }
            return this.parseForOfStatement(start, initializer);
        }
        return this.parseForStatement(start, initializer);
    }

    private ParseTree parseForOfStatement(SourcePosition start, ParseTree initializer) {
        this.eatPredefinedString("of");
        ParseTree collection = this.parseExpression();
        this.eat(TokenType.CLOSE_PAREN);
        ParseTree body = this.parseStatement();
        return new ForOfStatementTree(this.getTreeLocation(start), initializer, collection, body);
    }

    private void checkVanillaForInitializers(VariableDeclarationListTree variables) {
        for (VariableDeclarationTree declaration : variables.declarations) {
            if (declaration.initializer != null) continue;
            this.maybeReportNoInitializer(variables.declarationType, declaration.lvalue);
        }
    }

    private void maybeReportNoInitializer(TokenType token, ParseTree lvalue) {
        if (token == TokenType.CONST) {
            this.reportError("const variables must have an initializer", new Object[0]);
        } else if (lvalue.isPattern()) {
            this.reportError("destructuring must have an initializer", new Object[0]);
        }
    }

    private boolean peekVariableDeclarationList() {
        switch (this.peekType()) {
            case VAR: 
            case LET: 
            case CONST: {
                return true;
            }
        }
        return false;
    }

    private ParseTree parseForStatement(SourcePosition start, ParseTree initializer) {
        if (initializer == null) {
            initializer = new NullTree(this.getTreeLocation(this.getTreeStartLocation()));
        }
        this.eat(TokenType.SEMI_COLON);
        ParseTree condition = !this.peek(TokenType.SEMI_COLON) ? this.parseExpression() : new NullTree(this.getTreeLocation(this.getTreeStartLocation()));
        this.eat(TokenType.SEMI_COLON);
        ParseTree increment = !this.peek(TokenType.CLOSE_PAREN) ? this.parseExpression() : new NullTree(this.getTreeLocation(this.getTreeStartLocation()));
        this.eat(TokenType.CLOSE_PAREN);
        ParseTree body = this.parseStatement();
        return new ForStatementTree(this.getTreeLocation(start), initializer, condition, increment, body);
    }

    private ParseTree parseForInStatement(SourcePosition start, ParseTree initializer) {
        this.eat(TokenType.IN);
        ParseTree collection = this.parseExpression();
        this.eat(TokenType.CLOSE_PAREN);
        ParseTree body = this.parseStatement();
        return new ForInStatementTree(this.getTreeLocation(start), initializer, collection, body);
    }

    private ParseTree parseContinueStatement() {
        SourcePosition start = this.getTreeStartLocation();
        this.eat(TokenType.CONTINUE);
        IdentifierToken name = null;
        if (!this.peekImplicitSemiColon()) {
            name = this.eatIdOpt();
        }
        this.eatPossibleImplicitSemiColon();
        return new ContinueStatementTree(this.getTreeLocation(start), name);
    }

    private ParseTree parseBreakStatement() {
        SourcePosition start = this.getTreeStartLocation();
        this.eat(TokenType.BREAK);
        IdentifierToken name = null;
        if (!this.peekImplicitSemiColon()) {
            name = this.eatIdOpt();
        }
        this.eatPossibleImplicitSemiColon();
        return new BreakStatementTree(this.getTreeLocation(start), name);
    }

    private ParseTree parseReturnStatement() {
        SourcePosition start = this.getTreeStartLocation();
        this.eat(TokenType.RETURN);
        ParseTree expression = null;
        if (!this.peekImplicitSemiColon()) {
            expression = this.parseExpression();
        }
        this.eatPossibleImplicitSemiColon();
        return new ReturnStatementTree(this.getTreeLocation(start), expression);
    }

    private ParseTree parseWithStatement() {
        SourcePosition start = this.getTreeStartLocation();
        this.eat(TokenType.WITH);
        this.eat(TokenType.OPEN_PAREN);
        ParseTree expression = this.parseExpression();
        this.eat(TokenType.CLOSE_PAREN);
        ParseTree body = this.parseStatement();
        return new WithStatementTree(this.getTreeLocation(start), expression, body);
    }

    private ParseTree parseSwitchStatement() {
        SourcePosition start = this.getTreeStartLocation();
        this.eat(TokenType.SWITCH);
        this.eat(TokenType.OPEN_PAREN);
        ParseTree expression = this.parseExpression();
        this.eat(TokenType.CLOSE_PAREN);
        this.eat(TokenType.OPEN_CURLY);
        ImmutableList<ParseTree> caseClauses = this.parseCaseClauses();
        this.eat(TokenType.CLOSE_CURLY);
        return new SwitchStatementTree(this.getTreeLocation(start), expression, caseClauses);
    }

    private ImmutableList<ParseTree> parseCaseClauses() {
        boolean foundDefaultClause = false;
        ImmutableList.Builder result = ImmutableList.builder();
        block4: while (true) {
            SourcePosition start = this.getTreeStartLocation();
            switch (this.peekType()) {
                case CASE: {
                    this.eat(TokenType.CASE);
                    ParseTree expression = this.parseExpression();
                    this.eat(TokenType.COLON);
                    ImmutableList<ParseTree> statements = this.parseCaseStatementsOpt();
                    result.add((Object)new CaseClauseTree(this.getTreeLocation(start), expression, statements));
                    continue block4;
                }
                case DEFAULT: {
                    if (foundDefaultClause) {
                        this.reportError("Switch statements may have at most one default clause", new Object[0]);
                    } else {
                        foundDefaultClause = true;
                    }
                    this.eat(TokenType.DEFAULT);
                    this.eat(TokenType.COLON);
                    result.add((Object)new DefaultClauseTree(this.getTreeLocation(start), this.parseCaseStatementsOpt()));
                    continue block4;
                }
            }
            break;
        }
        return result.build();
    }

    private ImmutableList<ParseTree> parseCaseStatementsOpt() {
        return this.parseStatementList();
    }

    private ParseTree parseLabelledStatement() {
        SourcePosition start = this.getTreeStartLocation();
        IdentifierToken name = this.eatId();
        this.eat(TokenType.COLON);
        return new LabelledStatementTree(this.getTreeLocation(start), name, this.parseStatement());
    }

    private boolean peekLabelledStatement() {
        return this.peekId() && this.peek(1, TokenType.COLON);
    }

    private ParseTree parseThrowStatement() {
        SourcePosition start = this.getTreeStartLocation();
        this.eat(TokenType.THROW);
        ParseTree value = null;
        if (this.peekImplicitSemiColon()) {
            this.reportError("semicolon/newline not allowed after 'throw'", new Object[0]);
        } else {
            value = this.parseExpression();
        }
        this.eatPossibleImplicitSemiColon();
        return new ThrowStatementTree(this.getTreeLocation(start), value);
    }

    private ParseTree parseTryStatement() {
        SourcePosition start = this.getTreeStartLocation();
        this.eat(TokenType.TRY);
        BlockTree body = this.parseBlock();
        CatchTree catchBlock = null;
        if (this.peek(TokenType.CATCH)) {
            catchBlock = this.parseCatch();
        }
        FinallyTree finallyBlock = null;
        if (this.peek(TokenType.FINALLY)) {
            finallyBlock = this.parseFinallyBlock();
        }
        if (catchBlock == null && finallyBlock == null) {
            this.reportError("'catch' or 'finally' expected.", new Object[0]);
        }
        return new TryStatementTree(this.getTreeLocation(start), body, catchBlock, finallyBlock);
    }

    private CatchTree parseCatch() {
        SourcePosition start = this.getTreeStartLocation();
        this.eat(TokenType.CATCH);
        this.eat(TokenType.OPEN_PAREN);
        ParseTree exception = this.peekPatternStart() ? this.parsePattern(PatternKind.INITIALIZER) : this.parseIdentifierExpression();
        this.eat(TokenType.CLOSE_PAREN);
        BlockTree catchBody = this.parseBlock();
        CatchTree catchBlock = new CatchTree(this.getTreeLocation(start), exception, catchBody);
        return catchBlock;
    }

    private FinallyTree parseFinallyBlock() {
        SourcePosition start = this.getTreeStartLocation();
        this.eat(TokenType.FINALLY);
        BlockTree finallyBlock = this.parseBlock();
        return new FinallyTree(this.getTreeLocation(start), finallyBlock);
    }

    private ParseTree parseDebuggerStatement() {
        SourcePosition start = this.getTreeStartLocation();
        this.eat(TokenType.DEBUGGER);
        this.eatPossibleImplicitSemiColon();
        return new DebuggerStatementTree(this.getTreeLocation(start));
    }

    private ParseTree parsePrimaryExpression() {
        switch (this.peekType()) {
            case CLASS: {
                return this.parseClassExpression();
            }
            case SUPER: {
                return this.parseSuperExpression();
            }
            case THIS: {
                return this.parseThisExpression();
            }
            case IDENTIFIER: 
            case TYPE: 
            case DECLARE: {
                return this.parseIdentifierExpression();
            }
            case NUMBER: 
            case STRING: 
            case NULL: 
            case TRUE: 
            case FALSE: {
                return this.parseLiteralExpression();
            }
            case NO_SUBSTITUTION_TEMPLATE: 
            case TEMPLATE_HEAD: {
                return this.parseTemplateLiteral(null);
            }
            case OPEN_SQUARE: {
                return this.parseArrayInitializer();
            }
            case OPEN_CURLY: {
                return this.parseObjectLiteral();
            }
            case OPEN_PAREN: {
                return this.parseParenExpression();
            }
            case SLASH: 
            case SLASH_EQUAL: {
                return this.parseRegularExpressionLiteral();
            }
        }
        return this.parseMissingPrimaryExpression();
    }

    private SuperExpressionTree parseSuperExpression() {
        SourcePosition start = this.getTreeStartLocation();
        this.eat(TokenType.SUPER);
        return new SuperExpressionTree(this.getTreeLocation(start));
    }

    private ThisExpressionTree parseThisExpression() {
        SourcePosition start = this.getTreeStartLocation();
        this.eat(TokenType.THIS);
        return new ThisExpressionTree(this.getTreeLocation(start));
    }

    private IdentifierExpressionTree parseIdentifierExpression() {
        SourcePosition start = this.getTreeStartLocation();
        IdentifierToken identifier = this.eatId();
        return new IdentifierExpressionTree(this.getTreeLocation(start), identifier);
    }

    private LiteralExpressionTree parseLiteralExpression() {
        SourcePosition start = this.getTreeStartLocation();
        Token literal = this.nextLiteralToken();
        return new LiteralExpressionTree(this.getTreeLocation(start), literal);
    }

    private TemplateLiteralExpressionTree parseTemplateLiteral(ParseTree operand) {
        SourcePosition start = operand == null ? this.getTreeStartLocation() : operand.location.start;
        Token token = this.nextToken();
        ImmutableList.Builder elements = ImmutableList.builder();
        elements.add((Object)new TemplateLiteralPortionTree(token.location, token));
        if (token.type == TokenType.NO_SUBSTITUTION_TEMPLATE) {
            return new TemplateLiteralExpressionTree(this.getTreeLocation(start), operand, (ImmutableList<ParseTree>)elements.build());
        }
        ParseTree expression = this.parseExpression();
        elements.add((Object)new TemplateSubstitutionTree(expression.location, expression));
        while (!this.errorReporter.hadError()) {
            token = this.nextTemplateLiteralToken();
            if (token.type == TokenType.ERROR || token.type == TokenType.END_OF_FILE) break;
            elements.add((Object)new TemplateLiteralPortionTree(token.location, token));
            if (token.type == TokenType.TEMPLATE_TAIL) break;
            expression = this.parseExpression();
            elements.add((Object)new TemplateSubstitutionTree(expression.location, expression));
        }
        return new TemplateLiteralExpressionTree(this.getTreeLocation(start), operand, (ImmutableList<ParseTree>)elements.build());
    }

    private Token nextLiteralToken() {
        return this.nextToken();
    }

    private ParseTree parseRegularExpressionLiteral() {
        SourcePosition start = this.getTreeStartLocation();
        LiteralToken literal = this.nextRegularExpressionLiteralToken();
        return new LiteralExpressionTree(this.getTreeLocation(start), literal);
    }

    private ParseTree parseArrayInitializer() {
        if (this.peekType(1) == TokenType.FOR) {
            return this.parseArrayComprehension();
        }
        return this.parseArrayLiteral();
    }

    private ParseTree parseGeneratorComprehension() {
        return this.parseComprehension(ComprehensionTree.ComprehensionType.GENERATOR, TokenType.OPEN_PAREN, TokenType.CLOSE_PAREN);
    }

    private ParseTree parseArrayComprehension() {
        return this.parseComprehension(ComprehensionTree.ComprehensionType.ARRAY, TokenType.OPEN_SQUARE, TokenType.CLOSE_SQUARE);
    }

    private ParseTree parseComprehension(ComprehensionTree.ComprehensionType type, TokenType startToken, TokenType endToken) {
        SourcePosition start = this.getTreeStartLocation();
        this.eat(startToken);
        ImmutableList.Builder children = ImmutableList.builder();
        while (this.peek(TokenType.FOR) || this.peek(TokenType.IF)) {
            if (this.peek(TokenType.FOR)) {
                children.add((Object)this.parseComprehensionFor());
                continue;
            }
            children.add((Object)this.parseComprehensionIf());
        }
        ParseTree tailExpression = this.parseAssignmentExpression();
        this.eat(endToken);
        return new ComprehensionTree(this.getTreeLocation(start), type, (ImmutableList<ParseTree>)children.build(), tailExpression);
    }

    private ParseTree parseComprehensionFor() {
        SourcePosition start = this.getTreeStartLocation();
        this.eat(TokenType.FOR);
        this.eat(TokenType.OPEN_PAREN);
        ParseTree initializer = this.peekId() ? this.parseIdentifierExpression() : this.parsePattern(PatternKind.ANY);
        this.eatPredefinedString("of");
        ParseTree collection = this.parseAssignmentExpression();
        this.eat(TokenType.CLOSE_PAREN);
        return new ComprehensionForTree(this.getTreeLocation(start), initializer, collection);
    }

    private ParseTree parseComprehensionIf() {
        SourcePosition start = this.getTreeStartLocation();
        this.eat(TokenType.IF);
        this.eat(TokenType.OPEN_PAREN);
        ParseTree initializer = this.parseAssignmentExpression();
        this.eat(TokenType.CLOSE_PAREN);
        return new ComprehensionIfTree(this.getTreeLocation(start), initializer);
    }

    private ParseTree parseArrayLiteral() {
        SourcePosition start = this.getTreeStartLocation();
        ImmutableList.Builder elements = ImmutableList.builder();
        this.eat(TokenType.OPEN_SQUARE);
        Token trailingCommaToken = null;
        while (this.peek(TokenType.COMMA) || this.peek(TokenType.SPREAD) || this.peekAssignmentExpression()) {
            trailingCommaToken = null;
            if (this.peek(TokenType.COMMA)) {
                elements.add((Object)new NullTree(this.getTreeLocation(this.getTreeStartLocation())));
            } else if (this.peek(TokenType.SPREAD)) {
                elements.add((Object)this.parseSpreadExpression());
            } else {
                elements.add((Object)this.parseAssignmentExpression());
            }
            if (this.peek(TokenType.CLOSE_SQUARE)) continue;
            trailingCommaToken = this.eat(TokenType.COMMA);
        }
        this.eat(TokenType.CLOSE_SQUARE);
        this.maybeReportTrailingComma(trailingCommaToken);
        return new ArrayLiteralExpressionTree(this.getTreeLocation(start), (ImmutableList<ParseTree>)elements.build());
    }

    private ParseTree parseObjectLiteral() {
        SourcePosition start = this.getTreeStartLocation();
        ImmutableList.Builder result = ImmutableList.builder();
        this.eat(TokenType.OPEN_CURLY);
        Token commaToken = null;
        while (this.peekPropertyNameOrComputedProp(0) || this.peek(TokenType.STAR) || this.peekAccessibilityModifier()) {
            commaToken = null;
            result.add((Object)this.parsePropertyAssignment());
            commaToken = this.eatOpt(TokenType.COMMA);
            if (commaToken != null) continue;
        }
        this.eat(TokenType.CLOSE_CURLY);
        this.maybeReportTrailingComma(commaToken);
        return new ObjectLiteralExpressionTree(this.getTreeLocation(start), (ImmutableList<ParseTree>)result.build());
    }

    void maybeReportTrailingComma(Token commaToken) {
        if (commaToken != null && this.config.warnTrailingCommas) {
            this.errorReporter.reportWarning(commaToken.location.start, "Trailing comma is not legal in an ECMA-262 object initializer", new Object[0]);
        }
    }

    private boolean peekPropertyNameOrComputedProp(int tokenIndex) {
        return this.peekPropertyName(tokenIndex) || this.peekType(tokenIndex) == TokenType.OPEN_SQUARE;
    }

    private boolean peekPropertyName(int tokenIndex) {
        TokenType type = this.peekType(tokenIndex);
        switch (type) {
            case IDENTIFIER: 
            case NUMBER: 
            case STRING: {
                return true;
            }
        }
        return Keywords.isKeyword(type);
    }

    private ParseTree parsePropertyAssignment() {
        TokenType type = this.peekType();
        if (type == TokenType.STAR) {
            return this.parsePropertyAssignmentGenerator();
        }
        if (type == TokenType.STRING || type == TokenType.NUMBER || type == TokenType.IDENTIFIER || Keywords.isKeyword(type)) {
            if (this.peekGetAccessor(false)) {
                return this.parseGetAccessor(null);
            }
            if (this.peekSetAccessor(false)) {
                return this.parseSetAccessor(null);
            }
            if (this.peekType(1) == TokenType.OPEN_PAREN) {
                return this.parseClassMemberDeclaration(false, false, null);
            }
            return this.parsePropertyNameAssignment();
        }
        if (type == TokenType.OPEN_SQUARE) {
            SourcePosition start = this.getTreeStartLocation();
            ParseTree name = this.parseComputedPropertyName();
            if (this.peek(TokenType.COLON)) {
                this.eat(TokenType.COLON);
                ParseTree value = this.parseAssignmentExpression();
                return new ComputedPropertyDefinitionTree(this.getTreeLocation(start), name, value);
            }
            FunctionDeclarationTree value = this.parseFunctionTail(start, null, false, false, null, FunctionDeclarationTree.Kind.EXPRESSION);
            return new ComputedPropertyMethodTree(this.getTreeLocation(start), null, name, value);
        }
        throw new RuntimeException("unreachable");
    }

    private ParseTree parsePropertyAssignmentGenerator() {
        TokenType type = this.peekType(1);
        if (type == TokenType.STRING || type == TokenType.NUMBER || type == TokenType.IDENTIFIER || Keywords.isKeyword(type)) {
            return this.parseClassMemberDeclaration(false, false, null);
        }
        SourcePosition start = this.getTreeStartLocation();
        this.eat(TokenType.STAR);
        ParseTree name = this.parseComputedPropertyName();
        FunctionDeclarationTree value = this.parseFunctionTail(start, null, false, true, null, FunctionDeclarationTree.Kind.EXPRESSION);
        return new ComputedPropertyMethodTree(this.getTreeLocation(start), null, name, value);
    }

    private ParseTree parseComputedPropertyName() {
        this.eat(TokenType.OPEN_SQUARE);
        ParseTree assign = this.parseAssignmentExpression();
        this.eat(TokenType.CLOSE_SQUARE);
        return assign;
    }

    private boolean peekGetAccessor(boolean allowStatic) {
        int index = allowStatic && this.peek(TokenType.STATIC) ? 1 : 0;
        return this.peekPredefinedString(index, "get") && this.peekPropertyNameOrComputedProp(index + 1);
    }

    private boolean peekPredefinedString(String string) {
        return this.peekPredefinedString(0, string);
    }

    private Token eatPredefinedString(String string) {
        IdentifierToken token = this.eatId();
        if (token == null || !token.asIdentifier().value.equals(string)) {
            this.reportExpectedError(token, string);
            return null;
        }
        return token;
    }

    private boolean peekPredefinedString(int index, String string) {
        return this.peek(index, TokenType.IDENTIFIER) && ((IdentifierToken)this.peekToken((int)index)).value.equals(string);
    }

    private ParseTree parseGetAccessor(TokenType access) {
        SourcePosition start = this.getTreeStartLocation();
        boolean isStatic = this.eatOpt(TokenType.STATIC) != null;
        this.eatPredefinedString("get");
        if (this.peekPropertyName(0)) {
            Token propertyName = this.eatObjectLiteralPropertyName();
            this.eat(TokenType.OPEN_PAREN);
            this.eat(TokenType.CLOSE_PAREN);
            BlockTree body = this.parseFunctionBody();
            return new GetAccessorTree(this.getTreeLocation(start), propertyName, isStatic, body);
        }
        ParseTree property = this.parseComputedPropertyName();
        this.eat(TokenType.OPEN_PAREN);
        this.eat(TokenType.CLOSE_PAREN);
        BlockTree body = this.parseFunctionBody();
        return new ComputedPropertyGetterTree(this.getTreeLocation(start), property, isStatic, access, body);
    }

    private boolean peekSetAccessor(boolean allowStatic) {
        int index = allowStatic && this.peek(TokenType.STATIC) ? 1 : 0;
        return this.peekPredefinedString(index, "set") && this.peekPropertyNameOrComputedProp(index + 1);
    }

    private ParseTree parseSetAccessor(TokenType access) {
        SourcePosition start = this.getTreeStartLocation();
        boolean isStatic = this.eatOpt(TokenType.STATIC) != null;
        this.eatPredefinedString("set");
        if (this.peekPropertyName(0)) {
            Token propertyName = this.eatObjectLiteralPropertyName();
            this.eat(TokenType.OPEN_PAREN);
            IdentifierToken parameter = this.eatId();
            this.eat(TokenType.CLOSE_PAREN);
            BlockTree body = this.parseFunctionBody();
            return new SetAccessorTree(this.getTreeLocation(start), propertyName, isStatic, parameter, body);
        }
        ParseTree property = this.parseComputedPropertyName();
        this.eat(TokenType.OPEN_PAREN);
        IdentifierToken parameter = this.eatId();
        this.eat(TokenType.CLOSE_PAREN);
        BlockTree body = this.parseFunctionBody();
        return new ComputedPropertySetterTree(this.getTreeLocation(start), property, isStatic, access, parameter, body);
    }

    private ParseTree parsePropertyNameAssignment() {
        SourcePosition start = this.getTreeStartLocation();
        Token name = this.eatObjectLiteralPropertyName();
        Token colon = this.eatOpt(TokenType.COLON);
        if (colon == null) {
            if (name.type != TokenType.IDENTIFIER) {
                this.reportExpectedError(this.peekToken(), (Object)TokenType.COLON);
            } else if (Keywords.isKeyword(name.asIdentifier().value)) {
                this.reportError(name, "Cannot use keyword in short object literal", new Object[0]);
            }
        }
        ParseTree value = colon == null ? null : this.parseAssignmentExpression();
        return new PropertyNameAssignmentTree(this.getTreeLocation(start), name, value);
    }

    private ParseTree parseParenExpression() {
        if (this.peekType(1) == TokenType.FOR) {
            return this.parseGeneratorComprehension();
        }
        SourcePosition start = this.getTreeStartLocation();
        this.eat(TokenType.OPEN_PAREN);
        ParseTree result = this.parseExpression();
        this.eat(TokenType.CLOSE_PAREN);
        return new ParenExpressionTree(this.getTreeLocation(start), result);
    }

    private ParseTree parseMissingPrimaryExpression() {
        SourcePosition start = this.getTreeStartLocation();
        this.nextToken();
        this.reportError("primary expression expected", new Object[0]);
        return new MissingPrimaryExpressionTree(this.getTreeLocation(start));
    }

    private GenericTypeListTree maybeParseGenericTypes() {
        if (!this.peek(TokenType.OPEN_ANGLE)) {
            return null;
        }
        SourcePosition start = this.getTreeStartLocation();
        this.eat(TokenType.OPEN_ANGLE);
        this.scanner.incTypeParameterLevel();
        LinkedHashMap<IdentifierToken, ParseTree> types = new LinkedHashMap<IdentifierToken, ParseTree>();
        do {
            IdentifierToken name = this.eatId();
            ParseTree bound = null;
            if (this.peek(TokenType.EXTENDS)) {
                this.eat(TokenType.EXTENDS);
                bound = this.parseType();
            }
            types.put(name, bound);
            if (!this.peek(TokenType.COMMA)) continue;
            this.eat(TokenType.COMMA);
        } while (this.peekId());
        this.eat(TokenType.CLOSE_ANGLE);
        this.scanner.decTypeParameterLevel();
        return new GenericTypeListTree(this.getTreeLocation(start), types);
    }

    private ParseTree maybeParseColonType() {
        ParseTree type = null;
        if (this.peek(TokenType.COLON)) {
            type = this.parseTypeAnnotation();
        }
        return type;
    }

    private ParseTree parseExpressionNoIn() {
        return this.parse(Expression.NO_IN);
    }

    private ParseTree parseExpression() {
        return this.parse(Expression.NORMAL);
    }

    private boolean peekExpression() {
        switch (this.peekType()) {
            case FUNCTION: 
            case CLASS: 
            case OPEN_CURLY: 
            case NEW: 
            case IDENTIFIER: 
            case OPEN_SQUARE: 
            case OPEN_PAREN: 
            case YIELD: 
            case TYPE: 
            case DECLARE: 
            case THIS: 
            case SUPER: 
            case NUMBER: 
            case STRING: 
            case NO_SUBSTITUTION_TEMPLATE: 
            case TEMPLATE_HEAD: 
            case NULL: 
            case TRUE: 
            case SLASH: 
            case SLASH_EQUAL: 
            case FALSE: 
            case DELETE: 
            case VOID: 
            case TYPEOF: 
            case PLUS_PLUS: 
            case MINUS_MINUS: 
            case PLUS: 
            case MINUS: 
            case TILDE: 
            case BANG: {
                return true;
            }
        }
        return false;
    }

    private ParseTree parse(Expression expressionIn) {
        SourcePosition start = this.getTreeStartLocation();
        ParseTree result = this.parseAssignment(expressionIn);
        if (this.peek(TokenType.COMMA)) {
            ImmutableList.Builder exprs = ImmutableList.builder();
            exprs.add((Object)result);
            while (this.peek(TokenType.COMMA)) {
                this.eat(TokenType.COMMA);
                exprs.add((Object)this.parseAssignment(expressionIn));
            }
            return new CommaExpressionTree(this.getTreeLocation(start), (ImmutableList<ParseTree>)exprs.build());
        }
        return result;
    }

    private ParseTree parseAssignmentExpression() {
        return this.parseAssignment(Expression.NORMAL);
    }

    private boolean peekAssignmentExpression() {
        return this.peekExpression();
    }

    private ParseTree parseAssignment(Expression expressionIn) {
        ParseTree left;
        if (this.peek(TokenType.YIELD) && this.inGeneratorContext()) {
            return this.parseYield(expressionIn);
        }
        if (this.peekArrowFunction()) {
            return this.parseArrowFunction(expressionIn);
        }
        SourcePosition start = this.getTreeStartLocation();
        ParseTree parseTree = left = this.peekParenPatternAssignment() ? this.parseParenPattern() : this.parseConditional(expressionIn);
        if (this.peekAssignmentOperator()) {
            if (!left.isValidAssignmentTarget()) {
                this.reportError("invalid assignment target", new Object[0]);
            }
            Token operator = this.nextToken();
            ParseTree right = this.parseAssignment(expressionIn);
            return new BinaryOperatorTree(this.getTreeLocation(start), left, operator, right);
        }
        return left;
    }

    private boolean peekAssignmentOperator() {
        switch (this.peekType()) {
            case SLASH_EQUAL: 
            case EQUAL: 
            case STAR_EQUAL: 
            case PERCENT_EQUAL: 
            case PLUS_EQUAL: 
            case MINUS_EQUAL: 
            case LEFT_SHIFT_EQUAL: 
            case RIGHT_SHIFT_EQUAL: 
            case UNSIGNED_RIGHT_SHIFT_EQUAL: 
            case AMPERSAND_EQUAL: 
            case CARET_EQUAL: 
            case BAR_EQUAL: {
                return true;
            }
        }
        return false;
    }

    private boolean inGeneratorContext() {
        return this.inGeneratorContext.peekLast();
    }

    private ParseTree parseYield(Expression expressionIn) {
        SourcePosition start = this.getTreeStartLocation();
        this.eat(TokenType.YIELD);
        boolean isYieldFor = false;
        ParseTree expression = null;
        if (!this.peekImplicitSemiColon()) {
            boolean bl = isYieldFor = this.eatOpt(TokenType.STAR) != null;
            if (this.peekAssignmentExpression()) {
                expression = this.parseAssignment(expressionIn);
            }
        }
        return new YieldExpressionTree(this.getTreeLocation(start), isYieldFor, expression);
    }

    private ParseTree parseConditional(Expression expressionIn) {
        SourcePosition start = this.getTreeStartLocation();
        ParseTree condition = this.parseLogicalOR(expressionIn);
        if (this.peek(TokenType.QUESTION)) {
            this.eat(TokenType.QUESTION);
            ParseTree left = this.parseAssignment(expressionIn);
            this.eat(TokenType.COLON);
            ParseTree right = this.parseAssignment(expressionIn);
            return new ConditionalExpressionTree(this.getTreeLocation(start), condition, left, right);
        }
        return condition;
    }

    private ParseTree parseLogicalOR(Expression expressionIn) {
        SourcePosition start = this.getTreeStartLocation();
        ParseTree left = this.parseLogicalAND(expressionIn);
        while (this.peek(TokenType.OR)) {
            Token operator = this.eat(TokenType.OR);
            ParseTree right = this.parseLogicalAND(expressionIn);
            left = new BinaryOperatorTree(this.getTreeLocation(start), left, operator, right);
        }
        return left;
    }

    private ParseTree parseLogicalAND(Expression expressionIn) {
        SourcePosition start = this.getTreeStartLocation();
        ParseTree left = this.parseBitwiseOR(expressionIn);
        while (this.peek(TokenType.AND)) {
            Token operator = this.eat(TokenType.AND);
            ParseTree right = this.parseBitwiseOR(expressionIn);
            left = new BinaryOperatorTree(this.getTreeLocation(start), left, operator, right);
        }
        return left;
    }

    private ParseTree parseBitwiseOR(Expression expressionIn) {
        SourcePosition start = this.getTreeStartLocation();
        ParseTree left = this.parseBitwiseXOR(expressionIn);
        while (this.peek(TokenType.BAR)) {
            Token operator = this.eat(TokenType.BAR);
            ParseTree right = this.parseBitwiseXOR(expressionIn);
            left = new BinaryOperatorTree(this.getTreeLocation(start), left, operator, right);
        }
        return left;
    }

    private ParseTree parseBitwiseXOR(Expression expressionIn) {
        SourcePosition start = this.getTreeStartLocation();
        ParseTree left = this.parseBitwiseAND(expressionIn);
        while (this.peek(TokenType.CARET)) {
            Token operator = this.eat(TokenType.CARET);
            ParseTree right = this.parseBitwiseAND(expressionIn);
            left = new BinaryOperatorTree(this.getTreeLocation(start), left, operator, right);
        }
        return left;
    }

    private ParseTree parseBitwiseAND(Expression expressionIn) {
        SourcePosition start = this.getTreeStartLocation();
        ParseTree left = this.parseEquality(expressionIn);
        while (this.peek(TokenType.AMPERSAND)) {
            Token operator = this.eat(TokenType.AMPERSAND);
            ParseTree right = this.parseEquality(expressionIn);
            left = new BinaryOperatorTree(this.getTreeLocation(start), left, operator, right);
        }
        return left;
    }

    private ParseTree parseEquality(Expression expressionIn) {
        SourcePosition start = this.getTreeStartLocation();
        ParseTree left = this.parseRelational(expressionIn);
        while (this.peekEqualityOperator()) {
            Token operator = this.nextToken();
            ParseTree right = this.parseRelational(expressionIn);
            left = new BinaryOperatorTree(this.getTreeLocation(start), left, operator, right);
        }
        return left;
    }

    private boolean peekEqualityOperator() {
        switch (this.peekType()) {
            case EQUAL_EQUAL: 
            case NOT_EQUAL: 
            case EQUAL_EQUAL_EQUAL: 
            case NOT_EQUAL_EQUAL: {
                return true;
            }
        }
        return false;
    }

    private ParseTree parseRelational(Expression expressionIn) {
        SourcePosition start = this.getTreeStartLocation();
        ParseTree left = this.parseShiftExpression();
        while (this.peekRelationalOperator(expressionIn)) {
            Token operator = this.nextToken();
            ParseTree right = this.parseShiftExpression();
            left = new BinaryOperatorTree(this.getTreeLocation(start), left, operator, right);
        }
        return left;
    }

    private boolean peekRelationalOperator(Expression expressionIn) {
        switch (this.peekType()) {
            case OPEN_ANGLE: 
            case CLOSE_ANGLE: 
            case GREATER_EQUAL: 
            case LESS_EQUAL: 
            case INSTANCEOF: {
                return true;
            }
            case IN: {
                return expressionIn == Expression.NORMAL;
            }
        }
        return false;
    }

    private ParseTree parseShiftExpression() {
        SourcePosition start = this.getTreeStartLocation();
        ParseTree left = this.parseAdditiveExpression();
        while (this.peekShiftOperator()) {
            Token operator = this.nextToken();
            ParseTree right = this.parseAdditiveExpression();
            left = new BinaryOperatorTree(this.getTreeLocation(start), left, operator, right);
        }
        return left;
    }

    private boolean peekShiftOperator() {
        switch (this.peekType()) {
            case LEFT_SHIFT: 
            case RIGHT_SHIFT: 
            case UNSIGNED_RIGHT_SHIFT: {
                return true;
            }
        }
        return false;
    }

    private ParseTree parseAdditiveExpression() {
        SourcePosition start = this.getTreeStartLocation();
        ParseTree left = this.parseMultiplicativeExpression();
        while (this.peekAdditiveOperator()) {
            Token operator = this.nextToken();
            ParseTree right = this.parseMultiplicativeExpression();
            left = new BinaryOperatorTree(this.getTreeLocation(start), left, operator, right);
        }
        return left;
    }

    private boolean peekAdditiveOperator() {
        switch (this.peekType()) {
            case PLUS: 
            case MINUS: {
                return true;
            }
        }
        return false;
    }

    private ParseTree parseMultiplicativeExpression() {
        SourcePosition start = this.getTreeStartLocation();
        ParseTree left = this.parseUnaryExpression();
        while (this.peekMultiplicativeOperator()) {
            Token operator = this.nextToken();
            ParseTree right = this.parseUnaryExpression();
            left = new BinaryOperatorTree(this.getTreeLocation(start), left, operator, right);
        }
        return left;
    }

    private boolean peekMultiplicativeOperator() {
        switch (this.peekType()) {
            case STAR: 
            case SLASH: 
            case PERCENT: {
                return true;
            }
        }
        return false;
    }

    private ParseTree parseUnaryExpression() {
        SourcePosition start = this.getTreeStartLocation();
        if (this.peekUnaryOperator()) {
            Token operator = this.nextToken();
            ParseTree operand = this.parseUnaryExpression();
            return new UnaryExpressionTree(this.getTreeLocation(start), operator, operand);
        }
        return this.parsePostfixExpression();
    }

    private boolean peekUnaryOperator() {
        switch (this.peekType()) {
            case DELETE: 
            case VOID: 
            case TYPEOF: 
            case PLUS_PLUS: 
            case MINUS_MINUS: 
            case PLUS: 
            case MINUS: 
            case TILDE: 
            case BANG: {
                return true;
            }
        }
        return false;
    }

    private ParseTree parsePostfixExpression() {
        SourcePosition start = this.getTreeStartLocation();
        ParseTree operand = this.parseLeftHandSideExpression();
        while (this.peekPostfixOperator()) {
            Token operator = this.nextToken();
            operand = new PostfixExpressionTree(this.getTreeLocation(start), operand, operator);
        }
        return operand;
    }

    private boolean peekPostfixOperator() {
        if (this.peekImplicitSemiColon()) {
            return false;
        }
        switch (this.peekType()) {
            case PLUS_PLUS: 
            case MINUS_MINUS: {
                return true;
            }
        }
        return false;
    }

    private ParseTree parseLeftHandSideExpression() {
        SourcePosition start = this.getTreeStartLocation();
        ParseTree operand = this.parseNewExpression();
        if (!(operand instanceof NewExpressionTree) || ((NewExpressionTree)operand).arguments != null) {
            while (this.peekCallSuffix()) {
                switch (this.peekType()) {
                    case OPEN_PAREN: {
                        ArgumentListTree arguments = this.parseArguments();
                        operand = new CallExpressionTree(this.getTreeLocation(start), operand, arguments);
                        break;
                    }
                    case OPEN_SQUARE: {
                        this.eat(TokenType.OPEN_SQUARE);
                        ParseTree member = this.parseExpression();
                        this.eat(TokenType.CLOSE_SQUARE);
                        operand = new MemberLookupExpressionTree(this.getTreeLocation(start), operand, member);
                        break;
                    }
                    case PERIOD: {
                        this.eat(TokenType.PERIOD);
                        IdentifierToken id = this.eatIdOrKeywordAsId();
                        operand = new MemberExpressionTree(this.getTreeLocation(start), operand, id);
                        break;
                    }
                    case NO_SUBSTITUTION_TEMPLATE: 
                    case TEMPLATE_HEAD: {
                        operand = this.parseTemplateLiteral(operand);
                    }
                }
            }
        }
        return operand;
    }

    private boolean peekCallSuffix() {
        return this.peek(TokenType.OPEN_PAREN) || this.peek(TokenType.OPEN_SQUARE) || this.peek(TokenType.PERIOD) || this.peek(TokenType.NO_SUBSTITUTION_TEMPLATE) || this.peek(TokenType.TEMPLATE_HEAD);
    }

    private ParseTree parseMemberExpressionNoNew() {
        SourcePosition start = this.getTreeStartLocation();
        ParseTree operand = this.peekFunction() ? this.parseFunctionExpression() : this.parsePrimaryExpression();
        block5: while (this.peekMemberExpressionSuffix()) {
            switch (this.peekType()) {
                case OPEN_SQUARE: {
                    this.eat(TokenType.OPEN_SQUARE);
                    ParseTree member = this.parseExpression();
                    this.eat(TokenType.CLOSE_SQUARE);
                    operand = new MemberLookupExpressionTree(this.getTreeLocation(start), operand, member);
                    continue block5;
                }
                case PERIOD: {
                    this.eat(TokenType.PERIOD);
                    IdentifierToken id = this.eatIdOrKeywordAsId();
                    operand = new MemberExpressionTree(this.getTreeLocation(start), operand, id);
                    continue block5;
                }
                case NO_SUBSTITUTION_TEMPLATE: 
                case TEMPLATE_HEAD: {
                    operand = this.parseTemplateLiteral(operand);
                    continue block5;
                }
            }
            throw new RuntimeException("unreachable");
        }
        return operand;
    }

    private boolean peekMemberExpressionSuffix() {
        return this.peek(TokenType.OPEN_SQUARE) || this.peek(TokenType.PERIOD) || this.peek(TokenType.NO_SUBSTITUTION_TEMPLATE) || this.peek(TokenType.TEMPLATE_HEAD);
    }

    private ParseTree parseNewExpression() {
        if (this.peek(TokenType.NEW)) {
            SourcePosition start = this.getTreeStartLocation();
            this.eat(TokenType.NEW);
            ParseTree operand = this.parseNewExpression();
            ArgumentListTree arguments = null;
            if (this.peek(TokenType.OPEN_PAREN)) {
                arguments = this.parseArguments();
            }
            return new NewExpressionTree(this.getTreeLocation(start), operand, arguments);
        }
        return this.parseMemberExpressionNoNew();
    }

    private ArgumentListTree parseArguments() {
        SourcePosition start = this.getTreeStartLocation();
        ImmutableList.Builder arguments = ImmutableList.builder();
        this.eat(TokenType.OPEN_PAREN);
        while (this.peekAssignmentOrSpread()) {
            arguments.add((Object)this.parseAssignmentOrSpread());
            if (this.peek(TokenType.CLOSE_PAREN)) continue;
            this.eat(TokenType.COMMA);
            if (!this.peek(TokenType.CLOSE_PAREN)) continue;
            this.reportError("Invalid trailing comma in arguments list", new Object[0]);
        }
        this.eat(TokenType.CLOSE_PAREN);
        return new ArgumentListTree(this.getTreeLocation(start), (ImmutableList<ParseTree>)arguments.build());
    }

    private boolean peekAssignmentOrSpread() {
        return this.peek(TokenType.SPREAD) || this.peekAssignmentExpression();
    }

    private ParseTree parseAssignmentOrSpread() {
        if (this.peek(TokenType.SPREAD)) {
            return this.parseSpreadExpression();
        }
        return this.parseAssignmentExpression();
    }

    private boolean peekParenPatternAssignment() {
        return this.peekParenPattern(PatternKind.ANY, assignmentFollowSet);
    }

    private boolean peekParenPatternStart() {
        int index = 0;
        while (this.peek(index, TokenType.OPEN_PAREN)) {
            ++index;
        }
        return this.peekPatternStart(index);
    }

    private boolean peekPatternStart() {
        return this.peekPatternStart(0);
    }

    private boolean peekPatternStart(int index) {
        return this.peek(index, TokenType.OPEN_SQUARE) || this.peek(index, TokenType.OPEN_CURLY);
    }

    private ParseTree parseParenPattern() {
        return this.parseParenPattern(PatternKind.ANY);
    }

    private ParseTree parseParenPattern(PatternKind kind) {
        if (this.peek(TokenType.OPEN_PAREN)) {
            SourcePosition start = this.getTreeStartLocation();
            this.eat(TokenType.OPEN_PAREN);
            ParseTree result = this.parseParenPattern(kind);
            this.eat(TokenType.CLOSE_PAREN);
            return new ParenExpressionTree(this.getTreeLocation(start), result);
        }
        return this.parsePattern(kind);
    }

    private boolean peekPattern(PatternKind kind) {
        return this.peekPattern(kind, (Predicate<Token>)Predicates.alwaysTrue());
    }

    private boolean peekPattern(PatternKind kind, Predicate<Token> follow) {
        if (!this.peekPatternStart()) {
            return false;
        }
        Parser p = this.createLookaheadParser();
        try {
            p.parsePattern(kind);
            return follow.apply((Object)p.peekToken());
        }
        catch (LookaheadErrorReporter.ParseException e) {
            return false;
        }
    }

    private boolean peekParenPattern(PatternKind kind, EnumSet<TokenType> follow) {
        if (!this.peekParenPatternStart()) {
            return false;
        }
        Parser p = this.createLookaheadParser();
        try {
            p.parseParenPattern(kind);
            return follow.contains((Object)p.peekType());
        }
        catch (LookaheadErrorReporter.ParseException e) {
            return false;
        }
    }

    private ParseTree parsePattern(PatternKind kind) {
        switch (this.peekType()) {
            case OPEN_SQUARE: {
                return this.parseArrayPattern(kind);
            }
        }
        return this.parseObjectPattern(kind);
    }

    private boolean peekPatternElement() {
        return this.peekExpression() || this.peek(TokenType.SPREAD);
    }

    private ParseTree parseArrayPatternElement(PatternKind kind) {
        ParseTree lvalue;
        SourcePosition start = this.getTreeStartLocation();
        boolean rest = false;
        if (this.peekParenPatternStart()) {
            lvalue = this.parseParenPattern(kind);
        } else {
            if (this.peek(TokenType.SPREAD)) {
                this.eat(TokenType.SPREAD);
                rest = true;
            }
            lvalue = this.parseLeftHandSideExpression();
        }
        if (rest && lvalue.type != ParseTreeType.IDENTIFIER_EXPRESSION) {
            this.reportError("lvalues in rest elements must be identifiers", new Object[0]);
            return lvalue;
        }
        if (rest) {
            return new AssignmentRestElementTree(this.getTreeLocation(start), lvalue.asIdentifierExpression().identifierToken);
        }
        Token eq = this.eatOpt(TokenType.EQUAL);
        if (eq != null) {
            ParseTree defaultValue = this.parseAssignmentExpression();
            return new DefaultParameterTree(this.getTreeLocation(start), lvalue, defaultValue);
        }
        return lvalue;
    }

    private ParseTree parseArrayPattern(PatternKind kind) {
        SourcePosition start = this.getTreeStartLocation();
        ImmutableList.Builder elements = ImmutableList.builder();
        this.eat(TokenType.OPEN_SQUARE);
        while (this.peek(TokenType.COMMA) || this.peekPatternElement()) {
            if (this.peek(TokenType.COMMA)) {
                this.eat(TokenType.COMMA);
                elements.add((Object)new NullTree(this.getTreeLocation(this.getTreeStartLocation())));
                continue;
            }
            ParseTree element = this.parseArrayPatternElement(kind);
            elements.add((Object)element);
            if (element.isAssignmentRestElement() || !this.peek(TokenType.COMMA)) break;
            this.eat(TokenType.COMMA);
            if (!this.peek(TokenType.CLOSE_SQUARE)) continue;
            this.reportError("Array pattern may not end with a comma", new Object[0]);
            break;
        }
        this.eat(TokenType.CLOSE_SQUARE);
        return new ArrayPatternTree(this.getTreeLocation(start), (ImmutableList<ParseTree>)elements.build());
    }

    private ParseTree parseObjectPattern(PatternKind kind) {
        SourcePosition start = this.getTreeStartLocation();
        ImmutableList.Builder fields = ImmutableList.builder();
        this.eat(TokenType.OPEN_CURLY);
        while (this.peekObjectPatternField()) {
            fields.add((Object)this.parseObjectPatternField(kind));
            if (!this.peek(TokenType.COMMA)) break;
            this.eat(TokenType.COMMA);
        }
        this.eat(TokenType.CLOSE_CURLY);
        return new ObjectPatternTree(this.getTreeLocation(start), (ImmutableList<ParseTree>)fields.build());
    }

    private boolean peekObjectPatternField() {
        return this.peekPropertyNameOrComputedProp(0);
    }

    private ParseTree parseObjectPatternField(PatternKind kind) {
        Token name;
        SourcePosition start = this.getTreeStartLocation();
        if (this.peekType() == TokenType.OPEN_SQUARE) {
            ParseTree key = this.parseComputedPropertyName();
            this.eat(TokenType.COLON);
            ParseTree value = this.parseObjectPatternFieldTail(kind);
            return new ComputedPropertyDefinitionTree(this.getTreeLocation(start), key, value);
        }
        if (this.peekId() || Keywords.isKeyword(this.peekType())) {
            name = this.eatIdOrKeywordAsId();
            if (!this.peek(TokenType.COLON)) {
                Token idToken = name;
                if (Keywords.isKeyword(idToken.value)) {
                    this.reportError("cannot use keyword '" + name + "' here.", new Object[0]);
                }
                if (this.peek(TokenType.EQUAL)) {
                    IdentifierExpressionTree idTree = new IdentifierExpressionTree(this.getTreeLocation(start), (IdentifierToken)idToken);
                    this.eat(TokenType.EQUAL);
                    ParseTree defaultValue = this.parseAssignmentExpression();
                    return new DefaultParameterTree(this.getTreeLocation(start), idTree, defaultValue);
                }
                return new PropertyNameAssignmentTree(this.getTreeLocation(start), name, null);
            }
        } else {
            name = this.parseLiteralExpression().literalToken;
        }
        this.eat(TokenType.COLON);
        ParseTree value = this.parseObjectPatternFieldTail(kind);
        return new PropertyNameAssignmentTree(this.getTreeLocation(start), name, value);
    }

    private ParseTree parseObjectPatternFieldTail(PatternKind kind) {
        ParseTree value;
        SourcePosition start = this.getTreeStartLocation();
        if (this.peekPattern(kind)) {
            value = this.parsePattern(kind);
        } else {
            ParseTree parseTree = value = kind == PatternKind.ANY ? this.parseLeftHandSideExpression() : this.parseIdentifierExpression();
            if (!value.isValidAssignmentTarget()) {
                this.reportError("invalid assignment target", new Object[0]);
            }
        }
        if (this.peek(TokenType.EQUAL)) {
            this.eat(TokenType.EQUAL);
            ParseTree defaultValue = this.parseAssignmentExpression();
            return new DefaultParameterTree(this.getTreeLocation(start), value, defaultValue);
        }
        return value;
    }

    private ParseTree parseTypeAlias() {
        SourcePosition start = this.getTreeStartLocation();
        this.eat(TokenType.TYPE);
        IdentifierToken alias = this.eatId();
        this.eat(TokenType.EQUAL);
        ParseTree original = this.parseType();
        this.eatPossibleImplicitSemiColon();
        return new TypeAliasTree(this.getTreeLocation(start), alias, original);
    }

    private ParseTree parseAmbientDeclaration() {
        ParseTree declare;
        SourcePosition start = this.getTreeStartLocation();
        this.eat(TokenType.DECLARE);
        switch (this.peekType()) {
            case FUNCTION: {
                declare = this.parseAmbientFunctionDeclaration();
                break;
            }
            case CLASS: {
                declare = this.parseClassDeclaration(true);
                break;
            }
            case ENUM: {
                declare = this.parseEnumDeclaration();
                break;
            }
            default: {
                declare = this.parseVariableDeclarationListNoIn();
                for (VariableDeclarationTree tree : declare.asVariableDeclarationList().declarations) {
                    if (tree.initializer == null) continue;
                    this.reportError("Ambient variable declaration may not have initializer", new Object[0]);
                }
            }
        }
        this.eatPossibleImplicitSemiColon();
        return new AmbientDeclarationTree(this.getTreeLocation(start), declare);
    }

    private void eatPossibleImplicitSemiColon() {
        if (this.peek(TokenType.SEMI_COLON) && this.peekToken().location.start.line == this.getLastLine()) {
            this.eat(TokenType.SEMI_COLON);
            return;
        }
        if (this.peekImplicitSemiColon()) {
            return;
        }
        this.reportError("Semi-colon expected", new Object[0]);
    }

    private boolean peekImplicitSemiColon() {
        return this.peekImplicitSemiColon(0);
    }

    private boolean peekImplicitSemiColon(int index) {
        boolean lineAdvanced = index == 0 ? this.getNextLine() > this.getLastLine() : this.peekToken((int)index).location.start.line > this.peekToken((int)(index - 1)).location.end.line;
        return lineAdvanced || this.peek(index, TokenType.SEMI_COLON) || this.peek(index, TokenType.CLOSE_CURLY) || this.peek(index, TokenType.END_OF_FILE);
    }

    private int getLastLine() {
        return this.lastToken.location.end.line;
    }

    private int getNextLine() {
        return this.peekToken().location.start.line;
    }

    private Token eatOpt(TokenType expectedTokenType) {
        if (this.peek(expectedTokenType)) {
            return this.eat(expectedTokenType);
        }
        return null;
    }

    private boolean inStrictContext() {
        return this.config.isStrictMode;
    }

    private boolean peekId() {
        return this.peekId(0);
    }

    private boolean peekId(int index) {
        TokenType type = this.peekType(index);
        return type == TokenType.IDENTIFIER || type == TokenType.TYPE || type == TokenType.DECLARE || !this.inStrictContext() && Keywords.isStrictKeyword(type);
    }

    private boolean peekAccessibilityModifier() {
        return EnumSet.of(TokenType.PUBLIC, TokenType.PROTECTED, TokenType.PRIVATE).contains((Object)this.peekType());
    }

    private TokenType maybeParseAccessibilityModifier() {
        if (this.peekAccessibilityModifier()) {
            if (!this.config.is6Typed) {
                this.reportError("Accessibility modifier is only supported in ES6 typed mode", new Object[0]);
            }
            return this.nextToken().type;
        }
        return null;
    }

    private IdentifierToken eatIdOpt() {
        return this.peekId() ? this.eatIdOrKeywordAsId() : null;
    }

    private IdentifierToken eatId() {
        if (this.peekId()) {
            return this.eatIdOrKeywordAsId();
        }
        this.reportExpectedError(this.peekToken(), (Object)TokenType.IDENTIFIER);
        return null;
    }

    private Token eatObjectLiteralPropertyName() {
        Token token = this.peekToken();
        switch (token.type) {
            case NUMBER: 
            case STRING: {
                return this.nextToken();
            }
        }
        return this.eatIdOrKeywordAsId();
    }

    private IdentifierToken eatIdOrKeywordAsId() {
        Token token = this.nextToken();
        if (token.type == TokenType.IDENTIFIER) {
            return (IdentifierToken)token;
        }
        if (Keywords.isKeyword(token.type)) {
            return new IdentifierToken(token.location, Keywords.get(token.type).toString());
        }
        this.reportExpectedError(token, (Object)TokenType.IDENTIFIER);
        return null;
    }

    private Token eat(TokenType expectedTokenType) {
        Token token = this.nextToken();
        if (token.type != expectedTokenType) {
            this.reportExpectedError(token, (Object)expectedTokenType);
            return null;
        }
        return token;
    }

    private void reportExpectedError(Token token, Object expected) {
        this.reportError(token, "'%s' expected", expected);
    }

    private SourcePosition getTreeStartLocation() {
        return this.peekToken().location.start;
    }

    private SourcePosition getTreeEndLocation() {
        return this.lastToken.location.end;
    }

    private SourceRange getTreeLocation(SourcePosition start) {
        return new SourceRange(start, this.getTreeEndLocation());
    }

    private Token nextToken() {
        this.lastToken = this.scanner.nextToken();
        return this.lastToken;
    }

    private LiteralToken nextRegularExpressionLiteralToken() {
        LiteralToken lastToken = this.scanner.nextRegularExpressionLiteralToken();
        this.lastToken = lastToken;
        return lastToken;
    }

    private LiteralToken nextTemplateLiteralToken() {
        LiteralToken lastToken = this.scanner.nextTemplateLiteralToken();
        this.lastToken = lastToken;
        return lastToken;
    }

    private boolean peek(TokenType expectedType) {
        return this.peek(0, expectedType);
    }

    private boolean peek(int index, TokenType expectedType) {
        return this.peekType(index) == expectedType;
    }

    private TokenType peekType() {
        return this.peekType(0);
    }

    private TokenType peekType(int index) {
        return this.peekToken((int)index).type;
    }

    private Token peekToken() {
        return this.peekToken(0);
    }

    private Token peekToken(int index) {
        return this.scanner.peekToken(index);
    }

    private Parser createLookaheadParser() {
        return new Parser(this.config, new LookaheadErrorReporter(), this.scanner.getFile(), this.scanner.getOffset(), this.inGeneratorContext());
    }

    private void reportError(Token token, String message, Object ... arguments) {
        if (token == null) {
            this.reportError(message, arguments);
        } else {
            this.errorReporter.reportError(token.getStart(), message, arguments);
        }
    }

    private void reportError(String message, Object ... arguments) {
        this.errorReporter.reportError(this.scanner.getPosition(), message, arguments);
    }

    private static enum PatternKind {
        INITIALIZER,
        ANY;

    }

    private static enum Expression {
        NO_IN,
        NORMAL;

    }

    private static enum ParamContext {
        IMPLEMENTATION,
        SIGNATURE,
        TYPE_EXPRESSION;

    }

    private static class CommentRecorder
    implements Scanner.CommentRecorder {
        private ImmutableList.Builder<Comment> comments = ImmutableList.builder();

        private CommentRecorder() {
        }

        @Override
        public void recordComment(Comment.Type type, SourceRange range, String value) {
            this.comments.add((Object)new Comment(value, range, type));
        }

        private ImmutableList<Comment> getComments() {
            return this.comments.build();
        }
    }

    public static class Config {
        public final boolean is6Typed;
        public final boolean atLeast6;
        public final boolean atLeast5;
        public final boolean isStrictMode;
        public final boolean warnTrailingCommas;
        public final boolean warnLineContinuations;
        public final boolean warnES6NumberLiteral;

        public Config(Mode mode) {
            this.is6Typed = mode == Mode.ES6_TYPED;
            this.atLeast6 = mode == Mode.ES6 || mode == Mode.ES6_STRICT || mode == Mode.ES6_TYPED;
            this.atLeast5 = this.atLeast6 || mode == Mode.ES5 || mode == Mode.ES5_STRICT;
            this.isStrictMode = mode == Mode.ES5_STRICT || mode == Mode.ES6_STRICT || mode == Mode.ES6_TYPED;
            this.warnTrailingCommas = !this.atLeast5;
            this.warnLineContinuations = !this.atLeast6;
            this.warnES6NumberLiteral = !this.atLeast6;
        }

        public static enum Mode {
            ES3,
            ES5,
            ES5_STRICT,
            ES6,
            ES6_STRICT,
            ES6_TYPED;

        }
    }
}

