/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.rhino;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.javascript.rhino.InputId;
import com.google.javascript.rhino.JSDocInfo;
import com.google.javascript.rhino.SimpleSourceFile;
import com.google.javascript.rhino.StaticSourceFile;
import com.google.javascript.rhino.Token;
import com.google.javascript.rhino.TypeI;
import com.google.javascript.rhino.jstype.JSType;
import java.io.IOException;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Set;

public class Node
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final int JSDOC_INFO_PROP = 29;
    public static final int VAR_ARGS_NAME = 30;
    public static final int INCRDECR_PROP = 32;
    public static final int QUOTED_PROP = 36;
    public static final int OPT_ARG_NAME = 37;
    public static final int SYNTHETIC_BLOCK_PROP = 38;
    public static final int ADDED_BLOCK = 39;
    public static final int ORIGINALNAME_PROP = 40;
    public static final int SIDE_EFFECT_FLAGS = 42;
    public static final int IS_CONSTANT_NAME = 43;
    public static final int IS_NAMESPACE = 46;
    public static final int DIRECTIVES = 48;
    public static final int DIRECT_EVAL = 49;
    public static final int FREE_CALL = 50;
    public static final int STATIC_SOURCE_FILE = 51;
    public static final int LENGTH = 52;
    public static final int INPUT_ID = 53;
    public static final int SLASH_V = 54;
    public static final int INFERRED_FUNCTION = 55;
    public static final int CHANGE_TIME = 56;
    public static final int REFLECTED_OBJECT = 57;
    public static final int STATIC_MEMBER = 58;
    public static final int GENERATOR_FN = 59;
    public static final int ARROW_FN = 60;
    public static final int YIELD_FOR = 61;
    public static final int EXPORT_DEFAULT = 62;
    public static final int EXPORT_ALL_FROM = 63;
    public static final int IS_CONSTANT_VAR = 64;
    public static final int GENERATOR_MARKER = 65;
    public static final int GENERATOR_SAFE = 66;
    public static final int COOKED_STRING = 70;
    public static final int RAW_STRING_VALUE = 71;
    public static final int COMPUTED_PROP_METHOD = 72;
    public static final int COMPUTED_PROP_GETTER = 73;
    public static final int COMPUTED_PROP_SETTER = 74;
    public static final int COMPUTED_PROP_VARIABLE = 75;
    public static final int ANALYZED_DURING_GTI = 76;
    public static final int CONSTANT_PROPERTY_DEF = 77;
    public static final int DECLARED_TYPE_EXPR = 78;
    public static final int TYPE_BEFORE_CAST = 79;
    public static final int OPT_ES6_TYPED = 80;
    public static final int GENERIC_TYPE_LIST = 81;
    public static final int IMPLEMENTS = 82;
    public static final int CONSTRUCT_SIGNATURE = 83;
    public static final int ACCESS_MODIFIER = 84;
    public static final int DECR_FLAG = 1;
    public static final int POST_FLAG = 2;
    int type;
    Node next;
    private Node first;
    private Node last;
    private PropListItem propListHead;
    public static final int COLUMN_BITS = 12;
    public static final int MAX_COLUMN_NUMBER = 4095;
    public static final int COLUMN_MASK = 4095;
    private int sourcePosition;
    private TypeI typei;
    private Node parent;
    public static final int FLAG_GLOBAL_STATE_UNMODIFIED = 1;
    public static final int FLAG_THIS_UNMODIFIED = 2;
    public static final int FLAG_ARGUMENTS_UNMODIFIED = 4;
    public static final int FLAG_NO_THROWS = 8;
    public static final int FLAG_LOCAL_RESULTS = 16;
    public static final int SIDE_EFFECTS_FLAGS_MASK = 31;
    public static final int SIDE_EFFECTS_ALL = 0;
    public static final int NO_SIDE_EFFECTS = 15;

    private static final String propToString(int propType) {
        switch (propType) {
            case 30: {
                return "var_args_name";
            }
            case 29: {
                return "jsdoc_info";
            }
            case 32: {
                return "incrdecr";
            }
            case 36: {
                return "quoted";
            }
            case 37: {
                return "opt_arg";
            }
            case 38: {
                return "synthetic";
            }
            case 39: {
                return "added_block";
            }
            case 40: {
                return "originalname";
            }
            case 42: {
                return "side_effect_flags";
            }
            case 43: {
                return "is_constant_name";
            }
            case 46: {
                return "is_namespace";
            }
            case 48: {
                return "directives";
            }
            case 49: {
                return "direct_eval";
            }
            case 50: {
                return "free_call";
            }
            case 51: {
                return "source_file";
            }
            case 53: {
                return "input_id";
            }
            case 52: {
                return "length";
            }
            case 54: {
                return "slash_v";
            }
            case 55: {
                return "inferred";
            }
            case 56: {
                return "change_time";
            }
            case 57: {
                return "reflected_object";
            }
            case 58: {
                return "static_member";
            }
            case 59: {
                return "generator_fn";
            }
            case 60: {
                return "arrow_fn";
            }
            case 61: {
                return "yield_for";
            }
            case 62: {
                return "export_default";
            }
            case 63: {
                return "export_all_from";
            }
            case 64: {
                return "is_constant_var";
            }
            case 65: {
                return "is_generator_marker";
            }
            case 66: {
                return "is_generator_safe";
            }
            case 70: {
                return "cooked_string";
            }
            case 71: {
                return "raw_string_value";
            }
            case 72: {
                return "computed_prop_method";
            }
            case 73: {
                return "computed_prop_getter";
            }
            case 74: {
                return "computed_prop_setter";
            }
            case 75: {
                return "computed_prop_variable";
            }
            case 76: {
                return "analyzed_during_gti";
            }
            case 77: {
                return "constant_property_def";
            }
            case 78: {
                return "declared_type_expr";
            }
            case 79: {
                return "type_before_cast";
            }
            case 80: {
                return "opt_es6_typed";
            }
            case 81: {
                return "generic_type";
            }
            case 82: {
                return "implements";
            }
            case 83: {
                return "construct_signature";
            }
            case 84: {
                return "access_modifier";
            }
        }
        throw new IllegalStateException("unexpected prop id " + propType);
    }

    public Node(int nodeType) {
        this.type = nodeType;
        this.parent = null;
        this.sourcePosition = -1;
    }

    public Node(int nodeType, Node child) {
        Preconditions.checkArgument((child.parent == null ? 1 : 0) != 0, (Object)"new child has existing parent");
        Preconditions.checkArgument((child.next == null ? 1 : 0) != 0, (Object)"new child has existing sibling");
        this.type = nodeType;
        this.parent = null;
        this.first = this.last = child;
        child.next = null;
        child.parent = this;
        this.sourcePosition = -1;
    }

    public Node(int nodeType, Node left, Node right) {
        Preconditions.checkArgument((left.parent == null ? 1 : 0) != 0, (Object)"first new child has existing parent");
        Preconditions.checkArgument((left.next == null ? 1 : 0) != 0, (Object)"first new child has existing sibling");
        Preconditions.checkArgument((right.parent == null ? 1 : 0) != 0, (Object)"second new child has existing parent");
        Preconditions.checkArgument((right.next == null ? 1 : 0) != 0, (Object)"second new child has existing sibling");
        this.type = nodeType;
        this.parent = null;
        this.first = left;
        this.last = right;
        left.next = right;
        left.parent = this;
        right.next = null;
        right.parent = this;
        this.sourcePosition = -1;
    }

    public Node(int nodeType, Node left, Node mid, Node right) {
        Preconditions.checkArgument((left.parent == null ? 1 : 0) != 0);
        Preconditions.checkArgument((left.next == null ? 1 : 0) != 0);
        Preconditions.checkArgument((mid.parent == null ? 1 : 0) != 0);
        Preconditions.checkArgument((mid.next == null ? 1 : 0) != 0);
        Preconditions.checkArgument((right.parent == null ? 1 : 0) != 0);
        Preconditions.checkArgument((right.next == null ? 1 : 0) != 0);
        this.type = nodeType;
        this.parent = null;
        this.first = left;
        this.last = right;
        left.next = mid;
        left.parent = this;
        mid.next = right;
        mid.parent = this;
        right.next = null;
        right.parent = this;
        this.sourcePosition = -1;
    }

    public Node(int nodeType, Node left, Node mid, Node mid2, Node right) {
        Preconditions.checkArgument((left.parent == null ? 1 : 0) != 0);
        Preconditions.checkArgument((left.next == null ? 1 : 0) != 0);
        Preconditions.checkArgument((mid.parent == null ? 1 : 0) != 0);
        Preconditions.checkArgument((mid.next == null ? 1 : 0) != 0);
        Preconditions.checkArgument((mid2.parent == null ? 1 : 0) != 0);
        Preconditions.checkArgument((mid2.next == null ? 1 : 0) != 0);
        Preconditions.checkArgument((right.parent == null ? 1 : 0) != 0);
        Preconditions.checkArgument((right.next == null ? 1 : 0) != 0);
        this.type = nodeType;
        this.parent = null;
        this.first = left;
        this.last = right;
        left.next = mid;
        left.parent = this;
        mid.next = mid2;
        mid.parent = this;
        mid2.next = right;
        mid2.parent = this;
        right.next = null;
        right.parent = this;
        this.sourcePosition = -1;
    }

    public Node(int nodeType, int lineno, int charno) {
        this.type = nodeType;
        this.parent = null;
        this.sourcePosition = Node.mergeLineCharNo(lineno, charno);
    }

    public Node(int nodeType, Node child, int lineno, int charno) {
        this(nodeType, child);
        this.sourcePosition = Node.mergeLineCharNo(lineno, charno);
    }

    public Node(int nodeType, Node left, Node right, int lineno, int charno) {
        this(nodeType, left, right);
        this.sourcePosition = Node.mergeLineCharNo(lineno, charno);
    }

    public Node(int nodeType, Node left, Node mid, Node right, int lineno, int charno) {
        this(nodeType, left, mid, right);
        this.sourcePosition = Node.mergeLineCharNo(lineno, charno);
    }

    public Node(int nodeType, Node left, Node mid, Node mid2, Node right, int lineno, int charno) {
        this(nodeType, left, mid, mid2, right);
        this.sourcePosition = Node.mergeLineCharNo(lineno, charno);
    }

    public Node(int nodeType, Node[] children, int lineno, int charno) {
        this(nodeType, children);
        this.sourcePosition = Node.mergeLineCharNo(lineno, charno);
    }

    public Node(int nodeType, Node[] children) {
        this.type = nodeType;
        this.parent = null;
        if (children.length != 0) {
            this.first = children[0];
            this.last = children[children.length - 1];
            for (int i = 1; i < children.length; ++i) {
                if (null != children[i - 1].next) {
                    throw new IllegalArgumentException("duplicate child");
                }
                children[i - 1].next = children[i];
                Preconditions.checkArgument((children[i - 1].parent == null ? 1 : 0) != 0);
                children[i - 1].parent = this;
            }
            Preconditions.checkArgument((children[children.length - 1].parent == null ? 1 : 0) != 0);
            children[children.length - 1].parent = this;
            if (null != this.last.next) {
                throw new IllegalArgumentException("duplicate child");
            }
        }
    }

    public static Node newNumber(double number) {
        return new NumberNode(number);
    }

    public static Node newNumber(double number, int lineno, int charno) {
        return new NumberNode(number, lineno, charno);
    }

    public static Node newString(String str) {
        return new StringNode(40, str);
    }

    public static Node newString(int type, String str) {
        return new StringNode(type, str);
    }

    public static Node newString(String str, int lineno, int charno) {
        return new StringNode(40, str, lineno, charno);
    }

    public static Node newString(int type, String str, int lineno, int charno) {
        return new StringNode(type, str, lineno, charno);
    }

    public int getType() {
        return this.type;
    }

    public void setType(int type) {
        this.type = type;
    }

    public boolean hasChildren() {
        return this.first != null;
    }

    public Node getFirstChild() {
        return this.first;
    }

    public Node getLastChild() {
        return this.last;
    }

    public Node getNext() {
        return this.next;
    }

    public Node getChildBefore(Node child) {
        if (child == this.first) {
            return null;
        }
        Node n = this.first;
        if (n == null) {
            throw new RuntimeException("node is not a child");
        }
        while (n.next != child) {
            n = n.next;
            if (n != null) continue;
            throw new RuntimeException("node is not a child");
        }
        return n;
    }

    public Node getChildAtIndex(int i) {
        Node n = this.first;
        while (i > 0) {
            n = n.next;
            --i;
        }
        return n;
    }

    public int getIndexOfChild(Node child) {
        Node n = this.first;
        int i = 0;
        while (n != null) {
            if (child == n) {
                return i;
            }
            n = n.next;
            ++i;
        }
        return -1;
    }

    public Node getLastSibling() {
        Node n = this;
        while (n.next != null) {
            n = n.next;
        }
        return n;
    }

    public void addChildToFront(Node child) {
        Preconditions.checkArgument((child.parent == null ? 1 : 0) != 0);
        Preconditions.checkArgument((child.next == null ? 1 : 0) != 0);
        child.parent = this;
        child.next = this.first;
        this.first = child;
        if (this.last == null) {
            this.last = child;
        }
    }

    public void addChildToBack(Node child) {
        Preconditions.checkArgument((child.parent == null ? 1 : 0) != 0);
        Preconditions.checkArgument((child.next == null ? 1 : 0) != 0);
        child.parent = this;
        child.next = null;
        if (this.last == null) {
            this.first = this.last = child;
            return;
        }
        this.last.next = child;
        this.last = child;
    }

    public void addChildrenToFront(Node children) {
        Node child = children;
        while (child != null) {
            Preconditions.checkArgument((child.parent == null ? 1 : 0) != 0);
            child.parent = this;
            child = child.next;
        }
        Node lastSib = children.getLastSibling();
        lastSib.next = this.first;
        this.first = children;
        if (this.last == null) {
            this.last = lastSib;
        }
    }

    public void addChildrenToBack(Node children) {
        this.addChildrenAfter(children, this.getLastChild());
    }

    public void addChildBefore(Node newChild, Node node) {
        Preconditions.checkArgument((node != null && node.parent == this ? 1 : 0) != 0, (Object)"The existing child node of the parent should not be null.");
        Preconditions.checkArgument((newChild.next == null ? 1 : 0) != 0, (Object)"The new child node has siblings.");
        Preconditions.checkArgument((newChild.parent == null ? 1 : 0) != 0, (Object)"The new child node already has a parent.");
        if (this.first == node) {
            newChild.parent = this;
            newChild.next = this.first;
            this.first = newChild;
            return;
        }
        Node prev = this.getChildBefore(node);
        this.addChildAfter(newChild, prev);
    }

    public void addChildAfter(Node newChild, Node node) {
        Preconditions.checkArgument((newChild.next == null ? 1 : 0) != 0, (Object)"The new child node has siblings.");
        this.addChildrenAfter(newChild, node);
    }

    public void addChildrenAfter(Node children, Node node) {
        Preconditions.checkArgument((node == null || node.parent == this ? 1 : 0) != 0);
        Node child = children;
        while (child != null) {
            Preconditions.checkArgument((child.parent == null ? 1 : 0) != 0);
            child.parent = this;
            child = child.next;
        }
        Node lastSibling = children.getLastSibling();
        if (node != null) {
            Node oldNext = node.next;
            node.next = children;
            lastSibling.next = oldNext;
            if (node == this.last) {
                this.last = lastSibling;
            }
        } else {
            if (this.first != null) {
                lastSibling.next = this.first;
            } else {
                this.last = lastSibling;
            }
            this.first = children;
        }
    }

    public void removeChild(Node child) {
        Node prev = this.getChildBefore(child);
        if (prev == null) {
            this.first = this.first.next;
        } else {
            prev.next = child.next;
        }
        if (child == this.last) {
            this.last = prev;
        }
        child.next = null;
        child.parent = null;
    }

    public void replaceChild(Node child, Node newChild) {
        Preconditions.checkArgument((newChild.next == null ? 1 : 0) != 0, (Object)"The new child node has siblings.");
        Preconditions.checkArgument((newChild.parent == null ? 1 : 0) != 0, (Object)"The new child node already has a parent.");
        newChild.copyInformationFrom(child);
        newChild.next = child.next;
        newChild.parent = this;
        if (child == this.first) {
            this.first = newChild;
        } else {
            Node prev = this.getChildBefore(child);
            prev.next = newChild;
        }
        if (child == this.last) {
            this.last = newChild;
        }
        child.next = null;
        child.parent = null;
    }

    public void replaceChildAfter(Node prevChild, Node newChild) {
        Preconditions.checkArgument((prevChild.parent == this ? 1 : 0) != 0, (Object)"prev is not a child of this node.");
        Preconditions.checkArgument((newChild.next == null ? 1 : 0) != 0, (Object)"The new child node has siblings.");
        Preconditions.checkArgument((newChild.parent == null ? 1 : 0) != 0, (Object)"The new child node already has a parent.");
        newChild.copyInformationFrom(prevChild);
        Node child = prevChild.next;
        newChild.next = child.next;
        newChild.parent = this;
        prevChild.next = newChild;
        if (child == this.last) {
            this.last = newChild;
        }
        child.next = null;
        child.parent = null;
    }

    @VisibleForTesting
    PropListItem lookupProperty(int propType) {
        PropListItem x;
        for (x = this.propListHead; x != null && propType != x.getType(); x = x.getNext()) {
        }
        return x;
    }

    public Node clonePropsFrom(Node other) {
        Preconditions.checkState((this.propListHead == null ? 1 : 0) != 0, (Object)"Node has existing properties.");
        this.propListHead = other.propListHead;
        return this;
    }

    public void removeProp(int propType) {
        PropListItem result = this.removeProp(this.propListHead, propType);
        if (result != this.propListHead) {
            this.propListHead = result;
        }
    }

    public boolean hasProps() {
        return this.propListHead != null;
    }

    private PropListItem removeProp(PropListItem item, int propType) {
        if (item == null) {
            return null;
        }
        if (item.getType() == propType) {
            return item.getNext();
        }
        PropListItem result = this.removeProp(item.getNext(), propType);
        if (result != item.getNext()) {
            return item.chain(result);
        }
        return item;
    }

    public Object getProp(int propType) {
        PropListItem item = this.lookupProperty(propType);
        if (item == null) {
            return null;
        }
        return item.getObjectValue();
    }

    public boolean getBooleanProp(int propType) {
        return this.getIntProp(propType) != 0;
    }

    public int getIntProp(int propType) {
        PropListItem item = this.lookupProperty(propType);
        if (item == null) {
            return 0;
        }
        return item.getIntValue();
    }

    public int getExistingIntProp(int propType) {
        PropListItem item = this.lookupProperty(propType);
        if (item == null) {
            throw new IllegalStateException("missing prop: " + propType);
        }
        return item.getIntValue();
    }

    public void putProp(int propType, Object value) {
        this.removeProp(propType);
        if (value != null) {
            this.propListHead = this.createProp(propType, value, this.propListHead);
        }
    }

    public void putBooleanProp(int propType, boolean value) {
        this.putIntProp(propType, value ? 1 : 0);
    }

    public void putIntProp(int propType, int value) {
        this.removeProp(propType);
        if (value != 0) {
            this.propListHead = this.createProp(propType, value, this.propListHead);
        }
    }

    public void setDeclaredTypeExpression(TypeDeclarationNode typeExpression) {
        this.putProp(78, typeExpression);
    }

    public TypeDeclarationNode getDeclaredTypeExpression() {
        return (TypeDeclarationNode)this.getProp(78);
    }

    PropListItem createProp(int propType, Object value, PropListItem next) {
        return new ObjectPropListItem(propType, value, next);
    }

    PropListItem createProp(int propType, int value, PropListItem next) {
        return new IntPropListItem(propType, value, next);
    }

    public JSType getJSTypeBeforeCast() {
        return (JSType)this.getProp(79);
    }

    private int[] getSortedPropTypes() {
        int count = 0;
        for (PropListItem x = this.propListHead; x != null; x = x.getNext()) {
            ++count;
        }
        int[] keys = new int[count];
        for (PropListItem x = this.propListHead; x != null; x = x.getNext()) {
            keys[--count] = x.getType();
        }
        Arrays.sort(keys);
        return keys;
    }

    public double getDouble() throws UnsupportedOperationException {
        if (this.getType() == 39) {
            throw new IllegalStateException("Number node not created with Node.newNumber");
        }
        throw new UnsupportedOperationException(this + " is not a number node");
    }

    public void setDouble(double value) throws UnsupportedOperationException {
        if (this.getType() == 39) {
            throw new IllegalStateException("Number node not created with Node.newNumber");
        }
        throw new UnsupportedOperationException(this + " is not a string node");
    }

    public String getString() throws UnsupportedOperationException {
        if (this.getType() == 40) {
            throw new IllegalStateException("String node not created with Node.newString");
        }
        throw new UnsupportedOperationException(this + " is not a string node");
    }

    public void setString(String value) throws UnsupportedOperationException {
        if (this.getType() == 40 || this.getType() == 38) {
            throw new IllegalStateException("String node not created with Node.newString");
        }
        throw new UnsupportedOperationException(this + " is not a string node");
    }

    public String toString() {
        return this.toString(true, true, true);
    }

    public String toString(boolean printSource, boolean printAnnotations, boolean printType) {
        StringBuilder sb = new StringBuilder();
        this.toString(sb, printSource, printAnnotations, printType);
        return sb.toString();
    }

    private void toString(StringBuilder sb, boolean printSource, boolean printAnnotations, boolean printType) {
        String typeString;
        int lineno;
        sb.append(Token.name(this.type));
        if (this instanceof StringNode) {
            sb.append(' ');
            sb.append(this.getString());
        } else if (this.type == 105) {
            sb.append(' ');
            if (this.first == null || this.first.getType() != 38) {
                sb.append("<invalid>");
            } else {
                sb.append(this.first.getString());
            }
        } else if (this.type == 39) {
            sb.append(' ');
            sb.append(this.getDouble());
        }
        if (printSource && (lineno = this.getLineno()) != -1) {
            sb.append(' ');
            sb.append(lineno);
        }
        if (printAnnotations) {
            int[] keys = this.getSortedPropTypes();
            for (int i = 0; i < keys.length; ++i) {
                int type = keys[i];
                PropListItem x = this.lookupProperty(type);
                sb.append(" [");
                sb.append(Node.propToString(type));
                sb.append(": ");
                switch (type) {
                    default: 
                }
                String value = x.toString();
                sb.append(value);
                sb.append(']');
            }
        }
        if (printType && this.typei != null && (typeString = this.typei.toString()) != null) {
            sb.append(" : ");
            sb.append(typeString);
        }
    }

    public String toStringTree() {
        return this.toStringTreeImpl();
    }

    private String toStringTreeImpl() {
        try {
            StringBuilder s = new StringBuilder();
            this.appendStringTree(s);
            return s.toString();
        }
        catch (IOException e) {
            throw new RuntimeException("Should not happen\n" + e);
        }
    }

    public void appendStringTree(Appendable appendable) throws IOException {
        Node.toStringTreeHelper(this, 0, appendable);
    }

    private static void toStringTreeHelper(Node n, int level, Appendable sb) throws IOException {
        for (int i = 0; i != level; ++i) {
            sb.append("    ");
        }
        sb.append(n.toString());
        sb.append('\n');
        for (Node cursor = n.getFirstChild(); cursor != null; cursor = cursor.getNext()) {
            Node.toStringTreeHelper(cursor, level + 1, sb);
        }
    }

    public void setStaticSourceFile(StaticSourceFile file) {
        this.putProp(51, file);
    }

    public void setSourceFileForTesting(String name) {
        this.putProp(51, new SimpleSourceFile(name, false));
    }

    public String getSourceFileName() {
        StaticSourceFile file = this.getStaticSourceFile();
        return file == null ? null : file.getName();
    }

    public StaticSourceFile getStaticSourceFile() {
        return (StaticSourceFile)this.getProp(51);
    }

    public void setInputId(InputId inputId) {
        this.putProp(53, inputId);
    }

    public InputId getInputId() {
        return (InputId)this.getProp(53);
    }

    public boolean isFromExterns() {
        StaticSourceFile file = this.getStaticSourceFile();
        return file == null ? false : file.isExtern();
    }

    public int getLength() {
        return this.getIntProp(52);
    }

    public void setLength(int length) {
        this.putIntProp(52, length);
    }

    public int getLineno() {
        return Node.extractLineno(this.sourcePosition);
    }

    public int getCharno() {
        return Node.extractCharno(this.sourcePosition);
    }

    public int getSourceOffset() {
        StaticSourceFile file = this.getStaticSourceFile();
        if (file == null) {
            return -1;
        }
        int lineno = this.getLineno();
        if (lineno == -1) {
            return -1;
        }
        return file.getLineOffset(lineno) + this.getCharno();
    }

    public int getSourcePosition() {
        return this.sourcePosition;
    }

    public void setLineno(int lineno) {
        int charno = this.getCharno();
        if (charno == -1) {
            charno = 0;
        }
        this.sourcePosition = Node.mergeLineCharNo(lineno, charno);
    }

    public void setCharno(int charno) {
        this.sourcePosition = Node.mergeLineCharNo(this.getLineno(), charno);
    }

    public void setSourceEncodedPosition(int sourcePosition) {
        this.sourcePosition = sourcePosition;
    }

    public void setSourceEncodedPositionForTree(int sourcePosition) {
        this.sourcePosition = sourcePosition;
        for (Node child = this.getFirstChild(); child != null; child = child.getNext()) {
            child.setSourceEncodedPositionForTree(sourcePosition);
        }
    }

    protected static int mergeLineCharNo(int lineno, int charno) {
        if (lineno < 0 || charno < 0) {
            return -1;
        }
        if ((charno & 0xFFFFF000) != 0) {
            return lineno << 12 | 0xFFF;
        }
        return lineno << 12 | charno & 0xFFF;
    }

    protected static int extractLineno(int lineCharNo) {
        if (lineCharNo == -1) {
            return -1;
        }
        return lineCharNo >>> 12;
    }

    protected static int extractCharno(int lineCharNo) {
        if (lineCharNo == -1) {
            return -1;
        }
        return lineCharNo & 0xFFF;
    }

    public Iterable<Node> children() {
        if (this.first == null) {
            return Collections.emptySet();
        }
        return new SiblingNodeIterable(this.first);
    }

    public Iterable<Node> siblings() {
        return new SiblingNodeIterable(this);
    }

    PropListItem getPropListHeadForTesting() {
        return this.propListHead;
    }

    void setPropListHead(PropListItem propListHead) {
        this.propListHead = propListHead;
    }

    public Node getParent() {
        return this.parent;
    }

    public Node getAncestor(int level) {
        Node node;
        Preconditions.checkArgument((level >= 0 ? 1 : 0) != 0);
        for (node = this; node != null && level-- > 0; node = node.getParent()) {
        }
        return node;
    }

    public AncestorIterable getAncestors() {
        return new AncestorIterable(this.getParent());
    }

    public boolean hasOneChild() {
        return this.first != null && this.first == this.last;
    }

    public boolean hasMoreThanOneChild() {
        return this.first != null && this.first != this.last;
    }

    public int getChildCount() {
        int c = 0;
        Node n = this.first;
        while (n != null) {
            ++c;
            n = n.next;
        }
        return c;
    }

    public boolean hasChild(Node child) {
        for (Node n = this.first; n != null; n = n.getNext()) {
            if (child != n) continue;
            return true;
        }
        return false;
    }

    @VisibleForTesting
    public String checkTreeEquals(Node actual) {
        NodeMismatch diff = this.checkTreeEqualsImpl(actual);
        if (diff != null) {
            return "Node tree inequality:\nTree1:\n" + this.toStringTree() + "\n\nTree2:\n" + actual.toStringTree() + "\n\nSubtree1: " + diff.nodeA.toStringTree() + "\n\nSubtree2: " + diff.nodeB.toStringTree();
        }
        return null;
    }

    @VisibleForTesting
    public String checkTreeEqualsIncludingJsDoc(Node actual) {
        NodeMismatch diff = this.checkTreeEqualsImpl(actual, true);
        if (diff != null) {
            if (diff.nodeA.isEquivalentTo(diff.nodeB, false, true, false)) {
                String jsDoc1 = diff.nodeA.getJSDocInfo() == null ? "(none)" : diff.nodeA.getJSDocInfo().toStringVerbose();
                String jsDoc2 = diff.nodeB.getJSDocInfo() == null ? "(none)" : diff.nodeB.getJSDocInfo().toStringVerbose();
                return "Node tree inequality:\nTree:\n" + this.toStringTree() + "\n\nJSDoc differs on subtree: " + diff.nodeA + "\nExpected JSDoc: " + jsDoc1 + "\nActual JSDoc  : " + jsDoc2;
            }
            return "Node tree inequality:\nExpected tree:\n" + this.toStringTree() + "\n\nActual tree:\n" + actual.toStringTree() + "\n\nExpected subtree: " + diff.nodeA.toStringTree() + "\n\nActual subtree: " + diff.nodeB.toStringTree();
        }
        return null;
    }

    NodeMismatch checkTreeEqualsImpl(Node node2) {
        return this.checkTreeEqualsImpl(node2, false);
    }

    private NodeMismatch checkTreeEqualsImpl(Node node2, boolean jsDoc) {
        if (!this.isEquivalentTo(node2, false, false, jsDoc)) {
            return new NodeMismatch(this, node2);
        }
        NodeMismatch res = null;
        Node n = this.first;
        Node n2 = node2.first;
        while (n != null) {
            res = n.checkTreeEqualsImpl(n2, jsDoc);
            if (res != null) {
                return res;
            }
            n = n.next;
            n2 = n2.next;
        }
        return res;
    }

    public boolean isEquivalentTo(Node node) {
        return this.isEquivalentTo(node, false, true, false);
    }

    public boolean isEquivalentToShallow(Node node) {
        return this.isEquivalentTo(node, false, false, false);
    }

    public boolean isEquivalentToTyped(Node node) {
        return this.isEquivalentTo(node, true, true, true);
    }

    boolean isEquivalentTo(Node node, boolean compareType, boolean recurse, boolean jsDoc) {
        if (this.type != node.getType() || this.getChildCount() != node.getChildCount() || this.getClass() != node.getClass()) {
            return false;
        }
        if (compareType && !JSType.isEquivalent(this.getJSType(), node.getJSType())) {
            return false;
        }
        if (jsDoc && !JSDocInfo.areEquivalent(this.getJSDocInfo(), node.getJSDocInfo())) {
            return false;
        }
        TypeDeclarationNode thisTDN = this.getDeclaredTypeExpression();
        TypeDeclarationNode thatTDN = node.getDeclaredTypeExpression();
        if (!(thisTDN == null && thatTDN == null || thisTDN != null && thatTDN != null && thisTDN.isEquivalentTo(thatTDN, compareType, recurse, jsDoc))) {
            return false;
        }
        if (this.type == 102 || this.type == 103) {
            int post2;
            int post1 = this.getIntProp(32);
            if (post1 != (post2 = node.getIntProp(32))) {
                return false;
            }
        } else if (this.type == 40 || this.type == 154) {
            int slashV2;
            int quoted2;
            int quoted1;
            if (this.type == 154 && (quoted1 = this.getIntProp(36)) != (quoted2 = node.getIntProp(36))) {
                return false;
            }
            int slashV1 = this.getIntProp(54);
            if (slashV1 != (slashV2 = node.getIntProp(54))) {
                return false;
            }
        } else if (this.type == 37 ? this.getBooleanProp(50) != node.getBooleanProp(50) : this.type == 105 && this.isArrowFunction() != node.isArrowFunction()) {
            return false;
        }
        if (recurse) {
            Node n = this.first;
            Node n2 = node.first;
            while (n != null) {
                if (!n.isEquivalentTo(n2, compareType, recurse, jsDoc)) {
                    return false;
                }
                n = n.next;
                n2 = n2.next;
            }
        }
        return true;
    }

    public String getQualifiedName() {
        if (this.type == 38) {
            String name = this.getString();
            return name.isEmpty() ? null : name;
        }
        if (this.type == 33) {
            String left = this.getFirstChild().getQualifiedName();
            if (left == null) {
                return null;
            }
            return left + "." + this.getLastChild().getString();
        }
        if (this.type == 42) {
            return "this";
        }
        if (this.type == 161) {
            return "super";
        }
        return null;
    }

    public boolean isQualifiedName() {
        switch (this.getType()) {
            case 38: {
                return !this.getString().isEmpty();
            }
            case 42: {
                return true;
            }
            case 33: {
                return this.getFirstChild().isQualifiedName();
            }
        }
        return false;
    }

    public boolean matchesQualifiedName(String name) {
        return name != null && this.matchesQualifiedName(name, name.length());
    }

    private boolean matchesQualifiedName(String qname, int endIndex) {
        int start = qname.lastIndexOf(46, endIndex - 1) + 1;
        switch (this.getType()) {
            case 38: {
                String name = this.getString();
                return start == 0 && !name.isEmpty() && name.length() == endIndex && qname.startsWith(name);
            }
            case 42: {
                return start == 0 && 4 == endIndex && qname.startsWith("this");
            }
            case 161: {
                return start == 0 && 5 == endIndex && qname.startsWith("super");
            }
            case 33: {
                String prop = this.getLastChild().getString();
                return start > 1 && prop.length() == endIndex - start && prop.regionMatches(0, qname, start, endIndex - start) && this.getFirstChild().matchesQualifiedName(qname, start - 1);
            }
        }
        return false;
    }

    public boolean matchesQualifiedName(Node n) {
        if (n == null || n.type != this.type) {
            return false;
        }
        switch (this.type) {
            case 38: {
                return !this.getString().isEmpty() && this.getString().equals(n.getString());
            }
            case 42: {
                return true;
            }
            case 161: {
                return true;
            }
            case 33: {
                return this.getLastChild().getString().equals(n.getLastChild().getString()) && this.getFirstChild().matchesQualifiedName(n.getFirstChild());
            }
        }
        return false;
    }

    public boolean isUnscopedQualifiedName() {
        switch (this.getType()) {
            case 38: {
                return !this.getString().isEmpty();
            }
            case 33: {
                return this.getFirstChild().isUnscopedQualifiedName();
            }
        }
        return false;
    }

    public boolean isValidAssignmentTarget() {
        switch (this.getType()) {
            case 33: 
            case 35: 
            case 38: 
            case 155: 
            case 156: 
            case 157: 
            case 179: {
                return true;
            }
        }
        return false;
    }

    public Node detachFromParent() {
        Preconditions.checkState((this.parent != null ? 1 : 0) != 0);
        this.parent.removeChild(this);
        return this;
    }

    public Node removeFirstChild() {
        Node child = this.first;
        if (child != null) {
            this.removeChild(child);
        }
        return child;
    }

    public Node removeChildren() {
        Node children = this.first;
        for (Node child = this.first; child != null; child = child.getNext()) {
            child.parent = null;
        }
        this.first = null;
        this.last = null;
        return children;
    }

    public void detachChildren() {
        Node child = this.first;
        while (child != null) {
            Node nextChild = child.getNext();
            child.parent = null;
            child.next = null;
            child = nextChild;
        }
        this.first = null;
        this.last = null;
    }

    public Node removeChildAfter(Node prev) {
        Preconditions.checkArgument((prev.parent == this ? 1 : 0) != 0, (Object)"prev is not a child of this node.");
        Preconditions.checkArgument((prev.next != null ? 1 : 0) != 0, (Object)"no next sibling.");
        Node child = prev.next;
        prev.next = child.next;
        if (child == this.last) {
            this.last = prev;
        }
        child.next = null;
        child.parent = null;
        return child;
    }

    public Node cloneNode() {
        return this.copyNodeFields(new Node(this.type));
    }

    <T extends Node> T copyNodeFields(T dst) {
        dst.setSourceEncodedPosition(this.sourcePosition);
        dst.setTypeI(this.typei);
        dst.setPropListHead(this.propListHead);
        return dst;
    }

    public Node cloneTree() {
        Node result = this.cloneNode();
        for (Node n2 = this.getFirstChild(); n2 != null; n2 = n2.getNext()) {
            Node n2clone = n2.cloneTree();
            n2clone.parent = result;
            if (result.last != null) {
                result.last.next = n2clone;
            }
            if (result.first == null) {
                result.first = n2clone;
            }
            result.last = n2clone;
        }
        return result;
    }

    public Node copyInformationFrom(Node other) {
        if (this.getProp(40) == null) {
            this.putProp(40, other.getProp(40));
        }
        if (this.getProp(51) == null) {
            this.putProp(51, other.getProp(51));
            this.sourcePosition = other.sourcePosition;
        }
        return this;
    }

    public Node copyInformationFromForTree(Node other) {
        this.copyInformationFrom(other);
        for (Node child = this.getFirstChild(); child != null; child = child.getNext()) {
            child.copyInformationFromForTree(other);
        }
        return this;
    }

    public Node useSourceInfoFrom(Node other) {
        this.putProp(40, other.getProp(40));
        this.putProp(51, other.getProp(51));
        this.sourcePosition = other.sourcePosition;
        this.setLength(other.getLength());
        return this;
    }

    public Node srcref(Node other) {
        return this.useSourceInfoFrom(other);
    }

    public Node useSourceInfoFromForTree(Node other) {
        this.useSourceInfoFrom(other);
        for (Node child = this.getFirstChild(); child != null; child = child.getNext()) {
            child.useSourceInfoFromForTree(other);
        }
        return this;
    }

    public Node srcrefTree(Node other) {
        return this.useSourceInfoFromForTree(other);
    }

    public Node useSourceInfoIfMissingFrom(Node other) {
        if (this.getProp(40) == null) {
            this.putProp(40, other.getProp(40));
        }
        if (this.getProp(51) == null) {
            this.putProp(51, other.getProp(51));
            this.sourcePosition = other.sourcePosition;
            this.setLength(other.getLength());
        }
        return this;
    }

    public Node useSourceInfoIfMissingFromForTree(Node other) {
        this.useSourceInfoIfMissingFrom(other);
        for (Node child = this.getFirstChild(); child != null; child = child.getNext()) {
            child.useSourceInfoIfMissingFromForTree(other);
        }
        return this;
    }

    public JSType getJSType() {
        return this.typei instanceof JSType ? (JSType)this.typei : null;
    }

    public void setJSType(JSType jsType) {
        this.typei = jsType;
    }

    public TypeI getTypeI() {
        return this.getJSType();
    }

    public void setTypeI(TypeI type) {
        this.typei = type;
    }

    public JSDocInfo getJSDocInfo() {
        return (JSDocInfo)this.getProp(29);
    }

    public Node setJSDocInfo(JSDocInfo info) {
        this.putProp(29, info);
        return this;
    }

    public void setChangeTime(int time) {
        this.putIntProp(56, time);
    }

    public int getChangeTime() {
        return this.getIntProp(56);
    }

    public void setVarArgs(boolean varArgs) {
        this.putBooleanProp(30, varArgs);
    }

    public boolean isVarArgs() {
        return this.getBooleanProp(30);
    }

    public void setOptionalArg(boolean optionalArg) {
        this.putBooleanProp(37, optionalArg);
    }

    public boolean isOptionalArg() {
        return this.getBooleanProp(37);
    }

    public void setIsSyntheticBlock(boolean val) {
        this.putBooleanProp(38, val);
    }

    public boolean isSyntheticBlock() {
        return this.getBooleanProp(38);
    }

    public void setDirectives(Set<String> val) {
        this.putProp(48, val);
    }

    public Set<String> getDirectives() {
        return (Set)this.getProp(48);
    }

    public void setIsAddedBlock(boolean val) {
        this.putBooleanProp(39, val);
    }

    public boolean isAddedBlock() {
        return this.getBooleanProp(39);
    }

    public void setStaticMember(boolean isStatic) {
        this.putBooleanProp(58, isStatic);
    }

    public boolean isStaticMember() {
        return this.getBooleanProp(58);
    }

    public void setIsGeneratorFunction(boolean isGenerator) {
        this.putBooleanProp(59, isGenerator);
    }

    public boolean isGeneratorFunction() {
        return this.getBooleanProp(59);
    }

    public void setGeneratorMarker(boolean isGeneratorMarker) {
        this.putBooleanProp(65, isGeneratorMarker);
    }

    public boolean isGeneratorMarker() {
        return this.getBooleanProp(65);
    }

    public void setGeneratorSafe(boolean isGeneratorSafe) {
        this.putBooleanProp(66, isGeneratorSafe);
    }

    public boolean isGeneratorSafe() {
        return this.getBooleanProp(66);
    }

    public void setIsArrowFunction(boolean isArrow) {
        this.putBooleanProp(60, isArrow);
    }

    public boolean isArrowFunction() {
        return this.getBooleanProp(60);
    }

    public void setYieldFor(boolean isGenerator) {
        this.putBooleanProp(61, isGenerator);
    }

    public boolean isYieldFor() {
        return this.getBooleanProp(61);
    }

    public void setSideEffectFlags(int flags) {
        Preconditions.checkArgument((this.getType() == 37 || this.getType() == 30 ? 1 : 0) != 0, (String)"setIsNoSideEffectsCall only supports CALL and NEW nodes, got %s", (Object[])new Object[]{Token.name(this.getType())});
        this.putIntProp(42, flags);
    }

    public void setSideEffectFlags(SideEffectFlags flags) {
        this.setSideEffectFlags(flags.valueOf());
    }

    public int getSideEffectFlags() {
        return this.getIntProp(42);
    }

    public boolean isOnlyModifiesThisCall() {
        return this.areBitFlagsSet(this.getSideEffectFlags() & 0xF, 13);
    }

    public boolean isOnlyModifiesArgumentsCall() {
        return this.areBitFlagsSet(this.getSideEffectFlags() & 0xF, 11);
    }

    public boolean isNoSideEffectsCall() {
        return this.areBitFlagsSet(this.getSideEffectFlags(), 15);
    }

    public boolean isLocalResultCall() {
        return this.areBitFlagsSet(this.getSideEffectFlags(), 16);
    }

    public boolean mayMutateArguments() {
        return !this.areBitFlagsSet(this.getSideEffectFlags(), 4);
    }

    public boolean mayMutateGlobalStateOrThrow() {
        return !this.areBitFlagsSet(this.getSideEffectFlags(), 9);
    }

    private boolean areBitFlagsSet(int value, int flags) {
        return (value & flags) == flags;
    }

    public boolean isQuotedString() {
        return false;
    }

    public void setQuotedString() {
        throw new IllegalStateException("not a StringNode");
    }

    public boolean isAdd() {
        return this.getType() == 21;
    }

    public boolean isAnd() {
        return this.getType() == 101;
    }

    public boolean isArrayLit() {
        return this.getType() == 63;
    }

    public boolean isArrayPattern() {
        return this.getType() == 156;
    }

    public boolean isAssign() {
        return this.getType() == 86;
    }

    public boolean isAssignAdd() {
        return this.getType() == 93;
    }

    public boolean isBlock() {
        return this.getType() == 125;
    }

    public boolean isBreak() {
        return this.getType() == 116;
    }

    public boolean isCall() {
        return this.getType() == 37;
    }

    public boolean isCase() {
        return this.getType() == 111;
    }

    public boolean isCast() {
        return this.getType() == 155;
    }

    public boolean isCatch() {
        return this.getType() == 120;
    }

    public boolean isClass() {
        return this.getType() == 158;
    }

    public boolean isClassMembers() {
        return this.getType() == 159;
    }

    public boolean isComma() {
        return this.getType() == 85;
    }

    public boolean isComputedProp() {
        return this.getType() == 175;
    }

    public boolean isContinue() {
        return this.getType() == 117;
    }

    public boolean isConst() {
        return this.getType() == 149;
    }

    public boolean isDebugger() {
        return this.getType() == 152;
    }

    public boolean isDec() {
        return this.getType() == 103;
    }

    public boolean isDefaultCase() {
        return this.getType() == 112;
    }

    public boolean isDefaultValue() {
        return this.getType() == 179;
    }

    public boolean isDelProp() {
        return this.getType() == 31;
    }

    public boolean isDestructuringPattern() {
        return this.isObjectPattern() || this.isArrayPattern();
    }

    public boolean isDo() {
        return this.getType() == 114;
    }

    public boolean isEmpty() {
        return this.getType() == 124;
    }

    public boolean isExport() {
        return this.getType() == 169;
    }

    public boolean isExprResult() {
        return this.getType() == 130;
    }

    public boolean isFalse() {
        return this.getType() == 43;
    }

    public boolean isFor() {
        return this.getType() == 115;
    }

    public boolean isForOf() {
        return this.getType() == 163;
    }

    public boolean isFunction() {
        return this.getType() == 105;
    }

    public boolean isGetterDef() {
        return this.getType() == 147;
    }

    public boolean isGetElem() {
        return this.getType() == 35;
    }

    public boolean isGetProp() {
        return this.getType() == 33;
    }

    public boolean isHook() {
        return this.getType() == 98;
    }

    public boolean isIf() {
        return this.getType() == 108;
    }

    public boolean isImport() {
        return this.getType() == 165;
    }

    public boolean isIn() {
        return this.getType() == 51;
    }

    public boolean isInc() {
        return this.getType() == 102;
    }

    public boolean isInstanceOf() {
        return this.getType() == 52;
    }

    public boolean isInterfaceMembers() {
        return this.getType() == 313;
    }

    public boolean isRecordType() {
        return this.getType() == 213;
    }

    public boolean isIndexSignature() {
        return this.getType() == 320;
    }

    public boolean isLabel() {
        return this.getType() == 126;
    }

    public boolean isLabelName() {
        return this.getType() == 153;
    }

    public boolean isLet() {
        return this.getType() == 162;
    }

    public boolean isMemberFunctionDef() {
        return this.getType() == 160;
    }

    public boolean isMemberVariableDef() {
        return this.getType() == 319;
    }

    public boolean isName() {
        return this.getType() == 38;
    }

    public boolean isNE() {
        return this.getType() == 13;
    }

    public boolean isNew() {
        return this.getType() == 30;
    }

    public boolean isNot() {
        return this.getType() == 26;
    }

    public boolean isNull() {
        return this.getType() == 41;
    }

    public boolean isNumber() {
        return this.getType() == 39;
    }

    public boolean isObjectLit() {
        return this.getType() == 64;
    }

    public boolean isObjectPattern() {
        return this.getType() == 157;
    }

    public boolean isOr() {
        return this.getType() == 100;
    }

    public boolean isParamList() {
        return this.getType() == 83;
    }

    public boolean isRegExp() {
        return this.getType() == 47;
    }

    public boolean isRest() {
        return this.getType() == 173;
    }

    public boolean isReturn() {
        return this.getType() == 4;
    }

    public boolean isScript() {
        return this.getType() == 132;
    }

    public boolean isSetterDef() {
        return this.getType() == 148;
    }

    public boolean isSpread() {
        return this.getType() == 174;
    }

    public boolean isString() {
        return this.getType() == 40;
    }

    public boolean isStringKey() {
        return this.getType() == 154;
    }

    public boolean isSuper() {
        return this.getType() == 161;
    }

    public boolean isSwitch() {
        return this.getType() == 110;
    }

    public boolean isTaggedTemplateLit() {
        return this.getType() == 176;
    }

    public boolean isTemplateLit() {
        return this.getType() == 177;
    }

    public boolean isTemplateLitSub() {
        return this.getType() == 178;
    }

    public boolean isThis() {
        return this.getType() == 42;
    }

    public boolean isThrow() {
        return this.getType() == 49;
    }

    public boolean isTrue() {
        return this.getType() == 44;
    }

    public boolean isTry() {
        return this.getType() == 77;
    }

    public boolean isTypeOf() {
        return this.getType() == 32;
    }

    public boolean isVar() {
        return this.getType() == 118;
    }

    public boolean isVoid() {
        return this.getType() == 122;
    }

    public boolean isWhile() {
        return this.getType() == 113;
    }

    public boolean isWith() {
        return this.getType() == 119;
    }

    public boolean isYield() {
        return this.getType() == 164;
    }

    static class NodeMismatch {
        final Node nodeA;
        final Node nodeB;

        NodeMismatch(Node nodeA, Node nodeB) {
            this.nodeA = nodeA;
            this.nodeB = nodeB;
        }

        public boolean equals(Object object) {
            if (object instanceof NodeMismatch) {
                NodeMismatch that = (NodeMismatch)object;
                return that.nodeA.equals(this.nodeA) && that.nodeB.equals(this.nodeB);
            }
            return false;
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.nodeA, this.nodeB});
        }
    }

    public static class SideEffectFlags {
        private int value = 0;

        public SideEffectFlags() {
        }

        public SideEffectFlags(int value) {
            this.value = value;
        }

        public int valueOf() {
            return this.value;
        }

        public SideEffectFlags setAllFlags() {
            this.value = 0;
            return this;
        }

        public SideEffectFlags clearAllFlags() {
            this.value = 31;
            return this;
        }

        public boolean areAllFlagsSet() {
            return this.value == 0;
        }

        public void clearSideEffectFlags() {
            this.value |= 0xF;
        }

        public SideEffectFlags setMutatesGlobalState() {
            this.removeFlag(1);
            this.removeFlag(4);
            this.removeFlag(2);
            return this;
        }

        public SideEffectFlags setThrows() {
            this.removeFlag(8);
            return this;
        }

        public SideEffectFlags setMutatesThis() {
            this.removeFlag(2);
            return this;
        }

        public SideEffectFlags setMutatesArguments() {
            this.removeFlag(4);
            return this;
        }

        public SideEffectFlags setReturnsTainted() {
            this.removeFlag(16);
            return this;
        }

        private void removeFlag(int flag) {
            this.value &= ~flag;
        }
    }

    public static class AncestorIterable
    implements Iterable<Node> {
        private Node cur;

        AncestorIterable(Node cur) {
            this.cur = cur;
        }

        @Override
        public Iterator<Node> iterator() {
            return new Iterator<Node>(){

                @Override
                public boolean hasNext() {
                    return AncestorIterable.this.cur != null;
                }

                @Override
                public Node next() {
                    if (!this.hasNext()) {
                        throw new NoSuchElementException();
                    }
                    Node n = AncestorIterable.this.cur;
                    AncestorIterable.this.cur = AncestorIterable.this.cur.getParent();
                    return n;
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
        }
    }

    private static final class SiblingNodeIterable
    implements Iterable<Node>,
    Iterator<Node> {
        private final Node start;
        private Node current;
        private boolean used;

        SiblingNodeIterable(Node start) {
            this.start = start;
            this.current = start;
            this.used = false;
        }

        @Override
        public Iterator<Node> iterator() {
            if (!this.used) {
                this.used = true;
                return this;
            }
            return new SiblingNodeIterable(this.start).iterator();
        }

        @Override
        public boolean hasNext() {
            return this.current != null;
        }

        @Override
        public Node next() {
            if (this.current == null) {
                throw new NoSuchElementException();
            }
            try {
                Node node = this.current;
                return node;
            }
            finally {
                this.current = this.current.getNext();
            }
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    private static class IntPropListItem
    extends AbstractPropListItem {
        private static final long serialVersionUID = 1L;
        final int intValue;

        IntPropListItem(int propType, int intValue, PropListItem next) {
            super(propType, next);
            this.intValue = intValue;
        }

        @Override
        public int getIntValue() {
            return this.intValue;
        }

        @Override
        public Object getObjectValue() {
            throw new UnsupportedOperationException();
        }

        public String toString() {
            return String.valueOf(this.intValue);
        }

        @Override
        public PropListItem chain(PropListItem next) {
            return new IntPropListItem(this.getType(), this.intValue, next);
        }
    }

    private static class ObjectPropListItem
    extends AbstractPropListItem {
        private static final long serialVersionUID = 1L;
        private final Object objectValue;

        ObjectPropListItem(int propType, Object objectValue, PropListItem next) {
            super(propType, next);
            this.objectValue = objectValue;
        }

        @Override
        public int getIntValue() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Object getObjectValue() {
            return this.objectValue;
        }

        public String toString() {
            return String.valueOf(this.objectValue);
        }

        @Override
        public PropListItem chain(PropListItem next) {
            return new ObjectPropListItem(this.getType(), this.objectValue, next);
        }
    }

    private static abstract class AbstractPropListItem
    implements PropListItem,
    Serializable {
        private static final long serialVersionUID = 1L;
        private final PropListItem next;
        private final int propType;

        AbstractPropListItem(int propType, PropListItem next) {
            this.propType = propType;
            this.next = next;
        }

        @Override
        public int getType() {
            return this.propType;
        }

        @Override
        public PropListItem getNext() {
            return this.next;
        }

        @Override
        public abstract PropListItem chain(PropListItem var1);
    }

    private static interface PropListItem {
        public int getType();

        public PropListItem getNext();

        public PropListItem chain(PropListItem var1);

        public Object getObjectValue();

        public int getIntValue();
    }

    private static class StringNode
    extends Node {
        private static final long serialVersionUID = 1L;
        private String str;

        StringNode(int type, String str) {
            super(type);
            if (null == str) {
                throw new IllegalArgumentException("StringNode: str is null");
            }
            this.str = str;
        }

        StringNode(int type, String str, int lineno, int charno) {
            super(type, lineno, charno);
            if (null == str) {
                throw new IllegalArgumentException("StringNode: str is null");
            }
            this.str = str;
        }

        @Override
        public String getString() {
            return this.str;
        }

        @Override
        public void setString(String str) {
            if (null == str) {
                throw new IllegalArgumentException("StringNode: str is null");
            }
            this.str = str;
        }

        @Override
        boolean isEquivalentTo(Node node, boolean compareType, boolean recur, boolean jsDoc) {
            return super.isEquivalentTo(node, compareType, recur, jsDoc) && this.str.equals(((StringNode)node).str);
        }

        @Override
        public boolean isQuotedString() {
            return this.getBooleanProp(36);
        }

        @Override
        public void setQuotedString() {
            this.putBooleanProp(36, true);
        }

        @Override
        public StringNode cloneNode() {
            return this.copyNodeFields(new StringNode(this.type, this.str));
        }
    }

    private static class NumberNode
    extends Node {
        private static final long serialVersionUID = 1L;
        private double number;

        NumberNode(double number) {
            super(39);
            this.number = number;
        }

        public NumberNode(double number, int lineno, int charno) {
            super(39, lineno, charno);
            this.number = number;
        }

        @Override
        public double getDouble() {
            return this.number;
        }

        @Override
        public void setDouble(double d) {
            this.number = d;
        }

        @Override
        boolean isEquivalentTo(Node node, boolean compareType, boolean recur, boolean jsDoc) {
            double thatValue;
            double thisValue;
            boolean equiv = super.isEquivalentTo(node, compareType, recur, jsDoc);
            if (equiv && (thisValue = this.getDouble()) == (thatValue = ((NumberNode)node).getDouble())) {
                return thisValue != 0.0 || 1.0 / thisValue == 1.0 / thatValue;
            }
            return false;
        }

        @Override
        public NumberNode cloneNode() {
            return this.copyNodeFields(new NumberNode(this.number));
        }
    }

    public static class TypeDeclarationNode
    extends Node {
        private static final long serialVersionUID = 1L;
        private String str;

        public TypeDeclarationNode(int nodeType, String str) {
            super(nodeType);
            this.str = str;
        }

        public TypeDeclarationNode(int nodeType) {
            super(nodeType);
        }

        public TypeDeclarationNode(int nodeType, Node child) {
            super(nodeType, child);
        }

        public TypeDeclarationNode(int nodeType, Node left, Node right) {
            super(nodeType, left, right);
        }

        public TypeDeclarationNode(int nodeType, Node left, Node mid, Node right) {
            super(nodeType, left, mid, right);
        }

        @Override
        public String getString() {
            return this.str;
        }

        @Override
        public TypeDeclarationNode cloneNode() {
            return this.copyNodeFields(new TypeDeclarationNode(this.type, this.str));
        }
    }
}

