/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.rhino.jstype;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Multimap;
import com.google.javascript.rhino.ErrorReporter;
import com.google.javascript.rhino.JSDocInfo;
import com.google.javascript.rhino.Node;
import com.google.javascript.rhino.SimpleErrorReporter;
import com.google.javascript.rhino.TypeI;
import com.google.javascript.rhino.TypeIRegistry;
import com.google.javascript.rhino.jstype.AllType;
import com.google.javascript.rhino.jstype.ArrowType;
import com.google.javascript.rhino.jstype.BooleanType;
import com.google.javascript.rhino.jstype.EnumType;
import com.google.javascript.rhino.jstype.ErrorFunctionType;
import com.google.javascript.rhino.jstype.FunctionBuilder;
import com.google.javascript.rhino.jstype.FunctionParamBuilder;
import com.google.javascript.rhino.jstype.FunctionType;
import com.google.javascript.rhino.jstype.JSType;
import com.google.javascript.rhino.jstype.JSTypeNative;
import com.google.javascript.rhino.jstype.NamedType;
import com.google.javascript.rhino.jstype.NamespaceType;
import com.google.javascript.rhino.jstype.NoObjectType;
import com.google.javascript.rhino.jstype.NoResolvedType;
import com.google.javascript.rhino.jstype.NoType;
import com.google.javascript.rhino.jstype.NullType;
import com.google.javascript.rhino.jstype.NumberType;
import com.google.javascript.rhino.jstype.ObjectType;
import com.google.javascript.rhino.jstype.PrototypeObjectType;
import com.google.javascript.rhino.jstype.RecordType;
import com.google.javascript.rhino.jstype.RecordTypeBuilder;
import com.google.javascript.rhino.jstype.StaticTypedScope;
import com.google.javascript.rhino.jstype.StringType;
import com.google.javascript.rhino.jstype.TemplateType;
import com.google.javascript.rhino.jstype.TemplateTypeMap;
import com.google.javascript.rhino.jstype.TemplatizedType;
import com.google.javascript.rhino.jstype.UnionTypeBuilder;
import com.google.javascript.rhino.jstype.UnknownType;
import com.google.javascript.rhino.jstype.VoidType;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class JSTypeRegistry
implements TypeIRegistry,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final String OBJECT_INDEX_TEMPLATE = "Object#Key";
    private TemplateType objectIndexTemplateKey;
    public static final String OBJECT_ELEMENT_TEMPLATE = "Object#Element";
    private TemplateType objectElementTemplateKey;
    private static final String I_OBJECT_KEY_TEMPLATE = "IObject#KEY1";
    private TemplateType iobjectKeyTemplateKey;
    public static final String I_OBJECT_VALUE_TEMPLATE = "IObject#VALUE1";
    private TemplateType iobjectValueTemplateKey;
    private static final int PROPERTY_CHECKING_UNION_SIZE = 3000;
    private final transient ErrorReporter reporter;
    private final JSType[] nativeTypes;
    private final Map<String, JSType> namesToTypes;
    private final Set<String> nonNullableTypeNames = new HashSet<String>();
    private final Set<String> forwardDeclaredTypes = new HashSet<String>();
    private final Map<String, UnionTypeBuilder> typesIndexedByProperty = new HashMap<String, UnionTypeBuilder>();
    private final Map<String, Map<String, ObjectType>> eachRefTypeIndexedByProperty = new HashMap<String, Map<String, ObjectType>>();
    private final Map<String, JSType> greatestSubtypeByProperty = new HashMap<String, JSType>();
    private final Multimap<String, FunctionType> interfaceToImplementors = LinkedHashMultimap.create();
    private final Multimap<StaticTypedScope<JSType>, NamedType> unresolvedNamedTypes = ArrayListMultimap.create();
    private final Multimap<StaticTypedScope<JSType>, NamedType> resolvedNamedTypes = ArrayListMultimap.create();
    private boolean lastGeneration = true;
    private final Map<String, TemplateType> templateTypes = new HashMap<String, TemplateType>();
    private final TemplateTypeMap emptyTemplateTypeMap;
    private static final String I_OBJECT_INTERFACE_NAME = "IObject";
    private static final String I_OBJECT_KEY_NAME = "KEY1";
    private static final String I_OBJECT_VALUE_NAME = "VALUE1";

    public JSTypeRegistry(ErrorReporter reporter) {
        this.reporter = reporter;
        this.emptyTemplateTypeMap = new TemplateTypeMap(this, (ImmutableList<TemplateType>)ImmutableList.of(), (ImmutableList<JSType>)ImmutableList.of());
        this.nativeTypes = new JSType[JSTypeNative.values().length];
        this.namesToTypes = new HashMap<String, JSType>();
        this.resetForTypeCheck();
    }

    public TemplateType getObjectElementKey() {
        return this.objectElementTemplateKey;
    }

    public TemplateType getObjectIndexKey() {
        Preconditions.checkNotNull((Object)this.objectIndexTemplateKey);
        return this.objectIndexTemplateKey;
    }

    public boolean isIObjectValueKey(String fnName, String templateParamName) {
        return I_OBJECT_INTERFACE_NAME.equals(fnName) && I_OBJECT_VALUE_NAME.equals(templateParamName);
    }

    public TemplateType getIObjectValueKey() {
        return this.iobjectValueTemplateKey;
    }

    public boolean isIObjectKeyKey(String fnName, String templateParamName) {
        return I_OBJECT_INTERFACE_NAME.equals(fnName) && I_OBJECT_KEY_NAME.equals(templateParamName);
    }

    public TemplateType getIObjectKeyKey() {
        Preconditions.checkNotNull((Object)this.iobjectKeyTemplateKey);
        return this.iobjectKeyTemplateKey;
    }

    public boolean isIObject(String fnName, JSDocInfo info) {
        if (!I_OBJECT_INTERFACE_NAME.equals(fnName)) {
            return false;
        }
        ImmutableList<String> infoTemplateTypeNames = info.getTemplateTypeNames();
        if (infoTemplateTypeNames.isEmpty() || infoTemplateTypeNames.size() != 2) {
            return false;
        }
        return this.isIObjectKeyKey(fnName, (String)infoTemplateTypeNames.get(0)) && this.isIObjectValueKey(fnName, (String)infoTemplateTypeNames.get(1));
    }

    public boolean isInstanceOfIObject(JSType type) {
        Preconditions.checkNotNull((Object)type);
        TemplateTypeMap typeMap = type.getTemplateTypeMap();
        if (typeMap == null) {
            return false;
        }
        return typeMap.hasTemplateType(this.getIObjectKeyKey());
    }

    public ImmutableList<TemplateType> getIObjectTemplateTypeNames() {
        ImmutableList.Builder builder = ImmutableList.builder();
        builder.add((Object)this.getIObjectKeyKey());
        builder.add((Object)this.getIObjectValueKey());
        ImmutableList templateTypeNames = builder.build();
        return templateTypeNames;
    }

    public ErrorReporter getErrorReporter() {
        return this.reporter;
    }

    public void resetForTypeCheck() {
        this.typesIndexedByProperty.clear();
        this.eachRefTypeIndexedByProperty.clear();
        this.initializeBuiltInTypes();
        this.namesToTypes.clear();
        this.initializeRegistry();
    }

    private void initializeBuiltInTypes() {
        this.objectIndexTemplateKey = new TemplateType(this, OBJECT_INDEX_TEMPLATE);
        this.objectElementTemplateKey = new TemplateType(this, OBJECT_ELEMENT_TEMPLATE);
        this.iobjectKeyTemplateKey = new TemplateType(this, I_OBJECT_KEY_TEMPLATE);
        this.iobjectValueTemplateKey = new TemplateType(this, I_OBJECT_VALUE_TEMPLATE);
        BooleanType BOOLEAN_TYPE = new BooleanType(this);
        this.registerNativeType(JSTypeNative.BOOLEAN_TYPE, BOOLEAN_TYPE);
        NullType NULL_TYPE = new NullType(this);
        this.registerNativeType(JSTypeNative.NULL_TYPE, NULL_TYPE);
        NumberType NUMBER_TYPE = new NumberType(this);
        this.registerNativeType(JSTypeNative.NUMBER_TYPE, NUMBER_TYPE);
        StringType STRING_TYPE = new StringType(this);
        this.registerNativeType(JSTypeNative.STRING_TYPE, STRING_TYPE);
        UnknownType UNKNOWN_TYPE = new UnknownType(this, false);
        this.registerNativeType(JSTypeNative.UNKNOWN_TYPE, UNKNOWN_TYPE);
        UnknownType checkedUnknownType = new UnknownType(this, true);
        this.registerNativeType(JSTypeNative.CHECKED_UNKNOWN_TYPE, checkedUnknownType);
        VoidType VOID_TYPE = new VoidType(this);
        this.registerNativeType(JSTypeNative.VOID_TYPE, VOID_TYPE);
        AllType ALL_TYPE = new AllType(this);
        this.registerNativeType(JSTypeNative.ALL_TYPE, ALL_TYPE);
        PrototypeObjectType TOP_LEVEL_PROTOTYPE = new PrototypeObjectType(this, null, null, true, null);
        this.registerNativeType(JSTypeNative.TOP_LEVEL_PROTOTYPE, TOP_LEVEL_PROTOTYPE);
        FunctionType OBJECT_FUNCTION_TYPE = new FunctionType(this, "Object", null, this.createArrowType(this.createOptionalParameters(ALL_TYPE), null), null, this.createTemplateTypeMap((ImmutableList<TemplateType>)ImmutableList.of((Object)this.objectIndexTemplateKey, (Object)this.objectElementTemplateKey), null), true, true);
        OBJECT_FUNCTION_TYPE.getInternalArrowType().returnType = OBJECT_FUNCTION_TYPE.getInstanceType();
        OBJECT_FUNCTION_TYPE.setPrototype(TOP_LEVEL_PROTOTYPE, null);
        this.registerNativeType(JSTypeNative.OBJECT_FUNCTION_TYPE, OBJECT_FUNCTION_TYPE);
        ObjectType OBJECT_TYPE = OBJECT_FUNCTION_TYPE.getInstanceType();
        this.registerNativeType(JSTypeNative.OBJECT_TYPE, OBJECT_TYPE);
        ObjectType OBJECT_PROTOTYPE = OBJECT_FUNCTION_TYPE.getPrototype();
        this.registerNativeType(JSTypeNative.OBJECT_PROTOTYPE, OBJECT_PROTOTYPE);
        FunctionType FUNCTION_FUNCTION_TYPE = new FunctionType(this, "Function", null, this.createArrowType(this.createParametersWithVarArgs(ALL_TYPE), UNKNOWN_TYPE), null, null, true, true);
        FUNCTION_FUNCTION_TYPE.setPrototypeBasedOn(OBJECT_TYPE);
        this.registerNativeType(JSTypeNative.FUNCTION_FUNCTION_TYPE, FUNCTION_FUNCTION_TYPE);
        ObjectType FUNCTION_PROTOTYPE = FUNCTION_FUNCTION_TYPE.getPrototype();
        this.registerNativeType(JSTypeNative.FUNCTION_PROTOTYPE, FUNCTION_PROTOTYPE);
        NoType NO_TYPE = new NoType(this);
        this.registerNativeType(JSTypeNative.NO_TYPE, NO_TYPE);
        NoObjectType NO_OBJECT_TYPE = new NoObjectType(this);
        this.registerNativeType(JSTypeNative.NO_OBJECT_TYPE, NO_OBJECT_TYPE);
        NoResolvedType NO_RESOLVED_TYPE = new NoResolvedType(this);
        this.registerNativeType(JSTypeNative.NO_RESOLVED_TYPE, NO_RESOLVED_TYPE);
        FunctionType ARRAY_FUNCTION_TYPE = new FunctionType(this, "Array", null, this.createArrowType(this.createParametersWithVarArgs(ALL_TYPE), null), null, this.createTemplateTypeMap((ImmutableList<TemplateType>)ImmutableList.of((Object)this.objectElementTemplateKey), null), true, true);
        ARRAY_FUNCTION_TYPE.getInternalArrowType().returnType = ARRAY_FUNCTION_TYPE.getInstanceType();
        ARRAY_FUNCTION_TYPE.getPrototype();
        this.registerNativeType(JSTypeNative.ARRAY_FUNCTION_TYPE, ARRAY_FUNCTION_TYPE);
        ObjectType ARRAY_TYPE = ARRAY_FUNCTION_TYPE.getInstanceType();
        this.registerNativeType(JSTypeNative.ARRAY_TYPE, ARRAY_TYPE);
        FunctionType BOOLEAN_OBJECT_FUNCTION_TYPE = new FunctionType(this, "Boolean", null, this.createArrowType(this.createOptionalParameters(ALL_TYPE), BOOLEAN_TYPE), null, null, true, true);
        BOOLEAN_OBJECT_FUNCTION_TYPE.getPrototype();
        this.registerNativeType(JSTypeNative.BOOLEAN_OBJECT_FUNCTION_TYPE, BOOLEAN_OBJECT_FUNCTION_TYPE);
        ObjectType BOOLEAN_OBJECT_TYPE = BOOLEAN_OBJECT_FUNCTION_TYPE.getInstanceType();
        this.registerNativeType(JSTypeNative.BOOLEAN_OBJECT_TYPE, BOOLEAN_OBJECT_TYPE);
        FunctionType DATE_FUNCTION_TYPE = new FunctionType(this, "Date", null, this.createArrowType(this.createOptionalParameters(UNKNOWN_TYPE, UNKNOWN_TYPE, UNKNOWN_TYPE, UNKNOWN_TYPE, UNKNOWN_TYPE, UNKNOWN_TYPE, UNKNOWN_TYPE), STRING_TYPE), null, null, true, true);
        DATE_FUNCTION_TYPE.getPrototype();
        this.registerNativeType(JSTypeNative.DATE_FUNCTION_TYPE, DATE_FUNCTION_TYPE);
        ObjectType DATE_TYPE = DATE_FUNCTION_TYPE.getInstanceType();
        this.registerNativeType(JSTypeNative.DATE_TYPE, DATE_TYPE);
        ErrorFunctionType ERROR_FUNCTION_TYPE = new ErrorFunctionType(this, "Error");
        this.registerNativeType(JSTypeNative.ERROR_FUNCTION_TYPE, ERROR_FUNCTION_TYPE);
        ObjectType ERROR_TYPE = ERROR_FUNCTION_TYPE.getInstanceType();
        this.registerNativeType(JSTypeNative.ERROR_TYPE, ERROR_TYPE);
        ErrorFunctionType EVAL_ERROR_FUNCTION_TYPE = new ErrorFunctionType(this, "EvalError");
        EVAL_ERROR_FUNCTION_TYPE.setPrototypeBasedOn(ERROR_TYPE);
        this.registerNativeType(JSTypeNative.EVAL_ERROR_FUNCTION_TYPE, EVAL_ERROR_FUNCTION_TYPE);
        ObjectType EVAL_ERROR_TYPE = EVAL_ERROR_FUNCTION_TYPE.getInstanceType();
        this.registerNativeType(JSTypeNative.EVAL_ERROR_TYPE, EVAL_ERROR_TYPE);
        ErrorFunctionType RANGE_ERROR_FUNCTION_TYPE = new ErrorFunctionType(this, "RangeError");
        RANGE_ERROR_FUNCTION_TYPE.setPrototypeBasedOn(ERROR_TYPE);
        this.registerNativeType(JSTypeNative.RANGE_ERROR_FUNCTION_TYPE, RANGE_ERROR_FUNCTION_TYPE);
        ObjectType RANGE_ERROR_TYPE = RANGE_ERROR_FUNCTION_TYPE.getInstanceType();
        this.registerNativeType(JSTypeNative.RANGE_ERROR_TYPE, RANGE_ERROR_TYPE);
        ErrorFunctionType REFERENCE_ERROR_FUNCTION_TYPE = new ErrorFunctionType(this, "ReferenceError");
        REFERENCE_ERROR_FUNCTION_TYPE.setPrototypeBasedOn(ERROR_TYPE);
        this.registerNativeType(JSTypeNative.REFERENCE_ERROR_FUNCTION_TYPE, REFERENCE_ERROR_FUNCTION_TYPE);
        ObjectType REFERENCE_ERROR_TYPE = REFERENCE_ERROR_FUNCTION_TYPE.getInstanceType();
        this.registerNativeType(JSTypeNative.REFERENCE_ERROR_TYPE, REFERENCE_ERROR_TYPE);
        ErrorFunctionType SYNTAX_ERROR_FUNCTION_TYPE = new ErrorFunctionType(this, "SyntaxError");
        SYNTAX_ERROR_FUNCTION_TYPE.setPrototypeBasedOn(ERROR_TYPE);
        this.registerNativeType(JSTypeNative.SYNTAX_ERROR_FUNCTION_TYPE, SYNTAX_ERROR_FUNCTION_TYPE);
        ObjectType SYNTAX_ERROR_TYPE = SYNTAX_ERROR_FUNCTION_TYPE.getInstanceType();
        this.registerNativeType(JSTypeNative.SYNTAX_ERROR_TYPE, SYNTAX_ERROR_TYPE);
        ErrorFunctionType TYPE_ERROR_FUNCTION_TYPE = new ErrorFunctionType(this, "TypeError");
        TYPE_ERROR_FUNCTION_TYPE.setPrototypeBasedOn(ERROR_TYPE);
        this.registerNativeType(JSTypeNative.TYPE_ERROR_FUNCTION_TYPE, TYPE_ERROR_FUNCTION_TYPE);
        ObjectType TYPE_ERROR_TYPE = TYPE_ERROR_FUNCTION_TYPE.getInstanceType();
        this.registerNativeType(JSTypeNative.TYPE_ERROR_TYPE, TYPE_ERROR_TYPE);
        ErrorFunctionType URI_ERROR_FUNCTION_TYPE = new ErrorFunctionType(this, "URIError");
        URI_ERROR_FUNCTION_TYPE.setPrototypeBasedOn(ERROR_TYPE);
        this.registerNativeType(JSTypeNative.URI_ERROR_FUNCTION_TYPE, URI_ERROR_FUNCTION_TYPE);
        ObjectType URI_ERROR_TYPE = URI_ERROR_FUNCTION_TYPE.getInstanceType();
        this.registerNativeType(JSTypeNative.URI_ERROR_TYPE, URI_ERROR_TYPE);
        FunctionType NUMBER_OBJECT_FUNCTION_TYPE = new FunctionType(this, "Number", null, this.createArrowType(this.createOptionalParameters(ALL_TYPE), NUMBER_TYPE), null, null, true, true);
        NUMBER_OBJECT_FUNCTION_TYPE.getPrototype();
        this.registerNativeType(JSTypeNative.NUMBER_OBJECT_FUNCTION_TYPE, NUMBER_OBJECT_FUNCTION_TYPE);
        ObjectType NUMBER_OBJECT_TYPE = NUMBER_OBJECT_FUNCTION_TYPE.getInstanceType();
        this.registerNativeType(JSTypeNative.NUMBER_OBJECT_TYPE, NUMBER_OBJECT_TYPE);
        FunctionType REGEXP_FUNCTION_TYPE = new FunctionType(this, "RegExp", null, this.createArrowType(this.createOptionalParameters(ALL_TYPE, ALL_TYPE)), null, null, true, true);
        REGEXP_FUNCTION_TYPE.getInternalArrowType().returnType = REGEXP_FUNCTION_TYPE.getInstanceType();
        REGEXP_FUNCTION_TYPE.getPrototype();
        this.registerNativeType(JSTypeNative.REGEXP_FUNCTION_TYPE, REGEXP_FUNCTION_TYPE);
        ObjectType REGEXP_TYPE = REGEXP_FUNCTION_TYPE.getInstanceType();
        this.registerNativeType(JSTypeNative.REGEXP_TYPE, REGEXP_TYPE);
        FunctionType STRING_OBJECT_FUNCTION_TYPE = new FunctionType(this, "String", null, this.createArrowType(this.createOptionalParameters(ALL_TYPE), STRING_TYPE), null, null, true, true);
        STRING_OBJECT_FUNCTION_TYPE.getPrototype();
        this.registerNativeType(JSTypeNative.STRING_OBJECT_FUNCTION_TYPE, STRING_OBJECT_FUNCTION_TYPE);
        ObjectType STRING_OBJECT_TYPE = STRING_OBJECT_FUNCTION_TYPE.getInstanceType();
        this.registerNativeType(JSTypeNative.STRING_OBJECT_TYPE, STRING_OBJECT_TYPE);
        JSType NULL_VOID = this.createUnionType(NULL_TYPE, VOID_TYPE);
        this.registerNativeType(JSTypeNative.NULL_VOID, NULL_VOID);
        JSType OBJECT_NUMBER_STRING = this.createUnionType(OBJECT_TYPE, NUMBER_TYPE, STRING_TYPE);
        this.registerNativeType(JSTypeNative.OBJECT_NUMBER_STRING, OBJECT_NUMBER_STRING);
        JSType OBJECT_NUMBER_STRING_BOOLEAN = this.createUnionType(OBJECT_TYPE, NUMBER_TYPE, STRING_TYPE, BOOLEAN_TYPE);
        this.registerNativeType(JSTypeNative.OBJECT_NUMBER_STRING_BOOLEAN, OBJECT_NUMBER_STRING_BOOLEAN);
        JSType NUMBER_STRING_BOOLEAN = this.createUnionType(NUMBER_TYPE, STRING_TYPE, BOOLEAN_TYPE);
        this.registerNativeType(JSTypeNative.NUMBER_STRING_BOOLEAN, NUMBER_STRING_BOOLEAN);
        JSType NUMBER_STRING = this.createUnionType(NUMBER_TYPE, STRING_TYPE);
        this.registerNativeType(JSTypeNative.NUMBER_STRING, NUMBER_STRING);
        JSType STRING_VALUE_OR_OBJECT_TYPE = this.createUnionType(STRING_OBJECT_TYPE, STRING_TYPE);
        this.registerNativeType(JSTypeNative.STRING_VALUE_OR_OBJECT_TYPE, STRING_VALUE_OR_OBJECT_TYPE);
        JSType NUMBER_VALUE_OR_OBJECT_TYPE = this.createUnionType(NUMBER_OBJECT_TYPE, NUMBER_TYPE);
        this.registerNativeType(JSTypeNative.NUMBER_VALUE_OR_OBJECT_TYPE, NUMBER_VALUE_OR_OBJECT_TYPE);
        FunctionType U2U_FUNCTION_TYPE = this.createFunctionTypeWithVarArgs(UNKNOWN_TYPE, UNKNOWN_TYPE);
        this.registerNativeType(JSTypeNative.U2U_FUNCTION_TYPE, U2U_FUNCTION_TYPE);
        FunctionType U2U_CONSTRUCTOR_TYPE = new FunctionType(this, "Function", null, this.createArrowType(this.createParametersWithVarArgs(UNKNOWN_TYPE), UNKNOWN_TYPE), UNKNOWN_TYPE, null, true, true){
            private static final long serialVersionUID = 1L;

            @Override
            public FunctionType getConstructor() {
                return this.registry.getNativeFunctionType(JSTypeNative.FUNCTION_FUNCTION_TYPE);
            }
        };
        this.registerNativeType(JSTypeNative.U2U_CONSTRUCTOR_TYPE, U2U_CONSTRUCTOR_TYPE);
        this.registerNativeType(JSTypeNative.FUNCTION_INSTANCE_TYPE, U2U_CONSTRUCTOR_TYPE);
        FUNCTION_FUNCTION_TYPE.setInstanceType(U2U_CONSTRUCTOR_TYPE);
        U2U_CONSTRUCTOR_TYPE.setImplicitPrototype(FUNCTION_PROTOTYPE);
        FunctionType LEAST_FUNCTION_TYPE = this.createNativeFunctionTypeWithVarArgs(NO_TYPE, ALL_TYPE);
        this.registerNativeType(JSTypeNative.LEAST_FUNCTION_TYPE, LEAST_FUNCTION_TYPE);
        FunctionType GLOBAL_THIS_CTOR = new FunctionType(this, "global this", null, this.createArrowType(this.createParameters(false, ALL_TYPE), NUMBER_TYPE), null, null, true, true);
        ObjectType GLOBAL_THIS = GLOBAL_THIS_CTOR.getInstanceType();
        this.registerNativeType(JSTypeNative.GLOBAL_THIS, GLOBAL_THIS);
        FunctionType GREATEST_FUNCTION_TYPE = this.createNativeFunctionTypeWithVarArgs(ALL_TYPE, NO_TYPE);
        this.registerNativeType(JSTypeNative.GREATEST_FUNCTION_TYPE, GREATEST_FUNCTION_TYPE);
        this.registerPropertyOnType("prototype", OBJECT_FUNCTION_TYPE);
    }

    private void initializeRegistry() {
        this.register(this.getNativeType(JSTypeNative.ARRAY_TYPE));
        this.register(this.getNativeType(JSTypeNative.BOOLEAN_OBJECT_TYPE));
        this.register(this.getNativeType(JSTypeNative.BOOLEAN_TYPE));
        this.register(this.getNativeType(JSTypeNative.DATE_TYPE));
        this.register(this.getNativeType(JSTypeNative.NULL_TYPE));
        this.register(this.getNativeType(JSTypeNative.NULL_TYPE), "Null");
        this.register(this.getNativeType(JSTypeNative.NUMBER_OBJECT_TYPE));
        this.register(this.getNativeType(JSTypeNative.NUMBER_TYPE));
        this.register(this.getNativeType(JSTypeNative.OBJECT_TYPE));
        this.register(this.getNativeType(JSTypeNative.ERROR_TYPE));
        this.register(this.getNativeType(JSTypeNative.URI_ERROR_TYPE));
        this.register(this.getNativeType(JSTypeNative.EVAL_ERROR_TYPE));
        this.register(this.getNativeType(JSTypeNative.TYPE_ERROR_TYPE));
        this.register(this.getNativeType(JSTypeNative.RANGE_ERROR_TYPE));
        this.register(this.getNativeType(JSTypeNative.REFERENCE_ERROR_TYPE));
        this.register(this.getNativeType(JSTypeNative.SYNTAX_ERROR_TYPE));
        this.register(this.getNativeType(JSTypeNative.REGEXP_TYPE));
        this.register(this.getNativeType(JSTypeNative.STRING_OBJECT_TYPE));
        this.register(this.getNativeType(JSTypeNative.STRING_TYPE));
        this.register(this.getNativeType(JSTypeNative.VOID_TYPE));
        this.register(this.getNativeType(JSTypeNative.VOID_TYPE), "Undefined");
        this.register(this.getNativeType(JSTypeNative.VOID_TYPE), "void");
        this.register(this.getNativeType(JSTypeNative.FUNCTION_INSTANCE_TYPE), "Function");
    }

    private void register(JSType type) {
        this.register(type, type.toString());
    }

    private void register(JSType type, String name) {
        Preconditions.checkArgument((!name.contains("<") ? 1 : 0) != 0, (Object)"Type names cannot contain template annotations.");
        this.namesToTypes.put(name, type);
    }

    private void registerNativeType(JSTypeNative typeId, JSType type) {
        this.nativeTypes[typeId.ordinal()] = type;
    }

    public void registerPropertyOnType(String propertyName, JSType type) {
        UnionTypeBuilder typeSet = this.typesIndexedByProperty.get(propertyName);
        if (typeSet == null) {
            typeSet = new UnionTypeBuilder(this, 3000);
            this.typesIndexedByProperty.put(propertyName, typeSet);
        }
        typeSet.addAlternate(type);
        this.addReferenceTypeIndexedByProperty(propertyName, type);
        this.greatestSubtypeByProperty.remove(propertyName);
    }

    private void addReferenceTypeIndexedByProperty(String propertyName, JSType type) {
        if (type instanceof ObjectType && ((ObjectType)type).hasReferenceName()) {
            Map<String, ObjectType> typeSet = this.eachRefTypeIndexedByProperty.get(propertyName);
            if (typeSet == null) {
                typeSet = new HashMap<String, ObjectType>();
                this.eachRefTypeIndexedByProperty.put(propertyName, typeSet);
            }
            ObjectType objType = (ObjectType)type;
            typeSet.put(objType.getReferenceName(), objType);
        } else if (type instanceof NamedType) {
            this.addReferenceTypeIndexedByProperty(propertyName, ((NamedType)type).getReferencedType());
        } else if (type.isUnionType()) {
            for (JSType alternate : type.toMaybeUnionType().getAlternates()) {
                this.addReferenceTypeIndexedByProperty(propertyName, alternate);
            }
        }
    }

    public void unregisterPropertyOnType(String propertyName, JSType type) {
        Map<String, ObjectType> typeSet = this.eachRefTypeIndexedByProperty.get(propertyName);
        if (typeSet != null) {
            typeSet.remove(type.toObjectType().getReferenceName());
        }
    }

    public JSType getGreatestSubtypeWithProperty(JSType type, String propertyName) {
        if (this.greatestSubtypeByProperty.containsKey(propertyName)) {
            return this.greatestSubtypeByProperty.get(propertyName).getGreatestSubtype(type);
        }
        if (this.typesIndexedByProperty.containsKey(propertyName)) {
            JSType built = this.typesIndexedByProperty.get(propertyName).build();
            this.greatestSubtypeByProperty.put(propertyName, built);
            return built.getGreatestSubtype(type);
        }
        return this.getNativeType(JSTypeNative.NO_TYPE);
    }

    public boolean canPropertyBeDefined(JSType type, String propertyName) {
        if (type.isStruct()) {
            return type.hasProperty(propertyName);
        }
        if (!type.isEmptyType() && !type.isUnknownType() && type.hasProperty(propertyName)) {
            return true;
        }
        if (this.typesIndexedByProperty.containsKey(propertyName)) {
            for (JSType alt : this.typesIndexedByProperty.get(propertyName).getAlternates()) {
                RecordType maybeRecordType;
                JSType greatestSubtype = alt.getGreatestSubtype(type);
                if (greatestSubtype.isEmptyType() || (maybeRecordType = greatestSubtype.toMaybeRecordType()) != null && maybeRecordType.isSynthetic()) continue;
                return true;
            }
        }
        return false;
    }

    public Iterable<ObjectType> getEachReferenceTypeWithProperty(String propertyName) {
        if (this.eachRefTypeIndexedByProperty.containsKey(propertyName)) {
            return this.eachRefTypeIndexedByProperty.get(propertyName).values();
        }
        return ImmutableList.of();
    }

    ObjectType findCommonSuperObject(ObjectType a, ObjectType b) {
        List<ObjectType> stackA = JSTypeRegistry.getSuperStack(a);
        List<ObjectType> stackB = JSTypeRegistry.getSuperStack(b);
        ObjectType result = this.getNativeObjectType(JSTypeNative.OBJECT_TYPE);
        while (!stackA.isEmpty() && !stackB.isEmpty()) {
            ObjectType currentB;
            ObjectType currentA = stackA.remove(stackA.size() - 1);
            if (currentA.isEquivalentTo(currentB = stackB.remove(stackB.size() - 1))) {
                result = currentA;
                continue;
            }
            return result;
        }
        return result;
    }

    private static List<ObjectType> getSuperStack(ObjectType a) {
        ArrayList<ObjectType> stack = new ArrayList<ObjectType>(5);
        for (ObjectType current = a; current != null; current = current.getImplicitPrototype()) {
            stack.add(current);
        }
        return stack;
    }

    boolean isLastGeneration() {
        return this.lastGeneration;
    }

    public void setLastGeneration(boolean lastGeneration) {
        this.lastGeneration = lastGeneration;
    }

    void registerTypeImplementingInterface(FunctionType type, ObjectType interfaceInstance) {
        this.interfaceToImplementors.put((Object)interfaceInstance.getReferenceName(), (Object)type);
    }

    public Collection<FunctionType> getDirectImplementors(ObjectType interfaceInstance) {
        return this.interfaceToImplementors.get((Object)interfaceInstance.getReferenceName());
    }

    public boolean declareType(String name, JSType t) {
        if (this.namesToTypes.containsKey(name)) {
            return false;
        }
        this.register(t, name);
        return true;
    }

    public void overwriteDeclaredType(String name, JSType t) {
        Preconditions.checkState((boolean)this.namesToTypes.containsKey(name));
        this.register(t, name);
    }

    public void forwardDeclareType(String name) {
        this.forwardDeclaredTypes.add(name);
    }

    public boolean isForwardDeclaredType(String name) {
        return this.forwardDeclaredTypes.contains(name);
    }

    @Override
    public String getReadableTypeName(Node n) {
        return this.getReadableJSTypeName(n, true);
    }

    public String getReadableTypeNameNoDeref(Node n) {
        return this.getReadableJSTypeName(n, false);
    }

    private String getReadableJSTypeName(Node n, boolean dereference) {
        ObjectType objectType;
        ObjectType dereferenced;
        JSType type = this.getJSTypeOrUnknown(n);
        if (dereference && (dereferenced = type.dereference()) != null) {
            type = dereferenced;
        }
        if (type.isFunctionPrototypeType() || type.toObjectType() != null && type.toObjectType().getConstructor() != null) {
            return type.toString();
        }
        if (n.isGetProp() && (objectType = this.getJSTypeOrUnknown(n.getFirstChild()).dereference()) != null) {
            String propName = n.getLastChild().getString();
            if (objectType.getConstructor() != null && objectType.getConstructor().isInterface()) {
                objectType = FunctionType.getTopDefiningInterface(objectType, propName);
            } else {
                while (objectType != null && !objectType.hasOwnProperty(propName)) {
                    objectType = objectType.getImplicitPrototype();
                }
            }
            if (objectType != null && (objectType.getConstructor() != null || objectType.isFunctionPrototypeType())) {
                return objectType + "." + propName;
            }
        }
        if (n.isQualifiedName()) {
            return n.getQualifiedName();
        }
        if (type.isFunctionType()) {
            return "function";
        }
        return type.toString();
    }

    private JSType getJSTypeOrUnknown(Node n) {
        JSType jsType = n.getJSType();
        if (jsType == null) {
            return this.getNativeType(JSTypeNative.UNKNOWN_TYPE);
        }
        return jsType;
    }

    public JSType getType(String jsTypeName) {
        TemplateType templateType = this.templateTypes.get(jsTypeName);
        if (templateType != null) {
            return templateType;
        }
        return this.namesToTypes.get(jsTypeName);
    }

    public JSType getNativeType(JSTypeNative typeId) {
        return this.nativeTypes[typeId.ordinal()];
    }

    public ObjectType getNativeObjectType(JSTypeNative typeId) {
        return (ObjectType)this.getNativeType(typeId);
    }

    public FunctionType getNativeFunctionType(JSTypeNative typeId) {
        return (FunctionType)this.getNativeType(typeId);
    }

    public JSType getType(StaticTypedScope<JSType> scope, String jsTypeName, String sourceName, int lineno, int charno) {
        switch (jsTypeName) {
            case "boolean": {
                return this.getNativeType(JSTypeNative.BOOLEAN_TYPE);
            }
            case "number": {
                return this.getNativeType(JSTypeNative.NUMBER_TYPE);
            }
            case "string": {
                return this.getNativeType(JSTypeNative.STRING_TYPE);
            }
            case "undefined": 
            case "void": {
                return this.getNativeType(JSTypeNative.VOID_TYPE);
            }
        }
        JSType type = null;
        JSType thisType = null;
        if (scope != null && scope.getTypeOfThis() != null) {
            thisType = scope.getTypeOfThis().toObjectType();
        }
        if (thisType != null && (type = thisType.getTemplateTypeMap().getTemplateTypeKeyByName(jsTypeName)) != null) {
            Preconditions.checkState((boolean)type.isTemplateType(), (String)"expected:%s", (Object[])new Object[]{type});
            return type;
        }
        type = this.getType(jsTypeName);
        if (type == null) {
            NamedType namedType = this.createNamedType(jsTypeName, sourceName, lineno, charno);
            this.unresolvedNamedTypes.put(scope, (Object)namedType);
            type = namedType;
        }
        return type;
    }

    public void clearNamedTypes() {
        this.resolvedNamedTypes.clear();
        this.unresolvedNamedTypes.clear();
    }

    public void resolveTypesInScope(StaticTypedScope<JSType> scope) {
        for (NamedType type : this.unresolvedNamedTypes.get(scope)) {
            type.resolve(this.reporter, scope);
        }
        this.resolvedNamedTypes.putAll(scope, (Iterable)this.unresolvedNamedTypes.removeAll(scope));
        if (scope != null && scope.getParentScope() == null) {
            PrototypeObjectType globalThis = (PrototypeObjectType)this.getNativeType(JSTypeNative.GLOBAL_THIS);
            JSType windowType = this.getType("Window");
            if (globalThis.isUnknownType()) {
                ObjectType windowObjType = ObjectType.cast(windowType);
                if (windowObjType != null) {
                    globalThis.setImplicitPrototype(windowObjType);
                } else {
                    globalThis.setImplicitPrototype(this.getNativeObjectType(JSTypeNative.OBJECT_TYPE));
                }
            }
        }
    }

    public JSType createOptionalType(JSType type) {
        if (type instanceof UnknownType || type.isAllType()) {
            return type;
        }
        return this.createUnionType(type, this.getNativeType(JSTypeNative.VOID_TYPE));
    }

    public JSType createDefaultObjectUnion(JSType type) {
        if (type.isTemplateType()) {
            return type;
        }
        return this.createNullableType(type);
    }

    public JSType createNullableType(JSType type) {
        return this.createUnionType(type, this.getNativeType(JSTypeNative.NULL_TYPE));
    }

    public JSType createOptionalNullableType(JSType type) {
        return this.createUnionType(type, this.getNativeType(JSTypeNative.VOID_TYPE), this.getNativeType(JSTypeNative.NULL_TYPE));
    }

    public JSType createUnionType(JSType ... variants) {
        UnionTypeBuilder builder = new UnionTypeBuilder(this);
        for (JSType type : variants) {
            builder.addAlternate(type);
        }
        return builder.build();
    }

    public JSType createUnionType(JSTypeNative ... variants) {
        UnionTypeBuilder builder = new UnionTypeBuilder(this);
        for (JSTypeNative typeId : variants) {
            builder.addAlternate(this.getNativeType(typeId));
        }
        return builder.build();
    }

    public EnumType createEnumType(String name, Node source, JSType elementsType) {
        return new EnumType(this, name, source, elementsType);
    }

    ArrowType createArrowType(Node parametersNode, JSType returnType) {
        return new ArrowType(this, parametersNode, returnType);
    }

    ArrowType createArrowType(Node parametersNode) {
        return new ArrowType(this, parametersNode, null);
    }

    public FunctionType createFunctionType(JSType returnType, JSType ... parameterTypes) {
        return this.createFunctionType(returnType, this.createParameters(parameterTypes));
    }

    public FunctionType createFunctionTypeWithVarArgs(JSType returnType, JSType ... parameterTypes) {
        return this.createFunctionType(returnType, this.createParametersWithVarArgs(parameterTypes));
    }

    private FunctionType createNativeFunctionTypeWithVarArgs(JSType returnType, JSType ... parameterTypes) {
        return this.createNativeFunctionType(returnType, this.createParametersWithVarArgs(parameterTypes));
    }

    private FunctionType createConstructorTypeWithVarArgs(JSType returnType, JSType ... parameterTypes) {
        return this.createConstructorType(null, null, this.createParametersWithVarArgs(parameterTypes), returnType, null);
    }

    public JSType createFunctionTypeWithInstanceType(ObjectType instanceType, JSType returnType, List<JSType> parameterTypes) {
        Node paramsNode = this.createParameters(parameterTypes.toArray(new JSType[parameterTypes.size()]));
        return new FunctionBuilder(this).withParamsNode(paramsNode).withReturnType(returnType).withTypeOfThis(instanceType).build();
    }

    public Node createParametersWithVarArgs(List<JSType> parameterTypes) {
        return this.createParametersWithVarArgs(parameterTypes.toArray(new JSType[parameterTypes.size()]));
    }

    public Node createParameters(JSType ... parameterTypes) {
        return this.createParameters(false, parameterTypes);
    }

    public Node createParametersWithVarArgs(JSType ... parameterTypes) {
        return this.createParameters(true, parameterTypes);
    }

    public Node createOptionalParameters(JSType ... parameterTypes) {
        FunctionParamBuilder builder = new FunctionParamBuilder(this);
        builder.addOptionalParams(parameterTypes);
        return builder.build();
    }

    private Node createParameters(boolean lastVarArgs, JSType ... parameterTypes) {
        FunctionParamBuilder builder = new FunctionParamBuilder(this);
        int max = parameterTypes.length - 1;
        for (int i = 0; i <= max; ++i) {
            if (lastVarArgs && i == max) {
                builder.addVarArgs(parameterTypes[i]);
                continue;
            }
            builder.addRequiredParams(parameterTypes[i]);
        }
        return builder.build();
    }

    public FunctionType createFunctionTypeWithNewReturnType(FunctionType existingFunctionType, JSType returnType) {
        return new FunctionBuilder(this).copyFromOtherFunction(existingFunctionType).withReturnType(returnType).build();
    }

    public FunctionType createFunctionType(JSType returnType, Node parameters) {
        return new FunctionBuilder(this).withParamsNode(parameters).withReturnType(returnType).build();
    }

    private FunctionType createNativeFunctionType(JSType returnType, Node parameters) {
        return new FunctionBuilder(this).withParamsNode(parameters).withReturnType(returnType).forNativeType().build();
    }

    public RecordType createRecordType(Map<String, RecordTypeBuilder.RecordProperty> properties) {
        return new RecordType(this, properties);
    }

    public ObjectType createObjectType(String name, ObjectType implicitPrototype) {
        return new PrototypeObjectType(this, name, implicitPrototype);
    }

    public ObjectType createAnonymousObjectType(JSDocInfo info) {
        PrototypeObjectType type = new PrototypeObjectType(this, null, null, true);
        type.setPrettyPrint(true);
        type.setJSDocInfo(info);
        return type;
    }

    public boolean resetImplicitPrototype(JSType type, ObjectType newImplicitProto) {
        if (type instanceof PrototypeObjectType) {
            PrototypeObjectType poType = (PrototypeObjectType)type;
            poType.clearCachedValues();
            poType.setImplicitPrototype(newImplicitProto);
            return true;
        }
        return false;
    }

    public FunctionType createConstructorType(String name, Node source, Node parameters, JSType returnType, ImmutableList<TemplateType> templateKeys) {
        Preconditions.checkArgument((source == null || source.isFunction() ? 1 : 0) != 0);
        return new FunctionType(this, name, source, this.createArrowType(parameters, returnType), null, this.createTemplateTypeMap(templateKeys, null), true, false);
    }

    public FunctionType createInterfaceType(String name, Node source, ImmutableList<TemplateType> templateKeys) {
        return FunctionType.forInterface(this, name, source, this.createTemplateTypeMap(templateKeys, null));
    }

    public TemplateType createTemplateType(String name) {
        return new TemplateType(this, name);
    }

    public TemplateType createTemplateTypeWithTransformation(String name, Node expr) {
        return new TemplateType(this, name, expr);
    }

    public TemplateTypeMap createTemplateTypeMap(ImmutableList<TemplateType> templateKeys, ImmutableList<JSType> templateValues) {
        templateKeys = templateKeys == null ? ImmutableList.of() : templateKeys;
        templateValues = templateValues == null ? ImmutableList.of() : templateValues;
        return templateKeys.isEmpty() && templateValues.isEmpty() ? this.emptyTemplateTypeMap : new TemplateTypeMap(this, templateKeys, templateValues);
    }

    public TemplatizedType createTemplatizedType(ObjectType baseType, ImmutableList<JSType> templatizedTypes) {
        return new TemplatizedType(this, baseType, templatizedTypes);
    }

    public TemplatizedType createTemplatizedType(ObjectType baseType, Map<TemplateType, JSType> templatizedTypes) {
        ImmutableList.Builder builder = ImmutableList.builder();
        TemplateTypeMap baseTemplateTypeMap = baseType.getTemplateTypeMap();
        for (TemplateType key : baseTemplateTypeMap.getUnfilledTemplateKeys()) {
            JSType templatizedType = templatizedTypes.containsKey(key) ? templatizedTypes.get(key) : this.getNativeType(JSTypeNative.UNKNOWN_TYPE);
            builder.add((Object)templatizedType);
        }
        return this.createTemplatizedType(baseType, (ImmutableList<JSType>)builder.build());
    }

    public TemplatizedType createTemplatizedType(ObjectType baseType, JSType ... templatizedTypes) {
        return this.createTemplatizedType(baseType, (ImmutableList<JSType>)ImmutableList.copyOf((Object[])templatizedTypes));
    }

    @VisibleForTesting
    public NamedType createNamedType(String reference, String sourceName, int lineno, int charno) {
        if (reference.endsWith(".")) {
            return new NamespaceType(this, reference, sourceName, lineno, charno);
        }
        return new NamedType(this, reference, sourceName, lineno, charno);
    }

    public void identifyNonNullableName(String name) {
        Preconditions.checkNotNull((Object)name);
        this.nonNullableTypeNames.add(name);
    }

    @Override
    public JSType createTypeFromCommentNode(Node n, String sourceName, StaticTypedScope<? extends TypeI> scope) {
        return this.createFromTypeNodesInternal(n, sourceName, scope);
    }

    private JSType createFromTypeNodesInternal(Node n, String sourceName, StaticTypedScope<JSType> scope) {
        switch (n.getType()) {
            case 309: {
                return this.createRecordTypeFromNodes(n.getFirstChild(), sourceName, scope);
            }
            case 306: {
                return this.createFromTypeNodesInternal(n.getFirstChild(), sourceName, scope).restrictByNotNullOrUndefined();
            }
            case 304: {
                Node firstChild = n.getFirstChild();
                if (firstChild == null) {
                    return this.getNativeType(JSTypeNative.UNKNOWN_TYPE);
                }
                return this.createNullableType(this.createFromTypeNodesInternal(firstChild, sourceName, scope));
            }
            case 307: {
                return this.createOptionalType(this.createFromTypeNodesInternal(n.getFirstChild(), sourceName, scope));
            }
            case 305: {
                return this.createOptionalType(this.createFromTypeNodesInternal(n.getFirstChild(), sourceName, scope));
            }
            case 302: {
                return this.getNativeType(JSTypeNative.ALL_TYPE);
            }
            case 301: {
                UnionTypeBuilder builder = new UnionTypeBuilder(this);
                for (Node child = n.getFirstChild(); child != null; child = child.getNext()) {
                    builder.addAlternate(this.createFromTypeNodesInternal(child, sourceName, scope));
                }
                return builder.build();
            }
            case 124: {
                return this.getNativeType(JSTypeNative.UNKNOWN_TYPE);
            }
            case 122: {
                return this.getNativeType(JSTypeNative.VOID_TYPE);
            }
            case 38: 
            case 40: {
                JSType namedType = this.getType(scope, n.getString(), sourceName, n.getLineno(), n.getCharno());
                if (namedType instanceof ObjectType && !(namedType instanceof NamespaceType) && !this.nonNullableTypeNames.contains(n.getString())) {
                    Node typeList = n.getFirstChild();
                    int nAllowedTypes = namedType.getTemplateTypeMap().numUnfilledTemplateKeys();
                    if (typeList != null && nAllowedTypes > 0) {
                        ImmutableList.Builder templateTypes = ImmutableList.builder();
                        if (n.getString().equals("Object") && typeList.getFirstChild() == typeList.getLastChild()) {
                            templateTypes.add((Object)this.getNativeType(JSTypeNative.UNKNOWN_TYPE));
                        }
                        int templateNodeIndex = 0;
                        for (Node templateNode : typeList.getFirstChild().siblings()) {
                            if (++templateNodeIndex > nAllowedTypes) break;
                            templateTypes.add((Object)this.createFromTypeNodesInternal(templateNode, sourceName, scope));
                        }
                        namedType = this.createTemplatizedType((ObjectType)namedType, (ImmutableList<JSType>)templateTypes.build());
                        Preconditions.checkNotNull((Object)namedType);
                    }
                    return this.createDefaultObjectUnion(namedType);
                }
                return namedType;
            }
            case 105: {
                JSType thisType = null;
                boolean isConstructor = false;
                Node current = n.getFirstChild();
                if (current.getType() == 42 || current.getType() == 30) {
                    Node contextNode = current.getFirstChild();
                    JSType candidateThisType = this.createFromTypeNodesInternal(contextNode, sourceName, scope);
                    if (candidateThisType.isNullType() || candidateThisType.isVoidType()) {
                        thisType = candidateThisType;
                    } else {
                        thisType = ObjectType.cast(candidateThisType.restrictByNotNullOrUndefined());
                        if (thisType == null) {
                            this.reporter.warning(SimpleErrorReporter.getMessage0(current.getType() == 42 ? "msg.jsdoc.function.thisnotobject" : "msg.jsdoc.function.newnotobject"), sourceName, contextNode.getLineno(), contextNode.getCharno());
                        }
                    }
                    isConstructor = current.getType() == 30;
                    current = current.getNext();
                }
                FunctionParamBuilder paramBuilder = new FunctionParamBuilder(this);
                if (current.getType() == 83) {
                    for (Node arg = current.getFirstChild(); arg != null; arg = arg.getNext()) {
                        if (arg.getType() == 305) {
                            if (arg.getChildCount() == 0) {
                                paramBuilder.addVarArgs(this.getNativeType(JSTypeNative.UNKNOWN_TYPE));
                                continue;
                            }
                            paramBuilder.addVarArgs(this.createFromTypeNodesInternal(arg.getFirstChild(), sourceName, scope));
                            continue;
                        }
                        JSType type = this.createFromTypeNodesInternal(arg, sourceName, scope);
                        if (arg.getType() == 307) {
                            boolean addSuccess = paramBuilder.addOptionalParams(type);
                            if (addSuccess) continue;
                            this.reporter.warning(SimpleErrorReporter.getMessage0("msg.jsdoc.function.varargs"), sourceName, arg.getLineno(), arg.getCharno());
                            continue;
                        }
                        paramBuilder.addRequiredParams(type);
                    }
                    current = current.getNext();
                }
                JSType returnType = this.createFromTypeNodesInternal(current, sourceName, scope);
                return new FunctionBuilder(this).withParamsNode(paramBuilder.build()).withReturnType(returnType).withTypeOfThis(thisType).setIsConstructor(isConstructor).build();
            }
        }
        throw new IllegalStateException("Unexpected node in type expression: " + n);
    }

    private JSType createRecordTypeFromNodes(Node n, String sourceName, StaticTypedScope<JSType> scope) {
        RecordTypeBuilder builder = new RecordTypeBuilder(this);
        for (Node fieldTypeNode = n.getFirstChild(); fieldTypeNode != null; fieldTypeNode = fieldTypeNode.getNext()) {
            String fieldName;
            Node fieldNameNode = fieldTypeNode;
            boolean hasType = false;
            if (fieldTypeNode.getType() == 310) {
                fieldNameNode = fieldTypeNode.getFirstChild();
                hasType = true;
            }
            if ((fieldName = fieldNameNode.getString()).startsWith("'") || fieldName.startsWith("\"")) {
                fieldName = fieldName.substring(1, fieldName.length() - 1);
            }
            JSType fieldType = null;
            fieldType = hasType ? this.createFromTypeNodesInternal(fieldTypeNode.getLastChild(), sourceName, scope) : this.getNativeType(JSTypeNative.UNKNOWN_TYPE);
            builder.addProperty(fieldName, fieldType, fieldNameNode);
        }
        return builder.build();
    }

    public void setTemplateTypeNames(List<TemplateType> keys) {
        Preconditions.checkNotNull(keys);
        for (TemplateType key : keys) {
            this.templateTypes.put(key.getReferenceName(), key);
        }
    }

    public void clearTemplateTypeNames() {
        this.templateTypes.clear();
    }

    private boolean isNonNullable(JSType type) {
        for (String s : this.nonNullableTypeNames) {
            JSType that = this.getType(s);
            if (that == null || !type.isEquivalentTo(that)) continue;
            return true;
        }
        return false;
    }

    public boolean isTemplatizable(JSType type) {
        return type instanceof ObjectType && !(type instanceof NamespaceType) && !this.isNonNullable(type);
    }
}

