/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.rhino.jstype;

import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.javascript.rhino.jstype.EquivalenceMethod;
import com.google.javascript.rhino.jstype.JSType;
import com.google.javascript.rhino.jstype.JSTypeNative;
import com.google.javascript.rhino.jstype.JSTypeRegistry;
import com.google.javascript.rhino.jstype.ObjectType;
import com.google.javascript.rhino.jstype.ProxyObjectType;
import com.google.javascript.rhino.jstype.RelationshipVisitor;
import com.google.javascript.rhino.jstype.TemplateType;
import com.google.javascript.rhino.jstype.TemplateTypeMap;
import com.google.javascript.rhino.jstype.TemplateTypeMapReplacer;
import com.google.javascript.rhino.jstype.Visitor;

public final class TemplatizedType
extends ProxyObjectType {
    private static final long serialVersionUID = 1L;
    final ImmutableList<JSType> templateTypes;
    final TemplateTypeMapReplacer replacer;

    TemplatizedType(JSTypeRegistry registry, ObjectType objectType, ImmutableList<JSType> templateTypes) {
        super(registry, objectType, objectType.getTemplateTypeMap().addValues(templateTypes));
        ImmutableList<TemplateType> filledTemplateKeys = objectType.getTemplateTypeMap().getUnfilledTemplateKeys();
        ImmutableList.Builder builder = ImmutableList.builder();
        for (TemplateType filledTemplateKey : filledTemplateKeys) {
            builder.add((Object)this.getTemplateTypeMap().getTemplateType(filledTemplateKey));
        }
        this.templateTypes = builder.build();
        this.replacer = new TemplateTypeMapReplacer(registry, this.getTemplateTypeMap());
    }

    @Override
    String toStringHelper(final boolean forAnnotations) {
        String typeString = super.toStringHelper(forAnnotations);
        if (!this.templateTypes.isEmpty()) {
            typeString = typeString + "<" + Joiner.on((String)",").join((Iterable)Lists.transform(this.templateTypes, (Function)new Function<JSType, String>(){

                public String apply(JSType type) {
                    return type.toStringHelper(forAnnotations);
                }
            })) + ">";
        }
        return typeString;
    }

    @Override
    public <T> T visit(Visitor<T> visitor) {
        return visitor.caseTemplatizedType(this);
    }

    @Override
    <T> T visit(RelationshipVisitor<T> visitor, JSType that) {
        return visitor.caseTemplatizedType(this, that);
    }

    @Override
    public TemplatizedType toMaybeTemplatizedType() {
        return this;
    }

    @Override
    public ImmutableList<JSType> getTemplateTypes() {
        return this.templateTypes;
    }

    @Override
    public JSType getPropertyType(String propertyName) {
        JSType result = super.getPropertyType(propertyName);
        return result == null ? null : result.visit(this.replacer);
    }

    @Override
    public boolean isSubtype(JSType that) {
        return this.isSubtype(that, new JSType.ImplCache());
    }

    @Override
    protected boolean isSubtype(JSType that, JSType.ImplCache implicitImplCache) {
        return TemplatizedType.isSubtypeHelper(this, that, implicitImplCache);
    }

    boolean wrapsSameRawType(JSType that) {
        return that.isTemplatizedType() && this.getReferencedTypeInternal().isEquivalentTo(that.toMaybeTemplatizedType().getReferencedTypeInternal());
    }

    boolean wrapsRawType(JSType that) {
        return this.getReferencedTypeInternal().isEquivalentTo(that);
    }

    JSType getGreatestSubtypeHelper(JSType rawThat) {
        Preconditions.checkNotNull((Object)rawThat);
        if (!this.wrapsSameRawType(rawThat)) {
            if (!rawThat.isTemplatizedType()) {
                if (this.isSubtype(rawThat)) {
                    return this;
                }
                if (rawThat.isSubtype(this)) {
                    return TemplatizedType.filterNoResolvedType(rawThat);
                }
            }
            if (this.isObject() && rawThat.isObject()) {
                return this.getNativeType(JSTypeNative.NO_OBJECT_TYPE);
            }
            return this.getNativeType(JSTypeNative.NO_TYPE);
        }
        TemplatizedType that = rawThat.toMaybeTemplatizedType();
        Preconditions.checkNotNull((Object)that);
        if (this.getTemplateTypeMap().checkEquivalenceHelper(that.getTemplateTypeMap(), EquivalenceMethod.INVARIANT)) {
            return this;
        }
        return this.getReferencedObjTypeInternal();
    }

    @Override
    public TemplateTypeMap getTemplateTypeMap() {
        return this.templateTypeMap;
    }

    @Override
    public boolean hasAnyTemplateTypesInternal() {
        return this.templateTypeMap.hasAnyTemplateTypesInternal();
    }

    public ObjectType getReferencedType() {
        return this.getReferencedObjTypeInternal();
    }
}

