/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.CompilerPass;
import com.google.javascript.jscomp.DiagnosticType;
import com.google.javascript.jscomp.JSError;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.rhino.JSDocInfo;
import com.google.javascript.rhino.Node;

final class CheckJSDoc
extends NodeTraversal.AbstractPostOrderCallback
implements CompilerPass {
    public static final DiagnosticType MISPLACED_MSG_ANNOTATION = DiagnosticType.disabled("JSC_MISPLACED_MSG_ANNOTATION", "Misplaced message annotation. @desc, @hidden, and @meaning annotations should onlybe on message nodes.");
    public static final DiagnosticType MISPLACED_ANNOTATION = DiagnosticType.warning("JSC_MISPLACED_ANNOTATION", "Misplaced {0} annotation. {1}");
    public static final DiagnosticType ANNOTATION_DEPRECATED = DiagnosticType.warning("JSC_ANNOTATION_DEPRECATED", "The {0} annotation is deprecated. {1}");
    public static final DiagnosticType DISALLOWED_MEMBER_JSDOC = DiagnosticType.warning("JSC_DISALLOWED_MEMBER_JSDOC", "Class level JSDocs (@interface, @extends, etc.) are not allowed on class members");
    static final DiagnosticType ARROW_FUNCTION_AS_CONSTRUCTOR = DiagnosticType.error("JSC_ARROW_FUNCTION_AS_CONSTRUCTOR", "Arrow functions cannot be used as constructors");
    private final AbstractCompiler compiler;

    CheckJSDoc(AbstractCompiler compiler) {
        this.compiler = compiler;
    }

    @Override
    public void process(Node externs, Node root) {
        NodeTraversal.traverseEs6(this.compiler, externs, this);
        NodeTraversal.traverseEs6(this.compiler, root, this);
    }

    @Override
    public void visit(NodeTraversal t, Node n, Node parent) {
        JSDocInfo info = n.getJSDocInfo();
        this.validateTypeAnnotations(t, n, info);
        this.validateFunctionJsDoc(t, n, info);
        this.validateMsgJsDoc(t, n, info);
        this.validateDeprecatedJsDoc(t, n, info);
        this.validateNoCollapse(t, n, info);
        this.validateClassLevelJsDoc(t, n, info);
        this.validateArrowFunction(n);
    }

    private void validateClassLevelJsDoc(NodeTraversal t, Node n, JSDocInfo info) {
        if (info != null && n.isMemberFunctionDef() && (info.isConstructorOrInterface() || info.hasBaseType() || info.getImplementedInterfaceCount() != 0 || info.getExtendedInterfacesCount() != 0)) {
            t.report(n, DISALLOWED_MEMBER_JSDOC, new String[0]);
        }
    }

    private void validateDeprecatedJsDoc(NodeTraversal t, Node n, JSDocInfo info) {
        if (info != null && info.isExpose()) {
            t.getCompiler().report(t.makeError(n, ANNOTATION_DEPRECATED, "@expose", "Use @nocollapse or @export instead."));
        }
    }

    private void validateNoCollapse(NodeTraversal t, Node n, JSDocInfo info) {
        if (n.isFromExterns()) {
            if (info != null && info.isNoCollapse()) {
                t.getCompiler().report(t.makeError(n, MISPLACED_ANNOTATION, "@nocollapse", "This JSDoc has no effect in externs."));
            }
            return;
        }
        if (!NodeUtil.isPrototypePropertyDeclaration(n.getParent())) {
            return;
        }
        JSDocInfo jsdoc = n.getJSDocInfo();
        if (jsdoc != null && jsdoc.isNoCollapse()) {
            t.getCompiler().report(t.makeError(n, MISPLACED_ANNOTATION, "@nocollapse", "This JSDoc has no effect on prototype properties."));
        }
    }

    private void validateFunctionJsDoc(NodeTraversal t, Node n, JSDocInfo info) {
        if (info == null) {
            return;
        }
        if (info.containsFunctionDeclaration() && !info.hasType()) {
            switch (n.getType()) {
                case 105: 
                case 118: 
                case 147: 
                case 148: 
                case 149: 
                case 154: 
                case 160: 
                case 162: 
                case 169: {
                    return;
                }
                case 33: 
                case 35: {
                    if (!n.getFirstChild().isQualifiedName()) break;
                    return;
                }
                case 86: {
                    return;
                }
            }
            t.getCompiler().report(t.makeError(n, MISPLACED_ANNOTATION, "function", "This JSDoc is not attached to a function node. Are you missing parentheses?"));
        }
    }

    private void validateMsgJsDoc(NodeTraversal t, Node n, JSDocInfo info) {
        if (info == null) {
            return;
        }
        if (info.getDescription() != null || info.isHidden() || info.getMeaning() != null) {
            boolean descOkay = false;
            switch (n.getType()) {
                case 86: {
                    Node lhs = n.getFirstChild();
                    if (lhs.isName()) {
                        descOkay = lhs.getString().startsWith("MSG_");
                        break;
                    }
                    if (!lhs.isQualifiedName()) break;
                    descOkay = lhs.getLastChild().getString().startsWith("MSG_");
                    break;
                }
                case 118: 
                case 149: 
                case 162: {
                    descOkay = n.getFirstChild().getString().startsWith("MSG_");
                    break;
                }
                case 154: {
                    descOkay = n.getString().startsWith("MSG_");
                }
            }
            if (!descOkay) {
                t.getCompiler().report(t.makeError(n, MISPLACED_MSG_ANNOTATION, new String[0]));
            }
        }
    }

    private void validateTypeAnnotations(NodeTraversal t, Node n, JSDocInfo info) {
        if (info != null && info.hasType()) {
            boolean valid = false;
            switch (n.getType()) {
                case 105: {
                    valid = NodeUtil.isFunctionDeclaration(n);
                    break;
                }
                case 38: 
                case 179: {
                    Node parent = n.getParent();
                    switch (parent.getType()) {
                        case 83: 
                        case 105: 
                        case 118: 
                        case 120: 
                        case 147: 
                        case 148: 
                        case 149: 
                        case 154: 
                        case 162: {
                            valid = true;
                        }
                    }
                    break;
                }
                case 118: 
                case 147: 
                case 148: 
                case 149: 
                case 154: 
                case 155: 
                case 162: 
                case 169: {
                    valid = true;
                    break;
                }
                case 86: {
                    valid = n.getParent().isExprResult() && (n.getFirstChild().isGetProp() || n.getFirstChild().isGetElem());
                    break;
                }
                case 33: {
                    valid = n.getParent().isExprResult() && n.isQualifiedName();
                    break;
                }
                case 37: {
                    valid = info.isDefine();
                    break;
                }
            }
            if (!valid) {
                t.getCompiler().report(t.makeError(n, MISPLACED_ANNOTATION, "type", "Type annotations are not allowed here. Are you missing parentheses?"));
            }
        }
    }

    private void validateArrowFunction(Node n) {
        JSDocInfo info;
        if (n.isArrowFunction() && (info = NodeUtil.getBestJSDocInfo(n)) != null && info.isConstructorOrInterface()) {
            this.compiler.report(JSError.make(n, ARROW_FUNCTION_AS_CONSTRUCTOR, new String[0]));
        }
    }
}

