/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.base.Preconditions;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.HotSwapCompilerPass;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.rhino.IR;
import com.google.javascript.rhino.Node;

public final class Es6RewriteDestructuring
implements NodeTraversal.Callback,
HotSwapCompilerPass {
    private final AbstractCompiler compiler;
    private static final String DESTRUCTURING_TEMP_VAR = "$jscomp$destructuring$var";
    private int destructuringVarCounter = 0;

    public Es6RewriteDestructuring(AbstractCompiler compiler) {
        this.compiler = compiler;
    }

    @Override
    public void process(Node externs, Node root) {
        NodeTraversal.traverseEs6(this.compiler, externs, this);
        NodeTraversal.traverseEs6(this.compiler, root, this);
    }

    @Override
    public void hotSwapScript(Node scriptRoot, Node originalRoot) {
        NodeTraversal.traverseEs6(this.compiler, scriptRoot, this);
    }

    @Override
    public boolean shouldTraverse(NodeTraversal nodeTraversal, Node n, Node parent) {
        switch (n.getType()) {
            case 83: {
                this.visitParamList(n, parent);
                break;
            }
            case 163: {
                this.visitForOf(n);
            }
        }
        return true;
    }

    @Override
    public void visit(NodeTraversal t, Node n, Node parent) {
        switch (n.getType()) {
            case 156: {
                this.visitArrayPattern(t, n, parent);
                break;
            }
            case 157: {
                this.visitObjectPattern(t, n, parent);
            }
        }
    }

    private void visitParamList(Node paramList, Node function) {
        Node insertSpot = null;
        Node body = function.getLastChild();
        for (int i = 0; i < paramList.getChildCount(); ++i) {
            Node param = paramList.getChildAtIndex(i);
            if (param.isDefaultValue()) {
                Node newParam;
                Node nameOrPattern = param.removeFirstChild();
                Node defaultValue = param.removeFirstChild();
                boolean isNoop = false;
                if (nameOrPattern.isName()) {
                    if (defaultValue.isName()) {
                        isNoop = "undefined".equals(defaultValue.getString());
                    } else if (defaultValue.isVoid()) {
                        isNoop = NodeUtil.isImmutableValue(defaultValue.getFirstChild());
                    }
                }
                if (isNoop) {
                    newParam = nameOrPattern.cloneTree();
                } else {
                    newParam = nameOrPattern.isName() ? nameOrPattern : IR.name(DESTRUCTURING_TEMP_VAR + this.destructuringVarCounter++);
                    Node lhs = nameOrPattern.cloneTree();
                    Node rhs = Es6RewriteDestructuring.defaultValueHook(newParam.cloneTree(), defaultValue);
                    Node newStatement = nameOrPattern.isName() ? IR.exprResult(IR.assign(lhs, rhs)) : IR.var(lhs, rhs);
                    newStatement.useSourceInfoIfMissingFromForTree(param);
                    body.addChildAfter(newStatement, insertSpot);
                    insertSpot = newStatement;
                }
                paramList.replaceChild(param, newParam);
                newParam.setOptionalArg(true);
                this.compiler.reportCodeChange();
                continue;
            }
            if (!param.isDestructuringPattern()) continue;
            String tempVarName = DESTRUCTURING_TEMP_VAR + this.destructuringVarCounter++;
            paramList.replaceChild(param, IR.name(tempVarName));
            Node newDecl = IR.var(param, IR.name(tempVarName));
            body.addChildAfter(newDecl, insertSpot);
            insertSpot = newDecl;
            this.compiler.reportCodeChange();
        }
    }

    private void visitForOf(Node node) {
        Node pattern = node.getFirstChild();
        if (pattern.isDestructuringPattern()) {
            this.visitDestructuringPatternInEnhancedFor(pattern);
        }
    }

    private void visitObjectPattern(NodeTraversal t, Node objectPattern, Node parent) {
        Node nodeToDetach;
        Node rhs;
        if (NodeUtil.isNameDeclaration(parent) && !NodeUtil.isEnhancedFor(parent.getParent())) {
            rhs = objectPattern.getLastChild();
            nodeToDetach = parent;
        } else if (parent.isAssign() && parent.getParent().isExprResult()) {
            rhs = parent.getLastChild();
            nodeToDetach = parent.getParent();
        } else {
            if (parent.isStringKey() || parent.isArrayPattern() || parent.isDefaultValue()) {
                return;
            }
            if (NodeUtil.isEnhancedFor(parent) || NodeUtil.isEnhancedFor(parent.getParent())) {
                this.visitDestructuringPatternInEnhancedFor(objectPattern);
                return;
            }
            if (parent.isCatch()) {
                this.visitDestructuringPatternInCatch(objectPattern);
                return;
            }
            throw new IllegalStateException("Unexpected OBJECT_PATTERN parent: " + parent);
        }
        String tempVarName = DESTRUCTURING_TEMP_VAR + this.destructuringVarCounter++;
        Node tempDecl = IR.var(IR.name(tempVarName), rhs.detachFromParent()).useSourceInfoIfMissingFromForTree(objectPattern);
        nodeToDetach.getParent().addChildBefore(tempDecl, nodeToDetach);
        Node child = objectPattern.getFirstChild();
        while (child != null) {
            Node newNode;
            Node newRHS;
            Node newLHS;
            Node next = child.getNext();
            if (child.isStringKey()) {
                if (!child.hasChildren()) {
                    Node name = IR.name(child.getString());
                    name.useSourceInfoIfMissingFrom(child);
                    child.addChildToBack(name);
                }
                Node getprop = new Node(child.isQuotedString() ? 35 : 33, IR.name(tempVarName), IR.string(child.getString()));
                Node value = child.removeFirstChild();
                if (!value.isDefaultValue()) {
                    newLHS = value;
                    newRHS = getprop;
                } else {
                    newLHS = value.removeFirstChild();
                    Node defaultValue = value.removeFirstChild();
                    newRHS = Es6RewriteDestructuring.defaultValueHook(getprop, defaultValue);
                }
            } else if (child.isComputedProp()) {
                if (child.getLastChild().isDefaultValue()) {
                    newLHS = child.getLastChild().removeFirstChild();
                    Node getelem = IR.getelem(IR.name(tempVarName), child.removeFirstChild());
                    String intermediateTempVarName = DESTRUCTURING_TEMP_VAR + this.destructuringVarCounter++;
                    Node intermediateDecl = IR.var(IR.name(intermediateTempVarName), getelem);
                    intermediateDecl.useSourceInfoIfMissingFromForTree(child);
                    nodeToDetach.getParent().addChildBefore(intermediateDecl, nodeToDetach);
                    newRHS = Es6RewriteDestructuring.defaultValueHook(IR.name(intermediateTempVarName), child.getLastChild().removeFirstChild());
                } else {
                    newRHS = IR.getelem(IR.name(tempVarName), child.removeFirstChild());
                    newLHS = child.removeFirstChild();
                }
            } else if (child.isDefaultValue()) {
                newLHS = child.removeFirstChild();
                Node defaultValue = child.removeFirstChild();
                Node getprop = IR.getprop(IR.name(tempVarName), IR.string(newLHS.getString()));
                newRHS = Es6RewriteDestructuring.defaultValueHook(getprop, defaultValue);
            } else {
                throw new IllegalStateException("Unexpected OBJECT_PATTERN child: " + child);
            }
            if (NodeUtil.isNameDeclaration(parent)) {
                newNode = IR.declaration(newLHS, newRHS, parent.getType());
            } else if (parent.isAssign()) {
                newNode = IR.exprResult(IR.assign(newLHS, newRHS));
            } else {
                throw new IllegalStateException("not reached");
            }
            newNode.useSourceInfoIfMissingFromForTree(child);
            nodeToDetach.getParent().addChildBefore(newNode, nodeToDetach);
            this.visit(t, newLHS, newLHS.getParent());
            child = next;
        }
        nodeToDetach.detachFromParent();
        this.compiler.reportCodeChange();
    }

    private void visitArrayPattern(NodeTraversal t, Node arrayPattern, Node parent) {
        Node nodeToDetach;
        Node rhs;
        if (NodeUtil.isNameDeclaration(parent) && !NodeUtil.isEnhancedFor(parent.getParent())) {
            Preconditions.checkState((arrayPattern.getNext() == null ? 1 : 0) != 0);
            rhs = arrayPattern.getLastChild();
            nodeToDetach = parent;
        } else if (parent.isAssign()) {
            rhs = arrayPattern.getNext();
            nodeToDetach = parent.getParent();
            Preconditions.checkState((boolean)nodeToDetach.isExprResult());
        } else {
            if (parent.isArrayPattern() || parent.isDefaultValue() || parent.isStringKey()) {
                return;
            }
            if (NodeUtil.isEnhancedFor(parent) || NodeUtil.isEnhancedFor(parent.getParent())) {
                this.visitDestructuringPatternInEnhancedFor(arrayPattern);
                return;
            }
            if (parent.isCatch()) {
                this.visitDestructuringPatternInCatch(arrayPattern);
                return;
            }
            throw new IllegalStateException("Unexpected ARRAY_PATTERN parent: " + parent);
        }
        String tempVarName = DESTRUCTURING_TEMP_VAR + this.destructuringVarCounter++;
        Node tempDecl = IR.var(IR.name(tempVarName), rhs.detachFromParent()).useSourceInfoIfMissingFromForTree(arrayPattern);
        nodeToDetach.getParent().addChildBefore(tempDecl, nodeToDetach);
        int i = 0;
        Node child = arrayPattern.getFirstChild();
        while (child != null) {
            Node next = child.getNext();
            if (!child.isEmpty()) {
                Node newNode;
                Node newRHS;
                Node newLHS;
                if (child.isDefaultValue()) {
                    Node getElem = IR.getelem(IR.name(tempVarName), IR.number(i));
                    newLHS = child.getFirstChild().detachFromParent();
                    newRHS = Es6RewriteDestructuring.defaultValueHook(getElem, child.getLastChild().detachFromParent());
                } else if (child.isRest()) {
                    newLHS = child.detachFromParent();
                    newLHS.setType(38);
                    newRHS = IR.call(IR.getprop(IR.getprop(IR.arraylit(new Node[0]), IR.string("slice")), IR.string("call")), IR.name(tempVarName), IR.number(i));
                } else {
                    newLHS = child.detachFromParent();
                    newRHS = IR.getelem(IR.name(tempVarName), IR.number(i));
                }
                if (parent.isAssign()) {
                    Node assignment = IR.assign(newLHS, newRHS);
                    newNode = IR.exprResult(assignment);
                } else {
                    newNode = IR.declaration(newLHS, newRHS, parent.getType());
                }
                newNode.useSourceInfoIfMissingFromForTree(arrayPattern);
                nodeToDetach.getParent().addChildBefore(newNode, nodeToDetach);
                this.visit(t, newLHS, newLHS.getParent());
            }
            child = next;
            ++i;
        }
        nodeToDetach.detachFromParent();
        this.compiler.reportCodeChange();
    }

    private void visitDestructuringPatternInEnhancedFor(Node pattern) {
        int declarationType;
        Node forNode;
        if (NodeUtil.isEnhancedFor(pattern.getParent())) {
            forNode = pattern.getParent();
            declarationType = 86;
        } else {
            forNode = pattern.getParent().getParent();
            declarationType = pattern.getParent().getType();
            Preconditions.checkState((boolean)NodeUtil.isEnhancedFor(forNode));
        }
        String tempVarName = DESTRUCTURING_TEMP_VAR + this.destructuringVarCounter++;
        Node block = forNode.getLastChild();
        if (declarationType == 86) {
            Node decl = IR.declaration(IR.name(tempVarName), 162);
            decl.useSourceInfoIfMissingFromForTree(pattern);
            pattern.getParent().replaceChild(pattern, decl);
            Node exprResult = IR.exprResult(IR.assign(pattern, IR.name(tempVarName)));
            exprResult.useSourceInfoIfMissingFromForTree(pattern);
            block.addChildToFront(exprResult);
        } else {
            pattern.getParent().replaceChild(pattern, IR.name(tempVarName).useSourceInfoFrom(pattern));
            Node decl = IR.declaration(pattern, IR.name(tempVarName), declarationType);
            decl.useSourceInfoIfMissingFromForTree(pattern);
            block.addChildToFront(decl);
        }
    }

    private void visitDestructuringPatternInCatch(Node pattern) {
        String tempVarName = DESTRUCTURING_TEMP_VAR + this.destructuringVarCounter++;
        Node catchBlock = pattern.getNext();
        pattern.getParent().replaceChild(pattern, IR.name(tempVarName));
        catchBlock.addChildToFront(IR.declaration(pattern, IR.name(tempVarName), 162));
    }

    private static Node defaultValueHook(Node getprop, Node defaultValue) {
        return IR.hook(IR.sheq(getprop, IR.name("undefined")), defaultValue, getprop.cloneTree());
    }
}

