/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.CompilerOptions;
import com.google.javascript.jscomp.DiagnosticType;
import com.google.javascript.jscomp.Es6TemplateLiterals;
import com.google.javascript.jscomp.HotSwapCompilerPass;
import com.google.javascript.jscomp.JSError;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.rhino.IR;
import com.google.javascript.rhino.JSDocInfo;
import com.google.javascript.rhino.JSDocInfoBuilder;
import com.google.javascript.rhino.JSTypeExpression;
import com.google.javascript.rhino.Node;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public final class Es6ToEs3Converter
implements NodeTraversal.Callback,
HotSwapCompilerPass {
    private final AbstractCompiler compiler;
    static final DiagnosticType CANNOT_CONVERT = DiagnosticType.error("JSC_CANNOT_CONVERT", "This code cannot be converted from ES6. {0}");
    static final DiagnosticType CANNOT_CONVERT_YET = DiagnosticType.error("JSC_CANNOT_CONVERT_YET", "ES6 transpilation of ''{0}'' is not yet implemented.");
    static final DiagnosticType DYNAMIC_EXTENDS_TYPE = DiagnosticType.error("JSC_DYNAMIC_EXTENDS_TYPE", "The class in an extends clause must be a qualified name.");
    static final DiagnosticType CLASS_REASSIGNMENT = DiagnosticType.error("CLASS_REASSIGNMENT", "Class names defined inside a function cannot be reassigned.");
    static final DiagnosticType CONFLICTING_GETTER_SETTER_TYPE = DiagnosticType.error("CONFLICTING_GETTER_SETTER_TYPE", "The types of the getter and setter for property ''{0}'' do not match.");
    static final DiagnosticType BAD_REST_PARAMETER_ANNOTATION = DiagnosticType.warning("BAD_REST_PARAMETER_ANNOTATION", "Missing \"...\" in type annotation for rest parameter.");
    private static final String REST_INDEX = "$jscomp$restIndex";
    private static final String REST_PARAMS = "$jscomp$restParams";
    private static final String FRESH_SPREAD_VAR = "$jscomp$spread$args";
    private static final String FRESH_COMP_PROP_VAR = "$jscomp$compprop";
    private static final String ITER_BASE = "$jscomp$iter$";
    private static final String ITER_RESULT = "$jscomp$key$";
    static final String INHERITS = "$jscomp.inherits";
    static final String MAKE_ITER = "$jscomp.makeIterator";

    public Es6ToEs3Converter(AbstractCompiler compiler) {
        this.compiler = compiler;
    }

    @Override
    public void process(Node externs, Node root) {
        NodeTraversal.traverseEs6(this.compiler, externs, this);
        NodeTraversal.traverseEs6(this.compiler, root, this);
    }

    @Override
    public void hotSwapScript(Node scriptRoot, Node originalRoot) {
        NodeTraversal.traverseEs6(this.compiler, scriptRoot, this);
    }

    @Override
    public boolean shouldTraverse(NodeTraversal t, Node n, Node parent) {
        switch (n.getType()) {
            case 173: {
                this.visitRestParam(n, parent);
                break;
            }
            case 147: 
            case 148: {
                if (this.compiler.getOptions().getLanguageOut() != CompilerOptions.LanguageMode.ECMASCRIPT3) break;
                this.cannotConvert(n, "ES5 getters/setters (consider using --language_out=ES5)");
                return false;
            }
        }
        return true;
    }

    @Override
    public void visit(NodeTraversal t, Node n, Node parent) {
        block0 : switch (n.getType()) {
            case 64: {
                for (Node child : n.children()) {
                    if (!child.isComputedProp()) continue;
                    this.visitObjectWithComputedProperty(n, parent);
                    break block0;
                }
                break;
            }
            case 160: {
                if (!parent.isObjectLit()) break;
                this.visitMemberDefInObjectLit(n, parent);
                break;
            }
            case 163: {
                this.visitForOf(n, parent);
                break;
            }
            case 154: {
                this.visitStringKey(n);
                break;
            }
            case 158: {
                this.visitClass(n, parent);
                break;
            }
            case 30: 
            case 37: 
            case 63: {
                for (Node child : n.children()) {
                    if (!child.isSpread()) continue;
                    this.visitArrayLitOrCallWithSpread(n, parent);
                    break block0;
                }
                break;
            }
            case 176: {
                Es6TemplateLiterals.visitTaggedTemplateLiteral(t, n);
                break;
            }
            case 177: {
                if (parent.isTaggedTemplateLit()) break;
                Es6TemplateLiterals.visitTemplateLiteral(t, n);
            }
        }
    }

    private void visitMemberDefInObjectLit(Node n, Node parent) {
        String name = n.getString();
        Node stringKey = IR.stringKey(name, n.getFirstChild().detachFromParent());
        parent.replaceChild(n, stringKey);
        this.compiler.reportCodeChange();
    }

    private void visitStringKey(Node n) {
        if (!n.hasChildren()) {
            Node name = IR.name(n.getString());
            name.useSourceInfoIfMissingFrom(n);
            n.addChildToBack(name);
            this.compiler.reportCodeChange();
        }
    }

    private void visitForOf(Node node, Node parent) {
        Node declarationOrAssign;
        String variableName;
        int declType;
        Node variable = node.removeFirstChild();
        Node iterable = node.removeFirstChild();
        Node body = node.removeFirstChild();
        Node iterName = IR.name(ITER_BASE + (String)this.compiler.getUniqueNameIdSupplier().get());
        Node getNext = IR.call(IR.getprop(iterName.cloneTree(), IR.string("next")), new Node[0]);
        if (variable.isName()) {
            declType = 38;
            variableName = variable.getQualifiedName();
        } else {
            Preconditions.checkState((boolean)NodeUtil.isNameDeclaration(variable), (String)"Expected var, let, or const. Got %s", (Object[])new Object[]{variable});
            declType = variable.getType();
            variableName = variable.getFirstChild().getQualifiedName();
        }
        Node iterResult = IR.name(ITER_RESULT + variableName);
        Node makeIter = IR.call(NodeUtil.newQName(this.compiler, MAKE_ITER), iterable);
        this.compiler.needsEs6Runtime = true;
        Node init = IR.var(iterName.cloneTree(), makeIter);
        Node initIterResult = iterResult.cloneTree();
        initIterResult.addChildToFront(getNext.cloneTree());
        init.addChildToBack(initIterResult);
        Node cond = IR.not(IR.getprop(iterResult.cloneTree(), IR.string("done")));
        Node incr = IR.assign(iterResult.cloneTree(), getNext.cloneTree());
        if (declType == 38) {
            declarationOrAssign = IR.exprResult(IR.assign(IR.name(variableName), IR.getprop(iterResult.cloneTree(), IR.string("value"))));
        } else {
            declarationOrAssign = new Node(declType, IR.name(variableName));
            declarationOrAssign.getFirstChild().addChildToBack(IR.getprop(iterResult.cloneTree(), IR.string("value")));
        }
        body.addChildToFront(declarationOrAssign);
        Node newFor = IR.forNode(init, cond, incr, body);
        newFor.useSourceInfoIfMissingFromForTree(node);
        parent.replaceChild(node, newFor);
        this.compiler.reportCodeChange();
    }

    private void checkClassReassignment(Node clazz) {
        Node name = NodeUtil.getClassNameNode(clazz);
        Node enclosingFunction = NodeUtil.getEnclosingFunction(clazz);
        if (enclosingFunction == null) {
            return;
        }
        CheckClassAssignments checkAssigns = new CheckClassAssignments(name);
        NodeTraversal.traverseEs6(this.compiler, enclosingFunction, checkAssigns);
    }

    private void visitRestParam(Node restParam, Node paramList) {
        Node functionBody = paramList.getLastSibling();
        restParam.setType(38);
        restParam.setVarArgs(true);
        JSTypeExpression type = null;
        JSDocInfo info = restParam.getJSDocInfo();
        String paramName = restParam.getString();
        if (info != null) {
            type = info.getType();
        } else {
            JSDocInfo functionInfo = paramList.getParent().getJSDocInfo();
            if (functionInfo != null) {
                type = functionInfo.getParameterType(paramName);
            }
        }
        if (type != null && type.getRoot().getType() != 305) {
            this.compiler.report(JSError.make(restParam, BAD_REST_PARAMETER_ANNOTATION, new String[0]));
        }
        if (!functionBody.hasChildren()) {
            this.compiler.reportCodeChange();
            return;
        }
        Node newBlock = IR.block().useSourceInfoFrom(functionBody);
        Node name = IR.name(paramName);
        Node let = IR.let(name, IR.name(REST_PARAMS)).useSourceInfoIfMissingFromForTree(functionBody);
        newBlock.addChildToFront(let);
        for (Node child : functionBody.children()) {
            newBlock.addChildToBack(child.detachFromParent());
        }
        if (type != null) {
            Node arrayType = IR.string("Array");
            Node typeNode = type.getRoot();
            Node memberType = typeNode.getType() == 305 ? typeNode.getFirstChild().cloneNode() : typeNode.cloneNode();
            arrayType.addChildToFront(new Node(125, memberType).useSourceInfoIfMissingFrom(typeNode));
            JSDocInfoBuilder builder = new JSDocInfoBuilder(false);
            builder.recordType(new JSTypeExpression(new Node(306, arrayType), restParam.getSourceFileName()));
            name.setJSDocInfo(builder.build());
        }
        int restIndex = paramList.getIndexOfChild(restParam);
        Node newArr = IR.var(IR.name(REST_PARAMS), IR.arraylit(new Node[0]));
        functionBody.addChildToFront(newArr.useSourceInfoIfMissingFromForTree(restParam));
        Node init = IR.var(IR.name(REST_INDEX), IR.number(restIndex));
        Node cond = IR.lt(IR.name(REST_INDEX), IR.getprop(IR.name("arguments"), IR.string("length")));
        Node incr = IR.inc(IR.name(REST_INDEX), false);
        Node body = IR.block(IR.exprResult(IR.assign(IR.getelem(IR.name(REST_PARAMS), IR.sub(IR.name(REST_INDEX), IR.number(restIndex))), IR.getelem(IR.name("arguments"), IR.name(REST_INDEX)))));
        functionBody.addChildAfter(IR.forNode(init, cond, incr, body).useSourceInfoIfMissingFromForTree(restParam), newArr);
        functionBody.addChildToBack(newBlock);
        this.compiler.reportCodeChange();
    }

    private void visitArrayLitOrCallWithSpread(Node node, Node parent) {
        Preconditions.checkArgument((node.isCall() || node.isArrayLit() || node.isNew() ? 1 : 0) != 0);
        ArrayList<Node> groups = new ArrayList<Node>();
        Node currGroup = null;
        Node callee = node.isArrayLit() ? null : node.removeFirstChild();
        Node currElement = node.removeFirstChild();
        while (currElement != null) {
            if (currElement.isSpread()) {
                if (currGroup != null) {
                    groups.add(currGroup);
                    currGroup = null;
                }
                groups.add(currElement.removeFirstChild());
            } else {
                if (currGroup == null) {
                    currGroup = IR.arraylit(new Node[0]);
                }
                currGroup.addChildToBack(currElement);
            }
            currElement = node.removeFirstChild();
        }
        if (currGroup != null) {
            groups.add(currGroup);
        }
        Node result = null;
        Node joinedGroups = IR.call(IR.getprop(IR.arraylit(new Node[0]), IR.string("concat")), groups.toArray(new Node[groups.size()]));
        if (node.isArrayLit()) {
            result = joinedGroups;
        } else if (node.isCall()) {
            if (NodeUtil.mayHaveSideEffects(callee) && callee.isGetProp()) {
                Node statement = node;
                while (!NodeUtil.isStatement(statement)) {
                    statement = statement.getParent();
                }
                Node freshVar = IR.name(FRESH_SPREAD_VAR + (String)this.compiler.getUniqueNameIdSupplier().get());
                Node n = IR.var(freshVar.cloneTree());
                n.useSourceInfoIfMissingFromForTree(statement);
                statement.getParent().addChildBefore(n, statement);
                callee.addChildToFront(IR.assign(freshVar.cloneTree(), callee.removeFirstChild()));
                result = IR.call(IR.getprop(callee, IR.string("apply")), freshVar, joinedGroups);
            } else {
                Node context = callee.isGetProp() ? callee.getFirstChild().cloneTree() : IR.nullNode();
                result = IR.call(IR.getprop(callee, IR.string("apply")), context, joinedGroups);
            }
        } else {
            Node bindApply = NodeUtil.newQName(this.compiler, "Function.prototype.bind.apply");
            result = IR.newNode(bindApply, callee, joinedGroups);
        }
        result.useSourceInfoIfMissingFromForTree(node);
        parent.replaceChild(node, result);
        this.compiler.reportCodeChange();
    }

    private void visitObjectWithComputedProperty(Node obj, Node parent) {
        Preconditions.checkArgument((boolean)obj.isObjectLit());
        List<Node> props = new ArrayList();
        Node currElement = obj.getFirstChild();
        while (currElement != null) {
            if (currElement.getBooleanProp(73) || currElement.getBooleanProp(74)) {
                this.cannotConvertYet(currElement, "computed getter/setter");
                return;
            }
            if (currElement.isGetterDef() || currElement.isSetterDef()) {
                currElement = currElement.getNext();
                continue;
            }
            Node nextNode = currElement.getNext();
            obj.removeChild(currElement);
            props.add(currElement);
            currElement = nextNode;
        }
        String objName = FRESH_COMP_PROP_VAR + (String)this.compiler.getUniqueNameIdSupplier().get();
        props = Lists.reverse(props);
        Node result = IR.name(objName);
        for (Node propdef : props) {
            if (propdef.isComputedProp()) {
                Node propertyExpression = propdef.removeFirstChild();
                Node value = propdef.removeFirstChild();
                result = IR.comma(IR.assign(IR.getelem(IR.name(objName), propertyExpression), value), result);
                continue;
            }
            if (!propdef.hasChildren()) {
                Node name = IR.name(propdef.getString()).useSourceInfoIfMissingFrom(propdef);
                propdef.addChildToBack(name);
            }
            Node val = propdef.removeFirstChild();
            propdef.setType(40);
            int type = propdef.isQuotedString() ? 35 : 33;
            Node access = new Node(type, IR.name(objName), propdef);
            result = IR.comma(IR.assign(access, val), result);
        }
        Node statement = obj;
        while (!NodeUtil.isStatement(statement)) {
            statement = statement.getParent();
        }
        result.useSourceInfoIfMissingFromForTree(obj);
        parent.replaceChild(obj, result);
        Node var = IR.var(IR.name(objName), obj);
        var.useSourceInfoIfMissingFromForTree(statement);
        statement.getParent().addChildBefore(var, statement);
        this.compiler.reportCodeChange();
    }

    private void visitClass(Node classNode, Node parent) {
        Node var;
        Node definePropsCall;
        Node declaration;
        String declaredMember;
        this.checkClassReassignment(classNode);
        ClassDeclarationMetadata metadata = ClassDeclarationMetadata.create(classNode, parent);
        if (metadata == null || metadata.fullClassName == null) {
            this.cannotConvert(parent, "Can only convert classes that are declarations or the right hand side of a simple assignment.");
            return;
        }
        if (metadata.hasSuperClass() && !metadata.superClassNameNode.isQualifiedName()) {
            this.compiler.report(JSError.make(metadata.superClassNameNode, DYNAMIC_EXTENDS_TYPE, new String[0]));
            return;
        }
        boolean useUnique = NodeUtil.isStatement(classNode) && !NodeUtil.isInFunction(classNode);
        String uniqueFullClassName = useUnique ? Es6ToEs3Converter.getUniqueClassName(metadata.fullClassName) : metadata.fullClassName;
        Node classNameAccess = NodeUtil.newQName(this.compiler, uniqueFullClassName);
        Node prototypeAccess = NodeUtil.newPropertyAccess(this.compiler, classNameAccess, "prototype");
        Preconditions.checkState((boolean)NodeUtil.isStatement(metadata.insertionPoint), (String)"insertion point must be a statement: %s", (Object[])new Object[]{metadata.insertionPoint});
        Node constructor = null;
        JSDocInfo ctorJSDocInfo = null;
        Node classMembers = classNode.getLastChild();
        LinkedHashMap prototypeMembersToDeclare = new LinkedHashMap();
        LinkedHashMap<String, JSDocInfo> classMembersToDeclare = new LinkedHashMap<String, JSDocInfo>();
        for (Node node : classMembers.children()) {
            if (node.isEmpty()) continue;
            Preconditions.checkState((node.isMemberFunctionDef() || node.isGetterDef() || node.isSetterDef() || node.isComputedProp() && !node.getBooleanProp(75) ? 1 : 0) != 0, (String)"Member variables should have been transpiled earlier: ", (Object[])new Object[]{node});
            if (node.isComputedProp() && (node.getBooleanProp(73) || node.getBooleanProp(74))) {
                this.cannotConvertYet(node, "computed getter or setter in classes");
                continue;
            }
            if (node.isGetterDef() || node.isSetterDef()) {
                JSTypeExpression existingType;
                JSTypeExpression typeExpr = this.getTypeFromGetterOrSetter(node).clone();
                this.addToDefinePropertiesObject(metadata, node);
                LinkedHashMap<String, JSDocInfo> membersToDeclare = node.isStaticMember() ? classMembersToDeclare : prototypeMembersToDeclare;
                JSDocInfo existingJSDoc = (JSDocInfo)membersToDeclare.get(node.getString());
                JSTypeExpression jSTypeExpression = existingType = existingJSDoc == null ? null : existingJSDoc.getType();
                if (existingType != null && !existingType.equals(typeExpr)) {
                    this.compiler.report(JSError.make(node, CONFLICTING_GETTER_SETTER_TYPE, node.getString()));
                    continue;
                }
                JSDocInfoBuilder jsDoc = new JSDocInfoBuilder(false);
                jsDoc.recordType(typeExpr);
                if (node.getJSDocInfo() != null && node.getJSDocInfo().isExport()) {
                    jsDoc.recordExport();
                }
                if (node.isStaticMember()) {
                    jsDoc.recordNoCollapse();
                }
                membersToDeclare.put(node.getString(), jsDoc.build());
                continue;
            }
            if (node.isMemberFunctionDef() && node.getString().equals("constructor")) {
                ctorJSDocInfo = node.getJSDocInfo();
                constructor = node.getFirstChild().detachFromParent();
                if (metadata.anonymous) continue;
                constructor.replaceChild(constructor.getFirstChild(), metadata.classNameNode.cloneNode());
                continue;
            }
            Node qualifiedMemberAccess = Es6ToEs3Converter.getQualifiedMemberAccess(this.compiler, node, classNameAccess, prototypeAccess);
            Node method = node.getLastChild().detachFromParent();
            Node assign = IR.assign(qualifiedMemberAccess, method);
            assign.useSourceInfoIfMissingFromForTree(node);
            JSDocInfo info = node.getJSDocInfo();
            if (node.isStaticMember() && NodeUtil.referencesThis(assign.getLastChild())) {
                JSDocInfoBuilder memberDoc = JSDocInfoBuilder.maybeCopyFrom(info);
                memberDoc.recordThisType(new JSTypeExpression(new Node(306, new Node(304)), node.getSourceFileName()));
                info = memberDoc.build();
            }
            if (info != null) {
                assign.setJSDocInfo(info);
            }
            Node newNode = NodeUtil.newExpr(assign);
            metadata.insertNodeAndAdvance(newNode);
        }
        for (Map.Entry entry : prototypeMembersToDeclare.entrySet()) {
            declaredMember = (String)entry.getKey();
            declaration = IR.getprop(prototypeAccess.cloneTree(), IR.string(declaredMember));
            declaration.setJSDocInfo((JSDocInfo)entry.getValue());
            metadata.insertNodeAndAdvance(IR.exprResult(declaration).useSourceInfoIfMissingFromForTree(classNode));
        }
        for (Map.Entry entry : classMembersToDeclare.entrySet()) {
            declaredMember = (String)entry.getKey();
            declaration = IR.getprop(classNameAccess.cloneTree(), IR.string(declaredMember));
            declaration.setJSDocInfo((JSDocInfo)entry.getValue());
            metadata.insertNodeAndAdvance(IR.exprResult(declaration).useSourceInfoIfMissingFromForTree(classNode));
        }
        if (metadata.definePropertiesObjForPrototype.hasChildren()) {
            definePropsCall = IR.exprResult(IR.call(NodeUtil.newQName(this.compiler, "Object.defineProperties"), prototypeAccess.cloneTree(), metadata.definePropertiesObjForPrototype));
            definePropsCall.useSourceInfoIfMissingFromForTree(classNode);
            metadata.insertNodeAndAdvance(definePropsCall);
        }
        if (metadata.definePropertiesObjForClass.hasChildren()) {
            definePropsCall = IR.exprResult(IR.call(NodeUtil.newQName(this.compiler, "Object.defineProperties"), classNameAccess.cloneTree(), metadata.definePropertiesObjForClass));
            definePropsCall.useSourceInfoIfMissingFromForTree(classNode);
            metadata.insertNodeAndAdvance(definePropsCall);
        }
        Preconditions.checkNotNull(constructor);
        JSDocInfo classJSDoc = NodeUtil.getBestJSDocInfo(classNode);
        JSDocInfoBuilder jSDocInfoBuilder = JSDocInfoBuilder.maybeCopyFrom(classJSDoc);
        jSDocInfoBuilder.recordConstructor();
        if (metadata.hasSuperClass()) {
            String superClassString = metadata.superClassNameNode.getQualifiedName();
            if (jSDocInfoBuilder.isInterfaceRecorded()) {
                jSDocInfoBuilder.recordExtendedInterface(new JSTypeExpression(new Node(306, IR.string(superClassString)), metadata.superClassNameNode.getSourceFileName()));
            } else {
                Node inherits = IR.call(NodeUtil.newQName(this.compiler, INHERITS), NodeUtil.newQName(this.compiler, metadata.fullClassName), NodeUtil.newQName(this.compiler, superClassString));
                Node inheritsCall = IR.exprResult(inherits);
                this.compiler.needsEs6Runtime = true;
                inheritsCall.useSourceInfoIfMissingFromForTree(classNode);
                Node enclosingStatement = NodeUtil.getEnclosingStatement(classNode);
                enclosingStatement.getParent().addChildAfter(inheritsCall, enclosingStatement);
                jSDocInfoBuilder.recordBaseType(new JSTypeExpression(new Node(306, IR.string(superClassString)), metadata.superClassNameNode.getSourceFileName()));
            }
        }
        if (!(jSDocInfoBuilder.isUnrestrictedRecorded() || jSDocInfoBuilder.isDictRecorded() || jSDocInfoBuilder.isStructRecorded())) {
            jSDocInfoBuilder.recordStruct();
        }
        if (ctorJSDocInfo != null) {
            jSDocInfoBuilder.recordSuppressions(ctorJSDocInfo.getSuppressions());
            for (String param : ctorJSDocInfo.getParameterNames()) {
                jSDocInfoBuilder.recordParameter(param, ctorJSDocInfo.getParameterType(param));
            }
            jSDocInfoBuilder.mergePropertyBitfieldFrom(ctorJSDocInfo);
        }
        if (NodeUtil.isStatement(classNode)) {
            constructor.getFirstChild().setString("");
            Node ctorVar = IR.let(metadata.classNameNode.cloneNode(), constructor);
            ctorVar.useSourceInfoIfMissingFromForTree(classNode);
            parent.replaceChild(classNode, ctorVar);
        } else {
            parent.replaceChild(classNode, constructor);
        }
        if (NodeUtil.isStatement(constructor)) {
            constructor.setJSDocInfo(jSDocInfoBuilder.build());
        } else if (parent.isName()) {
            var = parent.getParent();
            var.setJSDocInfo(jSDocInfoBuilder.build());
        } else if (constructor.getParent().isName()) {
            var = constructor.getParent().getParent();
            var.setJSDocInfo(jSDocInfoBuilder.build());
        } else if (parent.isAssign()) {
            parent.setJSDocInfo(jSDocInfoBuilder.build());
        } else {
            throw new IllegalStateException("Unexpected parent node " + parent);
        }
        this.compiler.reportCodeChange();
    }

    private JSTypeExpression getTypeFromGetterOrSetter(Node node) {
        JSDocInfo info = node.getJSDocInfo();
        if (info != null) {
            if (node.isGetterDef() && info.getReturnType() != null) {
                return info.getReturnType();
            }
            Set<String> paramNames = info.getParameterNames();
            if (paramNames.size() == 1) {
                return info.getParameterType((String)Iterables.getOnlyElement(info.getParameterNames()));
            }
        }
        return new JSTypeExpression(new Node(304), node.getSourceFileName());
    }

    private void addToDefinePropertiesObject(ClassDeclarationMetadata metadata, Node member) {
        Node obj = member.isStaticMember() ? metadata.definePropertiesObjForClass : metadata.definePropertiesObjForPrototype;
        Node prop = NodeUtil.getFirstPropMatchingKey(obj, member.getString());
        if (prop == null) {
            prop = IR.objectlit(IR.stringKey("configurable", IR.trueNode()), IR.stringKey("enumerable", IR.trueNode()));
            obj.addChildToBack(IR.stringKey(member.getString(), prop));
        }
        Node function = member.getLastChild();
        JSDocInfoBuilder info = JSDocInfoBuilder.maybeCopyFrom(NodeUtil.getBestJSDocInfo(function));
        info.recordThisType(new JSTypeExpression(new Node(306, IR.string(metadata.fullClassName)), member.getSourceFileName()));
        Node stringKey = IR.stringKey(member.isGetterDef() ? "get" : "set", function.detachFromParent());
        stringKey.setJSDocInfo(info.build());
        prop.addChildToBack(stringKey);
        prop.useSourceInfoIfMissingFromForTree(member);
    }

    static Node getQualifiedMemberAccess(AbstractCompiler compiler, Node member, Node staticAccess, Node instanceAccess) {
        Node context = member.isStaticMember() ? staticAccess : instanceAccess;
        context = context.cloneTree();
        if (member.isComputedProp()) {
            return IR.getelem(context, member.removeFirstChild());
        }
        return NodeUtil.newPropertyAccess(compiler, context, member.getString());
    }

    private static String getUniqueClassName(String qualifiedName) {
        return qualifiedName;
    }

    private void cannotConvert(Node n, String message) {
        this.compiler.report(JSError.make(n, CANNOT_CONVERT, message));
    }

    private void cannotConvertYet(Node n, String feature) {
        this.compiler.report(JSError.make(n, CANNOT_CONVERT_YET, feature));
    }

    static class ClassDeclarationMetadata {
        private Node insertionPoint;
        private final Node definePropertiesObjForPrototype;
        private final Node definePropertiesObjForClass;
        final String fullClassName;
        final boolean anonymous;
        final Node classNameNode;
        final Node superClassNameNode;

        private ClassDeclarationMetadata(Node insertionPoint, String fullClassName, boolean anonymous, Node classNameNode, Node superClassNameNode) {
            this.insertionPoint = insertionPoint;
            this.definePropertiesObjForClass = IR.objectlit(new Node[0]);
            this.definePropertiesObjForPrototype = IR.objectlit(new Node[0]);
            this.fullClassName = fullClassName;
            this.anonymous = anonymous;
            this.classNameNode = classNameNode;
            this.superClassNameNode = superClassNameNode;
        }

        static ClassDeclarationMetadata create(Node classNode, Node parent) {
            Node classNameNode = classNode.getFirstChild();
            Node superClassNameNode = classNameNode.getNext();
            if (NodeUtil.isClassDeclaration(classNode)) {
                return new ClassDeclarationMetadata(classNode, classNameNode.getString(), false, classNameNode, superClassNameNode);
            }
            if (parent.isAssign() && parent.getParent().isExprResult()) {
                String fullClassName = parent.getFirstChild().getQualifiedName();
                if (fullClassName == null) {
                    return null;
                }
                return new ClassDeclarationMetadata(parent.getParent(), fullClassName, true, classNameNode, superClassNameNode);
            }
            if (parent.isName()) {
                return new ClassDeclarationMetadata(parent.getParent(), parent.getString(), true, classNameNode, superClassNameNode);
            }
            return null;
        }

        void insertNodeAndAdvance(Node newNode) {
            this.insertionPoint.getParent().addChildAfter(newNode, this.insertionPoint);
            this.insertionPoint = newNode;
        }

        boolean hasSuperClass() {
            return !this.superClassNameNode.isEmpty();
        }
    }

    private class CheckClassAssignments
    extends NodeTraversal.AbstractPostOrderCallback {
        private Node className;

        public CheckClassAssignments(Node className) {
            this.className = className;
        }

        @Override
        public void visit(NodeTraversal t, Node n, Node parent) {
            if (!n.isAssign() || n.getFirstChild() == this.className) {
                return;
            }
            if (this.className.matchesQualifiedName(n.getFirstChild())) {
                Es6ToEs3Converter.this.compiler.report(JSError.make(n, CLASS_REASSIGNMENT, new String[0]));
            }
        }
    }
}

