/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.CompilerPass;
import com.google.javascript.jscomp.GlobalNamespace;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.jscomp.Var;
import com.google.javascript.rhino.JSDocInfo;
import com.google.javascript.rhino.Node;
import java.util.LinkedHashMap;
import java.util.Map;

final class InlineAliases
extends NodeTraversal.AbstractPostOrderCallback
implements CompilerPass {
    private final AbstractCompiler compiler;
    private final Map<String, String> aliases = new LinkedHashMap<String, String>();
    private GlobalNamespace namespace;
    private final NodeUtil.Visitor fixJsdocTypeNodes = new NodeUtil.Visitor(){

        @Override
        public void visit(Node aliasReference) {
            if (!aliasReference.isString()) {
                return;
            }
            String fullTypeName = aliasReference.getString();
            int dotIndex = 0;
            do {
                String aliasName;
                String string = aliasName = (dotIndex = fullTypeName.indexOf(46, dotIndex + 1)) == -1 ? fullTypeName : fullTypeName.substring(0, dotIndex);
                if (!InlineAliases.this.aliases.containsKey(aliasName)) continue;
                String replacement = (String)InlineAliases.this.aliases.get(aliasName) + fullTypeName.substring(aliasName.length());
                aliasReference.setString(replacement);
                return;
            } while (dotIndex != -1);
        }
    };

    InlineAliases(AbstractCompiler compiler) {
        this.compiler = compiler;
    }

    @Override
    public void process(Node externs, Node root) {
        this.namespace = new GlobalNamespace(this.compiler, root);
        NodeTraversal.traverseEs6(this.compiler, root, this);
    }

    private void visitAliasDefinition(Node lhs, JSDocInfo info) {
        Node rhs;
        if (info != null && info.hasConstAnnotation() && lhs.isQualifiedName() && (rhs = NodeUtil.getRValueOfLValue(lhs)) != null && rhs.isQualifiedName()) {
            GlobalNamespace.Name lhsName = this.namespace.getOwnSlot(lhs.getQualifiedName());
            GlobalNamespace.Name rhsName = this.namespace.getOwnSlot(rhs.getQualifiedName());
            if (lhsName != null && lhsName.isInlinableGlobalAlias() && rhsName != null && rhsName.isInlinableGlobalAlias() && !this.isPrivate(rhsName.getDeclaration().getNode())) {
                this.aliases.put(lhs.getQualifiedName(), rhs.getQualifiedName());
            }
        }
    }

    private boolean isPrivate(Node nameNode) {
        if (nameNode.isQualifiedName() && this.compiler.getCodingConvention().isPrivate(nameNode.getQualifiedName())) {
            return true;
        }
        JSDocInfo info = NodeUtil.getBestJSDocInfo(nameNode);
        return info != null && info.getVisibility().equals((Object)JSDocInfo.Visibility.PRIVATE);
    }

    @Override
    public void visit(NodeTraversal t, Node n, Node parent) {
        switch (n.getType()) {
            case 118: {
                if (n.getChildCount() != 1 || !t.inGlobalScope()) break;
                this.visitAliasDefinition(n.getFirstChild(), n.getFirstChild().getJSDocInfo());
                break;
            }
            case 86: {
                if (parent == null || !parent.isExprResult() || !t.inGlobalScope()) break;
                this.visitAliasDefinition(n.getFirstChild(), n.getJSDocInfo());
                break;
            }
            case 33: 
            case 38: {
                if (!n.isQualifiedName() || !this.aliases.containsKey(n.getQualifiedName())) break;
                String leftmostName = NodeUtil.getRootOfQualifiedName(n).getString();
                Var v = t.getScope().getVar(leftmostName);
                if (v != null && v.isLocal()) {
                    return;
                }
                Preconditions.checkState((!NodeUtil.isVarOrSimpleAssignLhs(n, parent) ? 1 : 0) != 0);
                parent.replaceChild(n, NodeUtil.newQName(this.compiler, this.aliases.get(n.getQualifiedName())).copyInformationFromForTree(n));
                this.compiler.reportCodeChange();
            }
        }
        this.maybeRewriteJsdoc(n.getJSDocInfo());
    }

    private void maybeRewriteJsdoc(JSDocInfo info) {
        if (info == null) {
            return;
        }
        for (Node typeNode : info.getTypeNodes()) {
            NodeUtil.visitPreOrder(typeNode, this.fixJsdocTypeNodes, (Predicate<Node>)Predicates.alwaysTrue());
        }
    }
}

