/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.collect.ImmutableList;
import com.google.javascript.jscomp.CheckLevel;
import com.google.javascript.jscomp.Compiler;
import com.google.javascript.jscomp.CompilerOptions;
import com.google.javascript.jscomp.DiagnosticGroups;
import com.google.javascript.jscomp.GoogleCodingConvention;
import com.google.javascript.jscomp.LintPassConfig;
import com.google.javascript.jscomp.SourceFile;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;

public class Linter {
    public static void main(String[] args) throws IOException {
        for (String filename : args) {
            Linter.lint(filename);
        }
    }

    private static void lint(String filename) throws IOException {
        Linter.lint(Paths.get(filename, new String[0]));
    }

    private static void lint(Path path) throws IOException {
        SourceFile file = SourceFile.fromFile(path.toString());
        Compiler compiler = new Compiler();
        CompilerOptions options = new CompilerOptions();
        options.setLanguageIn(CompilerOptions.LanguageMode.ECMASCRIPT6);
        options.setCodingConvention(new GoogleCodingConvention());
        options.setWarningLevel(DiagnosticGroups.MISSING_REQUIRE, CheckLevel.WARNING);
        options.setWarningLevel(DiagnosticGroups.EXTRA_REQUIRE, CheckLevel.WARNING);
        compiler.setPassConfig(new LintPassConfig(options));
        compiler.disableThreads();
        compiler.compile(ImmutableList.of(), ImmutableList.of((Object)file), options);
    }
}

