/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp.lint;

import com.google.common.collect.Ordering;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.DiagnosticType;
import com.google.javascript.jscomp.HotSwapCompilerPass;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.rhino.Node;
import java.util.ArrayList;
import java.util.List;

public final class CheckRequiresAndProvidesSorted
extends NodeTraversal.AbstractShallowCallback
implements HotSwapCompilerPass {
    public static final DiagnosticType REQUIRES_NOT_SORTED = DiagnosticType.warning("JSC_REQUIRES_NOT_SORTED", "goog.require() statements are not sorted.");
    public static final DiagnosticType PROVIDES_NOT_SORTED = DiagnosticType.warning("JSC_PROVIDES_NOT_SORTED", "goog.provide() statements are not sorted.");
    public static final DiagnosticType PROVIDES_AFTER_REQUIRES = DiagnosticType.warning("JSC_PROVIDES_AFTER_REQUIRES", "goog.provide() statements should be before goog.require() statements.");
    public static final DiagnosticType MULTIPLE_MODULES_IN_FILE = DiagnosticType.warning("JSC_MULTIPLE_MODULES_IN_FILE", "There should only be a single goog.module() statement per file.");
    public static final DiagnosticType MODULE_AND_PROVIDES = DiagnosticType.warning("JSC_MODULE_AND_PROVIDES", "A file using goog.module() may not also use goog.provide() statements.");
    private List<String> requiredNamespaces;
    private List<String> providedNamespaces;
    private List<String> moduleNamespaces;
    private final AbstractCompiler compiler;

    public CheckRequiresAndProvidesSorted(AbstractCompiler compiler) {
        this.compiler = compiler;
        this.requiredNamespaces = new ArrayList<String>();
        this.providedNamespaces = new ArrayList<String>();
        this.moduleNamespaces = new ArrayList<String>();
    }

    @Override
    public void process(Node externs, Node root) {
        NodeTraversal.traverseEs6(this.compiler, root, this);
    }

    @Override
    public void hotSwapScript(Node scriptRoot, Node originalRoot) {
        NodeTraversal.traverseEs6(this.compiler, scriptRoot, this);
    }

    @Override
    public void visit(NodeTraversal t, Node n, Node parent) {
        switch (n.getType()) {
            case 132: {
                if (!Ordering.natural().isOrdered(this.requiredNamespaces)) {
                    t.report(n, REQUIRES_NOT_SORTED, new String[0]);
                }
                if (!Ordering.natural().isOrdered(this.providedNamespaces)) {
                    t.report(n, PROVIDES_NOT_SORTED, new String[0]);
                }
                if (!this.moduleNamespaces.isEmpty() && !this.providedNamespaces.isEmpty()) {
                    t.report(n, MODULE_AND_PROVIDES, new String[0]);
                }
                if (this.moduleNamespaces.size() > 1) {
                    t.report(n, MULTIPLE_MODULES_IN_FILE, new String[0]);
                }
                this.requiredNamespaces.clear();
                this.providedNamespaces.clear();
                this.moduleNamespaces.clear();
                break;
            }
            case 37: {
                String prov;
                if (!parent.isExprResult() || !parent.getParent().isScript()) break;
                String req = this.compiler.getCodingConvention().extractClassNameIfRequire(n, parent);
                if (req != null) {
                    this.requiredNamespaces.add(req);
                }
                if ((prov = this.compiler.getCodingConvention().extractClassNameIfProvide(n, parent)) == null) break;
                if (!this.requiredNamespaces.isEmpty()) {
                    t.report(n, PROVIDES_AFTER_REQUIRES, new String[0]);
                }
                if (n.getFirstChild().matchesQualifiedName("goog.module")) {
                    this.moduleNamespaces.add(prov);
                    break;
                }
                this.providedNamespaces.add(prov);
            }
        }
    }
}

