/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.base.Preconditions;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.DiagnosticType;
import com.google.javascript.jscomp.HotSwapCompilerPass;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.rhino.JSDocInfo;
import com.google.javascript.rhino.Node;
import com.google.javascript.rhino.TypeI;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

class CheckUnusedPrivateProperties
implements HotSwapCompilerPass,
NodeTraversal.Callback {
    static final DiagnosticType UNUSED_PRIVATE_PROPERTY = DiagnosticType.disabled("JSC_UNUSED_PRIVATE_PROPERTY", "Private property {0} is never read");
    private final AbstractCompiler compiler;
    private Set<String> used = new HashSet<String>();
    private List<Node> candidates = new ArrayList<Node>();

    CheckUnusedPrivateProperties(AbstractCompiler compiler) {
        this.compiler = compiler;
    }

    @Override
    public void process(Node externs, Node root) {
        NodeTraversal.traverseEs6(this.compiler, root, this);
    }

    @Override
    public void hotSwapScript(Node scriptRoot, Node originalRoot) {
        NodeTraversal.traverseEs6(this.compiler, scriptRoot, this);
    }

    private void reportUnused(NodeTraversal t) {
        for (Node n : this.candidates) {
            String propName = this.getPropName(n);
            if (this.used.contains(propName)) continue;
            t.report(n, UNUSED_PRIVATE_PROPERTY, new String[0]);
        }
    }

    private String getPropName(Node n) {
        switch (n.getType()) {
            case 33: {
                return n.getLastChild().getString();
            }
            case 160: {
                return n.getString();
            }
        }
        throw new RuntimeException("Unexpected node type: " + n);
    }

    @Override
    public boolean shouldTraverse(NodeTraversal t, Node n, Node parent) {
        if (n.isScript()) {
            this.used.clear();
            this.candidates.clear();
        }
        return true;
    }

    @Override
    public void visit(NodeTraversal t, Node n, Node parent) {
        switch (n.getType()) {
            case 132: {
                this.reportUnused(t);
                break;
            }
            case 33: {
                String propName = n.getLastChild().getString();
                if (this.compiler.getCodingConvention().isExported(propName) || CheckUnusedPrivateProperties.isPinningPropertyUse(n) || !this.isCandidatePropertyDefinition(n)) {
                    this.used.add(propName);
                    break;
                }
                if (!this.isPrivatePropDecl(n)) break;
                this.candidates.add(n);
                break;
            }
            case 160: {
                if (!this.isPrivatePropDecl(n)) break;
                this.candidates.add(n);
                break;
            }
            case 64: {
                for (Node c : n.children()) {
                    this.used.add(c.getString());
                }
                break;
            }
            case 37: {
                Node propName;
                Node target = n.getFirstChild();
                if (!n.hasMoreThanOneChild() || !target.isName() || !target.getString().equals("JSCompiler_renameProperty") || !(propName = target.getNext()).isString()) break;
                this.used.add(propName.getString());
            }
        }
    }

    private boolean isPrivatePropDecl(Node n) {
        JSDocInfo info = NodeUtil.getBestJSDocInfo(n);
        return info != null && info.getVisibility() == JSDocInfo.Visibility.PRIVATE;
    }

    private boolean isCandidatePropertyDefinition(Node n) {
        Preconditions.checkState((boolean)n.isGetProp());
        Node target = n.getFirstChild();
        return target.isThis() || this.isConstructor(target) || target.isGetProp() && target.getLastChild().getString().equals("prototype");
    }

    private boolean isConstructor(Node n) {
        TypeI type = n.getTypeI();
        return type != null && (type.isConstructor() || type.isInterface());
    }

    private static boolean isPinningPropertyUse(Node n) {
        Node parent = n.getParent();
        if (n == parent.getFirstChild()) {
            if (parent.isExprResult()) {
                return false;
            }
            if (parent.isAssign()) {
                return false;
            }
            if (NodeUtil.isAssignmentOp(parent) || parent.isInc() || parent.isDec()) {
                return NodeUtil.isExpressionResultUsed(parent);
            }
        }
        return true;
    }
}

