/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.base.Preconditions;
import com.google.javascript.jscomp.AbstractPeepholeOptimization;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.rhino.IR;
import com.google.javascript.rhino.Node;

final class PeepholeCollectPropertyAssignments
extends AbstractPeepholeOptimization {
    PeepholeCollectPropertyAssignments() {
    }

    @Override
    Node optimizeSubtree(Node subtree) {
        if (!subtree.isScript() && !subtree.isBlock()) {
            return subtree;
        }
        boolean codeChanged = false;
        for (Node child = subtree.getFirstChild(); child != null; child = child.getNext()) {
            Node propertyCandidate;
            Node value;
            if (!child.isVar() && !NodeUtil.isExprAssign(child) || !PeepholeCollectPropertyAssignments.isPropertyAssignmentToName(child.getNext())) continue;
            Preconditions.checkState((boolean)child.hasOneChild());
            Node name = PeepholeCollectPropertyAssignments.getName(child);
            if (!name.isName() || (value = PeepholeCollectPropertyAssignments.getValue(child)) == null || !PeepholeCollectPropertyAssignments.isInterestingValue(value)) continue;
            while ((propertyCandidate = child.getNext()) != null && this.collectProperty(propertyCandidate, name.getString(), value)) {
                codeChanged = true;
            }
        }
        if (codeChanged) {
            this.reportCodeChange();
        }
        return subtree;
    }

    private static Node getName(Node n) {
        if (n.isVar()) {
            return n.getFirstChild();
        }
        if (NodeUtil.isExprAssign(n)) {
            return n.getFirstChild().getFirstChild();
        }
        throw new IllegalStateException();
    }

    private static Node getValue(Node n) {
        if (n.isVar()) {
            return n.getFirstChild().getFirstChild();
        }
        if (NodeUtil.isExprAssign(n)) {
            return n.getFirstChild().getLastChild();
        }
        throw new IllegalStateException();
    }

    static boolean isInterestingValue(Node n) {
        return n.isObjectLit() || n.isArrayLit();
    }

    private static boolean isPropertyAssignmentToName(Node propertyCandidate) {
        if (propertyCandidate == null) {
            return false;
        }
        if (!NodeUtil.isExprAssign(propertyCandidate)) {
            return false;
        }
        Node expr = propertyCandidate.getFirstChild();
        Node lhs = expr.getFirstChild();
        if (!NodeUtil.isGet(lhs)) {
            return false;
        }
        Node obj = lhs.getFirstChild();
        return obj.isName();
    }

    private boolean collectProperty(Node propertyCandidate, String name, Node value) {
        if (!PeepholeCollectPropertyAssignments.isPropertyAssignmentToName(propertyCandidate)) {
            return false;
        }
        Node lhs = propertyCandidate.getFirstChild().getFirstChild();
        if (!name.equals(lhs.getFirstChild().getString())) {
            return false;
        }
        Node rhs = lhs.getNext();
        if (this.mayHaveSideEffects(rhs) || NodeUtil.canBeSideEffected(rhs)) {
            return false;
        }
        if (!NodeUtil.isLiteralValue(rhs, true) && PeepholeCollectPropertyAssignments.mightContainForwardReference(rhs, name)) {
            return false;
        }
        switch (value.getType()) {
            case 63: {
                if (PeepholeCollectPropertyAssignments.collectArrayProperty(value, propertyCandidate)) break;
                return false;
            }
            case 64: {
                if (PeepholeCollectPropertyAssignments.collectObjectProperty(value, propertyCandidate)) break;
                return false;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        return true;
    }

    private static boolean collectArrayProperty(Node arrayLiteral, Node propertyCandidate) {
        int maxIndexAssigned;
        Node assignment = propertyCandidate.getFirstChild();
        int sizeOfArrayAtStart = arrayLiteral.getChildCount();
        Node lhs = assignment.getFirstChild();
        Node rhs = lhs.getNext();
        if (!lhs.isGetElem()) {
            return false;
        }
        Node obj = lhs.getFirstChild();
        Node property = obj.getNext();
        if (!property.isNumber()) {
            return false;
        }
        double dindex = property.getDouble();
        if (!(dindex >= 0.0) || Double.isInfinite(dindex) || dindex > 2.147483647E9) {
            return false;
        }
        int index = (int)dindex;
        if (dindex != (double)index) {
            return false;
        }
        if (maxIndexAssigned + 4 < index) {
            return false;
        }
        if (index > maxIndexAssigned) {
            for (maxIndexAssigned = sizeOfArrayAtStart - 1; maxIndexAssigned < index - 1; ++maxIndexAssigned) {
                Node emptyNode = IR.empty().srcref(arrayLiteral);
                arrayLiteral.addChildToBack(emptyNode);
            }
            arrayLiteral.addChildToBack(rhs.detachFromParent());
        } else {
            Node currentValue = arrayLiteral.getChildAtIndex(index);
            if (!currentValue.isEmpty()) {
                return false;
            }
            arrayLiteral.replaceChild(currentValue, rhs.detachFromParent());
        }
        propertyCandidate.detachFromParent();
        return true;
    }

    private static boolean collectObjectProperty(Node objectLiteral, Node propertyCandidate) {
        Node assignment = propertyCandidate.getFirstChild();
        Node lhs = assignment.getFirstChild();
        Node rhs = lhs.getNext();
        Node obj = lhs.getFirstChild();
        Node property = obj.getNext();
        if (lhs.isGetElem() && !property.isString() && !property.isNumber()) {
            return false;
        }
        String propertyName = property.isNumber() ? NodeUtil.getStringValue(property) : property.getString();
        Node newProperty = IR.stringKey(propertyName).useSourceInfoIfMissingFrom(property);
        if (lhs.isGetElem()) {
            newProperty.setQuotedString();
        }
        Node newValue = rhs.detachFromParent();
        newProperty.addChildToBack(newValue);
        boolean propertyExists = false;
        for (Node currentProperty : objectLiteral.children()) {
            String currentPropertyName = currentProperty.getString();
            Node currentValue = currentProperty.getFirstChild();
            if (!currentPropertyName.equals(propertyName)) continue;
            propertyExists = true;
            boolean isCurrentValueSideEffect = NodeUtil.canBeSideEffected(currentValue);
            boolean isNewValueSideEffect = NodeUtil.canBeSideEffected(newValue);
            if (isCurrentValueSideEffect || isNewValueSideEffect) break;
            objectLiteral.removeChild(currentProperty);
            objectLiteral.addChildToBack(newProperty);
            propertyCandidate.detachFromParent();
            return true;
        }
        if (!propertyExists) {
            objectLiteral.addChildToBack(newProperty);
        }
        propertyCandidate.detachFromParent();
        return true;
    }

    private static boolean mightContainForwardReference(Node node, String varName) {
        if (node.isName()) {
            return varName.equals(node.getString());
        }
        for (Node child = node.getFirstChild(); child != null; child = child.getNext()) {
            if (!PeepholeCollectPropertyAssignments.mightContainForwardReference(child, varName)) continue;
            return true;
        }
        return false;
    }
}

