/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.base.Preconditions;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Multimap;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.AccessControlUtils;
import com.google.javascript.jscomp.CodingConvention;
import com.google.javascript.jscomp.CollectFileOverviewVisibility;
import com.google.javascript.jscomp.DiagnosticType;
import com.google.javascript.jscomp.HotSwapCompilerPass;
import com.google.javascript.jscomp.JSError;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.jscomp.Var;
import com.google.javascript.rhino.JSDocInfo;
import com.google.javascript.rhino.Node;
import com.google.javascript.rhino.StaticSourceFile;
import com.google.javascript.rhino.jstype.FunctionType;
import com.google.javascript.rhino.jstype.JSType;
import com.google.javascript.rhino.jstype.JSTypeNative;
import com.google.javascript.rhino.jstype.JSTypeRegistry;
import com.google.javascript.rhino.jstype.ObjectType;
import java.util.ArrayDeque;
import javax.annotation.Nullable;

class CheckAccessControls
extends NodeTraversal.AbstractPostOrderCallback
implements NodeTraversal.ScopedCallback,
HotSwapCompilerPass {
    static final DiagnosticType DEPRECATED_NAME = DiagnosticType.disabled("JSC_DEPRECATED_VAR", "Variable {0} has been deprecated.");
    static final DiagnosticType DEPRECATED_NAME_REASON = DiagnosticType.disabled("JSC_DEPRECATED_VAR_REASON", "Variable {0} has been deprecated: {1}");
    static final DiagnosticType DEPRECATED_PROP = DiagnosticType.disabled("JSC_DEPRECATED_PROP", "Property {0} of type {1} has been deprecated.");
    static final DiagnosticType DEPRECATED_PROP_REASON = DiagnosticType.disabled("JSC_DEPRECATED_PROP_REASON", "Property {0} of type {1} has been deprecated: {2}");
    static final DiagnosticType DEPRECATED_CLASS = DiagnosticType.disabled("JSC_DEPRECATED_CLASS", "Class {0} has been deprecated.");
    static final DiagnosticType DEPRECATED_CLASS_REASON = DiagnosticType.disabled("JSC_DEPRECATED_CLASS_REASON", "Class {0} has been deprecated: {1}");
    static final DiagnosticType BAD_PACKAGE_PROPERTY_ACCESS = DiagnosticType.error("JSC_BAD_PACKAGE_PROPERTY_ACCESS", "Access to package-private property {0} of {1} not allowed here.");
    static final DiagnosticType BAD_PRIVATE_GLOBAL_ACCESS = DiagnosticType.error("JSC_BAD_PRIVATE_GLOBAL_ACCESS", "Access to private variable {0} not allowed outside file {1}.");
    static final DiagnosticType BAD_PRIVATE_PROPERTY_ACCESS = DiagnosticType.warning("JSC_BAD_PRIVATE_PROPERTY_ACCESS", "Access to private property {0} of {1} not allowed here.");
    static final DiagnosticType BAD_PROTECTED_PROPERTY_ACCESS = DiagnosticType.warning("JSC_BAD_PROTECTED_PROPERTY_ACCESS", "Access to protected property {0} of {1} not allowed here.");
    static final DiagnosticType BAD_PROPERTY_OVERRIDE_IN_FILE_WITH_FILEOVERVIEW_VISIBILITY = DiagnosticType.error("JSC_BAD_PROPERTY_OVERRIDE_IN_FILE_WITH_FILEOVERVIEW_VISIBILITY", "Overridden property {0} in file with fileoverview visibility {1} must explicitly redeclare superclass visibility");
    static final DiagnosticType PRIVATE_OVERRIDE = DiagnosticType.warning("JSC_PRIVATE_OVERRIDE", "Overriding private property of {0}.");
    static final DiagnosticType EXTEND_FINAL_CLASS = DiagnosticType.error("JSC_EXTEND_FINAL_CLASS", "{0} is not allowed to extend final class {1}.");
    static final DiagnosticType VISIBILITY_MISMATCH = DiagnosticType.warning("JSC_VISIBILITY_MISMATCH", "Overriding {0} property of {1} with {2} property.");
    static final DiagnosticType CONST_PROPERTY_REASSIGNED_VALUE = DiagnosticType.warning("JSC_CONSTANT_PROPERTY_REASSIGNED_VALUE", "constant property {0} assigned a value more than once");
    static final DiagnosticType CONST_PROPERTY_DELETED = DiagnosticType.warning("JSC_CONSTANT_PROPERTY_DELETED", "constant property {0} cannot be deleted");
    static final DiagnosticType CONVENTION_MISMATCH = DiagnosticType.warning("JSC_CONVENTION_MISMATCH", "Declared access conflicts with access convention.");
    private final AbstractCompiler compiler;
    private final JSTypeRegistry typeRegistry;
    private final boolean enforceCodingConventions;
    private int deprecatedDepth = 0;
    private final ArrayDeque<JSType> currentClassStack = new ArrayDeque();
    private final JSType noTypeSentinel;
    private ImmutableMap<StaticSourceFile, JSDocInfo.Visibility> defaultVisibilityForFiles;
    private final Multimap<JSType, String> initializedConstantProperties;

    CheckAccessControls(AbstractCompiler compiler, boolean enforceCodingConventions) {
        this.compiler = compiler;
        this.typeRegistry = compiler.getTypeRegistry();
        this.initializedConstantProperties = HashMultimap.create();
        this.enforceCodingConventions = enforceCodingConventions;
        this.noTypeSentinel = this.typeRegistry.getNativeType(JSTypeNative.NO_TYPE);
    }

    @Override
    public void process(Node externs, Node root) {
        CollectFileOverviewVisibility collectPass = new CollectFileOverviewVisibility(this.compiler);
        collectPass.process(externs, root);
        this.defaultVisibilityForFiles = collectPass.getFileOverviewVisibilityMap();
        NodeTraversal.traverse(this.compiler, externs, this);
        NodeTraversal.traverse(this.compiler, root, this);
    }

    @Override
    public void hotSwapScript(Node scriptRoot, Node originalRoot) {
        CollectFileOverviewVisibility collectPass = new CollectFileOverviewVisibility(this.compiler);
        collectPass.hotSwapScript(scriptRoot, originalRoot);
        this.defaultVisibilityForFiles = collectPass.getFileOverviewVisibilityMap();
        NodeTraversal.traverse(this.compiler, scriptRoot, this);
    }

    @Override
    public void enterScope(NodeTraversal t) {
        Node n = t.getScopeRoot();
        if (n.isFunction()) {
            JSType prevClass;
            Node parent = n.getParent();
            if (CheckAccessControls.isDeprecatedFunction(n)) {
                ++this.deprecatedDepth;
            }
            JSType currentClass = (prevClass = this.getCurrentClass()) == null ? this.getClassOfMethod(n, parent) : prevClass;
            this.currentClassStack.addFirst(currentClass == null ? this.noTypeSentinel : currentClass);
        }
    }

    @Override
    public void exitScope(NodeTraversal t) {
        Node n = t.getScopeRoot();
        if (n.isFunction()) {
            if (CheckAccessControls.isDeprecatedFunction(n)) {
                --this.deprecatedDepth;
            }
            this.currentClassStack.pop();
        }
    }

    private JSType getClassOfMethod(Node n, Node parent) {
        Preconditions.checkState(n.isFunction(), n);
        if (parent.isAssign()) {
            Node lValue = parent.getFirstChild();
            if (NodeUtil.isGet(lValue)) {
                JSType lValueType = lValue.getJSType();
                if (lValueType != null && (lValueType.isConstructor() || lValueType.isInterface())) {
                    return lValueType.toMaybeFunctionType().getInstanceType();
                }
                if (NodeUtil.isPrototypeProperty(lValue)) {
                    return CheckAccessControls.normalizeClassType(NodeUtil.getPrototypeClassName(lValue).getJSType());
                }
                return CheckAccessControls.normalizeClassType(lValue.getFirstChild().getJSType());
            }
            return CheckAccessControls.normalizeClassType(lValue.getJSType());
        }
        if (NodeUtil.isFunctionDeclaration(n) || parent.isName()) {
            return CheckAccessControls.normalizeClassType(n.getJSType());
        }
        if (parent.isStringKey() || parent.isGetterDef() || parent.isSetterDef() || parent.isMemberFunctionDef() || parent.isComputedProp()) {
            Node objectLitParent = parent.getGrandparent();
            if (!objectLitParent.isAssign()) {
                return null;
            }
            Node className = NodeUtil.getPrototypeClassName(objectLitParent.getFirstChild());
            if (className != null) {
                return CheckAccessControls.normalizeClassType(className.getJSType());
            }
        }
        return null;
    }

    private static JSType normalizeClassType(JSType type) {
        if (type == null || type.isUnknownType()) {
            return type;
        }
        if (type.isConstructor() || type.isInterface()) {
            return type.toMaybeFunctionType().getInstanceType();
        }
        if (type.isFunctionPrototypeType()) {
            return CheckAccessControls.normalizePrototypeObject(type.toMaybeObjectType());
        }
        return type;
    }

    private static ObjectType normalizePrototypeObject(ObjectType type) {
        FunctionType owner = type.getOwnerFunction();
        if (owner.hasInstanceType()) {
            return owner.getInstanceType();
        }
        return type;
    }

    @Override
    public void visit(NodeTraversal t, Node n, Node parent) {
        switch (n.getToken()) {
            case NAME: {
                this.checkNameDeprecation(t, n, parent);
                this.checkNameVisibility(t, n, parent);
                break;
            }
            case GETPROP: {
                this.checkPropertyDeprecation(t, n, parent);
                this.checkPropertyVisibility(t, n, parent);
                this.checkConstantProperty(t, n);
                break;
            }
            case STRING_KEY: 
            case GETTER_DEF: 
            case SETTER_DEF: 
            case MEMBER_FUNCTION_DEF: {
                this.checkKeyVisibilityConvention(t, n, parent);
                break;
            }
            case NEW: {
                this.checkConstructorDeprecation(t, n, parent);
                break;
            }
            case FUNCTION: {
                this.checkFinalClassOverrides(t, n, parent);
                break;
            }
        }
    }

    private void checkConstructorDeprecation(NodeTraversal t, Node n, Node parent) {
        String deprecationInfo;
        JSType type = n.getJSType();
        if (type != null && (deprecationInfo = CheckAccessControls.getTypeDeprecationInfo(type)) != null && this.shouldEmitDeprecationWarning(t, n, parent)) {
            if (!deprecationInfo.isEmpty()) {
                this.compiler.report(t.makeError(n, DEPRECATED_CLASS_REASON, type.toString(), deprecationInfo));
            } else {
                this.compiler.report(t.makeError(n, DEPRECATED_CLASS, type.toString()));
            }
        }
    }

    private void checkNameDeprecation(NodeTraversal t, Node n, Node parent) {
        JSDocInfo docInfo;
        if (parent.isFunction() || NodeUtil.isNameDeclaration(parent) || parent.isNew()) {
            return;
        }
        Var var = (Var)t.getScope().getVar(n.getString());
        JSDocInfo jSDocInfo = docInfo = var == null ? null : var.getJSDocInfo();
        if (docInfo != null && docInfo.isDeprecated() && this.shouldEmitDeprecationWarning(t, n, parent)) {
            if (docInfo.getDeprecationReason() != null) {
                this.compiler.report(t.makeError(n, DEPRECATED_NAME_REASON, n.getString(), docInfo.getDeprecationReason()));
            } else {
                this.compiler.report(t.makeError(n, DEPRECATED_NAME, n.getString()));
            }
        }
    }

    private void checkPropertyDeprecation(NodeTraversal t, Node n, Node parent) {
        String deprecationInfo;
        if (parent.isNew()) {
            return;
        }
        ObjectType objectType = CheckAccessControls.castToObject(CheckAccessControls.dereference(n.getFirstChild().getJSType()));
        String propertyName = n.getLastChild().getString();
        if (objectType != null && (deprecationInfo = CheckAccessControls.getPropertyDeprecationInfo(objectType, propertyName)) != null && this.shouldEmitDeprecationWarning(t, n, parent)) {
            if (!deprecationInfo.isEmpty()) {
                this.compiler.report(t.makeError(n, DEPRECATED_PROP_REASON, propertyName, this.typeRegistry.getReadableTypeName(n.getFirstChild()), deprecationInfo));
            } else {
                this.compiler.report(t.makeError(n, DEPRECATED_PROP, propertyName, this.typeRegistry.getReadableTypeName(n.getFirstChild())));
            }
        }
    }

    private boolean isPrivateByConvention(String name) {
        return this.enforceCodingConventions && this.compiler.getCodingConvention().isPrivate(name);
    }

    private void checkKeyVisibilityConvention(NodeTraversal t, Node key, Node parent) {
        JSDocInfo info = key.getJSDocInfo();
        if (info == null) {
            return;
        }
        if (!this.isPrivateByConvention(key.getString())) {
            return;
        }
        Node assign = parent.getParent();
        if (assign == null || !assign.isAssign()) {
            return;
        }
        Node left = assign.getFirstChild();
        if (!left.isGetProp() || !left.getLastChild().getString().equals("prototype")) {
            return;
        }
        JSDocInfo.Visibility declaredVisibility = info.getVisibility();
        if (declaredVisibility != JSDocInfo.Visibility.INHERITED && declaredVisibility != JSDocInfo.Visibility.PRIVATE) {
            this.compiler.report(t.makeError(key, CONVENTION_MISMATCH, new String[0]));
        }
    }

    private void checkNameVisibility(NodeTraversal t, Node name, Node parent) {
        Var var = (Var)t.getScope().getVar(name.getString());
        if (var == null) {
            return;
        }
        JSDocInfo.Visibility v = this.checkPrivateNameConvention(AccessControlUtils.getEffectiveNameVisibility(name, var, this.defaultVisibilityForFiles), name);
        switch (v) {
            case PACKAGE: {
                if (this.isPackageAccessAllowed(var, name)) break;
                this.compiler.report(t.makeError(name, BAD_PACKAGE_PROPERTY_ACCESS, name.getString(), var.getSourceFile().getName()));
                break;
            }
            case PRIVATE: {
                if (CheckAccessControls.isPrivateAccessAllowed(var, name, parent)) break;
                this.compiler.report(t.makeError(name, BAD_PRIVATE_GLOBAL_ACCESS, name.getString(), var.getSourceFile().getName()));
                break;
            }
        }
    }

    private JSDocInfo.Visibility checkPrivateNameConvention(JSDocInfo.Visibility v, Node name) {
        if (this.isPrivateByConvention(name.getString())) {
            if (v != JSDocInfo.Visibility.PRIVATE && v != JSDocInfo.Visibility.INHERITED) {
                this.compiler.report(JSError.make(name, CONVENTION_MISMATCH, new String[0]));
            }
            return JSDocInfo.Visibility.PRIVATE;
        }
        return v;
    }

    private static boolean isPrivateAccessAllowed(Var var, Node name, Node parent) {
        StaticSourceFile varSrc = var.getSourceFile();
        StaticSourceFile refSrc = name.getStaticSourceFile();
        JSDocInfo docInfo = var.getJSDocInfo();
        if (varSrc != null && refSrc != null && !varSrc.getName().equals(refSrc.getName())) {
            return docInfo != null && docInfo.isConstructor() && CheckAccessControls.isValidPrivateConstructorAccess(parent);
        }
        return true;
    }

    private boolean isPackageAccessAllowed(Var var, Node name) {
        StaticSourceFile varSrc = var.getSourceFile();
        StaticSourceFile refSrc = name.getStaticSourceFile();
        CodingConvention codingConvention = this.compiler.getCodingConvention();
        if (varSrc != null && refSrc != null) {
            String srcPackage = codingConvention.getPackageName(varSrc);
            String refPackage = codingConvention.getPackageName(refSrc);
            return srcPackage != null && refPackage != null && srcPackage.equals(refPackage);
        }
        return false;
    }

    private void checkOverriddenPropertyVisibilityMismatch(JSDocInfo.Visibility overriding, JSDocInfo.Visibility overridden, @Nullable JSDocInfo.Visibility fileOverview, NodeTraversal t, Node getprop) {
        if (overriding == JSDocInfo.Visibility.INHERITED && overriding != overridden && fileOverview != null && fileOverview != JSDocInfo.Visibility.INHERITED) {
            String propertyName = getprop.getLastChild().getString();
            this.compiler.report(t.makeError(getprop, BAD_PROPERTY_OVERRIDE_IN_FILE_WITH_FILEOVERVIEW_VISIBILITY, propertyName, fileOverview.name()));
        }
    }

    @Nullable
    private static JSDocInfo.Visibility getOverridingPropertyVisibility(Node parent) {
        JSDocInfo overridingInfo = parent.getJSDocInfo();
        return overridingInfo == null || !overridingInfo.isOverride() ? null : overridingInfo.getVisibility();
    }

    private void checkFinalClassOverrides(NodeTraversal t, Node fn, Node parent) {
        ObjectType finalParentClass;
        Preconditions.checkState(fn.isFunction(), fn);
        FunctionType type = fn.getJSType().toMaybeFunctionType();
        if (type != null && ((JSType)type).isConstructor() && (finalParentClass = CheckAccessControls.getSuperClassInstanceIfFinal(this.getClassOfMethod(fn, parent))) != null) {
            this.compiler.report(t.makeError(fn, EXTEND_FINAL_CLASS, ((JSType)type).getDisplayName(), ((JSType)finalParentClass).getDisplayName()));
        }
    }

    private void checkConstantProperty(NodeTraversal t, Node getprop) {
        String propertyName;
        Node parent = getprop.getParent();
        boolean isDelete = parent.isDelProp();
        if (!(NodeUtil.isAssignmentOp(parent) && parent.getFirstChild() == getprop || parent.isInc() || parent.isDec() || isDelete)) {
            return;
        }
        ObjectType objectType = CheckAccessControls.castToObject(CheckAccessControls.dereference(getprop.getFirstChild().getJSType()));
        boolean isConstant = this.isPropertyDeclaredConstant(objectType, propertyName = getprop.getLastChild().getString());
        if (isConstant) {
            ObjectType prototype;
            JSDocInfo info = parent.getJSDocInfo();
            if (info != null && info.getSuppressions().contains("const")) {
                return;
            }
            if (isDelete) {
                this.compiler.report(t.makeError(getprop, CONST_PROPERTY_DELETED, propertyName));
                return;
            }
            if (objectType == null || objectType.isFunctionType() && !objectType.toMaybeFunctionType().isConstructor()) {
                return;
            }
            for (ObjectType oType = objectType; oType != null; oType = oType.getPrototypeObject()) {
                if (!this.initializedConstantProperties.containsEntry(oType, propertyName) && !this.initializedConstantProperties.containsEntry(CheckAccessControls.getCanonicalInstance(oType), propertyName)) continue;
                this.compiler.report(t.makeError(getprop, CONST_PROPERTY_REASSIGNED_VALUE, propertyName));
                break;
            }
            this.initializedConstantProperties.put(objectType, propertyName);
            if (objectType.isInstanceType() && (prototype = objectType.getPrototypeObject()) != null && prototype.hasProperty(propertyName)) {
                this.initializedConstantProperties.put(prototype, propertyName);
            }
        }
    }

    static ObjectType getCanonicalInstance(ObjectType obj) {
        FunctionType ctor = obj.getConstructor();
        return ctor == null ? obj : ctor.getInstanceType();
    }

    private JSType typeOrUnknown(JSType type) {
        if (type == null) {
            return this.typeRegistry.getNativeType(JSTypeNative.UNKNOWN_TYPE);
        }
        return type;
    }

    private void checkPropertyVisibility(NodeTraversal t, Node getprop, Node parent) {
        JSDocInfo.Visibility overriding;
        JSDocInfo jsdoc = NodeUtil.getBestJSDocInfo(getprop);
        if (jsdoc != null && jsdoc.getSuppressions().contains("visibility")) {
            return;
        }
        JSType rawReferenceType = this.typeOrUnknown(getprop.getFirstChild().getJSType()).autobox();
        ObjectType referenceType = CheckAccessControls.castToObject(rawReferenceType);
        String propertyName = getprop.getLastChild().getString();
        boolean isPrivateByConvention = this.isPrivateByConvention(propertyName);
        if (isPrivateByConvention && CheckAccessControls.propertyIsDeclaredButNotPrivate(getprop, parent)) {
            this.compiler.report(t.makeError(getprop, CONVENTION_MISMATCH, new String[0]));
            return;
        }
        StaticSourceFile definingSource = AccessControlUtils.getDefiningSource(getprop, referenceType, propertyName);
        boolean isClassType = false;
        boolean isOverride = jsdoc != null && (parent.isExprResult() || parent.isAssign() && parent.getFirstChild() == getprop);
        ObjectType objectType = AccessControlUtils.getObjectType(referenceType, isOverride, propertyName);
        JSDocInfo.Visibility fileOverviewVisibility = this.defaultVisibilityForFiles.get(definingSource);
        JSDocInfo.Visibility visibility = AccessControlUtils.getEffectivePropertyVisibility(getprop, referenceType, this.defaultVisibilityForFiles, this.enforceCodingConventions ? this.compiler.getCodingConvention() : null);
        if (isOverride && (overriding = CheckAccessControls.getOverridingPropertyVisibility(parent)) != null) {
            this.checkOverriddenPropertyVisibilityMismatch(overriding, visibility, fileOverviewVisibility, t, getprop);
        }
        JSType reportType = rawReferenceType;
        if (objectType != null) {
            Node node = objectType.getOwnPropertyDefSite(propertyName);
            if (node == null) {
                return;
            }
            reportType = objectType;
            definingSource = node.getStaticSourceFile();
            isClassType = objectType.getOwnPropertyJSDocInfo(propertyName).isConstructor();
        } else if (!isPrivateByConvention && fileOverviewVisibility == null) {
            return;
        }
        StaticSourceFile referenceSource = getprop.getStaticSourceFile();
        if (isOverride) {
            boolean sameInput = referenceSource != null && referenceSource.getName().equals(definingSource.getName());
            this.checkOverriddenPropertyVisibility(t, getprop, parent, visibility, fileOverviewVisibility, reportType, sameInput);
        } else {
            this.checkNonOverriddenPropertyVisibility(t, getprop, parent, visibility, isClassType, reportType, referenceSource, definingSource);
        }
    }

    private static boolean propertyIsDeclaredButNotPrivate(Node getprop, Node parent) {
        JSDocInfo.Visibility declaredVisibility;
        JSDocInfo info = NodeUtil.getBestJSDocInfo(getprop);
        return (parent.isAssign() || parent.isExprResult()) && parent.getFirstChild() == getprop && info != null && (declaredVisibility = info.getVisibility()) != JSDocInfo.Visibility.PRIVATE && declaredVisibility != JSDocInfo.Visibility.INHERITED;
    }

    private void checkOverriddenPropertyVisibility(NodeTraversal t, Node getprop, Node parent, JSDocInfo.Visibility visibility, JSDocInfo.Visibility fileOverviewVisibility, JSType objectType, boolean sameInput) {
        JSDocInfo.Visibility overridingVisibility;
        JSDocInfo overridingInfo = parent.getJSDocInfo();
        JSDocInfo.Visibility visibility2 = overridingVisibility = overridingInfo == null ? JSDocInfo.Visibility.INHERITED : overridingInfo.getVisibility();
        if (visibility == JSDocInfo.Visibility.PRIVATE && !sameInput) {
            this.compiler.report(t.makeError(getprop, PRIVATE_OVERRIDE, objectType.toString()));
        } else if (overridingVisibility != JSDocInfo.Visibility.INHERITED && overridingVisibility != visibility && fileOverviewVisibility == null) {
            this.compiler.report(t.makeError(getprop, VISIBILITY_MISMATCH, visibility.name(), objectType.toString(), overridingVisibility.name()));
        }
    }

    private void checkNonOverriddenPropertyVisibility(NodeTraversal t, Node getprop, Node parent, JSDocInfo.Visibility visibility, boolean isClassType, JSType objectType, StaticSourceFile referenceSource, StaticSourceFile definingSource) {
        if (referenceSource != null && definingSource != null && referenceSource.getName().equals(definingSource.getName())) {
            return;
        }
        JSType ownerType = CheckAccessControls.normalizeClassType(objectType);
        switch (visibility) {
            case PACKAGE: {
                this.checkPackagePropertyVisibility(t, getprop, referenceSource, definingSource);
                break;
            }
            case PRIVATE: {
                this.checkPrivatePropertyVisibility(t, getprop, parent, isClassType, ownerType);
                break;
            }
            case PROTECTED: {
                this.checkProtectedPropertyVisibility(t, getprop, ownerType);
                break;
            }
        }
    }

    private void checkPackagePropertyVisibility(NodeTraversal t, Node getprop, StaticSourceFile referenceSource, StaticSourceFile definingSource) {
        CodingConvention codingConvention = this.compiler.getCodingConvention();
        String refPackage = codingConvention.getPackageName(referenceSource);
        String defPackage = codingConvention.getPackageName(definingSource);
        if (refPackage == null || defPackage == null || !refPackage.equals(defPackage)) {
            String propertyName = getprop.getLastChild().getString();
            this.compiler.report(t.makeError(getprop, BAD_PACKAGE_PROPERTY_ACCESS, propertyName, this.typeRegistry.getReadableTypeName(getprop.getFirstChild())));
        }
    }

    @Nullable
    private JSType getCurrentClass() {
        JSType cur = this.currentClassStack.peekFirst();
        return cur == this.noTypeSentinel ? null : cur;
    }

    private void checkPrivatePropertyVisibility(NodeTraversal t, Node getprop, Node parent, boolean isClassType, JSType ownerType) {
        if (isClassType && CheckAccessControls.isValidPrivateConstructorAccess(parent)) {
            return;
        }
        JSType accessedType = getprop.getFirstChild().getJSType();
        String propertyName = getprop.getLastChild().getString();
        String readableTypeName = ownerType.equals(accessedType) ? this.typeRegistry.getReadableTypeName(getprop.getFirstChild()) : ownerType.toString();
        this.compiler.report(t.makeError(getprop, BAD_PRIVATE_PROPERTY_ACCESS, propertyName, readableTypeName));
    }

    private void checkProtectedPropertyVisibility(NodeTraversal t, Node getprop, JSType ownerType) {
        JSType currentClass = this.getCurrentClass();
        if (currentClass == null || !currentClass.isSubtypeOf(ownerType)) {
            String propertyName = getprop.getLastChild().getString();
            this.compiler.report(t.makeError(getprop, BAD_PROTECTED_PROPERTY_ACCESS, propertyName, this.typeRegistry.getReadableTypeName(getprop.getFirstChild())));
        }
    }

    private static boolean isValidPrivateConstructorAccess(Node parent) {
        return !parent.isNew();
    }

    private boolean shouldEmitDeprecationWarning(NodeTraversal t, Node n, Node parent) {
        if (!(!t.inGlobalScope() || parent.isCall() && parent.getFirstChild() == n || n.isNew())) {
            return false;
        }
        if (n.isGetProp() && n == parent.getFirstChild() && NodeUtil.isAssignmentOp(parent)) {
            return false;
        }
        if (n.isGetProp() && parent.isExprResult() && n.getJSDocInfo().isDeprecated()) {
            return false;
        }
        return !this.canAccessDeprecatedTypes(t);
    }

    private boolean canAccessDeprecatedTypes(NodeTraversal t) {
        Node scopeRoot = t.getClosestHoistScopeRoot();
        if (NodeUtil.isFunctionBlock(scopeRoot)) {
            scopeRoot = scopeRoot.getParent();
        }
        Node scopeRootParent = scopeRoot.getParent();
        return this.deprecatedDepth > 0 || CheckAccessControls.getTypeDeprecationInfo(this.getTypeOfThis(scopeRoot)) != null || scopeRootParent != null && scopeRootParent.isAssign() && CheckAccessControls.getTypeDeprecationInfo(this.getClassOfMethod(scopeRoot, scopeRootParent)) != null;
    }

    private static boolean isDeprecatedFunction(Node n) {
        Preconditions.checkState(n.isFunction(), n);
        return CheckAccessControls.getDeprecationReason(NodeUtil.getBestJSDocInfo(n)) != null;
    }

    private static String getTypeDeprecationInfo(JSType type) {
        ObjectType implicitProto;
        if (type == null) {
            return null;
        }
        String depReason = CheckAccessControls.getDeprecationReason(type.getJSDocInfo());
        if (depReason != null) {
            return depReason;
        }
        ObjectType objType = CheckAccessControls.castToObject(type);
        if (objType != null && (implicitProto = objType.getPrototypeObject()) != null) {
            return CheckAccessControls.getTypeDeprecationInfo(implicitProto);
        }
        return null;
    }

    private static String getDeprecationReason(JSDocInfo info) {
        if (info != null && info.isDeprecated()) {
            if (info.getDeprecationReason() != null) {
                return info.getDeprecationReason();
            }
            return "";
        }
        return null;
    }

    private boolean isPropertyDeclaredConstant(ObjectType objectType, String prop) {
        if (this.enforceCodingConventions && this.compiler.getCodingConvention().isConstant(prop)) {
            return true;
        }
        while (objectType != null) {
            JSDocInfo docInfo = objectType.getOwnPropertyJSDocInfo(prop);
            if (docInfo != null && docInfo.isConstant()) {
                return true;
            }
            objectType = objectType.getPrototypeObject();
        }
        return false;
    }

    @Nullable
    private static String getPropertyDeprecationInfo(ObjectType type, String prop) {
        String depReason = CheckAccessControls.getDeprecationReason(type.getOwnPropertyJSDocInfo(prop));
        if (depReason != null) {
            return depReason;
        }
        ObjectType implicitProto = type.getPrototypeObject();
        if (implicitProto != null) {
            return CheckAccessControls.getPropertyDeprecationInfo(implicitProto, prop);
        }
        return null;
    }

    @Nullable
    private static ObjectType dereference(JSType type) {
        return type == null ? null : type.dereference();
    }

    @Nullable
    private static ObjectType getSuperClassInstanceIfFinal(@Nullable JSType type) {
        if (type != null) {
            JSDocInfo doc;
            ObjectType obj = CheckAccessControls.castToObject(type);
            FunctionType ctor = obj == null ? null : obj.getSuperClassConstructor();
            JSDocInfo jSDocInfo = doc = ctor == null ? null : ctor.getJSDocInfo();
            if (doc != null && doc.isFinal()) {
                return ctor.getInstanceType();
            }
        }
        return null;
    }

    @Nullable
    private static ObjectType castToObject(@Nullable JSType type) {
        return type == null ? null : type.toMaybeObjectType();
    }

    @Nullable
    private JSType getTypeOfThis(Node scopeRoot) {
        if (scopeRoot.isRoot()) {
            return CheckAccessControls.castToObject(scopeRoot.getJSType());
        }
        Preconditions.checkState(scopeRoot.isFunction(), scopeRoot);
        JSType nodeType = scopeRoot.getJSType();
        if (nodeType != null && nodeType.isFunctionType()) {
            return nodeType.toMaybeFunctionType().getTypeOfThis();
        }
        return null;
    }
}

