/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.base.Preconditions;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.CompilerPass;
import com.google.javascript.jscomp.CrossModuleReferenceCollector;
import com.google.javascript.jscomp.Es6SyntacticScopeCreator;
import com.google.javascript.jscomp.JSModule;
import com.google.javascript.jscomp.JSModuleGraph;
import com.google.javascript.jscomp.Reference;
import com.google.javascript.jscomp.Var;
import com.google.javascript.rhino.IR;
import com.google.javascript.rhino.Node;
import com.google.javascript.rhino.Token;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

class CrossModuleCodeMotion
implements CompilerPass {
    private final AbstractCompiler compiler;
    private final JSModuleGraph graph;
    private final Map<JSModule, Node> moduleInsertionPointMap = new HashMap<JSModule, Node>();
    private final boolean parentModuleCanSeeSymbolsDeclaredInChildren;

    CrossModuleCodeMotion(AbstractCompiler compiler, JSModuleGraph graph, boolean parentModuleCanSeeSymbolsDeclaredInChildren) {
        this.compiler = compiler;
        this.graph = graph;
        this.parentModuleCanSeeSymbolsDeclaredInChildren = parentModuleCanSeeSymbolsDeclaredInChildren;
    }

    @Override
    public void process(Node externs, Node root) {
        if (this.graph != null && this.graph.getModuleCount() > 1) {
            CrossModuleReferenceCollector referenceCollector = new CrossModuleReferenceCollector(this.compiler, new Es6SyntacticScopeCreator(this.compiler));
            referenceCollector.process(root);
            Collection<GlobalSymbol> globalSymbols = new GlobalSymbolCollector().collectGlobalSymbols(referenceCollector);
            this.moveGlobalSymbols(globalSymbols);
            this.addInstanceofGuards(globalSymbols);
        }
    }

    private void addInstanceofGuards(Collection<GlobalSymbol> globalSymbols) {
        for (GlobalSymbol globalSymbol : globalSymbols) {
            for (InstanceofReference instanceofReference : globalSymbol.instanceofReferencesToGuard) {
                if (globalSymbol.declarationsCoverModule(instanceofReference.getModule())) continue;
                this.addGuardToInstanceofReference(instanceofReference.getReference().getNode());
            }
        }
    }

    private void moveGlobalSymbols(Collection<GlobalSymbol> globalSymbols) {
        for (GlobalSymbolCycle globalSymbolCycle : new OrderAndCombineGlobalSymbols(globalSymbols).orderAndCombine()) {
            globalSymbolCycle.moveDeclarationStatements();
        }
    }

    private void addGuardToInstanceofReference(Node referenceNode) {
        Preconditions.checkState(this.isUnguardedInstanceofReference(referenceNode), "instanceof Reference is already guarded: %s", (Object)referenceNode);
        Node instanceofNode = Preconditions.checkNotNull(referenceNode.getParent());
        Node referenceForTypeOf = referenceNode.cloneNode();
        Node tmp = IR.block();
        instanceofNode.replaceWith(tmp);
        Node and = IR.and(new Node(Token.NE, IR.string("undefined"), new Node(Token.TYPEOF, referenceForTypeOf)), instanceofNode);
        and.useSourceInfoIfMissingFromForTree(instanceofNode);
        tmp.replaceWith(and);
        this.compiler.reportChangeToEnclosingScope(and);
    }

    private boolean isUndefinedTypeofGuardReference(Node reference) {
        Node undefinedTypeofGuard = reference.getGrandparent();
        if (undefinedTypeofGuard != null && this.isUndefinedTypeofGuardFor(undefinedTypeofGuard, reference)) {
            Node andNode = undefinedTypeofGuard.getParent();
            return andNode != null && andNode.isAnd() && this.isInstanceofFor(andNode.getLastChild(), reference);
        }
        return false;
    }

    private boolean isUndefinedTypeofGuardFor(Node expression, Node reference) {
        if (expression.isNE()) {
            Node undefinedString = expression.getFirstChild();
            Node typeofNode = expression.getLastChild();
            return undefinedString.isString() && undefinedString.getString().equals("undefined") && typeofNode.isTypeOf() && typeofNode.getFirstChild().isEquivalentTo(reference);
        }
        return false;
    }

    private boolean isGuardedInstanceofReference(Node reference) {
        Node instanceofNode = reference.getParent();
        if (this.isInstanceofFor(instanceofNode, reference)) {
            Node andNode = instanceofNode.getParent();
            return andNode != null && andNode.isAnd() && this.isUndefinedTypeofGuardFor(andNode.getFirstChild(), reference);
        }
        return false;
    }

    private boolean isUnguardedInstanceofReference(Node reference) {
        Node instanceofNode = reference.getParent();
        if (this.isInstanceofFor(instanceofNode, reference)) {
            Node andNode = instanceofNode.getParent();
            return andNode == null || !andNode.isAnd() || !this.isUndefinedTypeofGuardFor(andNode.getFirstChild(), reference);
        }
        return false;
    }

    private boolean isInstanceofFor(Node expression, Node reference) {
        return expression.isInstanceOf() && expression.getLastChild().isEquivalentTo(reference);
    }

    private static class MovableInstanceofReference
    implements InstanceofReference {
        DeclarationStatementGroup containingDsg;
        Reference reference;

        MovableInstanceofReference(DeclarationStatementGroup containingDsg, Reference reference) {
            this.containingDsg = containingDsg;
            this.reference = reference;
        }

        @Override
        public JSModule getModule() {
            return this.containingDsg.currentModule;
        }

        @Override
        public Reference getReference() {
            return this.reference;
        }
    }

    private static class ImmovableInstanceofReference
    implements InstanceofReference {
        JSModule module;
        Reference reference;

        ImmovableInstanceofReference(JSModule module, Reference reference) {
            this.module = module;
            this.reference = reference;
        }

        @Override
        public JSModule getModule() {
            return this.module;
        }

        @Override
        public Reference getReference() {
            return this.reference;
        }
    }

    static interface InstanceofReference {
        public JSModule getModule();

        public Reference getReference();
    }

    private class DeclarationStatementGroupCycle {
        GlobalSymbolCycle globalSymbolCycle;
        JSModule currentModule;
        Deque<DeclarationStatementGroup> dsgs;

        DeclarationStatementGroupCycle(GlobalSymbolCycle globalSymbolCycle, JSModule currentModule) {
            this.globalSymbolCycle = globalSymbolCycle;
            this.currentModule = currentModule;
            this.dsgs = new ArrayDeque<DeclarationStatementGroup>();
        }

        void moveToPreferredModule(BitSet modulesWithImmovableReferences) {
            JSModule preferredModule = this.getPreferredModule(modulesWithImmovableReferences);
            if (!preferredModule.equals(this.currentModule)) {
                this.moveStatementsToModule(preferredModule);
            }
            for (DeclarationStatementGroup dsg : this.dsgs) {
                dsg.currentModule = preferredModule;
                dsg.makeReferencesImmovable();
            }
        }

        private void moveStatementsToModule(JSModule preferredModule) {
            Node destParent = (Node)CrossModuleCodeMotion.this.moduleInsertionPointMap.get(preferredModule);
            if (destParent == null) {
                destParent = CrossModuleCodeMotion.this.compiler.getNodeForCodeInsertion(preferredModule);
                CrossModuleCodeMotion.this.moduleInsertionPointMap.put(preferredModule, destParent);
            }
            Deque<CrossModuleReferenceCollector.TopLevelStatement> statementsLastFirst = this.getStatementsLastFirst();
            for (CrossModuleReferenceCollector.TopLevelStatement statement : statementsLastFirst) {
                Node statementNode = statement.getStatementNode();
                CrossModuleCodeMotion.this.compiler.reportChangeToEnclosingScope(statementNode);
                statementNode.detach();
                destParent.addChildToFront(statementNode);
                CrossModuleCodeMotion.this.compiler.reportChangeToEnclosingScope(statementNode);
            }
        }

        private Deque<CrossModuleReferenceCollector.TopLevelStatement> getStatementsLastFirst() {
            ArrayDeque<CrossModuleReferenceCollector.TopLevelStatement> result = new ArrayDeque<CrossModuleReferenceCollector.TopLevelStatement>();
            block0: for (DeclarationStatementGroup dsg : this.dsgs) {
                ArrayDeque<CrossModuleReferenceCollector.TopLevelStatement> stack1 = new ArrayDeque<CrossModuleReferenceCollector.TopLevelStatement>(dsg.statementStack);
                ArrayDeque<CrossModuleReferenceCollector.TopLevelStatement> stack2 = result;
                result = new ArrayDeque(stack1.size() + stack2.size());
                while (true) {
                    if (stack1.isEmpty()) {
                        result.addAll(stack2);
                        continue block0;
                    }
                    if (stack2.isEmpty()) {
                        result.addAll(stack1);
                        continue block0;
                    }
                    CrossModuleReferenceCollector.TopLevelStatement s1 = (CrossModuleReferenceCollector.TopLevelStatement)stack1.peek();
                    CrossModuleReferenceCollector.TopLevelStatement s2 = (CrossModuleReferenceCollector.TopLevelStatement)stack2.peek();
                    if (s1.getOriginalOrder() > s2.getOriginalOrder()) {
                        result.add((CrossModuleReferenceCollector.TopLevelStatement)stack1.pop());
                        Preconditions.checkState(stack1.isEmpty() || ((CrossModuleReferenceCollector.TopLevelStatement)stack1.peek()).getOriginalOrder() < s1.getOriginalOrder(), "Statements are recorded in the wrong order.");
                        continue;
                    }
                    result.add((CrossModuleReferenceCollector.TopLevelStatement)stack2.pop());
                    Preconditions.checkState(stack2.isEmpty() || ((CrossModuleReferenceCollector.TopLevelStatement)stack2.peek()).getOriginalOrder() < s2.getOriginalOrder(), "Statements are recorded in the wrong order.");
                }
            }
            return result;
        }

        private JSModule getPreferredModule(BitSet modulesWithImmovableReferences) {
            if (modulesWithImmovableReferences.isEmpty()) {
                return this.currentModule;
            }
            if (!this.allStatementsCanMove()) {
                return this.currentModule;
            }
            return CrossModuleCodeMotion.this.graph.getSmallestCoveringSubtree(this.currentModule, modulesWithImmovableReferences);
        }

        boolean allStatementsCanMove() {
            for (DeclarationStatementGroup dsg : this.dsgs) {
                if (dsg.allStatementsCanMove()) continue;
                return false;
            }
            return true;
        }
    }

    private class OrderAndCombineGlobalSymbols {
        final Collection<GlobalSymbol> inputSymbols;
        final Deque<GlobalSymbol> componentContents = new ArrayDeque<GlobalSymbol>();
        final Deque<GlobalSymbol> componentRoots = new ArrayDeque<GlobalSymbol>();
        final Deque<GlobalSymbolCycle> stronglyConnectedSymbols;
        int preorderCounter = 0;

        OrderAndCombineGlobalSymbols(Collection<GlobalSymbol> dsgs) {
            this.inputSymbols = dsgs;
            this.stronglyConnectedSymbols = new ArrayDeque<GlobalSymbolCycle>(dsgs.size());
        }

        Deque<GlobalSymbolCycle> orderAndCombine() {
            for (GlobalSymbol globalSymbol : this.inputSymbols) {
                if (globalSymbol.preorderNumber >= 0) continue;
                this.processGlobalSymbol(globalSymbol);
            }
            return this.stronglyConnectedSymbols;
        }

        void processGlobalSymbol(GlobalSymbol symbol) {
            Preconditions.checkState(symbol.preorderNumber < 0, "already processed: %s", (Object)symbol);
            symbol.preorderNumber = this.preorderCounter++;
            this.componentRoots.push(symbol);
            this.componentContents.push(symbol);
            for (GlobalSymbol referringSymbol : symbol.referencingGlobalSymbols) {
                if (referringSymbol.preorderNumber < 0) {
                    this.processGlobalSymbol(referringSymbol);
                    continue;
                }
                if (referringSymbol.hasBeenAssignedToAStronglyConnectedComponent) continue;
                while (this.componentRoots.peek().preorderNumber > referringSymbol.preorderNumber) {
                    this.componentRoots.pop();
                }
            }
            if (this.componentRoots.peek().equals(symbol)) {
                GlobalSymbol connectedSymbol;
                this.componentRoots.pop();
                GlobalSymbolCycle cycle = new GlobalSymbolCycle();
                do {
                    connectedSymbol = this.componentContents.pop();
                    cycle.addSymbol(connectedSymbol);
                    connectedSymbol.hasBeenAssignedToAStronglyConnectedComponent = true;
                } while (!connectedSymbol.equals(symbol));
                this.stronglyConnectedSymbols.add(cycle);
            }
        }
    }

    private static class DeclarationStatementGroup {
        final GlobalSymbol declaredGlobalSymbol;
        final Set<GlobalSymbol> referencedGlobalSymbols = new HashSet<GlobalSymbol>();
        JSModule currentModule;
        Deque<CrossModuleReferenceCollector.TopLevelStatement> statementStack = new ArrayDeque<CrossModuleReferenceCollector.TopLevelStatement>();

        DeclarationStatementGroup(GlobalSymbol declaredGlobalSymbol, JSModule currentModule) {
            this.declaredGlobalSymbol = declaredGlobalSymbol;
            this.currentModule = currentModule;
        }

        boolean allStatementsCanMove() {
            for (CrossModuleReferenceCollector.TopLevelStatement s : this.statementStack) {
                if (s.isMovableDeclaration()) continue;
                return false;
            }
            return true;
        }

        void addReferenceToGlobalSymbol(GlobalSymbol refSymbol) {
            this.referencedGlobalSymbols.add(refSymbol);
        }

        void makeReferencesImmovable() {
            this.declaredGlobalSymbol.addImmovableReference(this.currentModule);
            for (GlobalSymbol symbol : this.referencedGlobalSymbols) {
                Preconditions.checkState(!symbol.isMoveDeclarationStatementsDone, "symbol %s moved before referring symbol %s", (Object)symbol, (Object)this.declaredGlobalSymbol);
                symbol.addImmovableReference(this.currentModule);
            }
        }
    }

    private class GlobalSymbolCycle {
        final Deque<GlobalSymbol> symbols = new ArrayDeque<GlobalSymbol>();

        private GlobalSymbolCycle() {
        }

        void addSymbol(GlobalSymbol symbol) {
            this.symbols.add(symbol);
        }

        void moveDeclarationStatements() {
            for (GlobalSymbol symbol : this.symbols) {
                Preconditions.checkState(!symbol.isMoveDeclarationStatementsDone, "duplicate attempt to move %s", (Object)symbol);
            }
            BitSet modulesWithImmovableReferences = new BitSet(CrossModuleCodeMotion.this.graph.getModuleCount());
            List<DeclarationStatementGroupCycle> cyclesLatestFirst = this.getDsgCyclesLatestFirst();
            for (DeclarationStatementGroupCycle dsgCycle : cyclesLatestFirst) {
                for (GlobalSymbol symbol : this.symbols) {
                    modulesWithImmovableReferences.or(symbol.modulesWithImmovableReferences);
                }
                dsgCycle.moveToPreferredModule(modulesWithImmovableReferences);
            }
            for (GlobalSymbol symbol : this.symbols) {
                symbol.isMoveDeclarationStatementsDone = true;
            }
        }

        List<DeclarationStatementGroupCycle> getDsgCyclesLatestFirst() {
            ArrayList<DeclarationStatementGroupCycle> cyclesLatestFirst = new ArrayList<DeclarationStatementGroupCycle>();
            Deque<DeclarationStatementGroup> dsgsLatestFirst = this.getDsgsLatestFirst();
            DeclarationStatementGroupCycle cycle = null;
            for (DeclarationStatementGroup dsg : dsgsLatestFirst) {
                if (cycle == null || !cycle.currentModule.equals(dsg.currentModule)) {
                    cycle = new DeclarationStatementGroupCycle(this, dsg.currentModule);
                    cyclesLatestFirst.add(cycle);
                }
                cycle.dsgs.add(dsg);
            }
            return cyclesLatestFirst;
        }

        private Deque<DeclarationStatementGroup> getDsgsLatestFirst() {
            ArrayDeque<DeclarationStatementGroup> resultStack = new ArrayDeque<DeclarationStatementGroup>();
            block0: for (GlobalSymbol symbol : this.symbols) {
                ArrayDeque<DeclarationStatementGroup> stack1 = resultStack;
                ArrayDeque<DeclarationStatementGroup> stack2 = new ArrayDeque<DeclarationStatementGroup>(symbol.dsgStack);
                resultStack = new ArrayDeque(stack1.size() + stack2.size());
                while (true) {
                    if (stack1.isEmpty()) {
                        resultStack.addAll(stack2);
                        continue block0;
                    }
                    if (stack2.isEmpty()) {
                        resultStack.addAll(stack1);
                        continue block0;
                    }
                    DeclarationStatementGroup dsg1 = (DeclarationStatementGroup)stack1.peek();
                    DeclarationStatementGroup dsg2 = (DeclarationStatementGroup)stack2.peek();
                    if (dsg1.currentModule.getIndex() > dsg2.currentModule.getIndex()) {
                        resultStack.add((DeclarationStatementGroup)stack1.pop());
                        Preconditions.checkState(stack1.isEmpty() || ((DeclarationStatementGroup)stack1.peek()).currentModule.getIndex() <= dsg1.currentModule.getIndex(), "DSG stacks are out of order.");
                        continue;
                    }
                    resultStack.add((DeclarationStatementGroup)stack2.pop());
                    Preconditions.checkState(stack2.isEmpty() || ((DeclarationStatementGroup)stack2.peek()).currentModule.getIndex() <= dsg2.currentModule.getIndex(), "DSG stacks are out of order.");
                }
            }
            return resultStack;
        }
    }

    private class GlobalSymbol {
        final Var var;
        final Deque<DeclarationStatementGroup> dsgStack = new ArrayDeque<DeclarationStatementGroup>();
        final BitSet modulesWithImmovableReferences = new BitSet(CrossModuleCodeMotion.access$500(CrossModuleCodeMotion.this).getModuleCount());
        final Set<GlobalSymbol> referencingGlobalSymbols = new LinkedHashSet<GlobalSymbol>();
        Deque<InstanceofReference> instanceofReferencesToGuard = new ArrayDeque<InstanceofReference>();
        int preorderNumber = -1;
        boolean hasBeenAssignedToAStronglyConnectedComponent = false;
        boolean isMoveDeclarationStatementsDone = false;

        GlobalSymbol(Var var) {
            this.var = var;
        }

        public String toString() {
            return this.var.getName();
        }

        void addImmovableReference(JSModule module) {
            this.modulesWithImmovableReferences.set(module.getIndex());
        }

        DeclarationStatementGroup addDeclarationStatement(CrossModuleReferenceCollector.TopLevelStatement statement) {
            DeclarationStatementGroup statementDsg;
            JSModule module = statement.getModule();
            DeclarationStatementGroup lastDsg = this.dsgStack.peek();
            if (lastDsg == null) {
                lastDsg = new DeclarationStatementGroup(this, module);
                this.dsgStack.push(lastDsg);
            }
            if (module.equals(lastDsg.currentModule)) {
                statementDsg = lastDsg;
            } else {
                statementDsg = new DeclarationStatementGroup(this, module);
                this.dsgStack.push(statementDsg);
            }
            statementDsg.statementStack.push(statement);
            return statementDsg;
        }

        void addReferringGlobalSymbol(GlobalSymbol declaredSymbol) {
            this.referencingGlobalSymbols.add(declaredSymbol);
        }

        boolean declarationsCoverModule(JSModule module) {
            for (DeclarationStatementGroup dsg : this.dsgStack) {
                if (!module.equals(dsg.currentModule) && !CrossModuleCodeMotion.this.graph.dependsOn(module, dsg.currentModule)) continue;
                return true;
            }
            return false;
        }
    }

    private class GlobalSymbolCollector {
        final Map<Var, GlobalSymbol> globalSymbolforVar = new HashMap<Var, GlobalSymbol>();
        final Deque<GlobalSymbol> symbolStack = new ArrayDeque<GlobalSymbol>();

        private GlobalSymbolCollector() {
        }

        Collection<GlobalSymbol> collectGlobalSymbols(CrossModuleReferenceCollector referenceCollector) {
            for (CrossModuleReferenceCollector.TopLevelStatement statement : referenceCollector.getTopLevelStatements()) {
                if (statement.isDeclarationStatement()) {
                    this.processDeclarationStatement(statement);
                    continue;
                }
                this.processImmovableStatement(statement);
            }
            return this.symbolStack;
        }

        private void processImmovableStatement(CrossModuleReferenceCollector.TopLevelStatement statement) {
            for (Reference ref : statement.getNonDeclarationReferences()) {
                this.processImmovableReference(ref, statement.getModule());
            }
        }

        private void processImmovableReference(Reference ref, JSModule module) {
            GlobalSymbol globalSymbol = this.getGlobalSymbol(ref.getSymbol());
            if (CrossModuleCodeMotion.this.parentModuleCanSeeSymbolsDeclaredInChildren) {
                Node n = ref.getNode();
                if (CrossModuleCodeMotion.this.isGuardedInstanceofReference(n) || CrossModuleCodeMotion.this.isUndefinedTypeofGuardReference(n)) {
                    return;
                }
                if (CrossModuleCodeMotion.this.isUnguardedInstanceofReference(n)) {
                    ImmovableInstanceofReference instanceofReference = new ImmovableInstanceofReference(module, ref);
                    globalSymbol.instanceofReferencesToGuard.push(instanceofReference);
                    return;
                }
            }
            globalSymbol.addImmovableReference(module);
        }

        private void processDeclarationStatement(CrossModuleReferenceCollector.TopLevelStatement statement) {
            GlobalSymbol declaredSymbol = this.getGlobalSymbol(statement.getDeclaredNameReference().getSymbol());
            DeclarationStatementGroup dsg = declaredSymbol.addDeclarationStatement(statement);
            this.processDeclarationStatementContainedReferences(statement, declaredSymbol, dsg);
        }

        private void processDeclarationStatementContainedReferences(CrossModuleReferenceCollector.TopLevelStatement statement, GlobalSymbol declaredSymbol, DeclarationStatementGroup dsg) {
            for (Reference ref : statement.getNonDeclarationReferences()) {
                GlobalSymbol refSymbol = this.getGlobalSymbol(ref.getSymbol());
                if (refSymbol.equals(declaredSymbol)) continue;
                if (CrossModuleCodeMotion.this.parentModuleCanSeeSymbolsDeclaredInChildren) {
                    Node n = ref.getNode();
                    if (CrossModuleCodeMotion.this.isGuardedInstanceofReference(n) || CrossModuleCodeMotion.this.isUndefinedTypeofGuardReference(n)) continue;
                    if (CrossModuleCodeMotion.this.isUnguardedInstanceofReference(n)) {
                        MovableInstanceofReference instanceofReference = new MovableInstanceofReference(dsg, ref);
                        refSymbol.instanceofReferencesToGuard.push(instanceofReference);
                        continue;
                    }
                }
                dsg.addReferenceToGlobalSymbol(refSymbol);
                refSymbol.addReferringGlobalSymbol(declaredSymbol);
            }
        }

        private GlobalSymbol getGlobalSymbol(Var var) {
            GlobalSymbol globalSymbol = this.globalSymbolforVar.get(var);
            if (globalSymbol == null) {
                globalSymbol = new GlobalSymbol(var);
                this.globalSymbolforVar.put(var, globalSymbol);
                this.symbolStack.push(globalSymbol);
            }
            return globalSymbol;
        }
    }
}

