/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.collect.Table;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.jscomp.Scope;
import com.google.javascript.rhino.JSDocInfo;
import com.google.javascript.rhino.Node;

final class Es6RenameReferences
extends NodeTraversal.AbstractPostOrderCallback {
    private final Table<Node, String, String> renameTable;

    Es6RenameReferences(Table<Node, String, String> renameTable) {
        this.renameTable = renameTable;
    }

    @Override
    public void visit(NodeTraversal t, Node n, Node parent) {
        JSDocInfo info;
        if (NodeUtil.isReferenceName(n)) {
            this.renameReference(t, n);
        }
        if ((info = n.getJSDocInfo()) != null) {
            this.renameTypeNode(t, info.getTypeNodes());
        }
    }

    private void renameTypeNode(NodeTraversal t, Iterable<Node> typeNodes) {
        for (Node type : typeNodes) {
            if (type.isString()) {
                this.renameReference(t, type);
            }
            this.renameTypeNode(t, type.children());
        }
    }

    private void renameReference(NodeTraversal t, Node n) {
        String oldName = n.getString();
        for (Scope current = t.getScope(); current != null; current = (Scope)current.getParent()) {
            String newName = this.renameTable.get(current.getRootNode(), oldName);
            if (newName != null) {
                n.setString(newName);
                t.reportCodeChange();
                return;
            }
            if (!current.hasOwnSlot(oldName)) continue;
            return;
        }
    }
}

