/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.CheckLevel;
import com.google.javascript.jscomp.CompilerInput;
import com.google.javascript.jscomp.DiagnosticGroup;
import com.google.javascript.jscomp.DiagnosticType;
import com.google.javascript.jscomp.JSError;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.TypeMismatch;
import com.google.javascript.jscomp.TypedScope;
import com.google.javascript.jscomp.TypedVar;
import com.google.javascript.jscomp.parsing.parser.util.format.SimpleFormat;
import com.google.javascript.rhino.Node;
import com.google.javascript.rhino.jstype.FunctionType;
import com.google.javascript.rhino.jstype.JSType;
import com.google.javascript.rhino.jstype.JSTypeNative;
import com.google.javascript.rhino.jstype.JSTypeRegistry;
import com.google.javascript.rhino.jstype.ObjectType;
import com.google.javascript.rhino.jstype.Property;
import com.google.javascript.rhino.jstype.TemplateTypeMap;
import com.google.javascript.rhino.jstype.TemplateTypeMapReplacer;
import com.google.javascript.rhino.jstype.UnknownType;
import java.io.Serializable;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.annotation.Nullable;

class TypeValidator
implements Serializable {
    private final transient AbstractCompiler compiler;
    private final JSTypeRegistry typeRegistry;
    private final JSType allBitwisableValueTypes;
    private final JSType nullOrUndefined;
    private JSType.SubtypingMode subtypingMode = JSType.SubtypingMode.NORMAL;
    private boolean strictOperatorChecks = false;
    private final List<TypeMismatch> mismatches = new ArrayList<TypeMismatch>();
    private final List<TypeMismatch> implicitInterfaceUses = new ArrayList<TypeMismatch>();
    private static final String FOUND_REQUIRED = "{0}\nfound   : {1}\nrequired: {2}";
    private static final String FOUND_REQUIRED_MISSING = "{0}\nfound   : {1}\nrequired: {2}\nmissing : [{3}]\nmismatch: [{4}]";
    static final DiagnosticType INVALID_CAST = DiagnosticType.warning("JSC_INVALID_CAST", "invalid cast - must be a subtype or supertype\nfrom: {0}\nto  : {1}");
    static final DiagnosticType TYPE_MISMATCH_WARNING = DiagnosticType.warning("JSC_TYPE_MISMATCH", "{0}");
    static final DiagnosticType INVALID_OPERAND_TYPE = DiagnosticType.warning("JSC_INVALID_OPERAND_TYPE", "{0}");
    static final DiagnosticType MISSING_EXTENDS_TAG_WARNING = DiagnosticType.warning("JSC_MISSING_EXTENDS_TAG", "Missing @extends tag on type {0}");
    static final DiagnosticType DUP_VAR_DECLARATION = DiagnosticType.warning("JSC_DUP_VAR_DECLARATION", "variable {0} redefined, original definition at {1}:{2}");
    static final DiagnosticType DUP_VAR_DECLARATION_TYPE_MISMATCH = DiagnosticType.warning("JSC_DUP_VAR_DECLARATION_TYPE_MISMATCH", "variable {0} redefined with type {1}, original definition at {2}:{3} with type {4}");
    static final DiagnosticType INTERFACE_METHOD_NOT_IMPLEMENTED = DiagnosticType.warning("JSC_INTERFACE_METHOD_NOT_IMPLEMENTED", "property {0} on interface {1} is not implemented by type {2}");
    static final DiagnosticType HIDDEN_INTERFACE_PROPERTY_MISMATCH = DiagnosticType.warning("JSC_HIDDEN_INTERFACE_PROPERTY_MISMATCH", "mismatch of the {0} property on type {1} and the type of the property it overrides from interface {2}\noriginal: {3}\noverride: {4}");
    static final DiagnosticType ABSTRACT_METHOD_NOT_IMPLEMENTED = DiagnosticType.warning("JSC_ABSTRACT_METHOD_NOT_IMPLEMENTED", "property {0} on abstract class {1} is not implemented by type {2}");
    static final DiagnosticType UNKNOWN_TYPEOF_VALUE = DiagnosticType.warning("JSC_UNKNOWN_TYPEOF_VALUE", "unknown type: {0}");
    static final DiagnosticType ILLEGAL_PROPERTY_ACCESS = DiagnosticType.warning("JSC_ILLEGAL_PROPERTY_ACCESS", "Cannot do {0} access on a {1}");
    static final DiagnosticGroup ALL_DIAGNOSTICS = new DiagnosticGroup(ABSTRACT_METHOD_NOT_IMPLEMENTED, INVALID_CAST, TYPE_MISMATCH_WARNING, MISSING_EXTENDS_TAG_WARNING, DUP_VAR_DECLARATION, DUP_VAR_DECLARATION_TYPE_MISMATCH, INTERFACE_METHOD_NOT_IMPLEMENTED, HIDDEN_INTERFACE_PROPERTY_MISMATCH, UNKNOWN_TYPEOF_VALUE, ILLEGAL_PROPERTY_ACCESS);

    TypeValidator(AbstractCompiler compiler) {
        this.compiler = compiler;
        this.typeRegistry = compiler.getTypeRegistry();
        this.allBitwisableValueTypes = this.typeRegistry.createUnionType(JSTypeNative.STRING_TYPE, JSTypeNative.NUMBER_TYPE, JSTypeNative.BOOLEAN_TYPE, JSTypeNative.NULL_TYPE, JSTypeNative.VOID_TYPE);
        this.nullOrUndefined = this.typeRegistry.getNativeType(JSTypeNative.NULL_VOID);
    }

    static FunctionType getFunctionType(@Nullable TypedVar v) {
        JSType t = v == null ? null : v.getType();
        ObjectType o = t == null ? null : t.dereference();
        return JSType.toMaybeFunctionType(o);
    }

    static ObjectType getInstanceOfCtor(@Nullable TypedVar v) {
        FunctionType ctor = TypeValidator.getFunctionType(v);
        if (ctor != null && ctor.isConstructor()) {
            return ctor.getInstanceType();
        }
        return null;
    }

    Iterable<TypeMismatch> getMismatches() {
        return this.mismatches;
    }

    void setSubtypingMode(JSType.SubtypingMode mode) {
        this.subtypingMode = mode;
    }

    void setStrictOperatorChecks(boolean strictChecks) {
        this.strictOperatorChecks = strictChecks;
    }

    public Iterable<TypeMismatch> getImplicitInterfaceUses() {
        return this.implicitInterfaceUses;
    }

    void expectValidTypeofName(NodeTraversal t, Node n, String found) {
        this.report(JSError.make(n, UNKNOWN_TYPEOF_VALUE, found));
    }

    boolean expectObject(NodeTraversal t, Node n, JSType type, String msg) {
        if (!type.matchesObjectContext()) {
            this.mismatch(t, n, msg, type, JSTypeNative.OBJECT_TYPE);
            return false;
        }
        return true;
    }

    void expectActualObject(NodeTraversal t, Node n, JSType type, String msg) {
        if (!type.isObject()) {
            this.mismatch(t, n, msg, type, JSTypeNative.OBJECT_TYPE);
        }
    }

    void expectAnyObject(NodeTraversal t, Node n, JSType type, String msg) {
        JSType anyObjectType = this.getNativeType(JSTypeNative.NO_OBJECT_TYPE);
        if (!anyObjectType.isSubtypeOf(type) && !type.isEmptyType()) {
            this.mismatch(t, n, msg, type, anyObjectType);
        }
    }

    boolean expectAutoboxesToIterable(NodeTraversal t, Node n, JSType type, String msg) {
        if (type.isUnionType()) {
            for (JSType alt : type.toMaybeUnionType().getAlternatesWithoutStructuralTyping()) {
                alt = alt.isBoxableScalar() ? alt.autoboxesTo() : alt;
                if (alt.isSubtypeOf(this.getNativeType(JSTypeNative.ITERABLE_TYPE))) continue;
                this.mismatch(t, n, msg, type, JSTypeNative.ITERABLE_TYPE);
                return false;
            }
        } else {
            JSType autoboxedType;
            JSType jSType = autoboxedType = type.isBoxableScalar() ? type.autoboxesTo() : type;
            if (!autoboxedType.isSubtypeOf(this.getNativeType(JSTypeNative.ITERABLE_TYPE))) {
                this.mismatch(t, n, msg, type, JSTypeNative.ITERABLE_TYPE);
                return false;
            }
        }
        return true;
    }

    void expectGeneratorSupertype(NodeTraversal t, Node n, JSType type, String msg) {
        if (!this.getNativeType(JSTypeNative.GENERATOR_TYPE).isSubtypeOf(type)) {
            this.mismatch(t, n, msg, type, JSTypeNative.GENERATOR_TYPE);
        }
    }

    void expectValidAsyncReturnType(NodeTraversal t, Node n, JSType type) {
        if (type.isUnknownType() || type.isAllType() || type == this.getNativeType(JSTypeNative.OBJECT_TYPE)) {
            return;
        }
        if (!type.getTemplateTypeMap().hasTemplateKey(this.typeRegistry.getIThenableTemplate())) {
            this.mismatch(t, n, "An async function must return a (supertype of) Promise", type, JSTypeNative.I_THENABLE_TYPE);
        }
    }

    void expectITemplateArraySupertype(NodeTraversal t, Node n, JSType type, String msg) {
        if (!this.getNativeType(JSTypeNative.I_TEMPLATE_ARRAY_TYPE).isSubtypeOf(type)) {
            this.mismatch(t, n, msg, type, JSTypeNative.I_TEMPLATE_ARRAY_TYPE);
        }
    }

    void expectString(NodeTraversal t, Node n, JSType type, String msg) {
        if (!type.matchesStringContext()) {
            this.mismatch(t, n, msg, type, JSTypeNative.STRING_TYPE);
        }
    }

    void expectNumber(NodeTraversal t, Node n, JSType type, String msg) {
        if (!type.matchesNumberContext()) {
            this.mismatch(t, n, msg, type, JSTypeNative.NUMBER_TYPE);
        } else if (this.strictOperatorChecks) {
            this.expectNumberStrict(n, type, msg);
        }
    }

    void expectNumberStrict(Node n, JSType type, String msg) {
        Preconditions.checkState(this.strictOperatorChecks);
        if (!type.isSubtypeOf(this.getNativeType(JSTypeNative.NUMBER_TYPE))) {
            this.registerMismatchAndReport(n, INVALID_OPERAND_TYPE, msg, type, this.getNativeType(JSTypeNative.NUMBER_TYPE), null, null);
        }
    }

    void expectMatchingTypes(Node n, JSType left, JSType right, String msg) {
        Preconditions.checkState(this.strictOperatorChecks);
        if (!left.isSubtypeOf(right) && !right.isSubtypeOf(left)) {
            this.registerMismatchAndReport(n, INVALID_OPERAND_TYPE, msg, right, left, null, null);
        }
    }

    void expectBitwiseable(NodeTraversal t, Node n, JSType type, String msg) {
        if (!type.matchesNumberContext() && !type.isSubtypeOf(this.allBitwisableValueTypes)) {
            this.mismatch(t, n, msg, type, this.allBitwisableValueTypes);
        } else if (this.strictOperatorChecks) {
            this.expectNumberStrict(n, type, msg);
        }
    }

    void expectNumberOrSymbol(NodeTraversal t, Node n, JSType type, String msg) {
        if (!type.matchesNumberContext() && !type.matchesSymbolContext()) {
            this.mismatch(t, n, msg, type, JSTypeNative.NUMBER_SYMBOL);
        }
    }

    void expectStringOrSymbol(NodeTraversal t, Node n, JSType type, String msg) {
        if (!type.matchesStringContext() && !type.matchesSymbolContext()) {
            this.mismatch(t, n, msg, type, JSTypeNative.STRING_SYMBOL);
        }
    }

    void expectStringOrNumber(NodeTraversal t, Node n, JSType type, String msg) {
        if (!(type.matchesNumberContext() || type.matchesStringContext() || type.matchesStringContext())) {
            this.mismatch(t, n, msg, type, JSTypeNative.NUMBER_STRING);
        } else if (this.strictOperatorChecks) {
            this.expectStringOrNumberOrSymbolStrict(n, type, msg);
        }
    }

    void expectStringOrNumberStrict(Node n, JSType type, String msg) {
        Preconditions.checkState(this.strictOperatorChecks);
        if (!type.isSubtypeOf(this.getNativeType(JSTypeNative.NUMBER_STRING))) {
            this.registerMismatchAndReport(n, INVALID_OPERAND_TYPE, msg, type, this.getNativeType(JSTypeNative.NUMBER_STRING), null, null);
        }
    }

    void expectStringOrNumberOrSymbol(NodeTraversal t, Node n, JSType type, String msg) {
        if (!(type.matchesNumberContext() || type.matchesStringContext() || type.matchesSymbolContext())) {
            this.mismatch(t, n, msg, type, JSTypeNative.NUMBER_STRING_SYMBOL);
        } else if (this.strictOperatorChecks) {
            this.expectStringOrNumberOrSymbolStrict(n, type, msg);
        }
    }

    void expectStringOrNumberOrSymbolStrict(Node n, JSType type, String msg) {
        Preconditions.checkState(this.strictOperatorChecks);
        if (!type.isSubtypeOf(this.getNativeType(JSTypeNative.NUMBER_STRING_SYMBOL))) {
            this.registerMismatchAndReport(n, INVALID_OPERAND_TYPE, msg, type, this.getNativeType(JSTypeNative.NUMBER_STRING_SYMBOL), null, null);
        }
    }

    boolean expectNotNullOrUndefined(NodeTraversal t, Node n, JSType type, String msg, JSType expectedType) {
        if (!type.isNoType() && !type.isUnknownType() && type.isSubtypeOf(this.nullOrUndefined) && !TypeValidator.containsForwardDeclaredUnresolvedName(type)) {
            if (n.isGetProp() && !t.inGlobalScope() && type.isNullType()) {
                return true;
            }
            this.mismatch(t, n, msg, type, expectedType);
            return false;
        }
        return true;
    }

    private static boolean containsForwardDeclaredUnresolvedName(JSType type) {
        if (type.isUnionType()) {
            for (JSType alt : type.toMaybeUnionType().getAlternates()) {
                if (!TypeValidator.containsForwardDeclaredUnresolvedName(alt)) continue;
                return true;
            }
        }
        return type.isNoResolvedType();
    }

    void expectSwitchMatchesCase(NodeTraversal t, Node n, JSType switchType, JSType caseType) {
        if (!(switchType.canTestForShallowEqualityWith(caseType) || caseType.autoboxesTo() != null && caseType.autoboxesTo().isSubtypeOf(switchType))) {
            this.mismatch(t, n.getFirstChild(), "case expression doesn't match switch", caseType, switchType);
        } else if (!(switchType.canTestForShallowEqualityWith(caseType) || caseType.autoboxesTo() != null && caseType.autoboxesTo().isSubtypeWithoutStructuralTyping(switchType))) {
            TypeMismatch.recordImplicitInterfaceUses(this.implicitInterfaceUses, n, caseType, switchType);
            TypeMismatch.recordImplicitUseOfNativeObject(this.mismatches, n, caseType, switchType);
        }
    }

    void expectIndexMatch(NodeTraversal t, Node n, JSType objType, JSType indexType) {
        Node indexNode;
        Preconditions.checkState(n.isGetElem() || n.isComputedProp(), n);
        Node node = indexNode = n.isGetElem() ? n.getLastChild() : n.getFirstChild();
        if (indexType.isSymbolValueType()) {
            return;
        }
        if (objType.isStruct()) {
            this.report(JSError.make(indexNode, ILLEGAL_PROPERTY_ACCESS, "'[]'", "struct"));
        }
        if (objType.isUnknownType()) {
            this.expectStringOrNumberOrSymbol(t, indexNode, indexType, "property access");
        } else {
            ObjectType dereferenced = objType.dereference();
            if (dereferenced != null && dereferenced.getTemplateTypeMap().hasTemplateKey(this.typeRegistry.getObjectIndexKey())) {
                this.expectCanAssignTo(t, indexNode, indexType, dereferenced.getTemplateTypeMap().getResolvedTemplateType(this.typeRegistry.getObjectIndexKey()), "restricted index type");
            } else if (dereferenced != null && dereferenced.isArrayType()) {
                this.expectNumberOrSymbol(t, indexNode, indexType, "array access");
            } else if (objType.matchesObjectContext()) {
                this.expectStringOrSymbol(t, indexNode, indexType, "property access");
            } else {
                this.mismatch(t, n, "only arrays or objects can be accessed", objType, this.typeRegistry.createUnionType(JSTypeNative.ARRAY_TYPE, JSTypeNative.OBJECT_TYPE));
            }
        }
    }

    boolean expectCanAssignToPropertyOf(NodeTraversal t, Node n, JSType rightType, JSType leftType, Node owner, String propName) {
        if (!leftType.isNoType() && !rightType.isSubtypeOf(leftType)) {
            FunctionType ownerFn;
            JSType ownerType = this.getJSType(owner);
            if (ownerType.isFunctionPrototypeType() && (ownerFn = ownerType.toObjectType().getOwnerFunction()).isInterface() && rightType.isFunctionType() && leftType.isFunctionType()) {
                return true;
            }
            this.mismatch(t, n, "assignment to property " + propName + " of " + this.typeRegistry.getReadableTypeName(owner), rightType, leftType);
            return false;
        }
        if (!leftType.isNoType() && !rightType.isSubtypeWithoutStructuralTyping(leftType)) {
            TypeMismatch.recordImplicitInterfaceUses(this.implicitInterfaceUses, n, rightType, leftType);
            TypeMismatch.recordImplicitUseOfNativeObject(this.mismatches, n, rightType, leftType);
        }
        return true;
    }

    boolean expectCanAssignTo(NodeTraversal t, Node n, JSType rightType, JSType leftType, String msg) {
        if (!rightType.isSubtypeOf(leftType)) {
            this.mismatch(t, n, msg, rightType, leftType);
            return false;
        }
        if (!rightType.isSubtypeWithoutStructuralTyping(leftType)) {
            TypeMismatch.recordImplicitInterfaceUses(this.implicitInterfaceUses, n, rightType, leftType);
            TypeMismatch.recordImplicitUseOfNativeObject(this.mismatches, n, rightType, leftType);
        }
        return true;
    }

    void expectArgumentMatchesParameter(NodeTraversal t, Node n, JSType argType, JSType paramType, Node callNode, int ordinal) {
        if (!argType.isSubtypeOf(paramType)) {
            this.mismatch(t, n, SimpleFormat.format("actual parameter %d of %s does not match formal parameter", ordinal, this.typeRegistry.getReadableTypeNameNoDeref(callNode.getFirstChild())), argType, paramType);
        } else if (!argType.isSubtypeWithoutStructuralTyping(paramType)) {
            TypeMismatch.recordImplicitInterfaceUses(this.implicitInterfaceUses, n, argType, paramType);
            TypeMismatch.recordImplicitUseOfNativeObject(this.mismatches, n, argType, paramType);
        }
    }

    void expectSuperType(NodeTraversal t, Node n, ObjectType superObject, ObjectType subObject) {
        ObjectType declaredSuper;
        FunctionType subCtor = subObject.getConstructor();
        ObjectType implicitProto = subObject.getImplicitPrototype();
        ObjectType objectType = declaredSuper = implicitProto == null ? null : implicitProto.getImplicitPrototype();
        if (declaredSuper != null && declaredSuper.isTemplatizedType()) {
            declaredSuper = declaredSuper.toMaybeTemplatizedType().getReferencedType();
        }
        if (declaredSuper != null && !(superObject instanceof UnknownType) && !declaredSuper.isEquivalentTo(superObject)) {
            if (declaredSuper.isEquivalentTo(this.getNativeType(JSTypeNative.OBJECT_TYPE))) {
                TypeMismatch.registerMismatch(this.mismatches, this.implicitInterfaceUses, superObject, declaredSuper, this.report(t.makeError(n, MISSING_EXTENDS_TAG_WARNING, subObject.toString())));
            } else {
                this.mismatch(n, "mismatch in declaration of superclass type", superObject, declaredSuper);
            }
            if (!subCtor.hasCachedValues()) {
                subCtor.setPrototypeBasedOn(superObject);
            }
        }
    }

    void expectExtends(Node n, FunctionType subCtor, FunctionType superCtor) {
        if (superCtor == null || !superCtor.isConstructor() && !superCtor.isInterface()) {
            return;
        }
        if (superCtor.isConstructor() != subCtor.isConstructor()) {
            return;
        }
        ObjectType superInstance = superCtor.getInstanceType();
        if (subCtor.isConstructor()) {
            ObjectType declaredSuper = subCtor.getSuperClassConstructor().getInstanceType();
            if (!superInstance.isEquivalentTo(declaredSuper)) {
                this.mismatch(n, "mismatch in declaration of superclass type", superInstance, declaredSuper);
            }
        } else if (subCtor.isInterface() && !subCtor.explicitlyImplOrExtInterface(superCtor)) {
            ObjectType extended = (ObjectType)subCtor.getExtendedInterfaces().get(0);
            this.mismatch(n, "mismatch in declaration of superclass type", superInstance, extended);
        }
    }

    void expectCanAssignToPrototype(NodeTraversal t, JSType ownerType, Node node, JSType rightType) {
        FunctionType functionType;
        if (ownerType.isFunctionType() && (functionType = ownerType.toMaybeFunctionType()).isConstructor()) {
            this.expectObject(t, node, rightType, "cannot override prototype with non-object");
        }
    }

    void expectCanCast(NodeTraversal t, Node n, JSType targetType, JSType sourceType) {
        if (!sourceType.canCastTo(targetType)) {
            TypeMismatch.registerMismatch(this.mismatches, this.implicitInterfaceUses, sourceType, targetType, this.report(t.makeError(n, INVALID_CAST, sourceType.toString(), targetType.toString())));
        } else if (!sourceType.isSubtypeWithoutStructuralTyping(targetType)) {
            TypeMismatch.recordImplicitInterfaceUses(this.implicitInterfaceUses, n, sourceType, targetType);
        }
    }

    TypedVar expectUndeclaredVariable(String sourceName, CompilerInput input, Node n, Node parent, TypedVar var, String variableName, JSType newType) {
        TypedVar newVar = var;
        JSType varType = var.getType();
        if (varType != null && varType != this.typeRegistry.getNativeType(JSTypeNative.UNKNOWN_TYPE) && newType != null && newType != this.typeRegistry.getNativeType(JSTypeNative.UNKNOWN_TYPE)) {
            if (var.input == null) {
                TypedScope s = (TypedScope)var.getScope();
                s.undeclare(var);
                newVar = s.declare(variableName, n, varType, input, false);
                n.setJSType(varType);
                if (parent.isVar()) {
                    if (n.hasChildren()) {
                        n.getFirstChild().setJSType(varType);
                    }
                } else {
                    Preconditions.checkState(parent.isFunction());
                    parent.setJSType(varType);
                }
            } else {
                boolean allowDupe = TypeValidator.hasDuplicateDeclarationSuppression(this.compiler, var.getNameNode());
                if (!allowDupe) {
                    if (!newType.isEquivalentTo(varType, true)) {
                        this.report(JSError.make(n, DUP_VAR_DECLARATION_TYPE_MISMATCH, variableName, newType.toString(), var.getInputName(), String.valueOf(var.nameNode.getLineno()), varType.toString()));
                    } else if (!var.getParentNode().isExprResult()) {
                        this.report(JSError.make(n, DUP_VAR_DECLARATION, variableName, var.getInputName(), String.valueOf(var.nameNode.getLineno())));
                    }
                }
            }
        }
        return newVar;
    }

    void expectAllInterfaceProperties(NodeTraversal t, Node n, FunctionType type) {
        ObjectType instance = type.getInstanceType();
        for (ObjectType implemented : type.getAllImplementedInterfaces()) {
            if (implemented.getImplicitPrototype() == null) continue;
            for (String prop : implemented.getImplicitPrototype().getOwnPropertyNames()) {
                this.expectInterfaceProperty(t, n, instance, implemented, prop);
            }
        }
    }

    private void expectInterfaceProperty(NodeTraversal t, Node n, ObjectType instance, ObjectType implementedInterface, String prop) {
        Property propSlot = instance.getSlot(prop);
        if (propSlot == null) {
            String sourceName = n.getSourceFileName();
            sourceName = Strings.nullToEmpty(sourceName);
            TypeMismatch.registerMismatch(this.mismatches, this.implicitInterfaceUses, instance, implementedInterface, this.report(JSError.make(n, INTERFACE_METHOD_NOT_IMPLEMENTED, prop, implementedInterface.toString(), instance.toString())));
        } else {
            Node propNode = propSlot.getDeclaration() == null ? null : propSlot.getDeclaration().getNode();
            propNode = propNode == null ? n : propNode;
            JSType found = propSlot.getType();
            found = found.restrictByNotNullOrUndefined();
            JSType required = implementedInterface.getImplicitPrototype().getPropertyType(prop);
            TemplateTypeMap typeMap = implementedInterface.getTemplateTypeMap();
            if (!typeMap.isEmpty()) {
                TemplateTypeMapReplacer replacer = new TemplateTypeMapReplacer(this.typeRegistry, typeMap);
                required = required.visit(replacer);
            }
            if (!found.isSubtype(required = required.restrictByNotNullOrUndefined(), this.subtypingMode)) {
                FunctionType constructor = implementedInterface.toObjectType().getConstructor();
                JSError err = t.makeError(propNode, HIDDEN_INTERFACE_PROPERTY_MISMATCH, prop, instance.toString(), constructor.getTopMostDefiningType(prop).toString(), required.toString(), found.toString());
                TypeMismatch.registerMismatch(this.mismatches, this.implicitInterfaceUses, found, required, err);
                this.report(err);
            }
        }
    }

    void expectAbstractMethodsImplemented(Node n, FunctionType ctorType) {
        FunctionType currSuperCtor;
        Preconditions.checkArgument(ctorType.isConstructor());
        LinkedHashMap<String, ObjectType> abstractMethodSuperTypeMap = new LinkedHashMap<String, ObjectType>();
        if (currSuperCtor == null || !currSuperCtor.isAbstract()) {
            return;
        }
        for (currSuperCtor = ctorType.getSuperClassConstructor(); currSuperCtor != null && currSuperCtor.isAbstract(); currSuperCtor = currSuperCtor.getSuperClassConstructor()) {
            ObjectType superType = currSuperCtor.getInstanceType();
            for (String prop : currSuperCtor.getInstanceType().getImplicitPrototype().getOwnPropertyNames()) {
                FunctionType maybeAbstractMethod = superType.findPropertyType(prop).toMaybeFunctionType();
                if (maybeAbstractMethod == null || !maybeAbstractMethod.isAbstract() || abstractMethodSuperTypeMap.containsKey(prop)) continue;
                abstractMethodSuperTypeMap.put(prop, superType);
            }
        }
        ObjectType instance = ctorType.getInstanceType();
        for (Map.Entry entry : abstractMethodSuperTypeMap.entrySet()) {
            String method = (String)entry.getKey();
            ObjectType superType = (ObjectType)entry.getValue();
            FunctionType abstractMethod = instance.findPropertyType(method).toMaybeFunctionType();
            if (abstractMethod != null && !abstractMethod.isAbstract()) continue;
            String sourceName = n.getSourceFileName();
            sourceName = Strings.nullToEmpty(sourceName);
            TypeMismatch.registerMismatch(this.mismatches, this.implicitInterfaceUses, instance, superType, this.report(JSError.make(n, ABSTRACT_METHOD_NOT_IMPLEMENTED, method, superType.toString(), instance.toString())));
        }
    }

    private void mismatch(NodeTraversal unusedT, Node n, String msg, JSType found, JSType required) {
        this.mismatch(n, msg, found, required);
    }

    private void mismatch(NodeTraversal t, Node n, String msg, JSType found, JSTypeNative required) {
        this.mismatch(t, n, msg, found, this.getNativeType(required));
    }

    private void mismatch(Node n, String msg, JSType found, JSType required) {
        if (!found.isSubtype(required, this.subtypingMode)) {
            TreeSet<String> missing = null;
            TreeSet<String> mismatch = null;
            if (required.isStructuralType()) {
                missing = new TreeSet<String>();
                mismatch = new TreeSet<String>();
                ObjectType requiredObject = required.toMaybeObjectType();
                ObjectType foundObject = found.toMaybeObjectType();
                if (requiredObject != null && foundObject != null) {
                    for (String property : requiredObject.getPropertyNames()) {
                        JSType propRequired = requiredObject.getPropertyType(property);
                        boolean hasProperty = foundObject.hasProperty(property);
                        if (propRequired.isExplicitlyVoidable() && !hasProperty) continue;
                        if (hasProperty) {
                            if (foundObject.getPropertyType(property).isSubtype(propRequired, this.subtypingMode)) continue;
                            mismatch.add(property);
                            continue;
                        }
                        missing.add(property);
                    }
                }
            }
            this.registerMismatchAndReport(n, TYPE_MISMATCH_WARNING, msg, found, required, missing, mismatch);
        }
    }

    private void registerMismatchAndReport(Node n, DiagnosticType diagnostic, String msg, JSType found, JSType required, Set<String> missing, Set<String> mismatch) {
        String foundRequiredFormatted = TypeValidator.formatFoundRequired(msg, found, required, missing, mismatch);
        JSError err = JSError.make(n, diagnostic, foundRequiredFormatted);
        TypeMismatch.registerMismatch(this.mismatches, this.implicitInterfaceUses, found, required, err);
        this.report(err);
    }

    private static String formatFoundRequired(String description, JSType found, JSType required, Set<String> missing, Set<String> mismatch) {
        String requiredStr;
        String foundStr = found.toString();
        if (foundStr.equals(requiredStr = required.toString())) {
            foundStr = found.toAnnotationString(JSType.Nullability.IMPLICIT);
            requiredStr = required.toAnnotationString(JSType.Nullability.IMPLICIT);
        }
        String missingStr = "";
        String mismatchStr = "";
        if (missing != null && !missing.isEmpty()) {
            missingStr = Joiner.on(",").join(missing);
        }
        if (mismatch != null && !mismatch.isEmpty()) {
            mismatchStr = Joiner.on(",").join(mismatch);
        }
        if (missingStr.length() > 0 || mismatchStr.length() > 0) {
            return MessageFormat.format(FOUND_REQUIRED_MISSING, description, foundStr, requiredStr, missingStr, mismatchStr);
        }
        return MessageFormat.format(FOUND_REQUIRED, description, foundStr, requiredStr);
    }

    private JSType getJSType(Node n) {
        return Preconditions.checkNotNull(n.getJSType(), "%s has no JSType attached", (Object)n);
    }

    private JSType getNativeType(JSTypeNative typeId) {
        return this.typeRegistry.getNativeType(typeId);
    }

    private JSError report(JSError error) {
        this.compiler.report(error);
        return error;
    }

    static boolean hasDuplicateDeclarationSuppression(AbstractCompiler compiler, Node decl) {
        CheckLevel originalDeclLevel = compiler.getErrorLevel(JSError.make(decl, DUP_VAR_DECLARATION, "dummy", "dummy"));
        return originalDeclLevel == CheckLevel.OFF;
    }
}

