/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.rhino.jstype;

import com.google.javascript.rhino.Node;
import com.google.javascript.rhino.jstype.JSType;
import com.google.javascript.rhino.jstype.JSTypeNative;
import com.google.javascript.rhino.jstype.JSTypeRegistry;
import com.google.javascript.rhino.jstype.ProxyObjectType;
import com.google.javascript.rhino.jstype.RelationshipVisitor;
import com.google.javascript.rhino.jstype.Visitor;

public final class TemplateType
extends ProxyObjectType {
    private static final long serialVersionUID = 1L;
    private final String name;
    private final Node typeTransformation;

    TemplateType(JSTypeRegistry registry, String name) {
        this(registry, name, null);
    }

    TemplateType(JSTypeRegistry registry, String name, Node typeTransformation) {
        super(registry, registry.getNativeObjectType(JSTypeNative.UNKNOWN_TYPE));
        this.name = name;
        this.typeTransformation = typeTransformation;
    }

    @Override
    public String getReferenceName() {
        return this.name;
    }

    @Override
    StringBuilder appendTo(StringBuilder sb, boolean forAnnotations) {
        return sb.append(this.name);
    }

    @Override
    public TemplateType toMaybeTemplateType() {
        return this;
    }

    @Override
    public boolean hasAnyTemplateTypesInternal() {
        return true;
    }

    @Override
    public <T> T visit(Visitor<T> visitor) {
        return visitor.caseTemplateType(this);
    }

    @Override
    <T> T visit(RelationshipVisitor<T> visitor, JSType that) {
        return visitor.caseTemplateType(this, that);
    }

    public boolean isTypeTransformation() {
        return this.typeTransformation != null;
    }

    public Node getTypeTransformation() {
        return this.typeTransformation;
    }
}

