/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicates;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.BasicBlock;
import com.google.javascript.jscomp.CollapseProperties;
import com.google.javascript.jscomp.CompilerInput;
import com.google.javascript.jscomp.CompilerPass;
import com.google.javascript.jscomp.DiagnosticType;
import com.google.javascript.jscomp.Es6SyntacticScopeCreator;
import com.google.javascript.jscomp.GlobalNamespace;
import com.google.javascript.jscomp.JSError;
import com.google.javascript.jscomp.JSModule;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.jscomp.Reference;
import com.google.javascript.jscomp.ReferenceCollectingCallback;
import com.google.javascript.jscomp.ReferenceCollection;
import com.google.javascript.jscomp.Scope;
import com.google.javascript.jscomp.Var;
import com.google.javascript.rhino.IR;
import com.google.javascript.rhino.Node;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;

class AggressiveInlineAliases
implements CompilerPass {
    static final DiagnosticType UNSAFE_CTOR_ALIASING = DiagnosticType.warning("JSC_UNSAFE_CTOR_ALIASING", "Variable {0} aliases a constructor, so it cannot be assigned multiple times");
    private final AbstractCompiler compiler;
    private boolean codeChanged;

    private void rewriteAliasProps(GlobalNamespace.Name name, Node value, int depth, Set<GlobalNamespace.AstChange> newNodes) {
        if (name.props == null) {
            return;
        }
        Preconditions.checkState(!value.matchesQualifiedName(name.getFullName()), "%s should not match name %s", (Object)value, (Object)name.getFullName());
        for (GlobalNamespace.Name prop : name.props) {
            this.rewriteAliasProp(value, depth, newNodes, prop);
        }
    }

    private void rewriteAliasProp(Node value, int depth, Set<GlobalNamespace.AstChange> newNodes, GlobalNamespace.Name prop) {
        this.rewriteAliasProps(prop, value, depth + 1, newNodes);
        ArrayList<GlobalNamespace.Ref> refs = new ArrayList<GlobalNamespace.Ref>(prop.getRefs());
        for (GlobalNamespace.Ref ref : refs) {
            Node target = ref.node;
            for (int i = 0; i <= depth; ++i) {
                if (target.isGetProp()) {
                    target = target.getFirstChild();
                    continue;
                }
                if (NodeUtil.isObjectLitKey(target)) {
                    Node gparent = target.getGrandparent();
                    if (gparent.isAssign()) {
                        target = gparent.getFirstChild();
                        continue;
                    }
                    Preconditions.checkState(NodeUtil.isObjectLitKey(gparent));
                    target = gparent;
                    continue;
                }
                throw new IllegalStateException("unexpected: " + target);
            }
            Preconditions.checkState(target.isGetProp() || target.isName());
            Node newValue = value.cloneTree();
            target.replaceWith(newValue);
            this.compiler.reportChangeToEnclosingScope(newValue);
            prop.removeRef(ref);
            newNodes.add(new GlobalNamespace.AstChange(ref.module, ref.scope, ref.node));
            this.codeChanged = true;
        }
    }

    AggressiveInlineAliases(AbstractCompiler compiler) {
        this.compiler = compiler;
        this.codeChanged = true;
    }

    @Override
    public void process(Node externs, Node root) {
        while (this.codeChanged) {
            this.codeChanged = false;
            GlobalNamespace namespace = new GlobalNamespace(this.compiler, root);
            this.inlineAliases(namespace);
        }
    }

    private JSModule getRefModule(Reference ref) {
        CompilerInput input = this.compiler.getInput(ref.getInputId());
        return input == null ? null : input.getModule();
    }

    private void inlineAliases(GlobalNamespace namespace) {
        ArrayDeque<GlobalNamespace.Name> workList = new ArrayDeque<GlobalNamespace.Name>(namespace.getNameForest());
        while (!workList.isEmpty()) {
            List<GlobalNamespace.Name> subclasses;
            GlobalNamespace.Name name = (GlobalNamespace.Name)workList.pop();
            if (name.type == GlobalNamespace.Name.Type.GET || name.type == GlobalNamespace.Name.Type.SET) continue;
            if (!name.inExterns() && name.globalSets == 1 && name.localSets == 0 && name.aliasingGets > 0) {
                ArrayList<GlobalNamespace.Ref> refs = new ArrayList<GlobalNamespace.Ref>(name.getRefs());
                for (GlobalNamespace.Ref ref : refs) {
                    Scope hoistScope = (Scope)ref.scope.getClosestHoistScope();
                    if (ref.type == GlobalNamespace.Ref.Type.ALIASING_GET && !this.mayBeGlobalAlias(ref) && ref.getTwin() == null) {
                        if (!this.inlineAliasIfPossible(name, ref, namespace)) continue;
                        name.removeRef(ref);
                        continue;
                    }
                    if (ref.type != GlobalNamespace.Ref.Type.ALIASING_GET || !hoistScope.isGlobal() || ref.getTwin() != null || !this.inlineGlobalAliasIfPossible(name, ref, namespace)) continue;
                    name.removeRef(ref);
                }
            }
            if (!name.inExterns() && name.type == GlobalNamespace.Name.Type.CLASS && (subclasses = name.subclasses) != null && name.props != null) {
                for (GlobalNamespace.Name subclass : subclasses) {
                    for (GlobalNamespace.Name prop : name.props) {
                        this.rewriteAllSubclassInheritedAccesses(name, subclass, prop, namespace);
                    }
                }
            }
            if (name.type != GlobalNamespace.Name.Type.OBJECTLIT && name.type != GlobalNamespace.Name.Type.FUNCTION && name.type != GlobalNamespace.Name.Type.CLASS || name.aliasingGets != 0 || this.isUnsafelyReassigned(name) || name.props == null) continue;
            workList.addAll(name.props);
        }
    }

    private boolean rewriteAllSubclassInheritedAccesses(GlobalNamespace.Name superclassNameObj, GlobalNamespace.Name subclassNameObj, GlobalNamespace.Name prop, GlobalNamespace namespace) {
        GlobalNamespace.Ref propDeclRef = prop.getDeclaration();
        if (propDeclRef == null || propDeclRef.node == null || !propDeclRef.node.getParent().isAssign()) {
            return false;
        }
        Node propRhs = propDeclRef.node.getParent().getLastChild();
        if (propRhs.isFunction()) {
            return false;
        }
        String subclassQualifiedPropName = subclassNameObj.getFullName() + "." + prop.getBaseName();
        GlobalNamespace.Name subclassPropNameObj = namespace.getOwnSlot(subclassQualifiedPropName);
        if (subclassPropNameObj != null && (subclassPropNameObj.localSets > 0 || subclassPropNameObj.globalSets > 0)) {
            return false;
        }
        if (subclassNameObj.subclasses != null) {
            for (GlobalNamespace.Name name : subclassNameObj.subclasses) {
                this.rewriteAllSubclassInheritedAccesses(superclassNameObj, name, prop, namespace);
            }
        }
        if (subclassPropNameObj != null) {
            LinkedHashSet<GlobalNamespace.AstChange> newNodes = new LinkedHashSet<GlobalNamespace.AstChange>();
            Node superclassNameNode = superclassNameObj.getDeclaration().node;
            if (superclassNameNode.isName()) {
                superclassNameNode = superclassNameNode.cloneNode();
            } else if (superclassNameNode.isGetProp()) {
                superclassNameNode = superclassNameNode.cloneTree();
            } else {
                return false;
            }
            this.rewriteAliasProp(superclassNameNode, 0, newNodes, subclassPropNameObj);
            namespace.scanNewNodes(newNodes);
        }
        return true;
    }

    private boolean mayBeGlobalAlias(GlobalNamespace.Ref alias) {
        Node aliasLhsNode;
        if (alias.scope.isGlobal()) {
            return true;
        }
        Node aliasParent = alias.node.getParent();
        if (!aliasParent.isAssign() && !aliasParent.isName()) {
            return true;
        }
        Node node = aliasLhsNode = aliasParent.isName() ? aliasParent : aliasParent.getFirstChild();
        if (!aliasLhsNode.isName()) {
            return true;
        }
        String aliasVarName = aliasLhsNode.getString();
        Var aliasVar = (Var)alias.scope.getVar(aliasVarName);
        if (aliasVar != null) {
            return aliasVar.isGlobal();
        }
        return true;
    }

    private boolean inlineAliasIfPossible(GlobalNamespace.Name name, GlobalNamespace.Ref alias, GlobalNamespace namespace) {
        Node aliasParent = alias.node.getParent();
        if (aliasParent.isName() || aliasParent.isAssign()) {
            Node aliasLhsNode = aliasParent.isName() ? aliasParent : aliasParent.getFirstChild();
            String aliasVarName = aliasLhsNode.getString();
            Var aliasVar = (Var)alias.scope.getVar(aliasVarName);
            Preconditions.checkState(aliasVar != null, "Expected variable to be defined in scope", (Object)aliasVarName);
            ReferenceCollectingCallback collector = new ReferenceCollectingCallback(this.compiler, ReferenceCollectingCallback.DO_NOTHING_BEHAVIOR, new Es6SyntacticScopeCreator(this.compiler), Predicates.equalTo(aliasVar));
            Scope aliasScope = (Scope)aliasVar.getScope();
            collector.processScope(aliasScope);
            ReferenceCollection aliasRefs = collector.getReferences(aliasVar);
            LinkedHashSet<GlobalNamespace.AstChange> newNodes = new LinkedHashSet<GlobalNamespace.AstChange>();
            if (aliasRefs.isWellDefined() && aliasRefs.isAssignedOnceInLifetime()) {
                int firstRead;
                int size = aliasRefs.references.size();
                for (int i = firstRead = aliasRefs.references.get(0).isInitializingDeclaration() ? 1 : 2; i < size; ++i) {
                    Reference aliasRef = aliasRefs.references.get(i);
                    newNodes.add(this.replaceAliasReference(alias, aliasRef));
                }
                this.replaceAliasAssignment(alias, aliasLhsNode);
                namespace.scanNewNodes(newNodes);
                return true;
            }
            if (name.isConstructor()) {
                if (this.partiallyInlineAlias(alias, namespace, aliasRefs, aliasLhsNode)) {
                    return true;
                }
                if (this.referencesCollapsibleProperty(aliasRefs, name, namespace)) {
                    this.compiler.report(JSError.make(aliasParent, UNSAFE_CTOR_ALIASING, aliasVarName));
                }
            }
        }
        return false;
    }

    private boolean partiallyInlineAlias(GlobalNamespace.Ref alias, GlobalNamespace namespace, ReferenceCollection aliasRefs, Node aliasLhsNode) {
        BasicBlock aliasBlock = null;
        for (Reference aliasRef : aliasRefs) {
            Node aliasRefNode = aliasRef.getNode();
            if (aliasRefNode == aliasLhsNode) {
                aliasBlock = aliasRef.getBasicBlock();
                continue;
            }
            if (!aliasRef.isLvalue()) continue;
            return false;
        }
        LinkedHashSet<GlobalNamespace.AstChange> newNodes = new LinkedHashSet<GlobalNamespace.AstChange>();
        boolean alreadySeenInitialAlias = false;
        boolean foundNonReplaceableAlias = false;
        for (Reference aliasRef : aliasRefs) {
            Node aliasRefNode = aliasRef.getNode();
            if (aliasRefNode == aliasLhsNode) {
                alreadySeenInitialAlias = true;
                continue;
            }
            if (aliasRef.isDeclaration()) continue;
            BasicBlock refBlock = aliasRef.getBasicBlock();
            if (refBlock != aliasBlock && aliasBlock.provablyExecutesBefore(refBlock) || refBlock == aliasBlock && alreadySeenInitialAlias) {
                this.codeChanged = true;
                newNodes.add(this.replaceAliasReference(alias, aliasRef));
                continue;
            }
            foundNonReplaceableAlias = true;
        }
        if (!foundNonReplaceableAlias) {
            this.replaceAliasAssignment(alias, aliasLhsNode);
        }
        if (this.codeChanged) {
            namespace.scanNewNodes(newNodes);
        }
        return !foundNonReplaceableAlias;
    }

    private void replaceAliasAssignment(GlobalNamespace.Ref alias, Node aliasLhsNode) {
        Node assignment = aliasLhsNode.getParent();
        if (!NodeUtil.isNameDeclaration(assignment) && NodeUtil.isExpressionResultUsed(assignment)) {
            return;
        }
        Node aliasParent = alias.node.getParent();
        aliasParent.replaceChild(alias.node, IR.nullNode());
        alias.name.removeRef(alias);
        this.codeChanged = true;
        this.compiler.reportChangeToEnclosingScope(aliasParent);
    }

    private boolean referencesCollapsibleProperty(ReferenceCollection aliasRefs, GlobalNamespace.Name aliasedName, GlobalNamespace namespace) {
        for (Reference ref : aliasRefs.references) {
            if (ref.getParent() == null || !ref.getParent().isGetProp()) continue;
            Node propertyNode = ref.getNode().getNext();
            String propertyName = propertyNode.getString();
            String originalPropertyName = aliasedName.getName() + "." + propertyName;
            GlobalNamespace.Name originalProperty = namespace.getOwnSlot(originalPropertyName);
            if (originalProperty == null || !originalProperty.canCollapse()) continue;
            return true;
        }
        return false;
    }

    private GlobalNamespace.AstChange replaceAliasReference(GlobalNamespace.Ref alias, Reference aliasRef) {
        Node newNode = alias.node.cloneTree();
        aliasRef.getParent().replaceChild(aliasRef.getNode(), newNode);
        this.compiler.reportChangeToEnclosingScope(newNode);
        return new GlobalNamespace.AstChange(this.getRefModule(aliasRef), aliasRef.getScope(), newNode);
    }

    private boolean inlineGlobalAliasIfPossible(GlobalNamespace.Name name, GlobalNamespace.Ref alias, GlobalNamespace namespace) {
        Node aliasParent = alias.node.getParent();
        if ((aliasParent.isAssign() || aliasParent.isName()) && NodeUtil.isExecutedExactlyOnce(aliasParent) || aliasParent.isName() && name.isConstructor()) {
            Node lvalue;
            Node node = lvalue = aliasParent.isName() ? aliasParent : aliasParent.getFirstChild();
            if (!lvalue.isQualifiedName()) {
                return false;
            }
            if (lvalue.isName() && this.compiler.getCodingConvention().isExported(lvalue.getString(), false)) {
                return false;
            }
            GlobalNamespace.Name aliasingName = namespace.getSlot(lvalue.getQualifiedName());
            if (name.equals(aliasingName) && aliasParent.isAssign()) {
                return false;
            }
            if (aliasingName != null && aliasingName.isInlinableGlobalAlias()) {
                LinkedHashSet<GlobalNamespace.AstChange> newNodes = new LinkedHashSet<GlobalNamespace.AstChange>();
                ArrayList<GlobalNamespace.Ref> refs = new ArrayList<GlobalNamespace.Ref>(aliasingName.getRefs());
                block4: for (GlobalNamespace.Ref ref : refs) {
                    switch (ref.type) {
                        case SET_FROM_GLOBAL: {
                            continue block4;
                        }
                        case DIRECT_GET: 
                        case ALIASING_GET: 
                        case PROTOTYPE_GET: 
                        case CALL_GET: {
                            Node newNode = alias.node.cloneTree();
                            Node node2 = ref.node;
                            node2.getParent().replaceChild(node2, newNode);
                            this.compiler.reportChangeToEnclosingScope(newNode);
                            newNodes.add(new GlobalNamespace.AstChange(ref.module, ref.scope, newNode));
                            aliasingName.removeRef(ref);
                            continue block4;
                        }
                    }
                    throw new IllegalStateException();
                }
                this.rewriteAliasProps(aliasingName, alias.node, 0, newNodes);
                aliasParent.replaceChild(alias.node, IR.nullNode());
                this.codeChanged = true;
                this.compiler.reportChangeToEnclosingScope(aliasParent);
                namespace.scanNewNodes(newNodes);
                return true;
            }
        }
        return false;
    }

    private boolean isUnsafelyReassigned(GlobalNamespace.Name name) {
        boolean foundOriginalDefinition = false;
        for (GlobalNamespace.Ref ref : name.getRefs()) {
            if (!ref.isSet() || CollapseProperties.isSafeNamespaceReinit(ref)) continue;
            if (!foundOriginalDefinition) {
                foundOriginalDefinition = true;
                continue;
            }
            return true;
        }
        return false;
    }
}

