/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.annotations.GwtIncompatible;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.javascript.jscomp.CheckAccessControls;
import com.google.javascript.jscomp.CheckConformance;
import com.google.javascript.jscomp.CheckConstPrivateProperties;
import com.google.javascript.jscomp.CheckDebuggerStatement;
import com.google.javascript.jscomp.CheckGlobalNames;
import com.google.javascript.jscomp.CheckGlobalThis;
import com.google.javascript.jscomp.CheckJSDoc;
import com.google.javascript.jscomp.CheckLevel;
import com.google.javascript.jscomp.CheckMissingAndExtraRequires;
import com.google.javascript.jscomp.CheckMissingGetCssName;
import com.google.javascript.jscomp.CheckMissingReturn;
import com.google.javascript.jscomp.CheckProvides;
import com.google.javascript.jscomp.CheckRegExp;
import com.google.javascript.jscomp.CheckSideEffects;
import com.google.javascript.jscomp.CheckSuspiciousCode;
import com.google.javascript.jscomp.CheckUnreachableCode;
import com.google.javascript.jscomp.CheckUnusedPrivateProperties;
import com.google.javascript.jscomp.ClosureCheckModule;
import com.google.javascript.jscomp.ClosureRewriteModule;
import com.google.javascript.jscomp.CollapseProperties;
import com.google.javascript.jscomp.CompilerOptions;
import com.google.javascript.jscomp.ConstCheck;
import com.google.javascript.jscomp.DiagnosticGroup;
import com.google.javascript.jscomp.DiagnosticType;
import com.google.javascript.jscomp.DisambiguateProperties;
import com.google.javascript.jscomp.Es6ExternsCheck;
import com.google.javascript.jscomp.FunctionTypeBuilder;
import com.google.javascript.jscomp.ImplicitNullabilityCheck;
import com.google.javascript.jscomp.J2clChecksPass;
import com.google.javascript.jscomp.JsMessageVisitor;
import com.google.javascript.jscomp.PeepholeFoldConstants;
import com.google.javascript.jscomp.ProcessClosurePrimitives;
import com.google.javascript.jscomp.ProcessCommonJSModules;
import com.google.javascript.jscomp.ProcessDefines;
import com.google.javascript.jscomp.ProcessTweaks;
import com.google.javascript.jscomp.RewritePolyfills;
import com.google.javascript.jscomp.RhinoErrorReporter;
import com.google.javascript.jscomp.StrictModeCheck;
import com.google.javascript.jscomp.TypeCheck;
import com.google.javascript.jscomp.TypeValidator;
import com.google.javascript.jscomp.VarCheck;
import com.google.javascript.jscomp.VariableReferenceCheck;
import com.google.javascript.jscomp.deps.ModuleLoader;
import com.google.javascript.jscomp.lint.CheckArrayWithGoogObject;
import com.google.javascript.jscomp.lint.CheckDuplicateCase;
import com.google.javascript.jscomp.lint.CheckEmptyStatements;
import com.google.javascript.jscomp.lint.CheckEnums;
import com.google.javascript.jscomp.lint.CheckInterfaces;
import com.google.javascript.jscomp.lint.CheckJSDocStyle;
import com.google.javascript.jscomp.lint.CheckMissingSemicolon;
import com.google.javascript.jscomp.lint.CheckNullableReturn;
import com.google.javascript.jscomp.lint.CheckPrimitiveAsObject;
import com.google.javascript.jscomp.lint.CheckPrototypeProperties;
import com.google.javascript.jscomp.lint.CheckRedundantNullabilityModifier;
import com.google.javascript.jscomp.lint.CheckRequiresAndProvidesSorted;
import com.google.javascript.jscomp.lint.CheckUnusedLabels;
import com.google.javascript.jscomp.lint.CheckUselessBlocks;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class DiagnosticGroups {
    static final DiagnosticType UNUSED = DiagnosticType.warning("JSC_UNUSED", "{0}");
    public static final Set<String> wildcardExcludedGroups = ImmutableSet.of("reportUnknownTypes", "analyzerChecks", "analyzerChecksInternal", "oldReportUnknownTypes", "newCheckTypes", "newCheckTypesCompatibility", new String[]{"newCheckTypesExtraChecks", "missingSourcesWarnings", "strictMissingProperties", "strictPrimitiveOperators", "strictCheckTypes"});
    private static final Map<String, DiagnosticGroup> groupsByName = new HashMap<String, DiagnosticGroup>();
    static final String DIAGNOSTIC_GROUP_NAMES = "accessControls, ambiguousFunctionDecl, checkRegExp, checkTypes, checkVars, conformanceViolations, const, constantProperty, deprecated, deprecatedAnnotations, duplicateMessage, es3, es5Strict, externsValidation, fileoverviewTags, functionParams, globalThis, internetExplorerChecks, invalidCasts, misplacedTypeAnnotation, missingGetCssName, missingOverride, missingPolyfill, missingProperties, missingProvide, missingRequire, missingReturn, moduleLoad, msgDescriptions, newCheckTypes, nonStandardJsDocs, missingSourcesWarnings, reportUnknownTypes, suspiciousCode, strictCheckTypes, strictMissingProperties, strictModuleDepCheck, strictPrimitiveOperators, typeInvalidation, undefinedNames, undefinedVars, unknownDefines, unusedLocalVariables, unusedPrivateMembers, uselessCode, useOfGoogBase, underscore, visibility";
    public static final DiagnosticGroup MODULE_LOAD = DiagnosticGroups.registerGroup("moduleLoad", ModuleLoader.LOAD_WARNING, ProcessCommonJSModules.SUSPICIOUS_EXPORTS_ASSIGNMENT, ProcessCommonJSModules.UNKNOWN_REQUIRE_ENSURE);
    public static final DiagnosticGroup GLOBAL_THIS = DiagnosticGroups.registerGroup("globalThis", CheckGlobalThis.GLOBAL_THIS);
    public static final DiagnosticGroup DEPRECATED = DiagnosticGroups.registerGroup("deprecated", CheckAccessControls.DEPRECATED_NAME, CheckAccessControls.DEPRECATED_NAME_REASON, CheckAccessControls.DEPRECATED_PROP, CheckAccessControls.DEPRECATED_PROP_REASON, CheckAccessControls.DEPRECATED_CLASS, CheckAccessControls.DEPRECATED_CLASS_REASON);
    public static final DiagnosticGroup UNDERSCORE = DiagnosticGroups.registerGroup("underscore", CheckJSDocStyle.MUST_BE_PRIVATE, CheckJSDocStyle.MUST_HAVE_TRAILING_UNDERSCORE);
    public static final DiagnosticGroup VISIBILITY = DiagnosticGroups.registerGroup("visibility", CheckAccessControls.BAD_PRIVATE_GLOBAL_ACCESS, CheckAccessControls.BAD_PRIVATE_PROPERTY_ACCESS, CheckAccessControls.BAD_PACKAGE_PROPERTY_ACCESS, CheckAccessControls.BAD_PROTECTED_PROPERTY_ACCESS, CheckAccessControls.EXTEND_FINAL_CLASS, CheckAccessControls.PRIVATE_OVERRIDE, CheckAccessControls.VISIBILITY_MISMATCH, CheckAccessControls.CONVENTION_MISMATCH);
    public static final DiagnosticGroup ACCESS_CONTROLS = DiagnosticGroups.registerGroup("accessControls", VISIBILITY);
    public static final DiagnosticGroup NON_STANDARD_JSDOC = DiagnosticGroups.registerGroup("nonStandardJsDocs", RhinoErrorReporter.BAD_JSDOC_ANNOTATION, RhinoErrorReporter.INVALID_PARAM, RhinoErrorReporter.JSDOC_IN_BLOCK_COMMENT);
    public static final DiagnosticGroup INVALID_CASTS = DiagnosticGroups.registerGroup("invalidCasts", TypeValidator.INVALID_CAST);
    @Deprecated
    public static final DiagnosticGroup FILEOVERVIEW_JSDOC = DiagnosticGroups.registerDeprecatedGroup("fileoverviewTags");
    public static final DiagnosticGroup STRICT_MODULE_DEP_CHECK = DiagnosticGroups.registerGroup("strictModuleDepCheck", VarCheck.STRICT_MODULE_DEP_ERROR, CheckGlobalNames.STRICT_MODULE_DEP_QNAME);
    public static final DiagnosticGroup VIOLATED_MODULE_DEP = DiagnosticGroups.registerGroup("violatedModuleDep", VarCheck.VIOLATED_MODULE_DEP_ERROR);
    public static final DiagnosticGroup EXTERNS_VALIDATION = DiagnosticGroups.registerGroup("externsValidation", VarCheck.NAME_REFERENCE_IN_EXTERNS_ERROR, VarCheck.UNDEFINED_EXTERN_VAR_ERROR);
    public static final DiagnosticGroup AMBIGUOUS_FUNCTION_DECL = DiagnosticGroups.registerGroup("ambiguousFunctionDecl", StrictModeCheck.BAD_FUNCTION_DECLARATION);
    public static final DiagnosticGroup UNKNOWN_DEFINES = DiagnosticGroups.registerGroup("unknownDefines", ProcessDefines.UNKNOWN_DEFINE_WARNING);
    public static final DiagnosticGroup TWEAKS = DiagnosticGroups.registerGroup("tweakValidation", ProcessTweaks.INVALID_TWEAK_DEFAULT_VALUE_WARNING, ProcessTweaks.TWEAK_WRONG_GETTER_TYPE_WARNING, ProcessTweaks.UNKNOWN_TWEAK_WARNING);
    public static final DiagnosticGroup MISSING_OVERRIDE = DiagnosticGroups.registerGroup("missingOverride", TypeCheck.HIDDEN_INTERFACE_PROPERTY, TypeCheck.HIDDEN_SUPERCLASS_PROPERTY);
    public static final DiagnosticGroup MISSING_PROPERTIES = DiagnosticGroups.registerGroup("missingProperties", TypeCheck.INEXISTENT_PROPERTY, TypeCheck.INEXISTENT_PROPERTY_WITH_SUGGESTION, TypeCheck.POSSIBLE_INEXISTENT_PROPERTY);
    public static final DiagnosticGroup J2CL_CHECKS = DiagnosticGroups.registerGroup("j2clChecks", J2clChecksPass.J2CL_REFERENCE_EQUALITY);
    public static final DiagnosticGroup MISSING_RETURN = DiagnosticGroups.registerGroup("missingReturn", CheckMissingReturn.MISSING_RETURN_STATEMENT);
    public static final DiagnosticGroup INTERNET_EXPLORER_CHECKS = DiagnosticGroups.registerGroup("internetExplorerChecks", RhinoErrorReporter.TRAILING_COMMA);
    public static final DiagnosticGroup UNDEFINED_VARIABLES = DiagnosticGroups.registerGroup("undefinedVars", VarCheck.UNDEFINED_VAR_ERROR);
    public static final DiagnosticGroup UNDEFINED_NAMES = DiagnosticGroups.registerGroup("undefinedNames", CheckGlobalNames.UNDEFINED_NAME_WARNING);
    public static final DiagnosticGroup DEBUGGER_STATEMENT_PRESENT = DiagnosticGroups.registerGroup("checkDebuggerStatement", CheckDebuggerStatement.DEBUGGER_STATEMENT_PRESENT);
    public static final DiagnosticGroup CHECK_REGEXP = DiagnosticGroups.registerGroup("checkRegExp", CheckRegExp.REGEXP_REFERENCE, CheckRegExp.MALFORMED_REGEXP);
    public static final DiagnosticGroup CHECK_TYPES = DiagnosticGroups.registerGroup("checkTypes", TypeValidator.ALL_DIAGNOSTICS, TypeCheck.ALL_DIAGNOSTICS, FunctionTypeBuilder.ALL_DIAGNOSTICS, GLOBAL_THIS);
    public static final DiagnosticGroup NEW_CHECK_TYPES_COMPATIBILITY_MODE = DiagnosticGroups.registerDeprecatedGroup("newCheckTypesCompatibility");
    public static final DiagnosticGroup NEW_CHECK_TYPES_EXTRA_CHECKS = DiagnosticGroups.registerDeprecatedGroup("newCheckTypesExtraChecks");
    public static final DiagnosticGroup NEW_CHECK_TYPES = DiagnosticGroups.registerDeprecatedGroup("newCheckTypes");
    public static final DiagnosticGroup NEW_CHECK_TYPES_ALL_CHECKS = DiagnosticGroups.registerDeprecatedGroup("newCheckTypesAllChecks");
    public static final DiagnosticGroup TOO_MANY_TYPE_PARAMS = DiagnosticGroups.registerGroup("tooManyTypeParams", RhinoErrorReporter.TOO_MANY_TEMPLATE_PARAMS);
    @Deprecated
    public static final DiagnosticGroup CHECK_EVENTFUL_OBJECT_DISPOSAL = DiagnosticGroups.registerDeprecatedGroup("checkEventfulObjectDisposal");
    public static final DiagnosticGroup OLD_REPORT_UNKNOWN_TYPES = DiagnosticGroups.registerGroup("oldReportUnknownTypes", TypeCheck.UNKNOWN_EXPR_TYPE);
    public static final DiagnosticGroup STRICT_MISSING_PROPERTIES = DiagnosticGroups.registerGroup("strictMissingProperties", TypeCheck.STRICT_INEXISTENT_PROPERTY, TypeCheck.STRICT_INEXISTENT_PROPERTY_WITH_SUGGESTION, TypeCheck.STRICT_INEXISTENT_UNION_PROPERTY);
    public static final DiagnosticGroup STRICT_PRIMITIVE_OPERATORS = DiagnosticGroups.registerGroup("strictPrimitiveOperators", TypeValidator.INVALID_OPERAND_TYPE);
    public static final DiagnosticGroup STRICT_CHECK_TYPES = DiagnosticGroups.registerGroup("strictCheckTypes", STRICT_MISSING_PROPERTIES, STRICT_PRIMITIVE_OPERATORS);
    public static final DiagnosticGroup REPORT_UNKNOWN_TYPES = DiagnosticGroups.registerGroup("reportUnknownTypes", TypeCheck.UNKNOWN_EXPR_TYPE);
    public static final DiagnosticGroup CHECK_VARIABLES = DiagnosticGroups.registerGroup("checkVars", VarCheck.UNDEFINED_VAR_ERROR, VarCheck.VAR_MULTIPLY_DECLARED_ERROR, VariableReferenceCheck.EARLY_REFERENCE, VariableReferenceCheck.REDECLARED_VARIABLE);
    public static final DiagnosticGroup CHECK_USELESS_CODE = DiagnosticGroups.registerGroup("uselessCode", CheckSideEffects.USELESS_CODE_ERROR, CheckUnreachableCode.UNREACHABLE_CODE);
    public static final DiagnosticGroup CONST = DiagnosticGroups.registerGroup("const", CheckAccessControls.CONST_PROPERTY_DELETED, CheckAccessControls.CONST_PROPERTY_REASSIGNED_VALUE, ConstCheck.CONST_REASSIGNED_VALUE_ERROR);
    static final DiagnosticGroup ACCESS_CONTROLS_CONST = DiagnosticGroups.registerGroup("accessControlsConst", CheckAccessControls.CONST_PROPERTY_DELETED, CheckAccessControls.CONST_PROPERTY_REASSIGNED_VALUE);
    public static final DiagnosticGroup CONSTANT_PROPERTY = DiagnosticGroups.registerGroup("constantProperty", CheckAccessControls.CONST_PROPERTY_DELETED, CheckAccessControls.CONST_PROPERTY_REASSIGNED_VALUE);
    public static final DiagnosticGroup TYPE_INVALIDATION = DiagnosticGroups.registerGroup("typeInvalidation", DisambiguateProperties.Warnings.INVALIDATION, DisambiguateProperties.Warnings.INVALIDATION_ON_TYPE);
    public static final DiagnosticGroup DUPLICATE_VARS = DiagnosticGroups.registerGroup("duplicate", CollapseProperties.NAMESPACE_REDEFINED_WARNING, VarCheck.VAR_MULTIPLY_DECLARED_ERROR, TypeValidator.DUP_VAR_DECLARATION, TypeValidator.DUP_VAR_DECLARATION_TYPE_MISMATCH, TypeCheck.FUNCTION_MASKS_VARIABLE, VariableReferenceCheck.REDECLARED_VARIABLE);
    public static final DiagnosticGroup ES3 = DiagnosticGroups.registerGroup("es3", RhinoErrorReporter.INVALID_ES3_PROP_NAME, RhinoErrorReporter.TRAILING_COMMA);
    static final DiagnosticGroup ES5_STRICT_UNCOMMON = DiagnosticGroups.registerGroup("es5StrictUncommon", RhinoErrorReporter.INVALID_OCTAL_LITERAL, RhinoErrorReporter.DUPLICATE_PARAM, StrictModeCheck.USE_OF_WITH, StrictModeCheck.EVAL_DECLARATION, StrictModeCheck.EVAL_ASSIGNMENT, StrictModeCheck.ARGUMENTS_DECLARATION, StrictModeCheck.ARGUMENTS_ASSIGNMENT, StrictModeCheck.DELETE_VARIABLE, StrictModeCheck.DUPLICATE_OBJECT_KEY);
    static final DiagnosticGroup ES5_STRICT_REFLECTION = DiagnosticGroups.registerGroup("es5StrictReflection", StrictModeCheck.ARGUMENTS_CALLEE_FORBIDDEN, StrictModeCheck.ARGUMENTS_CALLER_FORBIDDEN, StrictModeCheck.FUNCTION_CALLER_FORBIDDEN, StrictModeCheck.FUNCTION_ARGUMENTS_PROP_FORBIDDEN);
    public static final DiagnosticGroup ES5_STRICT = DiagnosticGroups.registerGroup("es5Strict", ES5_STRICT_UNCOMMON, ES5_STRICT_REFLECTION);
    public static final DiagnosticGroup MISSING_PROVIDE = DiagnosticGroups.registerGroup("missingProvide", CheckProvides.MISSING_PROVIDE_WARNING, ClosureRewriteModule.MISSING_MODULE_OR_PROVIDE);
    public static final DiagnosticGroup UNRECOGNIZED_TYPE_ERROR = DiagnosticGroups.registerGroup("unrecognizedTypeError", RhinoErrorReporter.UNRECOGNIZED_TYPE_ERROR);
    public static final DiagnosticGroup MISSING_REQUIRE = DiagnosticGroups.registerGroup("missingRequire", CheckMissingAndExtraRequires.MISSING_REQUIRE_WARNING);
    public static final DiagnosticGroup MISSING_SOURCES_WARNINGS = DiagnosticGroups.registerGroup("missingSourcesWarnings", REPORT_UNKNOWN_TYPES, UNDEFINED_NAMES, UNDEFINED_VARIABLES, MISSING_PROVIDE, DiagnosticGroup.forType(FunctionTypeBuilder.RESOLVED_TAG_EMPTY), DiagnosticGroup.forType(ProcessClosurePrimitives.MISSING_PROVIDE_ERROR), MISSING_PROPERTIES, DUPLICATE_VARS, DiagnosticGroup.forType(ProcessDefines.INVALID_DEFINE_INIT_ERROR), DiagnosticGroup.forType(Es6ExternsCheck.MISSING_ES6_EXTERNS), DiagnosticGroup.forType(ModuleLoader.LOAD_WARNING));
    public static final DiagnosticGroup STRICT_MISSING_REQUIRE = DiagnosticGroups.registerGroup("strictMissingRequire", CheckMissingAndExtraRequires.MISSING_REQUIRE_WARNING, CheckMissingAndExtraRequires.MISSING_REQUIRE_FOR_GOOG_SCOPE, CheckMissingAndExtraRequires.MISSING_REQUIRE_STRICT_WARNING);
    public static final DiagnosticGroup STRICT_REQUIRES = DiagnosticGroups.registerGroup("legacyGoogScopeRequire", CheckMissingAndExtraRequires.MISSING_REQUIRE_FOR_GOOG_SCOPE, CheckMissingAndExtraRequires.EXTRA_REQUIRE_WARNING);
    public static final DiagnosticGroup EXTRA_REQUIRE = DiagnosticGroups.registerGroup("extraRequire", CheckMissingAndExtraRequires.EXTRA_REQUIRE_WARNING);
    @GwtIncompatible(value="java.util.regex")
    public static final DiagnosticGroup MISSING_GETCSSNAME = DiagnosticGroups.registerGroup("missingGetCssName", CheckMissingGetCssName.MISSING_GETCSSNAME);
    @GwtIncompatible(value="JsMessage")
    public static final DiagnosticGroup DUPLICATE_MESSAGE = DiagnosticGroups.registerGroup("duplicateMessage", JsMessageVisitor.MESSAGE_DUPLICATE_KEY);
    @GwtIncompatible(value="JsMessage")
    public static final DiagnosticGroup MESSAGE_DESCRIPTIONS = DiagnosticGroups.registerGroup("msgDescriptions", JsMessageVisitor.MESSAGE_HAS_NO_DESCRIPTION);
    @GwtIncompatible(value="JsMessage")
    public static final DiagnosticGroup MSG_CONVENTIONS = DiagnosticGroups.registerGroup("messageConventions", JsMessageVisitor.MESSAGE_HAS_NO_DESCRIPTION, JsMessageVisitor.MESSAGE_HAS_NO_TEXT, JsMessageVisitor.MESSAGE_TREE_MALFORMED, JsMessageVisitor.MESSAGE_HAS_NO_VALUE, JsMessageVisitor.MESSAGE_DUPLICATE_KEY, JsMessageVisitor.MESSAGE_NOT_INITIALIZED_USING_NEW_SYNTAX);
    public static final DiagnosticGroup MISPLACED_TYPE_ANNOTATION = DiagnosticGroups.registerGroup("misplacedTypeAnnotation", CheckJSDoc.ARROW_FUNCTION_AS_CONSTRUCTOR, CheckJSDoc.DEFAULT_PARAM_MUST_BE_MARKED_OPTIONAL, CheckJSDoc.DISALLOWED_MEMBER_JSDOC, CheckJSDoc.INVALID_NO_SIDE_EFFECT_ANNOTATION, CheckJSDoc.INVALID_MODIFIES_ANNOTATION, CheckJSDoc.MISPLACED_ANNOTATION, CheckJSDoc.MISPLACED_MSG_ANNOTATION);
    public static final DiagnosticGroup MISPLACED_MSG_ANNOTATION = DiagnosticGroups.registerGroup("misplacedMsgAnnotation", CheckJSDoc.MISPLACED_MSG_ANNOTATION);
    public static final DiagnosticGroup MISPLACED_SUPPRESS = DiagnosticGroups.registerGroup("misplacedSuppress", CheckJSDoc.MISPLACED_SUPPRESS);
    public static final DiagnosticGroup SUSPICIOUS_CODE = DiagnosticGroups.registerGroup("suspiciousCode", CheckDuplicateCase.DUPLICATE_CASE, CheckSuspiciousCode.SUSPICIOUS_SEMICOLON, CheckSuspiciousCode.SUSPICIOUS_COMPARISON_WITH_NAN, CheckSuspiciousCode.SUSPICIOUS_IN_OPERATOR, CheckSuspiciousCode.SUSPICIOUS_INSTANCEOF_LEFT_OPERAND, CheckSuspiciousCode.SUSPICIOUS_NEGATED_LEFT_OPERAND_OF_IN_OPERATOR, TypeCheck.DETERMINISTIC_TEST, ProcessCommonJSModules.SUSPICIOUS_EXPORTS_ASSIGNMENT);
    public static final DiagnosticGroup FUNCTION_PARAMS = DiagnosticGroups.registerGroup("functionParams", FunctionTypeBuilder.INEXISTENT_PARAM, FunctionTypeBuilder.OPTIONAL_ARG_AT_END);
    public static final DiagnosticGroup DEPRECATED_ANNOTATIONS = DiagnosticGroups.registerGroup("deprecatedAnnotations", CheckJSDoc.ANNOTATION_DEPRECATED);
    public static final DiagnosticGroup UNUSED_PRIVATE_PROPERTY = DiagnosticGroups.registerGroup("unusedPrivateMembers", CheckUnusedPrivateProperties.UNUSED_PRIVATE_PROPERTY);
    public static final DiagnosticGroup UNUSED_LOCAL_VARIABLE = DiagnosticGroups.registerGroup("unusedLocalVariables", VariableReferenceCheck.UNUSED_LOCAL_ASSIGNMENT);
    public static final DiagnosticGroup MISSING_CONST_PROPERTY = DiagnosticGroups.registerGroup("jsdocMissingConst", CheckConstPrivateProperties.MISSING_CONST_PROPERTY);
    public static final DiagnosticGroup JSDOC_MISSING_TYPE = DiagnosticGroups.registerGroup("jsdocMissingType", RhinoErrorReporter.JSDOC_MISSING_TYPE_WARNING);
    public static final DiagnosticGroup UNNECESSARY_ESCAPE = DiagnosticGroups.registerGroup("unnecessaryEscape", RhinoErrorReporter.UNNECESSARY_ESCAPE);
    public static final DiagnosticGroup LINT_CHECKS = DiagnosticGroups.registerGroup("lintChecks", CheckJSDocStyle.ALL_DIAGNOSTICS, new DiagnosticGroup(CheckEmptyStatements.USELESS_EMPTY_STATEMENT, CheckEnums.COMPUTED_PROP_NAME_IN_ENUM, CheckEnums.DUPLICATE_ENUM_VALUE, CheckEnums.ENUM_PROP_NOT_CONSTANT, CheckEnums.SHORTHAND_ASSIGNMENT_IN_ENUM, CheckInterfaces.INTERFACE_FUNCTION_NOT_EMPTY, CheckInterfaces.INTERFACE_SHOULD_NOT_TAKE_ARGS, CheckMissingSemicolon.MISSING_SEMICOLON, CheckPrimitiveAsObject.NEW_PRIMITIVE_OBJECT, CheckPrimitiveAsObject.PRIMITIVE_OBJECT_DECLARATION, CheckPrototypeProperties.ILLEGAL_PROTOTYPE_MEMBER, CheckRedundantNullabilityModifier.REDUNDANT_NULLABILITY_MODIFIER_JSDOC, CheckRequiresAndProvidesSorted.DUPLICATE_REQUIRE, CheckRequiresAndProvidesSorted.REQUIRES_NOT_SORTED, CheckRequiresAndProvidesSorted.PROVIDES_NOT_SORTED, CheckRequiresAndProvidesSorted.PROVIDES_AFTER_REQUIRES, CheckUnusedLabels.UNUSED_LABEL, CheckUselessBlocks.USELESS_BLOCK, ClosureCheckModule.DECLARE_LEGACY_NAMESPACE_IN_NON_MODULE, ClosureCheckModule.GOOG_MODULE_IN_NON_MODULE, ClosureCheckModule.INCORRECT_SHORTNAME_CAPITALIZATION, ClosureCheckModule.LET_GOOG_REQUIRE, ClosureCheckModule.JSDOC_REFERENCE_TO_FULLY_QUALIFIED_IMPORT_NAME, ClosureCheckModule.JSDOC_REFERENCE_TO_SHORT_IMPORT_BY_LONG_NAME_INCLUDING_SHORT_NAME, ClosureCheckModule.REFERENCE_TO_FULLY_QUALIFIED_IMPORT_NAME, ClosureCheckModule.REFERENCE_TO_SHORT_IMPORT_BY_LONG_NAME_INCLUDING_SHORT_NAME, ClosureRewriteModule.USELESS_USE_STRICT_DIRECTIVE, RhinoErrorReporter.JSDOC_MISSING_BRACES_WARNING));
    static final DiagnosticGroup STRICT_MODULE_CHECKS = DiagnosticGroups.registerGroup("strictModuleChecks", ClosureCheckModule.AT_EXPORT_IN_NON_LEGACY_GOOG_MODULE, ClosureCheckModule.LET_GOOG_REQUIRE, ClosureCheckModule.JSDOC_REFERENCE_TO_FULLY_QUALIFIED_IMPORT_NAME, ClosureCheckModule.JSDOC_REFERENCE_TO_SHORT_IMPORT_BY_LONG_NAME_INCLUDING_SHORT_NAME, ClosureCheckModule.REFERENCE_TO_FULLY_QUALIFIED_IMPORT_NAME, ClosureCheckModule.REFERENCE_TO_SHORT_IMPORT_BY_LONG_NAME_INCLUDING_SHORT_NAME);
    static final DiagnosticGroup ANALYZER_CHECKS_INTERNAL = DiagnosticGroups.registerGroup("analyzerChecksInternal", CheckArrayWithGoogObject.ARRAY_PASSED_TO_GOOG_OBJECT, CheckNullableReturn.NULLABLE_RETURN, CheckNullableReturn.NULLABLE_RETURN_WITH_NAME, ImplicitNullabilityCheck.IMPLICITLY_NULLABLE_JSDOC);
    public static final DiagnosticGroup ANALYZER_CHECKS = DiagnosticGroups.registerGroup("analyzerChecks", ANALYZER_CHECKS_INTERNAL, UNUSED_PRIVATE_PROPERTY, MISSING_CONST_PROPERTY);
    public static final DiagnosticGroup USE_OF_GOOG_BASE = DiagnosticGroups.registerGroup("useOfGoogBase", ProcessClosurePrimitives.USE_OF_GOOG_BASE);
    public static final DiagnosticGroup CLOSURE_DEP_METHOD_USAGE_CHECKS = DiagnosticGroups.registerGroup("closureDepMethodUsageChecks", ProcessClosurePrimitives.INVALID_CLOSURE_CALL_ERROR);
    @GwtIncompatible(value="Conformance")
    public static final DiagnosticGroup CONFORMANCE_VIOLATIONS;
    public static final DiagnosticGroup LATE_PROVIDE;
    public static final DiagnosticGroup MISSING_POLYFILL;

    static DiagnosticGroup registerDeprecatedGroup(String name) {
        return DiagnosticGroups.registerGroup(name, new DiagnosticGroup(name, UNUSED));
    }

    static DiagnosticGroup registerGroup(String name, DiagnosticGroup group) {
        groupsByName.put(name, group);
        return group;
    }

    static DiagnosticGroup registerGroup(String name, DiagnosticType ... types) {
        DiagnosticGroup group = new DiagnosticGroup(name, types);
        groupsByName.put(name, group);
        return group;
    }

    static DiagnosticGroup registerGroup(String name, DiagnosticGroup ... groups) {
        DiagnosticGroup group = new DiagnosticGroup(name, groups);
        groupsByName.put(name, group);
        return group;
    }

    public Map<String, DiagnosticGroup> getRegisteredGroups() {
        return ImmutableMap.copyOf(groupsByName);
    }

    public DiagnosticGroup forName(String name) {
        return groupsByName.get(name);
    }

    public void setWarningLevel(CompilerOptions options, String name, CheckLevel level) {
        DiagnosticGroup group = this.forName(name);
        Preconditions.checkNotNull(group, "No warning class for name: %s", (Object)name);
        options.setWarningLevel(group, level);
    }

    static {
        DiagnosticGroups.registerGroup("transitionalSuspiciousCodeWarnings", PeepholeFoldConstants.INDEX_OUT_OF_BOUNDS_ERROR, PeepholeFoldConstants.NEGATING_A_NON_NUMBER_ERROR, PeepholeFoldConstants.FRACTIONAL_BITWISE_OPERAND);
        CONFORMANCE_VIOLATIONS = DiagnosticGroups.registerGroup("conformanceViolations", CheckConformance.CONFORMANCE_VIOLATION, CheckConformance.CONFORMANCE_POSSIBLE_VIOLATION);
        LATE_PROVIDE = DiagnosticGroups.registerGroup("lateProvide", ProcessClosurePrimitives.LATE_PROVIDE_ERROR);
        MISSING_POLYFILL = DiagnosticGroups.registerGroup("missingPolyfill", RewritePolyfills.INSUFFICIENT_OUTPUT_VERSION_ERROR);
        DiagnosticGroups.registerGroup("invalidProvide", ProcessClosurePrimitives.INVALID_PROVIDE_ERROR);
        DiagnosticGroups.registerGroup("es6Typed", RhinoErrorReporter.MISPLACED_TYPE_SYNTAX);
        DiagnosticGroups.registerDeprecatedGroup("duplicateZipContents");
    }
}

