/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Supplier;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.CodingConvention;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.rhino.IR;
import com.google.javascript.rhino.Node;
import com.google.javascript.rhino.Token;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

class FunctionArgumentInjector {
    static final String THIS_MARKER = "this";
    static final String REST_MARKER = "rest param";
    static final String DEFAULT_MARKER = "Default Value";
    static final String OBJECT_PATTERN_MARKER = "object pattern";

    private FunctionArgumentInjector() {
    }

    static Node inject(AbstractCompiler compiler, Node node, Node parent, Map<String, Node> replacements) {
        return FunctionArgumentInjector.inject(compiler, node, parent, replacements, true);
    }

    private static Node inject(AbstractCompiler compiler, Node node, Node parent, Map<String, Node> replacements, boolean replaceThis) {
        Node replacementTemplate;
        if (node.isName()) {
            replacementTemplate = replacements.get(node.getString());
            if (replacementTemplate != null) {
                Preconditions.checkState(!parent.isFunction() && !parent.isVar() && !parent.isCatch(), parent);
                Node replacement = replacementTemplate.cloneTree();
                parent.replaceChild(node, replacement);
                return replacement;
            }
        } else if (replaceThis && node.isThis()) {
            replacementTemplate = replacements.get(THIS_MARKER);
            Preconditions.checkNotNull(replacementTemplate);
            if (!replacementTemplate.isThis()) {
                Node replacement = replacementTemplate.cloneTree();
                parent.replaceChild(node, replacement);
                if (NodeUtil.mayHaveSideEffects(replacementTemplate, compiler)) {
                    replacements.remove(THIS_MARKER);
                }
                return replacement;
            }
        } else if (node.isFunction() && !node.isArrowFunction()) {
            replaceThis = false;
        }
        for (Node c = node.getFirstChild(); c != null; c = c.getNext()) {
            c = FunctionArgumentInjector.inject(compiler, c, node, replacements, replaceThis);
        }
        return node;
    }

    static ImmutableMap<String, Node> getFunctionCallParameterMap(Node fnNode, Node callNode, Supplier<String> safeNameIdSupplier) {
        Preconditions.checkNotNull(fnNode);
        ImmutableMap.Builder<String, Node> argMap = ImmutableMap.builder();
        Node cArg = callNode.getSecondChild();
        if (cArg != null && NodeUtil.isFunctionObjectCall(callNode)) {
            argMap.put(THIS_MARKER, cArg);
            cArg = cArg.getNext();
        } else {
            Preconditions.checkState(!NodeUtil.isFunctionObjectApply(callNode), callNode);
            argMap.put(THIS_MARKER, NodeUtil.newUndefinedNode(callNode));
        }
        for (Node fnParam : NodeUtil.getFunctionParameters(fnNode).children()) {
            Node array;
            if (cArg != null) {
                if (fnParam.isRest()) {
                    Preconditions.checkState(fnParam.getOnlyChild().isName(), fnParam.getOnlyChild());
                    array = IR.arraylit(new Node[0]);
                    array.useSourceInfoIfMissingFromForTree(cArg);
                    while (cArg != null) {
                        array.addChildToBack(cArg.cloneTree());
                        cArg = cArg.getNext();
                    }
                    argMap.put(fnParam.getOnlyChild().getString(), array);
                    return argMap.build();
                }
                Preconditions.checkState(fnParam.isName(), fnParam);
                argMap.put(fnParam.getString(), cArg);
                cArg = cArg.getNext();
                continue;
            }
            if (fnParam.isRest()) {
                Preconditions.checkState(fnParam.getOnlyChild().isName(), fnParam);
                array = IR.arraylit(new Node[0]);
                argMap.put(fnParam.getOnlyChild().getString(), array);
                continue;
            }
            Preconditions.checkState(fnParam.isName(), fnParam);
            Node srcLocation = callNode;
            argMap.put(fnParam.getString(), NodeUtil.newUndefinedNode(srcLocation));
        }
        while (cArg != null) {
            String uniquePlaceholder = FunctionArgumentInjector.getUniqueAnonymousParameterName(safeNameIdSupplier);
            argMap.put(uniquePlaceholder, cArg);
            cArg = cArg.getNext();
        }
        return argMap.build();
    }

    private static String getUniqueAnonymousParameterName(Supplier<String> safeNameIdSupplier) {
        return "JSCompiler_inline_anon_param_" + safeNameIdSupplier.get();
    }

    static Set<String> findModifiedParameters(Node fnNode) {
        ImmutableSet<String> names = FunctionArgumentInjector.getFunctionParameterSet(fnNode);
        HashSet<String> unsafeNames = new HashSet<String>();
        return FunctionArgumentInjector.findModifiedParameters(fnNode.getLastChild(), names, unsafeNames, false);
    }

    private static Set<String> findModifiedParameters(Node n, ImmutableSet<String> names, Set<String> unsafe, boolean inInnerFunction) {
        Preconditions.checkArgument(unsafe != null);
        if (n.isName()) {
            if (names.contains(n.getString()) && (inInnerFunction || FunctionArgumentInjector.canNameValueChange(n))) {
                unsafe.add(n.getString());
            }
        } else if (n.isFunction()) {
            inInnerFunction = true;
        }
        for (Node c : n.children()) {
            FunctionArgumentInjector.findModifiedParameters(c, names, unsafe, inInnerFunction);
        }
        return unsafe;
    }

    private static boolean canNameValueChange(Node n) {
        return NodeUtil.isLValue(n) && !NodeUtil.getEnclosingStatement(n).isConst() && !NodeUtil.getEnclosingStatement(n).isLet();
    }

    static void maybeAddTempsForCallArguments(Node fnNode, ImmutableMap<String, Node> argMap, Set<String> namesNeedingTemps, CodingConvention convention) {
        if (argMap.isEmpty()) {
            return;
        }
        Preconditions.checkArgument(fnNode.isFunction(), fnNode);
        Node block = fnNode.getLastChild();
        int argCount = argMap.size();
        boolean isTrivialBody = !block.hasChildren() || block.hasOneChild() && !FunctionArgumentInjector.bodyMayHaveConditionalCode(block.getLastChild());
        boolean hasMinimalParameters = NodeUtil.isUndefined(argMap.get(THIS_MARKER)) && argCount <= 2;
        ImmutableSet<String> namesAfterSideEffects = FunctionArgumentInjector.findParametersReferencedAfterSideEffect((ImmutableSet<String>)argMap.keySet(), block);
        for (Map.Entry entry : argMap.entrySet()) {
            String argName = (String)entry.getKey();
            if (namesNeedingTemps.contains(argName)) continue;
            Node cArg = (Node)entry.getValue();
            boolean safe = true;
            int references = NodeUtil.getNameReferenceCount(block, argName);
            boolean argSideEffects = NodeUtil.mayHaveSideEffects(cArg);
            if (!argSideEffects && references == 0) {
                safe = true;
            } else if (isTrivialBody && hasMinimalParameters && references == 1 && (!NodeUtil.canBeSideEffected(cArg) || !namesAfterSideEffects.contains(argName))) {
                safe = true;
            } else if (NodeUtil.mayEffectMutableState(cArg) && references > 0) {
                safe = false;
            } else if (argSideEffects) {
                safe = false;
            } else if (NodeUtil.canBeSideEffected(cArg) && namesAfterSideEffects.contains(argName)) {
                safe = false;
            } else if (references > 1) {
                switch (cArg.getToken()) {
                    case NAME: {
                        String name = cArg.getString();
                        safe = !convention.isExported(name);
                        break;
                    }
                    case THIS: {
                        safe = true;
                        break;
                    }
                    case STRING: {
                        safe = cArg.getString().length() < 2;
                        break;
                    }
                    default: {
                        safe = NodeUtil.isImmutableValue(cArg);
                    }
                }
            }
            if (safe) continue;
            namesNeedingTemps.add(argName);
        }
    }

    static boolean bodyMayHaveConditionalCode(Node n) {
        if (!n.isReturn() && !n.isExprResult()) {
            return true;
        }
        return FunctionArgumentInjector.mayHaveConditionalCode(n);
    }

    static boolean mayHaveConditionalCode(Node n) {
        for (Node c = n.getFirstChild(); c != null; c = c.getNext()) {
            switch (c.getToken()) {
                case FUNCTION: 
                case AND: 
                case OR: 
                case HOOK: {
                    return true;
                }
            }
            if (!FunctionArgumentInjector.mayHaveConditionalCode(c)) continue;
            return true;
        }
        return false;
    }

    private static ImmutableSet<String> findParametersReferencedAfterSideEffect(ImmutableSet<String> parameters, Node root) {
        HashSet<String> locals = new HashSet<String>(parameters);
        FunctionArgumentInjector.gatherLocalNames(root, locals);
        ReferencedAfterSideEffect collector = new ReferencedAfterSideEffect(parameters, ImmutableSet.copyOf(locals));
        NodeUtil.visitPostOrder(root, collector, collector);
        return collector.getResults();
    }

    private static void gatherLocalNames(Node n, Set<String> names) {
        if (n.isFunction()) {
            if (NodeUtil.isFunctionDeclaration(n)) {
                names.add(n.getFirstChild().getString());
            }
            return;
        }
        if (n.isName()) {
            switch (n.getParent().getToken()) {
                case VAR: 
                case LET: 
                case CONST: 
                case CATCH: {
                    names.add(n.getString());
                    break;
                }
            }
        }
        for (Node c = n.getFirstChild(); c != null; c = c.getNext()) {
            FunctionArgumentInjector.gatherLocalNames(c, names);
        }
    }

    private static ImmutableSet<String> getFunctionParameterSet(Node fnNode) {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        for (Node n : NodeUtil.getFunctionParameters(fnNode).children()) {
            if (n.isRest()) {
                builder.add(REST_MARKER);
                continue;
            }
            if (n.isDefaultValue() || n.isObjectPattern() || n.isArrayPattern()) {
                throw new IllegalStateException("Not supported: " + n);
            }
            builder.add(n.getString());
        }
        return builder.build();
    }

    private static class ReferencedAfterSideEffect
    implements NodeUtil.Visitor,
    Predicate<Node> {
        private final ImmutableSet<String> parameters;
        private final ImmutableSet<String> locals;
        private boolean sideEffectSeen = false;
        private final Set<String> parametersReferenced = new HashSet<String>();
        private int loopsEntered = 0;

        ReferencedAfterSideEffect(ImmutableSet<String> parameters, ImmutableSet<String> locals) {
            this.parameters = parameters;
            this.locals = locals;
        }

        ImmutableSet<String> getResults() {
            return ImmutableSet.copyOf(this.parametersReferenced);
        }

        @Override
        public boolean apply(Node node) {
            if (NodeUtil.isLoopStructure(node)) {
                ++this.loopsEntered;
            }
            return !this.sideEffectSeen || this.parameters.size() != this.parametersReferenced.size();
        }

        boolean inLoop() {
            return this.loopsEntered != 0;
        }

        @Override
        public void visit(Node n) {
            if (NodeUtil.isLoopStructure(n)) {
                --this.loopsEntered;
                if (!this.inLoop() && !this.sideEffectSeen) {
                    this.parametersReferenced.clear();
                }
            }
            if (!this.sideEffectSeen && this.hasNonLocalSideEffect(n)) {
                this.sideEffectSeen = true;
            }
            if (this.inLoop() || this.sideEffectSeen) {
                if (n.isName()) {
                    String name = n.getString();
                    if (this.parameters.contains(name)) {
                        this.parametersReferenced.add(name);
                    }
                } else if (n.isThis()) {
                    this.parametersReferenced.add(FunctionArgumentInjector.THIS_MARKER);
                }
            }
        }

        private boolean hasNonLocalSideEffect(Node n) {
            boolean sideEffect = false;
            Token type = n.getToken();
            if (NodeUtil.isAssignmentOp(n) || type == Token.INC || type == Token.DEC) {
                Node lhs = n.getFirstChild();
                if (!this.isLocalName(lhs)) {
                    sideEffect = true;
                }
            } else if (type == Token.CALL) {
                sideEffect = NodeUtil.functionCallHasSideEffects(n);
            } else if (type == Token.NEW) {
                sideEffect = NodeUtil.constructorCallHasSideEffects(n);
            } else if (type == Token.DELPROP) {
                sideEffect = true;
            }
            return sideEffect;
        }

        private boolean isLocalName(Node node) {
            if (node.isName()) {
                String name = node.getString();
                return this.locals.contains(name);
            }
            return false;
        }
    }
}

