/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp.deps;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.javascript.jscomp.CheckLevel;
import com.google.javascript.jscomp.DiagnosticType;
import com.google.javascript.jscomp.ErrorHandler;
import com.google.javascript.jscomp.JSError;
import com.google.javascript.jscomp.deps.BrowserModuleResolver;
import com.google.javascript.jscomp.deps.DependencyInfo;
import com.google.javascript.jscomp.deps.ModuleNames;
import com.google.javascript.jscomp.deps.ModuleResolver;
import java.nio.file.Paths;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Map;
import java.util.TreeSet;
import javax.annotation.Nullable;

public final class ModuleLoader {
    public static final DiagnosticType MODULE_CONFLICT = DiagnosticType.warning("JSC_MODULE_CONFLICT", "File cannot be a combination of goog.provide, goog.module, and/or ES6 module: {0}");
    public static final String MODULE_SLASH = "/";
    public static final String DEFAULT_FILENAME_PREFIX = "./";
    public static final String JSC_BROWSER_BLACKLISTED_MARKER = "$jscomp$browser$blacklisted";
    public static final DiagnosticType LOAD_WARNING = DiagnosticType.error("JSC_JS_MODULE_LOAD_WARNING", "Failed to load module \"{0}\"");
    public static final DiagnosticType INVALID_MODULE_PATH = DiagnosticType.error("JSC_INVALID_MODULE_PATH", "Invalid module path \"{0}\" for resolution mode \"{1}\"");
    private ErrorHandler errorHandler;
    private final ImmutableList<String> moduleRootPaths;
    private final ImmutableSet<String> modulePaths;
    private final PathResolver pathResolver;
    private final PathEscaper pathEscaper;
    private final ModuleResolver moduleResolver;
    public static final ModuleLoader EMPTY = new ModuleLoader(null, ImmutableList.of(), ImmutableList.of(), BrowserModuleResolver.FACTORY);

    public ModuleLoader(@Nullable ErrorHandler errorHandler, Iterable<String> moduleRoots, Iterable<? extends DependencyInfo> inputs, ModuleResolverFactory factory, PathResolver pathResolver, PathEscaper pathEscaper) {
        Preconditions.checkNotNull(moduleRoots);
        Preconditions.checkNotNull(inputs);
        Preconditions.checkNotNull(pathResolver);
        Preconditions.checkNotNull(pathEscaper);
        this.pathResolver = pathResolver;
        this.pathEscaper = pathEscaper;
        this.errorHandler = errorHandler == null ? new NoopErrorHandler() : errorHandler;
        this.moduleRootPaths = ModuleLoader.createRootPaths(moduleRoots, pathResolver, pathEscaper);
        this.modulePaths = ModuleLoader.resolvePaths(Iterables.transform(Iterables.transform(inputs, DependencyInfo::getName), pathResolver), this.moduleRootPaths, pathEscaper);
        this.moduleResolver = factory.create(this.modulePaths, this.moduleRootPaths, this.errorHandler, this.pathEscaper);
    }

    public ModuleLoader(@Nullable ErrorHandler errorHandler, Iterable<String> moduleRoots, Iterable<? extends DependencyInfo> inputs, ModuleResolverFactory factory, PathResolver pathResolver) {
        this(errorHandler, moduleRoots, inputs, factory, pathResolver, PathEscaper.ESCAPE);
    }

    public ModuleLoader(@Nullable ErrorHandler errorHandler, Iterable<String> moduleRoots, Iterable<? extends DependencyInfo> inputs, ModuleResolverFactory factory) {
        this(errorHandler, moduleRoots, inputs, factory, PathResolver.RELATIVE, PathEscaper.ESCAPE);
    }

    @VisibleForTesting
    public Map<String, String> getPackageJsonMainEntries() {
        return this.moduleResolver.getPackageJsonMainEntries();
    }

    public ModulePath resolve(String path) {
        return new ModulePath(ModuleLoader.normalize(this.pathEscaper.escape((String)this.pathResolver.apply(path)), this.moduleRootPaths));
    }

    public static boolean isRelativeIdentifier(String name) {
        return name.startsWith(DEFAULT_FILENAME_PREFIX) || name.startsWith("../");
    }

    public static boolean isAbsoluteIdentifier(String name) {
        return name.startsWith(MODULE_SLASH);
    }

    public static boolean isAmbiguousIdentifier(String name) {
        return !ModuleLoader.isAbsoluteIdentifier(name) && !ModuleLoader.isRelativeIdentifier(name);
    }

    public static boolean isPathIdentifier(String name) {
        return name.contains(MODULE_SLASH);
    }

    private static ImmutableList<String> createRootPaths(Iterable<String> roots, PathResolver resolver, PathEscaper escaper) {
        TreeSet<String> builder = new TreeSet<String>(Comparator.comparingInt(String::length).thenComparing(String::compareTo).reversed());
        for (String root : roots) {
            String rootModuleName = escaper.escape((String)resolver.apply(root));
            if (ModuleLoader.isAmbiguousIdentifier(rootModuleName)) {
                rootModuleName = MODULE_SLASH + rootModuleName;
            }
            builder.add(rootModuleName);
        }
        return ImmutableList.copyOf(builder);
    }

    private static ImmutableSet<String> resolvePaths(Iterable<String> modulePaths, Iterable<String> roots, PathEscaper escaper) {
        ImmutableSet.Builder resolved = ImmutableSet.builder();
        HashSet<String> knownPaths = new HashSet<String>();
        for (String name : modulePaths) {
            String canonicalizedPath = escaper.escape(name);
            if (!knownPaths.add(ModuleLoader.normalize(canonicalizedPath, roots))) {
                throw new IllegalArgumentException("Duplicate module path after resolving: " + name);
            }
            if (ModuleLoader.isAmbiguousIdentifier(canonicalizedPath)) {
                canonicalizedPath = MODULE_SLASH + canonicalizedPath;
            }
            resolved.add(canonicalizedPath);
        }
        return resolved.build();
    }

    static String normalize(String path, Iterable<String> moduleRootPaths) {
        String normalizedPath = path;
        if (ModuleLoader.isAmbiguousIdentifier(normalizedPath)) {
            normalizedPath = MODULE_SLASH + normalizedPath;
        }
        for (String moduleRoot : moduleRootPaths) {
            String trailing;
            if (!normalizedPath.startsWith(moduleRoot) || !(trailing = normalizedPath.substring(moduleRoot.length())).startsWith(MODULE_SLASH)) continue;
            return trailing.substring(MODULE_SLASH.length());
        }
        return path;
    }

    public void setErrorHandler(ErrorHandler errorHandler) {
        this.errorHandler = errorHandler == null ? new NoopErrorHandler() : errorHandler;
        this.moduleResolver.setErrorHandler(this.errorHandler);
    }

    public ErrorHandler getErrorHandler() {
        return this.errorHandler;
    }

    private static final class NoopErrorHandler
    implements ErrorHandler {
        private NoopErrorHandler() {
        }

        @Override
        public void report(CheckLevel level, JSError error) {
        }
    }

    public static enum ResolutionMode {
        BROWSER,
        BROWSER_WITH_TRANSFORMED_PREFIXES,
        NODE,
        WEBPACK;

    }

    @FunctionalInterface
    public static interface ModuleResolverFactory {
        public ModuleResolver create(ImmutableSet<String> var1, ImmutableList<String> var2, ErrorHandler var3, PathEscaper var4);
    }

    public static enum PathResolver implements Function<String, String>
    {
        RELATIVE{

            @Override
            public String apply(String path) {
                return path;
            }
        }
        ,
        ABSOLUTE{

            @Override
            public String apply(String path) {
                return Paths.get(path, new String[0]).toAbsolutePath().toString();
            }
        };

    }

    public static enum PathEscaper {
        ESCAPE{

            @Override
            public String escape(String path) {
                return ModuleNames.escapePath(path);
            }
        }
        ,
        CANONICALIZE_ONLY{

            @Override
            public String escape(String path) {
                return ModuleNames.canonicalizePath(path);
            }
        };


        public abstract String escape(String var1);
    }

    public class ModulePath {
        private final String path;

        private ModulePath(String path) {
            this.path = path;
        }

        public String toString() {
            return this.path;
        }

        public boolean equalsIgnoreLeadingSlash(ModulePath other) {
            return other != null && this.toModuleName().equals(other.toModuleName());
        }

        public String toJSIdentifier() {
            return ModuleNames.toJSIdentifier(this.path);
        }

        public String toModuleName() {
            return ModuleNames.toModuleName(this.path);
        }

        @Nullable
        public ModulePath resolveJsModule(String moduleAddress) {
            return this.resolveJsModule(moduleAddress, null, -1, -1);
        }

        @Nullable
        public ModulePath resolveJsModule(String moduleAddress, String sourcename, int lineno, int colno) {
            String loadAddress = ModuleLoader.this.moduleResolver.resolveJsModule(this.path, moduleAddress, sourcename, lineno, colno);
            if (loadAddress != null) {
                return new ModulePath(loadAddress);
            }
            return null;
        }

        public ModulePath resolveModuleAsPath(String moduleAddress) {
            return new ModulePath(ModuleLoader.this.moduleResolver.resolveModuleAsPath(this.path, moduleAddress));
        }
    }
}

