/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.base.Preconditions;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.AstFactory;
import com.google.javascript.jscomp.Es6ToEs3Util;
import com.google.javascript.jscomp.GlobalNamespace;
import com.google.javascript.jscomp.HotSwapCompilerPass;
import com.google.javascript.jscomp.JSError;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.jscomp.TranspilationPasses;
import com.google.javascript.jscomp.Var;
import com.google.javascript.jscomp.parsing.parser.FeatureSet;
import com.google.javascript.rhino.IR;
import com.google.javascript.rhino.Node;
import com.google.javascript.rhino.jstype.JSType;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.List;

public final class Es6ConvertSuperConstructorCalls
implements NodeTraversal.Callback,
HotSwapCompilerPass {
    private static final String TMP_ERROR = "$jscomp$tmp$error";
    private static final String SUPER_THIS = "$jscomp$super$this";
    private final AbstractCompiler compiler;
    private final Deque<ConstructorData> constructorDataStack;
    private final AstFactory astFactory;
    private GlobalNamespace globalNamespace;
    private static final FeatureSet transpiledFeatures = FeatureSet.BARE_MINIMUM.with(FeatureSet.Feature.SUPER);

    public Es6ConvertSuperConstructorCalls(AbstractCompiler compiler) {
        this.compiler = compiler;
        this.astFactory = compiler.createAstFactory();
        this.constructorDataStack = new ArrayDeque<ConstructorData>();
    }

    @Override
    public boolean shouldTraverse(NodeTraversal t, Node n, Node parent) {
        if (n.isFunction()) {
            this.constructorDataStack.push(new ConstructorData(n));
        } else if (n.isSuper()) {
            Node superCall;
            Node node = superCall = parent.isCall() ? parent : parent.getParent();
            if (!superCall.isCall() && parent.isGetProp()) {
                t.report(n, Es6ToEs3Util.CANNOT_CONVERT_YET, "super access with no extends clause");
                return false;
            }
            Preconditions.checkState(superCall.isCall(), superCall);
            ConstructorData constructorData = Preconditions.checkNotNull(this.constructorDataStack.peek());
            constructorData.superCalls.add(superCall);
        }
        return true;
    }

    @Override
    public void visit(NodeTraversal t, Node n, Node parent) {
        ConstructorData constructorData = this.constructorDataStack.peek();
        if (constructorData != null && n == constructorData.constructor) {
            this.constructorDataStack.pop();
            this.visitSuper(t, constructorData);
        }
    }

    private void visitSuper(NodeTraversal t, ConstructorData constructorData) {
        Node constructor = constructorData.constructor;
        List<Node> superCalls = constructorData.superCalls;
        if (superCalls.isEmpty()) {
            return;
        }
        if (constructor.isFromExterns()) {
            for (Node superCall : superCalls) {
                Node enclosingStatement = NodeUtil.getEnclosingStatement(superCall);
                Node enclosingScope = enclosingStatement.getParent();
                enclosingStatement.detach();
                this.compiler.reportChangeToEnclosingScope(enclosingScope);
            }
        } else {
            Node superClassNameNode = this.getSuperClassQNameNode(constructor);
            String superClassQName = superClassNameNode.getQualifiedName();
            JSType thisType = this.getTypeOfThisForConstructor(constructorData.constructor);
            if (this.isNativeObjectClass(t, superClassQName)) {
                for (Node superCall : superCalls) {
                    Node thisNode = this.astFactory.createThis(thisType).useSourceInfoFrom(superCall);
                    superCall.replaceWith(thisNode);
                    this.compiler.reportChangeToEnclosingScope(thisNode);
                }
            } else if (this.isUnextendableNativeClass(t, superClassQName)) {
                this.compiler.report(JSError.make(constructor, Es6ToEs3Util.CANNOT_CONVERT, "extending native class: " + superClassQName));
            } else if (this.isNativeErrorClass(t, superClassQName)) {
                for (Node superCall : superCalls) {
                    Node newSuperCall = this.createNewSuperCall(superClassNameNode, superCall, thisType);
                    this.replaceNativeErrorSuperCall(superCall, newSuperCall);
                }
            } else if (this.isKnownToReturnOnlyUndefined(superClassQName)) {
                for (Node superCall : superCalls) {
                    Node newSuperCall = this.createNewSuperCall(superClassNameNode, superCall, thisType);
                    Node superCallParent = superCall.getParent();
                    if (superCallParent.hasOneChild() && NodeUtil.isStatement(superCallParent)) {
                        superCallParent.replaceChild(superCall, newSuperCall);
                    } else {
                        superCallParent.replaceChild(superCall, this.astFactory.createComma(newSuperCall, this.astFactory.createThis(thisType)).useSourceInfoIfMissingFromForTree(superCall));
                    }
                    this.compiler.reportChangeToEnclosingScope(superCallParent);
                }
            } else {
                Node constructorBody = Preconditions.checkNotNull(constructor.getChildAtIndex(2));
                Node firstStatement = constructorBody.getFirstChild();
                Node firstSuperCall = superCalls.get(0);
                if (constructorBody.hasOneChild() && firstStatement.isExprResult() && firstStatement.hasOneChild() && firstStatement.getFirstChild() == firstSuperCall) {
                    Preconditions.checkState(superCalls.size() == 1, constructor);
                    Node newReturn = this.astFactory.createOr(this.createNewSuperCall(superClassNameNode, superCalls.get(0), superCalls.get(0).getJSType()), this.astFactory.createThis(thisType));
                    constructorBody.replaceChild(firstStatement, IR.returnNode(newReturn).useSourceInfoIfMissingFromForTree(firstStatement));
                } else {
                    JSType typeOfThis = this.getTypeOfThisForConstructor(constructor);
                    this.updateThisToSuperThis(typeOfThis, constructorBody, superCalls);
                    constructorBody.addChildToFront(IR.var(this.astFactory.createName(SUPER_THIS, typeOfThis)).useSourceInfoFromForTree(constructorBody));
                    constructorBody.addChildToBack(IR.returnNode(this.astFactory.createName(SUPER_THIS, typeOfThis)).useSourceInfoFromForTree(constructorBody));
                    for (Node superCall : superCalls) {
                        Node newSuperCall = this.createNewSuperCall(superClassNameNode, superCall, typeOfThis);
                        superCall.replaceWith(this.astFactory.createAssign(this.astFactory.createName(SUPER_THIS, typeOfThis), this.astFactory.createOr(newSuperCall, this.astFactory.createThis(typeOfThis))).useSourceInfoIfMissingFromForTree(superCall));
                    }
                }
                this.compiler.reportChangeToEnclosingScope(constructorBody);
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean isKnownToReturnOnlyUndefined(String functionQName) {
        if (this.globalNamespace == null) {
            return false;
        }
        GlobalNamespace.Name globalName = this.globalNamespace.getSlot(functionQName);
        if (globalName == null) {
            return false;
        }
        GlobalNamespace.Ref declarationRef = globalName.getDeclaration();
        if (declarationRef == null) {
            for (GlobalNamespace.Ref ref : globalName.getRefs()) {
                if (!ref.isSet()) continue;
                declarationRef = ref;
            }
        }
        if (declarationRef == null) {
            return false;
        }
        Node declaredVarOrProp = declarationRef.getNode();
        if (declaredVarOrProp.isFromExterns()) {
            return false;
        }
        Node declaration = declaredVarOrProp.getParent();
        Node declaredValue = null;
        if (declaration.isFunction()) {
            declaredValue = declaration;
        } else if (NodeUtil.isNameDeclaration(declaration) && declaredVarOrProp.isName()) {
            if (!declaredVarOrProp.hasChildren()) return false;
            declaredValue = Preconditions.checkNotNull(declaredVarOrProp.getFirstChild());
        } else if (declaration.isAssign() && declaration.getFirstChild() == declaredVarOrProp) {
            declaredValue = Preconditions.checkNotNull(declaration.getSecondChild());
        } else {
            if (!declaration.isObjectLit()) throw new IllegalStateException("Unexpected declaration format:\n" + declaration.toStringTree());
            if (!declaredVarOrProp.hasOneChild()) throw new IllegalStateException("Unexpected declaration format:\n" + declaration.toStringTree());
            declaredValue = Preconditions.checkNotNull(declaredVarOrProp.getFirstChild());
        }
        if (declaredValue.isFunction()) {
            Node functionBody = Preconditions.checkNotNull(declaredValue.getChildAtIndex(2));
            if (new UndefinedReturnValueCheck().mayReturnDefinedValue(functionBody)) return false;
            return true;
        }
        if (!declaredValue.isQualifiedName()) return false;
        return this.isKnownToReturnOnlyUndefined(declaredValue.getQualifiedName());
    }

    private Node createNewSuperCall(Node superClassQNameNode, Node superCall, JSType thisType) {
        Preconditions.checkArgument(superClassQNameNode.isQualifiedName(), superClassQNameNode);
        Preconditions.checkArgument(superCall.isCall(), superCall);
        Node callee = superCall.getFirstChild();
        if (callee.isSuper()) {
            return this.createNewSuperCallWithDotCall(superClassQNameNode, superCall, thisType);
        }
        return this.createNewSuperCallWithDotApply(superClassQNameNode, superCall, thisType);
    }

    private Node createNewSuperCallWithDotCall(Node superClassQNameNode, Node superCall, JSType thisType) {
        Preconditions.checkArgument(superClassQNameNode.isQualifiedName(), superClassQNameNode);
        Preconditions.checkArgument(superCall.isCall(), superCall);
        Node callee = superCall.removeFirstChild();
        Node superClassDotCall = this.astFactory.createGetProp(superClassQNameNode.cloneTree(), "call").useSourceInfoFromForTree(callee);
        Node newSuperCall = this.astFactory.createCall(superClassDotCall, new Node[0]).useSourceInfoFrom(superCall);
        newSuperCall.addChildToBack(this.astFactory.createThis(thisType).useSourceInfoFrom(callee));
        newSuperCall.putBooleanProp((byte)50, false);
        while (superCall.hasChildren()) {
            newSuperCall.addChildToBack(superCall.removeFirstChild());
        }
        return newSuperCall;
    }

    private Node createNewSuperCallWithDotApply(Node superClassQNameNode, Node superCall, JSType thisType) {
        Preconditions.checkArgument(superClassQNameNode.isQualifiedName(), superClassQNameNode);
        Preconditions.checkArgument(superCall.isCall(), superCall);
        Node callee = superCall.removeFirstChild();
        Preconditions.checkState(callee.isGetProp(), callee);
        Node applyNode = Preconditions.checkNotNull(callee.getSecondChild());
        Preconditions.checkState(applyNode.getString().equals("apply"), applyNode);
        Node superNode = callee.getFirstChild();
        callee.replaceChild(superNode, superClassQNameNode.cloneTree().useSourceInfoFromForTree(superNode));
        Node nullNode = superCall.getFirstChild();
        Preconditions.checkState(nullNode.isNull(), nullNode);
        superCall.removeChild(nullNode);
        Node newSuperCall = this.astFactory.createCall(callee, new Node[0]).useSourceInfoFrom(superCall);
        newSuperCall.addChildToBack(this.astFactory.createThis(thisType).useSourceInfoFrom(nullNode));
        while (superCall.hasChildren()) {
            newSuperCall.addChildToBack(superCall.removeFirstChild());
        }
        return newSuperCall;
    }

    private void replaceNativeErrorSuperCall(Node superCall, Node newSuperCall) {
        Node superStatement = NodeUtil.getEnclosingStatement(superCall);
        Node body = superStatement.getParent();
        Preconditions.checkState(body.isBlock(), body);
        JSType thisType = newSuperCall.getJSType();
        Node getError = IR.var(this.astFactory.createName(TMP_ERROR, thisType)).useSourceInfoIfMissingFromForTree(superCall);
        body.addChildBefore(getError, superStatement);
        Node getTmpError = this.astFactory.createAssign(this.astFactory.createName(TMP_ERROR, thisType), newSuperCall);
        Node copyMessage = this.astFactory.createAssign(this.astFactory.createGetProp(this.astFactory.createThis(thisType), "message"), this.astFactory.createGetProp(this.astFactory.createName(TMP_ERROR, thisType), "message"));
        Node setStack = this.astFactory.createAnd(this.astFactory.createIn(this.astFactory.createString("stack"), this.astFactory.createName(TMP_ERROR, thisType)), this.astFactory.createAssign(this.astFactory.createGetProp(this.astFactory.createThis(thisType), "stack"), this.astFactory.createGetProp(this.astFactory.createName(TMP_ERROR, thisType), "stack")));
        Node superErrorExpr = this.astFactory.createCommas(getTmpError, copyMessage, setStack, this.astFactory.createThis(thisType)).useSourceInfoIfMissingFromForTree(superCall);
        superCall.replaceWith(superErrorExpr);
        this.compiler.reportChangeToEnclosingScope(superErrorExpr);
    }

    private boolean isNativeObjectClass(NodeTraversal t, String className) {
        return className.equals("Object") && !this.isDefinedInSources(t, className);
    }

    private boolean isNativeErrorClass(NodeTraversal t, String superClassName) {
        switch (superClassName) {
            case "Error": 
            case "EvalError": 
            case "RangeError": 
            case "ReferenceError": 
            case "SyntaxError": 
            case "TypeError": 
            case "URIError": {
                return !this.isDefinedInSources(t, superClassName);
            }
        }
        return false;
    }

    private boolean isUnextendableNativeClass(NodeTraversal t, String className) {
        switch (className) {
            case "Array": 
            case "ArrayBuffer": 
            case "Boolean": 
            case "DataView": 
            case "Date": 
            case "Float32Array": 
            case "Function": 
            case "Generator": 
            case "GeneratorFunction": 
            case "Int16Array": 
            case "Int32Array": 
            case "Int8Array": 
            case "InternalError": 
            case "Map": 
            case "Number": 
            case "Promise": 
            case "Proxy": 
            case "RegExp": 
            case "Set": 
            case "String": 
            case "Symbol": 
            case "TypedArray": 
            case "Uint16Array": 
            case "Uint32Array": 
            case "Uint8Array": 
            case "Uint8ClampedArray": 
            case "WeakMap": 
            case "WeakSet": {
                return !this.isDefinedInSources(t, className);
            }
        }
        return false;
    }

    private boolean isDefinedInSources(NodeTraversal t, String varName) {
        Var objectVar = (Var)t.getScope().getVar(varName);
        return objectVar != null && !objectVar.isExtern();
    }

    private void updateThisToSuperThis(final JSType typeOfThis, Node constructorBody, final List<Node> superCalls) {
        NodeTraversal.Callback replaceThisWithSuperThis = new NodeTraversal.Callback(){

            @Override
            public boolean shouldTraverse(NodeTraversal nodeTraversal, Node n, Node parent) {
                if (superCalls.contains(n)) {
                    return false;
                }
                return !n.isFunction() || n.isArrowFunction();
            }

            @Override
            public void visit(NodeTraversal t, Node n, Node parent) {
                if (n.isThis()) {
                    Node superThis = Es6ConvertSuperConstructorCalls.this.astFactory.createName(Es6ConvertSuperConstructorCalls.SUPER_THIS, n.getJSType()).useSourceInfoFrom(n);
                    parent.replaceChild(n, superThis);
                } else if (n.isReturn() && !n.hasChildren()) {
                    n.addChildToFront(Es6ConvertSuperConstructorCalls.this.astFactory.createName(Es6ConvertSuperConstructorCalls.SUPER_THIS, typeOfThis).useSourceInfoFrom(n));
                }
            }
        };
        NodeTraversal.traverse(this.compiler, constructorBody, replaceThisWithSuperThis);
    }

    private JSType getTypeOfThisForConstructor(Node constructor) {
        JSType constructorType;
        Preconditions.checkArgument(constructor.isFunction(), constructor);
        JSType constructorTypeBeforeCast = constructor.getJSTypeBeforeCast();
        JSType jSType = constructorType = constructorTypeBeforeCast != null ? constructorTypeBeforeCast : constructor.getJSType();
        if (constructorType == null) {
            return null;
        }
        Preconditions.checkState(constructorType.isFunctionType());
        return constructorType.toMaybeFunctionType().getTypeOfThis();
    }

    private Node getSuperClassQNameNode(Node constructor) {
        String className = NodeUtil.getNameNode(constructor).getQualifiedName();
        Node constructorStatement = Preconditions.checkNotNull(NodeUtil.getEnclosingStatement(constructor));
        Node superClassNameNode = null;
        for (Node statement = constructorStatement.getNext(); statement != null && (superClassNameNode = this.getSuperClassNameNodeIfIsInheritsStatement(statement, className)) == null; statement = statement.getNext()) {
        }
        return Preconditions.checkNotNull(superClassNameNode, "$jscomp.inherits() call not found.");
    }

    private Node getSuperClassNameNodeIfIsInheritsStatement(Node statement, String className) {
        if (!statement.isExprResult()) {
            return null;
        }
        Node callNode = statement.getFirstChild();
        if (!callNode.isCall()) {
            return null;
        }
        Node jscompDotInherits = callNode.getFirstChild();
        if (!jscompDotInherits.matchesQualifiedName("$jscomp.inherits")) {
            return null;
        }
        Node classNameNode = Preconditions.checkNotNull(jscompDotInherits.getNext());
        if (classNameNode.matchesQualifiedName(className)) {
            return Preconditions.checkNotNull(classNameNode.getNext());
        }
        return null;
    }

    @Override
    public void process(Node externs, Node root) {
        this.globalNamespace = new GlobalNamespace(this.compiler, externs, root);
        TranspilationPasses.processTranspile(this.compiler, externs, transpiledFeatures, this);
        TranspilationPasses.processTranspile(this.compiler, root, transpiledFeatures, this);
        TranspilationPasses.maybeMarkFeaturesAsTranspiledAway(this.compiler, transpiledFeatures);
    }

    @Override
    public void hotSwapScript(Node scriptRoot, Node originalRoot) {
        TranspilationPasses.hotSwapTranspile(this.compiler, scriptRoot, transpiledFeatures, this);
    }

    private class UndefinedReturnValueCheck {
        private boolean foundNonEmptyReturn;

        private UndefinedReturnValueCheck() {
        }

        boolean mayReturnDefinedValue(Node functionBody) {
            this.foundNonEmptyReturn = false;
            NodeTraversal.AbstractShallowCallback checkForDefinedReturnValue = new NodeTraversal.AbstractShallowCallback(){

                @Override
                public void visit(NodeTraversal t, Node n, Node parent) {
                    if (!UndefinedReturnValueCheck.this.foundNonEmptyReturn && n.isReturn() && n.hasChildren() && !n.getFirstChild().matchesQualifiedName("undefined")) {
                        UndefinedReturnValueCheck.this.foundNonEmptyReturn = true;
                    }
                }
            };
            NodeTraversal.traverse(Es6ConvertSuperConstructorCalls.this.compiler, functionBody, checkForDefinedReturnValue);
            return this.foundNonEmptyReturn;
        }
    }

    private static final class ConstructorData {
        final Node constructor;
        final List<Node> superCalls;

        ConstructorData(Node constructor) {
            this.constructor = constructor;
            this.superCalls = new ArrayList<Node>();
        }
    }
}

