/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.base.Preconditions;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.AbstractScope;
import com.google.javascript.jscomp.CheckLevel;
import com.google.javascript.jscomp.CompilerInput;
import com.google.javascript.jscomp.DiagnosticType;
import com.google.javascript.jscomp.Es6SyntacticScopeCreator;
import com.google.javascript.jscomp.HotSwapCompilerPass;
import com.google.javascript.jscomp.JSError;
import com.google.javascript.jscomp.JSModule;
import com.google.javascript.jscomp.JSModuleGraph;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.jscomp.Scope;
import com.google.javascript.jscomp.TypeValidator;
import com.google.javascript.jscomp.Var;
import com.google.javascript.rhino.IR;
import com.google.javascript.rhino.JSDocInfoBuilder;
import com.google.javascript.rhino.Node;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;

class VarCheck
extends NodeTraversal.AbstractPostOrderCallback
implements HotSwapCompilerPass {
    static final DiagnosticType UNDEFINED_VAR_ERROR = DiagnosticType.error("JSC_UNDEFINED_VARIABLE", "variable {0} is undeclared");
    static final DiagnosticType VIOLATED_MODULE_DEP_ERROR = DiagnosticType.error("JSC_VIOLATED_MODULE_DEPENDENCY", "module {0} cannot reference {2}, defined in module {1}, since {1} loads after {0}");
    static final DiagnosticType MISSING_MODULE_DEP_ERROR = DiagnosticType.warning("JSC_MISSING_MODULE_DEPENDENCY", "missing module dependency; module {0} should depend on module {1} because it references {2}");
    static final DiagnosticType STRICT_MODULE_DEP_ERROR = DiagnosticType.disabled("JSC_STRICT_MODULE_DEPENDENCY", "cannot reference {2} because of a missing module dependency\ndefined in module {1}, referenced from module {0}");
    static final DiagnosticType NAME_REFERENCE_IN_EXTERNS_ERROR = DiagnosticType.warning("JSC_NAME_REFERENCE_IN_EXTERNS", "accessing name {0} in externs has no effect. Perhaps you forgot to add a var keyword?");
    static final DiagnosticType UNDEFINED_EXTERN_VAR_ERROR = DiagnosticType.warning("JSC_UNDEFINED_EXTERN_VAR_ERROR", "name {0} is not defined in the externs.");
    static final DiagnosticType VAR_MULTIPLY_DECLARED_ERROR = DiagnosticType.error("JSC_VAR_MULTIPLY_DECLARED_ERROR", "Variable {0} declared more than once. First occurrence: {1}");
    static final DiagnosticType VAR_ARGUMENTS_SHADOWED_ERROR = DiagnosticType.error("JSC_VAR_ARGUMENTS_SHADOWED_ERROR", "Shadowing \"arguments\" is not allowed");
    static final DiagnosticType BLOCK_SCOPED_DECL_MULTIPLY_DECLARED_ERROR = DiagnosticType.error("JSC_BLOCK_SCOPED_DECL_MULTIPLY_DECLARED_ERROR", "Duplicate let / const / class / function declaration in the same scope is not allowed.");
    private static final String ARGUMENTS = "arguments";
    private final Set<String> varsToDeclareInExterns = new HashSet<String>();
    private final AbstractCompiler compiler;
    private final boolean validityCheck;
    private final boolean strictExternCheck;
    private RedeclarationCheckHandler dupHandler;

    VarCheck(AbstractCompiler compiler) {
        this(compiler, false);
    }

    VarCheck(AbstractCompiler compiler, boolean validityCheck) {
        this.compiler = compiler;
        this.strictExternCheck = compiler.getErrorLevel(JSError.make("", 0, 0, UNDEFINED_EXTERN_VAR_ERROR, new String[0])) == CheckLevel.ERROR;
        this.validityCheck = validityCheck;
    }

    private Es6SyntacticScopeCreator createScopeCreator() {
        if (this.validityCheck) {
            return new Es6SyntacticScopeCreator(this.compiler);
        }
        this.dupHandler = new RedeclarationCheckHandler();
        return new Es6SyntacticScopeCreator(this.compiler, this.dupHandler);
    }

    @Override
    public void process(Node externs, Node root) {
        Es6SyntacticScopeCreator scopeCreator = this.createScopeCreator();
        if (!this.validityCheck) {
            NodeTraversal traversal = new NodeTraversal(this.compiler, new NameRefInExternsCheck(), scopeCreator);
            traversal.traverse(externs);
        }
        NodeTraversal t = new NodeTraversal(this.compiler, this, scopeCreator);
        t.traverseRoots(externs, root);
        for (String varName : this.varsToDeclareInExterns) {
            this.createSynthesizedExternVar(varName);
        }
        if (this.dupHandler != null) {
            this.dupHandler.removeDuplicates();
        }
    }

    @Override
    public void hotSwapScript(Node scriptRoot, Node originalRoot) {
        Preconditions.checkState(scriptRoot.isScript());
        Es6SyntacticScopeCreator scopeCreator = this.createScopeCreator();
        NodeTraversal t = new NodeTraversal(this.compiler, this, scopeCreator);
        AbstractScope topScope = scopeCreator.createScope(this.compiler.getRoot(), (AbstractScope)null);
        t.traverseWithScope(scriptRoot, topScope);
    }

    @Override
    public void visit(NodeTraversal t, Node n, Node parent) {
        if (n.isName()) {
            CompilerInput varInput;
            Scope scope;
            Var var;
            String varName = n.getString();
            if (varName.isEmpty()) {
                Preconditions.checkState(NodeUtil.isFunctionExpression(parent) || NodeUtil.isMethodDeclaration(parent));
                return;
            }
            if ((parent.isVar() || NodeUtil.isFunctionDeclaration(parent)) && this.varsToDeclareInExterns.contains(varName)) {
                this.createSynthesizedExternVar(varName);
                JSDocInfoBuilder builder = JSDocInfoBuilder.maybeCopyFrom(n.getJSDocInfo());
                builder.addSuppression("duplicate");
                n.setJSDocInfo(builder.build());
            }
            if ((var = (Var)(scope = t.getScope()).getVar(varName)) == null) {
                if (!((NodeUtil.isFunctionExpression(parent) || NodeUtil.isClassExpression(parent)) && n == parent.getFirstChild() || NodeUtil.isNonlocalModuleExportName(n))) {
                    boolean isArguments = scope.isFunctionScope() && ARGUMENTS.equals(varName);
                    boolean isTypeOf = parent.isTypeOf();
                    if (!(isArguments || isTypeOf || this.strictExternCheck && t.getInput().isExtern())) {
                        t.report(n, UNDEFINED_VAR_ERROR, varName);
                    }
                    if (this.validityCheck) {
                        throw new IllegalStateException("Unexpected variable " + varName);
                    }
                    this.createSynthesizedExternVar(varName);
                    ((Scope)scope.getGlobalScope()).declare(varName, n, this.compiler.getSynthesizedExternsInput());
                }
                return;
            }
            CompilerInput currInput = t.getInput();
            if (currInput == (varInput = var.input) || currInput == null || varInput == null) {
                return;
            }
            JSModule currModule = currInput.getModule();
            JSModule varModule = varInput.getModule();
            JSModuleGraph moduleGraph = this.compiler.getModuleGraph();
            if (!this.validityCheck && varModule != currModule && varModule != null && currModule != null && !moduleGraph.dependsOn(currModule, varModule)) {
                if (scope.isGlobal()) {
                    if (moduleGraph.dependsOn(varModule, currModule)) {
                        t.report(n, VIOLATED_MODULE_DEP_ERROR, currModule.getName(), varModule.getName(), varName);
                    } else {
                        t.report(n, MISSING_MODULE_DEP_ERROR, currModule.getName(), varModule.getName(), varName);
                    }
                } else {
                    t.report(n, STRICT_MODULE_DEP_ERROR, currModule.getName(), varModule.getName(), varName);
                }
            }
        }
    }

    static void createSynthesizedExternVar(AbstractCompiler compiler, String varName) {
        Node nameNode = IR.name(varName);
        if (compiler.getCodingConvention().isConstant(varName)) {
            nameNode.putBooleanProp((byte)43, true);
        }
        Node syntheticExternVar = IR.var(nameNode);
        VarCheck.getSynthesizedExternsRoot(compiler).addChildToBack(syntheticExternVar);
        compiler.reportChangeToEnclosingScope(syntheticExternVar);
    }

    private void createSynthesizedExternVar(String varName) {
        VarCheck.createSynthesizedExternVar(this.compiler, varName);
        this.varsToDeclareInExterns.remove(varName);
    }

    static boolean hasDuplicateDeclarationSuppression(AbstractCompiler compiler, Node n, Node origVar) {
        if (VarCheck.isExternNamespace(n)) {
            return true;
        }
        return TypeValidator.hasDuplicateDeclarationSuppression(compiler, origVar);
    }

    static boolean isExternNamespace(Node n) {
        return n.getParent().isVar() && n.isFromExterns() && NodeUtil.isNamespaceDecl(n);
    }

    private static Node getSynthesizedExternsRoot(AbstractCompiler compiler) {
        return compiler.getSynthesizedExternsInput().getAstRoot(compiler);
    }

    private class RedeclarationCheckHandler
    implements Es6SyntacticScopeCreator.RedeclarationHandler {
        private final ArrayList<Node> dupDeclNodes = new ArrayList();

        private RedeclarationCheckHandler() {
        }

        @Override
        public void onRedeclaration(Scope s, String name, Node n, CompilerInput input) {
            Node origParent;
            Node parent = NodeUtil.getDeclaringParent(n);
            Var origVar = (Var)s.getVar(name);
            Node origNode = origVar.getNode();
            Node node = origParent = origNode == null ? null : NodeUtil.getDeclaringParent(origNode);
            if (parent.isLet() || parent.isConst() || parent.isClass() || origParent != null && (origParent.isLet() || origParent.isConst() || origParent.isClass())) {
                VarCheck.this.compiler.report(JSError.make(n, BLOCK_SCOPED_DECL_MULTIPLY_DECLARED_ERROR, new String[0]));
                return;
            }
            if (parent.isFunction() && !s.isGlobal() && origParent != null && (origParent.isFunction() || origParent.isLet() || origParent.isConst() || origParent.isClass())) {
                VarCheck.this.compiler.report(JSError.make(n, BLOCK_SCOPED_DECL_MULTIPLY_DECLARED_ERROR, new String[0]));
                return;
            }
            if (s.isGlobal()) {
                if (origParent.isCatch() && parent.isCatch()) {
                    return;
                }
                boolean allowDupe = VarCheck.hasDuplicateDeclarationSuppression(VarCheck.this.compiler, n, origVar.getNameNode());
                if (VarCheck.isExternNamespace(n)) {
                    this.dupDeclNodes.add(parent);
                    return;
                }
                if (!allowDupe) {
                    VarCheck.this.compiler.report(JSError.make(n, VAR_MULTIPLY_DECLARED_ERROR, name, origVar.input != null ? origVar.input.getName() : "??"));
                }
            } else if (!(!name.equals(VarCheck.ARGUMENTS) || NodeUtil.isNameDeclaration(n.getParent()) && n.isName())) {
                VarCheck.this.compiler.report(JSError.make(n, VAR_ARGUMENTS_SHADOWED_ERROR, new String[0]));
            }
        }

        public void removeDuplicates() {
            for (Node n : this.dupDeclNodes) {
                Node parent = n.getParent();
                if (parent == null) continue;
                n.detach();
                VarCheck.this.compiler.reportChangeToEnclosingScope(parent);
            }
        }
    }

    private class NameRefInExternsCheck
    implements NodeTraversal.Callback {
        private NameRefInExternsCheck() {
        }

        @Override
        public boolean shouldTraverse(NodeTraversal t, Node n, Node parent) {
            return !n.isScript() || !NodeUtil.isFromTypeSummary(n);
        }

        @Override
        public void visit(NodeTraversal t, Node n, Node parent) {
            if (n.isName()) {
                switch (parent.getToken()) {
                    case VAR: 
                    case LET: 
                    case CONST: 
                    case FUNCTION: 
                    case CLASS: 
                    case PARAM_LIST: 
                    case DEFAULT_VALUE: 
                    case REST: 
                    case ARRAY_PATTERN: {
                        return;
                    }
                    case STRING_KEY: {
                        if (!parent.getParent().isObjectPattern()) break;
                        return;
                    }
                    case GETPROP: {
                        Scope scope;
                        Var var;
                        if (n == parent.getFirstChild() && (var = (Var)(scope = t.getScope()).getVar(n.getString())) == null) {
                            t.report(n, UNDEFINED_EXTERN_VAR_ERROR, n.getString());
                            VarCheck.this.varsToDeclareInExterns.add(n.getString());
                        }
                        return;
                    }
                    case ASSIGN: {
                        if (n != parent.getLastChild() || !n.isQualifiedName() || !parent.getFirstChild().isQualifiedName()) break;
                        return;
                    }
                    case NAME: {
                        if (!NodeUtil.isNameDeclaration(parent.getParent())) break;
                        return;
                    }
                    case OR: {
                        if (!NodeUtil.isNamespaceDecl(parent.getParent())) break;
                        return;
                    }
                }
                t.report(n, NAME_REFERENCE_IN_EXTERNS_ERROR, n.getString());
                Scope scope = t.getScope();
                Var var = (Var)scope.getVar(n.getString());
                if (var == null) {
                    VarCheck.this.varsToDeclareInExterns.add(n.getString());
                }
            }
        }
    }
}

