/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp.deps;

import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Streams;
import com.google.errorprone.annotations.Immutable;
import com.google.javascript.jscomp.deps.AutoValue_DependencyInfo_Require;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;

public interface DependencyInfo
extends Serializable {
    public String getName();

    public String getPathRelativeToClosureBase();

    public ImmutableList<String> getProvides();

    public ImmutableList<Require> getRequires();

    public ImmutableList<String> getRequiredSymbols();

    public ImmutableList<String> getWeakRequires();

    public ImmutableMap<String, String> getLoadFlags();

    public boolean isModule();

    public static class Util {
        private Util() {
        }

        public static void writeAddDependency(Appendable out, DependencyInfo info) throws IOException {
            out.append("goog.addDependency('").append(info.getPathRelativeToClosureBase()).append("', ");
            Util.writeJsArray(out, info.getProvides());
            out.append(", ");
            Util.writeJsArray(out, Require.asSymbolList(info.getRequires()));
            ImmutableMap<String, String> loadFlags = info.getLoadFlags();
            if (!loadFlags.isEmpty()) {
                out.append(", ");
                Util.writeJsObject(out, loadFlags);
            }
            out.append(");\n");
        }

        private static void writeJsObject(Appendable out, Map<String, String> map) throws IOException {
            ArrayList<String> entries = new ArrayList<String>();
            for (Map.Entry<String, String> entry : map.entrySet()) {
                String key = entry.getKey().replace("'", "\\'");
                String value = entry.getValue().replace("'", "\\'");
                entries.add("'" + key + "': '" + value + "'");
            }
            out.append("{");
            out.append(Joiner.on(", ").join(entries));
            out.append("}");
        }

        private static void writeJsArray(Appendable out, Collection<String> values) throws IOException {
            Iterable quoted = Iterables.transform(values, arg -> "'" + arg.replace("'", "\\'") + "'");
            out.append("[");
            out.append(Joiner.on(", ").join(quoted));
            out.append("]");
        }
    }

    public static abstract class Base
    implements DependencyInfo {
        @Override
        public boolean isModule() {
            return "goog".equals(this.getLoadFlags().get("module"));
        }

        @Override
        public ImmutableList<String> getRequiredSymbols() {
            return Require.asSymbolList(this.getRequires());
        }
    }

    @Immutable
    public static abstract class Require
    implements Serializable {
        public static final Require BASE = Require.googRequireSymbol("goog");

        public static ImmutableList<String> asSymbolList(Iterable<Require> requires) {
            return Streams.stream(requires).map(Require::getSymbol).collect(ImmutableList.toImmutableList());
        }

        public static Require googRequireSymbol(String symbol) {
            return Require.builder().setRawText(symbol).setSymbol(symbol).setType(Type.GOOG_REQUIRE_SYMBOL).build();
        }

        public static Require es6Import(String symbol, String rawPath) {
            return Require.builder().setRawText(rawPath).setSymbol(symbol).setType(Type.ES6_IMPORT).build();
        }

        public static Require commonJs(String symbol, String rawPath) {
            return Require.builder().setRawText(rawPath).setSymbol(symbol).setType(Type.COMMON_JS).build();
        }

        public static Require compilerModule(String symbol) {
            return Require.builder().setRawText(symbol).setSymbol(symbol).setType(Type.COMPILER_MODULE).build();
        }

        public static Require parsedFromDeps(String symbol) {
            return Require.builder().setRawText(symbol).setSymbol(symbol).setType(Type.PARSED_FROM_DEPS).build();
        }

        private static Builder builder() {
            return new AutoValue_DependencyInfo_Require.Builder();
        }

        protected abstract Builder toBuilder();

        public Require withSymbol(String symbol) {
            return this.toBuilder().setSymbol(symbol).build();
        }

        public abstract String getSymbol();

        public abstract String getRawText();

        public abstract Type getType();

        static abstract class Builder {
            Builder() {
            }

            public abstract Builder setType(Type var1);

            public abstract Builder setRawText(String var1);

            public abstract Builder setSymbol(String var1);

            public abstract Require build();
        }

        public static enum Type {
            GOOG_REQUIRE_SYMBOL,
            ES6_IMPORT,
            PARSED_FROM_DEPS,
            COMMON_JS,
            COMPILER_MODULE;

        }
    }
}

