/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.rhino.jstype;

import com.google.common.base.Joiner;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableList;
import com.google.javascript.rhino.ErrorReporter;
import com.google.javascript.rhino.jstype.BooleanLiteralSet;
import com.google.javascript.rhino.jstype.EquivalenceMethod;
import com.google.javascript.rhino.jstype.JSType;
import com.google.javascript.rhino.jstype.JSTypeNative;
import com.google.javascript.rhino.jstype.JSTypeRegistry;
import com.google.javascript.rhino.jstype.ObjectType;
import com.google.javascript.rhino.jstype.RelationshipVisitor;
import com.google.javascript.rhino.jstype.TernaryValue;
import com.google.javascript.rhino.jstype.UnionTypeBuilder;
import com.google.javascript.rhino.jstype.Visitor;
import java.util.ArrayList;
import java.util.TreeSet;

public class UnionType
extends JSType {
    private static final long serialVersionUID = 2L;
    private ImmutableList<JSType> alternatesRetainingStructuralSubtypes;
    private ImmutableList<JSType> alternatesCollapsingStructuralSubtypes;

    UnionType(JSTypeRegistry registry, ImmutableList<JSType> alternatesRetainingStructuralSubtypes) {
        super(registry);
        this.alternatesRetainingStructuralSubtypes = alternatesRetainingStructuralSubtypes;
        UnionTypeBuilder builder = UnionTypeBuilder.createForCollapsingStructuralSubtypes(registry);
        for (JSType alternate : alternatesRetainingStructuralSubtypes) {
            builder.addAlternate(alternate);
        }
        this.alternatesCollapsingStructuralSubtypes = builder.getAlternates();
    }

    public ImmutableList<JSType> getAlternates() {
        if (UnionType.anyMatch(JSType::isUnionType, this.alternatesRetainingStructuralSubtypes)) {
            this.rebuildAlternates();
        }
        return this.alternatesCollapsingStructuralSubtypes;
    }

    public ImmutableList<JSType> getAlternatesWithoutStructuralTyping() {
        if (UnionType.anyMatch(JSType::isUnionType, this.alternatesRetainingStructuralSubtypes)) {
            this.rebuildAlternates();
        }
        return this.alternatesRetainingStructuralSubtypes;
    }

    private void rebuildAlternates() {
        UnionTypeBuilder nonCollapsingBuilder = UnionTypeBuilder.create(this.registry);
        UnionTypeBuilder collapsingBuilder = UnionTypeBuilder.createForCollapsingStructuralSubtypes(this.registry);
        for (JSType alternate : this.alternatesRetainingStructuralSubtypes) {
            nonCollapsingBuilder.addAlternate(alternate);
            collapsingBuilder.addAlternate(alternate);
        }
        this.alternatesRetainingStructuralSubtypes = nonCollapsingBuilder.getAlternates();
        this.alternatesCollapsingStructuralSubtypes = collapsingBuilder.getAlternates();
    }

    @Override
    public boolean matchesNumberContext() {
        return UnionType.anyMatch(JSType::matchesNumberContext, this.alternatesRetainingStructuralSubtypes);
    }

    @Override
    public boolean matchesStringContext() {
        return UnionType.anyMatch(JSType::matchesStringContext, this.alternatesRetainingStructuralSubtypes);
    }

    @Override
    public boolean matchesSymbolContext() {
        return UnionType.anyMatch(JSType::matchesSymbolContext, this.alternatesRetainingStructuralSubtypes);
    }

    @Override
    public boolean matchesObjectContext() {
        return UnionType.anyMatch(JSType::matchesObjectContext, this.alternatesRetainingStructuralSubtypes);
    }

    @Override
    public JSType findPropertyType(String propertyName) {
        JSType propertyType = null;
        for (JSType alternate : this.getAlternates()) {
            JSType altPropertyType;
            if (alternate.isNullType() || alternate.isVoidType() || (altPropertyType = alternate.findPropertyType(propertyName)) == null) continue;
            if (propertyType == null) {
                propertyType = altPropertyType;
                continue;
            }
            propertyType = propertyType.getLeastSupertype(altPropertyType);
        }
        return propertyType;
    }

    @Override
    public boolean canBeCalled() {
        return UnionType.allMatch(JSType::canBeCalled, this.alternatesRetainingStructuralSubtypes);
    }

    @Override
    public JSType autobox() {
        UnionTypeBuilder restricted = UnionTypeBuilder.create(this.registry);
        for (int i = 0; i < this.alternatesRetainingStructuralSubtypes.size(); ++i) {
            JSType t = (JSType)this.alternatesRetainingStructuralSubtypes.get(i);
            restricted.addAlternate(t.autobox());
        }
        return restricted.build();
    }

    @Override
    public JSType restrictByNotNullOrUndefined() {
        UnionTypeBuilder restricted = UnionTypeBuilder.create(this.registry);
        for (int i = 0; i < this.alternatesRetainingStructuralSubtypes.size(); ++i) {
            JSType t = (JSType)this.alternatesRetainingStructuralSubtypes.get(i);
            restricted.addAlternate(t.restrictByNotNullOrUndefined());
        }
        return restricted.build();
    }

    @Override
    public JSType restrictByNotUndefined() {
        UnionTypeBuilder restricted = UnionTypeBuilder.create(this.registry);
        for (JSType t : this.alternatesRetainingStructuralSubtypes) {
            restricted.addAlternate(t.restrictByNotUndefined());
        }
        return restricted.build();
    }

    @Override
    public TernaryValue testForEquality(JSType that) {
        TernaryValue result = null;
        for (int i = 0; i < this.alternatesRetainingStructuralSubtypes.size(); ++i) {
            JSType t = (JSType)this.alternatesRetainingStructuralSubtypes.get(i);
            TernaryValue test = t.testForEquality(that);
            if (result == null) {
                result = test;
                continue;
            }
            if (result.equals((Object)test)) continue;
            return TernaryValue.UNKNOWN;
        }
        return result;
    }

    @Override
    public boolean isNullable() {
        return UnionType.anyMatch(JSType::isNullable, this.alternatesRetainingStructuralSubtypes);
    }

    @Override
    public boolean isVoidable() {
        return UnionType.anyMatch(JSType::isVoidable, this.alternatesRetainingStructuralSubtypes);
    }

    @Override
    public boolean isExplicitlyVoidable() {
        return UnionType.anyMatch(JSType::isExplicitlyVoidable, this.alternatesRetainingStructuralSubtypes);
    }

    @Override
    public boolean isUnknownType() {
        return UnionType.anyMatch(JSType::isUnknownType, this.alternatesRetainingStructuralSubtypes);
    }

    @Override
    public boolean isStruct() {
        return UnionType.anyMatch(JSType::isStruct, this.getAlternates());
    }

    @Override
    public boolean isDict() {
        return UnionType.anyMatch(JSType::isDict, this.getAlternates());
    }

    @Override
    public JSType getLeastSupertype(JSType that) {
        if (!that.isUnknownType() && !that.isUnionType()) {
            for (int i = 0; i < this.alternatesRetainingStructuralSubtypes.size(); ++i) {
                JSType alternate = (JSType)this.alternatesRetainingStructuralSubtypes.get(i);
                if (alternate.isUnknownType() || !that.isSubtypeOf(alternate)) continue;
                return this;
            }
        }
        return JSType.getLeastSupertype(this, that);
    }

    JSType meet(JSType that) {
        JSType result;
        UnionTypeBuilder builder = UnionTypeBuilder.create(this.registry);
        for (int i = 0; i < this.alternatesRetainingStructuralSubtypes.size(); ++i) {
            JSType alternate = (JSType)this.alternatesRetainingStructuralSubtypes.get(i);
            if (!alternate.isSubtypeOf(that)) continue;
            builder.addAlternate(alternate);
        }
        if (that.isUnionType()) {
            ImmutableList<JSType> thoseAlternatesWithoutStucturalTyping = that.toMaybeUnionType().alternatesRetainingStructuralSubtypes;
            for (int i = 0; i < thoseAlternatesWithoutStucturalTyping.size(); ++i) {
                JSType otherAlternate = (JSType)thoseAlternatesWithoutStucturalTyping.get(i);
                if (!otherAlternate.isSubtypeOf(this)) continue;
                builder.addAlternate(otherAlternate);
            }
        } else if (that.isSubtypeOf(this)) {
            builder.addAlternate(that);
        }
        if (!(result = builder.build()).isNoType()) {
            return result;
        }
        if (this.isObject() && that.isObject() && !that.isNoType()) {
            return this.getNativeType(JSTypeNative.NO_OBJECT_TYPE);
        }
        return this.getNativeType(JSTypeNative.NO_TYPE);
    }

    boolean checkUnionEquivalenceHelper(UnionType that, EquivalenceMethod eqMethod, JSType.EqCache eqCache) {
        ImmutableList<JSType> thatAlternates = that.getAlternatesWithoutStructuralTyping();
        if (eqMethod == EquivalenceMethod.IDENTITY && this.getAlternatesWithoutStructuralTyping().size() != thatAlternates.size()) {
            return false;
        }
        for (int i = 0; i < thatAlternates.size(); ++i) {
            JSType thatAlternate = (JSType)thatAlternates.get(i);
            if (this.hasAlternate(thatAlternate, eqMethod, eqCache)) continue;
            return false;
        }
        return true;
    }

    private boolean hasAlternate(JSType type, EquivalenceMethod eqMethod, JSType.EqCache eqCache) {
        ImmutableList<JSType> alternatesRetainingStructuralSubtypes = this.getAlternatesWithoutStructuralTyping();
        for (int i = 0; i < alternatesRetainingStructuralSubtypes.size(); ++i) {
            JSType alternate = (JSType)alternatesRetainingStructuralSubtypes.get(i);
            if (!alternate.checkEquivalenceHelper(type, eqMethod, eqCache)) continue;
            return true;
        }
        return false;
    }

    @Override
    public JSType.HasPropertyKind getPropertyKind(String pname, boolean autobox) {
        boolean found = false;
        boolean always = true;
        for (int i = 0; i < this.alternatesRetainingStructuralSubtypes.size(); ++i) {
            JSType alternate = (JSType)this.alternatesRetainingStructuralSubtypes.get(i);
            if (alternate.isNullType() || alternate.isVoidType()) continue;
            switch (alternate.getPropertyKind(pname, autobox)) {
                case KNOWN_PRESENT: {
                    found = true;
                    break;
                }
                case ABSENT: {
                    always = false;
                    break;
                }
                case MAYBE_PRESENT: {
                    found = true;
                    always = false;
                }
            }
            if (found && !always) break;
        }
        return found ? (always ? JSType.HasPropertyKind.KNOWN_PRESENT : JSType.HasPropertyKind.MAYBE_PRESENT) : JSType.HasPropertyKind.ABSENT;
    }

    @Override
    final int recursionUnsafeHashCode() {
        int hashCode = this.alternatesRetainingStructuralSubtypes.size();
        for (int i = 0; i < this.alternatesRetainingStructuralSubtypes.size(); ++i) {
            hashCode *= ((JSType)this.alternatesRetainingStructuralSubtypes.get(i)).hashCode();
        }
        return hashCode;
    }

    @Override
    public UnionType toMaybeUnionType() {
        return this;
    }

    @Override
    public boolean isObject() {
        return UnionType.allMatch(JSType::isObject, this.alternatesRetainingStructuralSubtypes);
    }

    public boolean contains(JSType type) {
        return UnionType.anyMatch(type::isEquivalentTo, this.alternatesRetainingStructuralSubtypes);
    }

    public JSType getRestrictedUnion(JSType type) {
        UnionTypeBuilder restricted = UnionTypeBuilder.create(this.registry);
        for (int i = 0; i < this.alternatesRetainingStructuralSubtypes.size(); ++i) {
            JSType t = (JSType)this.alternatesRetainingStructuralSubtypes.get(i);
            if (!t.isUnknownType() && !t.isNoResolvedType() && t.isSubtypeOf(type)) continue;
            restricted.addAlternate(t);
        }
        return restricted.build();
    }

    @Override
    StringBuilder appendTo(StringBuilder sb, boolean forAnnotations) {
        sb.append("(");
        TreeSet<String> sortedTypeNames = new TreeSet<String>();
        for (JSType jsType : this.alternatesRetainingStructuralSubtypes) {
            sortedTypeNames.add(jsType.appendTo(new StringBuilder(), forAnnotations).toString());
        }
        Joiner.on('|').appendTo(sb, (Iterable<?>)sortedTypeNames);
        return sb.append(")");
    }

    @Override
    public boolean isSubtype(JSType that) {
        return this.isSubtype(that, JSType.ImplCache.create(), JSType.SubtypingMode.NORMAL);
    }

    @Override
    protected boolean isSubtype(JSType that, JSType.ImplCache implicitImplCache, JSType.SubtypingMode subtypingMode) {
        if (that.isUnknownType() || this.isUnknownType()) {
            return true;
        }
        if (that.isAllType()) {
            return true;
        }
        for (int i = 0; i < this.alternatesRetainingStructuralSubtypes.size(); ++i) {
            JSType element = (JSType)this.alternatesRetainingStructuralSubtypes.get(i);
            if (subtypingMode == JSType.SubtypingMode.IGNORE_NULL_UNDEFINED && (element.isNullType() || element.isVoidType()) || element.isSubtype(that, implicitImplCache, subtypingMode)) continue;
            return false;
        }
        return true;
    }

    @Override
    public JSType getRestrictedTypeGivenToBooleanOutcome(boolean outcome) {
        UnionTypeBuilder restricted = UnionTypeBuilder.create(this.registry);
        for (int i = 0; i < this.alternatesRetainingStructuralSubtypes.size(); ++i) {
            JSType element = (JSType)this.alternatesRetainingStructuralSubtypes.get(i);
            restricted.addAlternate(element.getRestrictedTypeGivenToBooleanOutcome(outcome));
        }
        return restricted.build();
    }

    @Override
    public BooleanLiteralSet getPossibleToBooleanOutcomes() {
        JSType element;
        BooleanLiteralSet literals = BooleanLiteralSet.EMPTY;
        for (int i = 0; i < this.alternatesRetainingStructuralSubtypes.size() && (literals = literals.union((element = (JSType)this.alternatesRetainingStructuralSubtypes.get(i)).getPossibleToBooleanOutcomes())) != BooleanLiteralSet.BOTH; ++i) {
        }
        return literals;
    }

    @Override
    public JSType.TypePair getTypesUnderEquality(JSType that) {
        UnionTypeBuilder thisRestricted = UnionTypeBuilder.create(this.registry);
        UnionTypeBuilder thatRestricted = UnionTypeBuilder.create(this.registry);
        for (int i = 0; i < this.alternatesRetainingStructuralSubtypes.size(); ++i) {
            JSType element = (JSType)this.alternatesRetainingStructuralSubtypes.get(i);
            JSType.TypePair p = element.getTypesUnderEquality(that);
            if (p.typeA != null) {
                thisRestricted.addAlternate(p.typeA);
            }
            if (p.typeB == null) continue;
            thatRestricted.addAlternate(p.typeB);
        }
        return new JSType.TypePair(thisRestricted.build(), thatRestricted.build());
    }

    @Override
    public JSType.TypePair getTypesUnderInequality(JSType that) {
        UnionTypeBuilder thisRestricted = UnionTypeBuilder.create(this.registry);
        UnionTypeBuilder thatRestricted = UnionTypeBuilder.create(this.registry);
        for (int i = 0; i < this.alternatesRetainingStructuralSubtypes.size(); ++i) {
            JSType element = (JSType)this.alternatesRetainingStructuralSubtypes.get(i);
            JSType.TypePair p = element.getTypesUnderInequality(that);
            if (p.typeA != null) {
                thisRestricted.addAlternate(p.typeA);
            }
            if (p.typeB == null) continue;
            thatRestricted.addAlternate(p.typeB);
        }
        return new JSType.TypePair(thisRestricted.build(), thatRestricted.build());
    }

    @Override
    public JSType.TypePair getTypesUnderShallowInequality(JSType that) {
        UnionTypeBuilder thisRestricted = UnionTypeBuilder.create(this.registry);
        UnionTypeBuilder thatRestricted = UnionTypeBuilder.create(this.registry);
        for (int i = 0; i < this.alternatesRetainingStructuralSubtypes.size(); ++i) {
            JSType element = (JSType)this.alternatesRetainingStructuralSubtypes.get(i);
            JSType.TypePair p = element.getTypesUnderShallowInequality(that);
            if (p.typeA != null) {
                thisRestricted.addAlternate(p.typeA);
            }
            if (p.typeB == null) continue;
            thatRestricted.addAlternate(p.typeB);
        }
        return new JSType.TypePair(thisRestricted.build(), thatRestricted.build());
    }

    @Override
    public <T> T visit(Visitor<T> visitor) {
        return visitor.caseUnionType(this);
    }

    @Override
    <T> T visit(RelationshipVisitor<T> visitor, JSType that) {
        return visitor.caseUnionType(this, that);
    }

    @Override
    JSType resolveInternal(ErrorReporter reporter) {
        this.setResolvedTypeInternal(this);
        for (int i = 0; i < this.alternatesRetainingStructuralSubtypes.size(); ++i) {
            JSType alternate = (JSType)this.alternatesRetainingStructuralSubtypes.get(i);
            alternate.resolve(reporter);
        }
        this.rebuildAlternates();
        return this;
    }

    @Override
    public String toDebugHashCodeString() {
        ArrayList<String> hashCodes = new ArrayList<String>();
        for (JSType a : this.alternatesRetainingStructuralSubtypes) {
            hashCodes.add(a.toDebugHashCodeString());
        }
        return "{(" + Joiner.on(",").join(hashCodes) + ")}";
    }

    @Override
    public boolean setValidator(Predicate<JSType> validator) {
        for (int i = 0; i < this.alternatesRetainingStructuralSubtypes.size(); ++i) {
            JSType a = (JSType)this.alternatesRetainingStructuralSubtypes.get(i);
            a.setValidator(validator);
        }
        return true;
    }

    @Override
    public JSType collapseUnion() {
        JSType currentValue = null;
        ObjectType currentCommonSuper = null;
        for (int i = 0; i < this.alternatesRetainingStructuralSubtypes.size(); ++i) {
            JSType a = (JSType)this.alternatesRetainingStructuralSubtypes.get(i);
            if (a.isUnknownType()) {
                return this.getNativeType(JSTypeNative.UNKNOWN_TYPE);
            }
            ObjectType obj = a.toObjectType();
            if (obj == null) {
                if (currentValue == null && currentCommonSuper == null) {
                    currentValue = a;
                    continue;
                }
                return this.getNativeType(JSTypeNative.ALL_TYPE);
            }
            if (currentValue != null) {
                return this.getNativeType(JSTypeNative.ALL_TYPE);
            }
            currentCommonSuper = currentCommonSuper == null ? obj : this.registry.findCommonSuperObject(currentCommonSuper, obj);
        }
        return currentCommonSuper;
    }

    @Override
    public void matchConstraint(JSType constraint) {
        for (int i = 0; i < this.alternatesRetainingStructuralSubtypes.size(); ++i) {
            JSType alternate = (JSType)this.alternatesRetainingStructuralSubtypes.get(i);
            alternate.matchConstraint(constraint);
        }
    }

    @Override
    public boolean hasAnyTemplateTypesInternal() {
        return UnionType.anyMatch(JSType::hasAnyTemplateTypes, this.alternatesRetainingStructuralSubtypes);
    }

    private static boolean anyMatch(Predicate<JSType> predicate, ImmutableList<JSType> universe) {
        for (int i = 0; i < universe.size(); ++i) {
            if (!predicate.test((JSType)universe.get(i))) continue;
            return true;
        }
        return false;
    }

    private static boolean allMatch(Predicate<JSType> predicate, ImmutableList<JSType> universe) {
        for (int i = 0; i < universe.size(); ++i) {
            if (predicate.test((JSType)universe.get(i))) continue;
            return false;
        }
        return true;
    }
}

