/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.CompilerPass;
import com.google.javascript.jscomp.J2clSourceFileChecker;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.jscomp.jarjar.com.google.common.base.Preconditions;
import com.google.javascript.jscomp.jarjar.com.google.common.collect.ArrayListMultimap;
import com.google.javascript.jscomp.jarjar.com.google.common.collect.Iterables;
import com.google.javascript.rhino.Node;
import java.util.Collection;
import java.util.HashSet;

public class J2clConstantHoisterPass
implements CompilerPass {
    private final AbstractCompiler compiler;

    J2clConstantHoisterPass(AbstractCompiler compiler) {
        this.compiler = compiler;
    }

    @Override
    public void process(Node externs, Node root) {
        if (!J2clSourceFileChecker.shouldRunJ2clPasses(this.compiler)) {
            return;
        }
        ArrayListMultimap fieldAssignments = ArrayListMultimap.create();
        HashSet<Node> hoistableFunctions = new HashSet<Node>();
        NodeTraversal.traversePostOrder(this.compiler, root, (t, node, parent) -> {
            if (parent != null && NodeUtil.isLValue(node)) {
                fieldAssignments.put(node.getQualifiedName(), parent);
            }
            if (J2clConstantHoisterPass.isHoistableFunction(t, node)) {
                hoistableFunctions.add(node);
            }
        });
        for (Collection<Node> collection : fieldAssignments.asMap().values()) {
            this.maybeHoistClassField(collection, hoistableFunctions);
        }
    }

    private static boolean isHoistableFunction(NodeTraversal t, Node node) {
        return node.isFunction() && t.getScope().getVarCount() == 0;
    }

    private void maybeHoistClassField(Collection<Node> assignments, Collection<Node> hoistableFunctions) {
        Node clinitAssignment;
        if (assignments.size() != 2) {
            return;
        }
        Node first = Iterables.get(assignments, 0);
        Node second = Iterables.get(assignments, 1);
        Node topLevelDeclaration = J2clConstantHoisterPass.isClassFieldDeclaration(first) ? first : second;
        Node node = clinitAssignment = J2clConstantHoisterPass.isClinitFieldAssignment(first) ? first : second;
        if (!J2clConstantHoisterPass.isClassFieldDeclaration(topLevelDeclaration) || !J2clConstantHoisterPass.isClinitFieldAssignment(clinitAssignment)) {
            return;
        }
        Node assignmentRhs = clinitAssignment.getSecondChild();
        if (!NodeUtil.isLiteralValue(assignmentRhs, true) || assignmentRhs.isFunction() && !hoistableFunctions.contains(assignmentRhs)) {
            return;
        }
        if (NodeUtil.getEnclosingScript(clinitAssignment) != NodeUtil.getEnclosingScript(topLevelDeclaration)) {
            return;
        }
        this.hoistConstantLikeField(clinitAssignment, topLevelDeclaration);
    }

    private void hoistConstantLikeField(Node clinitAssignment, Node topLevelDeclaration) {
        Node clinitAssignedValue = clinitAssignment.getSecondChild();
        Node declarationInClass = topLevelDeclaration.getFirstChild();
        Node declarationAssignedValue = declarationInClass.getFirstChild();
        Node clinitChangeScope = NodeUtil.getEnclosingChangeScopeRoot(clinitAssignment);
        NodeUtil.removeChild(clinitAssignment.getParent(), clinitAssignment);
        clinitAssignedValue.detach();
        this.compiler.reportChangeToChangeScope(clinitChangeScope);
        if (declarationAssignedValue == null) {
            declarationInClass.addChildToFront(clinitAssignedValue);
            this.compiler.reportChangeToEnclosingScope(topLevelDeclaration);
        } else if (!declarationAssignedValue.equals(clinitAssignedValue)) {
            Preconditions.checkState(NodeUtil.isLiteralValue(declarationAssignedValue, false));
            declarationInClass.replaceChild(declarationAssignedValue, clinitAssignedValue);
            this.compiler.reportChangeToEnclosingScope(topLevelDeclaration);
        }
        declarationInClass.setDeclaredConstantVar(true);
    }

    private static boolean isClassFieldDeclaration(Node node) {
        return node.getParent().isScript() && node.isVar() && (!node.getFirstChild().hasChildren() || node.getFirstFirstChild() != null && NodeUtil.isLiteralValue(node.getFirstFirstChild(), false));
    }

    private static boolean isClinitFieldAssignment(Node node) {
        return node.getParent().isExprResult() && node.getGrandparent().isBlock() && J2clConstantHoisterPass.isClinitMethod(node.getGrandparent().getParent());
    }

    private static boolean isClinitMethod(Node fnNode) {
        if (!fnNode.isFunction()) {
            return false;
        }
        String fnName = NodeUtil.getName(fnNode);
        return fnName != null && J2clConstantHoisterPass.isClinitMethodName(fnName);
    }

    private static boolean isClinitMethodName(String methodName) {
        return methodName != null && (methodName.endsWith("$$0clinit") || methodName.endsWith(".$clinit"));
    }
}

