/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.javascript.jscomp.CheckLevel;
import com.google.javascript.jscomp.Compiler;
import com.google.javascript.jscomp.CompilerOptions;
import com.google.javascript.jscomp.DiagnosticGroups;
import com.google.javascript.jscomp.DiagnosticType;
import com.google.javascript.jscomp.GoogleCodingConvention;
import com.google.javascript.jscomp.LintPassConfig;
import com.google.javascript.jscomp.SourceFile;
import com.google.javascript.jscomp.deps.ModuleLoader;
import com.google.javascript.jscomp.jarjar.com.google.common.annotations.GwtIncompatible;
import com.google.javascript.jscomp.jarjar.com.google.common.collect.ImmutableList;
import com.google.javascript.jscomp.jarjar.com.google.common.collect.ImmutableMap;
import com.google.javascript.jscomp.jarjar.com.google.common.collect.ImmutableSet;
import com.google.javascript.jscomp.parsing.Config;
import com.google.javascript.refactoring.ApplySuggestedFixes;
import com.google.javascript.refactoring.FixingErrorManager;
import com.google.javascript.refactoring.SuggestedFix;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collection;

@GwtIncompatible(value="Unnecessary")
public final class Linter {
    static final int MAX_FIXES = 5;
    private final CompilerOptions options;

    private Linter(CompilerOptions options) {
        this.options = options;
    }

    static Builder builder() {
        return new Builder();
    }

    void lint(String filename) throws IOException {
        this.lint(Paths.get(filename, new String[0]), new Compiler(System.out));
    }

    void lint(Path path, Compiler compiler) throws IOException {
        SourceFile file = SourceFile.fromFile(path.toString());
        compiler.setPassConfig(new LintPassConfig(this.options));
        compiler.disableThreads();
        SourceFile externs = SourceFile.fromCode("<Linter externs>", "");
        compiler.compile(ImmutableList.of(externs), ImmutableList.of(file), this.options);
    }

    void fixRepeatedly(String filename) throws IOException {
        this.fixRepeatedly(filename, ImmutableSet.of());
    }

    void fixRepeatedly(String filename, ImmutableSet<DiagnosticType> unfixableErrors) throws IOException {
        for (int i = 0; i < 5 && this.fix(filename, unfixableErrors); ++i) {
        }
    }

    private boolean fix(String filename, ImmutableSet<DiagnosticType> unfixableErrors) throws IOException {
        Compiler compiler = new Compiler(System.out);
        FixingErrorManager errorManager = new FixingErrorManager(unfixableErrors);
        compiler.setErrorManager(errorManager);
        errorManager.setCompiler(compiler);
        this.lint(Paths.get(filename, new String[0]), compiler);
        Collection<SuggestedFix> fixes = errorManager.getSureFixes();
        if (!fixes.isEmpty()) {
            ApplySuggestedFixes.applySuggestedFixesToFiles(fixes);
            return true;
        }
        return false;
    }

    public static final class Builder {
        private final CompilerOptions options = new CompilerOptions();

        private Builder() {
            this.options.setLanguage(CompilerOptions.LanguageMode.ECMASCRIPT_NEXT);
            this.options.setParseJsDocDocumentation(Config.JsDocParsing.INCLUDE_ALL_COMMENTS);
            this.options.setPreserveDetailedSourceInfo(true);
            this.options.setPrettyPrint(true);
            this.options.setPreserveTypeAnnotations(true);
            this.options.setPreferSingleQuotes(true);
            this.options.setEmitUseStrict(false);
            this.options.setParseJsDocDocumentation(Config.JsDocParsing.INCLUDE_ALL_COMMENTS);
            this.options.setCodingConvention(new GoogleCodingConvention());
            this.options.setWarningLevel(DiagnosticGroups.CHECK_TYPES, CheckLevel.WARNING);
            this.options.setWarningLevel(DiagnosticGroups.JSDOC_MISSING_TYPE, CheckLevel.ERROR);
            this.options.setWarningLevel(DiagnosticGroups.MISPLACED_MSG_ANNOTATION, CheckLevel.WARNING);
            this.options.setWarningLevel(DiagnosticGroups.UNNECESSARY_ESCAPE, CheckLevel.WARNING);
            this.options.setWarningLevel(DiagnosticGroups.LINT_CHECKS, CheckLevel.WARNING);
            this.options.setWarningLevel(DiagnosticGroups.UNUSED_LOCAL_VARIABLE, CheckLevel.WARNING);
            this.options.setWarningLevel(DiagnosticGroups.UNUSED_PRIVATE_PROPERTY, CheckLevel.WARNING);
            this.options.setWarningLevel(DiagnosticGroups.STRICT_MISSING_REQUIRE, CheckLevel.ERROR);
            this.options.setWarningLevel(DiagnosticGroups.EXTRA_REQUIRE, CheckLevel.ERROR);
            this.options.setWarningLevel(DiagnosticGroups.MISPLACED_SUPPRESS, CheckLevel.WARNING);
            this.options.setWarningLevel(DiagnosticGroups.TYPE_IMPORT_CODE_REFERENCES, CheckLevel.ERROR);
            this.options.setWarningLevel(DiagnosticGroups.MODULE_LOAD, CheckLevel.OFF);
            this.options.setWarningLevel(DiagnosticGroups.STRICT_MODULE_CHECKS, CheckLevel.WARNING);
            this.options.setWarningLevel(DiagnosticGroups.UNDERSCORE, CheckLevel.WARNING);
            this.options.setSummaryDetailLevel(0);
        }

        public Builder withModuleResolutionMode(ModuleLoader.ResolutionMode moduleResolutionMode) {
            this.options.setModuleResolutionMode(moduleResolutionMode);
            return this;
        }

        public Builder withBrowserResolverPrefixReplacements(ImmutableMap<String, String> replacements) {
            this.options.setBrowserResolverPrefixReplacements(replacements);
            return this;
        }

        public Linter build() {
            return new Linter(this.options);
        }
    }
}

