/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.AstFactory;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.jscomp.jarjar.com.google.common.base.Preconditions;
import com.google.javascript.jscomp.parsing.parser.FeatureSet;
import com.google.javascript.rhino.IR;
import com.google.javascript.rhino.Node;
import java.util.ArrayDeque;

class OptionalChainRewriter {
    final AbstractCompiler compiler;
    final AstFactory astFactory;
    final TmpVarNameCreator tmpVarNameCreator;
    final Node chainParent;
    final Node wholeChain;
    final Node enclosingStatement;

    static Builder builder(AbstractCompiler compiler) {
        return new Builder(compiler);
    }

    private OptionalChainRewriter(Builder builder, Node wholeChain) {
        Preconditions.checkArgument(NodeUtil.isEndOfFullOptChain(wholeChain), wholeChain);
        this.compiler = builder.compiler;
        this.astFactory = builder.astFactory;
        this.tmpVarNameCreator = Preconditions.checkNotNull(builder.tmpVarNameCreator);
        this.wholeChain = wholeChain;
        this.chainParent = Preconditions.checkNotNull(wholeChain.getParent(), wholeChain);
        this.enclosingStatement = NodeUtil.getEnclosingStatement(wholeChain);
    }

    void rewrite() {
        Preconditions.checkState(NodeUtil.isOptChainNode(this.wholeChain), "already rewritten: %s", (Object)this.wholeChain);
        ArrayDeque<Node> startNodeStack = new ArrayDeque<Node>();
        Node subchainEnd = this.wholeChain;
        while (NodeUtil.isOptChainNode(subchainEnd)) {
            Node subchainStart = NodeUtil.getStartOfOptChainSegment(subchainEnd);
            startNodeStack.push(subchainStart);
            subchainEnd = subchainStart.getFirstChild();
        }
        Preconditions.checkState(!startNodeStack.isEmpty());
        Node optChainReplacement = this.rewriteInitialSegment((Node)startNodeStack.pop(), this.wholeChain);
        while (!startNodeStack.isEmpty()) {
            this.rewriteInitialSegment((Node)startNodeStack.pop(), this.wholeChain);
        }
        if (this.chainParent.isCall() && optChainReplacement.isFirstChildOf(this.chainParent) && NodeUtil.isNormalGet(this.wholeChain)) {
            Node thisValue = this.wholeChain.getFirstChild();
            Node tmpThisNode = this.getSubExprNameNode(thisValue);
            optChainReplacement.detach();
            this.chainParent.addChildToFront(tmpThisNode);
            Node dotCallNode = this.astFactory.createGetProp(optChainReplacement, "call").useSourceInfoIfMissingFromForTree(optChainReplacement);
            this.chainParent.addChildToFront(dotCallNode);
        }
        Node enclosingScript = NodeUtil.getEnclosingScript(this.enclosingStatement);
        NodeUtil.addFeatureToScript(enclosingScript, FeatureSet.Feature.LET_DECLARATIONS, this.compiler);
        this.compiler.reportChangeToEnclosingScope(this.chainParent);
    }

    private Node rewriteInitialSegment(Node fullChainStart, Node fullChainEnd) {
        Node receiverNode = fullChainStart.getFirstChild();
        Node initialChainEnd = NodeUtil.getEndOfOptChainSegment(fullChainStart);
        Preconditions.checkArgument(!NodeUtil.isOptChainNode(receiverNode), receiverNode);
        NodeUtil.convertToNonOptionalChainSegment(initialChainEnd);
        Node placeholder = IR.empty();
        fullChainEnd.replaceWith(placeholder);
        if (NodeUtil.isNormalGet(receiverNode) && fullChainStart.isCall()) {
            Node thisValue = receiverNode.getFirstChild();
            Node tmpThisNode = this.getSubExprNameNode(thisValue);
            Node tmpReceiverNode = this.getSubExprNameNode(receiverNode);
            receiverNode = fullChainStart.removeFirstChild();
            fullChainStart.addChildToFront(tmpThisNode);
            fullChainStart.addChildToFront(this.astFactory.createGetProp(tmpReceiverNode, "call").useSourceInfoIfMissingFromForTree(receiverNode));
        } else {
            Node tmpReceiverNode = this.getSubExprNameNode(receiverNode);
            receiverNode = fullChainStart.getFirstChild();
            receiverNode.replaceWith(tmpReceiverNode);
        }
        Node optChainReplacement = this.astFactory.createHook(this.astFactory.createEq(receiverNode, this.astFactory.createNull()), this.astFactory.createUndefinedValue(), fullChainEnd).useSourceInfoIfMissingFromForTree(fullChainEnd);
        placeholder.replaceWith(optChainReplacement);
        return optChainReplacement;
    }

    Node getSubExprNameNode(Node subExpr) {
        String tempVarName = this.declareTempVarName(subExpr);
        Node placeholder = IR.empty();
        subExpr.replaceWith(placeholder);
        Node replacement = this.astFactory.createAssign(tempVarName, subExpr).useSourceInfoIfMissingFromForTree(subExpr);
        placeholder.replaceWith(replacement);
        return replacement.getFirstChild().cloneNode();
    }

    String declareTempVarName(Node valueNode) {
        String tempVarName = this.tmpVarNameCreator.createTmpVarName();
        Node declarationStatement = this.astFactory.createSingleLetNameDeclaration(tempVarName).srcrefTree(valueNode);
        this.enclosingStatement.getParent().addChildBefore(declarationStatement, this.enclosingStatement);
        return tempVarName;
    }

    static class Builder {
        final AbstractCompiler compiler;
        final AstFactory astFactory;
        TmpVarNameCreator tmpVarNameCreator;

        private Builder(AbstractCompiler compiler) {
            this.compiler = Preconditions.checkNotNull(compiler);
            this.astFactory = compiler.createAstFactory();
        }

        Builder setTmpVarNameCreator(TmpVarNameCreator tmpVarNameCreator) {
            this.tmpVarNameCreator = Preconditions.checkNotNull(tmpVarNameCreator);
            return this;
        }

        OptionalChainRewriter build(Node wholeChain) {
            return new OptionalChainRewriter(this, wholeChain);
        }
    }

    static interface TmpVarNameCreator {
        public String createTmpVarName();
    }
}

