/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.CompilerPass;
import com.google.javascript.jscomp.DiagnosticType;
import com.google.javascript.jscomp.GlobalNamespace;
import com.google.javascript.jscomp.JSError;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.jscomp.jarjar.com.google.common.base.MoreObjects;
import com.google.javascript.jscomp.jarjar.com.google.common.base.Preconditions;
import com.google.javascript.jscomp.jarjar.com.google.common.collect.ImmutableMap;
import com.google.javascript.jscomp.jarjar.com.google.common.collect.ImmutableSet;
import com.google.javascript.jscomp.jarjar.com.google.common.collect.Sets;
import com.google.javascript.jscomp.jarjar.javax.annotation.Nullable;
import com.google.javascript.rhino.JSDocInfo;
import com.google.javascript.rhino.JSTypeExpression;
import com.google.javascript.rhino.Node;
import com.google.javascript.rhino.jstype.JSType;
import com.google.javascript.rhino.jstype.JSTypeNative;
import com.google.javascript.rhino.jstype.JSTypeRegistry;
import com.google.javascript.rhino.jstype.TernaryValue;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.Logger;

class ProcessDefines
implements CompilerPass {
    private static final Logger logger = Logger.getLogger("com.google.javascript.jscomp.ProcessDefines");
    private static final ImmutableSet<String> KNOWN_DEFINES = ImmutableSet.of("COMPILED", "goog.DEBUG", "$jscomp.ISOLATE_POLYFILLS");
    private final AbstractCompiler compiler;
    private final Map<String, Node> dominantReplacements;
    private final boolean checksOnly;
    private final Supplier<GlobalNamespace> namespaceSupplier;
    private final LinkedHashSet<JSDocInfo> knownDefineJsdocs = new LinkedHashSet();
    private final LinkedHashMap<String, Define> defineByDefineName = new LinkedHashMap();
    private final LinkedHashSet<Node> validDefineValueExpressions = new LinkedHashSet();
    private GlobalNamespace namespace;
    static final DiagnosticType UNKNOWN_DEFINE_WARNING = DiagnosticType.warning("JSC_UNKNOWN_DEFINE_WARNING", "unknown @define variable {0}");
    static final DiagnosticType INVALID_DEFINE_TYPE = DiagnosticType.error("JSC_INVALID_DEFINE_TYPE", "@define tag only permits primitive types");
    static final DiagnosticType INVALID_DEFINE_VALUE = DiagnosticType.error("JSC_INVALID_DEFINE_VALUE", "invalid initialization value for @define {0}");
    static final DiagnosticType INVALID_DEFINE_LOCATION = DiagnosticType.error("JSC_INVALID_DEFINE_LOCATION", "@define must be initalized on a static qualified name in global or module scope");
    static final DiagnosticType NON_CONST_DEFINE = DiagnosticType.error("JSC_NON_CONST_DEFINE", "@define {0} has already been set at {1}.");

    private ProcessDefines(Builder builder) {
        this.compiler = builder.compiler;
        this.dominantReplacements = ImmutableMap.copyOf(builder.replacements);
        this.checksOnly = builder.checksOnly;
        this.namespaceSupplier = builder.namespaceSupplier;
    }

    @Override
    public void process(Node externs, Node root) {
        this.initNamespace(externs, root);
        this.collectDefines();
        this.reportDefineUnknownDeclarations(root);
        this.collectValidDefineValueExpressions();
        this.validateDefineDeclarations();
        this.overrideDefines();
    }

    final ImmutableSet<String> collectDefineNames(Node externs, Node root) {
        this.initNamespace(externs, root);
        this.collectDefines();
        return ImmutableSet.copyOf(this.defineByDefineName.keySet());
    }

    private void initNamespace(Node externs, Node root) {
        if (this.namespaceSupplier != null) {
            this.namespace = this.namespaceSupplier.get();
        }
        if (this.namespace == null) {
            this.namespace = new GlobalNamespace(this.compiler, externs, root);
        }
    }

    private void overrideDefines() {
        if (!this.checksOnly) {
            for (Define define : this.defineByDefineName.values()) {
                boolean changed;
                String defineName;
                Node inputValue;
                if (define.valueParent == null || (inputValue = this.dominantReplacements.get(defineName = define.defineName)) == null || inputValue == define.value) continue;
                if (logger.isLoggable(Level.FINE)) {
                    logger.fine("Overriding @define variable " + defineName);
                }
                if (!(changed = define.value == null || inputValue.getToken() != define.value.getToken() || !inputValue.isEquivalentTo(define.value))) continue;
                if (define.value == null) {
                    define.valueParent.addChildToBack(inputValue.cloneTree());
                } else {
                    define.value.replaceWith(inputValue.cloneTree());
                }
                this.compiler.reportChangeToEnclosingScope(define.valueParent);
            }
        }
        Sets.SetView<String> unusedReplacements = Sets.difference(this.dominantReplacements.keySet(), Sets.union(KNOWN_DEFINES, this.defineByDefineName.keySet()));
        for (String unknownDefine : unusedReplacements) {
            this.compiler.report(JSError.make(UNKNOWN_DEFINE_WARNING, unknownDefine));
        }
    }

    private boolean isValidDefineType(JSTypeExpression expression) {
        JSTypeRegistry registry = this.compiler.getTypeRegistry();
        JSType type = registry.evaluateTypeExpressionInGlobalScope(expression);
        return !type.isUnknownType() && type.isSubtypeOf(registry.getNativeType(JSTypeNative.NUMBER_STRING_BOOLEAN));
    }

    private void collectDefines() {
        for (GlobalNamespace.Name name : this.namespace.getAllSymbols()) {
            GlobalNamespace.Ref declaration = this.selectDefineDeclaration(name);
            if (declaration == null) continue;
            int totalSets = name.getTotalSets();
            String defineName = MoreObjects.firstNonNull(declaration.getNode().getDefineName(), name.getFullName());
            Define existingDefine = this.defineByDefineName.putIfAbsent(defineName, ProcessDefines.createDefine(defineName, name, declaration));
            if (existingDefine != null) {
                declaration = existingDefine.declaration;
                totalSets += existingDefine.name.getTotalSets();
            }
            if (totalSets <= 1) continue;
            for (GlobalNamespace.Ref ref : name.getRefs()) {
                if (!ref.isSet() || ref.equals(declaration)) continue;
                this.compiler.report(JSError.make(ref.getNode(), NON_CONST_DEFINE, defineName, declaration.getNode().getLocation()));
            }
        }
    }

    @Nullable
    private GlobalNamespace.Ref selectDefineDeclaration(GlobalNamespace.Name name) {
        for (GlobalNamespace.Ref ref : name.getRefs()) {
            JSDocInfo jsdoc;
            Node refNode;
            if (!GlobalNamespace.Ref.Type.SET_FROM_GLOBAL.equals((Object)ref.type) || !(refNode = ref.getNode()).isQualifiedName() || (jsdoc = NodeUtil.getBestJSDocInfo(refNode)) == null || !jsdoc.isDefine()) continue;
            this.knownDefineJsdocs.add(jsdoc);
            return ref;
        }
        return null;
    }

    private static Define createDefine(String defineName, GlobalNamespace.Name name, GlobalNamespace.Ref declaration) {
        Preconditions.checkState(declaration.isSet());
        Node declarationNode = declaration.getNode();
        Node declarationParent = declarationNode.getParent();
        Node valueParent = null;
        Node value = null;
        if (declarationParent.isVar() || declarationParent.isConst()) {
            Preconditions.checkState(declarationNode.isName(), declarationNode);
            valueParent = declarationNode;
            value = declarationNode.getFirstChild();
        } else if (declarationParent.isAssign() && declarationNode.isFirstChildOf(declarationParent)) {
            valueParent = declarationParent;
            value = declarationParent.getLastChild();
        }
        return new Define(defineName, name, declaration, valueParent, value);
    }

    private void collectValidDefineValueExpressions() {
        LinkedHashSet namesToCheck = new LinkedHashSet(this.namespace.getAllSymbols());
        for (Define define : this.defineByDefineName.values()) {
            namesToCheck.remove(define.name);
            define.name.getRefs().stream().filter(r -> !r.isSet()).map(GlobalNamespace.Ref::getNode).forEachOrdered(this.validDefineValueExpressions::add);
        }
        boolean additionalNameFoundValid = true;
        while (additionalNameFoundValid) {
            additionalNameFoundValid = false;
            LinkedHashSet<GlobalNamespace.Name> indeterminateNames = new LinkedHashSet<GlobalNamespace.Name>();
            for (GlobalNamespace.Name name : namesToCheck) {
                if (!ProcessDefines.isGlobalConst(name)) continue;
                Node declValue = ProcessDefines.getConstantDeclValue(name.getDeclaration().getNode());
                switch (this.isValidDefineValue(declValue)) {
                    case TRUE: {
                        for (GlobalNamespace.Ref ref : name.getRefs()) {
                            this.validDefineValueExpressions.add(ref.getNode());
                        }
                        additionalNameFoundValid = true;
                        break;
                    }
                    case UNKNOWN: {
                        indeterminateNames.add(name);
                        break;
                    }
                }
            }
            namesToCheck = indeterminateNames;
        }
    }

    private final void validateDefineDeclarations() {
        for (Define define : this.defineByDefineName.values()) {
            JSDocInfo jsdoc;
            Node declarationNode = define.declaration.getNode();
            if (!this.hasValidValue(define)) {
                this.compiler.report(JSError.make(MoreObjects.firstNonNull(define.value, MoreObjects.firstNonNull(define.valueParent, declarationNode)), INVALID_DEFINE_VALUE, define.defineName));
            }
            if ((jsdoc = NodeUtil.getBestJSDocInfo(declarationNode)) != null && this.isValidDefineType(jsdoc.getType())) continue;
            this.compiler.report(JSError.make(declarationNode, INVALID_DEFINE_TYPE, new String[0]));
        }
    }

    private void reportDefineUnknownDeclarations(Node root) {
        NodeTraversal.traversePostOrder(this.compiler, root, (t, n, parent) -> {
            JSDocInfo jsdoc = n.getJSDocInfo();
            if (jsdoc != null && jsdoc.isDefine() && this.knownDefineJsdocs.add(jsdoc)) {
                this.compiler.report(JSError.make(n, INVALID_DEFINE_LOCATION, new String[0]));
            }
        });
    }

    private boolean hasValidValue(Define define) {
        if (define.valueParent == null) {
            return false;
        }
        if (define.valueParent.isFromExterns()) {
            return true;
        }
        return this.isValidDefineValue(define.value).toBoolean(false);
    }

    private static boolean isGlobalConst(GlobalNamespace.Name name) {
        return name.getTotalSets() == 1 && name.getDeclaration() != null && name.getDeclaration().type.equals((Object)GlobalNamespace.Ref.Type.SET_FROM_GLOBAL);
    }

    private TernaryValue isValidDefineValue(@Nullable Node val) {
        if (val == null) {
            return TernaryValue.FALSE;
        }
        switch (val.getToken()) {
            case STRING: 
            case NUMBER: 
            case TRUE: 
            case FALSE: {
                return TernaryValue.TRUE;
            }
            case AND: 
            case OR: 
            case ADD: 
            case BITAND: 
            case BITNOT: 
            case BITOR: 
            case BITXOR: 
            case DIV: 
            case EQ: 
            case EXPONENT: 
            case GE: 
            case GT: 
            case LE: 
            case LSH: 
            case LT: 
            case MOD: 
            case MUL: 
            case NE: 
            case RSH: 
            case SHEQ: 
            case SHNE: 
            case SUB: 
            case URSH: {
                return this.isValidDefineValue(val.getFirstChild()).and(this.isValidDefineValue(val.getLastChild()));
            }
            case HOOK: {
                return this.isValidDefineValue(val.getFirstChild()).and(this.isValidDefineValue(val.getSecondChild())).and(this.isValidDefineValue(val.getLastChild()));
            }
            case NOT: 
            case NEG: 
            case POS: {
                return this.isValidDefineValue(val.getFirstChild());
            }
            case NAME: 
            case GETPROP: {
                if (!val.isQualifiedName()) break;
                return this.validDefineValueExpressions.contains(val) ? TernaryValue.TRUE : TernaryValue.UNKNOWN;
            }
        }
        return TernaryValue.FALSE;
    }

    private static Node getConstantDeclValue(Node name) {
        Node parent = name.getParent();
        if (parent == null) {
            return null;
        }
        if (name.isName()) {
            if (parent.isConst()) {
                return name.getFirstChild();
            }
            if (!parent.isVar()) {
                return null;
            }
            JSDocInfo jsdoc = NodeUtil.getBestJSDocInfo(name);
            return jsdoc != null && jsdoc.isConstant() ? name.getFirstChild() : null;
        }
        if (name.isGetProp() && parent.isAssign()) {
            JSDocInfo jsdoc = NodeUtil.getBestJSDocInfo(name);
            return jsdoc != null && jsdoc.isConstant() ? name.getNext() : null;
        }
        return null;
    }

    private static final class Define {
        final String defineName;
        final GlobalNamespace.Name name;
        final GlobalNamespace.Ref declaration;
        @Nullable
        final Node valueParent;
        @Nullable
        final Node value;

        public Define(String defineName, GlobalNamespace.Name name, GlobalNamespace.Ref declaration, @Nullable Node valueParent, @Nullable Node value) {
            Preconditions.checkState(valueParent == null || value == null || value.getParent() == valueParent);
            Preconditions.checkState(declaration.isSet());
            Preconditions.checkState(declaration.name.equals(name));
            this.defineName = defineName;
            this.name = name;
            this.declaration = declaration;
            this.valueParent = valueParent;
            this.value = value;
        }
    }

    static class Builder {
        private final AbstractCompiler compiler;
        private final Map<String, Node> replacements = new LinkedHashMap<String, Node>();
        private boolean checksOnly;
        private Supplier<GlobalNamespace> namespaceSupplier;

        Builder(AbstractCompiler compiler) {
            this.compiler = compiler;
        }

        Builder putReplacements(Map<String, Node> replacements) {
            this.replacements.putAll(replacements);
            return this;
        }

        Builder checksOnly(boolean checksOnly) {
            this.checksOnly = checksOnly;
            return this;
        }

        Builder injectNamespace(Supplier<GlobalNamespace> namespaceSupplier) {
            this.namespaceSupplier = namespaceSupplier;
            return this;
        }

        ProcessDefines build() {
            return new ProcessDefines(this);
        }
    }
}

