/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp.bundle;

import com.google.javascript.jscomp.ErrorFormat;
import com.google.javascript.jscomp.JSError;
import com.google.javascript.jscomp.MessageFormatter;
import com.google.javascript.jscomp.SourceExcerptProvider;
import com.google.javascript.jscomp.jarjar.com.google.common.annotations.GwtIncompatible;
import com.google.javascript.jscomp.jarjar.com.google.common.collect.ImmutableList;

@GwtIncompatible
public class TranspilationException
extends RuntimeException {
    private final ImmutableList<JSError> errors;
    private final ImmutableList<JSError> warnings;

    public TranspilationException(Exception cause) {
        this(TranspilationException.tryCastToTranspilationException(cause.getCause()), cause);
    }

    public TranspilationException(SourceExcerptProvider source, ImmutableList<JSError> errors, ImmutableList<JSError> warnings) {
        this(ImmutableList.copyOf(errors), ImmutableList.copyOf(warnings), TranspilationException.format(source, errors, warnings), null);
    }

    private TranspilationException(TranspilationException root, Exception cause) {
        this(root.errors, root.warnings, root.getMessage(), cause);
    }

    private TranspilationException(ImmutableList<JSError> errors, ImmutableList<JSError> warnings, String formatted, Exception cause) {
        super(formatted, cause);
        this.errors = errors;
        this.warnings = warnings;
    }

    public ImmutableList<JSError> errors() {
        return this.errors;
    }

    public ImmutableList<JSError> warnings() {
        return this.warnings;
    }

    private static String format(SourceExcerptProvider source, ImmutableList<JSError> errors, ImmutableList<JSError> warnings) {
        StringBuilder sb = new StringBuilder().append("Transpilation failed:\n");
        MessageFormatter formatter = source != null ? ErrorFormat.SINGLELINE.toFormatter(source, false) : ErrorFormat.SOURCELESS.toFormatter(source, false);
        for (JSError error : errors) {
            sb.append("\n").append(formatter.formatError(error));
        }
        for (JSError warning : warnings) {
            sb.append("\n").append(formatter.formatError(warning));
        }
        return sb.toString();
    }

    private static TranspilationException tryCastToTranspilationException(Throwable t) {
        if (t instanceof TranspilationException) {
            return (TranspilationException)t;
        }
        return null;
    }
}

