/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp.colors;

import com.google.javascript.jscomp.colors.AutoValue_UnionColor;
import com.google.javascript.jscomp.colors.Color;
import com.google.javascript.jscomp.colors.PrimitiveColor;
import com.google.javascript.jscomp.jarjar.com.google.auto.value.AutoValue;
import com.google.javascript.jscomp.jarjar.com.google.common.base.Preconditions;
import com.google.javascript.jscomp.jarjar.com.google.common.collect.ImmutableCollection;
import com.google.javascript.jscomp.jarjar.com.google.common.collect.ImmutableSet;
import com.google.javascript.jscomp.jarjar.com.google.errorprone.annotations.Immutable;

@Immutable
@AutoValue
public abstract class UnionColor
implements Color {
    public static UnionColor create(ImmutableSet<Color> alternates) {
        Preconditions.checkArgument(alternates.size() > 1, "UnionColor alternates should have more than one element, found %s", alternates);
        ImmutableSet.Builder flatAlternates = ImmutableSet.builder();
        for (Color alternate : alternates) {
            if (alternate.isUnion()) {
                flatAlternates.addAll(alternate.getAlternates());
                continue;
            }
            flatAlternates.add(alternate);
        }
        return new AutoValue_UnionColor(flatAlternates.build());
    }

    @Override
    public boolean isPrimitive() {
        return false;
    }

    @Override
    public boolean isUnion() {
        return true;
    }

    @Override
    public boolean isObject() {
        return false;
    }

    @Override
    public abstract ImmutableCollection<Color> getAlternates();

    @Override
    public boolean isInvalidating() {
        for (Color alt : this.getAlternates()) {
            if (alt.equals(PrimitiveColor.NULL_OR_VOID) || !alt.isInvalidating()) continue;
            return true;
        }
        return false;
    }
}

