/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp.deps;

import com.google.javascript.jscomp.jarjar.com.google.common.collect.ImmutableMap;
import com.google.javascript.jscomp.jarjar.com.google.common.escape.ArrayBasedCharEscaper;
import com.google.javascript.jscomp.jarjar.com.google.common.escape.Escaper;
import java.io.IOException;

public final class SourceCodeEscapers {
    private static final char PRINTABLE_ASCII_MIN = ' ';
    private static final char PRINTABLE_ASCII_MAX = '~';
    private static final char[] HEX_DIGITS = "0123456789abcdef".toCharArray();
    private static final JavaScriptEscaper JAVASCRIPT_ESCAPER = new JavaScriptEscaper();

    private SourceCodeEscapers() {
    }

    public static Escaper javascriptEscaper() {
        return JAVASCRIPT_ESCAPER;
    }

    public static void appendWithJavascriptEscaper(CharSequence c, Appendable to) throws IOException {
        JAVASCRIPT_ESCAPER.appendTo(c, to);
    }

    private static char[] asUnicodeHexEscape(char c) {
        char[] r = new char[6];
        r[0] = 92;
        r[1] = 117;
        r[5] = HEX_DIGITS[c & 0xF];
        c = (char)(c >>> 4);
        r[4] = HEX_DIGITS[c & 0xF];
        c = (char)(c >>> 4);
        r[3] = HEX_DIGITS[c & 0xF];
        c = (char)(c >>> 4);
        r[2] = HEX_DIGITS[c & 0xF];
        return r;
    }

    private static final class JavaScriptEscaper
    extends ArrayBasedCharEscaper {
        private static final ImmutableMap<Character, String> JS_MAP = ImmutableMap.builder().put(Character.valueOf('\''), "\\x27").put(Character.valueOf('\"'), "\\x22").put(Character.valueOf('<'), "\\x3c").put(Character.valueOf('='), "\\x3d").put(Character.valueOf('>'), "\\x3e").put(Character.valueOf('&'), "\\x26").put(Character.valueOf('\b'), "\\b").put(Character.valueOf('\t'), "\\t").put(Character.valueOf('\n'), "\\n").put(Character.valueOf('\f'), "\\f").put(Character.valueOf('\r'), "\\r").put(Character.valueOf('\\'), "\\\\").build();

        JavaScriptEscaper() {
            super(JS_MAP, ' ', '~');
        }

        @Override
        protected char[] escapeUnsafe(char c) {
            if (c < '\u0100') {
                char[] r = new char[4];
                r[3] = HEX_DIGITS[c & 0xF];
                c = (char)(c >>> 4);
                r[2] = HEX_DIGITS[c & 0xF];
                r[1] = 120;
                r[0] = 92;
                return r;
            }
            return SourceCodeEscapers.asUnicodeHexEscape(c);
        }

        void appendTo(CharSequence c, Appendable to) throws IOException {
            int l = c.length();
            for (int i = 0; i < l; ++i) {
                char unescaped = c.charAt(i);
                char[] escaped = this.escape(unescaped);
                if (escaped != null) {
                    for (char value : escaped) {
                        to.append(value);
                    }
                    continue;
                }
                to.append(unescaped);
            }
        }
    }
}

