/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp.ijs;

import com.google.javascript.jscomp.ijs.PotentialDeclaration;
import com.google.javascript.jscomp.jarjar.com.google.common.base.Preconditions;
import com.google.javascript.jscomp.jarjar.com.google.common.collect.ListMultimap;
import com.google.javascript.jscomp.jarjar.com.google.common.collect.MultimapBuilder;
import com.google.javascript.rhino.Node;
import java.util.HashSet;
import java.util.Set;

final class FileInfo {
    private final Set<String> providedNamespaces = new HashSet<String>();
    private final Set<String> requiredLocalNames = new HashSet<String>();
    private final ListMultimap<String, PotentialDeclaration> declarations = MultimapBuilder.linkedHashKeys().arrayListValues().build();

    FileInfo() {
    }

    void recordNameDeclaration(Node qualifiedNameNode) {
        this.recordDeclaration(PotentialDeclaration.fromName(qualifiedNameNode));
    }

    void recordMethod(Node functionNode) {
        this.recordDeclaration(PotentialDeclaration.fromMethod(functionNode));
    }

    void recordStringKeyDeclaration(Node stringKeyNode) {
        this.recordDeclaration(PotentialDeclaration.fromStringKey(stringKeyNode));
    }

    void recordDefine(Node callNode) {
        this.recordDeclaration(PotentialDeclaration.fromDefine(callNode));
    }

    void recordAliasDeclaration(Node nameNode) {
        this.recordDeclaration(PotentialDeclaration.fromAlias(nameNode));
    }

    ListMultimap<String, PotentialDeclaration> getDeclarations() {
        return this.declarations;
    }

    void recordDeclaration(PotentialDeclaration decl) {
        this.declarations.put(decl.getFullyQualifiedName(), decl);
    }

    void recordImport(String localName) {
        this.requiredLocalNames.add(localName);
    }

    boolean isNameDeclared(String fullyQualifiedName) {
        return this.declarations.containsKey(fullyQualifiedName);
    }

    private static boolean containsPrefix(String fullyQualifiedName, Iterable<String> prefixNamespaces) {
        for (String prefix : prefixNamespaces) {
            if (!fullyQualifiedName.equals(prefix) && !fullyQualifiedName.startsWith(prefix + ".")) continue;
            return true;
        }
        return false;
    }

    boolean isPrefixProvided(String fullyQualifiedName) {
        return FileInfo.containsPrefix(fullyQualifiedName, this.providedNamespaces);
    }

    boolean isPrefixRequired(String fullyQualifiedName) {
        return FileInfo.containsPrefix(fullyQualifiedName, this.requiredLocalNames);
    }

    boolean isStrictPrefixDeclared(String fullyQualifiedName) {
        for (String prefix : this.declarations.keySet()) {
            if (!fullyQualifiedName.startsWith(prefix + ".")) continue;
            return true;
        }
        return false;
    }

    void markProvided(String providedName) {
        Preconditions.checkNotNull(providedName);
        this.providedNamespaces.add(providedName);
    }
}

