/*
 * Decompiled with CFR 0.152.
 */
package com.google.maps.android.clustering.algo;

import android.util.SparseArray;
import com.google.maps.android.clustering.Cluster;
import com.google.maps.android.clustering.ClusterItem;
import com.google.maps.android.clustering.algo.Algorithm;
import com.google.maps.android.clustering.algo.StaticCluster;
import com.google.maps.android.projection.Point;
import com.google.maps.android.projection.SphericalMercatorProjection;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;

public class GridBasedAlgorithm<T extends ClusterItem>
implements Algorithm<T> {
    private static final String TAG = GridBasedAlgorithm.class.getName();
    private static final int GRID_SIZE = 100;
    private final Set<T> mItems = new HashSet<T>();

    @Override
    public void addItem(T item) {
        this.mItems.add(item);
    }

    @Override
    public void addItems(Collection<T> items) {
        this.mItems.addAll(items);
    }

    @Override
    public void clearItems() {
        this.mItems.clear();
    }

    @Override
    public void removeItem(T item) {
        this.mItems.remove(item);
    }

    @Override
    public Set<? extends Cluster<T>> getClusters(double zoom) {
        int numCells = (int)Math.ceil(256.0 * Math.pow(2.0, zoom) / 100.0);
        SphericalMercatorProjection proj = new SphericalMercatorProjection(numCells);
        HashSet<StaticCluster<ClusterItem>> clusters = new HashSet<StaticCluster<ClusterItem>>();
        SparseArray sparseArray = new SparseArray();
        for (ClusterItem item : this.mItems) {
            Point p = proj.toPoint(item.getPosition());
            int coord = GridBasedAlgorithm.getCoord(numCells, p.x, p.y);
            StaticCluster<ClusterItem> cluster = (StaticCluster<ClusterItem>)sparseArray.get(coord);
            if (cluster == null) {
                cluster = new StaticCluster<ClusterItem>(proj.toLatLng(new com.google.maps.android.geometry.Point(Math.floor(p.x) + 0.5, Math.floor(p.y) + 0.5)));
                sparseArray.put(coord, cluster);
                clusters.add(cluster);
            }
            cluster.add(item);
        }
        return clusters;
    }

    @Override
    public Collection<T> getItems() {
        return this.mItems;
    }

    private static int getCoord(long numCells, double x, double y) {
        return (int)((double)numCells * Math.floor(x) + Math.floor(y));
    }
}

