/*
 * Decompiled with CFR 0.152.
 */
package com.google.maps.android.geojson;

import com.google.android.gms.maps.GoogleMap;
import com.google.android.gms.maps.model.Marker;
import com.google.android.gms.maps.model.MarkerOptions;
import com.google.android.gms.maps.model.Polygon;
import com.google.android.gms.maps.model.PolygonOptions;
import com.google.android.gms.maps.model.Polyline;
import com.google.android.gms.maps.model.PolylineOptions;
import com.google.maps.android.geojson.GeoJsonFeature;
import com.google.maps.android.geojson.GeoJsonGeometry;
import com.google.maps.android.geojson.GeoJsonGeometryCollection;
import com.google.maps.android.geojson.GeoJsonLineString;
import com.google.maps.android.geojson.GeoJsonLineStringStyle;
import com.google.maps.android.geojson.GeoJsonMultiLineString;
import com.google.maps.android.geojson.GeoJsonMultiPoint;
import com.google.maps.android.geojson.GeoJsonMultiPolygon;
import com.google.maps.android.geojson.GeoJsonPoint;
import com.google.maps.android.geojson.GeoJsonPointStyle;
import com.google.maps.android.geojson.GeoJsonPolygon;
import com.google.maps.android.geojson.GeoJsonPolygonStyle;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Observable;
import java.util.Observer;
import java.util.Set;

class GeoJsonRenderer
implements Observer {
    private static final int POLYGON_OUTER_COORDINATE_INDEX = 0;
    private static final int POLYGON_INNER_COORDINATE_INDEX = 1;
    private static final Object FEATURE_NOT_ON_MAP = null;
    private final HashMap<GeoJsonFeature, Object> mFeatures;
    private final GeoJsonPointStyle mDefaultPointStyle;
    private final GeoJsonLineStringStyle mDefaultLineStringStyle;
    private final GeoJsonPolygonStyle mDefaultPolygonStyle;
    private boolean mLayerOnMap;
    private GoogleMap mMap;

    GeoJsonRenderer(GoogleMap map, HashMap<GeoJsonFeature, Object> features) {
        this.mMap = map;
        this.mFeatures = features;
        this.mLayerOnMap = false;
        this.mDefaultPointStyle = new GeoJsonPointStyle();
        this.mDefaultLineStringStyle = new GeoJsonLineStringStyle();
        this.mDefaultPolygonStyle = new GeoJsonPolygonStyle();
        for (GeoJsonFeature feature : this.getFeatures()) {
            this.setFeatureDefaultStyles(feature);
        }
    }

    private static void removeFromMap(Object mapObject) {
        if (mapObject instanceof Marker) {
            ((Marker)mapObject).remove();
        } else if (mapObject instanceof Polyline) {
            ((Polyline)mapObject).remove();
        } else if (mapObject instanceof Polygon) {
            ((Polygon)mapObject).remove();
        } else if (mapObject instanceof ArrayList) {
            for (Object mapObjectElement : (ArrayList)mapObject) {
                GeoJsonRenderer.removeFromMap(mapObjectElement);
            }
        }
    }

    boolean isLayerOnMap() {
        return this.mLayerOnMap;
    }

    GoogleMap getMap() {
        return this.mMap;
    }

    void setMap(GoogleMap map) {
        for (GeoJsonFeature feature : this.getFeatures()) {
            this.redrawFeatureToMap(feature, map);
        }
    }

    void addLayerToMap() {
        if (!this.mLayerOnMap) {
            this.mLayerOnMap = true;
            for (GeoJsonFeature feature : this.getFeatures()) {
                this.addFeature(feature);
            }
        }
    }

    Set<GeoJsonFeature> getFeatures() {
        return this.mFeatures.keySet();
    }

    private void setFeatureDefaultStyles(GeoJsonFeature feature) {
        if (feature.getPointStyle() == null) {
            feature.setPointStyle(this.mDefaultPointStyle);
        }
        if (feature.getLineStringStyle() == null) {
            feature.setLineStringStyle(this.mDefaultLineStringStyle);
        }
        if (feature.getPolygonStyle() == null) {
            feature.setPolygonStyle(this.mDefaultPolygonStyle);
        }
    }

    void addFeature(GeoJsonFeature feature) {
        Object mapObject = FEATURE_NOT_ON_MAP;
        this.setFeatureDefaultStyles(feature);
        if (this.mLayerOnMap) {
            feature.addObserver(this);
            if (this.mFeatures.containsKey(feature)) {
                GeoJsonRenderer.removeFromMap(this.mFeatures.get(feature));
            }
            if (feature.hasGeometry()) {
                mapObject = this.addFeatureToMap(feature, feature.getGeometry());
            }
        }
        this.mFeatures.put(feature, mapObject);
    }

    void removeLayerFromMap() {
        if (this.mLayerOnMap) {
            for (GeoJsonFeature feature : this.mFeatures.keySet()) {
                GeoJsonRenderer.removeFromMap(this.mFeatures.get(feature));
                feature.deleteObserver(this);
            }
            this.mLayerOnMap = false;
        }
    }

    void removeFeature(GeoJsonFeature feature) {
        if (this.mFeatures.containsKey(feature)) {
            GeoJsonRenderer.removeFromMap(this.mFeatures.remove(feature));
            feature.deleteObserver(this);
        }
    }

    GeoJsonPointStyle getDefaultPointStyle() {
        return this.mDefaultPointStyle;
    }

    GeoJsonLineStringStyle getDefaultLineStringStyle() {
        return this.mDefaultLineStringStyle;
    }

    GeoJsonPolygonStyle getDefaultPolygonStyle() {
        return this.mDefaultPolygonStyle;
    }

    private Object addFeatureToMap(GeoJsonFeature feature, GeoJsonGeometry geometry) {
        String geometryType = geometry.getType();
        if (geometryType.equals("Point")) {
            return this.addPointToMap(feature.getPointStyle(), (GeoJsonPoint)geometry);
        }
        if (geometryType.equals("LineString")) {
            return this.addLineStringToMap(feature.getLineStringStyle(), (GeoJsonLineString)geometry);
        }
        if (geometryType.equals("Polygon")) {
            return this.addPolygonToMap(feature.getPolygonStyle(), (GeoJsonPolygon)geometry);
        }
        if (geometryType.equals("MultiPoint")) {
            return this.addMultiPointToMap(feature.getPointStyle(), (GeoJsonMultiPoint)geometry);
        }
        if (geometryType.equals("MultiLineString")) {
            return this.addMultiLineStringToMap(feature.getLineStringStyle(), (GeoJsonMultiLineString)geometry);
        }
        if (geometryType.equals("MultiPolygon")) {
            return this.addMultiPolygonToMap(feature.getPolygonStyle(), (GeoJsonMultiPolygon)geometry);
        }
        if (geometryType.equals("GeometryCollection")) {
            return this.addGeometryCollectionToMap(feature, ((GeoJsonGeometryCollection)geometry).getGeometries());
        }
        return null;
    }

    private Marker addPointToMap(GeoJsonPointStyle pointStyle, GeoJsonPoint point) {
        MarkerOptions markerOptions = pointStyle.toMarkerOptions();
        markerOptions.position(point.getCoordinates());
        return this.mMap.addMarker(markerOptions);
    }

    private ArrayList<Marker> addMultiPointToMap(GeoJsonPointStyle pointStyle, GeoJsonMultiPoint multiPoint) {
        ArrayList<Marker> markers = new ArrayList<Marker>();
        for (GeoJsonPoint geoJsonPoint : multiPoint.getPoints()) {
            markers.add(this.addPointToMap(pointStyle, geoJsonPoint));
        }
        return markers;
    }

    private Polyline addLineStringToMap(GeoJsonLineStringStyle lineStringStyle, GeoJsonLineString lineString) {
        PolylineOptions polylineOptions = lineStringStyle.toPolylineOptions();
        polylineOptions.addAll(lineString.getCoordinates());
        return this.mMap.addPolyline(polylineOptions);
    }

    private ArrayList<Polyline> addMultiLineStringToMap(GeoJsonLineStringStyle lineStringStyle, GeoJsonMultiLineString multiLineString) {
        ArrayList<Polyline> polylines = new ArrayList<Polyline>();
        for (GeoJsonLineString geoJsonLineString : multiLineString.getLineStrings()) {
            polylines.add(this.addLineStringToMap(lineStringStyle, geoJsonLineString));
        }
        return polylines;
    }

    private Polygon addPolygonToMap(GeoJsonPolygonStyle polygonStyle, GeoJsonPolygon polygon) {
        PolygonOptions polygonOptions = polygonStyle.toPolygonOptions();
        polygonOptions.addAll((Iterable)polygon.getCoordinates().get(0));
        for (int i = 1; i < polygon.getCoordinates().size(); ++i) {
            polygonOptions.addHole((Iterable)polygon.getCoordinates().get(i));
        }
        return this.mMap.addPolygon(polygonOptions);
    }

    private ArrayList<Polygon> addMultiPolygonToMap(GeoJsonPolygonStyle polygonStyle, GeoJsonMultiPolygon multiPolygon) {
        ArrayList<Polygon> polygons = new ArrayList<Polygon>();
        for (GeoJsonPolygon geoJsonPolygon : multiPolygon.getPolygons()) {
            polygons.add(this.addPolygonToMap(polygonStyle, geoJsonPolygon));
        }
        return polygons;
    }

    private ArrayList<Object> addGeometryCollectionToMap(GeoJsonFeature feature, List<GeoJsonGeometry> geoJsonGeometries) {
        ArrayList<Object> geometries = new ArrayList<Object>();
        for (GeoJsonGeometry geometry : geoJsonGeometries) {
            geometries.add(this.addFeatureToMap(feature, geometry));
        }
        return geometries;
    }

    private void redrawFeatureToMap(GeoJsonFeature feature) {
        this.redrawFeatureToMap(feature, this.mMap);
    }

    private void redrawFeatureToMap(GeoJsonFeature feature, GoogleMap map) {
        GeoJsonRenderer.removeFromMap(this.mFeatures.get(feature));
        this.mFeatures.put(feature, FEATURE_NOT_ON_MAP);
        this.mMap = map;
        if (map != null && feature.hasGeometry()) {
            this.mFeatures.put(feature, this.addFeatureToMap(feature, feature.getGeometry()));
        }
    }

    @Override
    public void update(Observable observable, Object data) {
        if (observable instanceof GeoJsonFeature) {
            boolean featureIsOnMap;
            GeoJsonFeature feature = (GeoJsonFeature)observable;
            boolean bl = featureIsOnMap = this.mFeatures.get(feature) != FEATURE_NOT_ON_MAP;
            if (featureIsOnMap && feature.hasGeometry()) {
                this.redrawFeatureToMap(feature);
            } else if (featureIsOnMap && !feature.hasGeometry()) {
                GeoJsonRenderer.removeFromMap(this.mFeatures.get(feature));
                this.mFeatures.put(feature, FEATURE_NOT_ON_MAP);
            } else if (!featureIsOnMap && feature.hasGeometry()) {
                this.addFeature(feature);
            }
        }
    }
}

