/*
 * Decompiled with CFR 0.152.
 */
package com.google.maps.android.ui;

import android.content.Context;
import android.graphics.Canvas;
import android.util.AttributeSet;
import android.widget.TextView;

public class SquareTextView
extends TextView {
    private int mOffsetTop = 0;
    private int mOffsetLeft = 0;

    public SquareTextView(Context context) {
        super(context);
    }

    public SquareTextView(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    public SquareTextView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        int width = this.getMeasuredWidth();
        int height = this.getMeasuredHeight();
        int dimension = Math.max(width, height);
        if (width > height) {
            this.mOffsetTop = width - height;
            this.mOffsetLeft = 0;
        } else {
            this.mOffsetTop = 0;
            this.mOffsetLeft = height - width;
        }
        this.setMeasuredDimension(dimension, dimension);
    }

    public void draw(Canvas canvas) {
        canvas.translate((float)(this.mOffsetLeft / 2), (float)(this.mOffsetTop / 2));
        super.draw(canvas);
    }
}

