/*
 * Decompiled with CFR 0.152.
 */
package com.google.maps.android.data.geojson;

import com.google.android.gms.maps.model.LatLng;
import com.google.maps.android.data.DataPolygon;
import java.util.ArrayList;
import java.util.List;

public class GeoJsonPolygon
implements DataPolygon {
    private static final String GEOMETRY_TYPE = "Polygon";
    private final List<? extends List<LatLng>> mCoordinates;
    private static final int POLYGON_OUTER_COORDINATE_INDEX = 0;
    private static final int POLYGON_INNER_COORDINATE_INDEX = 1;

    public GeoJsonPolygon(List<? extends List<LatLng>> coordinates) {
        if (coordinates == null) {
            throw new IllegalArgumentException("Coordinates cannot be null");
        }
        this.mCoordinates = coordinates;
    }

    public String getType() {
        return GEOMETRY_TYPE;
    }

    public List<? extends List<LatLng>> getCoordinates() {
        return this.mCoordinates;
    }

    public List<? extends List<LatLng>> getGeometryObject() {
        return this.getCoordinates();
    }

    @Override
    public String getGeometryType() {
        return this.getType();
    }

    public ArrayList<LatLng> getOuterBoundaryCoordinates() {
        return (ArrayList)this.getCoordinates().get(0);
    }

    public ArrayList<ArrayList<LatLng>> getInnerBoundaryCoordinates() {
        ArrayList<ArrayList<LatLng>> innerBoundary = new ArrayList<ArrayList<LatLng>>();
        for (int i = 1; i < this.getCoordinates().size(); ++i) {
            innerBoundary.add((ArrayList)this.getCoordinates().get(i));
        }
        return innerBoundary;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(GEOMETRY_TYPE).append("{");
        sb.append("\n coordinates=").append(this.mCoordinates);
        sb.append("\n}\n");
        return sb.toString();
    }
}

