/*
 * Decompiled with CFR 0.152.
 */
package com.google.maps.android.heatmaps;

import android.graphics.Color;
import java.util.HashMap;

public class Gradient {
    private static final int DEFAULT_COLOR_MAP_SIZE = 1000;
    public final int mColorMapSize;
    public int[] mColors;
    public float[] mStartPoints;

    public Gradient(int[] colors, float[] startPoints) {
        this(colors, startPoints, 1000);
    }

    public Gradient(int[] colors, float[] startPoints, int colorMapSize) {
        if (colors.length != startPoints.length) {
            throw new IllegalArgumentException("colors and startPoints should be same length");
        }
        if (colors.length == 0) {
            throw new IllegalArgumentException("No colors have been defined");
        }
        for (int i = 1; i < startPoints.length; ++i) {
            if (!(startPoints[i] <= startPoints[i - 1])) continue;
            throw new IllegalArgumentException("startPoints should be in increasing order");
        }
        this.mColorMapSize = colorMapSize;
        this.mColors = new int[colors.length];
        this.mStartPoints = new float[startPoints.length];
        System.arraycopy(colors, 0, this.mColors, 0, colors.length);
        System.arraycopy(startPoints, 0, this.mStartPoints, 0, startPoints.length);
    }

    private HashMap<Integer, ColorInterval> generateColorIntervals() {
        int i;
        HashMap<Integer, ColorInterval> colorIntervals = new HashMap<Integer, ColorInterval>();
        if (this.mStartPoints[0] != 0.0f) {
            int initialColor = Color.argb((int)0, (int)Color.red((int)this.mColors[0]), (int)Color.green((int)this.mColors[0]), (int)Color.blue((int)this.mColors[0]));
            colorIntervals.put(0, new ColorInterval(initialColor, this.mColors[0], (float)this.mColorMapSize * this.mStartPoints[0]));
        }
        for (i = 1; i < this.mColors.length; ++i) {
            colorIntervals.put((int)((float)this.mColorMapSize * this.mStartPoints[i - 1]), new ColorInterval(this.mColors[i - 1], this.mColors[i], (float)this.mColorMapSize * (this.mStartPoints[i] - this.mStartPoints[i - 1])));
        }
        if (this.mStartPoints[this.mStartPoints.length - 1] != 1.0f) {
            i = this.mStartPoints.length - 1;
            colorIntervals.put((int)((float)this.mColorMapSize * this.mStartPoints[i]), new ColorInterval(this.mColors[i], this.mColors[i], (float)this.mColorMapSize * (1.0f - this.mStartPoints[i])));
        }
        return colorIntervals;
    }

    int[] generateColorMap(double opacity) {
        int i;
        HashMap<Integer, ColorInterval> colorIntervals = this.generateColorIntervals();
        int[] colorMap = new int[this.mColorMapSize];
        ColorInterval interval = colorIntervals.get(0);
        int start = 0;
        for (i = 0; i < this.mColorMapSize; ++i) {
            if (colorIntervals.containsKey(i)) {
                interval = colorIntervals.get(i);
                start = i;
            }
            float ratio = (float)(i - start) / interval.duration;
            colorMap[i] = Gradient.interpolateColor(interval.color1, interval.color2, ratio);
        }
        if (opacity != 1.0) {
            for (i = 0; i < this.mColorMapSize; ++i) {
                int c = colorMap[i];
                colorMap[i] = Color.argb((int)((int)((double)Color.alpha((int)c) * opacity)), (int)Color.red((int)c), (int)Color.green((int)c), (int)Color.blue((int)c));
            }
        }
        return colorMap;
    }

    static int interpolateColor(int color1, int color2, float ratio) {
        int alpha = (int)((float)(Color.alpha((int)color2) - Color.alpha((int)color1)) * ratio + (float)Color.alpha((int)color1));
        float[] hsv1 = new float[3];
        Color.RGBToHSV((int)Color.red((int)color1), (int)Color.green((int)color1), (int)Color.blue((int)color1), (float[])hsv1);
        float[] hsv2 = new float[3];
        Color.RGBToHSV((int)Color.red((int)color2), (int)Color.green((int)color2), (int)Color.blue((int)color2), (float[])hsv2);
        if (hsv1[0] - hsv2[0] > 180.0f) {
            hsv2[0] = hsv2[0] + 360.0f;
        } else if (hsv2[0] - hsv1[0] > 180.0f) {
            hsv1[0] = hsv1[0] + 360.0f;
        }
        float[] result = new float[3];
        for (int i = 0; i < 3; ++i) {
            result[i] = (hsv2[i] - hsv1[i]) * ratio + hsv1[i];
        }
        return Color.HSVToColor((int)alpha, (float[])result);
    }

    private class ColorInterval {
        private final int color1;
        private final int color2;
        private final float duration;

        private ColorInterval(int color1, int color2, float duration) {
            this.color1 = color1;
            this.color2 = color2;
            this.duration = duration;
        }
    }
}

