/*
 * Decompiled with CFR 0.152.
 */
package com.google.maps.android.compose;

import android.content.Context;
import android.view.View;
import androidx.compose.runtime.Composable;
import androidx.compose.runtime.Composer;
import androidx.compose.runtime.ComposerKt;
import androidx.compose.runtime.internal.ComposableLambdaKt;
import androidx.compose.ui.platform.AbstractComposeView;
import androidx.compose.ui.platform.ComposeView;
import com.google.android.gms.maps.GoogleMap;
import com.google.android.gms.maps.MapView;
import com.google.android.gms.maps.model.Marker;
import com.google.maps.android.compose.MapComposeViewRenderKt;
import com.google.maps.android.compose.MarkerNode;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B#\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0014\u0010\u0004\u001a\u0010\u0012\u0004\u0012\u00020\u0006\u0012\u0006\u0012\u0004\u0018\u00010\u00070\u0005\u00a2\u0006\u0002\u0010\bJ\u0012\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\u0006H\u0016J\u0012\u0010\f\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\u0006H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0004\u001a\u0010\u0012\u0004\u0012\u00020\u0006\u0012\u0006\u0012\u0004\u0018\u00010\u00070\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/google/maps/android/compose/ComposeInfoWindowAdapter;", "Lcom/google/android/gms/maps/GoogleMap$InfoWindowAdapter;", "mapView", "Lcom/google/android/gms/maps/MapView;", "markerNodeFinder", "Lkotlin/Function1;", "Lcom/google/android/gms/maps/model/Marker;", "Lcom/google/maps/android/compose/MarkerNode;", "(Lcom/google/android/gms/maps/MapView;Lkotlin/jvm/functions/Function1;)V", "getInfoContents", "Landroid/view/View;", "marker", "getInfoWindow", "maps-compose_release"})
public final class ComposeInfoWindowAdapter
implements GoogleMap.InfoWindowAdapter {
    @NotNull
    private final MapView mapView;
    @NotNull
    private final Function1<Marker, MarkerNode> markerNodeFinder;

    public ComposeInfoWindowAdapter(@NotNull MapView mapView, @NotNull Function1<? super Marker, MarkerNode> markerNodeFinder) {
        Intrinsics.checkNotNullParameter((Object)mapView, (String)"mapView");
        Intrinsics.checkNotNullParameter(markerNodeFinder, (String)"markerNodeFinder");
        this.mapView = mapView;
        this.markerNodeFinder = markerNodeFinder;
    }

    @Nullable
    public View getInfoContents(@NotNull Marker marker) {
        ComposeView composeView;
        Intrinsics.checkNotNullParameter((Object)marker, (String)"marker");
        MarkerNode markerNode = (MarkerNode)this.markerNodeFinder.invoke((Object)marker);
        if (markerNode == null) {
            return null;
        }
        MarkerNode markerNode2 = markerNode;
        Function3<Marker, Composer, Integer, Unit> content = markerNode2.getInfoContent();
        if (content == null) {
            return null;
        }
        Context context = this.mapView.getContext();
        Intrinsics.checkNotNullExpressionValue((Object)context, (String)"mapView.context");
        ComposeView $this$getInfoContents_u24lambda_u240 = composeView = new ComposeView(context, null, 0, 6, null);
        boolean bl = false;
        $this$getInfoContents_u24lambda_u240.setContent((Function2)ComposableLambdaKt.composableLambdaInstance((int)1508359207, (boolean)true, (Object)new Function2<Composer, Integer, Unit>(content, marker){
            final /* synthetic */ Function3<Marker, Composer, Integer, Unit> $content;
            final /* synthetic */ Marker $marker;
            {
                this.$content = $content;
                this.$marker = $marker;
                super(2);
            }

            @Composable
            public final void invoke(@Nullable Composer $composer, int $changed) {
                if (($changed & 0xB) != 2 || !$composer.getSkipping()) {
                    if (ComposerKt.isTraceInProgress()) {
                        ComposerKt.traceEventStart((int)1508359207, (int)$changed, (int)-1, (String)"com.google.maps.android.compose.ComposeInfoWindowAdapter.getInfoContents.<anonymous>.<anonymous> (ComposeInfoWindowAdapter.kt:49)");
                    }
                    this.$content.invoke((Object)this.$marker, (Object)$composer, (Object)8);
                    if (ComposerKt.isTraceInProgress()) {
                        ComposerKt.traceEventEnd();
                    }
                } else {
                    $composer.skipToGroupEnd();
                }
            }
        }));
        ComposeView view2 = composeView;
        MapComposeViewRenderKt.renderComposeViewOnce$default(this.mapView, (AbstractComposeView)view2, null, markerNode2.getCompositionContext(), 2, null);
        return (View)view2;
    }

    @Nullable
    public View getInfoWindow(@NotNull Marker marker) {
        ComposeView composeView;
        Intrinsics.checkNotNullParameter((Object)marker, (String)"marker");
        MarkerNode markerNode = (MarkerNode)this.markerNodeFinder.invoke((Object)marker);
        if (markerNode == null) {
            return null;
        }
        MarkerNode markerNode2 = markerNode;
        Function3<Marker, Composer, Integer, Unit> infoWindow = markerNode2.getInfoWindow();
        if (infoWindow == null) {
            return null;
        }
        Context context = this.mapView.getContext();
        Intrinsics.checkNotNullExpressionValue((Object)context, (String)"mapView.context");
        ComposeView $this$getInfoWindow_u24lambda_u241 = composeView = new ComposeView(context, null, 0, 6, null);
        boolean bl = false;
        $this$getInfoWindow_u24lambda_u241.setContent((Function2)ComposableLambdaKt.composableLambdaInstance((int)-742372995, (boolean)true, (Object)new Function2<Composer, Integer, Unit>(infoWindow, marker){
            final /* synthetic */ Function3<Marker, Composer, Integer, Unit> $infoWindow;
            final /* synthetic */ Marker $marker;
            {
                this.$infoWindow = $infoWindow;
                this.$marker = $marker;
                super(2);
            }

            @Composable
            public final void invoke(@Nullable Composer $composer, int $changed) {
                if (($changed & 0xB) != 2 || !$composer.getSkipping()) {
                    if (ComposerKt.isTraceInProgress()) {
                        ComposerKt.traceEventStart((int)-742372995, (int)$changed, (int)-1, (String)"com.google.maps.android.compose.ComposeInfoWindowAdapter.getInfoWindow.<anonymous>.<anonymous> (ComposeInfoWindowAdapter.kt:62)");
                    }
                    this.$infoWindow.invoke((Object)this.$marker, (Object)$composer, (Object)8);
                    if (ComposerKt.isTraceInProgress()) {
                        ComposerKt.traceEventEnd();
                    }
                } else {
                    $composer.skipToGroupEnd();
                }
            }
        }));
        ComposeView view2 = composeView;
        MapComposeViewRenderKt.renderComposeViewOnce$default(this.mapView, (AbstractComposeView)view2, null, markerNode2.getCompositionContext(), 2, null);
        return (View)view2;
    }
}

