/*
 * Decompiled with CFR 0.152.
 */
package com.google.maps.android.compose;

import androidx.compose.runtime.AbstractApplier;
import com.google.android.gms.maps.GoogleMap;
import com.google.android.gms.maps.MapView;
import com.google.android.gms.maps.model.Circle;
import com.google.android.gms.maps.model.GroundOverlay;
import com.google.android.gms.maps.model.LatLng;
import com.google.android.gms.maps.model.Marker;
import com.google.android.gms.maps.model.Polygon;
import com.google.android.gms.maps.model.Polyline;
import com.google.maps.android.compose.CircleNode;
import com.google.maps.android.compose.ComposeInfoWindowAdapter;
import com.google.maps.android.compose.DragState;
import com.google.maps.android.compose.GroundOverlayNode;
import com.google.maps.android.compose.InputHandlerNode;
import com.google.maps.android.compose.MapNode;
import com.google.maps.android.compose.MapNodeRoot;
import com.google.maps.android.compose.MarkerNode;
import com.google.maps.android.compose.MarkerState;
import com.google.maps.android.compose.PolygonNode;
import com.google.maps.android.compose.PolylineNode;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\t\b\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\r\u0010\u000e\u001a\u00020\u000fH\u0000\u00a2\u0006\u0002\b\u0010J\u0018\u0010\u0011\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0002H\u0016J\u0018\u0010\u0015\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0002H\u0016J \u0010\u0016\u001a\u00020\u000f2\u0006\u0010\u0017\u001a\u00020\u00132\u0006\u0010\u0018\u001a\u00020\u00132\u0006\u0010\u0019\u001a\u00020\u0013H\u0016J\b\u0010\u001a\u001a\u00020\u000fH\u0014J\u0018\u0010\u001b\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0019\u001a\u00020\u0013H\u0016R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\u0005\u001a\u00020\u0006X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u001c"}, d2={"Lcom/google/maps/android/compose/MapApplier;", "Landroidx/compose/runtime/AbstractApplier;", "Lcom/google/maps/android/compose/MapNode;", "map", "Lcom/google/android/gms/maps/GoogleMap;", "mapView", "Lcom/google/android/gms/maps/MapView;", "(Lcom/google/android/gms/maps/GoogleMap;Lcom/google/android/gms/maps/MapView;)V", "decorations", "", "getMap", "()Lcom/google/android/gms/maps/GoogleMap;", "getMapView$maps_compose_release", "()Lcom/google/android/gms/maps/MapView;", "attachClickListeners", "", "attachClickListeners$maps_compose_release", "insertBottomUp", "index", "", "instance", "insertTopDown", "move", "from", "to", "count", "onClear", "remove", "maps-compose_release"})
public final class MapApplier
extends AbstractApplier<MapNode> {
    @NotNull
    private final GoogleMap map;
    @NotNull
    private final MapView mapView;
    @NotNull
    private final List<MapNode> decorations;

    public MapApplier(@NotNull GoogleMap map, @NotNull MapView mapView) {
        Intrinsics.checkNotNullParameter((Object)map, (String)"map");
        Intrinsics.checkNotNullParameter((Object)mapView, (String)"mapView");
        super((Object)MapNodeRoot.INSTANCE);
        this.map = map;
        this.mapView = mapView;
        this.decorations = new ArrayList();
        this.attachClickListeners$maps_compose_release();
    }

    @NotNull
    public final GoogleMap getMap() {
        return this.map;
    }

    @NotNull
    public final MapView getMapView$maps_compose_release() {
        return this.mapView;
    }

    protected void onClear() {
        this.map.clear();
        Iterable $this$forEach$iv = this.decorations;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            MapNode it = (MapNode)element$iv;
            boolean bl = false;
            it.onCleared();
        }
        this.decorations.clear();
    }

    public void insertBottomUp(int index, @NotNull MapNode instance) {
        Intrinsics.checkNotNullParameter((Object)instance, (String)"instance");
        this.decorations.add(index, instance);
        instance.onAttached();
    }

    public void insertTopDown(int index, @NotNull MapNode instance) {
        Intrinsics.checkNotNullParameter((Object)instance, (String)"instance");
    }

    public void move(int from, int to, int count) {
        this.move(this.decorations, from, to, count);
    }

    public void remove(int index, int count) {
        int n = 0;
        while (n < count) {
            int it = n++;
            boolean bl = false;
            this.decorations.get(index + it).onRemoved();
        }
        this.remove(this.decorations, index, count);
    }

    public final void attachClickListeners$maps_compose_release() {
        this.map.setOnCircleClickListener(arg_0 -> MapApplier.attachClickListeners$lambda$5(this, arg_0));
        this.map.setOnGroundOverlayClickListener(arg_0 -> MapApplier.attachClickListeners$lambda$9(this, arg_0));
        this.map.setOnPolygonClickListener(arg_0 -> MapApplier.attachClickListeners$lambda$13(this, arg_0));
        this.map.setOnPolylineClickListener(arg_0 -> MapApplier.attachClickListeners$lambda$17(this, arg_0));
        this.map.setOnMarkerClickListener(arg_0 -> MapApplier.attachClickListeners$lambda$21(this, arg_0));
        this.map.setOnInfoWindowClickListener(arg_0 -> MapApplier.attachClickListeners$lambda$25(this, arg_0));
        this.map.setOnInfoWindowCloseListener(arg_0 -> MapApplier.attachClickListeners$lambda$29(this, arg_0));
        this.map.setOnInfoWindowLongClickListener(arg_0 -> MapApplier.attachClickListeners$lambda$33(this, arg_0));
        this.map.setOnMarkerDragListener(new GoogleMap.OnMarkerDragListener(this){
            final /* synthetic */ MapApplier this$0;
            {
                this.this$0 = $receiver;
            }

            public void onMarkerDrag(@NotNull Marker marker) {
                Function1 function1;
                block4: {
                    Function1 function12;
                    Intrinsics.checkNotNullParameter((Object)marker, (String)"marker");
                    Iterable $this$findInputCallback$iv = MapApplier.access$getDecorations$p(this.this$0);
                    boolean $i$f$findInputCallback = false;
                    Function1 callback$iv = null;
                    for (MapNode item$iv : $this$findInputCallback$iv) {
                        if (item$iv instanceof MarkerNode) {
                            MarkerNode it = (MarkerNode)item$iv;
                            boolean bl = false;
                            if (Intrinsics.areEqual((Object)it.getMarker(), (Object)marker)) {
                                MarkerNode $this$onMarkerDrag_u24lambda_u241 = (MarkerNode)item$iv;
                                boolean bl2 = false;
                                function12 = (Function1)new Function1<Marker, Unit>($this$onMarkerDrag_u24lambda_u241){
                                    final /* synthetic */ MarkerNode $this_findInputCallback;
                                    {
                                        this.$this_findInputCallback = $receiver;
                                        super(1);
                                    }

                                    public final void invoke(@NotNull Marker it) {
                                        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                                        MarkerState markerState = this.$this_findInputCallback.getMarkerState();
                                        LatLng latLng = it.getPosition();
                                        Intrinsics.checkNotNullExpressionValue((Object)latLng, (String)"it.position");
                                        markerState.setPosition(latLng);
                                        this.$this_findInputCallback.getMarkerState().setDragState$maps_compose_release(DragState.DRAG);
                                    }
                                };
                                break block4;
                            }
                        }
                        if (!(item$iv instanceof InputHandlerNode)) continue;
                        InputHandlerNode $this$onMarkerDrag_u24lambda_u242 = (InputHandlerNode)item$iv;
                        boolean bl = false;
                        callback$iv = $this$onMarkerDrag_u24lambda_u242.getOnMarkerDrag();
                    }
                    function12 = function1 = callback$iv;
                }
                if (function1 != null) {
                    function1.invoke((Object)marker);
                }
            }

            public void onMarkerDragEnd(@NotNull Marker marker) {
                Function1 function1;
                block4: {
                    Function1 function12;
                    Intrinsics.checkNotNullParameter((Object)marker, (String)"marker");
                    Iterable $this$findInputCallback$iv = MapApplier.access$getDecorations$p(this.this$0);
                    boolean $i$f$findInputCallback = false;
                    Function1 callback$iv = null;
                    for (MapNode item$iv : $this$findInputCallback$iv) {
                        if (item$iv instanceof MarkerNode) {
                            MarkerNode it = (MarkerNode)item$iv;
                            boolean bl = false;
                            if (Intrinsics.areEqual((Object)it.getMarker(), (Object)marker)) {
                                MarkerNode $this$onMarkerDragEnd_u24lambda_u244 = (MarkerNode)item$iv;
                                boolean bl2 = false;
                                function12 = (Function1)new Function1<Marker, Unit>($this$onMarkerDragEnd_u24lambda_u244){
                                    final /* synthetic */ MarkerNode $this_findInputCallback;
                                    {
                                        this.$this_findInputCallback = $receiver;
                                        super(1);
                                    }

                                    public final void invoke(@NotNull Marker it) {
                                        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                                        MarkerState markerState = this.$this_findInputCallback.getMarkerState();
                                        LatLng latLng = it.getPosition();
                                        Intrinsics.checkNotNullExpressionValue((Object)latLng, (String)"it.position");
                                        markerState.setPosition(latLng);
                                        this.$this_findInputCallback.getMarkerState().setDragState$maps_compose_release(DragState.END);
                                    }
                                };
                                break block4;
                            }
                        }
                        if (!(item$iv instanceof InputHandlerNode)) continue;
                        InputHandlerNode $this$onMarkerDragEnd_u24lambda_u245 = (InputHandlerNode)item$iv;
                        boolean bl = false;
                        callback$iv = $this$onMarkerDragEnd_u24lambda_u245.getOnMarkerDragEnd();
                    }
                    function12 = function1 = callback$iv;
                }
                if (function1 != null) {
                    function1.invoke((Object)marker);
                }
            }

            public void onMarkerDragStart(@NotNull Marker marker) {
                Function1 function1;
                block4: {
                    Function1 function12;
                    Intrinsics.checkNotNullParameter((Object)marker, (String)"marker");
                    Iterable $this$findInputCallback$iv = MapApplier.access$getDecorations$p(this.this$0);
                    boolean $i$f$findInputCallback = false;
                    Function1 callback$iv = null;
                    for (MapNode item$iv : $this$findInputCallback$iv) {
                        if (item$iv instanceof MarkerNode) {
                            MarkerNode it = (MarkerNode)item$iv;
                            boolean bl = false;
                            if (Intrinsics.areEqual((Object)it.getMarker(), (Object)marker)) {
                                MarkerNode $this$onMarkerDragStart_u24lambda_u247 = (MarkerNode)item$iv;
                                boolean bl2 = false;
                                function12 = (Function1)new Function1<Marker, Unit>($this$onMarkerDragStart_u24lambda_u247){
                                    final /* synthetic */ MarkerNode $this_findInputCallback;
                                    {
                                        this.$this_findInputCallback = $receiver;
                                        super(1);
                                    }

                                    public final void invoke(@NotNull Marker it) {
                                        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                                        MarkerState markerState = this.$this_findInputCallback.getMarkerState();
                                        LatLng latLng = it.getPosition();
                                        Intrinsics.checkNotNullExpressionValue((Object)latLng, (String)"it.position");
                                        markerState.setPosition(latLng);
                                        this.$this_findInputCallback.getMarkerState().setDragState$maps_compose_release(DragState.START);
                                    }
                                };
                                break block4;
                            }
                        }
                        if (!(item$iv instanceof InputHandlerNode)) continue;
                        InputHandlerNode $this$onMarkerDragStart_u24lambda_u248 = (InputHandlerNode)item$iv;
                        boolean bl = false;
                        callback$iv = $this$onMarkerDragStart_u24lambda_u248.getOnMarkerDragStart();
                    }
                    function12 = function1 = callback$iv;
                }
                if (function1 != null) {
                    function1.invoke((Object)marker);
                }
            }
        });
        this.map.setInfoWindowAdapter((GoogleMap.InfoWindowAdapter)new ComposeInfoWindowAdapter(this.mapView, (Function1<? super Marker, MarkerNode>)((Function1)new Function1<Marker, MarkerNode>(this){
            final /* synthetic */ MapApplier this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            @Nullable
            public final MarkerNode invoke(@NotNull Marker marker) {
                Object v0;
                block1: {
                    Intrinsics.checkNotNullParameter((Object)marker, (String)"marker");
                    Iterable $this$firstOrNull$iv = MapApplier.access$getDecorations$p(this.this$0);
                    boolean $i$f$firstOrNull = false;
                    for (T element$iv : $this$firstOrNull$iv) {
                        MapNode it = (MapNode)element$iv;
                        boolean bl = false;
                        if (!(it instanceof MarkerNode && Intrinsics.areEqual((Object)((MarkerNode)it).getMarker(), (Object)marker))) continue;
                        v0 = element$iv;
                        break block1;
                    }
                    v0 = null;
                }
                return v0;
            }
        })));
    }

    private static final void attachClickListeners$lambda$5(MapApplier this$0, Circle circle) {
        Function1<Circle, Unit> function1;
        block4: {
            Function1<Circle, Unit> function12;
            Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
            Intrinsics.checkNotNullParameter((Object)circle, (String)"circle");
            Iterable $this$findInputCallback$iv = this$0.decorations;
            boolean $i$f$findInputCallback = false;
            Function1<Circle, Unit> callback$iv = null;
            for (MapNode item$iv : $this$findInputCallback$iv) {
                if (item$iv instanceof CircleNode) {
                    CircleNode it = (CircleNode)item$iv;
                    boolean bl = false;
                    if (Intrinsics.areEqual((Object)it.getCircle(), (Object)circle)) {
                        CircleNode $this$attachClickListeners_u24lambda_u245_u24lambda_u243 = (CircleNode)item$iv;
                        boolean bl2 = false;
                        function12 = $this$attachClickListeners_u24lambda_u245_u24lambda_u243.getOnCircleClick();
                        break block4;
                    }
                }
                if (!(item$iv instanceof InputHandlerNode)) continue;
                InputHandlerNode $this$attachClickListeners_u24lambda_u245_u24lambda_u244 = (InputHandlerNode)item$iv;
                boolean bl = false;
                callback$iv = $this$attachClickListeners_u24lambda_u245_u24lambda_u244.getOnCircleClick();
            }
            function12 = function1 = callback$iv;
        }
        if (function1 != null) {
            function1.invoke((Object)circle);
        }
    }

    private static final void attachClickListeners$lambda$9(MapApplier this$0, GroundOverlay groundOverlay) {
        Function1<GroundOverlay, Unit> function1;
        block4: {
            Function1<GroundOverlay, Unit> function12;
            Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
            Intrinsics.checkNotNullParameter((Object)groundOverlay, (String)"groundOverlay");
            Iterable $this$findInputCallback$iv = this$0.decorations;
            boolean $i$f$findInputCallback = false;
            Function1<GroundOverlay, Unit> callback$iv = null;
            for (MapNode item$iv : $this$findInputCallback$iv) {
                if (item$iv instanceof GroundOverlayNode) {
                    GroundOverlayNode it = (GroundOverlayNode)item$iv;
                    boolean bl = false;
                    if (Intrinsics.areEqual((Object)it.getGroundOverlay(), (Object)groundOverlay)) {
                        GroundOverlayNode $this$attachClickListeners_u24lambda_u249_u24lambda_u247 = (GroundOverlayNode)item$iv;
                        boolean bl2 = false;
                        function12 = $this$attachClickListeners_u24lambda_u249_u24lambda_u247.getOnGroundOverlayClick();
                        break block4;
                    }
                }
                if (!(item$iv instanceof InputHandlerNode)) continue;
                InputHandlerNode $this$attachClickListeners_u24lambda_u249_u24lambda_u248 = (InputHandlerNode)item$iv;
                boolean bl = false;
                callback$iv = $this$attachClickListeners_u24lambda_u249_u24lambda_u248.getOnGroundOverlayClick();
            }
            function12 = function1 = callback$iv;
        }
        if (function1 != null) {
            function1.invoke((Object)groundOverlay);
        }
    }

    private static final void attachClickListeners$lambda$13(MapApplier this$0, Polygon polygon) {
        Function1<Polygon, Unit> function1;
        block4: {
            Function1<Polygon, Unit> function12;
            Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
            Intrinsics.checkNotNullParameter((Object)polygon, (String)"polygon");
            Iterable $this$findInputCallback$iv = this$0.decorations;
            boolean $i$f$findInputCallback = false;
            Function1<Polygon, Unit> callback$iv = null;
            for (MapNode item$iv : $this$findInputCallback$iv) {
                if (item$iv instanceof PolygonNode) {
                    PolygonNode it = (PolygonNode)item$iv;
                    boolean bl = false;
                    if (Intrinsics.areEqual((Object)it.getPolygon(), (Object)polygon)) {
                        PolygonNode $this$attachClickListeners_u24lambda_u2413_u24lambda_u2411 = (PolygonNode)item$iv;
                        boolean bl2 = false;
                        function12 = $this$attachClickListeners_u24lambda_u2413_u24lambda_u2411.getOnPolygonClick();
                        break block4;
                    }
                }
                if (!(item$iv instanceof InputHandlerNode)) continue;
                InputHandlerNode $this$attachClickListeners_u24lambda_u2413_u24lambda_u2412 = (InputHandlerNode)item$iv;
                boolean bl = false;
                callback$iv = $this$attachClickListeners_u24lambda_u2413_u24lambda_u2412.getOnPolygonClick();
            }
            function12 = function1 = callback$iv;
        }
        if (function1 != null) {
            function1.invoke((Object)polygon);
        }
    }

    private static final void attachClickListeners$lambda$17(MapApplier this$0, Polyline polyline) {
        Function1<Polyline, Unit> function1;
        block4: {
            Function1<Polyline, Unit> function12;
            Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
            Intrinsics.checkNotNullParameter((Object)polyline, (String)"polyline");
            Iterable $this$findInputCallback$iv = this$0.decorations;
            boolean $i$f$findInputCallback = false;
            Function1<Polyline, Unit> callback$iv = null;
            for (MapNode item$iv : $this$findInputCallback$iv) {
                if (item$iv instanceof PolylineNode) {
                    PolylineNode it = (PolylineNode)item$iv;
                    boolean bl = false;
                    if (Intrinsics.areEqual((Object)it.getPolyline(), (Object)polyline)) {
                        PolylineNode $this$attachClickListeners_u24lambda_u2417_u24lambda_u2415 = (PolylineNode)item$iv;
                        boolean bl2 = false;
                        function12 = $this$attachClickListeners_u24lambda_u2417_u24lambda_u2415.getOnPolylineClick();
                        break block4;
                    }
                }
                if (!(item$iv instanceof InputHandlerNode)) continue;
                InputHandlerNode $this$attachClickListeners_u24lambda_u2417_u24lambda_u2416 = (InputHandlerNode)item$iv;
                boolean bl = false;
                callback$iv = $this$attachClickListeners_u24lambda_u2417_u24lambda_u2416.getOnPolylineClick();
            }
            function12 = function1 = callback$iv;
        }
        if (function1 != null) {
            function1.invoke((Object)polyline);
        }
    }

    private static final boolean attachClickListeners$lambda$21(MapApplier this$0, Marker marker) {
        Function1<Marker, Boolean> function1;
        block3: {
            Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
            Intrinsics.checkNotNullParameter((Object)marker, (String)"marker");
            Iterable $this$findInputCallback$iv = this$0.decorations;
            boolean $i$f$findInputCallback = false;
            Function1<Marker, Boolean> callback$iv = null;
            for (MapNode item$iv : $this$findInputCallback$iv) {
                if (item$iv instanceof MarkerNode) {
                    MarkerNode it = (MarkerNode)item$iv;
                    boolean bl = false;
                    if (Intrinsics.areEqual((Object)it.getMarker(), (Object)marker)) {
                        MarkerNode $this$attachClickListeners_u24lambda_u2421_u24lambda_u2419 = (MarkerNode)item$iv;
                        boolean bl2 = false;
                        function1 = $this$attachClickListeners_u24lambda_u2421_u24lambda_u2419.getOnMarkerClick();
                        break block3;
                    }
                }
                if (!(item$iv instanceof InputHandlerNode)) continue;
                InputHandlerNode $this$attachClickListeners_u24lambda_u2421_u24lambda_u2420 = (InputHandlerNode)item$iv;
                boolean bl = false;
                callback$iv = $this$attachClickListeners_u24lambda_u2421_u24lambda_u2420.getOnMarkerClick();
            }
            function1 = callback$iv;
        }
        Function1<Marker, Boolean> function12 = function1;
        return function12 != null ? (Boolean)function12.invoke((Object)marker) : false;
    }

    private static final void attachClickListeners$lambda$25(MapApplier this$0, Marker marker) {
        Function1<Marker, Unit> function1;
        block4: {
            Function1<Marker, Unit> function12;
            Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
            Intrinsics.checkNotNullParameter((Object)marker, (String)"marker");
            Iterable $this$findInputCallback$iv = this$0.decorations;
            boolean $i$f$findInputCallback = false;
            Function1<Marker, Unit> callback$iv = null;
            for (MapNode item$iv : $this$findInputCallback$iv) {
                if (item$iv instanceof MarkerNode) {
                    MarkerNode it = (MarkerNode)item$iv;
                    boolean bl = false;
                    if (Intrinsics.areEqual((Object)it.getMarker(), (Object)marker)) {
                        MarkerNode $this$attachClickListeners_u24lambda_u2425_u24lambda_u2423 = (MarkerNode)item$iv;
                        boolean bl2 = false;
                        function12 = $this$attachClickListeners_u24lambda_u2425_u24lambda_u2423.getOnInfoWindowClick();
                        break block4;
                    }
                }
                if (!(item$iv instanceof InputHandlerNode)) continue;
                InputHandlerNode $this$attachClickListeners_u24lambda_u2425_u24lambda_u2424 = (InputHandlerNode)item$iv;
                boolean bl = false;
                callback$iv = $this$attachClickListeners_u24lambda_u2425_u24lambda_u2424.getOnInfoWindowClick();
            }
            function12 = function1 = callback$iv;
        }
        if (function1 != null) {
            function1.invoke((Object)marker);
        }
    }

    private static final void attachClickListeners$lambda$29(MapApplier this$0, Marker marker) {
        Function1<Marker, Unit> function1;
        block4: {
            Function1<Marker, Unit> function12;
            Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
            Intrinsics.checkNotNullParameter((Object)marker, (String)"marker");
            Iterable $this$findInputCallback$iv = this$0.decorations;
            boolean $i$f$findInputCallback = false;
            Function1<Marker, Unit> callback$iv = null;
            for (MapNode item$iv : $this$findInputCallback$iv) {
                if (item$iv instanceof MarkerNode) {
                    MarkerNode it = (MarkerNode)item$iv;
                    boolean bl = false;
                    if (Intrinsics.areEqual((Object)it.getMarker(), (Object)marker)) {
                        MarkerNode $this$attachClickListeners_u24lambda_u2429_u24lambda_u2427 = (MarkerNode)item$iv;
                        boolean bl2 = false;
                        function12 = $this$attachClickListeners_u24lambda_u2429_u24lambda_u2427.getOnInfoWindowClose();
                        break block4;
                    }
                }
                if (!(item$iv instanceof InputHandlerNode)) continue;
                InputHandlerNode $this$attachClickListeners_u24lambda_u2429_u24lambda_u2428 = (InputHandlerNode)item$iv;
                boolean bl = false;
                callback$iv = $this$attachClickListeners_u24lambda_u2429_u24lambda_u2428.getOnInfoWindowClose();
            }
            function12 = function1 = callback$iv;
        }
        if (function1 != null) {
            function1.invoke((Object)marker);
        }
    }

    private static final void attachClickListeners$lambda$33(MapApplier this$0, Marker marker) {
        Function1<Marker, Unit> function1;
        block4: {
            Function1<Marker, Unit> function12;
            Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
            Intrinsics.checkNotNullParameter((Object)marker, (String)"marker");
            Iterable $this$findInputCallback$iv = this$0.decorations;
            boolean $i$f$findInputCallback = false;
            Function1<Marker, Unit> callback$iv = null;
            for (MapNode item$iv : $this$findInputCallback$iv) {
                if (item$iv instanceof MarkerNode) {
                    MarkerNode it = (MarkerNode)item$iv;
                    boolean bl = false;
                    if (Intrinsics.areEqual((Object)it.getMarker(), (Object)marker)) {
                        MarkerNode $this$attachClickListeners_u24lambda_u2433_u24lambda_u2431 = (MarkerNode)item$iv;
                        boolean bl2 = false;
                        function12 = $this$attachClickListeners_u24lambda_u2433_u24lambda_u2431.getOnInfoWindowLongClick();
                        break block4;
                    }
                }
                if (!(item$iv instanceof InputHandlerNode)) continue;
                InputHandlerNode $this$attachClickListeners_u24lambda_u2433_u24lambda_u2432 = (InputHandlerNode)item$iv;
                boolean bl = false;
                callback$iv = $this$attachClickListeners_u24lambda_u2433_u24lambda_u2432.getOnInfoWindowLongClick();
            }
            function12 = function1 = callback$iv;
        }
        if (function1 != null) {
            function1.invoke((Object)marker);
        }
    }

    public static final /* synthetic */ List access$getDecorations$p(MapApplier $this) {
        return $this.decorations;
    }
}

