/*
 * Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/maps/addressvalidation/v1/address.proto

package com.google.maps.addressvalidation.v1;

/**
 *
 *
 * <pre>
 * Details of the post-processed address. Post-processing includes
 * correcting misspelled parts of the address, replacing incorrect parts, and
 * inferring missing parts.
 * </pre>
 *
 * Protobuf type {@code google.maps.addressvalidation.v1.Address}
 */
public final class Address extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.maps.addressvalidation.v1.Address)
    AddressOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use Address.newBuilder() to construct.
  private Address(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private Address() {
    formattedAddress_ = "";
    addressComponents_ = java.util.Collections.emptyList();
    missingComponentTypes_ = com.google.protobuf.LazyStringArrayList.emptyList();
    unconfirmedComponentTypes_ = com.google.protobuf.LazyStringArrayList.emptyList();
    unresolvedTokens_ = com.google.protobuf.LazyStringArrayList.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new Address();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.maps.addressvalidation.v1.AddressProto
        .internal_static_google_maps_addressvalidation_v1_Address_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.maps.addressvalidation.v1.AddressProto
        .internal_static_google_maps_addressvalidation_v1_Address_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.maps.addressvalidation.v1.Address.class,
            com.google.maps.addressvalidation.v1.Address.Builder.class);
  }

  public static final int FORMATTED_ADDRESS_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private volatile java.lang.Object formattedAddress_ = "";
  /**
   *
   *
   * <pre>
   * The post-processed address, formatted as a single-line address following
   * the address formatting rules of the region where the address is located.
   * </pre>
   *
   * <code>string formatted_address = 2;</code>
   *
   * @return The formattedAddress.
   */
  @java.lang.Override
  public java.lang.String getFormattedAddress() {
    java.lang.Object ref = formattedAddress_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      formattedAddress_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The post-processed address, formatted as a single-line address following
   * the address formatting rules of the region where the address is located.
   * </pre>
   *
   * <code>string formatted_address = 2;</code>
   *
   * @return The bytes for formattedAddress.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getFormattedAddressBytes() {
    java.lang.Object ref = formattedAddress_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      formattedAddress_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int POSTAL_ADDRESS_FIELD_NUMBER = 3;
  private com.google.type.PostalAddress postalAddress_;
  /**
   *
   *
   * <pre>
   * The post-processed address represented as a postal address.
   * </pre>
   *
   * <code>.google.type.PostalAddress postal_address = 3;</code>
   *
   * @return Whether the postalAddress field is set.
   */
  @java.lang.Override
  public boolean hasPostalAddress() {
    return postalAddress_ != null;
  }
  /**
   *
   *
   * <pre>
   * The post-processed address represented as a postal address.
   * </pre>
   *
   * <code>.google.type.PostalAddress postal_address = 3;</code>
   *
   * @return The postalAddress.
   */
  @java.lang.Override
  public com.google.type.PostalAddress getPostalAddress() {
    return postalAddress_ == null
        ? com.google.type.PostalAddress.getDefaultInstance()
        : postalAddress_;
  }
  /**
   *
   *
   * <pre>
   * The post-processed address represented as a postal address.
   * </pre>
   *
   * <code>.google.type.PostalAddress postal_address = 3;</code>
   */
  @java.lang.Override
  public com.google.type.PostalAddressOrBuilder getPostalAddressOrBuilder() {
    return postalAddress_ == null
        ? com.google.type.PostalAddress.getDefaultInstance()
        : postalAddress_;
  }

  public static final int ADDRESS_COMPONENTS_FIELD_NUMBER = 4;

  @SuppressWarnings("serial")
  private java.util.List<com.google.maps.addressvalidation.v1.AddressComponent> addressComponents_;
  /**
   *
   *
   * <pre>
   * Unordered list. The individual address components of the formatted and
   * corrected address, along with validation information. This provides
   * information on the validation status of the individual components.
   *
   * Address components are not ordered in a particular way. Do not make any
   * assumptions on the ordering of the address components in the list.
   * </pre>
   *
   * <code>
   * repeated .google.maps.addressvalidation.v1.AddressComponent address_components = 4 [(.google.api.field_behavior) = UNORDERED_LIST];
   * </code>
   */
  @java.lang.Override
  public java.util.List<com.google.maps.addressvalidation.v1.AddressComponent>
      getAddressComponentsList() {
    return addressComponents_;
  }
  /**
   *
   *
   * <pre>
   * Unordered list. The individual address components of the formatted and
   * corrected address, along with validation information. This provides
   * information on the validation status of the individual components.
   *
   * Address components are not ordered in a particular way. Do not make any
   * assumptions on the ordering of the address components in the list.
   * </pre>
   *
   * <code>
   * repeated .google.maps.addressvalidation.v1.AddressComponent address_components = 4 [(.google.api.field_behavior) = UNORDERED_LIST];
   * </code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.maps.addressvalidation.v1.AddressComponentOrBuilder>
      getAddressComponentsOrBuilderList() {
    return addressComponents_;
  }
  /**
   *
   *
   * <pre>
   * Unordered list. The individual address components of the formatted and
   * corrected address, along with validation information. This provides
   * information on the validation status of the individual components.
   *
   * Address components are not ordered in a particular way. Do not make any
   * assumptions on the ordering of the address components in the list.
   * </pre>
   *
   * <code>
   * repeated .google.maps.addressvalidation.v1.AddressComponent address_components = 4 [(.google.api.field_behavior) = UNORDERED_LIST];
   * </code>
   */
  @java.lang.Override
  public int getAddressComponentsCount() {
    return addressComponents_.size();
  }
  /**
   *
   *
   * <pre>
   * Unordered list. The individual address components of the formatted and
   * corrected address, along with validation information. This provides
   * information on the validation status of the individual components.
   *
   * Address components are not ordered in a particular way. Do not make any
   * assumptions on the ordering of the address components in the list.
   * </pre>
   *
   * <code>
   * repeated .google.maps.addressvalidation.v1.AddressComponent address_components = 4 [(.google.api.field_behavior) = UNORDERED_LIST];
   * </code>
   */
  @java.lang.Override
  public com.google.maps.addressvalidation.v1.AddressComponent getAddressComponents(int index) {
    return addressComponents_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Unordered list. The individual address components of the formatted and
   * corrected address, along with validation information. This provides
   * information on the validation status of the individual components.
   *
   * Address components are not ordered in a particular way. Do not make any
   * assumptions on the ordering of the address components in the list.
   * </pre>
   *
   * <code>
   * repeated .google.maps.addressvalidation.v1.AddressComponent address_components = 4 [(.google.api.field_behavior) = UNORDERED_LIST];
   * </code>
   */
  @java.lang.Override
  public com.google.maps.addressvalidation.v1.AddressComponentOrBuilder
      getAddressComponentsOrBuilder(int index) {
    return addressComponents_.get(index);
  }

  public static final int MISSING_COMPONENT_TYPES_FIELD_NUMBER = 5;

  @SuppressWarnings("serial")
  private com.google.protobuf.LazyStringArrayList missingComponentTypes_ =
      com.google.protobuf.LazyStringArrayList.emptyList();
  /**
   *
   *
   * <pre>
   * The types of components that were expected to be present in a correctly
   * formatted mailing address but were not found in the input AND could
   * not be inferred. Components of this type are not present in
   * `formatted_address`, `postal_address`, or `address_components`. An
   * example might be `['street_number', 'route']` for an input like
   * "Boulder, Colorado, 80301, USA". The list of possible types can be found
   * [here](https://developers.google.com/maps/documentation/geocoding/requests-geocoding#Types).
   * </pre>
   *
   * <code>repeated string missing_component_types = 5;</code>
   *
   * @return A list containing the missingComponentTypes.
   */
  public com.google.protobuf.ProtocolStringList getMissingComponentTypesList() {
    return missingComponentTypes_;
  }
  /**
   *
   *
   * <pre>
   * The types of components that were expected to be present in a correctly
   * formatted mailing address but were not found in the input AND could
   * not be inferred. Components of this type are not present in
   * `formatted_address`, `postal_address`, or `address_components`. An
   * example might be `['street_number', 'route']` for an input like
   * "Boulder, Colorado, 80301, USA". The list of possible types can be found
   * [here](https://developers.google.com/maps/documentation/geocoding/requests-geocoding#Types).
   * </pre>
   *
   * <code>repeated string missing_component_types = 5;</code>
   *
   * @return The count of missingComponentTypes.
   */
  public int getMissingComponentTypesCount() {
    return missingComponentTypes_.size();
  }
  /**
   *
   *
   * <pre>
   * The types of components that were expected to be present in a correctly
   * formatted mailing address but were not found in the input AND could
   * not be inferred. Components of this type are not present in
   * `formatted_address`, `postal_address`, or `address_components`. An
   * example might be `['street_number', 'route']` for an input like
   * "Boulder, Colorado, 80301, USA". The list of possible types can be found
   * [here](https://developers.google.com/maps/documentation/geocoding/requests-geocoding#Types).
   * </pre>
   *
   * <code>repeated string missing_component_types = 5;</code>
   *
   * @param index The index of the element to return.
   * @return The missingComponentTypes at the given index.
   */
  public java.lang.String getMissingComponentTypes(int index) {
    return missingComponentTypes_.get(index);
  }
  /**
   *
   *
   * <pre>
   * The types of components that were expected to be present in a correctly
   * formatted mailing address but were not found in the input AND could
   * not be inferred. Components of this type are not present in
   * `formatted_address`, `postal_address`, or `address_components`. An
   * example might be `['street_number', 'route']` for an input like
   * "Boulder, Colorado, 80301, USA". The list of possible types can be found
   * [here](https://developers.google.com/maps/documentation/geocoding/requests-geocoding#Types).
   * </pre>
   *
   * <code>repeated string missing_component_types = 5;</code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the missingComponentTypes at the given index.
   */
  public com.google.protobuf.ByteString getMissingComponentTypesBytes(int index) {
    return missingComponentTypes_.getByteString(index);
  }

  public static final int UNCONFIRMED_COMPONENT_TYPES_FIELD_NUMBER = 6;

  @SuppressWarnings("serial")
  private com.google.protobuf.LazyStringArrayList unconfirmedComponentTypes_ =
      com.google.protobuf.LazyStringArrayList.emptyList();
  /**
   *
   *
   * <pre>
   * The types of the components that are present in the `address_components`
   * but could not be confirmed to be correct. This field is provided for the
   * sake of convenience: its contents are equivalent to iterating through the
   * `address_components` to find the types of all the components where the
   * [confirmation_level][google.maps.addressvalidation.v1.AddressComponent.confirmation_level]
   * is not
   * [CONFIRMED][google.maps.addressvalidation.v1.AddressComponent.ConfirmationLevel.CONFIRMED]
   * or the
   * [inferred][google.maps.addressvalidation.v1.AddressComponent.inferred]
   * flag is not set to `true`. The list of possible types can be found
   * [here](https://developers.google.com/maps/documentation/geocoding/requests-geocoding#Types).
   * </pre>
   *
   * <code>repeated string unconfirmed_component_types = 6;</code>
   *
   * @return A list containing the unconfirmedComponentTypes.
   */
  public com.google.protobuf.ProtocolStringList getUnconfirmedComponentTypesList() {
    return unconfirmedComponentTypes_;
  }
  /**
   *
   *
   * <pre>
   * The types of the components that are present in the `address_components`
   * but could not be confirmed to be correct. This field is provided for the
   * sake of convenience: its contents are equivalent to iterating through the
   * `address_components` to find the types of all the components where the
   * [confirmation_level][google.maps.addressvalidation.v1.AddressComponent.confirmation_level]
   * is not
   * [CONFIRMED][google.maps.addressvalidation.v1.AddressComponent.ConfirmationLevel.CONFIRMED]
   * or the
   * [inferred][google.maps.addressvalidation.v1.AddressComponent.inferred]
   * flag is not set to `true`. The list of possible types can be found
   * [here](https://developers.google.com/maps/documentation/geocoding/requests-geocoding#Types).
   * </pre>
   *
   * <code>repeated string unconfirmed_component_types = 6;</code>
   *
   * @return The count of unconfirmedComponentTypes.
   */
  public int getUnconfirmedComponentTypesCount() {
    return unconfirmedComponentTypes_.size();
  }
  /**
   *
   *
   * <pre>
   * The types of the components that are present in the `address_components`
   * but could not be confirmed to be correct. This field is provided for the
   * sake of convenience: its contents are equivalent to iterating through the
   * `address_components` to find the types of all the components where the
   * [confirmation_level][google.maps.addressvalidation.v1.AddressComponent.confirmation_level]
   * is not
   * [CONFIRMED][google.maps.addressvalidation.v1.AddressComponent.ConfirmationLevel.CONFIRMED]
   * or the
   * [inferred][google.maps.addressvalidation.v1.AddressComponent.inferred]
   * flag is not set to `true`. The list of possible types can be found
   * [here](https://developers.google.com/maps/documentation/geocoding/requests-geocoding#Types).
   * </pre>
   *
   * <code>repeated string unconfirmed_component_types = 6;</code>
   *
   * @param index The index of the element to return.
   * @return The unconfirmedComponentTypes at the given index.
   */
  public java.lang.String getUnconfirmedComponentTypes(int index) {
    return unconfirmedComponentTypes_.get(index);
  }
  /**
   *
   *
   * <pre>
   * The types of the components that are present in the `address_components`
   * but could not be confirmed to be correct. This field is provided for the
   * sake of convenience: its contents are equivalent to iterating through the
   * `address_components` to find the types of all the components where the
   * [confirmation_level][google.maps.addressvalidation.v1.AddressComponent.confirmation_level]
   * is not
   * [CONFIRMED][google.maps.addressvalidation.v1.AddressComponent.ConfirmationLevel.CONFIRMED]
   * or the
   * [inferred][google.maps.addressvalidation.v1.AddressComponent.inferred]
   * flag is not set to `true`. The list of possible types can be found
   * [here](https://developers.google.com/maps/documentation/geocoding/requests-geocoding#Types).
   * </pre>
   *
   * <code>repeated string unconfirmed_component_types = 6;</code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the unconfirmedComponentTypes at the given index.
   */
  public com.google.protobuf.ByteString getUnconfirmedComponentTypesBytes(int index) {
    return unconfirmedComponentTypes_.getByteString(index);
  }

  public static final int UNRESOLVED_TOKENS_FIELD_NUMBER = 7;

  @SuppressWarnings("serial")
  private com.google.protobuf.LazyStringArrayList unresolvedTokens_ =
      com.google.protobuf.LazyStringArrayList.emptyList();
  /**
   *
   *
   * <pre>
   * Any tokens in the input that could not be resolved. This might be an
   * input that was not recognized as a valid part of an address (for example
   * in an input like "123235253253 Main St, San Francisco, CA, 94105", the
   * unresolved tokens may look like `["123235253253"]` since that does not
   * look like a valid street number.
   * </pre>
   *
   * <code>repeated string unresolved_tokens = 7;</code>
   *
   * @return A list containing the unresolvedTokens.
   */
  public com.google.protobuf.ProtocolStringList getUnresolvedTokensList() {
    return unresolvedTokens_;
  }
  /**
   *
   *
   * <pre>
   * Any tokens in the input that could not be resolved. This might be an
   * input that was not recognized as a valid part of an address (for example
   * in an input like "123235253253 Main St, San Francisco, CA, 94105", the
   * unresolved tokens may look like `["123235253253"]` since that does not
   * look like a valid street number.
   * </pre>
   *
   * <code>repeated string unresolved_tokens = 7;</code>
   *
   * @return The count of unresolvedTokens.
   */
  public int getUnresolvedTokensCount() {
    return unresolvedTokens_.size();
  }
  /**
   *
   *
   * <pre>
   * Any tokens in the input that could not be resolved. This might be an
   * input that was not recognized as a valid part of an address (for example
   * in an input like "123235253253 Main St, San Francisco, CA, 94105", the
   * unresolved tokens may look like `["123235253253"]` since that does not
   * look like a valid street number.
   * </pre>
   *
   * <code>repeated string unresolved_tokens = 7;</code>
   *
   * @param index The index of the element to return.
   * @return The unresolvedTokens at the given index.
   */
  public java.lang.String getUnresolvedTokens(int index) {
    return unresolvedTokens_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Any tokens in the input that could not be resolved. This might be an
   * input that was not recognized as a valid part of an address (for example
   * in an input like "123235253253 Main St, San Francisco, CA, 94105", the
   * unresolved tokens may look like `["123235253253"]` since that does not
   * look like a valid street number.
   * </pre>
   *
   * <code>repeated string unresolved_tokens = 7;</code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the unresolvedTokens at the given index.
   */
  public com.google.protobuf.ByteString getUnresolvedTokensBytes(int index) {
    return unresolvedTokens_.getByteString(index);
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(formattedAddress_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, formattedAddress_);
    }
    if (postalAddress_ != null) {
      output.writeMessage(3, getPostalAddress());
    }
    for (int i = 0; i < addressComponents_.size(); i++) {
      output.writeMessage(4, addressComponents_.get(i));
    }
    for (int i = 0; i < missingComponentTypes_.size(); i++) {
      com.google.protobuf.GeneratedMessageV3.writeString(
          output, 5, missingComponentTypes_.getRaw(i));
    }
    for (int i = 0; i < unconfirmedComponentTypes_.size(); i++) {
      com.google.protobuf.GeneratedMessageV3.writeString(
          output, 6, unconfirmedComponentTypes_.getRaw(i));
    }
    for (int i = 0; i < unresolvedTokens_.size(); i++) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 7, unresolvedTokens_.getRaw(i));
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(formattedAddress_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, formattedAddress_);
    }
    if (postalAddress_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, getPostalAddress());
    }
    for (int i = 0; i < addressComponents_.size(); i++) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(4, addressComponents_.get(i));
    }
    {
      int dataSize = 0;
      for (int i = 0; i < missingComponentTypes_.size(); i++) {
        dataSize += computeStringSizeNoTag(missingComponentTypes_.getRaw(i));
      }
      size += dataSize;
      size += 1 * getMissingComponentTypesList().size();
    }
    {
      int dataSize = 0;
      for (int i = 0; i < unconfirmedComponentTypes_.size(); i++) {
        dataSize += computeStringSizeNoTag(unconfirmedComponentTypes_.getRaw(i));
      }
      size += dataSize;
      size += 1 * getUnconfirmedComponentTypesList().size();
    }
    {
      int dataSize = 0;
      for (int i = 0; i < unresolvedTokens_.size(); i++) {
        dataSize += computeStringSizeNoTag(unresolvedTokens_.getRaw(i));
      }
      size += dataSize;
      size += 1 * getUnresolvedTokensList().size();
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.maps.addressvalidation.v1.Address)) {
      return super.equals(obj);
    }
    com.google.maps.addressvalidation.v1.Address other =
        (com.google.maps.addressvalidation.v1.Address) obj;

    if (!getFormattedAddress().equals(other.getFormattedAddress())) return false;
    if (hasPostalAddress() != other.hasPostalAddress()) return false;
    if (hasPostalAddress()) {
      if (!getPostalAddress().equals(other.getPostalAddress())) return false;
    }
    if (!getAddressComponentsList().equals(other.getAddressComponentsList())) return false;
    if (!getMissingComponentTypesList().equals(other.getMissingComponentTypesList())) return false;
    if (!getUnconfirmedComponentTypesList().equals(other.getUnconfirmedComponentTypesList()))
      return false;
    if (!getUnresolvedTokensList().equals(other.getUnresolvedTokensList())) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + FORMATTED_ADDRESS_FIELD_NUMBER;
    hash = (53 * hash) + getFormattedAddress().hashCode();
    if (hasPostalAddress()) {
      hash = (37 * hash) + POSTAL_ADDRESS_FIELD_NUMBER;
      hash = (53 * hash) + getPostalAddress().hashCode();
    }
    if (getAddressComponentsCount() > 0) {
      hash = (37 * hash) + ADDRESS_COMPONENTS_FIELD_NUMBER;
      hash = (53 * hash) + getAddressComponentsList().hashCode();
    }
    if (getMissingComponentTypesCount() > 0) {
      hash = (37 * hash) + MISSING_COMPONENT_TYPES_FIELD_NUMBER;
      hash = (53 * hash) + getMissingComponentTypesList().hashCode();
    }
    if (getUnconfirmedComponentTypesCount() > 0) {
      hash = (37 * hash) + UNCONFIRMED_COMPONENT_TYPES_FIELD_NUMBER;
      hash = (53 * hash) + getUnconfirmedComponentTypesList().hashCode();
    }
    if (getUnresolvedTokensCount() > 0) {
      hash = (37 * hash) + UNRESOLVED_TOKENS_FIELD_NUMBER;
      hash = (53 * hash) + getUnresolvedTokensList().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.maps.addressvalidation.v1.Address parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.maps.addressvalidation.v1.Address parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.maps.addressvalidation.v1.Address parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.maps.addressvalidation.v1.Address parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.maps.addressvalidation.v1.Address parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.maps.addressvalidation.v1.Address parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.maps.addressvalidation.v1.Address parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.maps.addressvalidation.v1.Address parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.maps.addressvalidation.v1.Address parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.maps.addressvalidation.v1.Address parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.maps.addressvalidation.v1.Address parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.maps.addressvalidation.v1.Address parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.maps.addressvalidation.v1.Address prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Details of the post-processed address. Post-processing includes
   * correcting misspelled parts of the address, replacing incorrect parts, and
   * inferring missing parts.
   * </pre>
   *
   * Protobuf type {@code google.maps.addressvalidation.v1.Address}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.maps.addressvalidation.v1.Address)
      com.google.maps.addressvalidation.v1.AddressOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.maps.addressvalidation.v1.AddressProto
          .internal_static_google_maps_addressvalidation_v1_Address_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.maps.addressvalidation.v1.AddressProto
          .internal_static_google_maps_addressvalidation_v1_Address_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.maps.addressvalidation.v1.Address.class,
              com.google.maps.addressvalidation.v1.Address.Builder.class);
    }

    // Construct using com.google.maps.addressvalidation.v1.Address.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      formattedAddress_ = "";
      postalAddress_ = null;
      if (postalAddressBuilder_ != null) {
        postalAddressBuilder_.dispose();
        postalAddressBuilder_ = null;
      }
      if (addressComponentsBuilder_ == null) {
        addressComponents_ = java.util.Collections.emptyList();
      } else {
        addressComponents_ = null;
        addressComponentsBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000004);
      missingComponentTypes_ = com.google.protobuf.LazyStringArrayList.emptyList();
      unconfirmedComponentTypes_ = com.google.protobuf.LazyStringArrayList.emptyList();
      unresolvedTokens_ = com.google.protobuf.LazyStringArrayList.emptyList();
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.maps.addressvalidation.v1.AddressProto
          .internal_static_google_maps_addressvalidation_v1_Address_descriptor;
    }

    @java.lang.Override
    public com.google.maps.addressvalidation.v1.Address getDefaultInstanceForType() {
      return com.google.maps.addressvalidation.v1.Address.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.maps.addressvalidation.v1.Address build() {
      com.google.maps.addressvalidation.v1.Address result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.maps.addressvalidation.v1.Address buildPartial() {
      com.google.maps.addressvalidation.v1.Address result =
          new com.google.maps.addressvalidation.v1.Address(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(com.google.maps.addressvalidation.v1.Address result) {
      if (addressComponentsBuilder_ == null) {
        if (((bitField0_ & 0x00000004) != 0)) {
          addressComponents_ = java.util.Collections.unmodifiableList(addressComponents_);
          bitField0_ = (bitField0_ & ~0x00000004);
        }
        result.addressComponents_ = addressComponents_;
      } else {
        result.addressComponents_ = addressComponentsBuilder_.build();
      }
    }

    private void buildPartial0(com.google.maps.addressvalidation.v1.Address result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.formattedAddress_ = formattedAddress_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.postalAddress_ =
            postalAddressBuilder_ == null ? postalAddress_ : postalAddressBuilder_.build();
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        missingComponentTypes_.makeImmutable();
        result.missingComponentTypes_ = missingComponentTypes_;
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        unconfirmedComponentTypes_.makeImmutable();
        result.unconfirmedComponentTypes_ = unconfirmedComponentTypes_;
      }
      if (((from_bitField0_ & 0x00000020) != 0)) {
        unresolvedTokens_.makeImmutable();
        result.unresolvedTokens_ = unresolvedTokens_;
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.maps.addressvalidation.v1.Address) {
        return mergeFrom((com.google.maps.addressvalidation.v1.Address) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.maps.addressvalidation.v1.Address other) {
      if (other == com.google.maps.addressvalidation.v1.Address.getDefaultInstance()) return this;
      if (!other.getFormattedAddress().isEmpty()) {
        formattedAddress_ = other.formattedAddress_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (other.hasPostalAddress()) {
        mergePostalAddress(other.getPostalAddress());
      }
      if (addressComponentsBuilder_ == null) {
        if (!other.addressComponents_.isEmpty()) {
          if (addressComponents_.isEmpty()) {
            addressComponents_ = other.addressComponents_;
            bitField0_ = (bitField0_ & ~0x00000004);
          } else {
            ensureAddressComponentsIsMutable();
            addressComponents_.addAll(other.addressComponents_);
          }
          onChanged();
        }
      } else {
        if (!other.addressComponents_.isEmpty()) {
          if (addressComponentsBuilder_.isEmpty()) {
            addressComponentsBuilder_.dispose();
            addressComponentsBuilder_ = null;
            addressComponents_ = other.addressComponents_;
            bitField0_ = (bitField0_ & ~0x00000004);
            addressComponentsBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getAddressComponentsFieldBuilder()
                    : null;
          } else {
            addressComponentsBuilder_.addAllMessages(other.addressComponents_);
          }
        }
      }
      if (!other.missingComponentTypes_.isEmpty()) {
        if (missingComponentTypes_.isEmpty()) {
          missingComponentTypes_ = other.missingComponentTypes_;
          bitField0_ |= 0x00000008;
        } else {
          ensureMissingComponentTypesIsMutable();
          missingComponentTypes_.addAll(other.missingComponentTypes_);
        }
        onChanged();
      }
      if (!other.unconfirmedComponentTypes_.isEmpty()) {
        if (unconfirmedComponentTypes_.isEmpty()) {
          unconfirmedComponentTypes_ = other.unconfirmedComponentTypes_;
          bitField0_ |= 0x00000010;
        } else {
          ensureUnconfirmedComponentTypesIsMutable();
          unconfirmedComponentTypes_.addAll(other.unconfirmedComponentTypes_);
        }
        onChanged();
      }
      if (!other.unresolvedTokens_.isEmpty()) {
        if (unresolvedTokens_.isEmpty()) {
          unresolvedTokens_ = other.unresolvedTokens_;
          bitField0_ |= 0x00000020;
        } else {
          ensureUnresolvedTokensIsMutable();
          unresolvedTokens_.addAll(other.unresolvedTokens_);
        }
        onChanged();
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 18:
              {
                formattedAddress_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 18
            case 26:
              {
                input.readMessage(getPostalAddressFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000002;
                break;
              } // case 26
            case 34:
              {
                com.google.maps.addressvalidation.v1.AddressComponent m =
                    input.readMessage(
                        com.google.maps.addressvalidation.v1.AddressComponent.parser(),
                        extensionRegistry);
                if (addressComponentsBuilder_ == null) {
                  ensureAddressComponentsIsMutable();
                  addressComponents_.add(m);
                } else {
                  addressComponentsBuilder_.addMessage(m);
                }
                break;
              } // case 34
            case 42:
              {
                java.lang.String s = input.readStringRequireUtf8();
                ensureMissingComponentTypesIsMutable();
                missingComponentTypes_.add(s);
                break;
              } // case 42
            case 50:
              {
                java.lang.String s = input.readStringRequireUtf8();
                ensureUnconfirmedComponentTypesIsMutable();
                unconfirmedComponentTypes_.add(s);
                break;
              } // case 50
            case 58:
              {
                java.lang.String s = input.readStringRequireUtf8();
                ensureUnresolvedTokensIsMutable();
                unresolvedTokens_.add(s);
                break;
              } // case 58
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object formattedAddress_ = "";
    /**
     *
     *
     * <pre>
     * The post-processed address, formatted as a single-line address following
     * the address formatting rules of the region where the address is located.
     * </pre>
     *
     * <code>string formatted_address = 2;</code>
     *
     * @return The formattedAddress.
     */
    public java.lang.String getFormattedAddress() {
      java.lang.Object ref = formattedAddress_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        formattedAddress_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The post-processed address, formatted as a single-line address following
     * the address formatting rules of the region where the address is located.
     * </pre>
     *
     * <code>string formatted_address = 2;</code>
     *
     * @return The bytes for formattedAddress.
     */
    public com.google.protobuf.ByteString getFormattedAddressBytes() {
      java.lang.Object ref = formattedAddress_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        formattedAddress_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The post-processed address, formatted as a single-line address following
     * the address formatting rules of the region where the address is located.
     * </pre>
     *
     * <code>string formatted_address = 2;</code>
     *
     * @param value The formattedAddress to set.
     * @return This builder for chaining.
     */
    public Builder setFormattedAddress(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      formattedAddress_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The post-processed address, formatted as a single-line address following
     * the address formatting rules of the region where the address is located.
     * </pre>
     *
     * <code>string formatted_address = 2;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearFormattedAddress() {
      formattedAddress_ = getDefaultInstance().getFormattedAddress();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The post-processed address, formatted as a single-line address following
     * the address formatting rules of the region where the address is located.
     * </pre>
     *
     * <code>string formatted_address = 2;</code>
     *
     * @param value The bytes for formattedAddress to set.
     * @return This builder for chaining.
     */
    public Builder setFormattedAddressBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      formattedAddress_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private com.google.type.PostalAddress postalAddress_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.type.PostalAddress,
            com.google.type.PostalAddress.Builder,
            com.google.type.PostalAddressOrBuilder>
        postalAddressBuilder_;
    /**
     *
     *
     * <pre>
     * The post-processed address represented as a postal address.
     * </pre>
     *
     * <code>.google.type.PostalAddress postal_address = 3;</code>
     *
     * @return Whether the postalAddress field is set.
     */
    public boolean hasPostalAddress() {
      return ((bitField0_ & 0x00000002) != 0);
    }
    /**
     *
     *
     * <pre>
     * The post-processed address represented as a postal address.
     * </pre>
     *
     * <code>.google.type.PostalAddress postal_address = 3;</code>
     *
     * @return The postalAddress.
     */
    public com.google.type.PostalAddress getPostalAddress() {
      if (postalAddressBuilder_ == null) {
        return postalAddress_ == null
            ? com.google.type.PostalAddress.getDefaultInstance()
            : postalAddress_;
      } else {
        return postalAddressBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * The post-processed address represented as a postal address.
     * </pre>
     *
     * <code>.google.type.PostalAddress postal_address = 3;</code>
     */
    public Builder setPostalAddress(com.google.type.PostalAddress value) {
      if (postalAddressBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        postalAddress_ = value;
      } else {
        postalAddressBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The post-processed address represented as a postal address.
     * </pre>
     *
     * <code>.google.type.PostalAddress postal_address = 3;</code>
     */
    public Builder setPostalAddress(com.google.type.PostalAddress.Builder builderForValue) {
      if (postalAddressBuilder_ == null) {
        postalAddress_ = builderForValue.build();
      } else {
        postalAddressBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The post-processed address represented as a postal address.
     * </pre>
     *
     * <code>.google.type.PostalAddress postal_address = 3;</code>
     */
    public Builder mergePostalAddress(com.google.type.PostalAddress value) {
      if (postalAddressBuilder_ == null) {
        if (((bitField0_ & 0x00000002) != 0)
            && postalAddress_ != null
            && postalAddress_ != com.google.type.PostalAddress.getDefaultInstance()) {
          getPostalAddressBuilder().mergeFrom(value);
        } else {
          postalAddress_ = value;
        }
      } else {
        postalAddressBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The post-processed address represented as a postal address.
     * </pre>
     *
     * <code>.google.type.PostalAddress postal_address = 3;</code>
     */
    public Builder clearPostalAddress() {
      bitField0_ = (bitField0_ & ~0x00000002);
      postalAddress_ = null;
      if (postalAddressBuilder_ != null) {
        postalAddressBuilder_.dispose();
        postalAddressBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The post-processed address represented as a postal address.
     * </pre>
     *
     * <code>.google.type.PostalAddress postal_address = 3;</code>
     */
    public com.google.type.PostalAddress.Builder getPostalAddressBuilder() {
      bitField0_ |= 0x00000002;
      onChanged();
      return getPostalAddressFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The post-processed address represented as a postal address.
     * </pre>
     *
     * <code>.google.type.PostalAddress postal_address = 3;</code>
     */
    public com.google.type.PostalAddressOrBuilder getPostalAddressOrBuilder() {
      if (postalAddressBuilder_ != null) {
        return postalAddressBuilder_.getMessageOrBuilder();
      } else {
        return postalAddress_ == null
            ? com.google.type.PostalAddress.getDefaultInstance()
            : postalAddress_;
      }
    }
    /**
     *
     *
     * <pre>
     * The post-processed address represented as a postal address.
     * </pre>
     *
     * <code>.google.type.PostalAddress postal_address = 3;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.type.PostalAddress,
            com.google.type.PostalAddress.Builder,
            com.google.type.PostalAddressOrBuilder>
        getPostalAddressFieldBuilder() {
      if (postalAddressBuilder_ == null) {
        postalAddressBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.type.PostalAddress,
                com.google.type.PostalAddress.Builder,
                com.google.type.PostalAddressOrBuilder>(
                getPostalAddress(), getParentForChildren(), isClean());
        postalAddress_ = null;
      }
      return postalAddressBuilder_;
    }

    private java.util.List<com.google.maps.addressvalidation.v1.AddressComponent>
        addressComponents_ = java.util.Collections.emptyList();

    private void ensureAddressComponentsIsMutable() {
      if (!((bitField0_ & 0x00000004) != 0)) {
        addressComponents_ =
            new java.util.ArrayList<com.google.maps.addressvalidation.v1.AddressComponent>(
                addressComponents_);
        bitField0_ |= 0x00000004;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.maps.addressvalidation.v1.AddressComponent,
            com.google.maps.addressvalidation.v1.AddressComponent.Builder,
            com.google.maps.addressvalidation.v1.AddressComponentOrBuilder>
        addressComponentsBuilder_;

    /**
     *
     *
     * <pre>
     * Unordered list. The individual address components of the formatted and
     * corrected address, along with validation information. This provides
     * information on the validation status of the individual components.
     *
     * Address components are not ordered in a particular way. Do not make any
     * assumptions on the ordering of the address components in the list.
     * </pre>
     *
     * <code>
     * repeated .google.maps.addressvalidation.v1.AddressComponent address_components = 4 [(.google.api.field_behavior) = UNORDERED_LIST];
     * </code>
     */
    public java.util.List<com.google.maps.addressvalidation.v1.AddressComponent>
        getAddressComponentsList() {
      if (addressComponentsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(addressComponents_);
      } else {
        return addressComponentsBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * Unordered list. The individual address components of the formatted and
     * corrected address, along with validation information. This provides
     * information on the validation status of the individual components.
     *
     * Address components are not ordered in a particular way. Do not make any
     * assumptions on the ordering of the address components in the list.
     * </pre>
     *
     * <code>
     * repeated .google.maps.addressvalidation.v1.AddressComponent address_components = 4 [(.google.api.field_behavior) = UNORDERED_LIST];
     * </code>
     */
    public int getAddressComponentsCount() {
      if (addressComponentsBuilder_ == null) {
        return addressComponents_.size();
      } else {
        return addressComponentsBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * Unordered list. The individual address components of the formatted and
     * corrected address, along with validation information. This provides
     * information on the validation status of the individual components.
     *
     * Address components are not ordered in a particular way. Do not make any
     * assumptions on the ordering of the address components in the list.
     * </pre>
     *
     * <code>
     * repeated .google.maps.addressvalidation.v1.AddressComponent address_components = 4 [(.google.api.field_behavior) = UNORDERED_LIST];
     * </code>
     */
    public com.google.maps.addressvalidation.v1.AddressComponent getAddressComponents(int index) {
      if (addressComponentsBuilder_ == null) {
        return addressComponents_.get(index);
      } else {
        return addressComponentsBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Unordered list. The individual address components of the formatted and
     * corrected address, along with validation information. This provides
     * information on the validation status of the individual components.
     *
     * Address components are not ordered in a particular way. Do not make any
     * assumptions on the ordering of the address components in the list.
     * </pre>
     *
     * <code>
     * repeated .google.maps.addressvalidation.v1.AddressComponent address_components = 4 [(.google.api.field_behavior) = UNORDERED_LIST];
     * </code>
     */
    public Builder setAddressComponents(
        int index, com.google.maps.addressvalidation.v1.AddressComponent value) {
      if (addressComponentsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureAddressComponentsIsMutable();
        addressComponents_.set(index, value);
        onChanged();
      } else {
        addressComponentsBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Unordered list. The individual address components of the formatted and
     * corrected address, along with validation information. This provides
     * information on the validation status of the individual components.
     *
     * Address components are not ordered in a particular way. Do not make any
     * assumptions on the ordering of the address components in the list.
     * </pre>
     *
     * <code>
     * repeated .google.maps.addressvalidation.v1.AddressComponent address_components = 4 [(.google.api.field_behavior) = UNORDERED_LIST];
     * </code>
     */
    public Builder setAddressComponents(
        int index, com.google.maps.addressvalidation.v1.AddressComponent.Builder builderForValue) {
      if (addressComponentsBuilder_ == null) {
        ensureAddressComponentsIsMutable();
        addressComponents_.set(index, builderForValue.build());
        onChanged();
      } else {
        addressComponentsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Unordered list. The individual address components of the formatted and
     * corrected address, along with validation information. This provides
     * information on the validation status of the individual components.
     *
     * Address components are not ordered in a particular way. Do not make any
     * assumptions on the ordering of the address components in the list.
     * </pre>
     *
     * <code>
     * repeated .google.maps.addressvalidation.v1.AddressComponent address_components = 4 [(.google.api.field_behavior) = UNORDERED_LIST];
     * </code>
     */
    public Builder addAddressComponents(
        com.google.maps.addressvalidation.v1.AddressComponent value) {
      if (addressComponentsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureAddressComponentsIsMutable();
        addressComponents_.add(value);
        onChanged();
      } else {
        addressComponentsBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Unordered list. The individual address components of the formatted and
     * corrected address, along with validation information. This provides
     * information on the validation status of the individual components.
     *
     * Address components are not ordered in a particular way. Do not make any
     * assumptions on the ordering of the address components in the list.
     * </pre>
     *
     * <code>
     * repeated .google.maps.addressvalidation.v1.AddressComponent address_components = 4 [(.google.api.field_behavior) = UNORDERED_LIST];
     * </code>
     */
    public Builder addAddressComponents(
        int index, com.google.maps.addressvalidation.v1.AddressComponent value) {
      if (addressComponentsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureAddressComponentsIsMutable();
        addressComponents_.add(index, value);
        onChanged();
      } else {
        addressComponentsBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Unordered list. The individual address components of the formatted and
     * corrected address, along with validation information. This provides
     * information on the validation status of the individual components.
     *
     * Address components are not ordered in a particular way. Do not make any
     * assumptions on the ordering of the address components in the list.
     * </pre>
     *
     * <code>
     * repeated .google.maps.addressvalidation.v1.AddressComponent address_components = 4 [(.google.api.field_behavior) = UNORDERED_LIST];
     * </code>
     */
    public Builder addAddressComponents(
        com.google.maps.addressvalidation.v1.AddressComponent.Builder builderForValue) {
      if (addressComponentsBuilder_ == null) {
        ensureAddressComponentsIsMutable();
        addressComponents_.add(builderForValue.build());
        onChanged();
      } else {
        addressComponentsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Unordered list. The individual address components of the formatted and
     * corrected address, along with validation information. This provides
     * information on the validation status of the individual components.
     *
     * Address components are not ordered in a particular way. Do not make any
     * assumptions on the ordering of the address components in the list.
     * </pre>
     *
     * <code>
     * repeated .google.maps.addressvalidation.v1.AddressComponent address_components = 4 [(.google.api.field_behavior) = UNORDERED_LIST];
     * </code>
     */
    public Builder addAddressComponents(
        int index, com.google.maps.addressvalidation.v1.AddressComponent.Builder builderForValue) {
      if (addressComponentsBuilder_ == null) {
        ensureAddressComponentsIsMutable();
        addressComponents_.add(index, builderForValue.build());
        onChanged();
      } else {
        addressComponentsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Unordered list. The individual address components of the formatted and
     * corrected address, along with validation information. This provides
     * information on the validation status of the individual components.
     *
     * Address components are not ordered in a particular way. Do not make any
     * assumptions on the ordering of the address components in the list.
     * </pre>
     *
     * <code>
     * repeated .google.maps.addressvalidation.v1.AddressComponent address_components = 4 [(.google.api.field_behavior) = UNORDERED_LIST];
     * </code>
     */
    public Builder addAllAddressComponents(
        java.lang.Iterable<? extends com.google.maps.addressvalidation.v1.AddressComponent>
            values) {
      if (addressComponentsBuilder_ == null) {
        ensureAddressComponentsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, addressComponents_);
        onChanged();
      } else {
        addressComponentsBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Unordered list. The individual address components of the formatted and
     * corrected address, along with validation information. This provides
     * information on the validation status of the individual components.
     *
     * Address components are not ordered in a particular way. Do not make any
     * assumptions on the ordering of the address components in the list.
     * </pre>
     *
     * <code>
     * repeated .google.maps.addressvalidation.v1.AddressComponent address_components = 4 [(.google.api.field_behavior) = UNORDERED_LIST];
     * </code>
     */
    public Builder clearAddressComponents() {
      if (addressComponentsBuilder_ == null) {
        addressComponents_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000004);
        onChanged();
      } else {
        addressComponentsBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Unordered list. The individual address components of the formatted and
     * corrected address, along with validation information. This provides
     * information on the validation status of the individual components.
     *
     * Address components are not ordered in a particular way. Do not make any
     * assumptions on the ordering of the address components in the list.
     * </pre>
     *
     * <code>
     * repeated .google.maps.addressvalidation.v1.AddressComponent address_components = 4 [(.google.api.field_behavior) = UNORDERED_LIST];
     * </code>
     */
    public Builder removeAddressComponents(int index) {
      if (addressComponentsBuilder_ == null) {
        ensureAddressComponentsIsMutable();
        addressComponents_.remove(index);
        onChanged();
      } else {
        addressComponentsBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Unordered list. The individual address components of the formatted and
     * corrected address, along with validation information. This provides
     * information on the validation status of the individual components.
     *
     * Address components are not ordered in a particular way. Do not make any
     * assumptions on the ordering of the address components in the list.
     * </pre>
     *
     * <code>
     * repeated .google.maps.addressvalidation.v1.AddressComponent address_components = 4 [(.google.api.field_behavior) = UNORDERED_LIST];
     * </code>
     */
    public com.google.maps.addressvalidation.v1.AddressComponent.Builder
        getAddressComponentsBuilder(int index) {
      return getAddressComponentsFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * Unordered list. The individual address components of the formatted and
     * corrected address, along with validation information. This provides
     * information on the validation status of the individual components.
     *
     * Address components are not ordered in a particular way. Do not make any
     * assumptions on the ordering of the address components in the list.
     * </pre>
     *
     * <code>
     * repeated .google.maps.addressvalidation.v1.AddressComponent address_components = 4 [(.google.api.field_behavior) = UNORDERED_LIST];
     * </code>
     */
    public com.google.maps.addressvalidation.v1.AddressComponentOrBuilder
        getAddressComponentsOrBuilder(int index) {
      if (addressComponentsBuilder_ == null) {
        return addressComponents_.get(index);
      } else {
        return addressComponentsBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Unordered list. The individual address components of the formatted and
     * corrected address, along with validation information. This provides
     * information on the validation status of the individual components.
     *
     * Address components are not ordered in a particular way. Do not make any
     * assumptions on the ordering of the address components in the list.
     * </pre>
     *
     * <code>
     * repeated .google.maps.addressvalidation.v1.AddressComponent address_components = 4 [(.google.api.field_behavior) = UNORDERED_LIST];
     * </code>
     */
    public java.util.List<? extends com.google.maps.addressvalidation.v1.AddressComponentOrBuilder>
        getAddressComponentsOrBuilderList() {
      if (addressComponentsBuilder_ != null) {
        return addressComponentsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(addressComponents_);
      }
    }
    /**
     *
     *
     * <pre>
     * Unordered list. The individual address components of the formatted and
     * corrected address, along with validation information. This provides
     * information on the validation status of the individual components.
     *
     * Address components are not ordered in a particular way. Do not make any
     * assumptions on the ordering of the address components in the list.
     * </pre>
     *
     * <code>
     * repeated .google.maps.addressvalidation.v1.AddressComponent address_components = 4 [(.google.api.field_behavior) = UNORDERED_LIST];
     * </code>
     */
    public com.google.maps.addressvalidation.v1.AddressComponent.Builder
        addAddressComponentsBuilder() {
      return getAddressComponentsFieldBuilder()
          .addBuilder(com.google.maps.addressvalidation.v1.AddressComponent.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Unordered list. The individual address components of the formatted and
     * corrected address, along with validation information. This provides
     * information on the validation status of the individual components.
     *
     * Address components are not ordered in a particular way. Do not make any
     * assumptions on the ordering of the address components in the list.
     * </pre>
     *
     * <code>
     * repeated .google.maps.addressvalidation.v1.AddressComponent address_components = 4 [(.google.api.field_behavior) = UNORDERED_LIST];
     * </code>
     */
    public com.google.maps.addressvalidation.v1.AddressComponent.Builder
        addAddressComponentsBuilder(int index) {
      return getAddressComponentsFieldBuilder()
          .addBuilder(
              index, com.google.maps.addressvalidation.v1.AddressComponent.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Unordered list. The individual address components of the formatted and
     * corrected address, along with validation information. This provides
     * information on the validation status of the individual components.
     *
     * Address components are not ordered in a particular way. Do not make any
     * assumptions on the ordering of the address components in the list.
     * </pre>
     *
     * <code>
     * repeated .google.maps.addressvalidation.v1.AddressComponent address_components = 4 [(.google.api.field_behavior) = UNORDERED_LIST];
     * </code>
     */
    public java.util.List<com.google.maps.addressvalidation.v1.AddressComponent.Builder>
        getAddressComponentsBuilderList() {
      return getAddressComponentsFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.maps.addressvalidation.v1.AddressComponent,
            com.google.maps.addressvalidation.v1.AddressComponent.Builder,
            com.google.maps.addressvalidation.v1.AddressComponentOrBuilder>
        getAddressComponentsFieldBuilder() {
      if (addressComponentsBuilder_ == null) {
        addressComponentsBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.maps.addressvalidation.v1.AddressComponent,
                com.google.maps.addressvalidation.v1.AddressComponent.Builder,
                com.google.maps.addressvalidation.v1.AddressComponentOrBuilder>(
                addressComponents_,
                ((bitField0_ & 0x00000004) != 0),
                getParentForChildren(),
                isClean());
        addressComponents_ = null;
      }
      return addressComponentsBuilder_;
    }

    private com.google.protobuf.LazyStringArrayList missingComponentTypes_ =
        com.google.protobuf.LazyStringArrayList.emptyList();

    private void ensureMissingComponentTypesIsMutable() {
      if (!missingComponentTypes_.isModifiable()) {
        missingComponentTypes_ =
            new com.google.protobuf.LazyStringArrayList(missingComponentTypes_);
      }
      bitField0_ |= 0x00000008;
    }
    /**
     *
     *
     * <pre>
     * The types of components that were expected to be present in a correctly
     * formatted mailing address but were not found in the input AND could
     * not be inferred. Components of this type are not present in
     * `formatted_address`, `postal_address`, or `address_components`. An
     * example might be `['street_number', 'route']` for an input like
     * "Boulder, Colorado, 80301, USA". The list of possible types can be found
     * [here](https://developers.google.com/maps/documentation/geocoding/requests-geocoding#Types).
     * </pre>
     *
     * <code>repeated string missing_component_types = 5;</code>
     *
     * @return A list containing the missingComponentTypes.
     */
    public com.google.protobuf.ProtocolStringList getMissingComponentTypesList() {
      missingComponentTypes_.makeImmutable();
      return missingComponentTypes_;
    }
    /**
     *
     *
     * <pre>
     * The types of components that were expected to be present in a correctly
     * formatted mailing address but were not found in the input AND could
     * not be inferred. Components of this type are not present in
     * `formatted_address`, `postal_address`, or `address_components`. An
     * example might be `['street_number', 'route']` for an input like
     * "Boulder, Colorado, 80301, USA". The list of possible types can be found
     * [here](https://developers.google.com/maps/documentation/geocoding/requests-geocoding#Types).
     * </pre>
     *
     * <code>repeated string missing_component_types = 5;</code>
     *
     * @return The count of missingComponentTypes.
     */
    public int getMissingComponentTypesCount() {
      return missingComponentTypes_.size();
    }
    /**
     *
     *
     * <pre>
     * The types of components that were expected to be present in a correctly
     * formatted mailing address but were not found in the input AND could
     * not be inferred. Components of this type are not present in
     * `formatted_address`, `postal_address`, or `address_components`. An
     * example might be `['street_number', 'route']` for an input like
     * "Boulder, Colorado, 80301, USA". The list of possible types can be found
     * [here](https://developers.google.com/maps/documentation/geocoding/requests-geocoding#Types).
     * </pre>
     *
     * <code>repeated string missing_component_types = 5;</code>
     *
     * @param index The index of the element to return.
     * @return The missingComponentTypes at the given index.
     */
    public java.lang.String getMissingComponentTypes(int index) {
      return missingComponentTypes_.get(index);
    }
    /**
     *
     *
     * <pre>
     * The types of components that were expected to be present in a correctly
     * formatted mailing address but were not found in the input AND could
     * not be inferred. Components of this type are not present in
     * `formatted_address`, `postal_address`, or `address_components`. An
     * example might be `['street_number', 'route']` for an input like
     * "Boulder, Colorado, 80301, USA". The list of possible types can be found
     * [here](https://developers.google.com/maps/documentation/geocoding/requests-geocoding#Types).
     * </pre>
     *
     * <code>repeated string missing_component_types = 5;</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the missingComponentTypes at the given index.
     */
    public com.google.protobuf.ByteString getMissingComponentTypesBytes(int index) {
      return missingComponentTypes_.getByteString(index);
    }
    /**
     *
     *
     * <pre>
     * The types of components that were expected to be present in a correctly
     * formatted mailing address but were not found in the input AND could
     * not be inferred. Components of this type are not present in
     * `formatted_address`, `postal_address`, or `address_components`. An
     * example might be `['street_number', 'route']` for an input like
     * "Boulder, Colorado, 80301, USA". The list of possible types can be found
     * [here](https://developers.google.com/maps/documentation/geocoding/requests-geocoding#Types).
     * </pre>
     *
     * <code>repeated string missing_component_types = 5;</code>
     *
     * @param index The index to set the value at.
     * @param value The missingComponentTypes to set.
     * @return This builder for chaining.
     */
    public Builder setMissingComponentTypes(int index, java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureMissingComponentTypesIsMutable();
      missingComponentTypes_.set(index, value);
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The types of components that were expected to be present in a correctly
     * formatted mailing address but were not found in the input AND could
     * not be inferred. Components of this type are not present in
     * `formatted_address`, `postal_address`, or `address_components`. An
     * example might be `['street_number', 'route']` for an input like
     * "Boulder, Colorado, 80301, USA". The list of possible types can be found
     * [here](https://developers.google.com/maps/documentation/geocoding/requests-geocoding#Types).
     * </pre>
     *
     * <code>repeated string missing_component_types = 5;</code>
     *
     * @param value The missingComponentTypes to add.
     * @return This builder for chaining.
     */
    public Builder addMissingComponentTypes(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureMissingComponentTypesIsMutable();
      missingComponentTypes_.add(value);
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The types of components that were expected to be present in a correctly
     * formatted mailing address but were not found in the input AND could
     * not be inferred. Components of this type are not present in
     * `formatted_address`, `postal_address`, or `address_components`. An
     * example might be `['street_number', 'route']` for an input like
     * "Boulder, Colorado, 80301, USA". The list of possible types can be found
     * [here](https://developers.google.com/maps/documentation/geocoding/requests-geocoding#Types).
     * </pre>
     *
     * <code>repeated string missing_component_types = 5;</code>
     *
     * @param values The missingComponentTypes to add.
     * @return This builder for chaining.
     */
    public Builder addAllMissingComponentTypes(java.lang.Iterable<java.lang.String> values) {
      ensureMissingComponentTypesIsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(values, missingComponentTypes_);
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The types of components that were expected to be present in a correctly
     * formatted mailing address but were not found in the input AND could
     * not be inferred. Components of this type are not present in
     * `formatted_address`, `postal_address`, or `address_components`. An
     * example might be `['street_number', 'route']` for an input like
     * "Boulder, Colorado, 80301, USA". The list of possible types can be found
     * [here](https://developers.google.com/maps/documentation/geocoding/requests-geocoding#Types).
     * </pre>
     *
     * <code>repeated string missing_component_types = 5;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearMissingComponentTypes() {
      missingComponentTypes_ = com.google.protobuf.LazyStringArrayList.emptyList();
      bitField0_ = (bitField0_ & ~0x00000008);
      ;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The types of components that were expected to be present in a correctly
     * formatted mailing address but were not found in the input AND could
     * not be inferred. Components of this type are not present in
     * `formatted_address`, `postal_address`, or `address_components`. An
     * example might be `['street_number', 'route']` for an input like
     * "Boulder, Colorado, 80301, USA". The list of possible types can be found
     * [here](https://developers.google.com/maps/documentation/geocoding/requests-geocoding#Types).
     * </pre>
     *
     * <code>repeated string missing_component_types = 5;</code>
     *
     * @param value The bytes of the missingComponentTypes to add.
     * @return This builder for chaining.
     */
    public Builder addMissingComponentTypesBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      ensureMissingComponentTypesIsMutable();
      missingComponentTypes_.add(value);
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    private com.google.protobuf.LazyStringArrayList unconfirmedComponentTypes_ =
        com.google.protobuf.LazyStringArrayList.emptyList();

    private void ensureUnconfirmedComponentTypesIsMutable() {
      if (!unconfirmedComponentTypes_.isModifiable()) {
        unconfirmedComponentTypes_ =
            new com.google.protobuf.LazyStringArrayList(unconfirmedComponentTypes_);
      }
      bitField0_ |= 0x00000010;
    }
    /**
     *
     *
     * <pre>
     * The types of the components that are present in the `address_components`
     * but could not be confirmed to be correct. This field is provided for the
     * sake of convenience: its contents are equivalent to iterating through the
     * `address_components` to find the types of all the components where the
     * [confirmation_level][google.maps.addressvalidation.v1.AddressComponent.confirmation_level]
     * is not
     * [CONFIRMED][google.maps.addressvalidation.v1.AddressComponent.ConfirmationLevel.CONFIRMED]
     * or the
     * [inferred][google.maps.addressvalidation.v1.AddressComponent.inferred]
     * flag is not set to `true`. The list of possible types can be found
     * [here](https://developers.google.com/maps/documentation/geocoding/requests-geocoding#Types).
     * </pre>
     *
     * <code>repeated string unconfirmed_component_types = 6;</code>
     *
     * @return A list containing the unconfirmedComponentTypes.
     */
    public com.google.protobuf.ProtocolStringList getUnconfirmedComponentTypesList() {
      unconfirmedComponentTypes_.makeImmutable();
      return unconfirmedComponentTypes_;
    }
    /**
     *
     *
     * <pre>
     * The types of the components that are present in the `address_components`
     * but could not be confirmed to be correct. This field is provided for the
     * sake of convenience: its contents are equivalent to iterating through the
     * `address_components` to find the types of all the components where the
     * [confirmation_level][google.maps.addressvalidation.v1.AddressComponent.confirmation_level]
     * is not
     * [CONFIRMED][google.maps.addressvalidation.v1.AddressComponent.ConfirmationLevel.CONFIRMED]
     * or the
     * [inferred][google.maps.addressvalidation.v1.AddressComponent.inferred]
     * flag is not set to `true`. The list of possible types can be found
     * [here](https://developers.google.com/maps/documentation/geocoding/requests-geocoding#Types).
     * </pre>
     *
     * <code>repeated string unconfirmed_component_types = 6;</code>
     *
     * @return The count of unconfirmedComponentTypes.
     */
    public int getUnconfirmedComponentTypesCount() {
      return unconfirmedComponentTypes_.size();
    }
    /**
     *
     *
     * <pre>
     * The types of the components that are present in the `address_components`
     * but could not be confirmed to be correct. This field is provided for the
     * sake of convenience: its contents are equivalent to iterating through the
     * `address_components` to find the types of all the components where the
     * [confirmation_level][google.maps.addressvalidation.v1.AddressComponent.confirmation_level]
     * is not
     * [CONFIRMED][google.maps.addressvalidation.v1.AddressComponent.ConfirmationLevel.CONFIRMED]
     * or the
     * [inferred][google.maps.addressvalidation.v1.AddressComponent.inferred]
     * flag is not set to `true`. The list of possible types can be found
     * [here](https://developers.google.com/maps/documentation/geocoding/requests-geocoding#Types).
     * </pre>
     *
     * <code>repeated string unconfirmed_component_types = 6;</code>
     *
     * @param index The index of the element to return.
     * @return The unconfirmedComponentTypes at the given index.
     */
    public java.lang.String getUnconfirmedComponentTypes(int index) {
      return unconfirmedComponentTypes_.get(index);
    }
    /**
     *
     *
     * <pre>
     * The types of the components that are present in the `address_components`
     * but could not be confirmed to be correct. This field is provided for the
     * sake of convenience: its contents are equivalent to iterating through the
     * `address_components` to find the types of all the components where the
     * [confirmation_level][google.maps.addressvalidation.v1.AddressComponent.confirmation_level]
     * is not
     * [CONFIRMED][google.maps.addressvalidation.v1.AddressComponent.ConfirmationLevel.CONFIRMED]
     * or the
     * [inferred][google.maps.addressvalidation.v1.AddressComponent.inferred]
     * flag is not set to `true`. The list of possible types can be found
     * [here](https://developers.google.com/maps/documentation/geocoding/requests-geocoding#Types).
     * </pre>
     *
     * <code>repeated string unconfirmed_component_types = 6;</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the unconfirmedComponentTypes at the given index.
     */
    public com.google.protobuf.ByteString getUnconfirmedComponentTypesBytes(int index) {
      return unconfirmedComponentTypes_.getByteString(index);
    }
    /**
     *
     *
     * <pre>
     * The types of the components that are present in the `address_components`
     * but could not be confirmed to be correct. This field is provided for the
     * sake of convenience: its contents are equivalent to iterating through the
     * `address_components` to find the types of all the components where the
     * [confirmation_level][google.maps.addressvalidation.v1.AddressComponent.confirmation_level]
     * is not
     * [CONFIRMED][google.maps.addressvalidation.v1.AddressComponent.ConfirmationLevel.CONFIRMED]
     * or the
     * [inferred][google.maps.addressvalidation.v1.AddressComponent.inferred]
     * flag is not set to `true`. The list of possible types can be found
     * [here](https://developers.google.com/maps/documentation/geocoding/requests-geocoding#Types).
     * </pre>
     *
     * <code>repeated string unconfirmed_component_types = 6;</code>
     *
     * @param index The index to set the value at.
     * @param value The unconfirmedComponentTypes to set.
     * @return This builder for chaining.
     */
    public Builder setUnconfirmedComponentTypes(int index, java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureUnconfirmedComponentTypesIsMutable();
      unconfirmedComponentTypes_.set(index, value);
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The types of the components that are present in the `address_components`
     * but could not be confirmed to be correct. This field is provided for the
     * sake of convenience: its contents are equivalent to iterating through the
     * `address_components` to find the types of all the components where the
     * [confirmation_level][google.maps.addressvalidation.v1.AddressComponent.confirmation_level]
     * is not
     * [CONFIRMED][google.maps.addressvalidation.v1.AddressComponent.ConfirmationLevel.CONFIRMED]
     * or the
     * [inferred][google.maps.addressvalidation.v1.AddressComponent.inferred]
     * flag is not set to `true`. The list of possible types can be found
     * [here](https://developers.google.com/maps/documentation/geocoding/requests-geocoding#Types).
     * </pre>
     *
     * <code>repeated string unconfirmed_component_types = 6;</code>
     *
     * @param value The unconfirmedComponentTypes to add.
     * @return This builder for chaining.
     */
    public Builder addUnconfirmedComponentTypes(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureUnconfirmedComponentTypesIsMutable();
      unconfirmedComponentTypes_.add(value);
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The types of the components that are present in the `address_components`
     * but could not be confirmed to be correct. This field is provided for the
     * sake of convenience: its contents are equivalent to iterating through the
     * `address_components` to find the types of all the components where the
     * [confirmation_level][google.maps.addressvalidation.v1.AddressComponent.confirmation_level]
     * is not
     * [CONFIRMED][google.maps.addressvalidation.v1.AddressComponent.ConfirmationLevel.CONFIRMED]
     * or the
     * [inferred][google.maps.addressvalidation.v1.AddressComponent.inferred]
     * flag is not set to `true`. The list of possible types can be found
     * [here](https://developers.google.com/maps/documentation/geocoding/requests-geocoding#Types).
     * </pre>
     *
     * <code>repeated string unconfirmed_component_types = 6;</code>
     *
     * @param values The unconfirmedComponentTypes to add.
     * @return This builder for chaining.
     */
    public Builder addAllUnconfirmedComponentTypes(java.lang.Iterable<java.lang.String> values) {
      ensureUnconfirmedComponentTypesIsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(values, unconfirmedComponentTypes_);
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The types of the components that are present in the `address_components`
     * but could not be confirmed to be correct. This field is provided for the
     * sake of convenience: its contents are equivalent to iterating through the
     * `address_components` to find the types of all the components where the
     * [confirmation_level][google.maps.addressvalidation.v1.AddressComponent.confirmation_level]
     * is not
     * [CONFIRMED][google.maps.addressvalidation.v1.AddressComponent.ConfirmationLevel.CONFIRMED]
     * or the
     * [inferred][google.maps.addressvalidation.v1.AddressComponent.inferred]
     * flag is not set to `true`. The list of possible types can be found
     * [here](https://developers.google.com/maps/documentation/geocoding/requests-geocoding#Types).
     * </pre>
     *
     * <code>repeated string unconfirmed_component_types = 6;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearUnconfirmedComponentTypes() {
      unconfirmedComponentTypes_ = com.google.protobuf.LazyStringArrayList.emptyList();
      bitField0_ = (bitField0_ & ~0x00000010);
      ;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The types of the components that are present in the `address_components`
     * but could not be confirmed to be correct. This field is provided for the
     * sake of convenience: its contents are equivalent to iterating through the
     * `address_components` to find the types of all the components where the
     * [confirmation_level][google.maps.addressvalidation.v1.AddressComponent.confirmation_level]
     * is not
     * [CONFIRMED][google.maps.addressvalidation.v1.AddressComponent.ConfirmationLevel.CONFIRMED]
     * or the
     * [inferred][google.maps.addressvalidation.v1.AddressComponent.inferred]
     * flag is not set to `true`. The list of possible types can be found
     * [here](https://developers.google.com/maps/documentation/geocoding/requests-geocoding#Types).
     * </pre>
     *
     * <code>repeated string unconfirmed_component_types = 6;</code>
     *
     * @param value The bytes of the unconfirmedComponentTypes to add.
     * @return This builder for chaining.
     */
    public Builder addUnconfirmedComponentTypesBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      ensureUnconfirmedComponentTypesIsMutable();
      unconfirmedComponentTypes_.add(value);
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }

    private com.google.protobuf.LazyStringArrayList unresolvedTokens_ =
        com.google.protobuf.LazyStringArrayList.emptyList();

    private void ensureUnresolvedTokensIsMutable() {
      if (!unresolvedTokens_.isModifiable()) {
        unresolvedTokens_ = new com.google.protobuf.LazyStringArrayList(unresolvedTokens_);
      }
      bitField0_ |= 0x00000020;
    }
    /**
     *
     *
     * <pre>
     * Any tokens in the input that could not be resolved. This might be an
     * input that was not recognized as a valid part of an address (for example
     * in an input like "123235253253 Main St, San Francisco, CA, 94105", the
     * unresolved tokens may look like `["123235253253"]` since that does not
     * look like a valid street number.
     * </pre>
     *
     * <code>repeated string unresolved_tokens = 7;</code>
     *
     * @return A list containing the unresolvedTokens.
     */
    public com.google.protobuf.ProtocolStringList getUnresolvedTokensList() {
      unresolvedTokens_.makeImmutable();
      return unresolvedTokens_;
    }
    /**
     *
     *
     * <pre>
     * Any tokens in the input that could not be resolved. This might be an
     * input that was not recognized as a valid part of an address (for example
     * in an input like "123235253253 Main St, San Francisco, CA, 94105", the
     * unresolved tokens may look like `["123235253253"]` since that does not
     * look like a valid street number.
     * </pre>
     *
     * <code>repeated string unresolved_tokens = 7;</code>
     *
     * @return The count of unresolvedTokens.
     */
    public int getUnresolvedTokensCount() {
      return unresolvedTokens_.size();
    }
    /**
     *
     *
     * <pre>
     * Any tokens in the input that could not be resolved. This might be an
     * input that was not recognized as a valid part of an address (for example
     * in an input like "123235253253 Main St, San Francisco, CA, 94105", the
     * unresolved tokens may look like `["123235253253"]` since that does not
     * look like a valid street number.
     * </pre>
     *
     * <code>repeated string unresolved_tokens = 7;</code>
     *
     * @param index The index of the element to return.
     * @return The unresolvedTokens at the given index.
     */
    public java.lang.String getUnresolvedTokens(int index) {
      return unresolvedTokens_.get(index);
    }
    /**
     *
     *
     * <pre>
     * Any tokens in the input that could not be resolved. This might be an
     * input that was not recognized as a valid part of an address (for example
     * in an input like "123235253253 Main St, San Francisco, CA, 94105", the
     * unresolved tokens may look like `["123235253253"]` since that does not
     * look like a valid street number.
     * </pre>
     *
     * <code>repeated string unresolved_tokens = 7;</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the unresolvedTokens at the given index.
     */
    public com.google.protobuf.ByteString getUnresolvedTokensBytes(int index) {
      return unresolvedTokens_.getByteString(index);
    }
    /**
     *
     *
     * <pre>
     * Any tokens in the input that could not be resolved. This might be an
     * input that was not recognized as a valid part of an address (for example
     * in an input like "123235253253 Main St, San Francisco, CA, 94105", the
     * unresolved tokens may look like `["123235253253"]` since that does not
     * look like a valid street number.
     * </pre>
     *
     * <code>repeated string unresolved_tokens = 7;</code>
     *
     * @param index The index to set the value at.
     * @param value The unresolvedTokens to set.
     * @return This builder for chaining.
     */
    public Builder setUnresolvedTokens(int index, java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureUnresolvedTokensIsMutable();
      unresolvedTokens_.set(index, value);
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Any tokens in the input that could not be resolved. This might be an
     * input that was not recognized as a valid part of an address (for example
     * in an input like "123235253253 Main St, San Francisco, CA, 94105", the
     * unresolved tokens may look like `["123235253253"]` since that does not
     * look like a valid street number.
     * </pre>
     *
     * <code>repeated string unresolved_tokens = 7;</code>
     *
     * @param value The unresolvedTokens to add.
     * @return This builder for chaining.
     */
    public Builder addUnresolvedTokens(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureUnresolvedTokensIsMutable();
      unresolvedTokens_.add(value);
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Any tokens in the input that could not be resolved. This might be an
     * input that was not recognized as a valid part of an address (for example
     * in an input like "123235253253 Main St, San Francisco, CA, 94105", the
     * unresolved tokens may look like `["123235253253"]` since that does not
     * look like a valid street number.
     * </pre>
     *
     * <code>repeated string unresolved_tokens = 7;</code>
     *
     * @param values The unresolvedTokens to add.
     * @return This builder for chaining.
     */
    public Builder addAllUnresolvedTokens(java.lang.Iterable<java.lang.String> values) {
      ensureUnresolvedTokensIsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(values, unresolvedTokens_);
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Any tokens in the input that could not be resolved. This might be an
     * input that was not recognized as a valid part of an address (for example
     * in an input like "123235253253 Main St, San Francisco, CA, 94105", the
     * unresolved tokens may look like `["123235253253"]` since that does not
     * look like a valid street number.
     * </pre>
     *
     * <code>repeated string unresolved_tokens = 7;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearUnresolvedTokens() {
      unresolvedTokens_ = com.google.protobuf.LazyStringArrayList.emptyList();
      bitField0_ = (bitField0_ & ~0x00000020);
      ;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Any tokens in the input that could not be resolved. This might be an
     * input that was not recognized as a valid part of an address (for example
     * in an input like "123235253253 Main St, San Francisco, CA, 94105", the
     * unresolved tokens may look like `["123235253253"]` since that does not
     * look like a valid street number.
     * </pre>
     *
     * <code>repeated string unresolved_tokens = 7;</code>
     *
     * @param value The bytes of the unresolvedTokens to add.
     * @return This builder for chaining.
     */
    public Builder addUnresolvedTokensBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      ensureUnresolvedTokensIsMutable();
      unresolvedTokens_.add(value);
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.maps.addressvalidation.v1.Address)
  }

  // @@protoc_insertion_point(class_scope:google.maps.addressvalidation.v1.Address)
  private static final com.google.maps.addressvalidation.v1.Address DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.maps.addressvalidation.v1.Address();
  }

  public static com.google.maps.addressvalidation.v1.Address getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<Address> PARSER =
      new com.google.protobuf.AbstractParser<Address>() {
        @java.lang.Override
        public Address parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<Address> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<Address> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.maps.addressvalidation.v1.Address getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
