/*
 * Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/maps/addressvalidation/v1/geocode.proto

package com.google.maps.addressvalidation.v1;

/**
 *
 *
 * <pre>
 * Contains information about the place the input was geocoded to.
 * </pre>
 *
 * Protobuf type {@code google.maps.addressvalidation.v1.Geocode}
 */
public final class Geocode extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.maps.addressvalidation.v1.Geocode)
    GeocodeOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use Geocode.newBuilder() to construct.
  private Geocode(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private Geocode() {
    placeId_ = "";
    placeTypes_ = com.google.protobuf.LazyStringArrayList.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new Geocode();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.maps.addressvalidation.v1.GeocodeProto
        .internal_static_google_maps_addressvalidation_v1_Geocode_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.maps.addressvalidation.v1.GeocodeProto
        .internal_static_google_maps_addressvalidation_v1_Geocode_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.maps.addressvalidation.v1.Geocode.class,
            com.google.maps.addressvalidation.v1.Geocode.Builder.class);
  }

  public static final int LOCATION_FIELD_NUMBER = 1;
  private com.google.type.LatLng location_;
  /**
   *
   *
   * <pre>
   * The geocoded location of the input.
   *
   * Using place IDs is preferred over using addresses,
   * latitude/longitude coordinates, or plus codes. Using coordinates when
   * routing or calculating driving directions will always result in the point
   * being snapped to the road nearest to those coordinates. This may not be a
   * road that will quickly or safely lead to the destination and may not be
   * near an access point to the property. Additionally, when a location is
   * reverse geocoded, there is no guarantee that the returned address will
   * match the original.
   * </pre>
   *
   * <code>.google.type.LatLng location = 1;</code>
   *
   * @return Whether the location field is set.
   */
  @java.lang.Override
  public boolean hasLocation() {
    return location_ != null;
  }
  /**
   *
   *
   * <pre>
   * The geocoded location of the input.
   *
   * Using place IDs is preferred over using addresses,
   * latitude/longitude coordinates, or plus codes. Using coordinates when
   * routing or calculating driving directions will always result in the point
   * being snapped to the road nearest to those coordinates. This may not be a
   * road that will quickly or safely lead to the destination and may not be
   * near an access point to the property. Additionally, when a location is
   * reverse geocoded, there is no guarantee that the returned address will
   * match the original.
   * </pre>
   *
   * <code>.google.type.LatLng location = 1;</code>
   *
   * @return The location.
   */
  @java.lang.Override
  public com.google.type.LatLng getLocation() {
    return location_ == null ? com.google.type.LatLng.getDefaultInstance() : location_;
  }
  /**
   *
   *
   * <pre>
   * The geocoded location of the input.
   *
   * Using place IDs is preferred over using addresses,
   * latitude/longitude coordinates, or plus codes. Using coordinates when
   * routing or calculating driving directions will always result in the point
   * being snapped to the road nearest to those coordinates. This may not be a
   * road that will quickly or safely lead to the destination and may not be
   * near an access point to the property. Additionally, when a location is
   * reverse geocoded, there is no guarantee that the returned address will
   * match the original.
   * </pre>
   *
   * <code>.google.type.LatLng location = 1;</code>
   */
  @java.lang.Override
  public com.google.type.LatLngOrBuilder getLocationOrBuilder() {
    return location_ == null ? com.google.type.LatLng.getDefaultInstance() : location_;
  }

  public static final int PLUS_CODE_FIELD_NUMBER = 2;
  private com.google.maps.addressvalidation.v1.PlusCode plusCode_;
  /**
   *
   *
   * <pre>
   * The plus code corresponding to the `location`.
   * </pre>
   *
   * <code>.google.maps.addressvalidation.v1.PlusCode plus_code = 2;</code>
   *
   * @return Whether the plusCode field is set.
   */
  @java.lang.Override
  public boolean hasPlusCode() {
    return plusCode_ != null;
  }
  /**
   *
   *
   * <pre>
   * The plus code corresponding to the `location`.
   * </pre>
   *
   * <code>.google.maps.addressvalidation.v1.PlusCode plus_code = 2;</code>
   *
   * @return The plusCode.
   */
  @java.lang.Override
  public com.google.maps.addressvalidation.v1.PlusCode getPlusCode() {
    return plusCode_ == null
        ? com.google.maps.addressvalidation.v1.PlusCode.getDefaultInstance()
        : plusCode_;
  }
  /**
   *
   *
   * <pre>
   * The plus code corresponding to the `location`.
   * </pre>
   *
   * <code>.google.maps.addressvalidation.v1.PlusCode plus_code = 2;</code>
   */
  @java.lang.Override
  public com.google.maps.addressvalidation.v1.PlusCodeOrBuilder getPlusCodeOrBuilder() {
    return plusCode_ == null
        ? com.google.maps.addressvalidation.v1.PlusCode.getDefaultInstance()
        : plusCode_;
  }

  public static final int BOUNDS_FIELD_NUMBER = 4;
  private com.google.geo.type.Viewport bounds_;
  /**
   *
   *
   * <pre>
   * The bounds of the geocoded place.
   * </pre>
   *
   * <code>.google.geo.type.Viewport bounds = 4;</code>
   *
   * @return Whether the bounds field is set.
   */
  @java.lang.Override
  public boolean hasBounds() {
    return bounds_ != null;
  }
  /**
   *
   *
   * <pre>
   * The bounds of the geocoded place.
   * </pre>
   *
   * <code>.google.geo.type.Viewport bounds = 4;</code>
   *
   * @return The bounds.
   */
  @java.lang.Override
  public com.google.geo.type.Viewport getBounds() {
    return bounds_ == null ? com.google.geo.type.Viewport.getDefaultInstance() : bounds_;
  }
  /**
   *
   *
   * <pre>
   * The bounds of the geocoded place.
   * </pre>
   *
   * <code>.google.geo.type.Viewport bounds = 4;</code>
   */
  @java.lang.Override
  public com.google.geo.type.ViewportOrBuilder getBoundsOrBuilder() {
    return bounds_ == null ? com.google.geo.type.Viewport.getDefaultInstance() : bounds_;
  }

  public static final int FEATURE_SIZE_METERS_FIELD_NUMBER = 5;
  private float featureSizeMeters_ = 0F;
  /**
   *
   *
   * <pre>
   * The size of the geocoded place, in meters. This is another measure of the
   * coarseness of the geocoded location, but in physical size rather than in
   * semantic meaning.
   * </pre>
   *
   * <code>float feature_size_meters = 5;</code>
   *
   * @return The featureSizeMeters.
   */
  @java.lang.Override
  public float getFeatureSizeMeters() {
    return featureSizeMeters_;
  }

  public static final int PLACE_ID_FIELD_NUMBER = 6;

  @SuppressWarnings("serial")
  private volatile java.lang.Object placeId_ = "";
  /**
   *
   *
   * <pre>
   * The PlaceID of the place this input geocodes to.
   *
   * For more information about Place IDs see
   * [here](https://developers.google.com/maps/documentation/places/web-service/place-id).
   * </pre>
   *
   * <code>string place_id = 6;</code>
   *
   * @return The placeId.
   */
  @java.lang.Override
  public java.lang.String getPlaceId() {
    java.lang.Object ref = placeId_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      placeId_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The PlaceID of the place this input geocodes to.
   *
   * For more information about Place IDs see
   * [here](https://developers.google.com/maps/documentation/places/web-service/place-id).
   * </pre>
   *
   * <code>string place_id = 6;</code>
   *
   * @return The bytes for placeId.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getPlaceIdBytes() {
    java.lang.Object ref = placeId_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      placeId_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int PLACE_TYPES_FIELD_NUMBER = 7;

  @SuppressWarnings("serial")
  private com.google.protobuf.LazyStringArrayList placeTypes_ =
      com.google.protobuf.LazyStringArrayList.emptyList();
  /**
   *
   *
   * <pre>
   * The type(s) of place that the input geocoded to. For example,
   * `['locality', 'political']`. The full list of types can be found
   * [here](https://developers.google.com/maps/documentation/geocoding/requests-geocoding#Types).
   * </pre>
   *
   * <code>repeated string place_types = 7;</code>
   *
   * @return A list containing the placeTypes.
   */
  public com.google.protobuf.ProtocolStringList getPlaceTypesList() {
    return placeTypes_;
  }
  /**
   *
   *
   * <pre>
   * The type(s) of place that the input geocoded to. For example,
   * `['locality', 'political']`. The full list of types can be found
   * [here](https://developers.google.com/maps/documentation/geocoding/requests-geocoding#Types).
   * </pre>
   *
   * <code>repeated string place_types = 7;</code>
   *
   * @return The count of placeTypes.
   */
  public int getPlaceTypesCount() {
    return placeTypes_.size();
  }
  /**
   *
   *
   * <pre>
   * The type(s) of place that the input geocoded to. For example,
   * `['locality', 'political']`. The full list of types can be found
   * [here](https://developers.google.com/maps/documentation/geocoding/requests-geocoding#Types).
   * </pre>
   *
   * <code>repeated string place_types = 7;</code>
   *
   * @param index The index of the element to return.
   * @return The placeTypes at the given index.
   */
  public java.lang.String getPlaceTypes(int index) {
    return placeTypes_.get(index);
  }
  /**
   *
   *
   * <pre>
   * The type(s) of place that the input geocoded to. For example,
   * `['locality', 'political']`. The full list of types can be found
   * [here](https://developers.google.com/maps/documentation/geocoding/requests-geocoding#Types).
   * </pre>
   *
   * <code>repeated string place_types = 7;</code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the placeTypes at the given index.
   */
  public com.google.protobuf.ByteString getPlaceTypesBytes(int index) {
    return placeTypes_.getByteString(index);
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (location_ != null) {
      output.writeMessage(1, getLocation());
    }
    if (plusCode_ != null) {
      output.writeMessage(2, getPlusCode());
    }
    if (bounds_ != null) {
      output.writeMessage(4, getBounds());
    }
    if (java.lang.Float.floatToRawIntBits(featureSizeMeters_) != 0) {
      output.writeFloat(5, featureSizeMeters_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(placeId_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 6, placeId_);
    }
    for (int i = 0; i < placeTypes_.size(); i++) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 7, placeTypes_.getRaw(i));
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (location_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, getLocation());
    }
    if (plusCode_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, getPlusCode());
    }
    if (bounds_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(4, getBounds());
    }
    if (java.lang.Float.floatToRawIntBits(featureSizeMeters_) != 0) {
      size += com.google.protobuf.CodedOutputStream.computeFloatSize(5, featureSizeMeters_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(placeId_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(6, placeId_);
    }
    {
      int dataSize = 0;
      for (int i = 0; i < placeTypes_.size(); i++) {
        dataSize += computeStringSizeNoTag(placeTypes_.getRaw(i));
      }
      size += dataSize;
      size += 1 * getPlaceTypesList().size();
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.maps.addressvalidation.v1.Geocode)) {
      return super.equals(obj);
    }
    com.google.maps.addressvalidation.v1.Geocode other =
        (com.google.maps.addressvalidation.v1.Geocode) obj;

    if (hasLocation() != other.hasLocation()) return false;
    if (hasLocation()) {
      if (!getLocation().equals(other.getLocation())) return false;
    }
    if (hasPlusCode() != other.hasPlusCode()) return false;
    if (hasPlusCode()) {
      if (!getPlusCode().equals(other.getPlusCode())) return false;
    }
    if (hasBounds() != other.hasBounds()) return false;
    if (hasBounds()) {
      if (!getBounds().equals(other.getBounds())) return false;
    }
    if (java.lang.Float.floatToIntBits(getFeatureSizeMeters())
        != java.lang.Float.floatToIntBits(other.getFeatureSizeMeters())) return false;
    if (!getPlaceId().equals(other.getPlaceId())) return false;
    if (!getPlaceTypesList().equals(other.getPlaceTypesList())) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (hasLocation()) {
      hash = (37 * hash) + LOCATION_FIELD_NUMBER;
      hash = (53 * hash) + getLocation().hashCode();
    }
    if (hasPlusCode()) {
      hash = (37 * hash) + PLUS_CODE_FIELD_NUMBER;
      hash = (53 * hash) + getPlusCode().hashCode();
    }
    if (hasBounds()) {
      hash = (37 * hash) + BOUNDS_FIELD_NUMBER;
      hash = (53 * hash) + getBounds().hashCode();
    }
    hash = (37 * hash) + FEATURE_SIZE_METERS_FIELD_NUMBER;
    hash = (53 * hash) + java.lang.Float.floatToIntBits(getFeatureSizeMeters());
    hash = (37 * hash) + PLACE_ID_FIELD_NUMBER;
    hash = (53 * hash) + getPlaceId().hashCode();
    if (getPlaceTypesCount() > 0) {
      hash = (37 * hash) + PLACE_TYPES_FIELD_NUMBER;
      hash = (53 * hash) + getPlaceTypesList().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.maps.addressvalidation.v1.Geocode parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.maps.addressvalidation.v1.Geocode parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.maps.addressvalidation.v1.Geocode parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.maps.addressvalidation.v1.Geocode parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.maps.addressvalidation.v1.Geocode parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.maps.addressvalidation.v1.Geocode parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.maps.addressvalidation.v1.Geocode parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.maps.addressvalidation.v1.Geocode parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.maps.addressvalidation.v1.Geocode parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.maps.addressvalidation.v1.Geocode parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.maps.addressvalidation.v1.Geocode parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.maps.addressvalidation.v1.Geocode parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.maps.addressvalidation.v1.Geocode prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Contains information about the place the input was geocoded to.
   * </pre>
   *
   * Protobuf type {@code google.maps.addressvalidation.v1.Geocode}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.maps.addressvalidation.v1.Geocode)
      com.google.maps.addressvalidation.v1.GeocodeOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.maps.addressvalidation.v1.GeocodeProto
          .internal_static_google_maps_addressvalidation_v1_Geocode_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.maps.addressvalidation.v1.GeocodeProto
          .internal_static_google_maps_addressvalidation_v1_Geocode_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.maps.addressvalidation.v1.Geocode.class,
              com.google.maps.addressvalidation.v1.Geocode.Builder.class);
    }

    // Construct using com.google.maps.addressvalidation.v1.Geocode.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      location_ = null;
      if (locationBuilder_ != null) {
        locationBuilder_.dispose();
        locationBuilder_ = null;
      }
      plusCode_ = null;
      if (plusCodeBuilder_ != null) {
        plusCodeBuilder_.dispose();
        plusCodeBuilder_ = null;
      }
      bounds_ = null;
      if (boundsBuilder_ != null) {
        boundsBuilder_.dispose();
        boundsBuilder_ = null;
      }
      featureSizeMeters_ = 0F;
      placeId_ = "";
      placeTypes_ = com.google.protobuf.LazyStringArrayList.emptyList();
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.maps.addressvalidation.v1.GeocodeProto
          .internal_static_google_maps_addressvalidation_v1_Geocode_descriptor;
    }

    @java.lang.Override
    public com.google.maps.addressvalidation.v1.Geocode getDefaultInstanceForType() {
      return com.google.maps.addressvalidation.v1.Geocode.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.maps.addressvalidation.v1.Geocode build() {
      com.google.maps.addressvalidation.v1.Geocode result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.maps.addressvalidation.v1.Geocode buildPartial() {
      com.google.maps.addressvalidation.v1.Geocode result =
          new com.google.maps.addressvalidation.v1.Geocode(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.maps.addressvalidation.v1.Geocode result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.location_ = locationBuilder_ == null ? location_ : locationBuilder_.build();
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.plusCode_ = plusCodeBuilder_ == null ? plusCode_ : plusCodeBuilder_.build();
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.bounds_ = boundsBuilder_ == null ? bounds_ : boundsBuilder_.build();
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.featureSizeMeters_ = featureSizeMeters_;
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.placeId_ = placeId_;
      }
      if (((from_bitField0_ & 0x00000020) != 0)) {
        placeTypes_.makeImmutable();
        result.placeTypes_ = placeTypes_;
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.maps.addressvalidation.v1.Geocode) {
        return mergeFrom((com.google.maps.addressvalidation.v1.Geocode) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.maps.addressvalidation.v1.Geocode other) {
      if (other == com.google.maps.addressvalidation.v1.Geocode.getDefaultInstance()) return this;
      if (other.hasLocation()) {
        mergeLocation(other.getLocation());
      }
      if (other.hasPlusCode()) {
        mergePlusCode(other.getPlusCode());
      }
      if (other.hasBounds()) {
        mergeBounds(other.getBounds());
      }
      if (other.getFeatureSizeMeters() != 0F) {
        setFeatureSizeMeters(other.getFeatureSizeMeters());
      }
      if (!other.getPlaceId().isEmpty()) {
        placeId_ = other.placeId_;
        bitField0_ |= 0x00000010;
        onChanged();
      }
      if (!other.placeTypes_.isEmpty()) {
        if (placeTypes_.isEmpty()) {
          placeTypes_ = other.placeTypes_;
          bitField0_ |= 0x00000020;
        } else {
          ensurePlaceTypesIsMutable();
          placeTypes_.addAll(other.placeTypes_);
        }
        onChanged();
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                input.readMessage(getLocationFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                input.readMessage(getPlusCodeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            case 34:
              {
                input.readMessage(getBoundsFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000004;
                break;
              } // case 34
            case 45:
              {
                featureSizeMeters_ = input.readFloat();
                bitField0_ |= 0x00000008;
                break;
              } // case 45
            case 50:
              {
                placeId_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000010;
                break;
              } // case 50
            case 58:
              {
                java.lang.String s = input.readStringRequireUtf8();
                ensurePlaceTypesIsMutable();
                placeTypes_.add(s);
                break;
              } // case 58
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private com.google.type.LatLng location_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.type.LatLng, com.google.type.LatLng.Builder, com.google.type.LatLngOrBuilder>
        locationBuilder_;
    /**
     *
     *
     * <pre>
     * The geocoded location of the input.
     *
     * Using place IDs is preferred over using addresses,
     * latitude/longitude coordinates, or plus codes. Using coordinates when
     * routing or calculating driving directions will always result in the point
     * being snapped to the road nearest to those coordinates. This may not be a
     * road that will quickly or safely lead to the destination and may not be
     * near an access point to the property. Additionally, when a location is
     * reverse geocoded, there is no guarantee that the returned address will
     * match the original.
     * </pre>
     *
     * <code>.google.type.LatLng location = 1;</code>
     *
     * @return Whether the location field is set.
     */
    public boolean hasLocation() {
      return ((bitField0_ & 0x00000001) != 0);
    }
    /**
     *
     *
     * <pre>
     * The geocoded location of the input.
     *
     * Using place IDs is preferred over using addresses,
     * latitude/longitude coordinates, or plus codes. Using coordinates when
     * routing or calculating driving directions will always result in the point
     * being snapped to the road nearest to those coordinates. This may not be a
     * road that will quickly or safely lead to the destination and may not be
     * near an access point to the property. Additionally, when a location is
     * reverse geocoded, there is no guarantee that the returned address will
     * match the original.
     * </pre>
     *
     * <code>.google.type.LatLng location = 1;</code>
     *
     * @return The location.
     */
    public com.google.type.LatLng getLocation() {
      if (locationBuilder_ == null) {
        return location_ == null ? com.google.type.LatLng.getDefaultInstance() : location_;
      } else {
        return locationBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * The geocoded location of the input.
     *
     * Using place IDs is preferred over using addresses,
     * latitude/longitude coordinates, or plus codes. Using coordinates when
     * routing or calculating driving directions will always result in the point
     * being snapped to the road nearest to those coordinates. This may not be a
     * road that will quickly or safely lead to the destination and may not be
     * near an access point to the property. Additionally, when a location is
     * reverse geocoded, there is no guarantee that the returned address will
     * match the original.
     * </pre>
     *
     * <code>.google.type.LatLng location = 1;</code>
     */
    public Builder setLocation(com.google.type.LatLng value) {
      if (locationBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        location_ = value;
      } else {
        locationBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The geocoded location of the input.
     *
     * Using place IDs is preferred over using addresses,
     * latitude/longitude coordinates, or plus codes. Using coordinates when
     * routing or calculating driving directions will always result in the point
     * being snapped to the road nearest to those coordinates. This may not be a
     * road that will quickly or safely lead to the destination and may not be
     * near an access point to the property. Additionally, when a location is
     * reverse geocoded, there is no guarantee that the returned address will
     * match the original.
     * </pre>
     *
     * <code>.google.type.LatLng location = 1;</code>
     */
    public Builder setLocation(com.google.type.LatLng.Builder builderForValue) {
      if (locationBuilder_ == null) {
        location_ = builderForValue.build();
      } else {
        locationBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The geocoded location of the input.
     *
     * Using place IDs is preferred over using addresses,
     * latitude/longitude coordinates, or plus codes. Using coordinates when
     * routing or calculating driving directions will always result in the point
     * being snapped to the road nearest to those coordinates. This may not be a
     * road that will quickly or safely lead to the destination and may not be
     * near an access point to the property. Additionally, when a location is
     * reverse geocoded, there is no guarantee that the returned address will
     * match the original.
     * </pre>
     *
     * <code>.google.type.LatLng location = 1;</code>
     */
    public Builder mergeLocation(com.google.type.LatLng value) {
      if (locationBuilder_ == null) {
        if (((bitField0_ & 0x00000001) != 0)
            && location_ != null
            && location_ != com.google.type.LatLng.getDefaultInstance()) {
          getLocationBuilder().mergeFrom(value);
        } else {
          location_ = value;
        }
      } else {
        locationBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The geocoded location of the input.
     *
     * Using place IDs is preferred over using addresses,
     * latitude/longitude coordinates, or plus codes. Using coordinates when
     * routing or calculating driving directions will always result in the point
     * being snapped to the road nearest to those coordinates. This may not be a
     * road that will quickly or safely lead to the destination and may not be
     * near an access point to the property. Additionally, when a location is
     * reverse geocoded, there is no guarantee that the returned address will
     * match the original.
     * </pre>
     *
     * <code>.google.type.LatLng location = 1;</code>
     */
    public Builder clearLocation() {
      bitField0_ = (bitField0_ & ~0x00000001);
      location_ = null;
      if (locationBuilder_ != null) {
        locationBuilder_.dispose();
        locationBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The geocoded location of the input.
     *
     * Using place IDs is preferred over using addresses,
     * latitude/longitude coordinates, or plus codes. Using coordinates when
     * routing or calculating driving directions will always result in the point
     * being snapped to the road nearest to those coordinates. This may not be a
     * road that will quickly or safely lead to the destination and may not be
     * near an access point to the property. Additionally, when a location is
     * reverse geocoded, there is no guarantee that the returned address will
     * match the original.
     * </pre>
     *
     * <code>.google.type.LatLng location = 1;</code>
     */
    public com.google.type.LatLng.Builder getLocationBuilder() {
      bitField0_ |= 0x00000001;
      onChanged();
      return getLocationFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The geocoded location of the input.
     *
     * Using place IDs is preferred over using addresses,
     * latitude/longitude coordinates, or plus codes. Using coordinates when
     * routing or calculating driving directions will always result in the point
     * being snapped to the road nearest to those coordinates. This may not be a
     * road that will quickly or safely lead to the destination and may not be
     * near an access point to the property. Additionally, when a location is
     * reverse geocoded, there is no guarantee that the returned address will
     * match the original.
     * </pre>
     *
     * <code>.google.type.LatLng location = 1;</code>
     */
    public com.google.type.LatLngOrBuilder getLocationOrBuilder() {
      if (locationBuilder_ != null) {
        return locationBuilder_.getMessageOrBuilder();
      } else {
        return location_ == null ? com.google.type.LatLng.getDefaultInstance() : location_;
      }
    }
    /**
     *
     *
     * <pre>
     * The geocoded location of the input.
     *
     * Using place IDs is preferred over using addresses,
     * latitude/longitude coordinates, or plus codes. Using coordinates when
     * routing or calculating driving directions will always result in the point
     * being snapped to the road nearest to those coordinates. This may not be a
     * road that will quickly or safely lead to the destination and may not be
     * near an access point to the property. Additionally, when a location is
     * reverse geocoded, there is no guarantee that the returned address will
     * match the original.
     * </pre>
     *
     * <code>.google.type.LatLng location = 1;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.type.LatLng, com.google.type.LatLng.Builder, com.google.type.LatLngOrBuilder>
        getLocationFieldBuilder() {
      if (locationBuilder_ == null) {
        locationBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.type.LatLng,
                com.google.type.LatLng.Builder,
                com.google.type.LatLngOrBuilder>(getLocation(), getParentForChildren(), isClean());
        location_ = null;
      }
      return locationBuilder_;
    }

    private com.google.maps.addressvalidation.v1.PlusCode plusCode_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.maps.addressvalidation.v1.PlusCode,
            com.google.maps.addressvalidation.v1.PlusCode.Builder,
            com.google.maps.addressvalidation.v1.PlusCodeOrBuilder>
        plusCodeBuilder_;
    /**
     *
     *
     * <pre>
     * The plus code corresponding to the `location`.
     * </pre>
     *
     * <code>.google.maps.addressvalidation.v1.PlusCode plus_code = 2;</code>
     *
     * @return Whether the plusCode field is set.
     */
    public boolean hasPlusCode() {
      return ((bitField0_ & 0x00000002) != 0);
    }
    /**
     *
     *
     * <pre>
     * The plus code corresponding to the `location`.
     * </pre>
     *
     * <code>.google.maps.addressvalidation.v1.PlusCode plus_code = 2;</code>
     *
     * @return The plusCode.
     */
    public com.google.maps.addressvalidation.v1.PlusCode getPlusCode() {
      if (plusCodeBuilder_ == null) {
        return plusCode_ == null
            ? com.google.maps.addressvalidation.v1.PlusCode.getDefaultInstance()
            : plusCode_;
      } else {
        return plusCodeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * The plus code corresponding to the `location`.
     * </pre>
     *
     * <code>.google.maps.addressvalidation.v1.PlusCode plus_code = 2;</code>
     */
    public Builder setPlusCode(com.google.maps.addressvalidation.v1.PlusCode value) {
      if (plusCodeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        plusCode_ = value;
      } else {
        plusCodeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The plus code corresponding to the `location`.
     * </pre>
     *
     * <code>.google.maps.addressvalidation.v1.PlusCode plus_code = 2;</code>
     */
    public Builder setPlusCode(
        com.google.maps.addressvalidation.v1.PlusCode.Builder builderForValue) {
      if (plusCodeBuilder_ == null) {
        plusCode_ = builderForValue.build();
      } else {
        plusCodeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The plus code corresponding to the `location`.
     * </pre>
     *
     * <code>.google.maps.addressvalidation.v1.PlusCode plus_code = 2;</code>
     */
    public Builder mergePlusCode(com.google.maps.addressvalidation.v1.PlusCode value) {
      if (plusCodeBuilder_ == null) {
        if (((bitField0_ & 0x00000002) != 0)
            && plusCode_ != null
            && plusCode_ != com.google.maps.addressvalidation.v1.PlusCode.getDefaultInstance()) {
          getPlusCodeBuilder().mergeFrom(value);
        } else {
          plusCode_ = value;
        }
      } else {
        plusCodeBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The plus code corresponding to the `location`.
     * </pre>
     *
     * <code>.google.maps.addressvalidation.v1.PlusCode plus_code = 2;</code>
     */
    public Builder clearPlusCode() {
      bitField0_ = (bitField0_ & ~0x00000002);
      plusCode_ = null;
      if (plusCodeBuilder_ != null) {
        plusCodeBuilder_.dispose();
        plusCodeBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The plus code corresponding to the `location`.
     * </pre>
     *
     * <code>.google.maps.addressvalidation.v1.PlusCode plus_code = 2;</code>
     */
    public com.google.maps.addressvalidation.v1.PlusCode.Builder getPlusCodeBuilder() {
      bitField0_ |= 0x00000002;
      onChanged();
      return getPlusCodeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The plus code corresponding to the `location`.
     * </pre>
     *
     * <code>.google.maps.addressvalidation.v1.PlusCode plus_code = 2;</code>
     */
    public com.google.maps.addressvalidation.v1.PlusCodeOrBuilder getPlusCodeOrBuilder() {
      if (plusCodeBuilder_ != null) {
        return plusCodeBuilder_.getMessageOrBuilder();
      } else {
        return plusCode_ == null
            ? com.google.maps.addressvalidation.v1.PlusCode.getDefaultInstance()
            : plusCode_;
      }
    }
    /**
     *
     *
     * <pre>
     * The plus code corresponding to the `location`.
     * </pre>
     *
     * <code>.google.maps.addressvalidation.v1.PlusCode plus_code = 2;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.maps.addressvalidation.v1.PlusCode,
            com.google.maps.addressvalidation.v1.PlusCode.Builder,
            com.google.maps.addressvalidation.v1.PlusCodeOrBuilder>
        getPlusCodeFieldBuilder() {
      if (plusCodeBuilder_ == null) {
        plusCodeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.maps.addressvalidation.v1.PlusCode,
                com.google.maps.addressvalidation.v1.PlusCode.Builder,
                com.google.maps.addressvalidation.v1.PlusCodeOrBuilder>(
                getPlusCode(), getParentForChildren(), isClean());
        plusCode_ = null;
      }
      return plusCodeBuilder_;
    }

    private com.google.geo.type.Viewport bounds_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.geo.type.Viewport,
            com.google.geo.type.Viewport.Builder,
            com.google.geo.type.ViewportOrBuilder>
        boundsBuilder_;
    /**
     *
     *
     * <pre>
     * The bounds of the geocoded place.
     * </pre>
     *
     * <code>.google.geo.type.Viewport bounds = 4;</code>
     *
     * @return Whether the bounds field is set.
     */
    public boolean hasBounds() {
      return ((bitField0_ & 0x00000004) != 0);
    }
    /**
     *
     *
     * <pre>
     * The bounds of the geocoded place.
     * </pre>
     *
     * <code>.google.geo.type.Viewport bounds = 4;</code>
     *
     * @return The bounds.
     */
    public com.google.geo.type.Viewport getBounds() {
      if (boundsBuilder_ == null) {
        return bounds_ == null ? com.google.geo.type.Viewport.getDefaultInstance() : bounds_;
      } else {
        return boundsBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * The bounds of the geocoded place.
     * </pre>
     *
     * <code>.google.geo.type.Viewport bounds = 4;</code>
     */
    public Builder setBounds(com.google.geo.type.Viewport value) {
      if (boundsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        bounds_ = value;
      } else {
        boundsBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The bounds of the geocoded place.
     * </pre>
     *
     * <code>.google.geo.type.Viewport bounds = 4;</code>
     */
    public Builder setBounds(com.google.geo.type.Viewport.Builder builderForValue) {
      if (boundsBuilder_ == null) {
        bounds_ = builderForValue.build();
      } else {
        boundsBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The bounds of the geocoded place.
     * </pre>
     *
     * <code>.google.geo.type.Viewport bounds = 4;</code>
     */
    public Builder mergeBounds(com.google.geo.type.Viewport value) {
      if (boundsBuilder_ == null) {
        if (((bitField0_ & 0x00000004) != 0)
            && bounds_ != null
            && bounds_ != com.google.geo.type.Viewport.getDefaultInstance()) {
          getBoundsBuilder().mergeFrom(value);
        } else {
          bounds_ = value;
        }
      } else {
        boundsBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The bounds of the geocoded place.
     * </pre>
     *
     * <code>.google.geo.type.Viewport bounds = 4;</code>
     */
    public Builder clearBounds() {
      bitField0_ = (bitField0_ & ~0x00000004);
      bounds_ = null;
      if (boundsBuilder_ != null) {
        boundsBuilder_.dispose();
        boundsBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The bounds of the geocoded place.
     * </pre>
     *
     * <code>.google.geo.type.Viewport bounds = 4;</code>
     */
    public com.google.geo.type.Viewport.Builder getBoundsBuilder() {
      bitField0_ |= 0x00000004;
      onChanged();
      return getBoundsFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The bounds of the geocoded place.
     * </pre>
     *
     * <code>.google.geo.type.Viewport bounds = 4;</code>
     */
    public com.google.geo.type.ViewportOrBuilder getBoundsOrBuilder() {
      if (boundsBuilder_ != null) {
        return boundsBuilder_.getMessageOrBuilder();
      } else {
        return bounds_ == null ? com.google.geo.type.Viewport.getDefaultInstance() : bounds_;
      }
    }
    /**
     *
     *
     * <pre>
     * The bounds of the geocoded place.
     * </pre>
     *
     * <code>.google.geo.type.Viewport bounds = 4;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.geo.type.Viewport,
            com.google.geo.type.Viewport.Builder,
            com.google.geo.type.ViewportOrBuilder>
        getBoundsFieldBuilder() {
      if (boundsBuilder_ == null) {
        boundsBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.geo.type.Viewport,
                com.google.geo.type.Viewport.Builder,
                com.google.geo.type.ViewportOrBuilder>(
                getBounds(), getParentForChildren(), isClean());
        bounds_ = null;
      }
      return boundsBuilder_;
    }

    private float featureSizeMeters_;
    /**
     *
     *
     * <pre>
     * The size of the geocoded place, in meters. This is another measure of the
     * coarseness of the geocoded location, but in physical size rather than in
     * semantic meaning.
     * </pre>
     *
     * <code>float feature_size_meters = 5;</code>
     *
     * @return The featureSizeMeters.
     */
    @java.lang.Override
    public float getFeatureSizeMeters() {
      return featureSizeMeters_;
    }
    /**
     *
     *
     * <pre>
     * The size of the geocoded place, in meters. This is another measure of the
     * coarseness of the geocoded location, but in physical size rather than in
     * semantic meaning.
     * </pre>
     *
     * <code>float feature_size_meters = 5;</code>
     *
     * @param value The featureSizeMeters to set.
     * @return This builder for chaining.
     */
    public Builder setFeatureSizeMeters(float value) {

      featureSizeMeters_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The size of the geocoded place, in meters. This is another measure of the
     * coarseness of the geocoded location, but in physical size rather than in
     * semantic meaning.
     * </pre>
     *
     * <code>float feature_size_meters = 5;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearFeatureSizeMeters() {
      bitField0_ = (bitField0_ & ~0x00000008);
      featureSizeMeters_ = 0F;
      onChanged();
      return this;
    }

    private java.lang.Object placeId_ = "";
    /**
     *
     *
     * <pre>
     * The PlaceID of the place this input geocodes to.
     *
     * For more information about Place IDs see
     * [here](https://developers.google.com/maps/documentation/places/web-service/place-id).
     * </pre>
     *
     * <code>string place_id = 6;</code>
     *
     * @return The placeId.
     */
    public java.lang.String getPlaceId() {
      java.lang.Object ref = placeId_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        placeId_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The PlaceID of the place this input geocodes to.
     *
     * For more information about Place IDs see
     * [here](https://developers.google.com/maps/documentation/places/web-service/place-id).
     * </pre>
     *
     * <code>string place_id = 6;</code>
     *
     * @return The bytes for placeId.
     */
    public com.google.protobuf.ByteString getPlaceIdBytes() {
      java.lang.Object ref = placeId_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        placeId_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The PlaceID of the place this input geocodes to.
     *
     * For more information about Place IDs see
     * [here](https://developers.google.com/maps/documentation/places/web-service/place-id).
     * </pre>
     *
     * <code>string place_id = 6;</code>
     *
     * @param value The placeId to set.
     * @return This builder for chaining.
     */
    public Builder setPlaceId(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      placeId_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The PlaceID of the place this input geocodes to.
     *
     * For more information about Place IDs see
     * [here](https://developers.google.com/maps/documentation/places/web-service/place-id).
     * </pre>
     *
     * <code>string place_id = 6;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearPlaceId() {
      placeId_ = getDefaultInstance().getPlaceId();
      bitField0_ = (bitField0_ & ~0x00000010);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The PlaceID of the place this input geocodes to.
     *
     * For more information about Place IDs see
     * [here](https://developers.google.com/maps/documentation/places/web-service/place-id).
     * </pre>
     *
     * <code>string place_id = 6;</code>
     *
     * @param value The bytes for placeId to set.
     * @return This builder for chaining.
     */
    public Builder setPlaceIdBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      placeId_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }

    private com.google.protobuf.LazyStringArrayList placeTypes_ =
        com.google.protobuf.LazyStringArrayList.emptyList();

    private void ensurePlaceTypesIsMutable() {
      if (!placeTypes_.isModifiable()) {
        placeTypes_ = new com.google.protobuf.LazyStringArrayList(placeTypes_);
      }
      bitField0_ |= 0x00000020;
    }
    /**
     *
     *
     * <pre>
     * The type(s) of place that the input geocoded to. For example,
     * `['locality', 'political']`. The full list of types can be found
     * [here](https://developers.google.com/maps/documentation/geocoding/requests-geocoding#Types).
     * </pre>
     *
     * <code>repeated string place_types = 7;</code>
     *
     * @return A list containing the placeTypes.
     */
    public com.google.protobuf.ProtocolStringList getPlaceTypesList() {
      placeTypes_.makeImmutable();
      return placeTypes_;
    }
    /**
     *
     *
     * <pre>
     * The type(s) of place that the input geocoded to. For example,
     * `['locality', 'political']`. The full list of types can be found
     * [here](https://developers.google.com/maps/documentation/geocoding/requests-geocoding#Types).
     * </pre>
     *
     * <code>repeated string place_types = 7;</code>
     *
     * @return The count of placeTypes.
     */
    public int getPlaceTypesCount() {
      return placeTypes_.size();
    }
    /**
     *
     *
     * <pre>
     * The type(s) of place that the input geocoded to. For example,
     * `['locality', 'political']`. The full list of types can be found
     * [here](https://developers.google.com/maps/documentation/geocoding/requests-geocoding#Types).
     * </pre>
     *
     * <code>repeated string place_types = 7;</code>
     *
     * @param index The index of the element to return.
     * @return The placeTypes at the given index.
     */
    public java.lang.String getPlaceTypes(int index) {
      return placeTypes_.get(index);
    }
    /**
     *
     *
     * <pre>
     * The type(s) of place that the input geocoded to. For example,
     * `['locality', 'political']`. The full list of types can be found
     * [here](https://developers.google.com/maps/documentation/geocoding/requests-geocoding#Types).
     * </pre>
     *
     * <code>repeated string place_types = 7;</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the placeTypes at the given index.
     */
    public com.google.protobuf.ByteString getPlaceTypesBytes(int index) {
      return placeTypes_.getByteString(index);
    }
    /**
     *
     *
     * <pre>
     * The type(s) of place that the input geocoded to. For example,
     * `['locality', 'political']`. The full list of types can be found
     * [here](https://developers.google.com/maps/documentation/geocoding/requests-geocoding#Types).
     * </pre>
     *
     * <code>repeated string place_types = 7;</code>
     *
     * @param index The index to set the value at.
     * @param value The placeTypes to set.
     * @return This builder for chaining.
     */
    public Builder setPlaceTypes(int index, java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensurePlaceTypesIsMutable();
      placeTypes_.set(index, value);
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The type(s) of place that the input geocoded to. For example,
     * `['locality', 'political']`. The full list of types can be found
     * [here](https://developers.google.com/maps/documentation/geocoding/requests-geocoding#Types).
     * </pre>
     *
     * <code>repeated string place_types = 7;</code>
     *
     * @param value The placeTypes to add.
     * @return This builder for chaining.
     */
    public Builder addPlaceTypes(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensurePlaceTypesIsMutable();
      placeTypes_.add(value);
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The type(s) of place that the input geocoded to. For example,
     * `['locality', 'political']`. The full list of types can be found
     * [here](https://developers.google.com/maps/documentation/geocoding/requests-geocoding#Types).
     * </pre>
     *
     * <code>repeated string place_types = 7;</code>
     *
     * @param values The placeTypes to add.
     * @return This builder for chaining.
     */
    public Builder addAllPlaceTypes(java.lang.Iterable<java.lang.String> values) {
      ensurePlaceTypesIsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(values, placeTypes_);
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The type(s) of place that the input geocoded to. For example,
     * `['locality', 'political']`. The full list of types can be found
     * [here](https://developers.google.com/maps/documentation/geocoding/requests-geocoding#Types).
     * </pre>
     *
     * <code>repeated string place_types = 7;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearPlaceTypes() {
      placeTypes_ = com.google.protobuf.LazyStringArrayList.emptyList();
      bitField0_ = (bitField0_ & ~0x00000020);
      ;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The type(s) of place that the input geocoded to. For example,
     * `['locality', 'political']`. The full list of types can be found
     * [here](https://developers.google.com/maps/documentation/geocoding/requests-geocoding#Types).
     * </pre>
     *
     * <code>repeated string place_types = 7;</code>
     *
     * @param value The bytes of the placeTypes to add.
     * @return This builder for chaining.
     */
    public Builder addPlaceTypesBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      ensurePlaceTypesIsMutable();
      placeTypes_.add(value);
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.maps.addressvalidation.v1.Geocode)
  }

  // @@protoc_insertion_point(class_scope:google.maps.addressvalidation.v1.Geocode)
  private static final com.google.maps.addressvalidation.v1.Geocode DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.maps.addressvalidation.v1.Geocode();
  }

  public static com.google.maps.addressvalidation.v1.Geocode getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<Geocode> PARSER =
      new com.google.protobuf.AbstractParser<Geocode>() {
        @java.lang.Override
        public Geocode parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<Geocode> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<Geocode> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.maps.addressvalidation.v1.Geocode getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
