/*
 * Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/maps/addressvalidation/v1/address_validation_service.proto

package com.google.maps.addressvalidation.v1;

/**
 *
 *
 * <pre>
 * The result of validating an address.
 * </pre>
 *
 * Protobuf type {@code google.maps.addressvalidation.v1.ValidationResult}
 */
public final class ValidationResult extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.maps.addressvalidation.v1.ValidationResult)
    ValidationResultOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use ValidationResult.newBuilder() to construct.
  private ValidationResult(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private ValidationResult() {}

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new ValidationResult();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.maps.addressvalidation.v1.AddressValidationServiceProto
        .internal_static_google_maps_addressvalidation_v1_ValidationResult_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.maps.addressvalidation.v1.AddressValidationServiceProto
        .internal_static_google_maps_addressvalidation_v1_ValidationResult_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.maps.addressvalidation.v1.ValidationResult.class,
            com.google.maps.addressvalidation.v1.ValidationResult.Builder.class);
  }

  public static final int VERDICT_FIELD_NUMBER = 1;
  private com.google.maps.addressvalidation.v1.Verdict verdict_;
  /**
   *
   *
   * <pre>
   * Overall verdict flags
   * </pre>
   *
   * <code>.google.maps.addressvalidation.v1.Verdict verdict = 1;</code>
   *
   * @return Whether the verdict field is set.
   */
  @java.lang.Override
  public boolean hasVerdict() {
    return verdict_ != null;
  }
  /**
   *
   *
   * <pre>
   * Overall verdict flags
   * </pre>
   *
   * <code>.google.maps.addressvalidation.v1.Verdict verdict = 1;</code>
   *
   * @return The verdict.
   */
  @java.lang.Override
  public com.google.maps.addressvalidation.v1.Verdict getVerdict() {
    return verdict_ == null
        ? com.google.maps.addressvalidation.v1.Verdict.getDefaultInstance()
        : verdict_;
  }
  /**
   *
   *
   * <pre>
   * Overall verdict flags
   * </pre>
   *
   * <code>.google.maps.addressvalidation.v1.Verdict verdict = 1;</code>
   */
  @java.lang.Override
  public com.google.maps.addressvalidation.v1.VerdictOrBuilder getVerdictOrBuilder() {
    return verdict_ == null
        ? com.google.maps.addressvalidation.v1.Verdict.getDefaultInstance()
        : verdict_;
  }

  public static final int ADDRESS_FIELD_NUMBER = 2;
  private com.google.maps.addressvalidation.v1.Address address_;
  /**
   *
   *
   * <pre>
   * Information about the address itself as opposed to the geocode.
   * </pre>
   *
   * <code>.google.maps.addressvalidation.v1.Address address = 2;</code>
   *
   * @return Whether the address field is set.
   */
  @java.lang.Override
  public boolean hasAddress() {
    return address_ != null;
  }
  /**
   *
   *
   * <pre>
   * Information about the address itself as opposed to the geocode.
   * </pre>
   *
   * <code>.google.maps.addressvalidation.v1.Address address = 2;</code>
   *
   * @return The address.
   */
  @java.lang.Override
  public com.google.maps.addressvalidation.v1.Address getAddress() {
    return address_ == null
        ? com.google.maps.addressvalidation.v1.Address.getDefaultInstance()
        : address_;
  }
  /**
   *
   *
   * <pre>
   * Information about the address itself as opposed to the geocode.
   * </pre>
   *
   * <code>.google.maps.addressvalidation.v1.Address address = 2;</code>
   */
  @java.lang.Override
  public com.google.maps.addressvalidation.v1.AddressOrBuilder getAddressOrBuilder() {
    return address_ == null
        ? com.google.maps.addressvalidation.v1.Address.getDefaultInstance()
        : address_;
  }

  public static final int GEOCODE_FIELD_NUMBER = 3;
  private com.google.maps.addressvalidation.v1.Geocode geocode_;
  /**
   *
   *
   * <pre>
   * Information about the location and place that the address geocoded to.
   * </pre>
   *
   * <code>.google.maps.addressvalidation.v1.Geocode geocode = 3;</code>
   *
   * @return Whether the geocode field is set.
   */
  @java.lang.Override
  public boolean hasGeocode() {
    return geocode_ != null;
  }
  /**
   *
   *
   * <pre>
   * Information about the location and place that the address geocoded to.
   * </pre>
   *
   * <code>.google.maps.addressvalidation.v1.Geocode geocode = 3;</code>
   *
   * @return The geocode.
   */
  @java.lang.Override
  public com.google.maps.addressvalidation.v1.Geocode getGeocode() {
    return geocode_ == null
        ? com.google.maps.addressvalidation.v1.Geocode.getDefaultInstance()
        : geocode_;
  }
  /**
   *
   *
   * <pre>
   * Information about the location and place that the address geocoded to.
   * </pre>
   *
   * <code>.google.maps.addressvalidation.v1.Geocode geocode = 3;</code>
   */
  @java.lang.Override
  public com.google.maps.addressvalidation.v1.GeocodeOrBuilder getGeocodeOrBuilder() {
    return geocode_ == null
        ? com.google.maps.addressvalidation.v1.Geocode.getDefaultInstance()
        : geocode_;
  }

  public static final int METADATA_FIELD_NUMBER = 4;
  private com.google.maps.addressvalidation.v1.AddressMetadata metadata_;
  /**
   *
   *
   * <pre>
   * Other information relevant to deliverability. `metadata` is not guaranteed
   * to be fully populated for every address sent to the Address Validation API.
   * </pre>
   *
   * <code>.google.maps.addressvalidation.v1.AddressMetadata metadata = 4;</code>
   *
   * @return Whether the metadata field is set.
   */
  @java.lang.Override
  public boolean hasMetadata() {
    return metadata_ != null;
  }
  /**
   *
   *
   * <pre>
   * Other information relevant to deliverability. `metadata` is not guaranteed
   * to be fully populated for every address sent to the Address Validation API.
   * </pre>
   *
   * <code>.google.maps.addressvalidation.v1.AddressMetadata metadata = 4;</code>
   *
   * @return The metadata.
   */
  @java.lang.Override
  public com.google.maps.addressvalidation.v1.AddressMetadata getMetadata() {
    return metadata_ == null
        ? com.google.maps.addressvalidation.v1.AddressMetadata.getDefaultInstance()
        : metadata_;
  }
  /**
   *
   *
   * <pre>
   * Other information relevant to deliverability. `metadata` is not guaranteed
   * to be fully populated for every address sent to the Address Validation API.
   * </pre>
   *
   * <code>.google.maps.addressvalidation.v1.AddressMetadata metadata = 4;</code>
   */
  @java.lang.Override
  public com.google.maps.addressvalidation.v1.AddressMetadataOrBuilder getMetadataOrBuilder() {
    return metadata_ == null
        ? com.google.maps.addressvalidation.v1.AddressMetadata.getDefaultInstance()
        : metadata_;
  }

  public static final int USPS_DATA_FIELD_NUMBER = 5;
  private com.google.maps.addressvalidation.v1.UspsData uspsData_;
  /**
   *
   *
   * <pre>
   * Extra deliverability flags provided by USPS. Only provided in region `US`
   * and `PR`.
   * </pre>
   *
   * <code>.google.maps.addressvalidation.v1.UspsData usps_data = 5;</code>
   *
   * @return Whether the uspsData field is set.
   */
  @java.lang.Override
  public boolean hasUspsData() {
    return uspsData_ != null;
  }
  /**
   *
   *
   * <pre>
   * Extra deliverability flags provided by USPS. Only provided in region `US`
   * and `PR`.
   * </pre>
   *
   * <code>.google.maps.addressvalidation.v1.UspsData usps_data = 5;</code>
   *
   * @return The uspsData.
   */
  @java.lang.Override
  public com.google.maps.addressvalidation.v1.UspsData getUspsData() {
    return uspsData_ == null
        ? com.google.maps.addressvalidation.v1.UspsData.getDefaultInstance()
        : uspsData_;
  }
  /**
   *
   *
   * <pre>
   * Extra deliverability flags provided by USPS. Only provided in region `US`
   * and `PR`.
   * </pre>
   *
   * <code>.google.maps.addressvalidation.v1.UspsData usps_data = 5;</code>
   */
  @java.lang.Override
  public com.google.maps.addressvalidation.v1.UspsDataOrBuilder getUspsDataOrBuilder() {
    return uspsData_ == null
        ? com.google.maps.addressvalidation.v1.UspsData.getDefaultInstance()
        : uspsData_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (verdict_ != null) {
      output.writeMessage(1, getVerdict());
    }
    if (address_ != null) {
      output.writeMessage(2, getAddress());
    }
    if (geocode_ != null) {
      output.writeMessage(3, getGeocode());
    }
    if (metadata_ != null) {
      output.writeMessage(4, getMetadata());
    }
    if (uspsData_ != null) {
      output.writeMessage(5, getUspsData());
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (verdict_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, getVerdict());
    }
    if (address_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, getAddress());
    }
    if (geocode_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, getGeocode());
    }
    if (metadata_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(4, getMetadata());
    }
    if (uspsData_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(5, getUspsData());
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.maps.addressvalidation.v1.ValidationResult)) {
      return super.equals(obj);
    }
    com.google.maps.addressvalidation.v1.ValidationResult other =
        (com.google.maps.addressvalidation.v1.ValidationResult) obj;

    if (hasVerdict() != other.hasVerdict()) return false;
    if (hasVerdict()) {
      if (!getVerdict().equals(other.getVerdict())) return false;
    }
    if (hasAddress() != other.hasAddress()) return false;
    if (hasAddress()) {
      if (!getAddress().equals(other.getAddress())) return false;
    }
    if (hasGeocode() != other.hasGeocode()) return false;
    if (hasGeocode()) {
      if (!getGeocode().equals(other.getGeocode())) return false;
    }
    if (hasMetadata() != other.hasMetadata()) return false;
    if (hasMetadata()) {
      if (!getMetadata().equals(other.getMetadata())) return false;
    }
    if (hasUspsData() != other.hasUspsData()) return false;
    if (hasUspsData()) {
      if (!getUspsData().equals(other.getUspsData())) return false;
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (hasVerdict()) {
      hash = (37 * hash) + VERDICT_FIELD_NUMBER;
      hash = (53 * hash) + getVerdict().hashCode();
    }
    if (hasAddress()) {
      hash = (37 * hash) + ADDRESS_FIELD_NUMBER;
      hash = (53 * hash) + getAddress().hashCode();
    }
    if (hasGeocode()) {
      hash = (37 * hash) + GEOCODE_FIELD_NUMBER;
      hash = (53 * hash) + getGeocode().hashCode();
    }
    if (hasMetadata()) {
      hash = (37 * hash) + METADATA_FIELD_NUMBER;
      hash = (53 * hash) + getMetadata().hashCode();
    }
    if (hasUspsData()) {
      hash = (37 * hash) + USPS_DATA_FIELD_NUMBER;
      hash = (53 * hash) + getUspsData().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.maps.addressvalidation.v1.ValidationResult parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.maps.addressvalidation.v1.ValidationResult parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.maps.addressvalidation.v1.ValidationResult parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.maps.addressvalidation.v1.ValidationResult parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.maps.addressvalidation.v1.ValidationResult parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.maps.addressvalidation.v1.ValidationResult parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.maps.addressvalidation.v1.ValidationResult parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.maps.addressvalidation.v1.ValidationResult parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.maps.addressvalidation.v1.ValidationResult parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.maps.addressvalidation.v1.ValidationResult parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.maps.addressvalidation.v1.ValidationResult parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.maps.addressvalidation.v1.ValidationResult parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.maps.addressvalidation.v1.ValidationResult prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * The result of validating an address.
   * </pre>
   *
   * Protobuf type {@code google.maps.addressvalidation.v1.ValidationResult}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.maps.addressvalidation.v1.ValidationResult)
      com.google.maps.addressvalidation.v1.ValidationResultOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.maps.addressvalidation.v1.AddressValidationServiceProto
          .internal_static_google_maps_addressvalidation_v1_ValidationResult_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.maps.addressvalidation.v1.AddressValidationServiceProto
          .internal_static_google_maps_addressvalidation_v1_ValidationResult_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.maps.addressvalidation.v1.ValidationResult.class,
              com.google.maps.addressvalidation.v1.ValidationResult.Builder.class);
    }

    // Construct using com.google.maps.addressvalidation.v1.ValidationResult.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      verdict_ = null;
      if (verdictBuilder_ != null) {
        verdictBuilder_.dispose();
        verdictBuilder_ = null;
      }
      address_ = null;
      if (addressBuilder_ != null) {
        addressBuilder_.dispose();
        addressBuilder_ = null;
      }
      geocode_ = null;
      if (geocodeBuilder_ != null) {
        geocodeBuilder_.dispose();
        geocodeBuilder_ = null;
      }
      metadata_ = null;
      if (metadataBuilder_ != null) {
        metadataBuilder_.dispose();
        metadataBuilder_ = null;
      }
      uspsData_ = null;
      if (uspsDataBuilder_ != null) {
        uspsDataBuilder_.dispose();
        uspsDataBuilder_ = null;
      }
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.maps.addressvalidation.v1.AddressValidationServiceProto
          .internal_static_google_maps_addressvalidation_v1_ValidationResult_descriptor;
    }

    @java.lang.Override
    public com.google.maps.addressvalidation.v1.ValidationResult getDefaultInstanceForType() {
      return com.google.maps.addressvalidation.v1.ValidationResult.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.maps.addressvalidation.v1.ValidationResult build() {
      com.google.maps.addressvalidation.v1.ValidationResult result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.maps.addressvalidation.v1.ValidationResult buildPartial() {
      com.google.maps.addressvalidation.v1.ValidationResult result =
          new com.google.maps.addressvalidation.v1.ValidationResult(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.maps.addressvalidation.v1.ValidationResult result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.verdict_ = verdictBuilder_ == null ? verdict_ : verdictBuilder_.build();
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.address_ = addressBuilder_ == null ? address_ : addressBuilder_.build();
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.geocode_ = geocodeBuilder_ == null ? geocode_ : geocodeBuilder_.build();
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.metadata_ = metadataBuilder_ == null ? metadata_ : metadataBuilder_.build();
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.uspsData_ = uspsDataBuilder_ == null ? uspsData_ : uspsDataBuilder_.build();
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.maps.addressvalidation.v1.ValidationResult) {
        return mergeFrom((com.google.maps.addressvalidation.v1.ValidationResult) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.maps.addressvalidation.v1.ValidationResult other) {
      if (other == com.google.maps.addressvalidation.v1.ValidationResult.getDefaultInstance())
        return this;
      if (other.hasVerdict()) {
        mergeVerdict(other.getVerdict());
      }
      if (other.hasAddress()) {
        mergeAddress(other.getAddress());
      }
      if (other.hasGeocode()) {
        mergeGeocode(other.getGeocode());
      }
      if (other.hasMetadata()) {
        mergeMetadata(other.getMetadata());
      }
      if (other.hasUspsData()) {
        mergeUspsData(other.getUspsData());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                input.readMessage(getVerdictFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                input.readMessage(getAddressFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            case 26:
              {
                input.readMessage(getGeocodeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000004;
                break;
              } // case 26
            case 34:
              {
                input.readMessage(getMetadataFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000008;
                break;
              } // case 34
            case 42:
              {
                input.readMessage(getUspsDataFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000010;
                break;
              } // case 42
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private com.google.maps.addressvalidation.v1.Verdict verdict_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.maps.addressvalidation.v1.Verdict,
            com.google.maps.addressvalidation.v1.Verdict.Builder,
            com.google.maps.addressvalidation.v1.VerdictOrBuilder>
        verdictBuilder_;
    /**
     *
     *
     * <pre>
     * Overall verdict flags
     * </pre>
     *
     * <code>.google.maps.addressvalidation.v1.Verdict verdict = 1;</code>
     *
     * @return Whether the verdict field is set.
     */
    public boolean hasVerdict() {
      return ((bitField0_ & 0x00000001) != 0);
    }
    /**
     *
     *
     * <pre>
     * Overall verdict flags
     * </pre>
     *
     * <code>.google.maps.addressvalidation.v1.Verdict verdict = 1;</code>
     *
     * @return The verdict.
     */
    public com.google.maps.addressvalidation.v1.Verdict getVerdict() {
      if (verdictBuilder_ == null) {
        return verdict_ == null
            ? com.google.maps.addressvalidation.v1.Verdict.getDefaultInstance()
            : verdict_;
      } else {
        return verdictBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Overall verdict flags
     * </pre>
     *
     * <code>.google.maps.addressvalidation.v1.Verdict verdict = 1;</code>
     */
    public Builder setVerdict(com.google.maps.addressvalidation.v1.Verdict value) {
      if (verdictBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        verdict_ = value;
      } else {
        verdictBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Overall verdict flags
     * </pre>
     *
     * <code>.google.maps.addressvalidation.v1.Verdict verdict = 1;</code>
     */
    public Builder setVerdict(
        com.google.maps.addressvalidation.v1.Verdict.Builder builderForValue) {
      if (verdictBuilder_ == null) {
        verdict_ = builderForValue.build();
      } else {
        verdictBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Overall verdict flags
     * </pre>
     *
     * <code>.google.maps.addressvalidation.v1.Verdict verdict = 1;</code>
     */
    public Builder mergeVerdict(com.google.maps.addressvalidation.v1.Verdict value) {
      if (verdictBuilder_ == null) {
        if (((bitField0_ & 0x00000001) != 0)
            && verdict_ != null
            && verdict_ != com.google.maps.addressvalidation.v1.Verdict.getDefaultInstance()) {
          getVerdictBuilder().mergeFrom(value);
        } else {
          verdict_ = value;
        }
      } else {
        verdictBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Overall verdict flags
     * </pre>
     *
     * <code>.google.maps.addressvalidation.v1.Verdict verdict = 1;</code>
     */
    public Builder clearVerdict() {
      bitField0_ = (bitField0_ & ~0x00000001);
      verdict_ = null;
      if (verdictBuilder_ != null) {
        verdictBuilder_.dispose();
        verdictBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Overall verdict flags
     * </pre>
     *
     * <code>.google.maps.addressvalidation.v1.Verdict verdict = 1;</code>
     */
    public com.google.maps.addressvalidation.v1.Verdict.Builder getVerdictBuilder() {
      bitField0_ |= 0x00000001;
      onChanged();
      return getVerdictFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Overall verdict flags
     * </pre>
     *
     * <code>.google.maps.addressvalidation.v1.Verdict verdict = 1;</code>
     */
    public com.google.maps.addressvalidation.v1.VerdictOrBuilder getVerdictOrBuilder() {
      if (verdictBuilder_ != null) {
        return verdictBuilder_.getMessageOrBuilder();
      } else {
        return verdict_ == null
            ? com.google.maps.addressvalidation.v1.Verdict.getDefaultInstance()
            : verdict_;
      }
    }
    /**
     *
     *
     * <pre>
     * Overall verdict flags
     * </pre>
     *
     * <code>.google.maps.addressvalidation.v1.Verdict verdict = 1;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.maps.addressvalidation.v1.Verdict,
            com.google.maps.addressvalidation.v1.Verdict.Builder,
            com.google.maps.addressvalidation.v1.VerdictOrBuilder>
        getVerdictFieldBuilder() {
      if (verdictBuilder_ == null) {
        verdictBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.maps.addressvalidation.v1.Verdict,
                com.google.maps.addressvalidation.v1.Verdict.Builder,
                com.google.maps.addressvalidation.v1.VerdictOrBuilder>(
                getVerdict(), getParentForChildren(), isClean());
        verdict_ = null;
      }
      return verdictBuilder_;
    }

    private com.google.maps.addressvalidation.v1.Address address_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.maps.addressvalidation.v1.Address,
            com.google.maps.addressvalidation.v1.Address.Builder,
            com.google.maps.addressvalidation.v1.AddressOrBuilder>
        addressBuilder_;
    /**
     *
     *
     * <pre>
     * Information about the address itself as opposed to the geocode.
     * </pre>
     *
     * <code>.google.maps.addressvalidation.v1.Address address = 2;</code>
     *
     * @return Whether the address field is set.
     */
    public boolean hasAddress() {
      return ((bitField0_ & 0x00000002) != 0);
    }
    /**
     *
     *
     * <pre>
     * Information about the address itself as opposed to the geocode.
     * </pre>
     *
     * <code>.google.maps.addressvalidation.v1.Address address = 2;</code>
     *
     * @return The address.
     */
    public com.google.maps.addressvalidation.v1.Address getAddress() {
      if (addressBuilder_ == null) {
        return address_ == null
            ? com.google.maps.addressvalidation.v1.Address.getDefaultInstance()
            : address_;
      } else {
        return addressBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Information about the address itself as opposed to the geocode.
     * </pre>
     *
     * <code>.google.maps.addressvalidation.v1.Address address = 2;</code>
     */
    public Builder setAddress(com.google.maps.addressvalidation.v1.Address value) {
      if (addressBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        address_ = value;
      } else {
        addressBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Information about the address itself as opposed to the geocode.
     * </pre>
     *
     * <code>.google.maps.addressvalidation.v1.Address address = 2;</code>
     */
    public Builder setAddress(
        com.google.maps.addressvalidation.v1.Address.Builder builderForValue) {
      if (addressBuilder_ == null) {
        address_ = builderForValue.build();
      } else {
        addressBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Information about the address itself as opposed to the geocode.
     * </pre>
     *
     * <code>.google.maps.addressvalidation.v1.Address address = 2;</code>
     */
    public Builder mergeAddress(com.google.maps.addressvalidation.v1.Address value) {
      if (addressBuilder_ == null) {
        if (((bitField0_ & 0x00000002) != 0)
            && address_ != null
            && address_ != com.google.maps.addressvalidation.v1.Address.getDefaultInstance()) {
          getAddressBuilder().mergeFrom(value);
        } else {
          address_ = value;
        }
      } else {
        addressBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Information about the address itself as opposed to the geocode.
     * </pre>
     *
     * <code>.google.maps.addressvalidation.v1.Address address = 2;</code>
     */
    public Builder clearAddress() {
      bitField0_ = (bitField0_ & ~0x00000002);
      address_ = null;
      if (addressBuilder_ != null) {
        addressBuilder_.dispose();
        addressBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Information about the address itself as opposed to the geocode.
     * </pre>
     *
     * <code>.google.maps.addressvalidation.v1.Address address = 2;</code>
     */
    public com.google.maps.addressvalidation.v1.Address.Builder getAddressBuilder() {
      bitField0_ |= 0x00000002;
      onChanged();
      return getAddressFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Information about the address itself as opposed to the geocode.
     * </pre>
     *
     * <code>.google.maps.addressvalidation.v1.Address address = 2;</code>
     */
    public com.google.maps.addressvalidation.v1.AddressOrBuilder getAddressOrBuilder() {
      if (addressBuilder_ != null) {
        return addressBuilder_.getMessageOrBuilder();
      } else {
        return address_ == null
            ? com.google.maps.addressvalidation.v1.Address.getDefaultInstance()
            : address_;
      }
    }
    /**
     *
     *
     * <pre>
     * Information about the address itself as opposed to the geocode.
     * </pre>
     *
     * <code>.google.maps.addressvalidation.v1.Address address = 2;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.maps.addressvalidation.v1.Address,
            com.google.maps.addressvalidation.v1.Address.Builder,
            com.google.maps.addressvalidation.v1.AddressOrBuilder>
        getAddressFieldBuilder() {
      if (addressBuilder_ == null) {
        addressBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.maps.addressvalidation.v1.Address,
                com.google.maps.addressvalidation.v1.Address.Builder,
                com.google.maps.addressvalidation.v1.AddressOrBuilder>(
                getAddress(), getParentForChildren(), isClean());
        address_ = null;
      }
      return addressBuilder_;
    }

    private com.google.maps.addressvalidation.v1.Geocode geocode_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.maps.addressvalidation.v1.Geocode,
            com.google.maps.addressvalidation.v1.Geocode.Builder,
            com.google.maps.addressvalidation.v1.GeocodeOrBuilder>
        geocodeBuilder_;
    /**
     *
     *
     * <pre>
     * Information about the location and place that the address geocoded to.
     * </pre>
     *
     * <code>.google.maps.addressvalidation.v1.Geocode geocode = 3;</code>
     *
     * @return Whether the geocode field is set.
     */
    public boolean hasGeocode() {
      return ((bitField0_ & 0x00000004) != 0);
    }
    /**
     *
     *
     * <pre>
     * Information about the location and place that the address geocoded to.
     * </pre>
     *
     * <code>.google.maps.addressvalidation.v1.Geocode geocode = 3;</code>
     *
     * @return The geocode.
     */
    public com.google.maps.addressvalidation.v1.Geocode getGeocode() {
      if (geocodeBuilder_ == null) {
        return geocode_ == null
            ? com.google.maps.addressvalidation.v1.Geocode.getDefaultInstance()
            : geocode_;
      } else {
        return geocodeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Information about the location and place that the address geocoded to.
     * </pre>
     *
     * <code>.google.maps.addressvalidation.v1.Geocode geocode = 3;</code>
     */
    public Builder setGeocode(com.google.maps.addressvalidation.v1.Geocode value) {
      if (geocodeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        geocode_ = value;
      } else {
        geocodeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Information about the location and place that the address geocoded to.
     * </pre>
     *
     * <code>.google.maps.addressvalidation.v1.Geocode geocode = 3;</code>
     */
    public Builder setGeocode(
        com.google.maps.addressvalidation.v1.Geocode.Builder builderForValue) {
      if (geocodeBuilder_ == null) {
        geocode_ = builderForValue.build();
      } else {
        geocodeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Information about the location and place that the address geocoded to.
     * </pre>
     *
     * <code>.google.maps.addressvalidation.v1.Geocode geocode = 3;</code>
     */
    public Builder mergeGeocode(com.google.maps.addressvalidation.v1.Geocode value) {
      if (geocodeBuilder_ == null) {
        if (((bitField0_ & 0x00000004) != 0)
            && geocode_ != null
            && geocode_ != com.google.maps.addressvalidation.v1.Geocode.getDefaultInstance()) {
          getGeocodeBuilder().mergeFrom(value);
        } else {
          geocode_ = value;
        }
      } else {
        geocodeBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Information about the location and place that the address geocoded to.
     * </pre>
     *
     * <code>.google.maps.addressvalidation.v1.Geocode geocode = 3;</code>
     */
    public Builder clearGeocode() {
      bitField0_ = (bitField0_ & ~0x00000004);
      geocode_ = null;
      if (geocodeBuilder_ != null) {
        geocodeBuilder_.dispose();
        geocodeBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Information about the location and place that the address geocoded to.
     * </pre>
     *
     * <code>.google.maps.addressvalidation.v1.Geocode geocode = 3;</code>
     */
    public com.google.maps.addressvalidation.v1.Geocode.Builder getGeocodeBuilder() {
      bitField0_ |= 0x00000004;
      onChanged();
      return getGeocodeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Information about the location and place that the address geocoded to.
     * </pre>
     *
     * <code>.google.maps.addressvalidation.v1.Geocode geocode = 3;</code>
     */
    public com.google.maps.addressvalidation.v1.GeocodeOrBuilder getGeocodeOrBuilder() {
      if (geocodeBuilder_ != null) {
        return geocodeBuilder_.getMessageOrBuilder();
      } else {
        return geocode_ == null
            ? com.google.maps.addressvalidation.v1.Geocode.getDefaultInstance()
            : geocode_;
      }
    }
    /**
     *
     *
     * <pre>
     * Information about the location and place that the address geocoded to.
     * </pre>
     *
     * <code>.google.maps.addressvalidation.v1.Geocode geocode = 3;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.maps.addressvalidation.v1.Geocode,
            com.google.maps.addressvalidation.v1.Geocode.Builder,
            com.google.maps.addressvalidation.v1.GeocodeOrBuilder>
        getGeocodeFieldBuilder() {
      if (geocodeBuilder_ == null) {
        geocodeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.maps.addressvalidation.v1.Geocode,
                com.google.maps.addressvalidation.v1.Geocode.Builder,
                com.google.maps.addressvalidation.v1.GeocodeOrBuilder>(
                getGeocode(), getParentForChildren(), isClean());
        geocode_ = null;
      }
      return geocodeBuilder_;
    }

    private com.google.maps.addressvalidation.v1.AddressMetadata metadata_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.maps.addressvalidation.v1.AddressMetadata,
            com.google.maps.addressvalidation.v1.AddressMetadata.Builder,
            com.google.maps.addressvalidation.v1.AddressMetadataOrBuilder>
        metadataBuilder_;
    /**
     *
     *
     * <pre>
     * Other information relevant to deliverability. `metadata` is not guaranteed
     * to be fully populated for every address sent to the Address Validation API.
     * </pre>
     *
     * <code>.google.maps.addressvalidation.v1.AddressMetadata metadata = 4;</code>
     *
     * @return Whether the metadata field is set.
     */
    public boolean hasMetadata() {
      return ((bitField0_ & 0x00000008) != 0);
    }
    /**
     *
     *
     * <pre>
     * Other information relevant to deliverability. `metadata` is not guaranteed
     * to be fully populated for every address sent to the Address Validation API.
     * </pre>
     *
     * <code>.google.maps.addressvalidation.v1.AddressMetadata metadata = 4;</code>
     *
     * @return The metadata.
     */
    public com.google.maps.addressvalidation.v1.AddressMetadata getMetadata() {
      if (metadataBuilder_ == null) {
        return metadata_ == null
            ? com.google.maps.addressvalidation.v1.AddressMetadata.getDefaultInstance()
            : metadata_;
      } else {
        return metadataBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Other information relevant to deliverability. `metadata` is not guaranteed
     * to be fully populated for every address sent to the Address Validation API.
     * </pre>
     *
     * <code>.google.maps.addressvalidation.v1.AddressMetadata metadata = 4;</code>
     */
    public Builder setMetadata(com.google.maps.addressvalidation.v1.AddressMetadata value) {
      if (metadataBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        metadata_ = value;
      } else {
        metadataBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Other information relevant to deliverability. `metadata` is not guaranteed
     * to be fully populated for every address sent to the Address Validation API.
     * </pre>
     *
     * <code>.google.maps.addressvalidation.v1.AddressMetadata metadata = 4;</code>
     */
    public Builder setMetadata(
        com.google.maps.addressvalidation.v1.AddressMetadata.Builder builderForValue) {
      if (metadataBuilder_ == null) {
        metadata_ = builderForValue.build();
      } else {
        metadataBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Other information relevant to deliverability. `metadata` is not guaranteed
     * to be fully populated for every address sent to the Address Validation API.
     * </pre>
     *
     * <code>.google.maps.addressvalidation.v1.AddressMetadata metadata = 4;</code>
     */
    public Builder mergeMetadata(com.google.maps.addressvalidation.v1.AddressMetadata value) {
      if (metadataBuilder_ == null) {
        if (((bitField0_ & 0x00000008) != 0)
            && metadata_ != null
            && metadata_
                != com.google.maps.addressvalidation.v1.AddressMetadata.getDefaultInstance()) {
          getMetadataBuilder().mergeFrom(value);
        } else {
          metadata_ = value;
        }
      } else {
        metadataBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Other information relevant to deliverability. `metadata` is not guaranteed
     * to be fully populated for every address sent to the Address Validation API.
     * </pre>
     *
     * <code>.google.maps.addressvalidation.v1.AddressMetadata metadata = 4;</code>
     */
    public Builder clearMetadata() {
      bitField0_ = (bitField0_ & ~0x00000008);
      metadata_ = null;
      if (metadataBuilder_ != null) {
        metadataBuilder_.dispose();
        metadataBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Other information relevant to deliverability. `metadata` is not guaranteed
     * to be fully populated for every address sent to the Address Validation API.
     * </pre>
     *
     * <code>.google.maps.addressvalidation.v1.AddressMetadata metadata = 4;</code>
     */
    public com.google.maps.addressvalidation.v1.AddressMetadata.Builder getMetadataBuilder() {
      bitField0_ |= 0x00000008;
      onChanged();
      return getMetadataFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Other information relevant to deliverability. `metadata` is not guaranteed
     * to be fully populated for every address sent to the Address Validation API.
     * </pre>
     *
     * <code>.google.maps.addressvalidation.v1.AddressMetadata metadata = 4;</code>
     */
    public com.google.maps.addressvalidation.v1.AddressMetadataOrBuilder getMetadataOrBuilder() {
      if (metadataBuilder_ != null) {
        return metadataBuilder_.getMessageOrBuilder();
      } else {
        return metadata_ == null
            ? com.google.maps.addressvalidation.v1.AddressMetadata.getDefaultInstance()
            : metadata_;
      }
    }
    /**
     *
     *
     * <pre>
     * Other information relevant to deliverability. `metadata` is not guaranteed
     * to be fully populated for every address sent to the Address Validation API.
     * </pre>
     *
     * <code>.google.maps.addressvalidation.v1.AddressMetadata metadata = 4;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.maps.addressvalidation.v1.AddressMetadata,
            com.google.maps.addressvalidation.v1.AddressMetadata.Builder,
            com.google.maps.addressvalidation.v1.AddressMetadataOrBuilder>
        getMetadataFieldBuilder() {
      if (metadataBuilder_ == null) {
        metadataBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.maps.addressvalidation.v1.AddressMetadata,
                com.google.maps.addressvalidation.v1.AddressMetadata.Builder,
                com.google.maps.addressvalidation.v1.AddressMetadataOrBuilder>(
                getMetadata(), getParentForChildren(), isClean());
        metadata_ = null;
      }
      return metadataBuilder_;
    }

    private com.google.maps.addressvalidation.v1.UspsData uspsData_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.maps.addressvalidation.v1.UspsData,
            com.google.maps.addressvalidation.v1.UspsData.Builder,
            com.google.maps.addressvalidation.v1.UspsDataOrBuilder>
        uspsDataBuilder_;
    /**
     *
     *
     * <pre>
     * Extra deliverability flags provided by USPS. Only provided in region `US`
     * and `PR`.
     * </pre>
     *
     * <code>.google.maps.addressvalidation.v1.UspsData usps_data = 5;</code>
     *
     * @return Whether the uspsData field is set.
     */
    public boolean hasUspsData() {
      return ((bitField0_ & 0x00000010) != 0);
    }
    /**
     *
     *
     * <pre>
     * Extra deliverability flags provided by USPS. Only provided in region `US`
     * and `PR`.
     * </pre>
     *
     * <code>.google.maps.addressvalidation.v1.UspsData usps_data = 5;</code>
     *
     * @return The uspsData.
     */
    public com.google.maps.addressvalidation.v1.UspsData getUspsData() {
      if (uspsDataBuilder_ == null) {
        return uspsData_ == null
            ? com.google.maps.addressvalidation.v1.UspsData.getDefaultInstance()
            : uspsData_;
      } else {
        return uspsDataBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Extra deliverability flags provided by USPS. Only provided in region `US`
     * and `PR`.
     * </pre>
     *
     * <code>.google.maps.addressvalidation.v1.UspsData usps_data = 5;</code>
     */
    public Builder setUspsData(com.google.maps.addressvalidation.v1.UspsData value) {
      if (uspsDataBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        uspsData_ = value;
      } else {
        uspsDataBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Extra deliverability flags provided by USPS. Only provided in region `US`
     * and `PR`.
     * </pre>
     *
     * <code>.google.maps.addressvalidation.v1.UspsData usps_data = 5;</code>
     */
    public Builder setUspsData(
        com.google.maps.addressvalidation.v1.UspsData.Builder builderForValue) {
      if (uspsDataBuilder_ == null) {
        uspsData_ = builderForValue.build();
      } else {
        uspsDataBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Extra deliverability flags provided by USPS. Only provided in region `US`
     * and `PR`.
     * </pre>
     *
     * <code>.google.maps.addressvalidation.v1.UspsData usps_data = 5;</code>
     */
    public Builder mergeUspsData(com.google.maps.addressvalidation.v1.UspsData value) {
      if (uspsDataBuilder_ == null) {
        if (((bitField0_ & 0x00000010) != 0)
            && uspsData_ != null
            && uspsData_ != com.google.maps.addressvalidation.v1.UspsData.getDefaultInstance()) {
          getUspsDataBuilder().mergeFrom(value);
        } else {
          uspsData_ = value;
        }
      } else {
        uspsDataBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Extra deliverability flags provided by USPS. Only provided in region `US`
     * and `PR`.
     * </pre>
     *
     * <code>.google.maps.addressvalidation.v1.UspsData usps_data = 5;</code>
     */
    public Builder clearUspsData() {
      bitField0_ = (bitField0_ & ~0x00000010);
      uspsData_ = null;
      if (uspsDataBuilder_ != null) {
        uspsDataBuilder_.dispose();
        uspsDataBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Extra deliverability flags provided by USPS. Only provided in region `US`
     * and `PR`.
     * </pre>
     *
     * <code>.google.maps.addressvalidation.v1.UspsData usps_data = 5;</code>
     */
    public com.google.maps.addressvalidation.v1.UspsData.Builder getUspsDataBuilder() {
      bitField0_ |= 0x00000010;
      onChanged();
      return getUspsDataFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Extra deliverability flags provided by USPS. Only provided in region `US`
     * and `PR`.
     * </pre>
     *
     * <code>.google.maps.addressvalidation.v1.UspsData usps_data = 5;</code>
     */
    public com.google.maps.addressvalidation.v1.UspsDataOrBuilder getUspsDataOrBuilder() {
      if (uspsDataBuilder_ != null) {
        return uspsDataBuilder_.getMessageOrBuilder();
      } else {
        return uspsData_ == null
            ? com.google.maps.addressvalidation.v1.UspsData.getDefaultInstance()
            : uspsData_;
      }
    }
    /**
     *
     *
     * <pre>
     * Extra deliverability flags provided by USPS. Only provided in region `US`
     * and `PR`.
     * </pre>
     *
     * <code>.google.maps.addressvalidation.v1.UspsData usps_data = 5;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.maps.addressvalidation.v1.UspsData,
            com.google.maps.addressvalidation.v1.UspsData.Builder,
            com.google.maps.addressvalidation.v1.UspsDataOrBuilder>
        getUspsDataFieldBuilder() {
      if (uspsDataBuilder_ == null) {
        uspsDataBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.maps.addressvalidation.v1.UspsData,
                com.google.maps.addressvalidation.v1.UspsData.Builder,
                com.google.maps.addressvalidation.v1.UspsDataOrBuilder>(
                getUspsData(), getParentForChildren(), isClean());
        uspsData_ = null;
      }
      return uspsDataBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.maps.addressvalidation.v1.ValidationResult)
  }

  // @@protoc_insertion_point(class_scope:google.maps.addressvalidation.v1.ValidationResult)
  private static final com.google.maps.addressvalidation.v1.ValidationResult DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.maps.addressvalidation.v1.ValidationResult();
  }

  public static com.google.maps.addressvalidation.v1.ValidationResult getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<ValidationResult> PARSER =
      new com.google.protobuf.AbstractParser<ValidationResult>() {
        @java.lang.Override
        public ValidationResult parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<ValidationResult> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<ValidationResult> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.maps.addressvalidation.v1.ValidationResult getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
