/*
 * Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/maps/addressvalidation/v1/address.proto

package com.google.maps.addressvalidation.v1;

/**
 *
 *
 * <pre>
 * Represents an address component, such as a street, city, or state.
 * </pre>
 *
 * Protobuf type {@code google.maps.addressvalidation.v1.AddressComponent}
 */
public final class AddressComponent extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.maps.addressvalidation.v1.AddressComponent)
    AddressComponentOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use AddressComponent.newBuilder() to construct.
  private AddressComponent(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private AddressComponent() {
    componentType_ = "";
    confirmationLevel_ = 0;
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new AddressComponent();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.maps.addressvalidation.v1.AddressProto
        .internal_static_google_maps_addressvalidation_v1_AddressComponent_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.maps.addressvalidation.v1.AddressProto
        .internal_static_google_maps_addressvalidation_v1_AddressComponent_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.maps.addressvalidation.v1.AddressComponent.class,
            com.google.maps.addressvalidation.v1.AddressComponent.Builder.class);
  }

  /**
   *
   *
   * <pre>
   * The different possible values for confirmation levels.
   * </pre>
   *
   * Protobuf enum {@code google.maps.addressvalidation.v1.AddressComponent.ConfirmationLevel}
   */
  public enum ConfirmationLevel implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * Default value. This value is unused.
     * </pre>
     *
     * <code>CONFIRMATION_LEVEL_UNSPECIFIED = 0;</code>
     */
    CONFIRMATION_LEVEL_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * We were able to verify that this component exists and makes sense in the
     * context of the rest of the address.
     * </pre>
     *
     * <code>CONFIRMED = 1;</code>
     */
    CONFIRMED(1),
    /**
     *
     *
     * <pre>
     * This component could not be confirmed, but it is plausible that it
     * exists. For example, a street number within a known valid range of
     * numbers on a street where specific house numbers are not known.
     * </pre>
     *
     * <code>UNCONFIRMED_BUT_PLAUSIBLE = 2;</code>
     */
    UNCONFIRMED_BUT_PLAUSIBLE(2),
    /**
     *
     *
     * <pre>
     * This component was not confirmed and is likely to be wrong. For
     * example, a neighborhood that does not fit the rest of the address.
     * </pre>
     *
     * <code>UNCONFIRMED_AND_SUSPICIOUS = 3;</code>
     */
    UNCONFIRMED_AND_SUSPICIOUS(3),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * Default value. This value is unused.
     * </pre>
     *
     * <code>CONFIRMATION_LEVEL_UNSPECIFIED = 0;</code>
     */
    public static final int CONFIRMATION_LEVEL_UNSPECIFIED_VALUE = 0;
    /**
     *
     *
     * <pre>
     * We were able to verify that this component exists and makes sense in the
     * context of the rest of the address.
     * </pre>
     *
     * <code>CONFIRMED = 1;</code>
     */
    public static final int CONFIRMED_VALUE = 1;
    /**
     *
     *
     * <pre>
     * This component could not be confirmed, but it is plausible that it
     * exists. For example, a street number within a known valid range of
     * numbers on a street where specific house numbers are not known.
     * </pre>
     *
     * <code>UNCONFIRMED_BUT_PLAUSIBLE = 2;</code>
     */
    public static final int UNCONFIRMED_BUT_PLAUSIBLE_VALUE = 2;
    /**
     *
     *
     * <pre>
     * This component was not confirmed and is likely to be wrong. For
     * example, a neighborhood that does not fit the rest of the address.
     * </pre>
     *
     * <code>UNCONFIRMED_AND_SUSPICIOUS = 3;</code>
     */
    public static final int UNCONFIRMED_AND_SUSPICIOUS_VALUE = 3;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static ConfirmationLevel valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static ConfirmationLevel forNumber(int value) {
      switch (value) {
        case 0:
          return CONFIRMATION_LEVEL_UNSPECIFIED;
        case 1:
          return CONFIRMED;
        case 2:
          return UNCONFIRMED_BUT_PLAUSIBLE;
        case 3:
          return UNCONFIRMED_AND_SUSPICIOUS;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<ConfirmationLevel>
        internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<ConfirmationLevel>
        internalValueMap =
            new com.google.protobuf.Internal.EnumLiteMap<ConfirmationLevel>() {
              public ConfirmationLevel findValueByNumber(int number) {
                return ConfirmationLevel.forNumber(number);
              }
            };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.maps.addressvalidation.v1.AddressComponent.getDescriptor()
          .getEnumTypes()
          .get(0);
    }

    private static final ConfirmationLevel[] VALUES = values();

    public static ConfirmationLevel valueOf(
        com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private ConfirmationLevel(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.maps.addressvalidation.v1.AddressComponent.ConfirmationLevel)
  }

  public static final int COMPONENT_NAME_FIELD_NUMBER = 1;
  private com.google.maps.addressvalidation.v1.ComponentName componentName_;
  /**
   *
   *
   * <pre>
   * The name for this component.
   * </pre>
   *
   * <code>.google.maps.addressvalidation.v1.ComponentName component_name = 1;</code>
   *
   * @return Whether the componentName field is set.
   */
  @java.lang.Override
  public boolean hasComponentName() {
    return componentName_ != null;
  }
  /**
   *
   *
   * <pre>
   * The name for this component.
   * </pre>
   *
   * <code>.google.maps.addressvalidation.v1.ComponentName component_name = 1;</code>
   *
   * @return The componentName.
   */
  @java.lang.Override
  public com.google.maps.addressvalidation.v1.ComponentName getComponentName() {
    return componentName_ == null
        ? com.google.maps.addressvalidation.v1.ComponentName.getDefaultInstance()
        : componentName_;
  }
  /**
   *
   *
   * <pre>
   * The name for this component.
   * </pre>
   *
   * <code>.google.maps.addressvalidation.v1.ComponentName component_name = 1;</code>
   */
  @java.lang.Override
  public com.google.maps.addressvalidation.v1.ComponentNameOrBuilder getComponentNameOrBuilder() {
    return componentName_ == null
        ? com.google.maps.addressvalidation.v1.ComponentName.getDefaultInstance()
        : componentName_;
  }

  public static final int COMPONENT_TYPE_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private volatile java.lang.Object componentType_ = "";
  /**
   *
   *
   * <pre>
   * The type of the address component. See
   * [Table 2: Additional types returned by the Places
   * service](https://developers.google.com/places/web-service/supported_types#table2)
   * for a list of possible types.
   * </pre>
   *
   * <code>string component_type = 2;</code>
   *
   * @return The componentType.
   */
  @java.lang.Override
  public java.lang.String getComponentType() {
    java.lang.Object ref = componentType_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      componentType_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The type of the address component. See
   * [Table 2: Additional types returned by the Places
   * service](https://developers.google.com/places/web-service/supported_types#table2)
   * for a list of possible types.
   * </pre>
   *
   * <code>string component_type = 2;</code>
   *
   * @return The bytes for componentType.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getComponentTypeBytes() {
    java.lang.Object ref = componentType_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      componentType_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int CONFIRMATION_LEVEL_FIELD_NUMBER = 3;
  private int confirmationLevel_ = 0;
  /**
   *
   *
   * <pre>
   * Indicates the level of certainty that we have that the component
   * is correct.
   * </pre>
   *
   * <code>
   * .google.maps.addressvalidation.v1.AddressComponent.ConfirmationLevel confirmation_level = 3;
   * </code>
   *
   * @return The enum numeric value on the wire for confirmationLevel.
   */
  @java.lang.Override
  public int getConfirmationLevelValue() {
    return confirmationLevel_;
  }
  /**
   *
   *
   * <pre>
   * Indicates the level of certainty that we have that the component
   * is correct.
   * </pre>
   *
   * <code>
   * .google.maps.addressvalidation.v1.AddressComponent.ConfirmationLevel confirmation_level = 3;
   * </code>
   *
   * @return The confirmationLevel.
   */
  @java.lang.Override
  public com.google.maps.addressvalidation.v1.AddressComponent.ConfirmationLevel
      getConfirmationLevel() {
    com.google.maps.addressvalidation.v1.AddressComponent.ConfirmationLevel result =
        com.google.maps.addressvalidation.v1.AddressComponent.ConfirmationLevel.forNumber(
            confirmationLevel_);
    return result == null
        ? com.google.maps.addressvalidation.v1.AddressComponent.ConfirmationLevel.UNRECOGNIZED
        : result;
  }

  public static final int INFERRED_FIELD_NUMBER = 4;
  private boolean inferred_ = false;
  /**
   *
   *
   * <pre>
   * Indicates that the component was not part of the input, but we
   * inferred it for the address location and believe it should be provided
   * for a complete address.
   * </pre>
   *
   * <code>bool inferred = 4;</code>
   *
   * @return The inferred.
   */
  @java.lang.Override
  public boolean getInferred() {
    return inferred_;
  }

  public static final int SPELL_CORRECTED_FIELD_NUMBER = 5;
  private boolean spellCorrected_ = false;
  /**
   *
   *
   * <pre>
   * Indicates the spelling of the component name was corrected in a minor way,
   * for example by switching two characters that appeared in the wrong order.
   * This indicates a cosmetic change.
   * </pre>
   *
   * <code>bool spell_corrected = 5;</code>
   *
   * @return The spellCorrected.
   */
  @java.lang.Override
  public boolean getSpellCorrected() {
    return spellCorrected_;
  }

  public static final int REPLACED_FIELD_NUMBER = 6;
  private boolean replaced_ = false;
  /**
   *
   *
   * <pre>
   * Indicates the name of the component was replaced with a completely
   * different one, for example a wrong postal code being replaced with one that
   * is correct for the address. This is not a cosmetic change, the input
   * component has been changed to a different one.
   * </pre>
   *
   * <code>bool replaced = 6;</code>
   *
   * @return The replaced.
   */
  @java.lang.Override
  public boolean getReplaced() {
    return replaced_;
  }

  public static final int UNEXPECTED_FIELD_NUMBER = 7;
  private boolean unexpected_ = false;
  /**
   *
   *
   * <pre>
   * Indicates an address component that is not expected to be present in a
   * postal address for the given region. We have retained it only because it
   * was part of the input.
   * </pre>
   *
   * <code>bool unexpected = 7;</code>
   *
   * @return The unexpected.
   */
  @java.lang.Override
  public boolean getUnexpected() {
    return unexpected_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (componentName_ != null) {
      output.writeMessage(1, getComponentName());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(componentType_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, componentType_);
    }
    if (confirmationLevel_
        != com.google.maps.addressvalidation.v1.AddressComponent.ConfirmationLevel
            .CONFIRMATION_LEVEL_UNSPECIFIED
            .getNumber()) {
      output.writeEnum(3, confirmationLevel_);
    }
    if (inferred_ != false) {
      output.writeBool(4, inferred_);
    }
    if (spellCorrected_ != false) {
      output.writeBool(5, spellCorrected_);
    }
    if (replaced_ != false) {
      output.writeBool(6, replaced_);
    }
    if (unexpected_ != false) {
      output.writeBool(7, unexpected_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (componentName_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, getComponentName());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(componentType_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, componentType_);
    }
    if (confirmationLevel_
        != com.google.maps.addressvalidation.v1.AddressComponent.ConfirmationLevel
            .CONFIRMATION_LEVEL_UNSPECIFIED
            .getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(3, confirmationLevel_);
    }
    if (inferred_ != false) {
      size += com.google.protobuf.CodedOutputStream.computeBoolSize(4, inferred_);
    }
    if (spellCorrected_ != false) {
      size += com.google.protobuf.CodedOutputStream.computeBoolSize(5, spellCorrected_);
    }
    if (replaced_ != false) {
      size += com.google.protobuf.CodedOutputStream.computeBoolSize(6, replaced_);
    }
    if (unexpected_ != false) {
      size += com.google.protobuf.CodedOutputStream.computeBoolSize(7, unexpected_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.maps.addressvalidation.v1.AddressComponent)) {
      return super.equals(obj);
    }
    com.google.maps.addressvalidation.v1.AddressComponent other =
        (com.google.maps.addressvalidation.v1.AddressComponent) obj;

    if (hasComponentName() != other.hasComponentName()) return false;
    if (hasComponentName()) {
      if (!getComponentName().equals(other.getComponentName())) return false;
    }
    if (!getComponentType().equals(other.getComponentType())) return false;
    if (confirmationLevel_ != other.confirmationLevel_) return false;
    if (getInferred() != other.getInferred()) return false;
    if (getSpellCorrected() != other.getSpellCorrected()) return false;
    if (getReplaced() != other.getReplaced()) return false;
    if (getUnexpected() != other.getUnexpected()) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (hasComponentName()) {
      hash = (37 * hash) + COMPONENT_NAME_FIELD_NUMBER;
      hash = (53 * hash) + getComponentName().hashCode();
    }
    hash = (37 * hash) + COMPONENT_TYPE_FIELD_NUMBER;
    hash = (53 * hash) + getComponentType().hashCode();
    hash = (37 * hash) + CONFIRMATION_LEVEL_FIELD_NUMBER;
    hash = (53 * hash) + confirmationLevel_;
    hash = (37 * hash) + INFERRED_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getInferred());
    hash = (37 * hash) + SPELL_CORRECTED_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getSpellCorrected());
    hash = (37 * hash) + REPLACED_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getReplaced());
    hash = (37 * hash) + UNEXPECTED_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getUnexpected());
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.maps.addressvalidation.v1.AddressComponent parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.maps.addressvalidation.v1.AddressComponent parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.maps.addressvalidation.v1.AddressComponent parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.maps.addressvalidation.v1.AddressComponent parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.maps.addressvalidation.v1.AddressComponent parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.maps.addressvalidation.v1.AddressComponent parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.maps.addressvalidation.v1.AddressComponent parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.maps.addressvalidation.v1.AddressComponent parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.maps.addressvalidation.v1.AddressComponent parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.maps.addressvalidation.v1.AddressComponent parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.maps.addressvalidation.v1.AddressComponent parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.maps.addressvalidation.v1.AddressComponent parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.maps.addressvalidation.v1.AddressComponent prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Represents an address component, such as a street, city, or state.
   * </pre>
   *
   * Protobuf type {@code google.maps.addressvalidation.v1.AddressComponent}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.maps.addressvalidation.v1.AddressComponent)
      com.google.maps.addressvalidation.v1.AddressComponentOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.maps.addressvalidation.v1.AddressProto
          .internal_static_google_maps_addressvalidation_v1_AddressComponent_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.maps.addressvalidation.v1.AddressProto
          .internal_static_google_maps_addressvalidation_v1_AddressComponent_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.maps.addressvalidation.v1.AddressComponent.class,
              com.google.maps.addressvalidation.v1.AddressComponent.Builder.class);
    }

    // Construct using com.google.maps.addressvalidation.v1.AddressComponent.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      componentName_ = null;
      if (componentNameBuilder_ != null) {
        componentNameBuilder_.dispose();
        componentNameBuilder_ = null;
      }
      componentType_ = "";
      confirmationLevel_ = 0;
      inferred_ = false;
      spellCorrected_ = false;
      replaced_ = false;
      unexpected_ = false;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.maps.addressvalidation.v1.AddressProto
          .internal_static_google_maps_addressvalidation_v1_AddressComponent_descriptor;
    }

    @java.lang.Override
    public com.google.maps.addressvalidation.v1.AddressComponent getDefaultInstanceForType() {
      return com.google.maps.addressvalidation.v1.AddressComponent.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.maps.addressvalidation.v1.AddressComponent build() {
      com.google.maps.addressvalidation.v1.AddressComponent result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.maps.addressvalidation.v1.AddressComponent buildPartial() {
      com.google.maps.addressvalidation.v1.AddressComponent result =
          new com.google.maps.addressvalidation.v1.AddressComponent(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.maps.addressvalidation.v1.AddressComponent result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.componentName_ =
            componentNameBuilder_ == null ? componentName_ : componentNameBuilder_.build();
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.componentType_ = componentType_;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.confirmationLevel_ = confirmationLevel_;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.inferred_ = inferred_;
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.spellCorrected_ = spellCorrected_;
      }
      if (((from_bitField0_ & 0x00000020) != 0)) {
        result.replaced_ = replaced_;
      }
      if (((from_bitField0_ & 0x00000040) != 0)) {
        result.unexpected_ = unexpected_;
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.maps.addressvalidation.v1.AddressComponent) {
        return mergeFrom((com.google.maps.addressvalidation.v1.AddressComponent) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.maps.addressvalidation.v1.AddressComponent other) {
      if (other == com.google.maps.addressvalidation.v1.AddressComponent.getDefaultInstance())
        return this;
      if (other.hasComponentName()) {
        mergeComponentName(other.getComponentName());
      }
      if (!other.getComponentType().isEmpty()) {
        componentType_ = other.componentType_;
        bitField0_ |= 0x00000002;
        onChanged();
      }
      if (other.confirmationLevel_ != 0) {
        setConfirmationLevelValue(other.getConfirmationLevelValue());
      }
      if (other.getInferred() != false) {
        setInferred(other.getInferred());
      }
      if (other.getSpellCorrected() != false) {
        setSpellCorrected(other.getSpellCorrected());
      }
      if (other.getReplaced() != false) {
        setReplaced(other.getReplaced());
      }
      if (other.getUnexpected() != false) {
        setUnexpected(other.getUnexpected());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                input.readMessage(getComponentNameFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                componentType_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            case 24:
              {
                confirmationLevel_ = input.readEnum();
                bitField0_ |= 0x00000004;
                break;
              } // case 24
            case 32:
              {
                inferred_ = input.readBool();
                bitField0_ |= 0x00000008;
                break;
              } // case 32
            case 40:
              {
                spellCorrected_ = input.readBool();
                bitField0_ |= 0x00000010;
                break;
              } // case 40
            case 48:
              {
                replaced_ = input.readBool();
                bitField0_ |= 0x00000020;
                break;
              } // case 48
            case 56:
              {
                unexpected_ = input.readBool();
                bitField0_ |= 0x00000040;
                break;
              } // case 56
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private com.google.maps.addressvalidation.v1.ComponentName componentName_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.maps.addressvalidation.v1.ComponentName,
            com.google.maps.addressvalidation.v1.ComponentName.Builder,
            com.google.maps.addressvalidation.v1.ComponentNameOrBuilder>
        componentNameBuilder_;
    /**
     *
     *
     * <pre>
     * The name for this component.
     * </pre>
     *
     * <code>.google.maps.addressvalidation.v1.ComponentName component_name = 1;</code>
     *
     * @return Whether the componentName field is set.
     */
    public boolean hasComponentName() {
      return ((bitField0_ & 0x00000001) != 0);
    }
    /**
     *
     *
     * <pre>
     * The name for this component.
     * </pre>
     *
     * <code>.google.maps.addressvalidation.v1.ComponentName component_name = 1;</code>
     *
     * @return The componentName.
     */
    public com.google.maps.addressvalidation.v1.ComponentName getComponentName() {
      if (componentNameBuilder_ == null) {
        return componentName_ == null
            ? com.google.maps.addressvalidation.v1.ComponentName.getDefaultInstance()
            : componentName_;
      } else {
        return componentNameBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * The name for this component.
     * </pre>
     *
     * <code>.google.maps.addressvalidation.v1.ComponentName component_name = 1;</code>
     */
    public Builder setComponentName(com.google.maps.addressvalidation.v1.ComponentName value) {
      if (componentNameBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        componentName_ = value;
      } else {
        componentNameBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The name for this component.
     * </pre>
     *
     * <code>.google.maps.addressvalidation.v1.ComponentName component_name = 1;</code>
     */
    public Builder setComponentName(
        com.google.maps.addressvalidation.v1.ComponentName.Builder builderForValue) {
      if (componentNameBuilder_ == null) {
        componentName_ = builderForValue.build();
      } else {
        componentNameBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The name for this component.
     * </pre>
     *
     * <code>.google.maps.addressvalidation.v1.ComponentName component_name = 1;</code>
     */
    public Builder mergeComponentName(com.google.maps.addressvalidation.v1.ComponentName value) {
      if (componentNameBuilder_ == null) {
        if (((bitField0_ & 0x00000001) != 0)
            && componentName_ != null
            && componentName_
                != com.google.maps.addressvalidation.v1.ComponentName.getDefaultInstance()) {
          getComponentNameBuilder().mergeFrom(value);
        } else {
          componentName_ = value;
        }
      } else {
        componentNameBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The name for this component.
     * </pre>
     *
     * <code>.google.maps.addressvalidation.v1.ComponentName component_name = 1;</code>
     */
    public Builder clearComponentName() {
      bitField0_ = (bitField0_ & ~0x00000001);
      componentName_ = null;
      if (componentNameBuilder_ != null) {
        componentNameBuilder_.dispose();
        componentNameBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The name for this component.
     * </pre>
     *
     * <code>.google.maps.addressvalidation.v1.ComponentName component_name = 1;</code>
     */
    public com.google.maps.addressvalidation.v1.ComponentName.Builder getComponentNameBuilder() {
      bitField0_ |= 0x00000001;
      onChanged();
      return getComponentNameFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The name for this component.
     * </pre>
     *
     * <code>.google.maps.addressvalidation.v1.ComponentName component_name = 1;</code>
     */
    public com.google.maps.addressvalidation.v1.ComponentNameOrBuilder getComponentNameOrBuilder() {
      if (componentNameBuilder_ != null) {
        return componentNameBuilder_.getMessageOrBuilder();
      } else {
        return componentName_ == null
            ? com.google.maps.addressvalidation.v1.ComponentName.getDefaultInstance()
            : componentName_;
      }
    }
    /**
     *
     *
     * <pre>
     * The name for this component.
     * </pre>
     *
     * <code>.google.maps.addressvalidation.v1.ComponentName component_name = 1;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.maps.addressvalidation.v1.ComponentName,
            com.google.maps.addressvalidation.v1.ComponentName.Builder,
            com.google.maps.addressvalidation.v1.ComponentNameOrBuilder>
        getComponentNameFieldBuilder() {
      if (componentNameBuilder_ == null) {
        componentNameBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.maps.addressvalidation.v1.ComponentName,
                com.google.maps.addressvalidation.v1.ComponentName.Builder,
                com.google.maps.addressvalidation.v1.ComponentNameOrBuilder>(
                getComponentName(), getParentForChildren(), isClean());
        componentName_ = null;
      }
      return componentNameBuilder_;
    }

    private java.lang.Object componentType_ = "";
    /**
     *
     *
     * <pre>
     * The type of the address component. See
     * [Table 2: Additional types returned by the Places
     * service](https://developers.google.com/places/web-service/supported_types#table2)
     * for a list of possible types.
     * </pre>
     *
     * <code>string component_type = 2;</code>
     *
     * @return The componentType.
     */
    public java.lang.String getComponentType() {
      java.lang.Object ref = componentType_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        componentType_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The type of the address component. See
     * [Table 2: Additional types returned by the Places
     * service](https://developers.google.com/places/web-service/supported_types#table2)
     * for a list of possible types.
     * </pre>
     *
     * <code>string component_type = 2;</code>
     *
     * @return The bytes for componentType.
     */
    public com.google.protobuf.ByteString getComponentTypeBytes() {
      java.lang.Object ref = componentType_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        componentType_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The type of the address component. See
     * [Table 2: Additional types returned by the Places
     * service](https://developers.google.com/places/web-service/supported_types#table2)
     * for a list of possible types.
     * </pre>
     *
     * <code>string component_type = 2;</code>
     *
     * @param value The componentType to set.
     * @return This builder for chaining.
     */
    public Builder setComponentType(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      componentType_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The type of the address component. See
     * [Table 2: Additional types returned by the Places
     * service](https://developers.google.com/places/web-service/supported_types#table2)
     * for a list of possible types.
     * </pre>
     *
     * <code>string component_type = 2;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearComponentType() {
      componentType_ = getDefaultInstance().getComponentType();
      bitField0_ = (bitField0_ & ~0x00000002);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The type of the address component. See
     * [Table 2: Additional types returned by the Places
     * service](https://developers.google.com/places/web-service/supported_types#table2)
     * for a list of possible types.
     * </pre>
     *
     * <code>string component_type = 2;</code>
     *
     * @param value The bytes for componentType to set.
     * @return This builder for chaining.
     */
    public Builder setComponentTypeBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      componentType_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    private int confirmationLevel_ = 0;
    /**
     *
     *
     * <pre>
     * Indicates the level of certainty that we have that the component
     * is correct.
     * </pre>
     *
     * <code>
     * .google.maps.addressvalidation.v1.AddressComponent.ConfirmationLevel confirmation_level = 3;
     * </code>
     *
     * @return The enum numeric value on the wire for confirmationLevel.
     */
    @java.lang.Override
    public int getConfirmationLevelValue() {
      return confirmationLevel_;
    }
    /**
     *
     *
     * <pre>
     * Indicates the level of certainty that we have that the component
     * is correct.
     * </pre>
     *
     * <code>
     * .google.maps.addressvalidation.v1.AddressComponent.ConfirmationLevel confirmation_level = 3;
     * </code>
     *
     * @param value The enum numeric value on the wire for confirmationLevel to set.
     * @return This builder for chaining.
     */
    public Builder setConfirmationLevelValue(int value) {
      confirmationLevel_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Indicates the level of certainty that we have that the component
     * is correct.
     * </pre>
     *
     * <code>
     * .google.maps.addressvalidation.v1.AddressComponent.ConfirmationLevel confirmation_level = 3;
     * </code>
     *
     * @return The confirmationLevel.
     */
    @java.lang.Override
    public com.google.maps.addressvalidation.v1.AddressComponent.ConfirmationLevel
        getConfirmationLevel() {
      com.google.maps.addressvalidation.v1.AddressComponent.ConfirmationLevel result =
          com.google.maps.addressvalidation.v1.AddressComponent.ConfirmationLevel.forNumber(
              confirmationLevel_);
      return result == null
          ? com.google.maps.addressvalidation.v1.AddressComponent.ConfirmationLevel.UNRECOGNIZED
          : result;
    }
    /**
     *
     *
     * <pre>
     * Indicates the level of certainty that we have that the component
     * is correct.
     * </pre>
     *
     * <code>
     * .google.maps.addressvalidation.v1.AddressComponent.ConfirmationLevel confirmation_level = 3;
     * </code>
     *
     * @param value The confirmationLevel to set.
     * @return This builder for chaining.
     */
    public Builder setConfirmationLevel(
        com.google.maps.addressvalidation.v1.AddressComponent.ConfirmationLevel value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000004;
      confirmationLevel_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Indicates the level of certainty that we have that the component
     * is correct.
     * </pre>
     *
     * <code>
     * .google.maps.addressvalidation.v1.AddressComponent.ConfirmationLevel confirmation_level = 3;
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearConfirmationLevel() {
      bitField0_ = (bitField0_ & ~0x00000004);
      confirmationLevel_ = 0;
      onChanged();
      return this;
    }

    private boolean inferred_;
    /**
     *
     *
     * <pre>
     * Indicates that the component was not part of the input, but we
     * inferred it for the address location and believe it should be provided
     * for a complete address.
     * </pre>
     *
     * <code>bool inferred = 4;</code>
     *
     * @return The inferred.
     */
    @java.lang.Override
    public boolean getInferred() {
      return inferred_;
    }
    /**
     *
     *
     * <pre>
     * Indicates that the component was not part of the input, but we
     * inferred it for the address location and believe it should be provided
     * for a complete address.
     * </pre>
     *
     * <code>bool inferred = 4;</code>
     *
     * @param value The inferred to set.
     * @return This builder for chaining.
     */
    public Builder setInferred(boolean value) {

      inferred_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Indicates that the component was not part of the input, but we
     * inferred it for the address location and believe it should be provided
     * for a complete address.
     * </pre>
     *
     * <code>bool inferred = 4;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearInferred() {
      bitField0_ = (bitField0_ & ~0x00000008);
      inferred_ = false;
      onChanged();
      return this;
    }

    private boolean spellCorrected_;
    /**
     *
     *
     * <pre>
     * Indicates the spelling of the component name was corrected in a minor way,
     * for example by switching two characters that appeared in the wrong order.
     * This indicates a cosmetic change.
     * </pre>
     *
     * <code>bool spell_corrected = 5;</code>
     *
     * @return The spellCorrected.
     */
    @java.lang.Override
    public boolean getSpellCorrected() {
      return spellCorrected_;
    }
    /**
     *
     *
     * <pre>
     * Indicates the spelling of the component name was corrected in a minor way,
     * for example by switching two characters that appeared in the wrong order.
     * This indicates a cosmetic change.
     * </pre>
     *
     * <code>bool spell_corrected = 5;</code>
     *
     * @param value The spellCorrected to set.
     * @return This builder for chaining.
     */
    public Builder setSpellCorrected(boolean value) {

      spellCorrected_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Indicates the spelling of the component name was corrected in a minor way,
     * for example by switching two characters that appeared in the wrong order.
     * This indicates a cosmetic change.
     * </pre>
     *
     * <code>bool spell_corrected = 5;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearSpellCorrected() {
      bitField0_ = (bitField0_ & ~0x00000010);
      spellCorrected_ = false;
      onChanged();
      return this;
    }

    private boolean replaced_;
    /**
     *
     *
     * <pre>
     * Indicates the name of the component was replaced with a completely
     * different one, for example a wrong postal code being replaced with one that
     * is correct for the address. This is not a cosmetic change, the input
     * component has been changed to a different one.
     * </pre>
     *
     * <code>bool replaced = 6;</code>
     *
     * @return The replaced.
     */
    @java.lang.Override
    public boolean getReplaced() {
      return replaced_;
    }
    /**
     *
     *
     * <pre>
     * Indicates the name of the component was replaced with a completely
     * different one, for example a wrong postal code being replaced with one that
     * is correct for the address. This is not a cosmetic change, the input
     * component has been changed to a different one.
     * </pre>
     *
     * <code>bool replaced = 6;</code>
     *
     * @param value The replaced to set.
     * @return This builder for chaining.
     */
    public Builder setReplaced(boolean value) {

      replaced_ = value;
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Indicates the name of the component was replaced with a completely
     * different one, for example a wrong postal code being replaced with one that
     * is correct for the address. This is not a cosmetic change, the input
     * component has been changed to a different one.
     * </pre>
     *
     * <code>bool replaced = 6;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearReplaced() {
      bitField0_ = (bitField0_ & ~0x00000020);
      replaced_ = false;
      onChanged();
      return this;
    }

    private boolean unexpected_;
    /**
     *
     *
     * <pre>
     * Indicates an address component that is not expected to be present in a
     * postal address for the given region. We have retained it only because it
     * was part of the input.
     * </pre>
     *
     * <code>bool unexpected = 7;</code>
     *
     * @return The unexpected.
     */
    @java.lang.Override
    public boolean getUnexpected() {
      return unexpected_;
    }
    /**
     *
     *
     * <pre>
     * Indicates an address component that is not expected to be present in a
     * postal address for the given region. We have retained it only because it
     * was part of the input.
     * </pre>
     *
     * <code>bool unexpected = 7;</code>
     *
     * @param value The unexpected to set.
     * @return This builder for chaining.
     */
    public Builder setUnexpected(boolean value) {

      unexpected_ = value;
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Indicates an address component that is not expected to be present in a
     * postal address for the given region. We have retained it only because it
     * was part of the input.
     * </pre>
     *
     * <code>bool unexpected = 7;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearUnexpected() {
      bitField0_ = (bitField0_ & ~0x00000040);
      unexpected_ = false;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.maps.addressvalidation.v1.AddressComponent)
  }

  // @@protoc_insertion_point(class_scope:google.maps.addressvalidation.v1.AddressComponent)
  private static final com.google.maps.addressvalidation.v1.AddressComponent DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.maps.addressvalidation.v1.AddressComponent();
  }

  public static com.google.maps.addressvalidation.v1.AddressComponent getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<AddressComponent> PARSER =
      new com.google.protobuf.AbstractParser<AddressComponent>() {
        @java.lang.Override
        public AddressComponent parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<AddressComponent> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<AddressComponent> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.maps.addressvalidation.v1.AddressComponent getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
